<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

use GlpiPlugin\dlteams\Exception\ImportFailureException;

//const protectioncatalog = [
//    0 => 'Aucune clé ou compte nécessaire',
//    1 => 'Par compte, code, certificat',
//    2 => 'Par clé physique',
//    3 => 'Par clé physique + compte, code, certificat'
//];
class PluginDlteamsDataCatalog extends CommonTreeDropdown implements
    PluginDlteamsExportableInterface
{
    use PluginDlteamsExportable;

    /**
     * @var PluginReportsColumn[]
     */
    public $dohistory = true;
    protected $usenotepad = true;
    public static $menukey = "dataaccessdatacatalog";

    // Constantes publiques
    public const ACCESS_NONE = 0;
    public const ACCESS_ACCOUNT = 1;
    public const ACCESS_KEY = 2;
    public const ACCESS_KEY_AND_ACCOUNT = 3;

    // Tableau de correspondance
    public static array $protectionCatalog = [
        self::ACCESS_NONE => 'Aucune clé ou compte nécessaire',
        self::ACCESS_ACCOUNT => 'Par compte, code, certificat',
        self::ACCESS_KEY => 'Par clé physique',
        self::ACCESS_KEY_AND_ACCOUNT => 'Par clé physique + compte, code, certificat'
    ];

    public const reports = [
        'report/datacatalog/rootdatacataloglist.php' => 'Liste des catalogues (racine)',
        'report/datacatalog/datacataloglist.php' => 'Liste des catalogues (Tous)',
        'report/datacatalog/datacatalogusers.php' => 'Liste des catalogues avec utilisateurs',
        'report/datacatalog/usercatalogaccess.php' => 'Revue des accès par utilisateur',
    ];

    // From CommonDBTM
    public $auto_message_on_action = true;
    public static $rightname = 'plugin_dlteams_datacatalog';
    public static $mustBeAttached = false;

    // From CommonDBChild
    public static $itemtype = 'PluginDlteamsDataCatalog';
    public static $items_id = 'plugin_dlteams_datacatalogs_id';

    public static function getTypeName($nb = 0)
    {
        return _n('Data catalog', 'Data catalogs', $nb, 'dlteams');
    }

//    public static function getAnnuairescatalogues()
//    {
//        global $DB;
//
//        $query = [
//            "FROM" => PluginDlteamsDataCatalog::getTable(),
//            "WHERE" => [
//                "manage_accountkey" => true,
//                "entities_id" => $_SESSION['glpiactive_entity']
//            ]
//        ];
//        $iterator = $DB->request($query);
//        $result = [];
//        foreach ($iterator as $row) {
//            $result[] = $row;
//        }
//
//        return $result;
//    }


    private static function getMeansOfAccesRequest(PluginDlteamsDataCatalog $item)
    {
        global $DB;

        $request = [
            'SELECT' => [
                PluginDlteamsDataCatalog_Item::getTable() . '.id AS linkid',
                PluginDlteamsDataCatalog_Item::getTable() . '.itemtype AS itemtype',
                PluginDlteamsDataCatalog_Item::getTable() . '.items_id AS items_id',
                PluginDlteamsDataCatalog_Item::getTable() . '.meansofacces_mandatory AS meansofacces_mandatory',
                PluginDlteamsDataCatalog_Item::getTable() . '.comment AS comment',
            ],
            'FROM' => PluginDlteamsDataCatalog_Item::getTable(),
            'WHERE' => [
                'itemtype' => PluginDlteamsMeansOfAcce::class,
                PluginDlteamsDataCatalog_Item::getTable() . '.datacatalogs_id' => $item->fields["id"]
            ]
        ];
        return $DB->request($request);
    }

    public static function additionalShowRelatedParentFields(PluginDlteamsDataCatalog $currentcatalog, ?PluginDlteamsDataCatalog $parentcatalog = null, $options = [])
    {
        $rand = mt_rand();
        echo "<tr> <td class='form-table-text'>" . __("Type de catalogue", 'dlteams') . "</td>";
        echo "<td>";
        $datacarriercategories_id = 0;
        $groups_id = 0;
        $users_id = 0;
        $suppliers_id = 0;
        $contacts_id = 0;
        if (!$parentcatalog && !isset($options["parentcatalog"])) {
            $datacarriercategories_id = $currentcatalog->fields['plugin_dlteams_datacarriercategories_id'];
            $groups_id = $currentcatalog->fields['groups_id_contact'];
            $users_id = $currentcatalog->fields['users_id_contact'];
            $suppliers_id = $currentcatalog->fields['suppliers_id_contact'];
            $contacts_id = $currentcatalog->fields['contacts_id_contact'];
        }
        if ($parentcatalog && isset($options["parentcatalog"]) && $options["parentcatalog"] > 0) {
            $datacarriercategories_id = $parentcatalog->fields['plugin_dlteams_datacarriercategories_id'];
            $groups_id = $parentcatalog->fields['groups_id_contact'];
            $users_id = $parentcatalog->fields['users_id_contact'];
            $suppliers_id = $parentcatalog->fields['suppliers_id_contact'];
            $contacts_id = $parentcatalog->fields['contacts_id_contact'];
        }

        // echo "<div style='display: flex; gap: 5px; align-items: center'>";
        PluginDlteamsDataCarrierCategory::dropdown([
            'addicon' => PluginDlteamsDataCarrierCategory::canCreate(),
            'name' => 'plugin_dlteams_datacarriercategories_id',
            'width' => '300px',
            'value' => $datacarriercategories_id,
        ]);
        echo "</div>";
        echo "</td></tr>";

        echo "</div>";
        echo "</div>";
        echo "</td><td width='20%' class='left'>";
        echo "</td></tr>";
        echo "<style>
            .comment-td {width: 40%;}
            @media (max-width: 767px) {.comment-td {width: 100%;}}
           </style>";
        echo "<tr class='tab_bg_1' style='display: none' id='field_submit'><td class='right' width='40%'>";
        echo "</td><td width='40%' class='left'>";

        echo "<div style='display: flex; gap: 4px;'>";
        echo "<input for='datacatalogitem_form$rand' type='submit' name='add' value=\"" . _sx('button', 'Add') . "\" class='submit'>";
        echo "</div>";
        echo "</td><td width='20%' class='left'>";
        echo "</td></tr>";

        echo "<tr> <td class='form-table-text'>" . __("Information classification", 'dlteams') . "</td>";
        echo "<td>";
        PluginDlteamsCatalogClassification::dropdown([
            'addicon' => PluginDlteamsCatalogClassification::canCreate(),
            'name' => 'plugin_dlteams_catalogclassifications_id',
            'width' => '300px',
            'value' => $currentcatalog->fields['plugin_dlteams_catalogclassifications_id'],
        ]);
        echo "</td></tr>";


//       s'affiche ce catalogue, ses enfants et ses parents ont tous "ce catalogue gère des comptes ou des clés" = false
//        if(!$currentcatalog->fields["manage_accountkey"] && $currentcatalog->fields["plugin_dlteams_datacatalogs_id"] != 0) {
//            echo "<tr> <td class='form-table-text'></td>";
//            echo "<td>";
//            Html::showCheckbox([
//                'name' => 'manage_accountkey',
//                'checked' => $currentcatalog->fields["manage_accountkey"],
//            ]);
//            echo "<label>&nbsp;Ce catalogue gère des comptes ou des clés</label>";
//            echo "</td></tr>";
//        }

        if (isset($options["currentcatalog_canmanage"]) && $options["currentcatalog_canmanage"]) {

            echo "<tr class='tab_bg_2'><th colspan='2' style='text-align:left!important'>" . __("Caractéristiques de l'annuaire", 'dlteams') . "</th></tr>";

            // echo "<span style='color: red'>Caractéristiques de l'annuaire</span>";
            // si type de comptes = 4 - clés physiques alors -> echo "<span style='color: red'>Ce catalogue gère des clés</span>";
            // si type de comptes = 4 - clés physiques alors -> echo "<span style='color: red'>Ce catalogue gère  clés</span>";
            // echo "</td>";

            echo "<tr id='directory_name_field2'> <td class='form-table-text'>" . __("Type de clé", 'dlteams') . "</td>";
            echo "<td>";
            PluginDlteamsKeyType::dropdown([
                'addicon' => PluginDlteamsKeyType::canCreate(),
                'name' => 'default_keytype',
                'width' => '300px',
                'value' => $currentcatalog->fields['default_keytype'],
            ]);
            echo "</td></tr>";

            echo "<tr id='directory_name_field'>";
            echo "<td class='form-table-text'>";
            echo "<label style='white-space: nowrap'>Désignation </label>";
            echo "</td>";
            echo "<td>" . "<input type='text' style='width:90%' style='text-align:left; display:none;' name='directory_name' value='" . Html::cleanInputText($currentcatalog->fields['directory_name']) . "'>" . "</td>";
            echo "</tr>";


            echo "<tr id='directory_name_field2'> <td class='form-table-text'>";
            echo "<a href='https://dlteams.app/front/helpdesk.faq.php?id=201' target='_blank' style=' flex-direction: row; align-items: center; width: fit-content'>";
            echo __("Format par défaut", 'dlteams');
            echo "<i class='fa fa-info-circle'></i>";
            echo "</a>";
            echo "</td>";
            echo "<td>";
            echo "<input type='text' style='width:90%' style='text-align:left;' name='default_format' value='" . Html::cleanInputText($currentcatalog->fields['default_format']) . "'>";
            echo "</td></tr>";
        }

//        if (!$currentcatalog->fields['plugin_dlteams_datacatalogs_id']) {
        echo "<tr><td class='form-table-text'>" . "Moyen d'accès" . "</td>";
        echo "<td>";

        if ($currentcatalog->fields["plugin_dlteams_datacatalogs_id"] == 0)
            Dropdown::showFromArray(
                'keyrequired', // => $this->fields['motor_type'],
                PluginDlteamsDataCatalog::$protectionCatalog,
                [
                    'value' => $currentcatalog->fields['keyrequired'],
                    'multiple' => false,
                    'width' => '100%',
                ]
            );
        elseif (isset($currentcatalog->fields['keyrequired']) && $currentcatalog->fields['keyrequired']) {

//                    var_dump($currentcatalog->fields['keyrequired']);
            $text = PluginDlteamsDataCatalog::$protectionCatalog[$currentcatalog->fields['keyrequired']];
            echo "<span style='color: #0a6aa1'>$text</span>";
        }


        echo "</td>";
        echo "<script>
				$(document).ready(function(e){
				    
				let is_directory = true;
					if(is_directory){
							$('#directory_name_field').css('display', 'contents');
							$('#directory_name_field2').css('display', 'table-row');
						}
						else{
							$('#directory_name_field').css('display', 'none');
							$('#directory_name_field2').css('display', 'none');
						}
                        
					$('input[name=is_directoryservice]').change(function() {
							if(this.checked){
							$('#directory_name_field').css('display', 'contents');
							$('#directory_name_field2').css('display', 'table-row');
							}
						else{
                          $('#directory_name_field').css('display', 'none');
                          $('#directory_name_field2').css('display', 'none');
						}
                    });
				});
				</script>";
        echo "</tr>";
//            }

        /* echo "<tr class='tab_bg_2'><th colspan='4'> <i class='fa fa-information' style='font-weight: normal'></i>" . __("Responsable de la gestion administrative", 'dlteams')  . "</th>" . "</tr>";
        echo "<tr class='tab_bg_4'>";
        echo "<td class='form-table-text'>" . __("Personne", 'dlteams') . "</td>";
        echo "<td>";
        User::dropdown([
            'addicon' => User::canCreate(),
            'name' => 'users_id_contact',
            'width' => '250px',
            'value' => $users_id,
            'entity' => $currentcatalog->fields["entities_id"],
            'right' => 'all',
        ]);
        echo "</td>";

        echo "<td class='form-table-text'>" . __("Groupe", 'dlteams') . "</td>";
        echo "<td>";
        Group::dropdown([
            'addicon' => Group::canCreate(),
            'name' => 'groups_id_contact',
            'width' => '300px',
            'value' => $groups_id,
        ]);
        echo "</td></tr>";

        echo "<tr>";
        echo "<td class='form-table-text'>" . __("Tiers ", 'dlteams') . "</td>";
        echo "<td>";
        Supplier::dropdown([
            'addicon' => Supplier::canCreate(),
            'name' => 'suppliers_id_contact',
            'width' => '300px',
            'value' => $suppliers_id,
        ]);
        echo "</td>";
        echo "<td class='form-table-text'>" . __("Employé d'un tiers", 'dlteams') . "</td>";
        echo "<td>";
        Contact::dropdown([
            'addicon' => Contact::canCreate(),
            'name' => 'contact_id_contact',
            'width' => '300px',
            'value' => $contacts_id,
        ]);
        echo "</td></tr>";
		
		// la dropdown n'apparait que pour un catalogue racine, sinon on fait printf comme "Protection de l'accès à ce catalogue"
		echo "<tr class='tab_bg_2'><th colspan='4'> <i class='fa fa-information' style='font-weight: normal'></i>" . __("Gestionnaire technique", 'dlteams')  . "</th>" . "</tr>";

        // echo "</table>";
		*/
    }

    public function canManageAccountKey()
    {
        $isNewID = ((isset($options['withtemplate']) && ($options['withtemplate'] == 2))
            || $this->isNewID($this->getID()));

        if ($isNewID)
            return false;

        $id = $this->fields["id"];
        $query = "SELECT t1.*
FROM glpi_plugin_dlteams_datacatalogs AS t1
JOIN glpi_plugin_dlteams_datacatalogs AS t2
ON (
    (LOCATE('>', t2.`completename`) > 0 AND LEFT(t2.`completename`, LOCATE('>', t2.`completename`) - 1) = LEFT(t1.`completename`, LOCATE('>', t1.`completename`) - 1) 
    OR 
     (LOCATE('>', t2.`completename`) > 0 AND LEFT(t2.`completename`, LOCATE('>', t2.`completename`) - 1) = t1.`completename`)) 
    OR 
    (LOCATE('>', t2.`completename`) = 0 AND t2.`completename` = t1.`completename`)
    OR 
    (LOCATE('>', t2.`completename`) = 0 AND t2.`completename` = LEFT(t1.`completename`, LOCATE('>', t1.`completename`) - 1))
)
WHERE t2.id = $id AND t1.`manage_accountkey` = 1;";

        global $DB;
        $result = [];
        $req = $DB->request($query);

        if (count($req)) { // oui existe -> on quitte
            foreach ($req as $idtemp => $row) {
                $result[] = $row["id"];
            }
        }

        return in_array($this->fields["id"], $result);
    }

    public function existOneThatCanManage()
    {
        $isNewID = ((isset($options['withtemplate']) && ($options['withtemplate'] == 2))
            || $this->isNewID($this->getID()));
        if ($isNewID)
            return [];

        $id = $this->fields["id"];
        $query = "SELECT t1.*
            FROM glpi_plugin_dlteams_datacatalogs AS t1
            JOIN glpi_plugin_dlteams_datacatalogs AS t2
            ON (
                (LOCATE('>', t2.`completename`) > 0 AND LEFT(t2.`completename`, LOCATE('>', t2.`completename`) - 1) = LEFT(t1.`completename`, LOCATE('>', t1.`completename`) - 1) 
                OR 
                 (LOCATE('>', t2.`completename`) > 0 AND LEFT(t2.`completename`, LOCATE('>', t2.`completename`) - 1) = t1.`completename`)) 
                OR 
                (LOCATE('>', t2.`completename`) = 0 AND t2.`completename` = t1.`completename`)
                OR 
                (LOCATE('>', t2.`completename`) = 0 AND t2.`completename` = LEFT(t1.`completename`, LOCATE('>', t1.`completename`) - 1))
            )
            WHERE t2.id = $id AND t1.`manage_accountkey` = 1;";

        global $DB;
        $result = [];
        $req = $DB->request($query);

        if (count($req)) { // oui existe -> on quitte
            foreach ($req as $idtemp => $row) {
                $result[] = $row["id"];
            }
        }

        return $result;
    }

    public function getAccountKeyManager()
    {
        $isNewID = ((isset($options['withtemplate']) && ($options['withtemplate'] == 2))
            || $this->isNewID($this->getID()));
        if ($isNewID)
            return [];
        $id = $this->fields["id"];
        $query = "SELECT t1.*
FROM glpi_plugin_dlteams_datacatalogs AS t1
JOIN glpi_plugin_dlteams_datacatalogs AS t2
ON (
    (LOCATE('>', t2.`completename`) > 0 AND LEFT(t2.`completename`, LOCATE('>', t2.`completename`) - 1) = LEFT(t1.`completename`, LOCATE('>', t1.`completename`) - 1) 
    OR 
     (LOCATE('>', t2.`completename`) > 0 AND LEFT(t2.`completename`, LOCATE('>', t2.`completename`) - 1) = t1.`completename`)) 
    OR 
    (LOCATE('>', t2.`completename`) = 0 AND t2.`completename` = t1.`completename`)
    OR 
    (LOCATE('>', t2.`completename`) = 0 AND t2.`completename` = LEFT(t1.`completename`, LOCATE('>', t1.`completename`) - 1))
)
WHERE t2.id = $id AND t1.`manage_accountkey` = 1;";

        global $DB;
        $result = [];
        $req = $DB->request($query);

        if (count($req)) { // oui existe -> on quitte
            foreach ($req as $idtemp => $row) {
                $result[] = $row["id"];
            }
        }

        return $result;
    }

    function showForm($id, $options = [])
    {
        $currentcatalog_canmanage = $this->canManageAccountKey();


        echo "<div id='content_form'>";
        $this->initForm($id, $options);
        $this->showFormHeader($options);
        echo "<tr>";
        echo "<td class='form-table-text'>" . __("Name", 'dlteams') . "</td>";

        echo "<td colspan='2'>";
        $input = Html::cleanInputText($this->fields['name']);
        echo "<input type='text' style='width:75%' maxlength=250 name='name' required value='" . $input . "'>";
        echo "</td></tr>";

        if ($options && isset($options["parentcatalog"])) {
            $parentcatalog = new PluginDlteamsDataCatalog();
            $parentcatalog->getFromDB($options["parentcatalog"]);
        }

        echo "<tr> <td class='form-table-text'>" . __("Est un sous-catalogue de ", 'dlteams') . "</td>";
        echo "<td>";
        $parentcatalog_value = 0;
        if (isset($parentcatalog) && $options["parentcatalog"] != 0)
            $parentcatalog_value = $parentcatalog->fields["id"];
        else if (isset($options["parentcatalog"]) && $options["parentcatalog"] == 0)
            $parentcatalog_value = 0;
        else if ($this->fields['plugin_dlteams_datacatalogs_id'] && !isset($options["parentcatalog"]) != 0)
            $parentcatalog_value = $this->fields['plugin_dlteams_datacatalogs_id'];


        if ($parentcatalog_value == $id)
            $parentcatalog_value = 0;
//        var_dump($this->fields['plugin_dlteams_datacatalogs_id'] && !isset($options["parentcatalog"]) != 0);
//        die();
        self::dropdown([
            'addicon' => self::canCreate(),
            'name' => 'plugin_dlteams_datacatalogs_id',
            'width' => '300px',
            'entity_sons' => true,
            'value' => $parentcatalog_value,
        ]);
        echo "</td></tr>";

        echo "<tr> <td class='form-table-text'>" . __("Description des données visibles, url, chemin d'accès, ...", 'dlteams') . "</td>";
        echo "<td colspan='2'>" . "<textarea class='form-control' style='width:75%' rows='3' name='content' >" . Html::cleanInputText($this->fields['content']) . "</textarea>" . "</td>";
        echo "</td></tr>";

        /*echo "<tr>";
        echo "<td class='form-table-text'>". __("Chemin d'accès, URL", 'dlteams')."</td>";
        echo "<td>";
            Html::autocompletionTextField($this, "url");
        echo "&nbsp;<a target='_blank' href='" . $this->fields["url"] . "'><i class=\"fas fa-link\"></i></a>";
        echo "</td></tr>";*/

        $options["currentcatalog_canmanage"] = $currentcatalog_canmanage;
        static::additionalShowRelatedParentFields($this, isset($parentcatalog) ? $parentcatalog : null, $options);

        $id = isset($this->fields['id']) ? (int)$this->fields['id'] : 0;

//        echo "<script>
//    $(function() {
//        $('select[name=plugin_dlteams_datacatalogs_id]').change(function(e){
//            $.ajax({
//                url: '/marketplace/dlteams/ajax/parent_catalog_update_fields.php',
//                type: 'POST',
//                data: {
//                    id: $(this).val(),
//                    currentcatalog: " . $id . "
//                },
//                success: function (data) {
//                    $('#content_form').html(data);
//                }
//            }); 
//        });
//    });
//</script>";

        $isNewID = ((isset($options['withtemplate']) && ($options['withtemplate'] == 2))
            || $this->isNewID($this->getID()));


        if ($isNewID) {
            $this->showFormButtons($options);
            return true;
        }


        if ($currentcatalog_canmanage && $this->fields["keyrequired"]) {
            if (!$this->fields["manage_accountkey"]) {
                $options["addbuttons"] = [
                    'changeto_directory' => 'Ce catalogue est un annuaire'
                ];
            }

            if ($this->fields["manage_accountkey"]) {
                $options["addbuttons"] = [
                    'delete_directory' => 'Supprimer cet annuaire et ses comptes'
                ];
            }
        }


//        var_dump($this->existOneThatCanManage());
//        die();
//        if(count($this->existOneThatCanManage()) == 0){
        if (count($this->existOneThatCanManage()) == 0) {
            $options["addbuttons"] = [
                'changeto_directory' => 'Ce catalogue est un annuaire'
            ];
        }


        echo "</div>";

        $this->showFormButtons($options);

//        if($currentcatalog_canmanage)
        $this->additionalShowOtherCatalogs($id);


        echo "<style>";
        echo "
            .form-table-text {
                text-align: right;
            }
            
            
            @media (max-width: 600px) {
                .form-table-text {
                    text-align: left;
                }
            }
        ";

        echo "</style>";
        return true;
    }

    protected function computeFriendlyName()
    {
//        if (isset($this->fields[static::getNameField()])) {
        return $this->fields["completename"];
//        }
//        return '';
    }

    public function additionalShow($id)
    {
        if ($id) {
            $id = $this->fields['id'];
            if (!$this->can($id, READ)) {
                return false;
            }
            $canedit = $this->can($id, UPDATE);
            $rand = mt_rand(1, mt_getrandmax());
            global $CFG_GLPI;
            global $DB;


            // Section Data type - BEGIN
            $id = $this->fields['id'];
            if (!$this->can($id, READ)) {
                return false;
            }
            $canedit = $this->can($id, UPDATE);
            $rand = mt_rand(1, mt_getrandmax());

            global $DB;

            $iterator = $DB->request([
                'SELECT' => [
                    'glpi_plugin_dlteams_datacatalogs_items.id AS linkid',
                    'glpi_plugin_dlteams_datacatalogs_items.comment as comment',
                    'glpi_plugin_dlteams_datacarriertypes.id as id',
                    'glpi_plugin_dlteams_datacarriertypes.name as name',
                ],
                'FROM' => 'glpi_plugin_dlteams_datacatalogs_items',
                'JOIN' => [
                    'glpi_plugin_dlteams_datacarriertypes' => [
                        'FKEY' => [
                            'glpi_plugin_dlteams_datacatalogs_items' => 'items_id',
                            'glpi_plugin_dlteams_datacarriertypes' => 'id'
                        ]
                    ]
                ],
                'WHERE' => [
                    'glpi_plugin_dlteams_datacatalogs_items.datacatalogs_id' => $this->fields['id'],
                    'glpi_plugin_dlteams_datacatalogs_items.itemtype' => "PluginDlteamsDataCarrierType"
                ],
                'ORDER' => ['name ASC'],
            ], "", true);

            $number = count($iterator);
            $items_list = [];
            $used = [];
            //var_dump(count($iterator));
            // while ($data = $iterator->next()) {
            foreach ($iterator as $id => $data) {
                $items_list[$data['linkid']] = $data;
                $used[$data['id']] = $data['id'];
            }

            if ($canedit) {
                echo "<form name='allitemitem_form$rand' id='allitemitem_form$rand' method='post' action='" . Toolbox::getItemTypeFormURL(PluginDlteamsAllItem::class) . "'>";
                echo "<input type='hidden' name='itemtype1' value='" . $this->getType() . "' />";
                echo "<input type='hidden' name='items_id1' value='" . $this->getID() . "' />";
                echo "<input type='hidden' name='itemtype' value='" . PluginDlteamsDataCarrierType::getType() . "' />";
                echo "<input type='hidden' name='entities_id' value='" . $this->getID(Entity::class) . "' />";
                // echo "<input type='hidden' name='comment' value='".$this->fields['comment']."' />";

                echo "<table class='tab_cadre_fixe'>";
                echo "<tr class='tab_bg_2'><th style='text-align:left!important'>" . __("Types de données contenues par ce catalogue", 'dlteams') . "</th></tr>";
                $subtitle = "ne pas inclure les types de données des sous-catalogues";
                echo "</table>";


                echo "<table class='tab_cadre_fixe'>";
                echo "<td style='text-align:right'>" . __("Type", 'dlteams') . "</td>";
                echo "<td>";
                PluginDlteamsDataCarrierType::dropdown([
                    'addicon' => PluginDlteamsDataCarrierType::canCreate(),
                    'name' => 'items_id',
                    'width' => '300px'
                ]);
                echo "</td>";

                echo "<tr>";
                echo "<td style='text-align:right'>" . __("Comment") . " " . "</td>";
                $comment = Html::cleanInputText($this->fields['comment']);
                echo "<td>" . "<textarea style='width:100%' rows='1' name='comment' >" . $comment . "</textarea>" . "</td>";
                echo "<td class='left'><input type='submit' name='add' value=\"" . _sx('button', 'Add') . "\" class='submit' style='margin:0px auto!important'>" . "</td>";
                echo "</tr>";
                echo "</table>";

                Html::closeForm();
            }

            if ($iterator) {
                echo "<div class='spaced'>";
                if ($canedit && $number) {
                    Html::openMassiveActionsForm('mass' . PluginDlteamsDataCatalog_Item::class . $rand);
                    $massive_action_params = ['container' => 'mass' . PluginDlteamsDataCatalog_Item::class . $rand,
                        'num_displayed' => min($_SESSION['glpilist_limit'], $number)];
                    Html::showMassiveActions($massive_action_params);
                }
                echo "<table class='tab_cadre_fixehov'>";

                $header_begin = "<tr>";
                $header_top = '';
                $header_bottom = '';
                $header_end = '';

                if ($canedit && $number) {
                    $header_begin .= "<th width='10'>";
                    $header_top .= Html::getCheckAllAsCheckbox('mass' . PluginDlteamsDataCatalog_Item::class . $rand);
                    $header_bottom .= Html::getCheckAllAsCheckbox('mass' . PluginDlteamsDataCatalog_Item::class . $rand);
                    $header_end .= "</th>";
                }

                $header_end .= "<th width='20%' style='text-align:left'>" . __("Specify the data format", 'dlteams') . "</th>";
                // $header_end .= "<th width='20%'>" . __("Type", 'dlteams') . "</th>";
                $header_end .= "<th width='80%' style='text-align:left'>" . __("Comment", 'dlteams') . "</th>";
                $header_end .= "</tr>";

                echo $header_begin . $header_top . $header_end;
                foreach ($items_list as $data) {
                    if ($data['name']) {
                        echo "<tr class='tab_bg_1'>";

                        if ($canedit && $number) {
                            echo "<td width='10'>";
                            Html::showMassiveActionCheckBox(PluginDlteamsDataCatalog_Item::class, $data['linkid']);
                            echo "</td>";
                        }

                        $link = $data['name'];
                        if ($_SESSION['glpiis_ids_visible'] || empty($data['name'])) {
                            $link = sprintf(__("%1\$s (%2\$s)"), $link, $data['id']);
                        }
                        $name = "<a target='_blank' href=\"" . PluginDlteamsDataCarrierType::getFormURLWithID($data['id']) . "\">" . $link . "</a>";

                        echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                        echo ">" . $name . "</td>";
                        // echo "<td class='left'>" . $data['type'] . " </td>";
                        echo "<td class='left'>" . $data['comment'] . "</td>";
                        echo "</tr>";
                    }
                }

                if ($iterator->count() > 10) {
                    echo $header_begin . $header_bottom . $header_end;
                }
                echo "</table>";

                if ($canedit && $number) {
                    //$massive_action_params['ontop'] = false;
                    //Html::showMassiveActions($massive_action_params);
                    Html::closeForm();
                }
                echo "</div>";
            }

//            means of access
//            if ($canedit) {
//                echo "<form name='meansofaccess_form$rand' id='meansofaccess_form$rand' method='post'
//         action='" . Toolbox::getItemTypeFormURL(__CLASS__) . "'>";
//                echo "<input type='hidden' name='itemtype' value='" . $this->getType() . "' />";
//                echo "<input type='hidden' name='datacatalogs_id' value='" . $this->getID() . "' />";
//                echo "<input type='hidden' name='itemtype1' value='" . PluginAccountsAccount::getType() . "' />";
//                echo "<input type='hidden' name='entities_id' value='" . $this->getID(Entity::class) . "' />";
//                echo "<input type='hidden' name='comment' value='" . $this->fields['comment'] . "' />";
//
//                echo "<table class='tab_cadre_fixe'>";
//                echo "<tr class='tab_bg_2'><th style='text-align:center!important'>" . __("Indiquez les moyens d'accès au catalogue", 'dlteams') . "</th></tr>";
//                echo "</table>";
//
//                echo "<table class='tab_cadre_fixe'>";
//                echo "<td style='text-align:right'>" . __("Moyen d'accès", 'dlteams') . "</td>";
//                echo "<td>";
//                echo "<div style='display: flex; gap: 4px; align-items: center'>";
//
//                PluginDlteamsMeansOfAcce::dropdown([
//                    'addicon' => PluginDlteamsMeansOfAcce::canCreate(),
//                    'name' => 'meansofacces_id',
//
//                ]);
//
//                echo "</td>";
//
//                echo "</div>";
//
//
//                echo "<tr class='tab_bg_1' style='display: none' id='mandatory_field'>";
//                echo "<td width='25%' style='text-align: right'>" . __('Mandatory') . "</td>";
//                echo "<td width='75%'>";
//
//
//                Html::showCheckbox(['name' => 'mandatory',
//                    'title' => __('Mandatory', 'dlteams')
//                ]);
//                /**add by me**/
//                echo "</td>";
//                echo "</tr>";
//
//                echo "<tr id='comment_meoa' style='display: none'>";
//                echo "<td id='comment_label_meansofacces' style='text-align:right'>" . __("Commentaires", 'dlteams') . " " . "</td>";
//                $comment = Html::cleanInputText($this->fields['comment']);
//                echo "<td>" . "<textarea style='width:100%' rows='2' name='comment' >" . $comment . "</textarea>" . "</td>";
//                echo "<td class='left'><input type='submit' name='addmeansofaccess' value=\"" . _sx('button', 'Add') . "\" class='submit' style='margin:0px auto!important'>" . "</td>";
//                echo "</tr>";
//
//                echo "</table>";
//
//                Html::closeForm();
//
//                echo "<script>
//                $(document).ready(function(e){
//
//                $('select[name=meansofacces_id]').on('change', function () {
//
//                    if ($(this).val() != '0') {
//                            document.getElementById('comment_meoa').style.display = '';
//                            document.getElementById('mandatory_field').style.display = '';
//
//                        } else {
//                            document.getElementById('comment_meoa').style.display = 'none';
//                            document.getElementById('mandatory_field').style.display = 'none';
//                        }
//
//                        switch ($(this).val()) {
//                          case '1':
//                              $('#account_field').css('display', 'block');
//                              break;
//                          case '2':
//                              $('#account_field').css('display', 'none');
//                              break;
//                          case '3':
//                              $('#account_field').css('display', 'none');
//                              break;
//                          case '4':
//                              $('#comment_label_meansofacces').text('" . __("Commentaires", 'dlteams') . "');
//                              $('#account_field').css('display', 'none');
//                              break;
//                          case '5':
//                              $('#comment_label_meansofacces').text('quelles habilitation ?');
//                              $('#account_field').css('display', 'none');
//                              break;
//                          case '6':
//                              $('#comment_label_meansofacces').text('quelles matériels ?');
//                              $('#account_field').css('display', 'none');
//                              break;
//                          case '7':
//                              $('#comment_label_meansofacces').text('quelles horaires ?');
//                              $('#account_field').css('display', 'none');
//                              break;
//                        }
//                    });
//
//                });
//        </script>";
//            }
//
//            $items_list = static::getMeansOfAccesRequest($this);
//
//            if ($canedit) {
//                // Display recipients
//                echo "<div class='spaced'>";
//                if ($canedit && count($items_list)) {
//                    Html::openMassiveActionsForm('mass' . PluginDlteamsDataCatalog_Item::class . $rand);
//                    $massive_action_params = ['container' => 'mass' . PluginDlteamsDataCatalog_Item::class . $rand,
//                        'num_displayed' => min($_SESSION['glpilist_limit'], $number)];
//                    Html::showMassiveActions($massive_action_params);
//                }
//                echo "<table class='tab_cadre_fixehov'>";
//
//                $header_begin = "<tr>";
//                $header_top = '';
//                $header_bottom = '';
//                $header_end = '';
//
//                if ($canedit && count($items_list)) {
//
//                    $header_begin .= "<th width='10'>";
//                    $header_top .= Html::getCheckAllAsCheckbox('mass' . PluginDlteamsDataCatalog_Item::class . $rand);
//                    $header_bottom .= Html::getCheckAllAsCheckbox('mass' . PluginDlteamsDataCatalog_Item::class . $rand);
//                    $header_end .= "</th>";
//                }
//
//                $header_end .= "<th>" . __("Moyen d'accès") . "</th>";
//                $header_end .= "<th>" . __("Obligatoire", 'dlteams') . "</th>";
//                $header_end .= "<th>" . __("Comment") . "</th>";
//                $header_end .= "</tr>";
//
//
//                echo $header_begin . $header_top . $header_end;
//                //var_dump($items_list);
//
//                foreach ($items_list as $data) {
//                    echo "<tr class='tab_bg_1'>";
//
//                    if ($canedit && count($items_list)) {
//                        echo "<td width='10'>";
//                        Html::showMassiveActionCheckBox(PluginDlteamsDataCatalog_Item::class, $data['linkid']);
//                        echo "</td>";
//                    }
//
//                    $itemtype_str = $data['itemtype'];
//                    $itemtype_object = new $itemtype_str();
//                    $itemtype_object->getFromDB($data['items_id']);
//
//                    $name = "<a target='_blank' href=\"" . $data['itemtype']::getFormURLWithID($data['items_id']) . "\">" . $itemtype_object->fields['name'] . "</a>";
//
//                    echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
//                    echo ">" . $name . "</td>";
//
//                    $mandatory = isset($data["meansofacces_mandatory"]) && $data["meansofacces_mandatory"] ? "oui" : "Non";
//                    echo "<td class='left' width='30%'>" . $mandatory . "</td>";
//                    echo "<td class='left' width='40%'>" . ($data['comment'] ?? "") . "</td>";
//                    echo "</tr>";
//                }
//
//                if ($iterator->count() > 10) {
//                    echo $header_begin . $header_bottom . $header_end;
//                }
//                echo "</table>";
//
//                if ($canedit && $number > 10) {
//                    $massive_action_params['ontop'] = false;
//                    Html::showMassiveActions($massive_action_params);
//                }
//                Html::closeForm();
//
//
//                echo "</div>";
//            }
        }
    }


    public function isUsed()
    {

        if (parent::isUsed()) {
            return true;
        }

        return $this->isUsedInIemsTables();
    }


    /**
     * Check if group is used in consumables.
     *
     * @return boolean
     */
    private function isUsedInIemsTables()
    {

        $counts = countElementsInTable(
            PluginDlteamsDataCatalog_Item::getTable(),
            [
                'datacatalogs_id' => $this->fields['id'],
            ]
        );


        return $counts > 0;
    }

    public static function annuaireTiersRequest(PluginDlteamsDataCatalog $annuaire)
    {
        global $DB;
        $data = [];
        $iterator = $DB->request([
            'SELECT' => [
                PluginDlteamsDataCatalog_Item::getTable() . '.id as linkid',
                PluginDlteamsDataCatalog::getTable() . '.id as id',
                PluginDlteamsDataCatalog::getTable() . '.name as name',
            ],
            'FROM' => PluginDlteamsDataCatalog_Item::getTable(),
            'JOIN' => [
                PluginDlteamsDataCatalog::getTable() => [
                    'FKEY' => [
                        PluginDlteamsDataCatalog_Item::getTable() => 'items_id',
                        PluginDlteamsDataCatalog::getTable() => 'id'
                    ]
                ]
            ],

            'WHERE' => [
                PluginDlteamsDataCatalog_Item::getTable() . '.datacatalogs_id' => $annuaire->fields['id'],
                PluginDlteamsDataCatalog_Item::getTable() . '.itemtype' => PluginDlteamsDataCatalog::class,
            ],
            'ORDER' => ['name ASC'],
        ], "", true);


        foreach ($iterator as $catalog_item)
            $data[] = $catalog_item;

        return $data;
    }

    public function additionalShowOtherCatalogs($id)
    {
        if ($id) {
            $id = $this->fields['id'];
            if (!$this->can($id, READ)) {
                return false;
            }


            // Section Data type - BEGIN
            $id = $this->fields['id'];
            if (!$this->can($id, READ)) {
                return false;
            }
            $canedit = $this->can($id, UPDATE);
            $rand = mt_rand(1, mt_getrandmax());

            $iterator = static::annuaireTiersRequest($this);

            $number = count($iterator);
            $items_list = [];
            $used = [];

            foreach ($iterator as $id => $data) {
                $items_list[$data['linkid']] = $data;
                $used[$data['id']] = $data['id'];
            }

            if ($canedit && $this->fields["keyrequired"] == 1 && $this->fields["plugin_dlteams_datacatalogs_id"] == 0) { // keyrequired 0 si aucune clé
                echo "<form name='allitemitem_form$rand' id='allitemitem_form$rand' method='post' action='" . Toolbox::getItemTypeFormURL(__CLASS__) . "'>";
                echo "<input type='hidden' name='datacatalogs_id' value='" . $this->getID() . "' />";

                echo "<table class='tab_cadre_fixe'>";
                echo "<tr class='tab_bg_2'><th style='text-align:left!important'>" . __("Annuaire(s) utilisable(s) pour l'accès à ce catalogue", 'dlteams') . "</th></tr>";
                echo "</table>";
                echo "<table class='tab_cadre_fixe'>";
                echo "<td style='text-align:right'>" . __("Service d'annuaire", 'dlteams') . "</td>";

                echo "<td>";


                $condition = ['manage_accountkey' => 1];
                if ($this->fields["manage_accountkey"]) {
                    $condition = [
                        "OR" => [
                            [
                                "manage_accountkey" => true
                            ],
//                                ["id" => 2438]
                        ]
                    ];
                    if ($this->getAccountKeyManager() && count($this->getAccountKeyManager()) > 0) {
                        $condition["OR"][] = ["id" => $this->getAccountKeyManager()];
                    }
                }


                PluginDlteamsDataCatalog::dropdown([
                    'addicon' => PluginDlteamsDataCatalog::canCreate(),
                    'name' => 'items_id',
                    'width' => '300px',
                    'used' => [...$used],
                    'condition' => $condition
                ]);
                echo "   ";

                echo "<class='left'><input type='submit' name='add_other_directory' value=\"" . _sx('button', 'Add') . "\" class='submit' style='margin:0px class='left' auto!important'>";
                // echo "</tr>";
                echo "</table>";
                Html::closeForm();


                if ($iterator) {
                    $ma_processor = PluginDlteamsDataCatalog_Otherdirectory_Ma::class;

                    echo "<div class='spaced'>";
                    if ($canedit && $number) {
                        Html::openMassiveActionsForm('mass' . $ma_processor . $rand);
                        $massive_action_params = ['container' => 'mass' . $ma_processor . $rand,
                            'num_displayed' => min($_SESSION['glpilist_limit'], $number)];
                        Html::showMassiveActions($massive_action_params);
                    }
                    echo "<table class='tab_cadre_fixehov'>";

                    $header_begin = "<tr>";
                    $header_top = '';
                    $header_bottom = '';
                    $header_end = '';

                    if ($canedit && $number) {
                        $header_begin .= "<th width='10'>";
                        $header_top .= Html::getCheckAllAsCheckbox('mass' . $ma_processor . $rand);
                        $header_bottom .= Html::getCheckAllAsCheckbox('mass' . $ma_processor . $rand);
                        $header_end .= "</th>";
                    }

                    $header_end .= "<th style='text-align:left'>" . __("Service annuaire", 'dlteams') . "</th>";
                    // $header_end .= "<th width='20%'>" . __("Type", 'dlteams') . "</th>";
//                $header_end .= "<th width='80%' style='text-align:left'>" . __("Comment", 'dlteams') . "</th>";
                    $header_end .= "</tr>";

                    echo $header_begin . $header_top . $header_end;
                    foreach ($items_list as $data) {
                        if ($data['name']) {
                            echo "<tr class='tab_bg_1'>";
                            if ($canedit && $number) {
                                echo "<td width='10'>";
                                Html::showMassiveActionCheckBox($ma_processor, $data['linkid']);
                                echo "</td>";
                            }

                            $link = $data['name'];
                            if ($_SESSION['glpiis_ids_visible'] || empty($data['name'])) {
                                $link = sprintf(__("%1\$s (%2\$s)"), $link, $data['id']);
                            }
                            $name = "<a target='_blank' href=\"" . PluginDlteamsDataCatalog::getFormURLWithID($data['id']) . "\">" . $link . "</a>";

                            echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                            echo ">" . $name . "</td>";
                            // echo "<td class='left'>" . $data['type'] . " </td>";
                            // echo "<td class='left'>" . $data['comment'] . "</td>";
                            echo "</tr>";
                        }
                    }

                    // if ($iterator->count() > 10) {
                    //    echo $header_begin . $header_bottom . $header_end;
                    // }
                    echo "</table>";

                    if ($canedit && $number) {
                        //$massive_action_params['ontop'] = false;
                        //Html::showMassiveActions($massive_action_params);
                        Html::closeForm();
                    }

                    echo "</div>";
                }
            }

//            }

        }
    }


    function prepareInputForAdd($input)
    {
        $input['users_id_creator'] = Session::getLoginUserID();
        return parent::prepareInputForAdd($input);
    }

    function prepareInputForUpdate($input)
    {
        $input['users_id_lastupdater'] = Session::getLoginUserID();
        return parent::prepareInputForUpdate($input);
    }

    function cleanDBonPurge()
    {
        /*$rel = new PluginDlteamsRecord_MotifEnvoi();
        $rel->deleteByCriteria(['plugin_dlteams_concernedpersons_id' => $this->fields['id']]);*/
    }

    public function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {

        if (!$withtemplate && self::canView()) {
            $nb = 0;
            switch ($item->getType()) {
                case 'PluginDlteamsDataCatalog':

                    global $DB;
                    $ID = $item->getID();
                    $fk = $this->getForeignKeyField();

                    $result = $DB->request(
                        [
                            'SELECT' => [
                                'glpi_plugin_dlteams_datacatalogs.*', // Toutes les colonnes des catalogues
                                'parent.name AS parent_name',         // Nom du parent pour référence
                                'parent.id AS parent_id'             // ID du parent
                            ],
                            'FROM' => 'glpi_plugin_dlteams_datacatalogs',
                            'LEFT JOIN' => [
                                // Jointure avec la même table pour lier les enfants avec leurs parents
                                'glpi_plugin_dlteams_datacatalogs AS parent' => [
                                    'FKEY' => [
                                        'parent' => 'id',                           // ID du parent
                                        'glpi_plugin_dlteams_datacatalogs' => $fk // Lien enfant vers parent
                                    ]
                                ]
                            ],
                            'WHERE' => [
                                'OR' => [
                                    "glpi_plugin_dlteams_datacatalogs.$fk" => $ID, // Catalogues directement liés au parent
                                    "parent.$fk" => $ID // Catalogues enfants liés au parent
                                ]
                            ],
                            'ORDER' => 'glpi_plugin_dlteams_datacatalogs.name'
                        ]
                    );

                    $nb = count($result);

                    $ong = [];
                    $ong[1] = self::createTabEntry(_n('Child catalog', 'Childs catalogs', 2, 'dlteams'), $nb);
                    return $ong;
            }
        }

        if ($item instanceof self) {
            $tabs[1] = __('Analyse d\'impact', 'dlteams');
        }

        return '';
    }

    public static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {

        switch ($item->getType()) {
            case 'PluginDlteamsDataCatalog':
                switch ($tabnum) {
                    case 1:
                        $item->showChildren();
                        return true;
                }
                break;
        }
        return false;
    }

    /**
     * @see CommonDBTM::showMassiveActionsSubForm()
     */
    public static function showMassiveActionsSubForm(MassiveAction $ma)
    {

        switch ($ma->getAction()) {
            case 'copyTo':
                //                $values = [];
//                foreach ($_SESSION["glpiactiveentities"] ?? [] as $key => $entities_id) {
//                    $entity = new Entity();
//                    $entity->getFromDB($entities_id);
//                    $values[$key] = $entity->fields["completename"];
//                }
                Entity::dropdown(['name' => 'entities_id']);
                echo '<br /><br />' . Html::submit(_x('button', 'Post'), ['name' => 'massiveaction']);
                return true;
                break;
            case 'add_child_catalogs':
                echo "<input type='text' name='value' size='50'>";
                break;
        }

        return parent::showMassiveActionsSubForm($ma);
    }

    /**
     * Print the HTML array children of a TreeDropdown
     *
     * @return void
     */
    public function showChildren()
    {
        global $DB;

        $ID = $this->getID();
        $this->check($ID, READ);
        $fields = array_filter(
            $this->getAdditionalFields(),
            function ($field) {
                return isset($field['list']) && $field['list'];
            }
        );
        $nb = count($fields);
        $entity_assign = $this->isEntityAssign();

        // Minimal form for quick input.
        if (static::canCreate()) {
            $link = $this->getFormURL();
            /*
            echo "<div class='firstbloc'>";
            echo "<form action='" . $link . "' method='post'>";
            echo "<table class='tab_cadre_fixe'>";

            echo "<tr><th colspan='3'>" . __('New child heading') . "</th></tr>";

            echo "<tr class='tab_bg_1'>";
            echo "<td>" . __('Name') . "</td><td>";
            echo Html::input('name', ['value' => '']);

            if (
                $entity_assign
                && ($this->getForeignKeyField() != 'entities_id')
            ) {
                echo "<input type='hidden' name='entities_id' value='" . $_SESSION['glpiactive_entity'] . "'>";
            }

            if ($entity_assign && $this->isRecursive()) {
                echo "<input type='hidden' name='is_recursive' value='1'>";
            }
            echo "<input type='hidden' name='" . $this->getForeignKeyField() . "' value='$ID'></td>";
            echo "<td><input type='submit' name='add' value=\"" . _sx('button', 'Add') . "\" class='btn btn-primary'>";
            echo "</td></tr>\n";
            echo "</table>";
            Html::closeForm();
            echo "</div>\n";
            */

//            ajouter un catalogue existaant comme enfant

            $used = [];
            $fk = $this->getForeignKeyField();
            $result = $DB->request(
                [
                    'SELECT' => [
                        'glpi_plugin_dlteams_datacatalogs.*', // Toutes les colonnes des catalogues
                        'parent.name AS parent_name',         // Nom du parent pour référence
                        'parent.id AS parent_id'             // ID du parent
                    ],
                    'FROM' => 'glpi_plugin_dlteams_datacatalogs',
                    'LEFT JOIN' => [
                        // Jointure avec la même table pour lier les enfants avec leurs parents
                        'glpi_plugin_dlteams_datacatalogs AS parent' => [
                            'FKEY' => [
                                'parent' => 'id',                           // ID du parent
                                'glpi_plugin_dlteams_datacatalogs' => $fk // Lien enfant vers parent
                            ]
                        ]
                    ],
                    'WHERE' => [
                        'OR' => [
                            "glpi_plugin_dlteams_datacatalogs.$fk" => $ID, // Catalogues directement liés au parent
                            "parent.$fk" => $ID // Catalogues enfants liés au parent
                        ]
                    ],
                    'ORDER' => 'glpi_plugin_dlteams_datacatalogs.name'
                ]
            );

            foreach ($result as $id => $data) {
                $used[$data['id']] = $data['id'];
            }
            $used[$ID] = $ID;

            echo "<div class='firstbloc'>";
            $this->initForm($this->fields["id"], []);
            $this->showFormHeader([]);
            echo "<table class='tab_cadre_fixe'>";
            echo "<tr><th colspan='3'>" . __('Intitulé d\'enfant existant') . "</th></tr>";


            echo "<input type='hidden' name='id' value='" . $this->fields["id"] . "'>";
            echo "<tr class='tab_bg_1'><td style='text-align: right; width: 35%; white-space: nowrap'>" . __('Rattacher un catalogue comme enfant') . "</td><td style='min-width: 10%'>";
//            echo Html::input('name', ['value' => '']);
            PluginDlteamsDataCatalog::dropdown([
                'addicon' => self::canCreate(),
                'name' => 'son_id',
                'width' => '100%',
                'entity_sons' => true,
                'used' => $used,
                'value' => null
            ]);

            if (
                $entity_assign
                && ($this->getForeignKeyField() != 'entities_id')
            ) {
                echo "<input type='hidden' name='entities_id' value='" . $_SESSION['glpiactive_entity'] . "'>";
            }

            if ($entity_assign && $this->isRecursive()) {
                echo "<input type='hidden' name='is_recursive' value='1'>";
            }
            echo "<input type='hidden' name='" . $this->getForeignKeyField() . "' value='$ID'></td>";
            echo "<td style='text-align: left'><input type='submit' name='update_as_child' value=\"" . _sx('button', 'Add') . "\" class='btn btn-primary'>";
            echo "</td></tr>\n";
            echo "</table>";
            Html::closeForm();
            echo "</div>\n";
        }


        $rand = mt_rand();
        echo "<div class='spaced'>";

        echo "<table class='tab_cadre_fixehov'>";

        echo "<tr class='noHover'><th colspan='" . ($nb + 3) . "'>" . sprintf(
                __('Sons of %s'),
                $this->getTreeLink()
            );
        echo "</th></tr>";

        echo "</table>";

        echo "<table class='tab_cadre_fixehov'>";
        $header = "<tr>";

//        $header .= "<th width='10'>";
//        $header .= Html::getCheckAllAsCheckbox('mass' . $ma_processor . $rand);
//        $header .= "</th>";

        $header .= "<th>" . __('Name') . "</th>";
        if ($entity_assign) {
            $header .= "<th>" . Entity::getTypeName(1) . "</th>";
        }
        foreach ($fields as $field) {
            $header .= "<th>" . $field['label'] . "</th>";
        }
        $header .= "<th>" . __('Comments') . "</th>";
        $header .= "</tr>\n";
        echo $header;


        $nb = 0;
        foreach ($result as $data) {
            $nb++;
            echo "<tr class='tab_bg_1'>";

//            echo "<td>";
//            Html::showMassiveActionCheckBox($ma_processor, $data["id"]);
//            echo "</td>";

            echo "<td>";


            if (
                (($fk == 'entities_id') && in_array($data['id'], $_SESSION['glpiactiveentities']))
                || !$entity_assign
                || (($fk != 'entities_id') && in_array($data['entities_id'], $_SESSION['glpiactiveentities']))
            ) {
                echo "<a href='" . $this->getFormURL();
                echo '?id=' . $data['id'] . "'>" . $data['completename'] . "</a>";
            } else {
                echo $data['name'];
            }
            echo "</td>";
            if ($entity_assign) {
                echo "<td>" . Dropdown::getDropdownName("glpi_entities", $data["entities_id"]) . "</td>";
            }

            foreach ($fields as $field) {
                echo "<td>";
                switch ($field['type']) {
                    case 'UserDropdown':
                        echo getUserName($data[$field['name']]);
                        break;

                    case 'bool':
                        echo Dropdown::getYesNo($data[$field['name']]);
                        break;

                    case 'dropdownValue':
                        echo Dropdown::getDropdownName(
                            getTableNameForForeignKeyField($field['name']),
                            $data[$field['name']]
                        );
                        break;

                    default:
                        echo $data[$field['name']];
                }
                echo "</td>";
            }
            echo "<td>" . $data['comment'] . "</td>";
            echo "</tr>\n";
        }
//        if ($nb) {
//            echo $header;
//        }
        echo "</table></div>\n";
    }

    /* Execute massive action for dlteams Plugin
     * @see CommonDBTM::processMassiveActionsForOneItemtype()
     */
    static function processMassiveActionsForOneItemtype(MassiveAction $ma, CommonDBTM $item, array $ids)
    {
        switch ($ma->getAction()) {
            case 'copyTo':
                if ($item->getType() == PluginDlteamsDataCatalog::class) {
                    // @var PluginDlteamsRecord $item
                    foreach ($ids as $id) {
                        if ($item->getFromDB($id)) {
                            if ($item->copy1($ma->POST['entities_id'], $id, $item)) {
                                //Session::addMessageAfterRedirect(sprintf(__('Record copied: %s', 'dlteams'), $item->getName()));
                                $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_OK);
                            }
                        } else {
                            // Example of ko count
                            $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_KO);
                        }
                    }
                }
                return;
                break;
            case 'add_child_catalogs':
                $tab_catalog_names = explode(',', $ma->POST["value"]);

                foreach ($ids as $key => $id) {
                    $datacatalog = new PluginDlteamsDataCatalog();
                    $temp_catalo = new PluginDlteamsDataCatalog();
                    $temp_catalo->getFromDB($id);
                    foreach ($tab_catalog_names as $ct_name) {
                        if ($newdt_id = $datacatalog->add([
                            "name" => $ct_name,
                            "plugin_dlteams_catalogclassifications_id" => $temp_catalo->fields["plugin_dlteams_catalogclassifications_id"],
                            "plugin_dlteams_datacarriercategories_id" => $temp_catalo->fields["plugin_dlteams_datacarriercategories_id"],
                            "plugin_dlteams_datacatalogs_id" => $id,
                            "entities_id" => $temp_catalo->fields["entities_id"]
                        ])) {
                            $link = PluginDlteamsDataCatalog::getFormURLWithID($newdt_id);
//                            Session::addMessageAfterRedirect("Ajouté avec succès");
                            Session::addMessageAfterRedirect(sprintf("<a href='%s'>%s</a> ajouté comme sous catalogue de %s", PluginDlteamsDataCatalog::getFormURLWithID($newdt_id), $ct_name, $temp_catalo->fields["name"]));
                        } else {
                            Session::addMessageAfterRedirect(sprintf("Echec de l'ajout de % comme enfant de %s", $ct_name, $temp_catalo->fields["name"]));
                        }
                    }
                }
                break;
        }
        return true;
    }

    public static function rawSearchOptionsToAdd($itemtype = null)
    {
        $tab = [];

        $tab[] = [
            'id' => '100',
            'table' => 'glpi_documents_items',
            'field' => 'id',
            'name' => _x('quantity', 'Documents'),
            'forcegroupby' => true,
            'usehaving' => true,
            'datatype' => 'count',
            'massiveaction' => false,
            'joinparams' => [
                'jointype' => 'itemtype_item'
            ]
        ];



        return $tab;
    }

    function rawSearchOptions()
    {

        $tab = [];
//        $tab[] = [
//            'id'                 => '9',
//            'table'              => 'glpi_plugin_dlteams_datacatalogs',
//            'field'              => 'completename',
//            'name'               => PlugindlteamsDataCatalog::getTypeName(1),
//            'datatype'           => 'dropdown'
//        ];
        $tab[] = [
            'id' => '1',
            'table' => $this->getTable(),
            'field' => 'completename',
            'name' => __('Complete name'),
            'datatype' => 'itemlink',
            'massiveaction' => false,
            'autocomplete' => true,
        ];

        /*        $tab[] = [
                    'id' => '3',
                    'table' => 'glpi_plugin_dlteams_datacatalogs',
                    'field' => 'name',
                    'linkfield' => 'plugin_dlteams_datacatalogs_id',
                    'name' => __("Catalogue parent"),
                    'datatype' => 'dropdown',
                    'toview' => true,
                    'massiveaction' => true,
                ];*/

        $tab[] = [
            'id' => '13',
            'table' => $this->getTable(),
            'field' => 'completename',
            'name' => __('Parent'),
            'datatype' => 'dropdown',
            'massiveaction' => false,
            'joinparams' => [
                'condition' => [new QueryExpression('1=1')]
            ]
        ];

        $tab[] = [
            'id' => '4',
            'table' => 'glpi_plugin_dlteams_datacarriercategories',
            'field' => 'name',
            'name' => __("Type"),
            'datatype' => 'dropdown',
            'toview' => true,
            'massiveaction' => true,
        ];

        $tab[] = [
            'id' => '5',
            'table' => $this->getTable(),
            'field' => 'content',
            'name' => __("Content"),
            'datatype' => 'text',
            'toview' => true,
            'massiveaction' => true,
        ];

        $tab[] = [
            'id' => '6',
            'table' => 'glpi_plugin_dlteams_catalogclassifications',
            'field' => 'name',
            'name' => __("Classification"),
            'datatype' => 'dropdown',
            'toview' => true,
            'massiveaction' => true,
        ];

        $tab[] = [
            'id' => '7',
            'table' => 'glpi_users',
            'field' => 'name',
            'linkfield' => 'users_id_contact',
            'name' => __("Utilisateur resp."),
            'datatype' => 'dropdown',
            'toview' => true,
            'massiveaction' => true,
        ];

        $tab[] = [
            'id' => '8',
            'table' => 'glpi_groups',
            'field' => 'name',
            'linkfield' => 'groups_id_contact',
            'name' => __("Groupe resp."),
            //'condition' => ['is_assign' => 1],
            'datatype' => 'dropdown',
            'toview' => true,
            'massiveaction' => true,
        ];

        $tab[] = [
            'id' => '9',
            'table' => $this->getTable(),
            'field' => 'comment',
            'name' => __("Comments"),
            'datatype' => 'text',
            'toview' => true,
            'massiveaction' => false,
        ];

        if ($this->isEntityAssign()) {
            $tab[] = [
                'id' => '14',
                'table' => 'glpi_entities',
                'field' => 'completename',
                'name' => __("Entity"),
                'datatype' => 'dropdown',
                'massiveaction' => false,
            ];
        }

        $tab[] = [
            'id' => '15',
            'table' => $this->getTable(),
            'field' => 'is_recursive',
            'name' => __("Child entities"),
            'datatype' => 'bool',
            'massiveaction' => false,
        ];

        $tab[] = [
            'id' => '16',
            'table' => $this->getTable(),
            'field' => 'manage_accountkey',
            'name' => __("Annuaire"),
            'datatype' => 'bool',
            'massiveaction' => false,
        ];

        $tab[] = [
            'id' => '2',
            'table' => $this->getTable(),
            'field' => 'id',
            'name' => __("ID"),
            'massiveaction' => false,
            'datatype' => 'number',
        ];

//        $tab[] = [
//            'id' => '101',
//            'table' => 'glpi_plugin_dlteams_policieforms_items',
//            'field' => 'id',
//            'name' => _x('quantity', 'Jeux de données'),
//            'forcegroupby' => true,
//            'usehaving' => true,
//            'datatype' => 'count',
//            'massiveaction' => false,
//            'joinparams' => [
//                'jointype' => 'itemtype_item'
//            ]
//        ];

        $tab[] = [
            'id' => '101',
            'table' => PluginDlteamsDataCatalog_Item::getTable(),
            'field' => 'items_id',
            'name' => _x('quantity', 'Jeux de données'),
            'datatype' => 'specific', //'itemlink',
            'comments' => true,
            'nosort' => false,
            'additionalfields' => ['itemtype'],
            'joinparams' => [
                'linkfield' => 'datacatalogs_id',
                'jointype' => 'child',
                'condition' => "AND NEWTABLE.`itemtype` = '" . PluginDlteamsPolicieForm::class . "'",
            ],
            'forcegroupby' => true,
            'massiveaction' => false,
            'htmltext' => true,
            'showpolicieForm' => true
            //'dlteams_activityname' => true,
        ];

        $tab[] = [
            'id' => '102',
            'table' => 'glpi_appliances_items',
            'field' => 'id',
            'name' => _x('quantity', 'Applicatifs'),
            'forcegroupby' => true,
            'usehaving' => true,
            'datatype' => 'count',
            'massiveaction' => false,
            'joinparams' => [
                'jointype' => 'itemtype_item'
            ]
        ];

        $tab[] = [
            'id' => '104',
            'table' => 'glpi_plugin_dlteams_accountkeys_items',
            'field' => 'id',
            'name' => _x('quantity', "Clés d'accès"),
            'forcegroupby' => true,
            'usehaving' => true,
            'datatype' => 'count',
            'massiveaction' => false,
            'joinparams' => [
                'jointype' => 'itemtype_item'
            ]
        ];

//        $tab[] = [
//            'id' => '105',
//            'table' => 'glpi_plugin_dlteams_records_items',
//            'field' => 'id',
//            'name' => _x('quantity', 'Traitements'),
//            'forcegroupby' => true,
//            'usehaving' => true,
//            'datatype' => 'count',
//            'massiveaction' => false,
//            'joinparams' => [
//                'jointype' => 'itemtype_item'
//            ]
//        ];

        $tab[] = [
            'id'                 => '105',
            'table'              => PluginDlteamsDataCatalog_Item::getTable(),
            'field'              => 'items_id',
            'name'               => _x('quantity','Traitements'),
            'datatype'           => 'specific', //'itemlink',
            'comments'           => true,
            'nosort'             => false,
            'additionalfields'   => ['itemtype'],
            'joinparams'         => [
                'linkfield' => 'datacatalogs_id',
                'jointype'           => 'child',
                'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsRecord::class."'",
            ],
            'forcegroupby'       => true,
            'massiveaction'      => false,
            'htmltext'           => true,
            'showrecord' => true
            //'dlteams_activityname' => true,
        ];

//        $tab[] = [
//            'id' => '106',
//            'table' => 'glpi_plugin_dlteams_protectivemeasures_items',
//            'field' => 'id',
//            'name' => _x('quantity', 'Mesures Protection'),
//            'forcegroupby' => true,
//            'usehaving' => true,
//            'datatype' => 'count',
//            'massiveaction' => false,
//            'joinparams' => [
//                'jointype' => 'itemtype_item'
//            ]
//        ];

        
        $tab[] = [
            'id'                 => '106',
            'table'              => PluginDlteamsDataCatalog_Item::getTable(),
            'field'              => 'items_id',
            'name'               => _x('quantity','Mesures Protection'),
            'datatype'           => 'specific', //'itemlink',
            'comments'           => true,
            'nosort'             => false,
            'additionalfields'   => ['itemtype'],
            'joinparams'         => [
                'linkfield' => 'datacatalogs_id',
                'jointype'           => 'child',
                'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsProtectiveMeasure::class."'",
            ],
            'forcegroupby'       => true,
            'massiveaction'      => false,
            'htmltext'           => true,
            'showprotectiveMeasure' => true
            //'dlteams_activityname' => true,
        ];

        $tab[] = [
            'id' => '108',
            'table' => 'glpi_plugin_dlteams_datacenters_items',
            'field' => 'id',
            'name' => _x('quantity', 'Datacenter'),
            'forcegroupby' => true,
            'usehaving' => true,
            'datatype' => 'count',
            'massiveaction' => false,
            'joinparams' => [
                'jointype' => 'itemtype_item'
            ]
        ];

        $tab[] = [
            'id' => '109',
            'table' => 'glpi_computers_items',
            'field' => 'id',
            'name' => _x('quantity', 'Pcs'),
            'forcegroupby' => true,
            'usehaving' => true,
            'datatype' => 'count',
            'massiveaction' => false,
            'joinparams' => [
                'jointype' => 'itemtype_item'
            ]
        ];

        $tab[] = [
            'id' => '110',
            'table' => 'glpi_plugin_dlteams_physicalstorages_items',
            'field' => 'id',
            'name' => _x('quantity', 'Mob.'),
            'forcegroupby' => true,
            'usehaving' => true,
            'datatype' => 'count',
            'massiveaction' => false,
            'joinparams' => [
                'jointype' => 'itemtype_item'
            ]
        ];

        return $tab;
    }

    public function canShowAnnuaireTab()
    {
        $id = $this->fields["id"];
        $query = "SELECT t1.*
FROM glpi_plugin_dlteams_datacatalogs AS t1
JOIN glpi_plugin_dlteams_datacatalogs AS t2
ON (
    (LOCATE('>', t2.`completename`) > 0 AND LEFT(t2.`completename`, LOCATE('>', t2.`completename`) - 1) = LEFT(t1.`completename`, LOCATE('>', t1.`completename`) - 1) 
    OR 
     (LOCATE('>', t2.`completename`) > 0 AND LEFT(t2.`completename`, LOCATE('>', t2.`completename`) - 1) = t1.`completename`)) 
    OR 
    (LOCATE('>', t2.`completename`) = 0 AND t2.`completename` = t1.`completename`)
    OR 
    (LOCATE('>', t2.`completename`) = 0 AND t2.`completename` = LEFT(t1.`completename`, LOCATE('>', t1.`completename`) - 1))
)
WHERE t2.id = $id;";

        global $DB;
        $result = [];
        $req = $DB->request($query);

        $findmanagekey = false;
        if (count($req)) { // oui existe -> on quitte
            foreach ($req as $idtemp => $row) {
                $result[] = $row["id"];
                if ($row["manage_accountkey"])
                    $findmanagekey = true;
            }
        }

        return in_array($id, $result) && $findmanagekey;
    }

    public function defineTabs($options = [])
    {
        $ong = [];
        $this->addDefaultFormTab($ong);
        // l'onglet Sous-catalogues n'apparait que si il existe des sous catalogues -> pas cohérent
        // if (!$this->fields["plugin_dlteams_datacarriercategories_id"])
        $this->addStandardTab('PluginDlteamsDataCatalog', $ong, $options);
        // if (!$this->fields["plugin_dlteams_datacatalogs_id"]) // si le catalogue est root
        $this->addStandardTab(PluginDlteamsDatacatalog_External::class, $ong, $options);
        $this->addStandardTab(PluginDlteamsPolicieForm_Item::class, $ong, $options);
        if ($this->fields["plugin_dlteams_datacarriercategories_id"] != 2)
            $this->addStandardTab(PluginDlteamsAppliance_Item::class, $ong, $options);

        if ($this->canShowAnnuaireTab() && $this->fields["keyrequired"])
            $this->addStandardTab(PluginDlteamsAccountKey_Directory::class, $ong, $options);
        if (!$this->fields["is_helpdesk_visible"])
            $this->addStandardTab(PluginDlteamsAccountKey_Item::class, $ong, $options);
        if ($this->canShowAnnuaireTab() && $this->fields["keyrequired"])
            $this->addStandardTab(PluginDlteamsAcces_Catalog::class, $ong, $options);
        $this->addStandardTab(PluginDlteamsRiskAssessment_Item::class, $ong, $options);
        $this->addStandardTab('PluginDlteamsDatacatalog_Protectivemeasure', $ong, $options);
        if (!$this->fields["plugin_dlteams_datacatalogs_id"]) {
            $this->addStandardTab('PluginDlteamsDataCatalogStorage_Item', $ong, $options);
        }
        $this->addImpactTab($ong, $options);
        $this->addStandardTab('PluginDlteamsObject_document', $ong, $options)
            //->addStandardTab('PluginDlteamsDataCatalog_Item', $ong, $options)
            ->addStandardTab('Notepad', $ong, $options)
            ->addStandardTab('KnowbaseItem_Item', $ong, $options)
            ->addStandardTab(PluginDlteamsTicket_Item::class, $ong, $options)
            ->addImpactTab($ong, $options)
            ->addStandardTab('Log', $ong, $options);
        return $ong;
    }

    private function showDatacarrierCategoryTab($type, $key)
    {
        return $this->fields["plugin_dlteams_datacarriercategories_id"] == $key;
    }


    private function canShowTabOfItemtype($itemtype, $items_id)
    {
        $request = [
            "FROM" => PluginDlteamsDataCatalog_Item::getTable(),
            "WHERE" => [
                "datacatalogs_id" => $this->fields["id"],
                "itemtype" => PluginDlteamsMeansOfAcce::class,
                "items_id" => $items_id
            ]
        ];
        global $DB;
        $iterator = $DB->request($request);
        return count($iterator) > 0;
    }

    function exportToDB($subItems = [])
    {
        if ($this->isNewItem()) {
            return false;
        }
        $export = $this->fields;
        return $export;
    }

    public static function importToDB(PluginDlteamsLinker $linker, $input = [], $containerId = 0, $subItems = [])
    {
        $item = new self();
        $originalId = $input['id'];
        unset($input['id']);
        $input['entities_id'] = $_POST['entities_id'];
        $input['comment'] = str_replace(['\'', '"'], "", $input['comment']);
        $input['name'] = str_replace(['\'', '"'], "", $input['name']);
        $input['content'] = str_replace(['\'', '"'], "", $input['content']);
        $itemId = $item->add($input);
        if ($itemId === false) {
            $typeName = strtolower(self::getTypeName());
            throw new ImportFailureException(sprintf(__('failed to copy the %1$s record', 'dlteams'), $input['name']));
        }
        return $itemId;
    }

    public function deleteObsoleteItems(CommonDBTM $container, array $exclude)
    {

    }


    public function copy1($entity, $id, $item)
    {
        global $DB;
        $dbu = new DbUtils();
        $name = $item->fields['name'];

        $nb = $dbu->countElementsInTable(static::getTable(), ['name' => addslashes($name), 'entities_id' => $entity]);

//        $req = $DB->request("SELECT * FROM `glpi_plugin_dlteams_datacatalogs` WHERE `entities_id` = $entitiesB_id AND `name` = (SELECT `name` FROM `glpi_plugin_dlteams_datacatalogs` WHERE `id` = $id)");


        // var_dump (count($req)) ;
//        if (count($req)) { // oui existe -> on quitte
//            foreach ($req as $id => $row) {
//                $id = $row['id'];
//                // pour tests -- $DB->request("DELETE FROM glpi_plugin_dlteams_records WHERE id = $id");
//                // var_dump ("Traitement déjà existant (entité, record) : ", $entitiesB_id,", ", $id);
//                $message .= (sprintf(__('Catalogue de données déjà existant : %s', 'dlteams'), $item->getName())) . nl2br("\n") ;
//            }
//            Session::addMessageAfterRedirect($message, false, ERROR);
//            Html::back();
//        }

        $dt = new PluginDlteamsDataCatalog();
        $dt->getFromDB($id);

//        copy the new catalog
        $datacatalog = new PluginDlteamsDataCatalog();


        if ($nb <= 0) {
//            $DB->request("INSERT INTO " . static::getTable() . " (entities_id, is_recursive, date_mod, date_creation, name, content, comment, plugin_dlteams_rightmeasurecategories_id) SELECT '$entity', is_recursive, date_mod, date_creation, name, content, comment, 0 FROM " . static::getTable() . " WHERE id='$id'");
            $datacatalog = new PluginDlteamsDataCatalog();
            $datacatalog->add([
                "name" => addslashes($dt->fields["name"]),
                "content" => addslashes($dt->fields["content"]),
                "plugin_dlteams_catalogclassifications_id" => $dt->fields["plugin_dlteams_catalogclassifications_id"],
                "plugin_dlteams_datacarriercategories_id" => $dt->fields["plugin_dlteams_datacarriercategories_id"],
                "entities_id" => $entity,
            ]);
            $newid = $datacatalog->fields["id"];

            $relations_to_copy = [
                PluginDlteamsPolicieForm::class,
                PluginDlteamsAppliance::class,
                PluginDlteamsProtectiveMeasure::class
            ];

            $DB->request("INSERT INTO " . PluginDlteamsDataCatalog_Item::getTable() . " (datacatalogs_id, items_id, itemtype, comment) SELECT '$newid', items_id, itemtype, comment FROM " . PluginDlteamsDataCatalog_Item::getTable() . " WHERE datacatalogs_id='$id' AND (itemtype='PluginDlteamsPolicieForm' OR itemtype='PluginDlteamsAppliance' OR itemtype='PluginDlteamsProtectiveMeasure')");
            $DB->request("INSERT INTO " . PluginDlteamsPolicieForm_Item::getTable() . " (policieforms_id, items_id, itemtype, comment) SELECT policieforms_id, '$newid', itemtype, comment FROM " . PluginDlteamsPolicieForm_Item::getTable() . " WHERE itemtype='PluginDlteamsDataCatalog' AND items_id='$id'");
            $DB->request("INSERT INTO " . Appliance_Item::getTable() . " (appliances_id, items_id, itemtype, comment) SELECT appliances_id, '$newid', itemtype, comment FROM " . Appliance_Item::getTable() . " WHERE itemtype='PluginDlteamsDataCatalog' AND items_id='$id'");
            $DB->request("INSERT INTO " . PluginDlteamsProtectiveMeasure_Item::getTable() . " (protectivemeasures_id, items_id, itemtype, comment) SELECT protectivemeasures_id, '$newid', itemtype, comment FROM " . PluginDlteamsProtectiveMeasure_Item::getTable() . " WHERE itemtype='PluginDlteamsDataCatalog' AND items_id='$id'");

            return true;
        } else {
            return false;
        }
    }


}

?>

