<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */


use GlpiPlugin\dlteams\Exception\ImportFailureException;

class PluginDlteamsDataCatalog_Otherdirectory_Ma extends CommonDBTM{

    static public $itemtype_2 = 'PluginDlteamsDataCatalog';

    static function canCreate()
    {
        return true;
    }

    static function canView()
    {
        return true;
    }
//
    static function canUpdate()
    {
        return true;
    }

    static function canDelete()
    {
        return true;
    }

    static function canPurge()
    {
        return true;
    }

    function canCreateItem()
    {
        return true;
    }

    function canViewItem()
    {
        return true;
    }

    function canUpdateItem()
    {
        return true;
    }

    function canDeleteItem()
    {
        return true;
    }

    function canPurgeItem()
    {
        return true;
    }


    public static function getTable($classname = null)
    {
        return PluginDlteamsDataCatalog::getTable(); // TODO: Change the autogenerated stub
    }

    public function rawSearchOptions()
    {
        return parent::rawSearchOptions(); // TODO: Change the autogenerated stub
    }


    public function getForbiddenStandardMassiveAction()
    {
        $forbidden = parent::getForbiddenStandardMassiveAction();
        $forbidden[] = 'clone';
        $forbidden[] = 'MassiveAction:add_transfer_list';
        $forbidden[] = 'MassiveAction:amend_comment';
        $forbidden[] = 'MassiveAction:update';
        $forbidden[] = 'MassiveAction:delete';
        return $forbidden;
    }

    public function getSpecificMassiveActions($checkitem = NULL)
    {
        $actions = parent::getSpecificMassiveActions($checkitem);
        // add a single massive action
        $class = __CLASS__;
        $action_key = "delete_dlteams_action";
        $action_label = _n("Supprimer", "Supprimer", 0, "dlteams");

        $actions[$class . MassiveAction::CLASS_ACTION_SEPARATOR . $action_key] = $action_label;

        return $actions;
    }

    public static function showMassiveActionsSubForm(MassiveAction $ma)
    {
        switch ($ma->getAction()) {
            case 'delete_dlteams_action':
                echo "<tr class='tab_bg_1'><td width='24%' style='display: flex; align-items: center; gap: 5px'>";

//                echo '<br /><br />' . Html::submit(_x('button', 'Post'), ['name' => 'massiveaction']);
                echo '<br /><br />' . Html::submit(_x('button', 'Post'), ['name' => 'massiveaction', 'class' => 'btn btn-primary btn-xs']);
                echo "</td></tr>";
                return true;
                break;
        }
        return parent::showMassiveActionsSubForm($ma); // TODO: Change the autogenerated stub
    }




    public static function processMassiveActionsForOneItemtype(MassiveAction $ma, CommonDBTM $item, array $ids)
    {

        switch ($ma->getAction()){
            case 'delete_dlteams_action':
                foreach ($ids as $id){
                    $datacatalog_item = new PluginDlteamsDataCatalog_Item();
//            $datacatalog->getFromDB($id);

                    $datacatalog_item->delete([
                        "id" => $id
                    ]);
                }
                $ma->itemDone(__CLASS__, $id, MassiveAction::ACTION_OK);
                return true;
                break;
        }
        parent::processMassiveActionsForOneItemtype($ma, $item, $ids); // TODO: Change the autogenerated stub
    }


}
