<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */


use GlpiPlugin\dlteams\Exception\ImportFailureException;
class PluginDlteamsDataCatalogStorage_Item extends CommonDBTM
{
    static function canCreate() {return true;}
    static function canView() {return true;}
    static function canUpdate() {return true;}
    static function canDelete() {return true;}
    static function canPurge() {return true;}
    function canCreateItem() {return true;}
    function canViewItem() {return true;}
    function canUpdateItem() {return true;}
    function canDeleteItem() {return true;}
    function canPurgeItem() {return true;}
    static function getTypeName($nb = 0)
    {
        return __("Stockages physique"); //Conteneurs de stockage
    }

    public static $items_id_1;
    public static $itemtypes_list = [
        'Datacenter',
        'Computer',
        'NetworkEquipment',
        'Peripheral',
        'Printer',
        'Phone',
        'PluginDlteamsPhysicalStorage',
        'PluginDlteamsDataCatalog'
    ];

    public function __construct()
    {
        static::$items_id_1 = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", PluginDlteamsDataCatalog_Item::class))) . "s_id";
        self::forceTable(PluginDlteamsDataCatalog_Item::getTable());
        parent::__construct();
    }

    public static function getTable($classname = null)
    {
        return PluginDlteamsDataCatalog_Item::getTable(); // TODO: Change the autogenerated stub
    }

    public function post_purgeItem()
    {
//        purge relations
        $relation_item_str = $this->fields["itemtype"] . "_Item";
        if(!class_exists($relation_item_str))
            $relation_item_str = "PluginDlteams".$relation_item_str;
        $relation_item = new $relation_item_str();

        $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype"]))) . "s_id";

        $criteria = [
            "itemtype" => "PluginDlteamsDataCatalog",
            "items_id" => $this->fields["datacatalogs_id"],
            $relation_column_id => $this->fields["items_id"],
            "comment" => $this->fields["comment"]
        ];

        $relation_item->deleteByCriteria($criteria);
    }

    public function post_updateItem($history = 1)
    {
        $relation_item_str = $this->fields["itemtype"] . "_Item";
        if(!class_exists($relation_item_str))
            $relation_item_str = "PluginDlteams".$relation_item_str;
        $relation_item = new $relation_item_str();
        $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype"]))) . "s_id";

        $criteria = [
            "itemtype" => "PluginDlteamsDataCatalog",
            "items_id" => $this->fields["datacatalogs_id"],
            $relation_column_id => $this->fields["items_id"],
            "comment" => $this->oldvalues["comment"]
        ];

        $relation_item->deleteByCriteria($criteria);
        $relation_item->add([
            ...$criteria,
            "comment" => $this->fields["comment"]
        ]);
    }

    static function getTypeNameForClass($nb = 0) {
        return __("Stockages", 'dlteams');
    }
    // affichage de l'onglet et de son nom
    function getTabNameForItem(CommonGLPI $item, $withtemplate = 0) {
        if (!$item->canView()) {
            return false;
        }
        switch ($item->getType()) {
            case PluginDlteamsDataCatalog::class :
                $nb = 0;
                if ($_SESSION['glpishow_count_on_tabs']) {
                    $nb = self::countForRecord($item);
                }
                return self::createTabEntry(PluginDlteamsDataCatalogStorage_Item::getTypeName($nb), $nb);
        }
        return '';
    }

    // comptage du nombre de liaison entre les 2 objets dans la table de l'objet courant
    static function countForRecord($record) {
        global $DB;
        $items_list = [];
        $iterator = $DB->request(self::getRequest($record));
        foreach ($iterator as $id => $data) {
            array_push($items_list, $data);
        }
        return count($items_list);
    }

    static function getRequest($record) {
        return [
            'SELECT' => [
                'glpi_plugin_dlteams_datacatalogs_items.id AS linkid',
            ],
            'FROM' => 'glpi_plugin_dlteams_datacatalogs_items',
            'WHERE' => [
                'OR' => [
                    [   'glpi_plugin_dlteams_datacatalogs_items.datacatalogs_id' => $record->fields['id'],
                        'glpi_plugin_dlteams_datacatalogs_items.itemtype' => 'Datacenter',
                    ],
                    [   'glpi_plugin_dlteams_datacatalogs_items.datacatalogs_id' => $record->fields['id'],
                        'glpi_plugin_dlteams_datacatalogs_items.itemtype' => 'Printer',
                    ],
                    [   'glpi_plugin_dlteams_datacatalogs_items.datacatalogs_id' => $record->fields['id'],
                        'glpi_plugin_dlteams_datacatalogs_items.itemtype' => 'NetworkEquipement',
                    ],
                    [   'glpi_plugin_dlteams_datacatalogs_items.datacatalogs_id' => $record->fields['id'],
                        'glpi_plugin_dlteams_datacatalogs_items.itemtype' => 'Computer',
                    ],
                    [   'glpi_plugin_dlteams_datacatalogs_items.datacatalogs_id' => $record->fields['id'],
                        'glpi_plugin_dlteams_datacatalogs_items.itemtype' => 'PluginDlteamsPhysicalStorage',
                    ],
                    [   'glpi_plugin_dlteams_datacatalogs_items.datacatalogs_id' => $record->fields['id'],
                        'glpi_plugin_dlteams_datacatalogs_items.itemtype' => 'Peripheral',
                    ],
                    [   'glpi_plugin_dlteams_datacatalogs_items.datacatalogs_id' => $record->fields['id'],
                        'glpi_plugin_dlteams_datacatalogs_items.itemtype' => 'Phone',
                    ]
                ],
            ]
        ];
    }

    public static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {
        self::showItems($item);
    }

    public static function showItems(PluginDlteamsDataCatalog $object_item)
    {

        global $DB;
        $instID = $object_item->fields['id'];
        if (!$object_item->can($instID, READ)) {
            return false;
        }
        $canedit = $object_item->can($instID, UPDATE);
        // for a measure,
        // don't show here others protective measures associated to this one,
        // it's done for both directions in self::showAssociated
        $types_iterator = [];
        $number = count($types_iterator);

        $used = [];
        $types = static::$itemtypes_list;

        $rand = mt_rand();

        if ($canedit) {
            echo "<form name='datacatalogitem_form$rand' id='datacatalogitem_form$rand' method='post'
            action='" . Toolbox::getItemTypeFormURL(PluginDlteamsElementsRGPD::class) . "'>";
            echo "<input type='hidden' name='" . static::$items_id_1 . "' value='$instID'>";
            echo "<input type='hidden' name='itemtype1' value='" . str_replace("_Item", "", PluginDlteamsDataCatalog_Item::class) . "'>";
            echo "<input type='hidden' name='items_id1' value='" . $instID . "'>";
            echo "<input type='hidden' name='link_element' value='" . true . "'>";

            echo "<table class='tab_cadre_fixe'>";
            $title = "Stockages pour ce catalogue";
            $entitled = "Ajoutez un élément où se trouvent stockées des données";
            echo "<tr class='tab_bg_2'><th colspan='3'>" . __($title, 'dlteams') .
                "</th>";
            echo "</tr>";

            echo "<tr class='tab_bg_1'><td class='right' style='text-wrap: nowrap;' width='40%'>" . __($entitled, 'dlteams');
            echo "</td><td width='40%' class='left'>";

//            ech
            echo "<div style='display: flex; gap: 4px;'>";

            Dropdown::showSelectItemFromItemtypes(['itemtypes' => $types,
                'checkright' => true,
                'used' => $used,
                'ajax_page' => "/marketplace/dlteams/ajax/dlteamsDropdownAllItem.php"
            ]);
            echo "</div>";
            unset($types);
            echo "</td><td width='20%' class='left'>";
            echo "</td></tr>";

            echo "<tr class='tab_bg_1' style='display: none' id='field_comment'><td class='right' width='40%'>" . __("Comment");
            echo "</td><td width='40%' class='left comment-td'>";
            echo "<div style='display: flex; gap: 4px;'>";
            echo "<div>";
            echo "<textarea type='text' style='width:100%' maxlength=1000 rows='3' name='comment' class='comment'></textarea>";

            if($object_item::getType() == PluginDlteamsDataCatalog::class) {
                echo "<div style='display: flex; align-items: center; gap: 3px;'>";
                Html::showCheckbox([
                    'name' => 'apply_on_childs',
                    'checked' => true
                ]);
                echo "<label>les catalogues enfants héritent automatiquement</label>";
                echo "</div>";
            }

            echo "</div>";
            echo "</div>";
            echo "</td><td width='20%' class='left'>";
            echo "</td></tr>";
            echo "<style>
                .comment-td {width: 40%;}
                @media (max-width: 767px) {.comment-td {width: 100%;}}
              </style>";

            echo "<tr class='tab_bg_1' style='display: none' id='submit'><td class='right' width='40%'>";
            echo "</td><td width='40%' class='left'>";

            echo "<div style='display: flex; gap: 4px;'>";
            echo "<input for='datacatalogitem_form$rand' type='submit' name='add' value=\"" . _sx('button', 'Add') . "\" class='submit'>";
            echo "</div>";
            echo "</td><td width='20%' class='left'>";
            echo "</td></tr>";

            echo "</table>";
            Html::closeForm();
        }

        echo "<script>
                $(document).ready(function(e){
                    $(document).on('change', 'select[name=items_id]', function () {
                       
                        if($(this).val() != '0'){
                            $('#field_comment').css('display', 'revert');
                            $('#submit').css('display', 'revert');
                            
                            $.ajax({
                                url: '/marketplace/dlteams/ajax/get_object_specific_field.php',
                                type: 'POST',
                                data: {
                                    id: $(this).val(),
                                    object: $('select[name=itemtype]').val(),
                                    field: 'content'
                                },
                                success: function (data) {
                                    // Handle the returned data here
                                    let comm_field = $('textarea[name=comment]');
                                    comm_field.val(data);
                                    comm_field.val(comm_field.val().replace(/^\s+/, ''));
                                }
                            });  
                        } else {
                            $('textarea[name=comment]').val('');
                            $('#submit').css('display', 'none');
                            $('#field_comment').css('display', 'none');   
                        }
                    });
                });
        </script>";

//        var_dump(self::getTable());
        $items = self::getItemsRequest($object_item);

        if (!count($items)) {
            echo "<table class='tab_cadre_fixe'><tr><th>" . __('No item found') . "</th></tr>";
            echo "</table>";
        }
        else {
            if ($canedit) {
                Html::openMassiveActionsForm('mass' . __CLASS__ . $rand);
                $massiveactionparams = [
                    'num_displayed' => min($_SESSION['glpilist_limit'], count($items)),
                    'container' => 'mass' . __CLASS__ . $rand
                ];
                Html::showMassiveActions($massiveactionparams);
            }

            echo "<table class='tab_cadre_fixehov'>";
            $header = "<tr>";
            if ($canedit) {
                    $header .= "<th width='10'>";
                    $header .= Html::getCheckAllAsCheckbox('mass' . __CLASS__ . $rand);
                    $header .= "</th>";
            }
            $header .= "<th>" . __("Element") . "</th>";
            $header .= "<th>" . __("Type") . "</th>";
            $header .= "<th>" . __("Comment") . "</th>";
            $header .= "</tr>";
            echo $header;

            foreach ($items as $row) {
                $item = new $row['itemtype'](); //plante si itemtype is null
                $item->getFromDB($row['items_id']);
                $name = "<a target='_blank' href=\"" . $item::getFormURLWithID($item->getField('id')) . "\">" . $item->getField('name') . "</a>";
                echo "<tr lass='tab_bg_1'>";
                if ($canedit) {
                    echo "<td>";
                    Html::showMassiveActionCheckBox(__CLASS__, $row["id"]);
                    echo "</td>";
                }
                echo "<td>" . $name . "</td>";
                echo "<td>" . $row["itemtype"]::getTypeName() . "</td>";
                echo "<td>" . $row['comment'] . "</td>";
                echo "</tr>";
            }
            //echo $header;
            echo "</table>";

            /*if ($canedit && count($items)) {
                $massiveactionparams['ontop'] = false;
                Html::showMassiveActions($massiveactionparams);
            }*/
            if ($canedit) {
                Html::closeForm();
            }
        }
    }

    function rawSearchOptions()
    {
        $tab[] = [
            'id' => '44',
            'table' => static::getTable(),
            'field' => 'comment',
            'datatype' => 'text',
            'name' => __("Commentaire"),
            'forcegroupby' => true,
            'massiveaction' => true,
        ];

        return $tab;
    }

    public function getForbiddenStandardMassiveAction()
    {
        $forbidden = parent::getForbiddenStandardMassiveAction();
        $forbidden[] = 'clone';
        $forbidden[] = 'MassiveAction:add_transfer_list';
        $forbidden[] = 'MassiveAction:amend_comment';
        return $forbidden;
    }

    public static function getItemsRequest(CommonDBTM $object_item)
    {
        global $DB;
        $link_table = str_replace("_Item", "", PluginDlteamsDataCatalog_Item::class);
        $temp = new $link_table();

        $query = [
            'FROM' => self::getTable(),
            'SELECT' => [
                self::getTable() . '.id',
                self::getTable() . '.id as linkid',
                self::getTable() . '.comment',
                self::getTable() . '.itemtype as itemtype',
                self::getTable() . '.items_id as items_id',
            ],
//            'WHERE' => [
//                static::getTable() . '.' . static::$items_id_1 => $object_item->fields['id']
//            ],
            'LEFT JOIN' => [
                $temp->getTable() => [
                    'FKEY' => [
                        static::getTable() => static::$items_id_1,
                        $temp->getTable() => 'id'
                    ]
                ]
            ],
            'ORDER' => [$temp->getTable().'.name ASC'],
        ];

        foreach (static::$itemtypes_list as $itemtype){
            $query['WHERE']['OR'][] = [
                'itemtype' => $itemtype,
                static::getTable() . '.' . static::$items_id_1 => $object_item->fields['id']
            ];
        }

        $items = $DB->request($query);

        return iterator_to_array($items);
    }
}
