<?php

use Glpi\RichText\UserMention;

/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2023 Teclib' and contributors.
 * @copyright 2003-2014 by the INDEPNET Development Team.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */

/// Class KnowbaseItem_Comment
/// since version 9.2
class PluginDlteamsMessage extends CommonDBTM
{
    public static $rightname = 'plugin_dlteams_message';
    public $dohistory = true;
    protected $usenotepad = true;

    // TYPES
    const DEFAULT = 1;
    const TICKETTASKREPORT = 2; // Comptes rendu
    const TICKETTASKCONTROL = 3; // COntroles
    const SENDMAIL = 4; // rejected


    public static function getIcon()
    {
        return 'fas fa-comments';
    }

    public static function getMenuContent()
    {
        return parent::getMenuContent(); // TODO: Change the autogenerated stub
    }


    public function canAddItem($type)
    {
        return parent::canAddItem($type); // TODO: Change the autogenerated stub
    }

    public function canCreateItem()
    {
        return parent::canCreateItem(); // TODO: Change the autogenerated stub
    }

    public function canUpdateItem()
    {
        return parent::canUpdateItem(); // TODO: Change the autogenerated stub
    }

    public function canDeleteItem()
    {
        return parent::canDeleteItem(); // TODO: Change the autogenerated stub
    }

    public function canPurgeItem()
    {
        return true;
    }

    public function canViewItem()
    {
        return true;
    }

    public static function canCreate()
    {
        return true;
    }

    public static function canView()
    {
        return true;
    }

    public static function canUpdate()
    {
        return true;
    }

    public static function canDelete()
    {
        return true;
    }

    public static function canPurge()
    {
        return true;
    }

//    protected static $notable = true;


    public function __construct()
    {
        parent::forceTable("glpi_plugin_dlteams_messages");
    }

    public static function getTypeName($nb = 0)
    {
        return _n('Messages', 'Messages', $nb);
    }

    public static function getTable($classname = null)
    {
        return "glpi_plugin_dlteams_messages";
    }


    public static function getSpecificValueToDisplay($field, $values, array $options = [])
    {
        if (isset($options["searchopt"]["contentfield"]) && $options["searchopt"]["contentfield"]) {
            $content = $values["content"];

            $output = "";

            $output .= htmlspecialchars_decode($content);

            return $output;
        } elseif (isset($options["searchopt"]["objectfield"]) && $options["searchopt"]["objectfield"]) {
            $itemtype_str = $values["itemtype"];


            if (class_exists($itemtype_str))
                $itemtype = $itemtype_str::getTypeName();
            else
                $itemtype = $itemtype_str;

            return $itemtype;
        } elseif (isset($options["searchopt"]["dlteams_specific_itemtype"]) && $options["searchopt"]["dlteams_specific_itemtype"]) {
            /*            highlight_string("<?php\n\$data =\n" . var_export($values["id"], true) . ";\n?>");*/
//            die();
            $id = $values["id"];
            $if = new ITILFollowup();
            $if->getFromDB($id);


            $itemtype_str = $if->fields["itemtype"];
            if ($itemtype_str == PluginDlteamsTicketTask::class)
                $itemtype_str = TicketTask::class;
            $itemtype = new $itemtype_str();
            $output = "";


            $url = $itemtype::getFormURLWithID($if->fields["items_id"]);
            $output .= "<a href='$url' target='_blank'>" . $if->fields["items_id"] . "</a>";

            return $output;
        } elseif (isset($options["searchopt"]["objectfield_display_id"]) && $options["searchopt"]["objectfield_display_id"]) {
            /*                        highlight_string("<?php\n\$data =\n" . var_export($values["id"], true) . ";\n?>");*/
//            die();
            $id = $values["id"];
            $if = new ITILFollowup();
            $if->getFromDB($id);


            $itemtype_str = $if->fields["itemtype"];
            if ($itemtype_str == PluginDlteamsTicketTask::class)
                $itemtype_str = TicketTask::class;
            $itemtype = new $itemtype_str();
            $output = "";

            $url = $itemtype::getFormURLWithID($if->fields["items_id"]) . "&forcetab=PluginDlteamsMessage$1&#kbcomment" . $if->fields["id"];
            $output .= "<a href='$url' target='_blank'>" . $if->fields["id"] . "</a>";

            return $output;
        }
        parent::getSpecificValueToDisplay($field, $values, $options);
    }

    public function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {
        switch ($item->getType()) {
            default:
                $nb = 0;
                if ($_SESSION['glpishow_count_on_tabs']) {

                    $where = [
                        'items_id' => $item->fields['id'],
                        'itemtype' => $item->getType()
                    ];

                    $nb = countElementsInTable(
                        ITILFollowup::getTable(),
                        $where
                    );


                    if ($where['itemtype'] == PluginDlteamsTicketTask::class) {
                        $tickettask = new TicketTask();
                        $tickettask->getFromDB($item->fields["id"]);

//           get planifications tasks
                        $planification_task_query = [
                            "FROM" => TicketTask::getTable(),
                            "WHERE" => [
                                "tickettasks_id" => $item->fields["id"]
                            ]
                        ];

                        global $DB;
                        $iterator = $DB->request($planification_task_query);

                        $planif_count_messages = 0;
                        foreach ($iterator as $pt) {
                            $planif_count_messages += count(self::getCommentsForKbItem($pt['id'], $where['itemtype'], null, true));
                        }
                        $nb += $planif_count_messages;
                    }

                    if ($where['itemtype'] == Ticket::class) {
                        $task_query = [
                            "FROM" => TicketTask::getTable(),
                            "WHERE" => [
                                "tickets_id" => $item->fields["id"]
                            ]
                        ];

                        global $DB;
                        $iterator = $DB->request($task_query);

                        $planif_count_messages = 0;
                        foreach ($iterator as $pt) {
                            $planif_count_messages += count(self::fetchComments($pt['id'], PluginDlteamsTicketTask::class));
                        }

//                tasks messages
                        $task_message_count = 0;
                        foreach ($iterator as $pt) {
                            $task_message_count += count(self::fetchComments($pt['id'], PluginDlteamsTicketTask::class));
                        }

                        $total = $nb + $task_message_count;
                        if ($task_message_count > 0)
                            $nb = "$nb + $task_message_count ($total)";
                    }


                }
                return [
//                    1 => self::createTabEntry("Messages", $nb)
                    1 => self::createTabEntry("Messages", count(self::fetchComments($item->fields["id"], $item->getType())))
                ];
                break;
        }
    }


    public static function showCentralList()
    {
        /** @var \DBmysql $DB */
        global $DB;

        $criteria = [
            'SELECT' => [PluginDlteamsMessage::getTable() . ".*"],
            'DISTINCT' => true,
            'FROM' => PluginDlteamsMessage::getTable(),
//            'WHERE'           => $WHERE + getEntitiesRestrictCriteria('glpi_tickets'),
            'ORDERBY' => PluginDlteamsMessage::getTable() . '.date_mod DESC'
        ];

        $iterator = $DB->request($criteria);
        $total_row_count = count($iterator);
        $displayed_row_count = min((int)$_SESSION['glpidisplay_count_on_home'], $total_row_count);
        $displayed_row_count = 10;

        if ($total_row_count > 0) {
            $options = [
                'criteria' => [],
                'reset' => 'reset',
            ];
            $forcetab = '';


            $main_header = "<a href=\"" . Ticket::getSearchURL() . "\">" .
                Html::makeTitle(__('Mes messages'), 0, 0) . "</a>";
            $twig_params = [
                'class' => 'table table-borderless table-striped table-hover card-table',
                'header_rows' => [
                    [
                        [
                            'colspan' => 4,
                            'content' => $main_header
                        ]
                    ]
                ],
                'rows' => []
            ];

            $i = 0;
            if ($displayed_row_count > 0) {
                $twig_params['header_rows'][] = [
                    [
                        'content' => __('ID'),
                        'style' => 'width: 5%'
                    ],
                    [
                        'content' => _n('Objet', 'Objets', 1),
                        'style' => 'width: 15%'
                    ],
                    [
                        'content' => _n('Elément', 'Eléments', 1),
                        'style' => 'width: 15%'
                    ],
                    [
                        'content' => _n('Contenu', 'Contenu', Session::getPluralNumber()),
                        'style' => 'width: 20%'
                    ],
//                    __('Description')
                ];
                foreach ($iterator as $data) {

                    if (class_exists($data["itemtype"])) {
                        $row = [
                            'values' => []
                        ];
                        $element = new  $data["itemtype"]();
                        $element->getFromDB($data["items_id"]);
                        $element = isset($element->fields["name"]) ? $element->fields["name"] : $element->fields["id"];
                        $content = substr(html_entity_decode($data["content"]), 0, 30) ?? "--";
                        $row['class'] = 'tab_bg_2';
                        $row['values'] = [
                            [
                                'colspan' => 6,
                                'content' => '<tr class="">
                                          <td colspan="1" class="" style=""><div class="priority_block" style="border-color: #ffcece"><span style="background: #ffcece"></span>&nbsp;ID : ' . $data["id"] . '</div></td>
                                          <td colspan="1" class="" style="">' . $data["itemtype"]::getTypeName() . '</td>
                                          <td colspan="1" class="" style="">' . $element . '</td>
                                          <td colspan="1" class="" style=""><a href="#">' . $content . '</a></td>
                     </tr>'
                            ]
                        ];

                        $twig_params['rows'][] = $row;

                        $i++;
                        if ($i == $displayed_row_count) {
                            break;
                        }
                    }
                }
                if (count($iterator) == 0) {
                    $row = [
                        'values' => []
                    ];

                    $row['class'] = 'tab_bg_2';
                    $row['values'] = [
                        [
                            'colspan' => 6,
                            'content' => "<i>" . __('No ticket in progress.') . "</i>"
                        ]
                    ];

                    $twig_params['rows'][] = $row;
                }
            }
            $output = \Glpi\Application\View\TemplateRenderer::getInstance()->render('components/table.html.twig', $twig_params);

            echo $output;

        }
    }

    public static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {
        switch ($tabnum) {
            case 1:
                self::showForItemV2($item);
                break;
        }
        return true;
    }

    public function showForm($ID, array $options = [])
    {
        self::showForItemV2($this);
    }


    public static function showForItemV2(CommonDBTM $item, $withtemplate = 0)
    {
        $itemId = $item->fields['id'];
        $itemType = $item->getType();


        // Ajout du formulaire d'envoi
        $items_id = $item->fields["id"];
        $itemtype = $item->getType();

        if ($item->getType() == PluginDlteamsMessage::class) {
            $itemId = Session::getLoginUserID();
            $itemType = User::class;


            // Ajout du formulaire d'envoi
            $items_id = Session::getLoginUserID();
            $itemtype = User::class;
        }
//        echo self::renderMessageForm($items_id, $itemtype);
        echo "<br/>";

        // Récupérer les commentaires
        $comments = self::fetchComments($itemId, $itemType);
        self::sortCommentsByDate($comments);

        // Cache des utilisateurs pour éviter des appels répétés à getFromDB
        $userCache = [];

        echo "<div id='dlteams-chat-container' class='dlteams-chat-container'>";
        echo "    <div class='dlteams-chat-messages' id='dlteamsChatMessages'>";

        if (!empty($comments)) {
            $currentDate = null;

            foreach ($comments as $comment) {

                // Rendu du message principal
                $canReply = count($comment['answers']) == 0;
                self::renderComment($comment, $userCache, $item->getType(), $currentDate, false, $comment, $canReply);

                // Rendu des réponses associées
                if (!empty($comment['answers'])) {
                    $comment['answers'] = self::flattenComments($comment['answers']);
                    $lastAnswer = $comment['answers'][count($comment['answers']) - 1];
                    foreach ($comment['answers'] as $reply) {
                        self::renderComment($reply, $userCache, $item->getType(), $currentDate, true, null, $reply["id"] == $lastAnswer["id"]);
                    }
                }
            }
        } else {
            echo "<div class='dlteams-no-messages'>" . __('No messages yet.') . "</div>";
        }

        echo "    </div>";


        // Ajout des styles et scripts
        self::addChatStyles();
        self::addChatScripts();
        echo "</div>";
        echo self::renderMessageForm($items_id, $itemtype);
    }

    /**
     * Rendu d'un commentaire ou réponse.
     */
    private static function renderComment($comment, &$userCache, $itemType, &$currentDate, $isReply = false, $parentComment = null, $canReply = false)
    {

        // Récupérer ou mettre en cache les informations utilisateur
        if (!isset($userCache[$comment['users_id']])) {
            $user = new User();
            $user->getFromDB($comment['users_id']);
            $userCache[$comment['users_id']] = [
                'name' => htmlspecialchars($user->fields["firstname"] . " " . $user->fields["realname"]),
                'link' => User::getFormURLWithID($comment["users_id"]),
                'initials' => $user->getUserInitials()
            ];
        }


        $isSentByUser = Session::getLoginUserID() == $comment['users_id'];
        $avatar = $userCache[$comment['users_id']]["initials"];
        $messageClass = $isSentByUser ? 'dlteams-sent' : 'dlteams-received';
        $contentClass = $isSentByUser ? 'dlteams-sent-content' : 'dlteams-received-content';


        $footerName = "<a href='{$userCache[$comment['users_id']]['link']}' target='_blank'>{$userCache[$comment['users_id']]['name']}</a>";

//        $timestamp = Html::convDateTime($comment['date_creation']);
        $timestamp = Html::timestampToRelativeStr($comment['date_creation']);
        $formatted_datetime = date('d-m-Y H:i', strtotime($comment['date_creation']));
        $messageId = $comment['id'];
//        $messageDate = date('Y-m-d', strtotime($comment['date_creation'] ?? ""));
        $messageDate = Html::timestampToRelativeStr($comment['date_creation']);

        if (!$isReply) {
            // Ajouter un séparateur de date si nécessaire
            if (!isset($currentDate) || $currentDate !== $messageDate) {
                $currentDate = $messageDate;
            }
//                TODO: si afficher le separateur en date, decommenter
//                $label = $messageDate === date('Y-m-d') ? __('Today') : Html::convDate($messageDate);

            $parentId = $parentComment["id"];
            $objetStr = $parentComment["itemtype"];
            $objetName = $objetStr::getTypeName();
            $objetId = $parentComment["items_id"];
            $label = "Conversation $parentId ( $objetName $objetId) ";
            $convname = $parentComment["conversationname"];
            $convname ? $convname = " -> " . $convname : null;
            echo "<div class='date-separator'>
                <div title='Modifier le nom de la conversation' data-bs-toggle='tooltip' data-bs-placement='bottom' class='editable-label-wrapper' data-id='{$parentId}'>
                    <span class='editable-label'>{$label}</span> {$convname}
                </div>
              </div>";
//            }


        }


        // Styles spécifiques (pour différencier les items)
        $styles = ($comment["itemtype"] != $itemType) ? "background-color: #bffffe" : "";

        $itemtype = $comment["itemtype"];
        $items_id = isset($parentId) ? $parentId : $comment["items_id"];

        echo "<div data-itemtype='$itemtype' data-items_id='$items_id' class='dlteams-message {$messageClass}' id='kbcomment{$comment['id']}'>";
        echo "    <div class='dlteams-message-avatar'>{$avatar}</div>";
        echo "    <div style='$styles' class='dlteams-message-content {$contentClass}'>";


        // Si c'est une réponse, afficher un extrait du parent
        if (!empty($comment['tag'])) {
//            $pc = new ITILFollowup();
//            $pc->getFromDB($comment['parent_comment_id']);
//            $parentExcerpt = static::truncateHtmlContent(htmlspecialchars_decode($pc->fields['content']), 100);
            $tag = $comment['tag'];
            echo "<blockquote style='border-left: 2px solid #001f5d; margin-top: 0.5rem' class='dlteams-message-parent'>";
            echo "    <div class='parent-content' onclick='scrollToMessage(\"kbcomment{$comment['parent_comment_id']}\")' style='color: gray;'>{$tag}</div>";
            echo "</blockquote>";
            $tag = "";
        }

        echo "        <span class='message-text' id='message-text-{$messageId}'>" . stripslashes(htmlspecialchars_decode($comment['content'])) . "</span>";
        echo "        <div class='dlteams-message-footer mt-2'>";
        echo "<div style='display: flex; flex-direction: row; gap: 0.5rem;'>";
        echo "            <span><a href='/marketplace/dlteams/front/message.php' target='_blank'>Id {$messageId}</a></span>";

        echo "            <span title='$formatted_datetime' data-bs-toggle='tooltip' data-bs-placement='bottom' style='color: #001f5d; cursor: pointer; font-weight: 400; font-size: 0.6rem'>&nbsp;&nbsp;&nbsp; <i class='far fa-clock me-1'></i> {$timestamp}&nbsp;&nbsp;&nbsp;</span>";
        echo "            <span class='dlteams-time'> {$footerName}</span>";
        echo "</div>";


        echo "        </div>";
        echo "    </div>";


        $canForward = true;

        echo "<div style='display: flex'>";
        echo "<div style='display: flex; flex-direction: column'>";
        $actionSize = "0.9rem";

        if ($parentComment) {
            echo "            <span style='cursor: pointer; font-size: $actionSize' class='dlteams-time'>";
            echo "                <i onclick='forwardMessage({$messageId}, \"{$itemtype}\", {$items_id})' class='fa fa-arrow-right'></i>";
            echo "            </span>";
        }


        if ($isSentByUser) {
            echo "            <span style='cursor: pointer; font-size: $actionSize' class='dlteams-time'>";
            echo "                <i onclick='editMessage({$messageId}, \"{$itemtype}\", {$items_id})' class='fa fa-edit'></i>";
            echo "            </span>";
        }

        if ($canReply) {
            echo "            <span style='cursor: pointer; font-size: $actionSize' class='dlteams-time'>";
            echo "                <i onclick='answerMessage({$messageId}, \"{$itemtype}\", {$items_id})' class='fa fa-reply'></i>";
            echo "            </span>";
        }
        echo "</div>";

        $views_query = [
            "FROM" => PluginDlteamsITILFollowup_View::getTable(),
            "WHERE" => [
                "itilfollowups_id" => $messageId,
//                "items_id" => ['<>', Session::getLoginUserID()]
            ]
        ];
        global $DB;
        $iteratorows = $DB->request($views_query);

        $total = count($iteratorows);
        $maxVisible = 1;
        $i = 0;

        $rand_apply = mt_rand();

        $apply_to = "views" . $rand_apply;
        $viewers = "";
        foreach ($iteratorows as $iteratorow) {
//            if ($iteratorow["items_id"] == Session::getLoginUserID())
//                continue;
            $user = new User();
            $user->getFromDB($iteratorow["items_id"]);
            $initials = $user->getUserInitials();
            $bg_color = $user->getUserInitialsBgColor();

            $timestamp_message = Html::timestampToRelativeStr($iteratorow['date_creation']);
            $formatted_datetime_message = date('d-m-Y H:i', strtotime($iteratorow['date_creation']));
            $viewers .= "<div style='display: flex; gap: 0.3rem; align-items: center'><div
                class='dlteams-message-avatar'
                style=\"
                  width: 20px;
                  height: 20px;
                  font-size: 9px;
                  line-height: 20px;
                  background-color: {$bg_color};
                \">
                {$initials}
              </div><span>" . $user->fields["firstname"] . " " . $user->fields["realname"] . "</span>";
            $viewers .= "<span title='$formatted_datetime_message' data-bs-toggle='' data-bs-placement='top' style='color: #001f5d; cursor: pointer; font-weight: 400; font-size: 0.6rem; z-index: 50'>&nbsp;&nbsp;&nbsp; <i class='far fa-clock me-1'></i> {$timestamp_message}&nbsp;&nbsp;&nbsp;</span>";
            $viewers .= "</div><br/>";
        }
//        Html::timestampToRelativeStr()
        echo Html::showToolTip(
            $viewers,
            [
                'display' => false,
                'awesome-class' => '',
                'autoclose' => false,
//                'onclick'       => true,
                'applyto' => $apply_to,
                'title' => "Vues"
            ]
        );
        echo "<div id='$apply_to' style='display: flex; align-items: flex-end; cursor: pointer; margin-left: 0.2em'>";

        foreach ($iteratorows as $iteratorow) {
            // Si on est dans les 3 premiers, on affiche l'avatar
            if ($i < $maxVisible) {
                $user = new User();
                $user->getFromDB($iteratorow["items_id"]);
                $initials = $user->getUserInitials();
                $bg_color = $user->getUserInitialsBgColor();

                // Calcul du margin-left pour le chevauchement
                $margin = ($i === 0) ? '0' : '-15px';
                // Z-index croissant pour empiler correctement
                $zindex = $maxVisible + $i;

                echo "<div
                class='dlteams-message-avatar'
                style=\"
                  width: 20px;
                  height: 20px;
                  font-size: 9px;
                  line-height: 20px;
                  background-color: {$bg_color};
                  margin-left: {$margin};
                  z-index: {$zindex};
                \">
                {$initials}
              </div>";
            } // Si on arrive au 4ᵉ, on affiche +N et on sort de la boucle
            elseif ($i === $maxVisible) {
//                $margin = ($i === 0) ? '0' : '-15px';
                $zindex = $maxVisible + $i;
                $remaining = $total - $maxVisible;
                echo "<div
                class='dlteams-message-avatar dlteams-avatar-more'
                style=\"
                  width: 20px;
                  height: 20px;
                  font-size: 9px;
                  line-height: 20px;
                  background-color: #666;
                  margin-left: -15px;
                  z-index: $zindex;
                \">
                +{$remaining}
              </div>";
                break;
            }
            $i++;
        }


        echo "</div>";


        echo "</div>";


        echo "</div>";


        echo "<style>

                .dlteams-avatar-stack {
                  display: flex;
                  align-items: flex-end;     /* aligner en bas pour effet « escaliers » */
                }
                
                .dlteams-avatar-stack .dlteams-message-avatar {
                  width: 20px;
                  height: 20px;
                  font-size: 9px;
                  line-height: 20px;
                  border-radius: 50%;
                  color: white;
                  text-align: center;
                  margin-left: -8px;         /* chevauchement horizontal */
                  position: relative;
                  box-shadow: 0 0 0 1px #fff; /* un liseré blanc pour séparer */
                }
                
                .dlteams-avatar-stack .dlteams-message-avatar:first-child {
                  margin-left: 0;            /* pas de décalage pour le premier */
                }
                
                .dlteams-avatar-more {
                  background-color: #666;     /* couleur fixe pour le +N */
                  font-weight: bold;
                }
                .editable-label-wrapper {
                    display: inline-block;
                    position: relative;
                }
                
                .editable-label {
                    cursor: pointer;
                    padding: 2px 6px;
                    display: inline-block;
                    border-radius: 4px;
                    transition: background-color 0.2s;
                }
                
                .editable-label:hover {
                    background-color: #f0f0f0;
                    text-decoration: underline;
                }
                
                .label-editor-form {
                    display: flex;
                    gap: 4px;
                    align-items: center;
                }
                
                .label-editor-form input {
                    padding: 4px 6px;
                    font-size: 14px;
                    border-radius: 4px;
                    border: 1px solid #ccc;
                    min-width: 200px;
                }
                
                .label-editor-form button {
                    padding: 4px 8px;
                    font-size: 13px;
                    border: none;
                    border-radius: 4px;
                    cursor: pointer;
                }
                
                .label-editor-form .btn-save {
                    background-color: #4CAF50;
                    color: white;
                }
                
                .label-editor-form .btn-cancel {
                    background-color: #f44336;
                    color: white;
                }
                </style>";

        $rand = mt_rand();
        echo "<script>
                $(document).ready(function () {
                    var rand = $rand;
                        var rand_save = $rand+'_btnsave';
                        var rand_cancel = $rand+'_btncancel';
                        
                    $(document).on('click', '.editable-label', function () {
                        var \$labelSpan = \$(this);
                        var currentText = \$labelSpan.text();
                        var parent = \$labelSpan.closest('.editable-label-wrapper');
                        var id = parent.data('id');
                        
                
                        // Remplacer le label par un champ de saisie + boutons
                        var editorHtml = '<div class=\"label-editor-form\">' +
                                         '<input class=\"form-control\" type=\"text\" value=\"' + currentText + '\" />' +
                                         '<button id=\"'+rand_save+'\" class=\"btn-save\">✔</button>' +
                                         '<button id=\"'+rand_cancel+'\" class=\"btn-cancel\">✖</button>' +
                                         '</div>';
                        parent.html(editorHtml);
                    });
                
                    // Sauvegarder
                    $(document).on('click', '#'+rand_save, function () {
                        var form = $(this).closest('.label-editor-form');
                        var newText = form.find('input').val().trim();
                        var parent = form.closest('.editable-label-wrapper');
                        var id = parent.data('id');
                
                        if (newText === '') return;
                
                        
                        $.ajax({
                            url: '/marketplace/dlteams/ajax/update-conversation-label.php',
                            type: 'POST',
                            data: { id: id, label: newText },
                            success: function (response) {
                               // if (response.success) {
                                    //parent.html('<span class=\"editable-label\">' + newText + '</span>');
                                    window.location.reload();
                               // } else {
                                 //   alert('Erreur : ' + (response.error || 'Impossible de sauvegarder.'));
                                   // parent.html('<span class=\"editable-label\">' + newText + '</span>');
                               // }
                            },
                            error: function () {
                                alert('Erreur réseau');
                                //parent.html('<span class=\"editable-label\">' + newText + '</span>');
                            }
                        });
                    });
                
                    // Annuler
                    $(document).on('click', '#'+rand_cancel, function () {
                        var form = $(this).closest('.label-editor-form');
                        var parent = form.closest('.editable-label-wrapper');
                        var originalText = form.find('input').val();
                        parent.html('<span class=\"editable-label\">' + originalText + '</span>');
                    });
                });
                </script>";
    }


    /**
     * Rendu du formulaire d'envoi de message.
     */
    private static function renderMessageForm($items_id, $itemtype)
    {
        ob_start();

        // Bouton pour nouvelle conversation
        echo "<div style='display: flex; justify-content: end; gap: 0.4rem'>
            <button type='button' class='btn btn-primary btn-sm mt-1' id='newConversationButton'>Nouvelle conversation</button>
            <button type='button' class='btn btn-primary btn-sm mt-2 mb-2' id='hideInputButton' style='display: none;'>Masquer</button>";
//        if($itemtype == Supplier::class){

        echo "<button type='button' class='btn btn-primary btn-sm mt-1' id='newMailButton'>Nouveau mail</button>";
//        }
        echo "</div>";


        // Conteneur de la case de saisie masqué par défaut
        echo "<div id='chat-input-container' style='display: none;'>";
        echo "<form name='messageform' id='messageform'
                  class='comment_form' method='post'
                  action='" . Toolbox::getItemTypeFormURL(__CLASS__) . "'>";
        echo "    <div class='dlteams-chat-footer'>";

        // Placeholder pour répondre ou éditer
        echo '<div id="reply-content-placeholder" style="display: none; position: relative;">
            <blockquote style="width: 100%; padding: 0.3rem; border-left: 4px solid #007bff; background: #f9f9f9;">
            </blockquote>
            <span onclick="exitMode()" style="position: absolute; top: 3px; right: 3px; font-weight: bold; cursor: pointer;">X</span>
          </div>';

        // Zone de saisie du message
        echo "<div style='display: flex; align-items: center; width: 100%'>";
        echo "<div style='width: 100%'>";
        echo Html::textarea([
            "display" => false,
            "editor_id" => "dlteamsMessageInput",
            "enable_richtext" => true,
            'cols' => 1,
            'rows' => 1,
            'name' => 'content',
            "value" => "",
            "placeholder" => __("Votre message.."),
        ]);
        echo "</div>";
        echo "<input type='hidden' name='items_id' value='$items_id'>";
        echo "<input type='hidden' name='itemtype' value='$itemtype'>";
        echo "<button name='add'><i class='fa fa-paper-plane'></i></button>";
        echo "</div>";

        echo "</div>";


        Html::closeForm(true);
        echo "</div>"; // Fin du conteneur masqué


        $object = new $itemtype();
        $object->getFromDB($items_id);
        echo "<div id='mailablecontent' style='display: none; margin: 1rem'>";
        \Glpi\Application\View\TemplateRenderer::getInstance()->display('@dlteams/components/itilobject/timeline/mailable.html.twig', [
                "processor" => Toolbox::getItemTypeFormURL(__CLASS__),
                "item" => $object
            ]
        );
        echo "</div>";

        return ob_get_clean();
    }


    public static function getEnhancedHtml(?string $content, array $params = []): string
    {
        $p = [
            'images_gallery' => false,
            'user_mentions' => true,
            'images_lazy' => true,
            'text_maxsize' => 1000,
        ];
        $p = array_replace($p, $params);

        $content_size = strlen($content ?? '');

        // Sanitize content first (security and to decode HTML entities)
        $content = \Glpi\RichText\RichText::getSafeHtml($content);

        if ($p['user_mentions']) {
            $content = UserMention::refreshUserMentionsHtmlToDisplay($content);
        }

        if ($p['images_lazy']) {
            $content = self::loadImagesLazy($content);
        }

        if ($p['images_gallery']) {
            $content = self::replaceImagesByGallery($content);
        }

        if ($p['text_maxsize'] > 0 && $content_size > $p['text_maxsize']) {
            $content = <<<HTML
<div class="long_text">$content
    <p class='read_more'>
        <span class='read_more_button'>...</span>
    </p>
</div>
HTML;
            $content .= HTML::scriptBlock('$(function() { read_more(); });');
        }

        return $content;
    }

    /**
     * Replace images by gallery component in rich text.
     *
     * @param string $content
     *
     * @return string
     * @since 10.0.0
     *
     */
    private static function replaceImagesByGallery(string $content): string
    {

        $image_matches = [];
        preg_match_all(
            '/<a[^>]*>\s*<img[^>]*src=["\']([^"\']*document\.send\.php\?docid=([0-9]+)(?:&[^"\']+)?)["\'][^>]*>\s*<\/a>/',
            $content,
            $image_matches,
            PREG_SET_ORDER
        );
        foreach ($image_matches as $image_match) {
            $img_tag = $image_match[0];
            $docsrc = $image_match[1];
            $docid = $image_match[2];

            // Special chars are encoded in `src` attribute. We decode them to be sure to work with "raw" data.
            $docsrc = htmlspecialchars_decode($image_match[1], ENT_QUOTES);

            $document = new Document();
            if ($document->getFromDB($docid)) {
                $docpath = GLPI_DOC_DIR . '/' . $document->fields['filepath'];
                if (Document::isImage($docpath)) {
                    //find width / height define by user
                    $width = null;
                    if (preg_match("/width=[\"|'](\d+)(\.\d+)?[\"|']/", $img_tag, $wmatches)) {
                        $width = intval($wmatches[1]);
                    }
                    $height = null;
                    if (preg_match("/height=[\"|'](\d+)(\.\d+)?[\"|']/", $img_tag, $hmatches)) {
                        $height = intval($hmatches[1]);
                    }

                    //find real size from image
                    $imgsize = getimagesize($docpath);

                    $gallery = self::imageGallery([
                        [
                            'src' => $docsrc,
                            'w' => $imgsize[0],
                            'h' => $imgsize[1],
                            'thumbnail_w' => $width,
                            'thumbnail_h' => $height,
                        ]
                    ]);
                    $content = str_replace($img_tag, $gallery, $content);
                }
            }
        }

        return $content;
    }

    /**
     * insert `loading="lazy" into img tag
     *
     * @param string $content
     *
     * @return string
     * @since 10.0.3
     *
     */
    private static function loadImagesLazy(string $content): string
    {
        return preg_replace(
            '/<img([\w\W]+?)\/+>/',
            '<img$1 loading="lazy">',
            $content
        );
    }

    /**
     * Récupère les commentaires d'un élément en utilisant la logique précédente.
     */
    private static function fetchComments($itemId, $itemType)
    {

        $comments = self::getCommentsForKbItem($itemId, $itemType);

        if ($itemType === PluginDlteamsTicketTask::class) {
            global $DB;
            $query = [
                'FROM' => TicketTask::getTable(),
                'WHERE' => ['tickettasks_id' => $itemId],
            ];
            $iterator = $DB->request($query);

            foreach ($iterator as $task) {
                $comments = array_merge(
                    $comments,
                    self::getCommentsForKbItem($task['id'], $itemType, null, true)
                );
            }
        } elseif ($itemType === Ticket::class) {
            global $DB;
            $query = [
                'FROM' => TicketTask::getTable(),
                'WHERE' => ['tickets_id' => $itemId],
            ];
            $iterator = $DB->request($query);

            foreach ($iterator as $task) {
                $comments = array_merge(
                    $comments,
                    self::getCommentsForKbItem($task['id'], PluginDlteamsTicketTask::class, null, true)
                );
            }


            $query = [
                'FROM' => Document_Item::getTable(),
                'WHERE' => ['items_id' => $itemId, 'itemtype' => Ticket::class],
            ];
            $iterator = $DB->request($query);

            foreach ($iterator as $document) {
                $comments = array_merge(
                    $comments,
                    self::getCommentsForKbItem($document['documents_id'], Document::class, null, true)
                );
            }


            $query = [
                'FROM' => Problem_Ticket::getTable(),
                'WHERE' => ['tickets_id' => $itemId],
            ];
            $iterator = $DB->request($query);

            foreach ($iterator as $pt) {
                $comments = array_merge(
                    $comments,
                    self::getCommentsForKbItem($pt['problems_id'], Problem::class, null, true)
                );
            }


            $query = [
                'FROM' => Change_Ticket::getTable(),
                'WHERE' => ['tickets_id' => $itemId],
            ];
            $iterator = $DB->request($query);

            foreach ($iterator as $ct) {
                $comments = array_merge(
                    $comments,
                    self::getCommentsForKbItem($ct['changes_id'], Change::class, null, true)
                );
            }
        } elseif ($itemType === User::class) {
            $comments = self::getCommentsForKbItem(["<>", 0], $itemType);
        }

        return $comments;
    }

    /**
     * Ajoute le style CSS nécessaire.
     */
    private static function addChatStyles()
    {
        echo "<style>

       /* Zone de réponse dans une bulle */
.dlteams-reply-excerpt {
    background-color: #e6f3ff;
    border-left: 4px solid #007bff;
    padding: 5px 10px;
    margin-bottom: 5px;
    border-radius: 5px;
    cursor: pointer;
}

.dlteams-reply-excerpt:hover {
    background-color: #d9eafc;
}

.reply-content {
    font-size: 13px;
    color: #555;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

/* Conteneur principal du chat */
.dlteams-chat-container {
    width: 100%;
    height: 61vh;
    border: 1px solid #ddd;
    border-radius: 10px;
    display: flex;
    flex-direction: column;
    background-color: #f7f7f7;
    overflow: hidden;
    position: relative;
}

.dlteams-chat-messages {
    flex-grow: 1;
    padding: 10px;
    overflow-y: auto;
    display: flex;
    flex-direction: column;
}

.dlteams-no-messages {
    text-align: center;
    color: #999;
    margin-top: 20px;
}

/* Messages individuels */
.dlteams-message {
    display: flex;
    margin-bottom: 15px;
    align-items: flex-end;
    position: relative;
    transition: background-color 0.3s ease;
}

.dlteams-message-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    margin: 0 5px;
    background-color: #ccc;
    display: flex;
    justify-content: center;
    align-items: center;
    font-size: 14px;
    font-weight: bold;
    color: #fff;
}

.dlteams-message-content {
    max-width: 70%;
    padding: 8px 12px;
    border-radius: 15px;
    font-size: 14px;
    line-height: 1.4;
    position: relative;
}

.dlteams-message-content.dlteams-sent-content {
    background-color: #f3f6ff;
    border-radius: 15px 15px 0px 15px;
    border: solid 0.1px;
    border-color: #a7b1cb;
}

.dlteams-message-content.dlteams-received-content {
    background-color: #fff;
    border: 1px solid #ddd;
    border-radius: 15px;
}

/* Footer du message */
.dlteams-message-footer {
    font-size: 10px;
    color: #555;
    margin-top: 5px;
    text-align: right;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.dlteams-time {
    font-size: 10px;
    color: #999;
    margin-left: 5px;
}

/* Surlignage temporaire */
.highlighted {
    background-color: #fffbcc;
    transition: background-color 2s ease-out;
}

/* Séparateurs de date */
.date-separator {
    text-align: center;
    margin: 10px 0;
    position: relative;
    color: #888;
    font-size: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.date-separator span {
    background: #f9f9f9;
    padding: 2px 10px;
    border: 1px solid #ddd;
    border-radius: 10px;
}

/* Zone d'entrée */
.dlteams-chat-footer {
    padding: 8px;
    background-color: #f9f9f9;
    display: flex;
    flex-direction: column;
}

.dlteams-chat-footer input {
    flex-grow: 1;
    border-radius: 15px;
    border: 1px solid #ddd;
    padding: 8px 10px;
}

.dlteams-chat-footer button {
    margin-left: 8px;
    background-color: #ccc;
    color: black;
    border: none;
    border-radius: 50%;
    width: 35px;
    height: 35px;
    display: flex;
    align-items: center;
    justify-content: center;
}

        .tox.tox-tinymce {
//            height: 100px !important;
            width: 100% !important;
        }

/* Menu contextuel personnalisé */
.custom-context-menu {
    position: absolute;
    z-index: 1000;
    background: #fff;
    border: 1px solid #ddd;
    box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
    border-radius: 5px;
    list-style: none;
    padding: 5px 0;
    margin: 0;
    width: 150px;
}

.custom-context-menu li {
    padding: 8px 12px;
    cursor: pointer;
    font-size: 14px;
    color: #333;
    display: flex;
    align-items: center;
    gap: 8px;
}

.custom-context-menu li:hover {
    background: #f5f5f5;
}

.custom-context-menu i {
    font-size: 16px;
    color: #888;
}

.custom-context-menu li:hover i {
    color: #555;
}

/* Réponse / Édition */
#reply-content-placeholder {
    margin-bottom: 1rem;
    padding: 0.5rem;
    background: #f1f1f1;
    border-radius: 5px;
    position: relative;
}

#reply-content-placeholder span {
    cursor: pointer;
}

#reply-content-placeholder blockquote {
    margin: 0;
    padding: 0.5rem;
    font-style: italic;
    color: #555;
    background: #fff;
}

/* Survol et actions des messages */
.dlteams-message:hover input[type='checkbox'] {
    display: block;
}

.message-actions {
    display: none;
    gap: 5px;
}

.dlteams-message:hover .message-actions {
    display: flex;
}

.message-actions i {
    font-size: 14px;
    color: #888;
    cursor: pointer;
    transition: color 0.3s ease;
}

.message-actions i:hover {
    color: #333;
}

            
    </style>";
    }


    /**
     * Ajoute le script JS pour les interactions utilisateur.
     */
    private static function addChatScripts()
    {
        ?>
        <script>
            function scrollToMessage(messageId) {
                const targetMessage = document.getElementById(messageId);

                if (targetMessage) {
                    targetMessage.scrollIntoView({behavior: 'smooth', block: 'center'});

                    // Mise en surbrillance temporaire du message
                    targetMessage.classList.add('highlighted');
                    setTimeout(() => {
                        targetMessage.classList.remove('highlighted');
                    }, 2000);
                } else {
                    // alert("Message original introuvable.");
                }
            }

            function scrollToBottom() {
                const chatMessages = document.getElementById('dlteamsChatMessages');
                if (chatMessages) {
                    // Défilement immédiat sans animation
                    chatMessages.scrollTop = chatMessages.scrollHeight;
                }
            }

            // Affiche la case à cocher
            function showCheckbox(messageElement) {
                const checkbox = messageElement.querySelector('.message-checkbox');
                if (checkbox) checkbox.style.display = 'block';
            }

            // Masque la case à cocher si elle n'est pas cochée
            function hideCheckbox(messageElement) {
                const checkbox = messageElement.querySelector('.message-checkbox');
                if (checkbox && !checkbox.checked) {
                    checkbox.style.display = 'none';
                }
            }

            // Surligne le message si la case est cochée
            function toggleHighlight(checkbox) {
                const messageElement = checkbox.closest('.dlteams-message');
                if (checkbox.checked) {
                    messageElement.classList.add('highlighted');
                } else {
                    messageElement.classList.remove('highlighted');
                }
            }

            $(document).ready(function () {
                const chatInputContainer = document.getElementById('chat-input-container');
                const chatContainer = document.getElementById('dlteams-chat-container');
                const newConversationButton = document.getElementById('newConversationButton');
                const newMailButton = document.getElementById('newMailButton');
                const hideInputButton = document.getElementById('hideInputButton');
                const mailablecontent = document.getElementById('mailablecontent');

                // Fonction pour afficher la case de saisie
                function showChatInput() {
                    chatInputContainer.style.display = 'block';
                    // chatContainer.style.display = 'block';
                    newConversationButton.style.display = 'none';
                    hideInputButton.style.display = 'block';
                    mailablecontent.style.display = 'none';
                }

                // cacher le container de chat
                function hideChatContainer() {
                    chatContainer.style.display = 'none';
                    chatInputContainer.style.display = 'none';
                    mailablecontent.style.display = 'block';
                }


                // Fonction pour masquer la case de saisie
                function hideChatInput() {
                    chatInputContainer.style.display = 'none';
                    newConversationButton.style.display = 'block';
                    hideInputButton.style.display = 'none';
                }


                // Afficher la case de saisie lorsqu'on clique sur "Nouvelle conversation"
                newConversationButton.addEventListener('click', showChatInput);

                if (newMailButton)
                    newMailButton.addEventListener('click', hideChatContainer);


                // Masquer la case de saisie lorsqu'on clique sur "Masquer"
                hideInputButton.addEventListener('click', hideChatInput);


                // Affiche la case de saisie en mode réponse
                window.answerMessage = function (messageId, itemtype, items_id) {

                    showChatInput();

                    // Requête AJAX pour récupérer le contenu du message à répondre
                    $.ajax({
                        url: '/marketplace/dlteams/ajax/getMessageContent.php',
                        type: 'POST',
                        data: {id: messageId},
                        success: function (response) {
                            const data = JSON.parse(response);
                            const replyPlaceholder = document.getElementById('reply-content-placeholder');
                            replyPlaceholder.style.display = 'block';
                            replyPlaceholder.querySelector('blockquote').innerHTML = `
                            <strong>${data.author?.name || "Auteur inconnu"} :</strong> ${data.data_cut || ""}
                        `;

                            // Ajouter un champ caché pour le message auquel on répond
                            let replyInput = document.querySelector('#messageform input[name="reply_to"]');
                            if (!replyInput) {
                                replyInput = document.createElement('input');
                                replyInput.type = 'hidden';
                                replyInput.name = 'reply_to';
                                document.querySelector('#messageform').appendChild(replyInput);
                            }
                            replyInput.value = messageId;
                        }
                    });
                };


                window.forwardMessage = function (messageId, itemtype, items_id) {

                    glpi_ajax_dialog({
                        dialogclass: 'modal-lg',
                        title: __("Déplacer un message"),
                        url: '/marketplace/dlteams/ajax/getForwardMessageForm.php',
                        params: {
                            action: 'display_embed_form',
                            id: messageId,
                            itemtype,
                            items_id
                        },
                    });
                };

                // Affiche la case de saisie en mode édition
                window.editMessage = function (messageId, itemtype, items_id) {
                    showChatInput();

                    $.ajax({
                        url: '/marketplace/dlteams/ajax/getMessageContent.php',
                        type: 'POST',
                        data: {id: messageId},
                        success: function (response) {
                            const data = JSON.parse(response);
                            tinymce.get("dlteamsMessageInput").setContent(data.data);

                            // Ajouter un champ caché pour le message à éditer
                            let editInput = document.querySelector('#messageform input[name="edit"]');
                            if (!editInput) {
                                editInput = document.createElement('input');
                                editInput.type = 'hidden';
                                editInput.name = 'edit';
                                document.querySelector('#messageform').appendChild(editInput);
                            }
                            editInput.value = messageId;

                            // Indiquer qu'on est en mode édition
                            const replyPlaceholder = document.getElementById('reply-content-placeholder');
                            replyPlaceholder.style.display = 'block';
                            replyPlaceholder.querySelector('blockquote').innerText = "Vous éditez un message.";
                        }
                    });
                };


                // Réinitialiser la case de saisie
                window.exitMode = function () {
                    hideChatInput();

                    // Réinitialiser le champ d'édition
                    tinymce.get("dlteamsMessageInput").setContent("");

                    // Supprimer les champs cachés
                    const replyInput = document.querySelector('#messageform input[name="reply_to"]');
                    const editInput = document.querySelector('#messageform input[name="edit"]');
                    if (replyInput) replyInput.remove();
                    if (editInput) editInput.remove();

                    // Réinitialiser le mode actuel
                    const replyPlaceholder = document.getElementById('reply-content-placeholder');
                    replyPlaceholder.style.display = 'none';
                };

                // Défiler vers le bas au chargement
                scrollToBottom();
            });
        </script>
        <?php
    }


    /**
     * Show linked items of a knowbase item
     *
     * @param $item                     CommonDBTM object
     * @param $withtemplate    integer  withtemplate param (default 0)
     **/
    public static function showForItem(CommonDBTM $item, $withtemplate = 0)
    {


        $where = [
            'items_id' => $item->fields['id'],
            'itemtype' => $item->getType(),
//                'language'         => $item->fields['language']
        ];


        $kbitem_id = $where['items_id'];
        $kbitem = new self();
        $kbitem->getFromDB($kbitem_id);

        $cancomment = true;

        if ($cancomment) {
            echo "<div class='firstbloc'>";
            $rand = mt_rand();
            echo "<form name='allitemitem_form$rand' id='allitemitem_form$rand' method='post' action='" . Toolbox::getItemTypeFormURL(__CLASS__) . "'>";
            $itemtype = $item->getType();
            $items_id = $item->fields["id"];
            echo "<input type='hidden' name='itemtype' value='$itemtype'>";
            echo "<input type='hidden' name='items_id' value='$items_id'>";

            $disabled = false;
            $if = new self();
            if ($if->getFromDBByCrit(["itemtype" => $itemtype, "items_id" => $items_id, "solved_state" => 1])) {
                $disabledtext = "disabled";
                $disabled = true;
            }
            if ($disabled)
                echo "<div class='d-flex pa-2'><button class='btn btn-primary btn-sm ms-auto' type='submit' name='close'>Réouvrir cette discussion</button></div>";
            else
                echo "<div class='d-flex pa-2'><button class='btn btn-primary btn-sm ms-auto' type='submit' name='close'>Clôre cette discussion</button></div>";
            Html::closeForm();


            echo self::getCommentForm($kbitem_id, $item->getType());
            echo "</div>";
        }


        // Output events
        echo "<div class='forcomments timeline_history'>";
        echo "<ul class='comments left'>";
        $comments = self::getCommentsForKbItem($where['items_id'], $where['itemtype']);

        if ($where['itemtype'] == PluginDlteamsTicketTask::class) {
            $tickettask = new TicketTask();
            $tickettask->getFromDB($kbitem_id);

//           get planifications tasks
            $planification_task_query = [
                "FROM" => TicketTask::getTable(),
                "WHERE" => [
                    "tickettasks_id" => $kbitem_id
                ]
            ];

            global $DB;
            $iterator = $DB->request($planification_task_query);
            foreach ($iterator as $pt) {
                $comments = [
                    ...$comments,
                    ...self::getCommentsForKbItem($pt['id'], $where['itemtype'], null, true)];
            }
        }

        if ($where['itemtype'] == Ticket::class) {
            $task_query = [
                "FROM" => TicketTask::getTable(),
                "WHERE" => [
                    "tickets_id" => $kbitem_id
                ]
            ];

            global $DB;
            $iterator = $DB->request($task_query);

            foreach ($iterator as $pt) {

                $comments = [
                    ...$comments,
                    ...self::getCommentsForKbItem($pt['id'], PluginDlteamsTicketTask::class, null, !is_null($pt["tickettasks_id"]) && $pt["tickettasks_id"] != 0, true)];
            }
        }

        // No comments in database
        if (count($comments) < 1) {
            $no_txt = __('No comments');
            echo "<div class='center'>";
            echo "<table class='tab_cadre_fixe'>";
            echo "<tr><th>$no_txt</th></tr>";
            echo "</table>";
            echo "</div>";
            return;
        }
        $html = self::displayComments($comments, $cancomment, $item::getType());
        echo $html;

        echo "</ul>";
        echo "<script type='text/javascript'>
              $(function() {
                 var _bindForm = function(form) {
                     form.find('input[type=reset]').on('click', function(e) {
                        e.preventDefault();
                        form.remove();
                        $('.displayed_content').show();
                     });
                 };

                 
                 $('.add_answer').on('click', function() {
                     
                    var _this = $(this);
                     console.log(_this.data(), 'data');
                    var _data = {
                       'kbitem_id': _this.data('kbitem_id'),
                       'answer'   : _this.data('id'),
                       'itemtype': _this.data('itemtype'),
                    };

                    if (_this.data('language') != undefined) {
                       _data.language = _this.data('language');
                    }

                    if (_this.parents('.comment').find('#newcomment' + _this.data('id')).length > 0) {
                       return;
                    }

                    $.ajax({
                       url: '/marketplace/dlteams/ajax/getMessagerieContent.php',
                       method: 'post',
                       cache: false,
                       data: _data,
                       success: function(data) {
                          var _form = $('<div class=\"newcomment ms-3\" id=\"newcomment'+_this.data('id')+'\">' + data + '</div>');
                          _bindForm(_form);
                          _this.parents('.h_item').after(_form);
                       },
                       error: function() { " .
            Html::jsAlertCallback(__('Contact your GLPI admin!'), __('Unable to load revision!')) . "
                       }
                    });
                 });

                 $('.edit_item').on('click', function() {
                    var _this = $(this);
                    var _data = {
                       'kbitem_id': _this.data('kbitem_id'),
                       'edit'     : _this.data('id'),
                       'itemtype': _this.data('itemtype'),
                    };

                    if (_this.data('language') != undefined) {
                       _data.language = _this.data('language');
                    }

                    if (_this.parents('.comment').find('#editcomment' + _this.data('id')).length > 0) {
                       return;
                    }

                    $.ajax({
                       url: '/marketplace/dlteams/ajax/getMessagerieContent.php',
                       method: 'post',
                       cache: false,
                       data: _data,
                       success: function(data) {
                          var _form = $('<div class=\"editcomment\" id=\"editcomment'+_this.data('id')+'\">' + data + '</div>');
                          _bindForm(_form);
                          _this
                           .parents('.displayed_content').hide()
                           .parent()
                           .append(_form);
                       },
                       error: function() { " .
            Html::jsAlertCallback(__('Contact your GLPI admin!'), __('Unable to load revision!')) . "
                       }
                    });
                 });


              });
            </script>";

        echo "</div>";
    }


    /**
     * Transforme les commentaires imbriqués en une liste plate tout en conservant les relations parent-enfant.
     */
    static function flattenComments(array $comments, $parentId = null, &$flatList = [], &$processedIds = [])
    {
        foreach ($comments as $comment) {
            // Vérifier si le commentaire a déjà été ajouté
            if (in_array($comment['id'], $processedIds)) {
                continue; // Ignorer les doublons
            }

            // Ajouter le commentaire au tableau aplati
            $comment['parent_comment_id'] = $parentId;
            $flatList[] = $comment;

            // Marquer cet ID comme traité
            $processedIds[] = $comment['id'];

            // Si ce commentaire a des réponses, les parcourir récursivement
            if (!empty($comment['answers'])) {
                self::flattenComments($comment['answers'], $comment['id'], $flatList, $processedIds);
            }
        }

        return $flatList;
    }


    /**
     * Trie les commentaires par date de création, du plus ancien au plus récent.
     */
    static function sortCommentsByDate(array &$comments)
    {
        usort($comments, function ($a, $b) {
            $dateA = strtotime($a['date_creation'] ?? '0000-00-00 00:00:00');
            $dateB = strtotime($b['date_creation'] ?? '0000-00-00 00:00:00');
            return $dateA <=> $dateB; // Tri ascendant (plus ancien en premier)
        });
    }

    /**
     * Gat all comments for specified KB entry
     *
     * @param integer $kbitem_id KB entry ID
     * @param string $lang Requested language
     * @param integer $parent Parent ID (defaults to 0)
     *
     * @return array
     */
    public static function getCommentsForKbItem($kbitem_id, $itemtype, $parent = null, $isplannif_comment = false, $ischildcomment = false)
    {
        /** @var \DBmysql $DB */
        global $DB;

        $where = [
            'items_id' => $kbitem_id,
            'itemtype' => $itemtype,
            'parent_comment_id' => $parent,
            'entities_id' => Session::getActiveEntity()
        ];

        $db_comments = $DB->request(
            ITILFollowup::getTable(),
            $where + ['ORDER' => 'id ASC']
        );


        $comments = [];
        foreach ($db_comments as $db_comment) {
            /*            highlight_string("<?php\n\$data =\n" . var_export($db_comment, true) . ";\n?>");*/
//            die();

//            update views count
            $view = new PluginDlteamsITILFollowup_View();

            $criteria = [
                "itilfollowups_id" => $db_comment["id"],
                "itemtype" => User::class,
                "items_id" => Session::getLoginUserID()
            ];
            $crit = ['SELECT' => PluginDlteamsITILFollowup_View::getIndexName(),
                'FROM' => PluginDlteamsITILFollowup_View::getTable(),
                'WHERE' => $criteria
            ];

            $iter = $DB->request($crit);
            if (count($iter) == 0) {
                $view->add($criteria);
            }
            $db_comment['answers'] = self::getCommentsForKbItem($kbitem_id, $itemtype, $db_comment['id']);
            /*            highlight_string("<?php\n\$data =\n" . var_export($db_comment['id'], true) . ";\n?>");*/
            $db_comment["isplannif_comment"] = $isplannif_comment;
            $db_comment["ischild_comment"] = $ischildcomment;
            $comments[] = $db_comment;
        }


        return $comments;
    }


    public static function getNonReplyCommentCount(CommonDBTM $item, $withtemplate = 0)
    {
        $itemId = $item->fields['id'];
        $itemType = $item->getType();

        // Récupérer les commentaires
        $comments = self::fetchComments($itemId, $itemType);
        self::sortCommentsByDate($comments);

        $nonReplyCount = 0;

        if (!empty($comments)) {
            foreach ($comments as $comment) {
                // Vérifier si le commentaire principal n'est pas une réponse
                if (!$comment['isReply']) {
                    $nonReplyCount++;
                }

                // Vérifier les réponses associées
                if (!empty($comment['answers'])) {
                    $comment['answers'] = self::flattenComments($comment['answers']);
                    foreach ($comment['answers'] as $reply) {
                        if (!$reply['isReply']) {
                            $nonReplyCount++;
                        }
                    }
                }
            }
        }

        return $nonReplyCount;
    }


    public static function isSolved(PluginDlteamsMessage $item)
    {
        $if = new PluginDlteamsMessage();
        if ($if->getFromDBByCrit(["itemtype" => $item->getType(), "items_id" => $item->fields["id"], "solved_state" => 1]))
            return true;

        return false;
    }

    public function updateDateMod($ID, $no_stat_computation = false, $users_id_lastupdater = 0)
    {

    }


    /**
     * Get an object using some criteria
     *
     * @param array $crit search criteria
     *
     * @return boolean|array
     * @since 9.2
     *
     */
    public function getFromDBByCrit(array $crit)
    {
        /** @var \DBmysql $DB */
        global $DB;

        $crit = ['SELECT' => 'id',
            'FROM' => $this->getTable(),
            'WHERE' => $crit
        ];

        $iter = $DB->request($crit);
        if (count($iter) >= 1) {
            $row = $iter->current();
            return $this->getFromDB($row['id']);
        }
        return false;
    }

    public static function compare_dates($a, $b)
    {
        $dateA = isset($a["date_creation"]) && $a["date_creation"] ? strtotime($a["date_creation"]) : "";
        $dateB = isset($b["date_creation"]) && $b["date_creation"] ? strtotime($b["date_creation"]) : "";

        if ($dateA == $dateB) {
            return 0;
        }
        return ($dateA < $dateB) ? -1 : 1;
    }

    /**
     * Display comments
     *
     * @param array $comments Comments
     * @param boolean $cancomment Whether user can comment or not
     * @param integer $level Current level, defaults to 0
     *
     * @return string
     */
    public static function displayComments($comments, $cancomment, $itemtype, $level = 0)
    {
        $html = '';
        $html .= "<style>
        .avatar {
            --tblr-avatar-size: 2rem;
            --tblr-avatar-bg: var(--tblr-border-color-light);
            position: relative;
            width: var(--tblr-avatar-size);
            height: var(--tblr-avatar-size);
            font-size: calc(var(--tblr-avatar-size) / 2.8571428572);
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            color: #626976;
            text-align: center;
            text-transform: uppercase;
            vertical-align: bottom;
            user-select: none;
            background: var(--tblr-avatar-bg) no-repeat center / cover;
            border-radius: 4px;
        }
        
        
        #page .comments li, .qtip .comments li, .modal .modal-body .comments li {
            margin: 0;
            padding: 1rem;
            line-height: 2em;
            position: relative;
            clear: left;
        }
        .comment:not(.subcomment) {
            border-bottom: 1px solid #c9c9c9;
        }
        </style>
        ";

        usort($comments, ['PluginDlteamsMessage', 'compare_dates']);
        foreach ($comments as $comment) {
            /*            highlight_string("<?php\n\$data =\n" . var_export($comment, true) . ";\n?>");*/
//            die();
            $user = new User();
            $user->getFromDB($comment['users_id']);

            $istickettask_plannif = false;
            if ($comment["itemtype"] == PluginDlteamsTicketTask::class) {
                $tt = new TicketTask();
                $tt->getFromDB($comment["items_id"]);
                if ($tt->fields["tickettasks_id"])
                    $istickettask_plannif = true;
            }
            if ($istickettask_plannif) {
                $substyle = "style='background-color: aliceblue;'";
            }
//            elseif(isset($comment["ischild_comment"]) && $comment["ischild_comment"]){
//                $substyle = "style='background-color: aliceblue;'";
//            }
            else
                $substyle = "";
            $html .= "<li $substyle class='comment" . ($level > 0 ? ' subcomment' : '') . "' id='kbcomment{$comment['id']}'>";
            $html .= "<div class='h_item left d-flex'>";
            if ($level === 0) {
                $html .= '<hr/>';
            }
            $html .= "<div class='h_info'>";
            $timestamp = $comment['date_creation']; // exemple de timestamp

            $currentDate = date('Y-m-d');
            $eventDate = date('Y-m-d', strtotime($timestamp ?? ""));
            if ($eventDate == $currentDate)
                $created_at = date('H:i', strtotime($timestamp));
            else
                $created_at = Html::convDateTime($comment['date_creation']);
//            if($comment["itemtype"] == PluginDlteamsTicketTask::class){
//                $html .= "<div style='white-space: nowrap'>";
//                echo "<a target='_blank' href='".TicketTask::getFormURLWithID($comment["items_id"])."'>".$comment["items_id"]."&nbsp;<i class='fa fa-external-link'></i></a>";
//                echo "</div>";
//            }
            $html .= "<div style='white-space: nowrap' class='h_date'>" . $created_at . "</div>";
            $html .= "<div class='h_user'>";
            $thumbnail_url = User::getThumbnailURLForPicture($user->fields['picture']);
            $style = !empty($thumbnail_url) ? "background-image: url(\"$thumbnail_url\"); background-color: inherit;" : ("background-color: " . $user->getUserInitialsBgColor());
            $html .= '<a href="' . $user->getLinkURL() . '">';
            $html .= "<span class='avatar avatar-md rounded' style='{$style}'>";
            if (empty($thumbnail_url)) {
                $html .= $user->getUserInitials();
            }
            $html .= '</span></a>';
            $html .= "</div>"; // h_user
            $html .= "</div>"; //h_info

            $html .= "<div style='width: 100%' class='h_content KnowbaseItemComment'>";
            $html .= "<div class='displayed_content ms-2'>";


            echo "<div style='display: flex; gap: 0.1rem'>";

            $ct = self::getEnhancedHtml(htmlspecialchars_decode($comment['content']));


            $html .= "<div class='item_content'>";
            $html .= "<div style='display: flex; gap: 5px'>";
            if ($comment["itemtype"] == PluginDlteamsTicketTask::class) {
                $html .= "<div class='badge user-select-auto text-wrap d-none d-md-block mr-2' style='text-align: right; width: fit-content'>Id " . $comment["id"] . "</div>";
                $tt = new TicketTask();
                $tt->getFromDB($comment["items_id"]);
                if ($tt->fields["tickettasks_id"]) {
                    $html .= "<div class='badge user-select-auto text-wrap d-none d-md-block mr-2' style='text-align: right; width: fit-content'>message de Planification <a target='_blank' style='color: white' href='" . TicketTask::getFormURLWithID($comment["items_id"]) . "'>" . $comment["items_id"] .
                        "&nbsp;<i class='fa fa-external-link'></i></a> suite de la tâche <a target='_blank' style='color: white' href='" . TicketTask::getFormURLWithID($tt->fields["tickettasks_id"]) . "'>" . $tt->fields["tickettasks_id"] . " &nbsp;<i class='fa fa-external-link'></i></a></div>";
                }
//                else
//                    $html .= "<div class='badge user-select-auto text-wrap d-none d-md-block mr-2' style='text-align: right; width: fit-content'>Tâche <a style='color: white' target='_blank' href='" . TicketTask::getFormURLWithID($comment["items_id"]) . "'>" . $comment["items_id"] . "&nbsp;<i class='fa fa-external-link'></i></a></div>";
            } else
                $html .= "<div class='badge user-select-auto text-wrap d-none d-md-block mr-2' style='text-align: right; width: fit-content; background-color: #e5b553'>Id " . $comment["id"] . "</div>";

            if ($cancomment) {
                if (Session::getLoginUserID() == $comment['users_id']) {
                    $html .= "<span class='ti ti-edit edit_item pointer'
                  data-kbitem_id='{$comment['items_id']}'
                  data-itemtype='$itemtype'
                  data-id='{$comment['id']}'></span>";
                }
            }
            echo "</div>";
            $html .= "</div>";


            $html .= "<p>{$ct}</p>";
            $html .= "</div>";
            $html .= "</div>"; // displayed_content

            if ($cancomment) {
                $html .= "<span class='add_answer' title='" . __('Add an answer') . "'
               data-kbitem_id='{$comment['items_id']}'
                data-itemtype='$itemtype'
               data-id='{$comment['id']}'></span>";
            }

            $html .= "</div>"; //end h_content
            $html .= "</div>";

            if (isset($comment['answers']) && count($comment['answers']) > 0) {
//                var_dump("zzz");
//                die();
                $html .= "<input type='checkbox' id='toggle_{$comment['id']}'
                             class='toggle_comments' checked='checked'>";
                $html .= "<label for='toggle_{$comment['id']}' class='toggle_label'>&nbsp;</label>";
                $html .= "<ul>";
                $html .= self::displayComments($comment['answers'], $cancomment, $itemtype, $level + 1);
                $html .= "</ul>";
            }

            $html .= "</li>";
        }

        $html .= "<style>p {
                margin-top: 0;
                margin-bottom: 0.1rem !important;
            }
            
            .blink {
                  padding: 10px;
                  border: 1px solid #ccc;
                  background-color: white; /* Couleur initiale : blanc */
                  transition: background-color 0.3s ease;
                }
            </style>
";

        $html .= '
        <script>
        $(document).ready(function () {
              const hash = window.location.hash;
            
              if (hash) {
                  const element = $(hash);
            
                  if (element.length) {
                      $("html, body").animate(
                    {
                      scrollTop: element.offset().top,
                    },
                    600, // Durée du scroll (600 ms)
                    function () {
                        // Une fois le scroll terminé, lancer le clignotement
                        let blinkCount = 0;
                      const maxBlinks = 3;
            
                      function blink() {
                          if (blinkCount % 2 === 0) {
                              element.css("background-color", "#ffffe0"); // Jaune pâle
                          } else {
                              element.css("background-color", "white"); // Blanc
                          }
            
                          blinkCount++;
                          if (blinkCount < maxBlinks * 2) {
                              setTimeout(blink, 500); // Intervalle entre les changements
                          } else {
                              element.css("background-color", ""); // Réinitialiser après clignotement
                          }
                      }
            
                      blink(); // Lancer le clignotement
                    }
                  );
                }
              }
            });
        </script>
        ';
        return $html;
    }

    /**
     * Get comment form
     *
     * @param integer $kbitem_id Knowbase item ID
     * @param string $lang Related item language
     * @param false|integer $edit Comment id to edit, or false
     * @param false|integer $answer Comment id to answer to, or false
     * @return string
     */
    public static function getCommentForm($items_id, $itemtype, $edit = false, $answer = false)
    {
        $rand = mt_rand();

        $content = '';
        if ($edit !== false) {
            $comment = new ITILFollowup();
            $comment->getFromDB($edit);
            $content = $comment->fields['content'];
        }

        $if = new PluginDlteamsMessage();
        $disabledtext = "";
        $disabled = false;
        if ($if->getFromDBByCrit(["itemtype" => $itemtype, "items_id" => $items_id, "solved_state" => 1])) {
            $disabledtext = "disabled";
            $disabled = true;
        }

        $html = '';
        if (!$disabled)
            $html .= "<form name='messageform$rand' id='messageform$rand'
                      class='comment_form' method='post'
            action='" . Toolbox::getItemTypeFormURL(__CLASS__) . "'>";

        $html .= "<table class='tab_cadre_fixe'>";

        $form_title = ($edit === false ? __('New comment') : __('Edit comment'));
        $html .= "<tr class='tab_bg_2'><th colspan='3'>$form_title</th></tr>";

        $html .= "<tr class='tab_bg_1'><td><label for='comment'>" . _n('Message', 'Messages', 1) . "</label>
         &nbsp;<span class='red'>*</span></td><td style='width: 60%'>";
        $cols = 2;
        $rows = 1;
        $html .= Html::textarea([
            "display" => false,
            "id" => "comment",
            "enable_richtext" => true,
            'cols' => $cols,
            'rows' => $rows,
            'name' => 'content',
            "value" => $content]);
        $html .= "</td><td class='center'>";

        $btn_text = _sx('button', 'Add');
        $btn_name = 'add';

        if ($edit !== false) {
            $btn_text = _sx('button', 'Save');
            $btn_name = 'edit';
        }

        $html .= "<input type='submit' name='$btn_name' $disabledtext value='{$btn_text}' style='margin-right: 0.1rem' class='btn btn-primary'>";
        if ($edit !== false || $answer !== false) {
            $html .= "<input type='reset' name='cancel' value='" . __('Cancel') . "' class='btn btn-primary'>";
        }

        $html .= "<input type='hidden' name='items_id' value='$items_id'>";
        $html .= "<input type='hidden' name='itemtype' value='$itemtype'>";
        if ($answer !== false) {
            $html .= "<input type='hidden' name='parent_comment_id' value='{$answer}'/>";
        }
        if ($edit !== false) {
            $html .= "<input type='hidden' name='id' value='{$edit}'/>";
        }

        $html .= "</td></tr>";
        $html .= "</table>";
        if (!$disabled)
            $html .= Html::closeForm(false);
        return $html;
    }

    public function prepareInputForAdd($input)
    {
        if (!isset($input["users_id"])) {
            $input["users_id"] = 0;
            if ($uid = Session::getLoginUserID()) {
                $input["users_id"] = $uid;
            }
        }

        return $input;
    }

    public static function getDefaultSearchRequest()
    {
        $search = [
            'sort' => 6,
            'order' => 'DESC'
        ];
        return $search;
    }

    function rawSearchOptions()
    {

        $tab = [];

        $tab[] = [
            'id' => 'common',
            'name' => __("Characteristics")
        ];

        $tab[] = [
            'id' => '1',
            'table' => $this->getTable(),
            'field' => 'id',
            'name' => __("Id"),
            'datatype' => 'specific',
            'massiveaction' => false,
            'objectfield_display_id' => true
        ];

        $tab[] = [
            'id' => '2',
            'table' => $this->getTable(),
            'field' => 'itemtype',
            'name' => __("Objet"),
            'datatype' => 'specific',
            'massiveaction' => false,
            'autocomplete' => true,
            'objectfield' => true
        ];


        $tab[] = [
            'id' => '3',
            'table' => $this->getTable(),
            'field' => 'id',
            'name' => __("#Id"),
            'datatype' => 'specific',
            'dlteams_specific_itemtype' => true,
            'toview' => true,
            'massiveaction' => true,

        ];


        $tab[] = [
            'id' => '4',
            'table' => $this->getTable(),
            'field' => 'content',
            'name' => __("Contenu", 'dlteams'),
            'massiveaction' => true,
            'splititems' => true,
            'htmltext' => true,
            'datatype' => 'text',
            'contentfield' => true
        ];

        $tab[] = [
            'id' => '5',
            'table' => $this->getTable(),
            'field' => 'date_creation',
            'name' => __('Creation date'),
            'datatype' => 'datetime',
            'massiveaction' => false
        ];

        $tab[] = [
            'id' => '6',
            'table' => $this->getTable(),
            'field' => 'date_mod',
            'name' => __("Date"),
            'datatype' => 'datetime',
            'massiveaction' => false
        ];

        $tab[] = [
            'id' => '8',
            'table' => $this->getTable(),
            'field' => 'parent_comment_id',
            'name' => __('Conversation'),
            'datatype' => 'itemlink',
            'massiveaction' => false
        ];

        $tab[] = [
            'id' => '7',
            'table' => 'glpi_users',
            'field' => 'name',
            'linkfield' => 'users_id',
            'name' => __('Posté par'),
            'datatype' => 'text',
            'massiveaction' => false
        ];


        return $tab;

    }


    public function getSpecificMassiveActions($checkitem = null)
    {
        global $DB;

        return parent::getSpecificMassiveActions($checkitem);
    }


    /**
     * Tronque le contenu HTML sans casser les balises.
     *
     * @param string $html Contenu HTML à tronquer.
     * @param int $limit Longueur maximale du contenu tronqué.
     *
     * @return string Contenu tronqué.
     */
    static function truncateHtmlContent($html, $limit)
    {
        // Retourner une chaîne vide si le HTML est invalide
        if (empty(trim($html))) {
            return '';
        }

        $dom = new DOMDocument();

        // Charger le HTML tout en gérant les erreurs
        libxml_use_internal_errors(true);
        $dom->loadHTML('<?xml encoding="utf-8" ?>' . $html, LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD);
        libxml_clear_errors();

        $totalLength = 0;
        $truncated = '';

        // Vérifier si le body contient des nœuds
        $body = $dom->getElementsByTagName('body')->item(0);
        if (!$body || !$body->hasChildNodes()) {
            // Si aucun nœud valide, retourner une version textuelle simplifiée
            return mb_substr(strip_tags($html), 0, $limit) . (mb_strlen(strip_tags($html)) > $limit ? '...' : '');
        }

        // Parcourir les nœuds pour tronquer le contenu
        foreach ($body->childNodes as $node) {
            if ($totalLength >= $limit) {
                break;
            }
            $truncated .= truncateHtmlNode($node, $limit - $totalLength, $totalLength);
        }

        return $truncated . ($totalLength > $limit ? '...' : '');
    }

    /**
     * Tronque un nœud HTML récursivement.
     *
     * @param DOMNode $node Nœud à tronquer.
     * @param int $limit Limite de caractères restants.
     * @param int     &$totalLength Référence à la longueur totale comptabilisée.
     *
     * @return string Contenu tronqué du nœud.
     */
    static function truncateHtmlNode($node, $limit, &$totalLength)
    {
        if ($node->nodeType === XML_TEXT_NODE) {
            $remaining = $limit - $totalLength;
            $content = mb_substr($node->textContent, 0, $remaining);
            $totalLength += mb_strlen($content);
            return htmlspecialchars($content, ENT_QUOTES, 'UTF-8');
        } elseif ($node->nodeType === XML_ELEMENT_NODE) {
            $result = '<' . $node->nodeName;

            // Ajouter les attributs de la balise
            foreach ($node->attributes as $attribute) {
                $result .= ' ' . $attribute->nodeName . '="' . htmlspecialchars($attribute->nodeValue, ENT_QUOTES, 'UTF-8') . '"';
            }
            $result .= '>';

            // Traiter les enfants récursivement
            foreach ($node->childNodes as $child) {
                if ($totalLength >= $limit) {
                    break;
                }
                $result .= truncateHtmlNode($child, $limit, $totalLength);
            }

            $result .= '</' . $node->nodeName . '>';
            return $result;
        }
        return '';
    }


}
