<?php

class PluginDlteamsObjectRGPD extends CommonDBChild
{

    private static function showForUsers(User $item)
    {
        echo "<table class='tab_cadre_fixe'>";
        echo "<tr class='tab_bg_2'><th colspan='3'>" . __("Traitements relatifs", 'dlteams') . "</th></tr>";

        $iterator = static::getTraitementsRelatifsRequest($item);


        echo "<div class='spaced'>";

        echo "<table class='tab_cadre_fixehov'>";

        $header_begin = "<tr>";
        $header_top = '';
        $header_bottom = '';
        $header_end = '';


        $header_end .= "<th>" . __("Name") . "</th>";
        $header_end .= "<th>" . __("Content") . "</th>";
        $header_end .= "<th>" . __("Comment") . "</th>";


        $header_end .= "</tr>";

        echo $header_begin . $header_top . $header_end;


        foreach ($iterator as $data) {
            echo "<tr class='tab_bg_1'>";


            echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
            echo ">" . $data["name"] . "</td>";


            echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
            echo ">" . $data["content"] . "</td>";

            echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
            echo ">" . $data["comment"] . "</td>";


            echo "</tr>";
        }

        echo "</table>";

        Html::closeForm();
        echo "</table>";
    }


    private static function showIndividualsPeripheralsForUsers(User $item)
    {
        echo "<table class='tab_cadre_fixe'>";
        echo "<tr class='tab_bg_2'><th colspan='3'>" . __("Périphériques individuels", 'dlteams') . "</th></tr>";

        $usercreatepdf = new PluginDlteamsUserCreatePDF();
        $peripheriquesindividuels = $usercreatepdf->getPeripheriquesIndividuels($item->fields["id"]);


        echo "<div class='spaced'>";

        echo "<table class='tab_cadre_fixehov'>";

        $header_begin = "<tr>";
        $header_top = '';
        $header_bottom = '';
        $header_end = '';


        $header_end .= "<th>" . __("Type") . "</th>";
        $header_end .= "<th>" . __("Name") . "</th>";
        $header_end .= "<th>" . __("N° de série") . "</th>";
        $header_end .= "<th>" . __("Inventaire") . "</th>";


        $header_end .= "</tr>";

        echo $header_begin . $header_top . $header_end;


        foreach ($peripheriquesindividuels as $data) {
            echo "<tr class='tab_bg_1'>";


            echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
            echo ">" . $data["typename"] . "</td>";


            echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
            echo ">" . $data["name"] . "</td>";

            echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
            echo ">" . $data["serial"] . "</td>";

            echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
            echo ">" . $data["otherserial"] . "</td>";


            echo "</tr>";
        }

        echo "</table>";

        Html::closeForm();
        echo "</table>";
    }


    // --- 1. périphériques mutualisés ---
    private static function showMutualisedPeripheralsForUsers(User $item)
    {
        $title = __("Périphériques mutualisés", 'dlteams');
        echo "<table class='tab_cadre_fixe'>";
        echo "<tr class='tab_bg_2'><th colspan='3'>{$title}</th></tr>";

        $pdf = new PluginDlteamsUserCreatePDF();
        $list = $pdf->getPeripheriquesMutualises($item->fields["id"]);

        echo "<div class='spaced'><table class='tab_cadre_fixehov'>";
        echo "<tr>"
            . "<th>" . __("Type") . "</th>"
            . "<th>" . __("Nom") . "</th>"
            . "<th>" . __("Usage") . "</th>"
            . "</tr>";

        foreach ($list as $d) {
            echo "<tr class='tab_bg_1'>"
                . "<td>{$d['typename']}</td>"
                . "<td>{$d['name']}</td>"
                . "<td>" . ($d['usage'] ?? '') . "</td>"
                . "</tr>";
        }

        echo "</table></div></table>";
    }

    // 4. Périphériques administrateur (par utilisateur)
    private static function showAdminPeripheralsUserForUsers(User $item)
    {
        $title = __("Périphériques administrateur (utilisateur)", 'dlteams');
        echo "<table class='tab_cadre_fixe'>";
        echo "<tr class='tab_bg_2'><th colspan='3'>{$title}</th></tr>";

        $pdf = new PluginDlteamsUserCreatePDF();
        $list = $pdf->getPeripheriquesAdminTroughtUser($item->fields["id"]);

        echo "<div class='spaced'><table class='tab_cadre_fixehov'>";
        echo "<tr>"
            . "<th>" . __("Type") . "</th>"
            . "<th>" . __("Nom") . "</th>"
            . "<th>" . __("Usage") . "</th>"
            . "</tr>";

        foreach ($list as $d) {
            echo "<tr class='tab_bg_1'>"
                . "<td>{$d['typename']}</td>"
                . "<td>{$d['name']}</td>"
                . "<td>" . ($d['usage'] ?? '') . "</td>"
                . "</tr>";
        }

        echo "</table></div></table>";
    }

    // 5. Périphériques administrateur (par groupe)
    private static function showAdminPeripheralsGroupForUsers(User $item)
    {
        $title = __("Périphériques administrateur (groupe)", 'dlteams');
        echo "<table class='tab_cadre_fixe'>";
        echo "<tr class='tab_bg_2'><th colspan='3'>{$title}</th></tr>";

        $pdf = new PluginDlteamsUserCreatePDF();
        $list = $pdf->getPeripheriquesAdminTroughtGroup($item->fields["id"]);

        echo "<div class='spaced'><table class='tab_cadre_fixehov'>";
        echo "<tr>"
            . "<th>" . __("Type") . "</th>"
            . "<th>" . __("Nom") . "</th>"
            . "<th>" . __("Usage") . "</th>"
            . "</tr>";

        foreach ($list as $d) {
            echo "<tr class='tab_bg_1'>"
                . "<td>{$d['typename']}</td>"
                . "<td>{$d['name']}</td>"
                . "<td>" . ($d['usage'] ?? '') . "</td>"
                . "</tr>";
        }

        echo "</table></div></table>";
    }

    // 6. Clés physiques (badges, serrures, puces…)
    private static function showPhysicalKeysForUsers(User $item)
    {
        $title = __("Remise de clés physiques et badges", 'dlteams');
        echo "<table class='tab_cadre_fixe'>";
        echo "<tr class='tab_bg_2'><th colspan='3'>{$title}</th></tr>";

        $pdf = new PluginDlteamsUserCreatePDF();
        $list = $pdf->getClesPhysiques($item->fields["id"]);

        echo "<div class='spaced'><table class='tab_cadre_fixehov'>";
        echo "<tr>"
            . "<th>" . __("Nom") . "</th>"
            . "<th>" . __("Type de clé") . "</th>"
            . "<th>" . __("Contact") . "</th>"
            . "</tr>";

        foreach ($list as $d) {
            echo "<tr class='tab_bg_1'>"
                . "<td>{$d['name']}</td>"
                . "<td>{$d['keytypename']}</td>"
                . "<td>" . ($d['contact'] ?? '') . "</td>"
                . "</tr>";
        }

        echo "</table></div></table>";
    }

    // 7. Identifiants, secrets, documents, etc.
    private static function showAccountKeysForUsers(User $item)
    {
        $title = __("Remise d’identifiants et secrets", 'dlteams');
        echo "<table class='tab_cadre_fixe'>";
        echo "<tr class='tab_bg_2'><th colspan='4'>{$title}</th></tr>";

        $pdf = new PluginDlteamsUserCreatePDF();
        $list = $pdf->getCles($item->fields["id"]);

        echo "<div class='spaced'><table class='tab_cadre_fixehov'>";
        echo "<tr>"
            . "<th>" . __("Nom") . "</th>"
            . "<th>" . __("Type") . "</th>"
            . "<th>" . __("Annuaire") . "</th>"
            . "<th>" . __("Contact") . "</th>"
            . "</tr>";

        foreach ($list as $d) {
            echo "<tr class='tab_bg_1'>"
                . "<td>{$d['name']}</td>"
                . "<td>{$d['keytypename']}</td>"
                . "<td>" . ($d['annuaire_name'] ?? '--') . "</td>"
                . "<td>" . ($d['contact'] ?? '') . "</td>"
                . "</tr>";
        }

        echo "</table></div></table>";
    }

    // 8. Déclaration d’utilisation de matériels personnels (smartphone, ordinateur…)
    private static function showPersonalDevicesForUsers(User $item)
    {
        $title = __("Déclaration d’utilisation de matériels personnels", 'dlteams');
        echo "<table class='tab_cadre_fixe'>";
        echo "<tr class='tab_bg_2'><th colspan='3'>{$title}</th></tr>";

        $pdf = new PluginDlteamsUserCreatePDF();
        $phones = $pdf->getPhones($item->fields["id"]);
        $comps = $pdf->getComputers($item->fields["id"]);

        // Smartphones
        echo "<tr class='tab_bg_2'><th colspan='3'>" . __("Dispositifs Smartphones") . "</th></tr>";
        echo "<tr>"
            . "<th>" . __("Marque") . "</th>"
            . "<th>" . __("Modèle") . "</th>"
            . "<th>" . __("Usage") . "</th>"
            . "</tr>";

        foreach ($phones as $d) {
            echo "<tr class='tab_bg_1'>"
                . "<td>{$d['brand']}</td>"
                . "<td>{$d['phonemodel_name']}</td>"
                . "<td>" . ($d['usage'] ?? '') . "</td>"
                . "</tr>";
        }

        // Ordinateurs
        echo "<tr class='tab_bg_2'><th colspan='3'>" . __("Ordinateurs autorisés") . "</th></tr>";
        echo "<tr>"
            . "<th>" . __("Nom") . "</th>"
            . "<th>" . __("Usage") . "</th>"
            . "<th></th>"
            . "</tr>";

        foreach ($comps as $d) {
            echo "<tr class='tab_bg_1'>"
                . "<td>{$d['name']}</td>"
                . "<td>" . ($d['usage'] ?? '') . "</td>"
                . "<td></td>"
                . "</tr>";
        }

        echo "</table>";
    }

    // 9. Supports de données (catalogues)
    private static function showUserCatalogsForUsers(User $item)
    {
        $title = __("Supports de données mis à disposition", 'dlteams');
        echo "<table class='tab_cadre_fixe'><tr class='tab_bg_2'><th>{$title}</th></tr></table>";

        $pdf = new PluginDlteamsUserCreatePDF();
        $catalogs = $pdf->getUserCatalogs($item->fields["id"]);

        foreach ($catalogs as $data) {
            echo "<table class='table table-bordered spaced'>";
            echo "<tr><td><b>" . __("Nom du catalogue") . "</b></td><td>{$data['completename']}</td></tr>";
            echo "<tr><td><b>" . __("Description") . "</b></td><td>{$data['content']}</td></tr>";
            echo "<tr><td><b>" . __("Traitements et usages") . "</b></td><td>{$data['records']}</td></tr>";
            echo "<tr><td><b>" . __("Types de données") . "</b></td><td>{$data['datacarriertypes']}</td></tr>";
            echo "<tr><td><b>" . __("Stockage") . "</b></td><td>{$data['storages']}</td></tr>";
            echo "<tr><td><b>" . __("Modalités d'accès") . "</b></td><td>{$data['appliances']}</td></tr>";
            echo "<tr><td><b>" . __("Identifiants/clés") . "</b></td><td>{$data['accountkeys']}</td></tr>";
            echo "<tr><td><b>" . __("Accès autorisés") . "</b></td><td>{$data['catalog_users_formatted']}</td></tr>";
            echo "<tr><td><b>" . __("Administration") . "</b></td><td>{$data['catalog_admin_formatted']}</td></tr>";

            // Préparation des valeurs avec fallback
            $realname = isset($data['user_contact']['realname']) && $data['user_contact']['realname'] !== ''
                ? $data['user_contact']['realname']
                : '--';
            $firstname = isset($data['user_contact']['firstname']) && $data['user_contact']['firstname'] !== ''
                ? $data['user_contact']['firstname']
                : '--';
            $phone = isset($data['user_contact']['phone']) && $data['user_contact']['phone'] !== ''
                ? $data['user_contact']['phone']
                : '--';
            $email = isset($data['user_contact']['email']) && $data['user_contact']['email'] !== ''
                ? $data['user_contact']['email']
                : '--';

            /*            highlight_string("<?php\n\$data =\n" . var_export($data, true) . ";\n?>");*/
            echo "<tr><td><b>" . __("Contacts") . "</b>"
                . "<td>"
                . $realname . " " . $firstname . "<br>"
                . $email . "<br>"
                . $phone
                . "</td>"
                . "</tr>";
            echo "<tr><td><b>" . __("Commentaires") . "</b><td>{$data['content']}</td></tr>";
            echo "</table><br>";
        }
    }


    public static function getTraitementsRelatifsRequest(User $item)
    {

        $user_groups_idx = array_column(Group_User::getUserGroups($item->fields["id"]), "id");
        $or_conditions = [];

        // Condition pour les groupes (seulement si $user_groups_idx n'est pas vide)
        if (!empty($user_groups_idx)) {
            $or_conditions[] = [
                'glpi_plugin_dlteams_records_items.itemtype' => 'Group',
                'glpi_plugin_dlteams_records_items.itemtype1' => null,
                'glpi_plugin_dlteams_records_items.items_id' => $user_groups_idx,
            ];
        }

        // Condition pour l'utilisateur
        $or_conditions[] = [
            'glpi_plugin_dlteams_records_items.itemtype' => 'User',
            'glpi_plugin_dlteams_records_items.itemtype1' => null,
            'glpi_plugin_dlteams_records_items.items_id' => $item->fields["id"],
        ];


        $query = [
            'SELECT' => [
                'glpi_plugin_dlteams_records_items.id AS linkid',
                'glpi_plugin_dlteams_records_items.itemtype AS itemtype',
                'glpi_plugin_dlteams_records_items.items_id AS items_id',
                'glpi_plugin_dlteams_records_items.comment AS comment',
                'glpi_plugin_dlteams_records.name AS name',
                'glpi_plugin_dlteams_records.content AS content',
            ],
            'FROM' => 'glpi_plugin_dlteams_records_items',
            'JOIN' => [
                PluginDlteamsRecord::getTable() => [
                    'FKEY' => [
                        PluginDlteamsRecord_Item::getTable() => "records_id",
                        PluginDlteamsRecord::getTable() => "id"
                    ]
                ],
            ],
            'OR' => $or_conditions,

//            'ORDER' => ['glpi_plugin_dlteams_records_items.id ASC'],

//            'OR' => [
//                [
////                    'glpi_plugin_dlteams_records_items.records_id' => $item->fields['id'],
//                    'glpi_plugin_dlteams_records_items.itemtype' => 'Group',
//                    'glpi_plugin_dlteams_records_items.itemtype1' => null,
//                    'glpi_plugin_dlteams_records_items.items_id' => $user_groups_idx,
//                ],
//                [
////                    'glpi_plugin_dlteams_records_items.records_id' => $item->fields['id'],
//                    'glpi_plugin_dlteams_records_items.itemtype' => 'User',
//                    'glpi_plugin_dlteams_records_items.itemtype1' => null,
//                    'glpi_plugin_dlteams_records_items.items_id' => $item->fields["id"],
//                ],
//            ],
        ];
        global $DB;
        return $DB->request($query);
    }

    function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {
        switch ($item::getType()) {
            case User::getType():
                return __('Eléments RGPD', 'dlteams');
                break;
        }
        return '';
    }


    public static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {
        if ($item::getType() !== User::getType()) {
            return '';
        }

        static::showForUsers($item);
        echo "<br/>";
        static::showIndividualsPeripheralsForUsers($item);
        echo "<br/>";
        static::showMutualisedPeripheralsForUsers($item);
        echo "<br/>";
        static::showAdminPeripheralsUserForUsers($item);
        echo "<br/>";
        static::showAdminPeripheralsGroupForUsers($item);
        echo "<br/>";
        static::showPhysicalKeysForUsers($item);
        echo "<br/>";
        static::showAccountKeysForUsers($item);
        echo "<br/>";
        static::showPersonalDevicesForUsers($item);
        echo "<br/>";
        static::showUserCatalogsForUsers($item);

        return '';
    }

}