<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

use GlpiPlugin\dlteams\Exception\ImportFailureException;

class PluginDlteamsPolicieForm extends CommonDropdown implements
    PluginDlteamsExportableInterface
{
    use PluginDlteamsExportable;
    use Glpi\Features\TreeBrowse;

    static $rightname = 'plugin_dlteams_policieform';
    public static $menukey = "datagovernancepolicieform";
    public $dohistory = true;
    protected $usenotepad = true;

    static function getTypeName($nb = 0)
    {
        return _n("Processing document", "Processing documents", $nb, 'dlteams');
    }

//    public function getName($options = [])
//    {
//        //return sprintf("%s (%s)", $this->fields["name"], $this->fields["number"]); // TODO: Change the autogenerated stub
//        return sprintf(" %s | %s", $this->fields["id"], $this->fields["name"]); // TODO: Change the autogenerated stub
//    }

    public static function getMenuContent()
    {

        $menu = [];
        $menu['title'] = static::getTypeName(Session::getPluralNumber());
        $menu['shortcut'] = 'n';
        $menu['page'] = static::getSearchURL();
        $menu['icon'] = self::getIcon();
        $menu['config']['default'] = '/front/dropdown.php';


        $menu['options'] = [];
//        Bouton add
        if (static::canCreate()) {
            $menu['options']["policieform"]['links']['add'] = static::getFormURL(false);
        }

//        bouton rechercher
        $menu['options']["policieform"]['links']['search'] = static::getSearchURL(false);



//        bouton help
        $image = "<i class='fas fa-question' title='" . 'Aide' . "'></i>";
        $menu['options']["policieform"]['links'][$image] = KnowbaseItem::getSearchURL(false) . '?contains="jeux de données"';

        echo "<script>
                        \$(document).ready(function () {
                            // Attendre que la page soit complètement chargée
                            \$('a[href^=\"/front/knowbaseitem.php?contains=\"]').attr('target', '_blank');
                           
                        });
                    </script>";


        if (count($_SESSION['glpiprofiles']) > 1) {
            $profile = new Profile();
            $name = 'Vue-Modele';
            $options = [
                'SELECT' => [
                    'id'
                ],
                'WHERE' => [
                    'name' => $name,
                ]
            ];

            global $DB;
            $req = $DB->request($profile->getTable(), $options);
            foreach ($req as $id => $row) {
                //if ($row = $req->next()) {
                $profile->getFromDB($row['id']);
                if (array_key_exists($profile->getID(), $_SESSION['glpiprofiles'])) {
                    $swap = $_SESSION['glpiactiveprofile']['id'] == $profile->getID();
                    $text = '<i class="fa fa-layer-group pointer" style="margin-right: 0.4em;"></i>' . __("Swap to model view", "dlteams");
                    $returnKey = array_key_first($_SESSION['glpiprofiles']) == $profile->getID() ? array_keys($_SESSION['glpiprofiles'])[1] : array_key_first($_SESSION['glpiprofiles']);
                    $prodif = $profile->getID();
                    $server_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
                    empty($swap) ? $text = "vue modèle" : $text = "vue modèle";
                    empty($swap) ? $val = $prodif : $val = $returnKey;
                    empty($swap) ? $checked = '' : $checked = 'checked';


                    $text_temp = "<div id='switchmodelcontainer' style='width:100%; display: flex;justify-content: center; margin-bottom: 1px; margin-right: 25px;'>
                                        <label class='form-check form-switch btn-xs  me-0 me-sm-1 px-1 py-1 mb-0 flex-column-reverse flex-sm-row'
                                            title='$text'>
                                         <input type='checkbox' class='form-check-input ms-0 me-1 mt-0' role='button'
                                                autocomplete='off'
                                                $checked
                                                onclick='window.location.href=`$server_url/front/central.php?newprofile=$val`'
                                                />
                                         <span class='form-check-label mb-1 mb-sm-0'>
                                            $text
                                         </span>
                                      </label></div>
                                      
                                      <script>
                                            var child = document.getElementById('switchmodelcontainer');
                                            var parent = child.parentNode;
                                            parent.style.border = 'none';
                                            parent.classList.remove('btn-outline-secondary');
                                        </script>
                            ";


                    $menu['options']["policieform"]['links'][$text_temp] = "/front/central.php?newprofile=$val";
                    break;


                }
            }

        }



//        $plus = "<i class='fas fa-add' onclick='' title='" . __("add tab", 'dlteams') . "'></i> <span style='margin-left: 4px;'>ajouter chapitre</span>";
//
//        $temp_url = "/marketplace/dlteams/front/policieform_section.form.php" . "?items_id=" . static::getCurrentId() . "&itemtype=".static::class."&add_tab=" . true;
////        $links[$plus] = $temp_url;
//
//        $menu['options']["policieform"]['links'][$plus] = $temp_url;

        return $menu;
    }


    public static function getCurrentId()
    {
        // Get the current URL
        $currentURL = $_SERVER['REQUEST_URI'];

        // Get the query string from the URL
        $queryString = parse_url($currentURL, PHP_URL_QUERY);

        // Initialize an empty array for query parameters
        $queryParams = [];

        // Parse the query string into an array of parameters if it exists
        if ($queryString) {
            parse_str($queryString, $queryParams);
        }

        // Get the value of the "id" parameter
        $id = isset($queryParams['id']) ? $queryParams['id'] : null;

        return $id;
    }

    function showForm($id, $options = [])
    {
        global $CFG_GLPI;
        $this->initForm($id, $options);
        $this->showFormHeader($options);

        echo "<style>";
        echo "
            .form-table-text {
                text-align: right;
                width: 25%;
            }
            
            
            @media (max-width: 800px) {
                .form-table-text {
                    text-align: left;
                    width: 100%;
                }
            }
        ";

        echo "</style>";
        echo "<table, th, td width='100%'>";

        echo "<tr>";
//        echo "<td width='15%' style='text-align:right'>" . " " . "</td>";
        echo "<td class='form-table-text' >" . __("Name", 'dlteams') . "</td>";
        echo "<td>";
        $name = Html::cleanInputText($this->fields['name']);
        echo "<input type='text' style='width:98%' name='name' required value='" . $name . "'>" . "</td>";
//        echo "<td width='15%' style='text-align:right'>" . "" . "</td>";
        echo "</tr>";

        echo "<tr>";
//        echo "<td width='15%' style='text-align:right'>" . " " . "</td>";
        echo "<td class='form-table-text'>" . __("Content", 'dlteams') . "</td>";
        echo "<td>";
        $content = Html::cleanInputText($this->fields['content']);
        echo "<textarea style='width: 98%;' name='content' rows='3'>" . $content . "</textarea>";
        echo "</td></tr>";


//        echo "<tr>";
//        echo "<td class='form-table-text'>" . __("Activité / métier", 'dlteams') . "</td>";
//        echo "<td>";
//
//        $dpdwn_params = [
//            "name" => "activitycategories_idx[]",
//            "width" => "250px",
//            'value' => json_decode($this->fields["activitycategories_idx"] ?? "[]"),
//            'multiple' => true,
//            'ajax_page' => "/marketplace/dlteams/ajax/dlteamsDropdownAllItem.php"
//        ];
//
//
//        if($this->fields["activitycategories_idx"] && json_decode($this->fields["activitycategories_idx"]) == "[]"){
//            $dpdwn_params =  [
//                "name" => "activitycategories_idx[]",
//                "width" => "250px",
//                'values' => json_decode($this->fields["activitycategories_idx"] ?? "[]"),
//                'value' => null,
////            'right' => 'all',
//                'multiple' => true,
//                'ajax_page' => "/marketplace/dlteams/ajax/dlteamsDropdownAllItem.php"
//            ];
//        }
//
//        PluginDlteamsActivityCategory::dropdown($dpdwn_params);
//
//        echo "</td></tr>";


        $script = "<script>";
        $script .= "$(document).ready(function(){
            $('select[name=documents_id').change(function(e){            
                $.ajax({
                                url: '/marketplace/dlteams/ajax/typedocument_additionalfields.php',
                                type: 'POST',
                                data: {
                                    id: $(this).val(),
                                },
                                success: function (data) {
                                    $('#document_additional_fields').html(data);
                                   
                                }
                            }); 
//                               end ajax
            });
        });";
        $script .= "</script>";
        echo $script;

        echo "<tr>";
//        echo "<td width='15%' style='text-align:right'>" . " " . "</td>";
        echo "<td class='form-table-text'>" . __("Commentaire", 'dlteams') . "</td>";
        echo "<td>";
        $comment = Html::cleanInputText($this->fields['comment']);
        echo "<textarea style='width: 98%;' name='comment' rows='3'>" . $comment . "</textarea>";
        echo "</td></tr>";
        echo "</table>";

        $this->showFormButtons($options);

        if(!$this->isNewItem()){
            PluginDlteamsPolicieFormCategory_Item::showForItem($this);

            PluginDlteamsObject_document::showForitem($this, 0, false);
        }

		// $this->ShowDcpType($id);
//        $this->ShowDatacarrierType($id);
        return true;
    }

    function prepareInputForAdd($input)
    {
        $input['users_id_creator'] = Session::getLoginUserID();
        $input['activitycategories_idx'] = json_encode($input["activitycategories_idx"] ?? "[]");
        return parent::prepareInputForAdd($input);
    }

    function prepareInputForUpdate($input)
    {
        $input['users_id_lastupdater'] = Session::getLoginUserID();
        $input['activitycategories_idx'] = json_encode($input["activitycategories_idx"] ?? "[]");
        return parent::prepareInputForUpdate($input);
    }

    function cleanDBonPurge()
    {
        /*$rel = new PluginDlteamsRecord_MotifEnvoi();
        $rel->deleteByCriteria(['plugin_dlteams_concernedpersons_id' => $this->fields['id']]);*/
    }

    public function ShowDcpType($id)
    {
        if ($id) {
            $id = $this->fields['id'];
            if (!$this->can($id, READ)) {
                return false;
            }
            $canedit = $this->can($id, UPDATE);
            $rand = mt_rand(1, mt_getrandmax());
            global $CFG_GLPI;
            global $DB;

            $iterator = $DB->request([
                'SELECT' => [
                    'glpi_plugin_dlteams_policieforms_items.id AS linkid',
                    'glpi_plugin_dlteams_policieforms_items.comment as comment',
                    'glpi_plugin_dlteams_processeddatas.id as id',
                    'glpi_plugin_dlteams_processeddatas.name as name',
                ],
                'FROM' => 'glpi_plugin_dlteams_policieforms_items',
                'JOIN' => [
                    'glpi_plugin_dlteams_processeddatas' => [
                        'FKEY' => [
                            'glpi_plugin_dlteams_policieforms_items' => 'items_id',
                            'glpi_plugin_dlteams_processeddatas' => 'id'
                        ]
                    ]
                ],
                'WHERE' => [
                    'glpi_plugin_dlteams_policieforms_items.policieforms_id' => $this->fields['id'],
                    'glpi_plugin_dlteams_policieforms_items.itemtype' => "PluginDlteamsProcessedData"
                ],
                'ORDER' => ['name ASC'],
            ], "", true);

            $number = count($iterator);
            $items_list = [];
            $used = [];
            //var_dump(count($iterator));
            // while ($data = $iterator->next()) {
            foreach ($iterator as $id => $data) {
                $items_list[$data['linkid']] = $data;
                $used[$data['id']] = $data['id'];
            }

            if ($canedit) {
                echo "<form name='allitemitem_form$rand' id='allitemitem_form$rand' method='post' action='" . Toolbox::getItemTypeFormURL(PluginDlteamsElementsRGPD::class) . "'>";
                echo "<input type='hidden' name='itemtype1' value='" . $this->getType() . "' />";
                echo "<input type='hidden' name='items_id1' value='" . $this->getID() . "' />";
                echo "<input type='hidden' name='itemtype' value='" . PluginDlteamsProcessedData::getType() . "' />";
                echo "<input type='hidden' name='entities_id' value='" . $this->getID(Entity::class) . "' />";
                echo "<input type='hidden' name='link_element' value='" . true . "' />";
                // echo "<input type='hidden' name='comment' value='".$this->fields['comment']."' />";

                echo "<table class='tab_cadre_fixe'>";
                echo "<tr class='tab_bg_2'><th style='text-align:left!important'>" . __("Types de données à caractère personnel pouvant être contenues dans ce jeu de données", 'dlteams') . "</th></tr>";
                echo "</table>";

                echo "<table class='tab_cadre_fixe'>";
                echo "<td style='text-align:right'>" . __("Type de DCP", 'dlteams') . "</td>";
                echo "<td>";
                PluginDlteamsProcessedData::dropdown([
                    'addicon' => PluginDlteamsProcessedData::canCreate(),
                    'name' => 'items_id',
                    'width' => '300px',
                    'used' => $used
                ]);
                echo "</td>";

                echo "<tr>";
                echo "<td style='text-align:right'>" . __("Comment") . " " . "</td>";
//                $comment = Html::cleanInputText($this->fields['comment']);
                echo "<td>" . "<textarea style='width:100%' rows='1' name='comment' ></textarea>" . "</td>";
                echo "<td class='left'><input type='submit' name='add' value=\"" . _sx('button', 'Add') . "\" class='submit' style='margin:0px auto!important'>" . "</td>";
                echo "</tr>";
                echo "</table>";
                Html::closeForm();
            }

            if ($iterator) {
                echo "<div class='spaced'>";
                if ($canedit && $number) {
                    Html::openMassiveActionsForm('mass' . PluginDlteamsPolicieForm_Item::class . $rand);
                    $massive_action_params = ['container' => 'mass' . PluginDlteamsPolicieForm_Item::class . $rand,
                        'num_displayed' => min($_SESSION['glpilist_limit'], $number)];
                    Html::showMassiveActions($massive_action_params);
                }
                echo "<table class='tab_cadre_fixehov'>";

                $header_begin = "<tr>";
                $header_top = '';
                $header_bottom = '';
                $header_end = '';

                if ($canedit && $number) {
                    $header_begin .= "<th width='10'>";
                    $header_top .= Html::getCheckAllAsCheckbox('mass' . PluginDlteamsPolicieForm_Item::class . $rand);
                    $header_bottom .= Html::getCheckAllAsCheckbox('mass' . PluginDlteamsPolicieForm_Item::class . $rand);
                    $header_end .= "</th>";
                }

                $header_end .= "<th width='30%' style='text-align:left'>" . __("Type de DCP", 'dlteams') . "</th>";
                // $header_end .= "<th width='30%'>" . __("Type", 'dlteams') . "</th>";
                $header_end .= "<th width='70%' style='text-align:left'>" . __("Comment") . "</th>";
                $header_end .= "</tr>";

                echo $header_begin . $header_top . $header_end;
                foreach ($items_list as $data) {
                    if ($data['name']) {
                        echo "<tr class='tab_bg_1'>";

                        if ($canedit && $number) {
                            echo "<td width='10'>";
                            Html::showMassiveActionCheckBox(PluginDlteamsPolicieForm_Item::class, $data['linkid']);
                            echo "</td>";
                        }

                        $link = $data['name'];
                        if ($_SESSION['glpiis_ids_visible'] || empty($data['name'])) {
                            $link = sprintf(__("%1\$s (%2\$s)"), $link, $data['id']);
                        }
                        $name = "<a target='_blank' href=\"" . PluginDlteamsProcessedData::getFormURLWithID($data['id']) . "\">" . $link . "</a>";

                        echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                        echo ">" . $name . "</td>";
                        // echo "<td class='left'>" . $data['type'] . " </td>";
                        echo "<td class='left'>" . $data['comment'] . "</td>";
                        echo "</tr>";
                    }
                }

                if ($iterator->count() > 10) {
                    echo $header_begin . $header_bottom . $header_end;
                }
                echo "</table>";

                if ($canedit && $number) {
                    //$massive_action_params['ontop'] = false;
                    //Html::showMassiveActions($massive_action_params);
                    Html::closeForm();
                }
                echo "</div>";
            }
        }
    }

    public function ShowDatacarrierTypeGetRequest($id){
        global $DB;

        return $DB->request([
            'SELECT' => [
                'glpi_plugin_dlteams_policieforms_items.id AS linkid',
                'glpi_plugin_dlteams_policieforms_items.comment as comment',
                'glpi_plugin_dlteams_datacarriertypes.id as id',
                'glpi_plugin_dlteams_datacarriertypes.name as name',
                'glpi_plugin_dlteams_datacarriertypes.number as number',
            ],
            'FROM' => 'glpi_plugin_dlteams_policieforms_items',
            'JOIN' => [
                'glpi_plugin_dlteams_datacarriertypes' => [
                    'FKEY' => [
                        'glpi_plugin_dlteams_policieforms_items' => 'items_id',
                        'glpi_plugin_dlteams_datacarriertypes' => 'id'
                    ]
                ]
            ],
            'WHERE' => [
                'glpi_plugin_dlteams_policieforms_items.policieforms_id' => $this->fields['id'],
                'glpi_plugin_dlteams_policieforms_items.itemtype' => "PluginDlteamsDataCarrierType"
            ],
            'ORDER' => ['name ASC'],
        ], "", true);
    }

    public function ShowDatacarrierType($id, $readonly = false)
    {
        if ($id) {
            $id = $this->fields['id'];
            if (!$this->can($id, READ)) {
                return false;
            }
            $canedit = $this->can($id, UPDATE);
            $rand = mt_rand(1, mt_getrandmax());
            global $CFG_GLPI;
            $iterator = $this->ShowDatacarrierTypeGetRequest($id);

            $number = count($iterator);
            $items_list = [];
            $used = [];
            //var_dump(count($iterator));
            // while ($data = $iterator->next()) {
            foreach ($iterator as $id => $data) {
                $items_list[$data['linkid']] = $data;
                $used[$data['id']] = $data['id'];
            }

            $randdtct = mt_rand();
            if ($canedit && !$readonly) {
                echo "<form name='allitemitem_form$rand' id='allitemitem_form$rand' method='post' action='" . Toolbox::getItemTypeFormURL(PluginDlteamsElementsRGPD::class) . "'>";
                echo "<input type='hidden' name='itemtype1' value='" . $this->getType() . "' />";
                echo "<input type='hidden' name='items_id1' value='" . $this->getID() . "' />";
                echo "<input type='hidden' name='itemtype' value='" . PluginDlteamsDataCarrierType::getType() . "' />";
                echo "<input type='hidden' name='entities_id' value='" . $this->getID(Entity::class) . "' />";
                echo "<input type='hidden' name='link_element' value='" . true . "' />";
                // echo "<input type='hidden' name='comment' value='".$this->fields['comment']."' />";

                echo "<table class='tab_cadre_fixe'>";
                echo "<tr class='tab_bg_2'><th style='text-align:left!important'>" . __("Autres types de données (comptables, commerciales, ...)", 'dlteams') . "</th></tr>";
                echo "</table>";

                echo "<table class='tab_cadre_fixe'>";
                echo "<td class='form-table-text'>" . __("Type de données", 'dlteams') . "</td>";
                echo "<td>";

                PluginDlteamsDataCarrierType::dropdown([
                    'addicon' => PluginDlteamsDataCarrierType::canCreate(),
                    'name' => 'items_id',
                    'width' => '300px',
                    'used' => $used,
                    'rand' => $randdtct,
                    'url' => $CFG_GLPI['root_doc'] . "/marketplace/dlteams/ajax/getDropdownValue.php"
                ]);
                echo "</td>";

                echo "<tr>";
                echo "<td class='form-table-text'>" . __("Comment") . " " . "</td>";
//                $comment = Html::cleanInputText($this->fields['comment']);
                echo "<td>" . "<textarea style='width:100%' rows='1' name='comment' id='comment$randdtct'></textarea>" . "</td>";
                echo "<td class='left'><input type='submit' name='add' value=\"" . _sx('button', 'Add') . "\" class='submit' style='margin:0px auto!important'>" . "</td>";
                echo "</tr>";
                echo "</table>";
                Html::closeForm();
            }

            if ($iterator) {
                echo "<div class='spaced'>";
                if ($canedit && $number && !$readonly) {
                    Html::openMassiveActionsForm('mass' . PluginDlteamsPolicieForm_Item::class . $rand);
                    $massive_action_params = ['container' => 'mass' . PluginDlteamsPolicieForm_Item::class . $rand,
                        'num_displayed' => min($_SESSION['glpilist_limit'], $number)];
                    Html::showMassiveActions($massive_action_params);
                }
                echo "<table class='tab_cadre_fixehov'>";


                $header_begin = "<tr>";
                $header_top = '';
                $header_bottom = '';
                $header_end = '';

                if ($canedit && $number && !$readonly) {
                    $header_begin .= "<th width='10'>";
                    $header_top .= Html::getCheckAllAsCheckbox('mass' . PluginDlteamsPolicieForm_Item::class . $rand);
                    $header_bottom .= Html::getCheckAllAsCheckbox('mass' . PluginDlteamsPolicieForm_Item::class . $rand);
                    $header_end .= "</th>";
                }

// Ajouter une colonne vide pour les icônes
                $header_begin = "<tr>";
                $header_top = '';
                $header_bottom = '';
                $header_end = '';

                if ($canedit && $number && !$readonly) {
                    $header_begin .= "<th width='10'>";
                    $header_top .= Html::getCheckAllAsCheckbox('mass' . PluginDlteamsPolicieForm_Item::class . $rand);
                    $header_bottom .= Html::getCheckAllAsCheckbox('mass' . PluginDlteamsPolicieForm_Item::class . $rand);
                    $header_end .= "</th>";
                }

// Ajouter une colonne vide pour les icônes
                if ($canedit && !$readonly)
                    $header_end .= "<th width='5%'></th>";
                $header_end .= "<th width='30%' style='text-align:left'>" . __("Type de données", 'dlteams') . "</th>";
                $header_end .= "<th width='70%' style='text-align:left'>" . __("Comment") . "</th>";
                $header_end .= "</tr>";

                echo $header_begin . $header_top . $header_end;

                foreach ($items_list as $data) {
                    if ($data['name']) {
                        echo "<tr class='tab_bg_1'>";

                        if ($canedit && $number && !$readonly) {
                            echo "<td width='10'>";
                            Html::showMassiveActionCheckBox(PluginDlteamsPolicieForm_Item::class, $data['linkid']);
                            echo "</td>";
                        }

                        // Colonne pour les icônes
                        if ($canedit && !$readonly) {
                            echo "<td width='3%' class='center'>";
                            $linkid = $data["linkid"];
                            echo "<i class='fas fa-edit editma' style='color: #007bff; margin-right: 5px; cursor: pointer' data-id='$linkid'></i>";

                            // Dropdown pour confirmer la suppression
                            echo "<div class='dropdown' style='display: inline-block;'>";
                            echo "<a href='#' class='dropdown-toggle' data-bs-toggle='dropdown' aria-expanded='false' title='" . __("Delete", "dlteams") . "'>";
                            echo "<i class='fas fa-trash-alt' style='color: #dc3545;'></i></a>";
                            echo "<ul class='dropdown-menu dropdown-menu-end'>";
                            echo "<li><a href='delete_link_for_item_" . $data['id'] . "' class='dropdown-item text-danger' title='" . __("Confirm Delete", "dlteams") . "'>";
                            echo __("Confirmer suppression") . "</a></li>";
                            echo "</ul>";
                            echo "</div>";

                            echo "</td>";
                        }

                        $link = $data['number']." ".$data['name'];
                        if ($_SESSION['glpiis_ids_visible'] || empty($data['name'])) {
                            $link = sprintf(__("%1\$s (%2\$s)"), $link, $data['id']);
                        }
                        $name = "<a target='_blank' href=\"" . PluginDlteamsDataCarrierType::getFormURLWithID($data['id']) . "\">" . $link . "</a>";

                        echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                        echo ">" . $name . "</td>";
                        echo "<td class='left'>" . html_entity_decode($data['comment']) . "</td>";
                        echo "</tr>";
                    }
                }

                if ($iterator->count() > 10) {
                    echo $header_begin . $header_bottom . $header_end;
                }
                echo "</table>";

                if ($canedit && $number && !$readonly) {
                    //$massive_action_params['ontop'] = false;
                    //Html::showMassiveActions($massive_action_params);
                    Html::closeForm();
                }

                echo "</div>";


                echo "<script>
                    $('.editma').off('click').click(function(e) {
                        
                       glpi_ajax_dialog({
                        dialogclass: 'modal-lg',
                        bs_focus: false,
                        url: '/marketplace/dlteams/ajax/policieform_otherdatatype.php',
                        params: {
                            action: 'edit_policieform_otherdatatype_planif',
                            linkid: $(this).data('id')
                        },
                        title: i18n.textdomain('dlteams').__('Action', 'dlteams'),
                        close: function () {
        
                        },
                        fail: function () {
                            displayAjaxMessageAfterRedirect();
                        }
                    });
                    });
                    
                    </script>";


                if(!$readonly){
                    var_dump($readonly);
                    echo "<script>
                    $(document).ready(function(e){
    
                    $('#dropdown_items_id".$randdtct."').on('change', function () {
                        if($(this).val() != '0'){
                            
                            
                            $.ajax({
                                    url: '/marketplace/dlteams/ajax/get_object_specific_field.php',
                                    type: 'POST',
                                    data: {
                                        id: $(this).val(),
                                        object: '" . PluginDlteamsDataCarrierType::class . "',
                                        field: 'comment'
                                    },
                                    success: function (data) {
                                        // Handle the returned data here
                                        let comm_field = $('#comment".$randdtct."');
                                        comm_field.val(data);
                                        comm_field.val(comm_field.val().replace(/^\s+/, ''));
                                    }
                                });                      
                            
                            
                        }
                        else{
                           
                        }
                           
                        });
                    });
                    </script>";
                }
            }
        }
    }

//    public static function getDefaultSearchRequest()
//    {
//        $search = [
//			'sort' => 19,
//            'order' => 'DESC'
//        ];
//		return $search;
//	}

    /*public static function getDefaultSearchRequest()
    {
        $search = [
            'criteria' => [
				0 => [
                    'field' => 111,
                    // 'searchtype' => 'under',
					'searchtype' => 'contains',
                    'value' => ''
                ],
				1 => [
                    'field' => 0,
                    'searchtype' => 'contains',
                    'value' => ''
                ],
            ],
			// 'sort' => 19,
            // 'order' => 'DESC'
        ];
		return $search;
	}*/

    function rawSearchOptions()
    {
        $tab = [];

        $tab[] = [
            'id' => 'common',
            'name' => __("Characteristics")
        ];

        $tab[] = [
            'id' => '1',
            'table' => $this->getTable(),
            'field' => 'name',
            'name' => __("Name"),
            'datatype' => 'itemlink',
            'massiveaction' => false,
            'autocomplete' => true
        ];

        $tab[] = [
            'id' => '2',
            'table' => $this->getTable(),
            'field' => 'id',
            'name' => __("ID"),
            'massiveaction' => false,
            'datatype' => 'number',
        ];

        $tab[] = [
            'id' => '3',
            'table' => $this->getTable(),
            'field' => 'comment',
            'name' => __("Comments"),
            'datatype' => 'text',
            'massiveaction' => false,
        ];

        $tab[] = [
            'id' => '4',
            'table' => $this->getTable(),
            'field' => 'content',
            'name' => __("Contenu"),
            'datatype' => 'text',
            'toview' => true,
            'massiveaction' => true,
        ];

        if ($this->isEntityAssign()) {
            $tab[] = [
                'id' => '5',
                'table' => 'glpi_entities',
                'field' => 'completename',
                'name' => __("Entity"),
                'datatype' => 'dropdown',
                'massiveaction' => true,
            ];
        }

        $tab[] = [
            'id' => '6',
            'table' => $this->getTable(),
            'field' => 'is_recursive',
            'name' => __("Child entities"),
            'datatype' => 'bool',
            'massiveaction' => false,
        ];


        $tab[] = [
            'id' => '150',
            'table' => Entity::getTable(),
            'field' => 'entity_model',
            'name' => __("Entité modele"),
            'datatype' => 'itemlink',
            'massiveaction' => false,
        ];


        // $output = "<a href='/front/document.send.php?docid=" . $this->fields["documents_id"] . "' target='_blank'>" . $dc->getDownloadLink(null, 45) . "</a> <NOBR>";
		// $output = "<a href='/front/document.send.php?docid= " . $this->fields["documents_id"] . "' target='_blank'> </a>";
		// $output = "https://dlteams.app/front/document.send.php?docid=1949";
/* dans documents
        $tab[] = [
            'id'                 => '3',
            'table'              => $this->getTable(),
            'field'              => 'filename',
            'name'               => __('File'),
            'massiveaction'      => false,
            'datatype'           => 'string'
        ];
*/
		$tab[] = [
            'id' 		=> '7',
            //'table' 	=> $this->getTable(),
            //'field' 	=> 'documents_id',
             'table'     => 'glpi_documents',
			 'field'     => 'id',
            'name' 		=> __('File'),
			'datatype'  => 'string',
            'massiveaction' => false,
                'beforejoin'         => [
                    'table'              => 'glpi_documents',
			'additionalfields'   => ['filename'],
            'joinparams'         => [
                'jointype'           => 'child'
            ],
			],
        ];

        $tab[] = [
            'id' => '8',
            'table' => 'glpi_documentcategories',
            'field' => 'completename',
            'name' => __("Dossier des documents"),
            'datatype' => 'dropdown',
            'massiveaction' => true,
        ];

        $tab[] = [
            'id'                 => '19',
            'table'              => $this->getTable(),
            'field'              => 'date_mod',
            'name'               => __('Last update'),
            'datatype'           => 'datetime',
            'massiveaction'      => false
        ];

        $tab[] = [
            'id'                 => '20',
            'table'              => $this->getTable(),
            'field'              => 'date_creation',
            'name'               => __('Creation date'),
            'datatype'           => 'datetime',
            'massiveaction'      => false
        ];

        $tab[] = [
            'id'                 => '101',
            'table'              => PluginDlteamsPolicieForm_Item::getTable(),
            'field'              => 'items_id',
            'name'               => _x('quantity','Traitements'),
            'datatype'           => 'specific',
            'comments'           => true,
            'nosort'             => false,
            'additionalfields'   => ['itemtype'],
            'joinparams'         => [
            'linkfield' => 'policieforms_id',
                'jointype'           => 'child',
                'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsRecord::class."'",
            ],
            'forcegroupby'       => true,
            'massiveaction'      => true,			
			'htmltext'           => true,
            'showrecords'        => true
            //'dlteams_activityname' => true,
        ];

        /*$tab[] = [
            'id' => '102',
            'table' => 'glpi_plugin_dlteams_datacatalogs_items',
            'field' => 'id',
            'name' => _x('quantity', 'Catalogues'),
            'forcegroupby' => true,
            'usehaving' => true,
            'datatype' => 'count',
            'massiveaction' => false,
            'joinparams' => [
                'jointype' => 'itemtype_item'
            ]
        ];*/

        $tab[] = [
            'id'                 => '102',
            'table'              => PluginDlteamsPolicieForm_Item::getTable(),
            'field'              => 'items_id',
            'name'               => _x('quantity','Catalogues'),
            'datatype'           => 'specific',
            'comments'           => true,
            'nosort'             => false,
            'additionalfields'   => ['itemtype'],
            'joinparams'         => [
            'linkfield' => 'policieforms_id',
                'jointype'           => 'child',
                'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsDatacatalog::class."'",
            ],
            'forcegroupby'       => true,
            'massiveaction'      => false,
			'htmltext'           => true,
            'showcatalogs'       => true,
            //'dlteams_activityname' => true,
        ];
		
        $tab[] = [
            'id' => '104',
            'table' => 'glpi_plugin_dlteams_audits_items',
            'field' => 'id',
            'name' => _x('quantity', 'Audits'),
            'forcegroupby' => true,
            'usehaving' => true,
            'datatype' => 'count',
            'massiveaction' => false,
            'joinparams' => [
                'jointype' => 'itemtype_item'
            ]
        ];

//        $tab[] = [
//            'id' => '105',
//            'table' => 'glpi_plugin_dlteams_legalbasis_items',
//            'field' => 'id',
//            'name' => _x('quantity', 'Licéité'),
//            'forcegroupby' => true,
//            'usehaving' => true,
//            'datatype' => 'count',
//            'massiveaction' => false,
//            'joinparams' => [
//                'jointype' => 'itemtype_item'
//            ]
//        ];

        $tab[] = [
            'id'                 => '105',
            'table'              => PluginDlteamsPolicieForm_Item::getTable(),
            'field'              => 'items_id',
            'name'               => _x('quantity','Licéité'),
            'datatype'           => 'specific', //'itemlink',
            'comments'           => true,
            'nosort'             => false,
            'additionalfields'   => ['itemtype'],
            'joinparams'         => [
                'linkfield' => 'policieforms_id',
                'jointype'           => 'child',
                'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsLegalbasi::class."'",
            ],
            'forcegroupby'       => true,
            'massiveaction'      => false,
            'htmltext'           => true,
            'showLegaBasidata' => true
            //'dlteams_activityname' => true,
        ];


        $tab[] = [
            'id'                 => '106',
            'table'              => PluginDlteamsPolicieForm_Item::getTable(),
            'field'              => 'items_id',
            'name'               => _x('quantity','Rétention'),
            'datatype'           => 'specific', //'itemlink',
            'comments'           => true,
            'nosort'             => false,
            'additionalfields'   => ['itemtype'],
            'joinparams'         => [
                'linkfield' => 'policieforms_id',
                'jointype'           => 'child',
                'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsStoragePeriod::class."'",
            ],
            'forcegroupby'       => true,
            'massiveaction'      => false,
            'htmltext'           => true,
            'showstoragePeriodedata' => true
            //'dlteams_activityname' => true,
        ];

        $tab[] = [
            'id'                 => '107',
            'table'              => PluginDlteamsPolicieForm_Item::getTable(),
            'field'              => 'items_id',
            'name'               => _x('quantity','Protection'),
            'datatype'           => 'specific', //'itemlink',
            'comments'           => true,
            'nosort'             => false,
            'additionalfields'   => ['itemtype'],
            'joinparams'         => [
                'linkfield' => 'policieforms_id',
                'jointype'           => 'child',
                'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsProtectiveMeasure::class."'",
            ],
            'forcegroupby'       => true,
            'massiveaction'      => false,
            'htmltext'           => true,
            'showprotectedMeasuredata' => true
            //'dlteams_activityname' => true,
        ];

        /*$tab[] = [
            'id' => '108',
            'table' => 'glpi_plugin_dlteams_processeddatas_items',
            'field' => 'id',
            'name' => _x('quantity', 'DCP'),
            'forcegroupby' => true,
            'usehaving' => true,
            'datatype' => 'count',
            'massiveaction' => false,
            'joinparams' => [
                'jointype' => 'itemtype_item'
            ]
        ];*/
        $tab[] = [
            'id'                 => '108',
            'table'              => PluginDlteamsPolicieForm_Item::getTable(),
            'field'              => 'items_id1',
            'name'               => _x('quantity','Données'),
            'datatype'           => 'specific', //'itemlink',
            'comments'           => true,
            'nosort'             => false,
            'additionalfields'   => ['itemtype1'],
            'joinparams'         => [
            'linkfield' => 'policieforms_id',
                'jointype'           => 'child',
                'condition' => "AND NEWTABLE.`itemtype1` = '".PluginDlteamsProcessedData::class."'",
            ],
            'forcegroupby'       => true,
            'massiveaction'      => false,			
			'htmltext'           => true,
            'showprocesseddata' => true
            //'dlteams_activityname' => true,
        ];

        $tab[] = [
            'id' => '110',
            'table' => 'glpi_documents_items',
            'field' => 'id',
            'name' => _x('quantity', 'Docs'),
            'forcegroupby' => true,
            'usehaving' => true,
            // 'datatype' => 'count',
//			'datatype' => 'dropdown',
			'datatype' => 'itemlink',
            'massiveaction' => false,
            'joinparams' => [
                'jointype' => 'itemtype_item'
            ]
			
        ];

        $tab[] = [
            'id'                 => '111',
            'table'              => PluginDlteamsPolicieForm_Item::getTable(),
            'field'              => 'items_id',
            'name'               => _x('quantity', 'Activité, Métier'),
            'datatype'           => 'specific', //'itemlink' on perd le name
            'comments'           => true,
            'nosort'             => false,
            'additionalfields'   => ['itemtype'],
            'joinparams'         => [
            'linkfield' => 'policieforms_id',
                'jointype'           => 'child',
                'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsActivityCategory::class."'",
            ],
            'forcegroupby'       => true,
            'massiveaction'      => false,			
			'htmltext'           => true,
			'dlteams_activityname' => true,// si absent on perd le name
        ];

//        $tab[] = [
//            'id'                 => '13',
//            'table'              => 'glpi_items_problems',
//            'field'              => 'items_id',
//            'name'               => _n('Associated element', 'Associated elements', Session::getPluralNumber()),
//            'datatype'           => 'specific',
//            'comments'           => true,
//            'nosort'             => true,
//            'nosearch'           => true,
//            'additionalfields'   => ['itemtype'],
//            'joinparams'         => [
//                'jointype'           => 'child'
//            ],
//            'forcegroupby'       => true,
//            'massiveaction'      => false
//        ];

//        $tab[] = [
//            'id'                 => '5',
//            'table'              => 'glpi_useremails',
//            'field'              => 'email',
//            'name'               => _n('Email', 'Emails', Session::getPluralNumber()),
//            'datatype'           => 'email',
//            'joinparams'         => [
//                'jointype'           => 'child'
//            ],
//            'forcegroupby'       => true,
//            'massiveaction'      => false
//        ];

        /*$tab[] = [
            'id' => '113',
            'table' => 'glpi_plugin_dlteams_datacarriertypes_items',
            'field' => 'id',
            'name' => _x('quantity', 'Données'),
            'forcegroupby' => true,
            'usehaving' => true,
            'datatype' => 'count', // 'datatype' => 'dropdown',
            'massiveaction' => false,
            'joinparams' => [
             'jointype' => 'itemtype_item'
            ]
        ];*/

        /*$tab[] = [
            'id'                 => '113',
            'table'              => PluginDlteamsPolicieForm_Item::getTable(),
            'field'              => 'items_id',
            'name'               => _x('quantity','datacarrier'),
            'datatype'           => 'specific',
            'comments'           => true,
            'nosort'             => true,
            'additionalfields'   => ['itemtype'],
            'joinparams'         => [
            'linkfield' => 'policieforms_id',
                'jointype'           => 'child',
                'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsDataCarrier::class."'",
            ],
            'forcegroupby'       => true,
            'massiveaction'      => false,			
			'htmltext'           => true,
            //'dlteams_activityname' => true,
        ];*/

        $tab[] = [
            'id'                 => '114',
            'table'              => PluginDlteamsPolicieForm_Item::getTable(),
            'field'              => 'items_id',
            'name'               => _x('quantity','Personnes'),
            'datatype'           => 'spécific', // 'itemlink'
            'comments'           => true,
            // 'nosort'             => false,
            'additionalfields'   => ['itemtype'],
            'joinparams'         => [
            'linkfield' => 'policieforms_id',
                'jointype'           => 'child',
                'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsConcernedPerson::class."'",
            ],
            'forcegroupby'       => true,
            'massiveaction'      => false,			
			'htmltext'           => true,
            'showconcernedPerson' => true
            //'dlteams_activityname' => true,
        ];

        return $tab;
    }



    public function defineTabs($options = [])
    {
        $ong = [];

        $this->addDefaultFormTab($ong)
            ->addStandardTab(PluginDlteamsPolicieForm_Section::class, $ong, $options)
//            ->addStandardTab(PluginDlteamsPolicieFormCategory_Item::class, $ong, $options)
			->addStandardTab(PluginDlteamsPolicieForm_PersonalAndDataCategory::class, $ong, $options)
            ->addStandardTab(PluginDlteamsPolicieForm_CollectionFeatures::class, $ong, $options)
			->addStandardTab(PluginDlteamsConservation_Element::class, $ong, $options)
			->addStandardTab('PluginDlteamsRecord_Item', $ong, $options)
            ->addStandardTab(PluginDlteamsRightMeasure_Item::class, $ong, $options)
			->addStandardTab(PluginDlteamsProtectiveMeasure_Item::class, $ong, $options)
            ->addStandardTab(PluginDlteamsDataCatalog_Item::class, $ong, $options)
            ->addStandardTab(PluginDlteamsAcces_PolicieForm::class, $ong, $options)
            ->addStandardTab('PluginDlteamsObject_document', $ong, $options)
            ->addStandardTab('Notepad', $ong, $options)
            ->addStandardTab('KnowbaseItem_Item', $ong, $options)
            ->addStandardTab(PluginDlteamsTicket_Item::class, $ong, $options)
            ->addImpactTab($ong, $options)
            ->addStandardTab(PluginDlteamsActivitycategory_Item::class, $ong, $options)
            ->addImpactTab($ong, $options)
            ->addStandardTab('PluginDlteamsPolicieForm_Item', $ong, $options)
            ->addStandardTab('Log', $ong, $options);
        return $ong;
    }

    public static function showExportInfo(){
        // Choix unique via boutons radio
        echo "<fieldset style='border:1px solid #ccc; padding:15px; max-width: 70%; margin:auto; text-align: left; margin-top: 20px;'>";
        echo "  <legend style='font-weight:bold; text-align: center'>Options d'export :</legend>";

// Option 1
        echo "  <div style='margin-bottom:10px;'>";
        echo "    <label>";
        echo "      <input type='radio' name='exportOption' value='full' checked>";
        echo "      Désignation + Personnes, données + Licéité, Rétention";
        echo "    </label>";
        echo "  </div>";

// Option 2
        echo "  <div style='margin-bottom:10px;'>";
        echo "    <label>";
        echo "      <input type='radio' name='exportOption' value='medium'>";
        echo "      Désignation + Personnes, données";
        echo "    </label>";
        echo "  </div>";

// Option 3
        echo "  <div style='margin-bottom:10px;'>";
        echo "    <label>";
        echo "      <input type='radio' name='exportOption' value='minimal'>";
        echo "      Désignation";
        echo "    </label>";
        echo "  </div>";

        echo "</fieldset>";
    }


    /**
     * @see CommonDBTM::showMassiveActionsSubForm()
     */
    public static function showMassiveActionsSubForm(MassiveAction $ma)
    {

        switch ($ma->getAction()) {
            case 'copyTo':
                Entity::dropdown([
                    'name' => 'entities_id',
                ]);
                static::showExportInfo();



//                $submit_button = "<button id='submit_copy' class='submit'>Envoyer</button>";
//                echo $submit_button;
//                $script = "<script>";
//                $script.="$(document).ready(function(){
//               // alert('uu');
//                    $('#submit_copy').click(function(e){
//                    e.preventDefault();
//                    alert('oh yes');
//                    });
//                });";
//                $script.= "</script>";
//
//                echo  $script;
                echo '<br /><br />' . Html::submit(_x('button', 'Post'), ['name' => 'massiveaction']);
                return true;
        }

        return parent::showMassiveActionsSubForm($ma);
    }


    function exportToDB($subItems = [])
    {
        if ($this->isNewItem()) {
            return false;
        }

        $export = $this->fields;
        return $export;
    }


    /* Execute massive action for dlteams Plugin
     * @see CommonDBTM::processMassiveActionsForOneItemtype()
     */
    static function processMassiveActionsForOneItemtype(MassiveAction $ma, CommonDBTM $item, array $ids)
    {
        switch ($ma->getAction()) {
            case 'copyTo':
                if ($item->getType() == PluginDlteamsPolicieForm::class) {
//                    var_dump($ma->POST);
//                    die();
                    // @var PluginDlteamsRecord $item
                    global $DB;
                    $DB->beginTransaction();
                    $error = false;
                    foreach ($ids as $id) {
                        if ($item->getFromDB($id)) {
                            if ($item->copyPolicieForm($ma->POST['entities_id'], $id, $item, $ma->POST['exportOption'])) {
                                //Session::addMessageAfterRedirect(sprintf(__('Record copied: %s', 'dlteams'), $item->getName()));
                                $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_OK);
                            }
                        } else {
                            // Example of ko count
                            $DB->rollback();
                            $error = true;
                            $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_KO);
                        }
                    }
                    if ($error)
                        $DB->rollback();
                    else
                        $DB->commit();
                }
                return;
                break;
        }
        parent::processMassiveActionsForOneItemtype($ma, $item, $ids);
    }

    public static function importToDB(PluginDlteamsLinker $linker, $input = [], $containerId = 0, $subItems = [])
    {
        $item = new self();
        $originalId = $input['id'];
        unset($input['id']);
        $input['entities_id'] = $_POST['entities_id'];;
        $input['comment'] = str_replace(['\'', '"'], "", $input['comment']);
        $input['name'] = str_replace(['\'', '"'], "", $input['name']);
        $input['content'] = str_replace(['\'', '"'], "", $input['content']);
        $itemId = $item->add($input);
        if ($itemId === false) {
            $typeName = strtolower(self::getTypeName());
            throw new ImportFailureException(sprintf(__('failed to copy the %1$s record', 'dlteams'), $input['name']));
        }
        return $itemId;
    }

    public function deleteObsoleteItems(CommonDBTM $container, array $exclude)
    {
    }


}
