<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

class PluginDlteamsRecord_PersonalAndDataCategory extends CommonDBTM implements
    PluginDlteamsExportableInterface
{

    static public $itemtype_1 = 'PluginDlteamsRecord';
    static public $items_id_1 = 'records_id';
    static public $itemtype_2 = 'PluginDlteamsConcernedPerson';
    static public $items_id_2 = 'plugin_dlteams_concernedpersons_id';
    static public $column1_id = '49'; // for dlteams massiveupdate purpose
    static public $column2_id = '42'; // for dlteams massiveupdate purpose
    static public $column3_id = '39'; // for dlteams massiveupdate purpose

    static function canCreate()
    {
        return true;
    }

    static function canView()
    {
        return true;
    }

    static function canUpdate()
    {
        return true;
    }

    static function canDelete()
    {
        return true;
    }

    static function canPurge()
    {
        return true;
    }

    public function canEdit($ID)
    {
        return true;
    }

    function canCreateItem()
    {
        return true;
    }

    function canViewItem()
    {
        return true;
    }

    function canUpdateItem()
    {
        return true;
    }

    function canDeleteItem()
    {
        return true;
    }

    function canPurgeItem()
    {
        return true;
    }

    static function getTypeName($nb = 0)
    {
        return __("People, Datas", 'dlteams');
    }

    public function __construct()
    {
        self::forceTable('glpi_plugin_dlteams_records_items');
    }

    function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {

        if (!$item->canView()) {
            return false;
        }

        switch ($item->getType()) {
            case PluginDlteamsRecord::class:

                $nb = 0;
                if ($_SESSION['glpishow_count_on_tabs']) {
                    $nb = self::countForRecord($item);
                }

                return self::createTabEntry(PluginDlteamsRecord_PersonalAndDataCategory::getTypeName($nb), $nb);
        }

        return '';
    }

    static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {

        switch ($item->getType()) {
            case PluginDlteamsRecord::class :
                self::showForRecord($item, $withtemplate);
                break;
        }

        return true;
    }

    static function showForRecord(PluginDlteamsRecord $record, $withtemplate = 0)
    {
        global $CFG_GLPI, $DB;

        $id = $record->fields['id'];
        if (!$record->can($id, READ)) {
            return false;
        }

        $canedit = PluginDlteamsRecord::canUpdate();
        $rand = mt_rand(1, mt_getrandmax());

        PluginDlteamsRecord_PersonalAndDataCategory::normalizeTimelinePositions($record->fields["id"]);
        $iterator = $DB->request(self::getRequest($record));
        $items_list = [];
        foreach ($iterator as $data) {
            $items_list[$data['linkid']] = $data;
        }

        echo "<div class='firstbloc'>";
        if ($canedit) {
            echo "<form name='ticketitem_form$rand' id='ticketitem_form$rand' method='post' action='" . Toolbox::getItemTypeFormURL(__class__) . "'>
              <input type='hidden' name='base_id' value='{$record->fields['id']}' />
              <input type='hidden' name='baseitem' value='PluginDlteamsRecord' />
              <input type='hidden' name='itemtype' value='PluginDlteamsConcernedPerson' />
              <input type='hidden' name='itemtype1' value='PluginDlteamsProcessedData' />";
              echo "<input type='hidden' name='compute_ranking' value='true' />";
            echo "<input type='hidden' name='ranking_itemtype' value='".$record->getType()."' />";
            echo "<input type='hidden' name='ranking_items_id' value='".$record->fields["id"]."' />";
              echo "<table class='tab_cadre_fixe'>
                <tr class='tab_bg_2'>
                    <th colspan='4'>" . __("Add Category of data subjects linked to a personal data type", 'dlteams') . "<br/>
                    <i style='font-weight: normal'>" . __("Art 4.1, 5.1, 30.1(f) concernant les données relatives au traitement", 'dlteams') . "</i></th>
                </tr>
                <tr class='tab_bg_1'>
                    <td>" . _n("People category", "People categories", 0, 'dlteams') . "<br/><br/>";
            PluginDlteamsConcernedPerson::dropdown([
                'name'  => "items_id",
                'width' => '300px',
                'rand'  => $rand,
                'value' => $_SESSION["dlteams_recent_concernedperson"] ?? "",
                'url'   => $CFG_GLPI['root_doc'] . "/marketplace/dlteams/ajax/getDropdownValue.php"
            ]);
            echo "</td>
              <td>" . _n("Data type", "Data types", 0, 'dlteams') . "<br/><br/>";
            $used = [];
            if (!empty($_SESSION['dlteams_recent_concernedperson'])) {
                $filtered = array_filter($items_list, function ($item) {
                    return $item['items_id'] == $_SESSION['dlteams_recent_concernedperson'];
                });
                $used = array_column($filtered, 'items_id1');
            }
            PluginDlteamsProcessedData::dropdown([
                'name' => 'items_id1',
                'used' => $used,
                'width' => '300px',
                'url'   => $CFG_GLPI['root_doc'] . "/marketplace/dlteams/ajax/getDropdownValue.php"
            ]);
            echo "</td>
              <td>" . __("Mandatory", 'dlteams') . "<br/><br/>";
            Dropdown::showYesNo("mandatory", 1);
            echo "</td>
              <td class='center'>
                <input type='submit' name='add' value='" . __('Add') . "' class='submit' style='margin-top:35px'>
              </td>
            </tr>
          </table>
          ";
            Html::closeForm();

            echo "<script>
            $(document).ready(function() {
                $('#dropdown_items_id$rand').change(function() {
                    $.post('/marketplace/dlteams/ajax/updateConcernedPerson.php', { items_id: $(this).val() })
                     .done(() => window.location.reload())
                     .fail(err => console.error('Update failed:', err));
                });
            });
        </script>";
        }
        echo "</div>";

        if (!$iterator) return;

        $number = count($iterator);

        echo "<div class='spaced'>";
        if ($canedit && $number) {
            Html::openMassiveActionsForm('mass' . __class__ . $rand);
            $massive_action_params = ['container' => 'mass' . __class__ . $rand,
                'num_displayed' => min($_SESSION['glpilist_limit'], $number)];
            Html::showMassiveActions($massive_action_params);
        }
        echo "<table class='tab_cadre_fixehov'>
            <tr>
                " . ($canedit ? "<th width='10'>".Html::getCheckAllAsCheckbox('mass' . __class__ . $rand)  ."</th>" : "") . "
                <th>" . _n("People category", "People categories", 0, 'dlteams') . "</th>
                <th>" . _n("Data type", "Data types", 0, 'dlteams') . "</th>
                <th>" . __("Mandatory", 'dlteams') . "</th>
                <th>" . __("GDPR Sensitive", 'dlteams') . "</th>";

        if ($canedit) {
            echo "<th width='4%' class='left'></th>";
        }

            echo "</tr>";

        echo "<tbody class='sortable-rules'>";
        foreach ($items_list as $data) {
            echo "<tr data-recordsitem_id='" . $data['linkid'] . "'>
                " . ($canedit ? "<td>".Html::getMassiveActionCheckBox(__class__, $data['linkid'])."</td>" : "") . "
                <td>" . self::getItemLinkWithNumber($data, 'itemtype', 'items_id', $data['cpnumber']) . "</td>
                <td>" . self::getItemLinkWithNumber($data, 'itemtype1', 'items_id1', $data['pdnumber']) . "</td>
                <td>" . ($data['mandatory'] ? __('Yes') : __('No')) . "</td>
                <td>" . ($data['rgpd_sensitive_data'] ? __('Yes') : __('No')) . "</td>";
            if ($canedit) {
                echo "<td colspan='2'><i class='fas fa-grip-horizontal grip-rule'></i></td>";
            }
              echo "</tr>";
        }
        echo "</table>";
        if ($canedit && $number > 10) {
            $massive_action_params['ontop'] = false;
            Html::showMassiveActions($massive_action_params);

//                $massiveactionparams['ontop'] = false;
//                Html::showMassiveActions($massiveactionparams);
            Html::closeForm();
        }

        if($canedit){
            $collection_classname = static::getType();
            $js = <<<JAVASCRIPT
         $(function() {
            sortable('.sortable-rules', {
               handle: '.grip-rule',
               placeholder: '<tr><td colspan="7" class="sortable-placeholder">&nbsp;</td></tr>'
            })[0].addEventListener('sortupdate', function(e) {
               var sort_detail          = e.detail;
               console.log('alll');
               console.log(sort_detail);
               var recordsitem_id              = sort_detail.item.dataset.recordsitem_id;
               var collection_classname = "{$collection_classname}";
               var new_index            = sort_detail.destination.index;
               var old_index            = sort_detail.origin.index;
               var ref_id               = sort_detail.destination.itemsBeforeUpdate[new_index].dataset.recordsitem_id;
               var sort_action          = 'after';

               if (old_index > new_index) {
                  sort_action = 'before';
               }

               try{
                $.post(CFG_GLPI['root_doc']+'/marketplace/dlteams/ajax/record_personnesdcp.php', {
                  'action': 'move_rule',
                  'new_index': new_index,
                  'old_index': old_index,
                  'recordsitem_id': recordsitem_id,
                  'collection_classname': collection_classname,
                  'sort_action': sort_action,
                  'ref_id': ref_id,
               });
               }
               catch(e){
               
               }

               displayAjaxMessageAfterRedirect();
            });
         });
JAVASCRIPT;
            echo Html::scriptBlock($js);
        }
        echo "</div>";
    }


    static function getMaxRankingRequest($record)
    {
        global $DB;

        $max = 0;
        $iterator = $DB->request([
            'SELECT' => ['MAX' => 'timeline_position AS max_ranking'],
            'FROM'   => 'glpi_plugin_dlteams_records_items',
            'LEFT JOIN' => [
                'glpi_plugin_dlteams_concernedpersons' => [
                    'FKEY' => [
                        'glpi_plugin_dlteams_records_items' => "items_id",
                        'glpi_plugin_dlteams_concernedpersons' => "id",
                    ]
                ],
                'glpi_plugin_dlteams_processeddatas' => [
                    'FKEY' => [
                        'glpi_plugin_dlteams_records_items' => "items_id1",
                        'glpi_plugin_dlteams_processeddatas' => "id",

                    ],
                ],
            ],
            'WHERE' => [
                'OR' => [
                    [
                        'glpi_plugin_dlteams_records_items.records_id' => $record->fields['id'],
                        'glpi_plugin_dlteams_records_items.itemtype' => 'PluginDlteamsConcernedPerson',
                        'glpi_plugin_dlteams_records_items.itemtype1' => null,
                        'glpi_plugin_dlteams_concernedpersons.is_deleted' => 0,
                    ],
                    [
                        'glpi_plugin_dlteams_records_items.records_id' => $record->fields['id'],
                        'glpi_plugin_dlteams_records_items.itemtype' => 'PluginDlteamsConcernedPerson',
                        'glpi_plugin_dlteams_records_items.itemtype1' => 'PluginDlteamsProcessedData',
                        'glpi_plugin_dlteams_records_items.items_id1' => 0,
                        'glpi_plugin_dlteams_concernedpersons.is_deleted' => 0,
                    ],
                    [
                        'glpi_plugin_dlteams_records_items.records_id' => $record->fields['id'],
                        'glpi_plugin_dlteams_records_items.itemtype' => null,
                        'glpi_plugin_dlteams_records_items.itemtype1' => 'PluginDlteamsProcessedData',
                        'glpi_plugin_dlteams_processeddatas.is_deleted' => 0,
                    ],
                    [
                        'glpi_plugin_dlteams_records_items.records_id' => $record->fields['id'],
                        'glpi_plugin_dlteams_records_items.itemtype' => 'PluginDlteamsConcernedPerson',
                        'glpi_plugin_dlteams_records_items.items_id' => 0,
                        'glpi_plugin_dlteams_records_items.itemtype1' => 'PluginDlteamsProcessedData',
                        'glpi_plugin_dlteams_processeddatas.is_deleted' => 0,
                    ],
                    [
                        'glpi_plugin_dlteams_records_items.records_id' => $record->fields['id'],
                        'glpi_plugin_dlteams_records_items.itemtype' => 'PluginDlteamsConcernedPerson',
                        'glpi_plugin_dlteams_records_items.itemtype1' => 'PluginDlteamsProcessedData',
                        'glpi_plugin_dlteams_concernedpersons.is_deleted' => 0,
                        'glpi_plugin_dlteams_processeddatas.is_deleted' => 0,
                    ]
                ],
            ],
        ]);

//        var_dump($iterator->getSql());
//        die();
        if (count($iterator)) {
            $max = $iterator->current()['max_ranking'];
        }



        return $max;
    }

    public static function getItemLinkWithNumber($data, $itemTypeKey, $itemIdKey, $number, $class=false)
    {
        if ($data[$itemIdKey]) {
            if($class)
                $item = new $itemTypeKey();
            else
                $item = new $data[$itemTypeKey]();
            $item->getFromDB($data[$itemIdKey]);

            if(!$number && isset($item->fields['number']))
                $number = $item->fields["number"];
            if(!$number && isset($item->fields['completenumber']))
                $number = $item->fields["completenumber"];
            return " <a href='" . $item::getFormURLWithID($data[$itemIdKey]) . "' target='_blank'>". $item->fields['name'] . "</a>";
        }
        return " <a href='#'>----</a>";
    }



    function getForbiddenStandardMassiveAction()
    {

        $forbidden = parent::getForbiddenStandardMassiveAction();
        $forbidden[] = 'MassiveAction:amend_comment';
        $forbidden[] = 'MassiveAction:add_transfer_list';

        return $forbidden;
    }

    function rawSearchOptions()
    {

        $tab = [];

        /*$tab[] = [
           'id' => 'datasubjectscategory',
           'name' => PluginGenericobjectPersonnesconcernee::getTypeName(0)
        ];*/

        $tab[] = [
            'id' => "410",
            'table' => PluginDlteamsConcernedPerson::getTable(),
            'field' => 'items_id',
            'name' => __("Catégorie de personnes"),
            'forcegroupby' => true,
            'massiveaction' => true,
            'datatype' => 'dropdown',
        ];

        $tab[] = [
            'id' => "411",
            'table' => PluginDlteamsProcessedData::getTable(),
            'field' => 'items_id1',
            'name' => __("Catégories de données"),
            'forcegroupby' => true,
            'massiveaction' => true,
            'datatype' => 'dropdown',
        ];

        $tab[] = [
            'id' => "412",
            'table' => 'mandatory',
            'field' => 'mandatory',
            'name' => __("Obligatoire"),
            'forcegroupby' => true,
            'massiveaction' => true,
            'datatype' => 'bool',
        ];


        return $tab;
    }

    public function update(array $input, $history = 1, $options = [])
    {

        $record_item = new PluginDlteamsRecord_Item();
        $record_item->getFromDB($input["id"]);
        $record_oldfields = $record_item->fields;

        global $DB;
        if(isset($input["plugin_dlteams_concernedpersons_id"])){
            $DB->update(
                $record_item->getTable(),
                [
                    "items_id" => $input["plugin_dlteams_concernedpersons_id"]
                ],
                [
                    "id" => $input["id"]
                ]
            );


//            mis a jour de concerned person
            $concernedperson_item = new PluginDlteamsConcernedPerson_Item();
            $concernedperson_item->getFromDBByCrit([
                "concernedpersons_id" => $record_oldfields["items_id"],
                "itemtype" => PluginDlteamsRecord::class,
                "items_id" => $record_oldfields["records_id"],
                "itemtype1" => $record_oldfields["itemtype1"],
                "items_id1" => $record_oldfields["items_id1"],
                "comment" => $record_oldfields["comment"],
            ]);
            if($concernedperson_item){
                $DB->update(
                    $concernedperson_item->getTable(),
                    [
                        "concernedpersons_id" => $input["plugin_dlteams_concernedpersons_id"]
                    ],
                    [
                        "id" => $concernedperson_item->fields["id"]
                    ]
                );

                Session::addMessageAfterRedirect("Relation ".PluginDlteamsConcernedPerson::getTypeName()." mis a jour avec succès");
            }

//            mise a jour de processed data item
            $processeddata_item = new PluginDlteamsProcessedData_Item();
            $processeddata_item->getFromDBByCrit([
                "processeddatas_id" => $record_oldfields["items_id1"],
                "itemtype" => PluginDlteamsRecord::class,
                "items_id" => $record_oldfields["records_id"],
                "itemtype1" => $record_oldfields["itemtype"],
                "items_id1" => $record_oldfields["items_id"],
                "comment" => $record_oldfields["comment"],
            ]);
            if($processeddata_item){
                $DB->update(
                    $processeddata_item->getTable(),
                    [
                        "items_id1" => $input["plugin_dlteams_concernedpersons_id"]
                    ],
                    [
                        "id" => $processeddata_item->fields["id"]
                    ]
                );

                Session::addMessageAfterRedirect("Relation ".PluginDlteamsProcessedData::getTypeName()." mis a jour avec succès");
            }
        }

        if(isset($input["plugin_dlteams_processeddatas_id"])){
            $DB->update(
                $record_item->getTable(),
                [
                    "items_id1" => $input["plugin_dlteams_processeddatas_id"]
                ],
                [
                    "id" => $input["id"]
                ]
            );
            Session::addMessageAfterRedirect("Traitement mis à jour avec succès");


            $processeddata_item = new PluginDlteamsProcessedData_Item();
            $processeddata_item->getFromDBByCrit([
                "processeddatas_id" => $record_oldfields["items_id1"],
                "itemtype" => PluginDlteamsRecord::class,
                "items_id" => $record_oldfields["records_id"],
                "itemtype1" => $record_oldfields["itemtype"],
                "items_id1" => $record_oldfields["items_id"],
                "comment" => $record_oldfields["comment"],
            ]);
            if($processeddata_item){
                $DB->update(
                    $processeddata_item->getTable(),
                    [
                        "processeddatas_id" => $input["plugin_dlteams_processeddatas_id"]
                    ],
                    [
                        "id" => $processeddata_item->fields["id"]
                    ]
                );

                Session::addMessageAfterRedirect("Relation ".PluginDlteamsProcessedData::getTypeName()." mis a jour avec succès");
            }


            //            mis a jour de concerned person
            $concernedperson_item = new PluginDlteamsConcernedPerson_Item();
            $concernedperson_item->getFromDBByCrit([
                "concernedpersons_id" => $record_oldfields["items_id"],
                "itemtype" => PluginDlteamsRecord::class,
                "items_id" => $record_oldfields["records_id"],
                "itemtype1" => $record_oldfields["itemtype1"],
                "items_id1" => $record_oldfields["items_id1"],
                "comment" => $record_oldfields["comment"],
            ]);
            if($concernedperson_item){
                $DB->update(
                    $concernedperson_item->getTable(),
                    [
                        "items_id1" => $input["plugin_dlteams_processeddatas_id"]
                    ],
                    [
                        "id" => $concernedperson_item->fields["id"]
                    ]
                );

                Session::addMessageAfterRedirect("Relation ".PluginDlteamsConcernedPerson::getTypeName()." mis a jour avec succès");
            }
        }


        if(isset($input["mandatory"])){
            $DB->update(
                $record_item->getTable(),
                [
                    "mandatory" => $input["mandatory"]
                ],
                [
                    "id" => $input["id"]
                ]
            );
        }

        Session::addMessageAfterRedirect("Traitement modifié avec succès");
        return true; // TODO: Change the autogenerated stub
    }

    static function countForRecord($record)
    {
        global $DB;
        // Exécute la requête et récupère l'itérateur
        $iterator = $DB->request(self::getRequest($record));

        // Tableaux associatifs pour garantir l'unicité des combinaisons
        $uniquePerson  = [];
        $uniqueDonnees = [];

        foreach ($iterator as $data) {
            // Si itemtype et items_id sont renseignés, on compose une clé unique
            if (!empty($data['itemtype']) && !empty($data['items_id'])) {
                $key = $data['itemtype'] . '|' . $data['items_id'];
                $uniquePerson[$key] = true;
            }

            // Même logique pour itemtype1 et items_id1
            if (!empty($data['itemtype1']) && !empty($data['items_id1'])) {
                $key1 = $data['itemtype1'] . '|' . $data['items_id1'];
                $uniqueDonnees[$key1] = true;
            }
        }

        // Comptage des clés distinctes
        $person  = count($uniquePerson);
        $donnees = count($uniqueDonnees);

        // Retourne "X, Y" si les deux comptes sont > 0, sinon chaîne vide
        return ($person > 0 && $donnees > 0)
            ? "$person, $donnees"
            : "";
    }



    static function getRequest($record, $onlysensitive = false)
    {

        $query = [
            'SELECT' => [
                'glpi_plugin_dlteams_records_items.id AS linkid',
                'glpi_plugin_dlteams_records_items.*',
                'glpi_plugin_dlteams_concernedpersons.name AS gpdpname',
                'glpi_plugin_dlteams_processeddatas.name AS gpddname',
                'glpi_plugin_dlteams_processeddatas.rgpd_sensitive_data AS rgpd_sensitive_data',
                'glpi_plugin_dlteams_records_items.comment AS comment',
                'glpi_plugin_dlteams_concernedpersons.ranking as cpnumber',
                'glpi_plugin_dlteams_processeddatas.number as pdnumber',
                'glpi_plugin_dlteams_records_items.mandatory AS mandatory',

            ],
            'FROM' => 'glpi_plugin_dlteams_records_items',
            'LEFT JOIN' => [
                'glpi_plugin_dlteams_concernedpersons' => [
                    'FKEY' => [
                        'glpi_plugin_dlteams_records_items' => "items_id",
                        'glpi_plugin_dlteams_concernedpersons' => "id",
                    ]
                ],
                'glpi_plugin_dlteams_processeddatas' => [
                    'FKEY' => [
                        'glpi_plugin_dlteams_records_items' => "items_id1",
                        'glpi_plugin_dlteams_processeddatas' => "id",

                    ],
                ],
            ],
            'ORDER' => [
                'glpi_plugin_dlteams_records_items.timeline_position',
//                'pdnumber ASC',
            ],
            'WHERE' => [
                'OR' => [
                    [
                        'glpi_plugin_dlteams_records_items.records_id' => $record->fields['id'],
                        'glpi_plugin_dlteams_records_items.itemtype' => 'PluginDlteamsConcernedPerson',
                        'glpi_plugin_dlteams_records_items.itemtype1' => null,
                        'glpi_plugin_dlteams_concernedpersons.is_deleted' => 0,
                    ]+($onlysensitive?['glpi_plugin_dlteams_processeddatas.rgpd_sensitive_data' => 1]:[]),
                    [
                        'glpi_plugin_dlteams_records_items.records_id' => $record->fields['id'],
                        'glpi_plugin_dlteams_records_items.itemtype' => 'PluginDlteamsConcernedPerson',
                        'glpi_plugin_dlteams_records_items.itemtype1' => 'PluginDlteamsProcessedData',
                        'glpi_plugin_dlteams_records_items.items_id1' => 0,
                        'glpi_plugin_dlteams_concernedpersons.is_deleted' => 0,
                    ]+($onlysensitive?['glpi_plugin_dlteams_processeddatas.rgpd_sensitive_data' => 1]:[]),
                    [
                        'glpi_plugin_dlteams_records_items.records_id' => $record->fields['id'],
                        'glpi_plugin_dlteams_records_items.itemtype' => null,
                        'glpi_plugin_dlteams_records_items.itemtype1' => 'PluginDlteamsProcessedData',
                        'glpi_plugin_dlteams_processeddatas.is_deleted' => 0,
                    ]+($onlysensitive?['glpi_plugin_dlteams_processeddatas.rgpd_sensitive_data' => 1]:[]),
                    [
                        'glpi_plugin_dlteams_records_items.records_id' => $record->fields['id'],
                        'glpi_plugin_dlteams_records_items.itemtype' => 'PluginDlteamsConcernedPerson',
                        'glpi_plugin_dlteams_records_items.items_id' => 0,
                        'glpi_plugin_dlteams_records_items.itemtype1' => 'PluginDlteamsProcessedData',
                        'glpi_plugin_dlteams_processeddatas.is_deleted' => 0,
                    ]+($onlysensitive?['glpi_plugin_dlteams_processeddatas.rgpd_sensitive_data' => 1]:[]),
                    [
                        'glpi_plugin_dlteams_records_items.records_id' => $record->fields['id'],
                        'glpi_plugin_dlteams_records_items.itemtype' => 'PluginDlteamsConcernedPerson',
                        'glpi_plugin_dlteams_records_items.itemtype1' => 'PluginDlteamsProcessedData',
                        'glpi_plugin_dlteams_concernedpersons.is_deleted' => 0,
                        'glpi_plugin_dlteams_processeddatas.is_deleted' => 0,
                    ]+($onlysensitive?['glpi_plugin_dlteams_processeddatas.rgpd_sensitive_data' => 1]:[])
                ],
            ],
        ];


        return $query;
    }

    /**
     * Normalise la colonne timeline_position pour un enregistrement donné.
     *
     * @param int $recordsId  L’ID du PluginDlteamsRecord parent.
     */
    public static function normalizeTimelinePositions(int $recordsId) {
        global $DB;

        // 1. Charger l’objet parent et construire la requête GLPI
        $record = new PluginDlteamsRecord();
        $record->getFromDB($recordsId);
        $query    = self::getRequest($record);
        $iterator = $DB->request($query);

        // 2. Parcourir et réassigner les positions
        $position = 1;
        $DB->beginTransaction();
        try {
            foreach ($iterator as $row) {
                $linkid = $row['linkid'];
                if ((int)$row['timeline_position'] !== $position) {
                    $DB->update(
                        'glpi_plugin_dlteams_records_items',
                        ['timeline_position' => $position],
                        ['id'                => $linkid]
                    );
                }
                $position++;
            }
            $DB->commit();
        } catch (\Exception $e) {
            $DB->rollbackTransaction();
            // Vous pouvez loguer l’erreur ou afficher un message
            Session::addMessageAfterRedirect(
                __('Erreur lors de la normalisation des positions :').' '.$e->getMessage(),
                false,
                ERROR
            );
        }
    }

    protected function toggleMandatory($input)
    {
        $this->fields['mandatory'] = $input['mandatory'];
        return $this->updateInDB(['mandatory']);
    }

    /**
     * Export in an array all the data of the current instanciated PluginDlteamsRecord_PersonalAndDataCategory
     * @param boolean $remove_uuid remove the uuid key
     *
     * @return array the array with all data (with sub tables)
     */
    public function exportToDB($remove_uuid = false, $subItems = [])
    {
        if ($this->isNewItem()) {
            return false;
        }

        $personal_data_catagory = $this->fields;
        return $personal_data_catagory;
    }


    public static function importToDB(PluginDlteamsLinker $linker, $input = [], $record_id = 0, $subItems = [])
    {
        $recordFk = PluginDlteamsRecord::getForeignKeyField();
        $input[$recordFk] = $record_id;

        $item = new self();
        $originalId = $input['id'];
        unset($input['id']);
        $itemId = $item->add($input);
        if ($itemId === false) {
            $typeName = strtolower(self::getTypeName());
            throw new ImportFailureException(sprintf(__('failed to copy the %1$s record', 'dlteams'), $input['name']));
        }
        $linker->addObject($originalId, $item);
        return $itemId;
    }

    public function deleteObsoleteItems(CommonDBTM $container, array $exclude)
    {
    }


    public function post_purgeItem()
    {
//        purge relation 1
        if ($this->fields["itemtype"] && $this->fields["items_id"]) {
            $relation_item_str = $this->fields["itemtype"] . "_Item";
            if (!class_exists($relation_item_str))
                $relation_item_str = "PluginDlteams" . $relation_item_str;
            $relation_item = new $relation_item_str();

            $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype"]))) . "s_id";

            $criteria = [
                "itemtype" => "PluginDlteamsRecord",
                "items_id" => $this->fields["records_id"],
                $relation_column_id => $this->fields["items_id"],
                "itemtype1" => $this->fields["itemtype1"],
                "items_id1" => $this->fields["items_id1"],
                "comment" => $this->fields["comment"]
            ];

            if ($relation_item->deleteByCriteria($criteria))
                Session::addMessageAfterRedirect("Relation " . $relation_item::getTypeName() . " supprimé avec succès");
        }


        //        purge relation 2
        if ($this->fields["itemtype1"] && $this->fields["items_id1"]) {

            $relation_item_str = $this->fields["itemtype1"] . "_Item";
            if (!class_exists($relation_item_str))
                $relation_item_str = "PluginDlteams" . $relation_item_str;
            $relation_item = new $relation_item_str();

            $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype1"]))) . "s_id";

            $criteria = [
                "itemtype" => "PluginDlteamsRecord",
                "items_id" => $this->fields["records_id"],
                $relation_column_id => $this->fields["items_id1"],
                "itemtype1" => $this->fields["itemtype"],
                "items_id1" => $this->fields["items_id"],
                "comment" => $this->fields["comment"]
            ];

            if ($relation_item->deleteByCriteria($criteria))
                Session::addMessageAfterRedirect("Relation " . $relation_item::getTypeName() . " supprimé avec succès");
        }
    }
}
