<?php
/**
-------------------------------------------------------------------------
LICENSE

This file is part of Reports plugin for GLPI.

Reports is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Reports is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with Reports. If not, see <http://www.gnu.org/licenses/>.

@package   reports
@license   AGPL License 3.0 or (at your option) any later version
-------------------------------------------------------------------------
 */

$USEDBREPLICATE        = 1;
$DBCONNECTION_REQUIRED = 0;

include ("../../../../inc/includes.php");

$dbu = new DbUtils();

$report = new PluginReportsAutoReport(__('Liste des accès', 'dlteams'));
$report->displayCriteriasForm();

$columns = [
    new PluginReportsColumn('name', __('Intitulé'), ['sorton' => 'name']),
    new PluginReportsColumn('annuaire', __('Annuaire'), ['sorton' => 'annuaire']),
    new PluginReportsColumn('keytypename', __('Type'), ['sorton' => 'keytypename']),
    new PluginReportsColumn('permissions', __('Permissions'), ['sorton' => 'permissions']),
    new PluginReportsColumn('comment', __('Comment'), ['sorton' => 'comment']),
    new PluginReportsColumn('attribution', __('Attribution'), ['sorton' => 'attribution']),
];
$report->setColumns($columns);

$query = "
SELECT
  aki.`id` AS `linkid`,
  aki.*,
  dc.`name` AS `datacataloguename`,
  ak.`name` AS `name`,
  kt.`name` AS `keytypename`,
  annu.`name` AS `annuaire`,
  (
    SELECT GROUP_CONCAT(up.name SEPARATOR ', ')
    FROM JSON_TABLE(aki.`profiles_json`, '$[*]' COLUMNS (profile_id INT PATH '$')) AS jt
    LEFT JOIN `glpi_plugin_dlteams_userprofiles` AS up ON up.id = jt.profile_id
  ) AS `permissions`,
  kt.`id` AS `keytypeid`,
  (
    SELECT CONCAT(
         COUNT(aki2.id), ': ',
         IFNULL(GROUP_CONCAT(u.name SEPARATOR ', '), '')
    )
    FROM `glpi_plugin_dlteams_accountkeys_items` AS aki2
    LEFT JOIN `glpi_users` AS u ON u.id = aki2.items_id
    WHERE aki2.itemtype IN ('Group','Supplier','Contact','User')
      AND aki2.accountkeys_id = ak.id
  ) AS `attribution`
FROM `glpi_plugin_dlteams_accountkeys_items` AS aki
LEFT JOIN `glpi_plugin_dlteams_accountkeys` AS ak ON ak.`id` = aki.`accountkeys_id`
LEFT JOIN `glpi_plugin_dlteams_keytypes` AS kt ON ak.`plugin_dlteams_keytypes_id` = kt.`id`
LEFT JOIN `glpi_plugin_dlteams_datacatalogs` AS dc ON dc.`id` = aki.`items_id`
LEFT JOIN `glpi_plugin_dlteams_datacatalogs` AS annu ON ak.`plugin_dlteams_datacatalogs_id` = annu.`id`
WHERE aki.`itemtype` = 'PluginDlteamsDataCatalog'
  AND ak.`is_deleted` = '0'
ORDER BY dc.`name` ASC, ak.`name` ASC
";


$report->setSqlRequest($query);
$report->execute();
