<?php
$USEDBREPLICATE        = 1;
$DBCONNECTION_REQUIRED = 0;

include("../../../../inc/includes.php");

$dbu = new DbUtils();
$report = new PluginReportsAutoReport(__('Revue des accès par utilisateur', 'dlteams'));
$report->displayCriteriasForm();

$columns = [
    new PluginReportsColumn('user',         __('Utilisateur')),
    new PluginReportsColumn('annuaire',     __('Annuaire')),
    new PluginReportsColumn('keytypename',  __('Type')),
    new PluginReportsColumn('permissions',  __('Permissions')),
    new PluginReportsColumn('comment',      __('Comment')),
    new PluginReportsColumn('account',      __('Compte')),
];
$report->setColumns($columns);

$query = "
SELECT
  u.`name` AS `user`,
  annu.`name` AS `annuaire`,
  kt.`name` AS `keytypename`,
  (
    SELECT GROUP_CONCAT(up.name SEPARATOR ', ')
    FROM JSON_TABLE(aki.`profiles_json`, '\$[*]' COLUMNS (profile_id INT PATH '\$')) AS jt
    LEFT JOIN `glpi_plugin_dlteams_userprofiles` AS up ON up.id = jt.profile_id
  ) AS `permissions`,
  aki.`comment` AS `comment`,
  ak.`name` AS `account`
FROM `glpi_plugin_dlteams_accountkeys_items` AS aki
LEFT JOIN `glpi_plugin_dlteams_accountkeys` AS ak ON ak.`id` = aki.`accountkeys_id`
LEFT JOIN `glpi_users` AS u ON u.`id` = aki.`items_id`
LEFT JOIN `glpi_plugin_dlteams_keytypes` AS kt ON ak.`plugin_dlteams_keytypes_id` = kt.`id`
LEFT JOIN `glpi_plugin_dlteams_datacatalogs` AS annu ON ak.`plugin_dlteams_datacatalogs_id` = annu.`id`
WHERE aki.`itemtype` = 'User'
  AND ak.`is_deleted` = '0'
ORDER BY u.`name`, ak.`name`
";
$report->setGroupBy(['user']);

$report->setSqlRequest($query);
$report->execute();
