<?php

/**
 * ---------------------------------------------------------------------
 * DLTeams plugin for GLPI
 * ---------------------------------------------------------------------
 * LICENSE : This file is part of DLTeams Plugin.
 *
 * DLTeams Plugin is a GNU Free Copylefted software.
 * ---------------------------------------------------------------------
 */

$AJAX_INCLUDE = 1;
include('../../../inc/includes.php');

// Send UTF8 Headers
header("Content-Type: text/html; charset=UTF-8");
Html::header_nocache();

Session::checkLoginUser();

if (
    (!isset($_REQUEST['params']['_idor_token']) || empty($_REQUEST['params']['_idor_token'])) || !isset($_REQUEST['itemtype'])
    || !isset($_REQUEST['widget'])
) {
    http_response_code(400);
    die();
}

$idor = $_REQUEST['params']['_idor_token'];
unset($_REQUEST['params']['_idor_token']);

if (
    !Session::validateIDOR([
        'itemtype'     => $_REQUEST['itemtype'],
        '_idor_token'  => $idor
    ] + $_REQUEST['params'])
) {
    http_response_code(400);
    die();
}

/** @var class-string<CommonDBTM> $itemtype */
$itemtype = $_REQUEST['itemtype'];
$params = $_REQUEST['params'];

switch ($_REQUEST['widget']) {
    case 'central_count':
        if (method_exists($itemtype, 'showCentralCount')) {
            $itemtype::showCentralCount($params['foruser'] ?? false);
        }
        break;
    case 'central_list':
        // Classes GLPI standard
        if (method_exists($itemtype, 'showCentralList')) {
            if (is_subclass_of($itemtype, CommonITILObject::class) || is_subclass_of($itemtype, CommonITILTask::class)) {
                $showgrouptickets = isset($params['showgrouptickets']) ? ($params['showgrouptickets'] !== 'false') : false;
                $itemtype::showCentralList($params['start'] ?? 0, $params['status'] ?? 'process', $showgrouptickets);
            } else {
                // Classes dlteams et autres classes avec showCentralList
                $itemtype::showCentralList($params['start'] ?? 0, $params['status'] ?? 'process', false);
            }
        } else if ($itemtype === RSSFeed::class) {
            $personal = $params['personal'] !== 'false';
            $itemtype::showListForCentral($personal);
        } else if ($itemtype === Planning::class) {
            $itemtype::showCentral($params['who']);
        } else if ($itemtype === Reminder::class) {
            $personal = ($params['personal'] ?? true) !== 'false';
            $itemtype::showListForCentral($personal);
        } else if ($itemtype === Event::class) {
            // Gestion spéciale pour Event
            echo "<div class='text-center text-muted p-4'>";
            echo "<i class='fas fa-calendar-alt fa-2x mb-2'></i><br>";
            echo __('Recent events');
            echo "</div>";
        } else if ($itemtype === Document::class) {
            // Gestion spéciale pour Document
            echo "<div class='text-center text-muted p-4'>";
            echo "<i class='fas fa-file fa-2x mb-2'></i><br>";
            echo __('Recent documents');
            echo "</div>";
        } else if ($itemtype === Contract::class) {
            // Gestion spéciale pour Contract
            echo "<div class='text-center text-muted p-4'>";
            echo "<i class='fas fa-handshake fa-2x mb-2'></i><br>";
            echo __('Recent contracts');
            echo "</div>";
        } else if ($itemtype === Notepad::class) {
            // Gestion spéciale pour Notepad
            echo "<div class='text-center text-muted p-4'>";
            echo "<i class='fas fa-sticky-note fa-2x mb-2'></i><br>";
            echo __('Recent notes');
            echo "</div>";
        } else if ($itemtype === KnowbaseItem::class) {
            // Gestion spéciale pour KnowbaseItem
            echo "<div class='text-center text-muted p-4'>";
            echo "<i class='fas fa-book fa-2x mb-2'></i><br>";
            echo __('Recent knowledge base items');
            echo "</div>";
        } else if ($itemtype === ITILFollowup::class) {
            // Gestion spéciale pour ITILFollowup
            echo "<div class='text-center text-muted p-4'>";
            echo "<i class='fas fa-comments fa-2x mb-2'></i><br>";
            echo __('Recent followups');
            echo "</div>";
        } else if (class_exists('PluginFormcreatorFormAnswer') && $itemtype === 'PluginFormcreatorFormAnswer') {
            // Gestion spéciale pour FormCreator
            echo "<div class='text-center text-muted p-4'>";
            echo "<i class='fas fa-wpforms fa-2x mb-2'></i><br>";
            echo __('Recent form answers');
            echo "</div>";
        } else {
            echo "<div class='text-center text-muted p-4'>";
            echo "<i class='fas fa-info-circle fa-2x mb-2'></i><br>";
            echo sprintf(__('Widget not implemented for %s'), $itemtype);
            echo "</div>";
        }
        break;
    default:
        echo __('Invalid widget');
}
