<?php

/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include("../../../inc/includes.php");

$rand = mt_rand();
$linkid = $_POST["linkid"];

if(isset($_POST["action"]) && $_POST["action"] == "edit_liceite_retention"){
    echo "<form name='ticketitem_form$rand' id='ticketitem_form$rand' method='post'
            action='" . Toolbox::getItemTypeFormURL(PluginDlteamsStoragePeriod_Item::class) . "'>";
    echo "<input type='hidden' name='linkid' value='" . $linkid . "' />";
    $storageperiod_item = new PluginDlteamsStoragePeriod_Item();
    $storageperiod_item->getFromDB($linkid);
    echo "<div style='display: flex; flex-direction: column; gap: 1rem;'>";
    echo "<div style='display: flex; flex-direction: column; gap: 0.5rem;'>";
    echo "<label>";
    echo __("Specify the retention periods and the future of the personal data concerned by this processing", 'dlteams');
    echo "</label>";
    PluginDlteamsStoragePeriod::dropdown([
        'addicon' => PluginDlteamsStoragePeriod::canCreate(),
        'name' => 'plugin_dlteams_storageperiods_id',
        'value' => $storageperiod_item->fields["storageperiods_id"],
        'width' => '200px'
    ]);
    echo "</div>";


    echo "<div style='display: flex; flex-direction: column; gap: 0.5rem;'>";
    echo "<label>";
    echo __("Stockage", 'dlteams');
    echo "</label>";
    PluginDlteamsStorageType::dropdown([
        'addicon' => PluginDlteamsStorageType::canCreate(),
        'name' => 'plugin_dlteams_storagetypes_id',
        'value' => $storageperiod_item->fields["plugin_dlteams_storagetypes_id"],
        'width' => '250px',
    ]);
    echo "</div>";


    echo "<div style='display: flex; flex-direction: column; gap: 0.5rem;'>";
    echo "<label>";
    echo __("Action Fin Periode", 'dlteams');
    echo "</label>";
    PluginDlteamsStorageEndAction::dropdown([
        'addicon' => PluginDlteamsStorageEndAction::canCreate(),
        'name' => 'plugin_dlteams_storageendactions_id',
        'value' => $storageperiod_item->fields["plugin_dlteams_storageendactions_id"],
        'width' => '200px',
    ]);
    echo "</div>";


    echo "<div style='display: flex; flex-direction: column; gap: 0.5rem;'>";
    echo "<label>";
    echo __("Commentaires", 'dlteams');
    echo "</label>";
    Html::textarea(['name' => 'storage_comment',
        'value' => $storageperiod_item->fields["comment"],
        'class' => 'storage_comment1',
        'cols' => 60,
        'rows' => 3,
        'enable_richtext' => true]);
    echo "</div>";

    echo "<div style='width: 100%; align-items: center; justify-content: center; display: flex'>";
    echo "<input type='submit' style='width: fit-content' class='submit' name='update' value='" . __("Mettre à jour", 'dlteams') . "' />";
    echo "</div>";
    Html::closeForm();
//$storageperiod_item->

    echo "</div>";
}

if(isset($_POST["action"]) && $_POST["action"] == "edit_record_acteur_externe"){
//    var_dump("zzz");
//    die();
    echo "<form name='ticketitem_form$rand' id='ticketitem_form$rand' method='post'
            action='" . Toolbox::getItemTypeFormURL(PluginDlteamsRecord_External::class) . "'>";
    echo "<input type='hidden' name='linkid' value='" . $linkid . "' />";
    $record_item = new PluginDlteamsRecord_Item();
    $record_item->getFromDB($linkid);
    $record = new PluginDlteamsRecord();
    $record->getFromDB($record_item->fields["records_id"]);

    $destinataire_itemtype_str = $record_item->fields["itemtype"];
    $destinataire_itemtype = new $destinataire_itemtype_str();
    echo "<div style='display: flex; flex-direction: column; gap: 1rem;'>";
    echo "<div style='display: flex; flex-direction: column; gap: 0.5rem;'>";
    echo "<label>";
    echo __("Destinataire", 'dlteams');
    echo "</label>";

    echo "<div style='display: flex; gap: 1rem;'>";
    $rand = Dropdown::showFromArray("itemtype", [
        __("------", 'dlteams'),
        PluginDlteamsConcernedPerson::class => __("Personnes Concernees", 'dlteams'),
        PluginDlteamsThirdPartyCategory::class => __("Tiers Categories", 'dlteams'),
        Supplier::class => __("Tiers", 'dlteams'),
    ], [
        'value' => $record_item->fields["itemtype"],
        'width' => '150px',
    ]);

    echo "<span id='itemtype_row$rand' style='margin-left:5px!important'></span>";
    echo "</div>";


    $dropdown_id = "dropdown_itemtype" . $rand;
    global $CFG_GLPI;
    $target_id = "itemtype_row" . $rand;
    $ajax_url = $CFG_GLPI['root_doc'] . '/marketplace/dlteams/ajax/general_item_dropdown.php';
    $real_items_id = (int)$record_item->fields["items_id"];
    $class_to_check = $record_item->fields["itemtype"];

    $javascript_template = <<<'JS'
<script type="text/javascript">
$(function() {
    $('#%s').on('change', function() {
        let selectedValue = $(this).val();

        let itemsIdToSend = 0;

        const itemtypeToSend = '%s';
        const realItemsId = %d;

        if (selectedValue === itemtypeToSend) {
            itemsIdToSend = realItemsId;
        }
        
        $.ajax({
            type: 'POST',
            url: '%s',
            data: {
                itemtype: selectedValue,
                items_id: itemsIdToSend
            },
            success: function(response) {
                $('#%s').html(response);
            }
        });
    }).trigger('change')
});
</script>
JS;

    echo sprintf(
        $javascript_template,
        $dropdown_id,
        $class_to_check,
        $real_items_id,
        $ajax_url,
        $target_id
    );

    echo "</div>";



    echo "<div style='display: flex; flex-direction: column; gap: 1rem;'>";
    echo "<div style='display: flex; flex-direction: column; gap: 0.5rem;'>";
    echo "<label>";
    echo __("Motif d'envoi ", 'dlteams');
    echo "</label>";
    PluginDlteamsSendingReason::dropdown([
        'addicon' => PluginDlteamsSendingReason::canCreate(),
        'value' => $record_item->fields["items_id1"],
        'name' => 'items_id1',
        'width' => '250px'
    ]);
    echo "</div>";


    echo "<div style='display: flex; flex-direction: column; gap: 0.5rem;'>";
    echo "<label>";
    echo __("Données/Commentaires", 'dlteams');
    echo "</label>";
    echo "<textarea type='text' maxlength=600 rows='3' name='comment' placeholder='Commentaire'>". $record_item->fields["comment"] ."</textarea>";
    echo "</div>";


    echo "<div style='width: 100%; align-items: center; justify-content: center; display: flex'>";
    echo "<input type='submit' style='width: fit-content' class='submit' name='update_edit_record_acteur_externe' value='" . __("Mettre à jour", 'dlteams') . "' />";
    echo "</div>";
    echo "</div>";

    Html::closeForm();
//$storageperiod_item->



    echo "</div>";
}

if(isset($_POST["action"]) && $_POST["action"] == "edit_legalbasis"){

    $item_str = $_POST["itemtype"];
    $item = new $item_str();
    $item->getFromDB($_POST["items_id"]);
    $iterator = PluginDlteamsLegalBasi_Item::getRequest($item);
    $used = [];

    foreach ($iterator as $data) {
//        $items_list[$data['linkid']] = $data;
        $used[$data['id']] = $data['id'];
    }


    echo "<form name='ticketitem_form$rand' id='ticketitem_form$rand' method='post'
            action='" . Toolbox::getItemTypeFormURL(PluginDlteamsLegalBasi_Item::class) . "'>";
    echo "<input type='hidden' name='linkid' value='" . $linkid . "' />";
    echo "<input type='hidden' name='itemtype' value='" . $_POST["itemtype"] . "' />";
    echo "<input type='hidden' name='items_id' value='" . $_POST["items_id"] . "' />";
    $legalbasi_item = new PluginDlteamsLegalBasi_Item();
    $legalbasi_item->getFromDB($linkid);
    echo "<div style='display: flex; flex-direction: column; gap: 1rem;'>";
    echo "<div style='display: flex; flex-direction: column; gap: 0.5rem;'>";
    echo "<label>";
    echo __("Add Legal Basis to record", 'dlteams');
    echo "</label>";


    global $CFG_GLPI;
    Dropdown::show(PluginDlteamsLegalbasi::class, [
        'addicon' => PluginDlteamsLegalbasi::canCreate(),
        'name' => 'legalbasis_id',
        'value' => $legalbasi_item->fields["legalbasis_id"],
        'used' => $used,
        'url' => $CFG_GLPI['root_doc'] . "/marketplace/dlteams/ajax/getDropdownValue.php"
    ]);

    echo "</div>";


    echo "<div style='display: flex; flex-direction: column; gap: 0.5rem;'>";
    echo "<label>";
    echo __("Commentaires", 'dlteams');
    echo "</label>";
    Html::textarea(['name' => 'comment',
        'value' => $legalbasi_item->fields["comment"],
        'class' => 'storage_comment1',
        'cols' => 60,
        'rows' => 3,
        'enable_richtext' => false]);
    echo "</div>";

    echo "<div style='width: 100%; align-items: center; justify-content: center; display: flex'>";
    echo "<input type='submit' style='width: fit-content' class='submit' name='update' value='" . __("Mettre à jour", 'dlteams') . "' />";
    echo "</div>";
    Html::closeForm();
//$storageperiod_item->

    echo "</div>";
}

// Action pour le personne donnée policie
if(isset($_POST["action"]) && $_POST["action"] == "edit_ppd"){

    $item_str = $_POST["itemtype"];
    $item = new $item_str();
    $item->getFromDB($_POST["items_id"]);
    $iterator = PluginDlteamsLegalBasi_Item::getRequest($item);
    $used = [];

    foreach ($iterator as $data) {
//        $items_list[$data['linkid']] = $data;
        $used[$data['id']] = $data['id'];
    }


    echo "<form name='ticketitem_form$rand' id='ticketitem_form$rand' method='post'
            action='" . Toolbox::getItemTypeFormURL(PluginDlteamsPolicieForm_Item::class) . "'>";
    echo "<input type='hidden' name='linkid' value='" . $linkid . "' />";
    echo "<input type='hidden' name='itemtype' value='" . $_POST["itemtype"] . "' />";
    echo "<input type='hidden' name='items_id' value='" . $_POST["items_id"] . "' />";
//    $legalbasi_item = new PluginDlteamsLegalBasi_Item();
//    $legalbasi_item->getFromDB($linkid);
    echo "<div style='display: flex; flex-direction: column; gap: 1rem;'>";
//    echo "<div style='display: flex; flex-direction: column; gap: 0.5rem;'>";
//    echo "<label>";
//    echo _n("People category", "People categories", 0, 'dlteams');
//    echo "</label>";
//
    $linkid = $_POST['linkid'];
    $policieForm_item = new  PluginDlteamsPolicieForm_Item();
    $policieForm_item->getFromDB($linkid);
//
//
//    global $CFG_GLPI;
//    PluginDlteamsConcernedPerson::dropdown([
//        'name' => 'items_id',
//        'rand' => $rand,
//        'width' => '100%',
//        'value' => $policieForm_item->fields['items_id'],
//        'url' => "{$CFG_GLPI['root_doc']}/marketplace/dlteams/ajax/getDropdownValue.php",
//    ]);
//
//    echo "</div>";


//    echo "<div style='display: flex; flex-direction: column; gap: 0.5rem;'>";
//    echo "<label>";
//    echo _n("Data type", "Data types", 0, 'dlteams');
//    echo "</label>";
//
//    global  $DB;
//    $policieForm = new PluginDlteamsPolicieForm();
//    $policieForm->getFromDB($policieForm_item->fields['policieforms_id']);
//    $iterator = $DB->request(PluginDlteamsPolicieForm_PersonalAndDataCategory::getRequest($policieForm));
//    $itemsList = [];
//    foreach ($iterator as $row) {
//        $itemsList[$row['linkid']] = $row;
//    }
//
//    // Prepare "used" data types based on recent selection
//    $recentPersonId = $_SESSION['dlteams_pf_recent_concernedperson'] ?? null;
//    $usedDataTypes = [];
//    if ($recentPersonId) {
//        $filtered = array_filter(
//            $itemsList,
//            fn($item) => $item['items_id'] === $recentPersonId
//        );
//        $usedDataTypes = array_column($filtered, 'items_id1');
//    }
//
//    PluginDlteamsProcessedData::dropdown([
//        'name' => 'items_id1',
//        'used' => $usedDataTypes,
//        'value' => $policieForm_item->fields['items_id1'],
//        'width' => '100%',
//        'url' => "{$CFG_GLPI['root_doc']}/marketplace/dlteams/ajax/getDropdownValue.php",
//    ]);
//    echo "</div>";

    // Mandatory
    echo "<div style='display: flex; flex-direction: column; gap: 0.5rem;'>";
    echo "<label>";
    echo __("Mandatory", 'dlteams');
    echo "</label>";
    Dropdown::showYesNo('mandatory', $policieForm_item->fields['mandatory']);
    echo "</div>";

// Comment
    echo "<div style='display: flex; flex-direction: column; gap: 0.5rem;'>";
    echo "<label>";
    echo __("Comment", 'dlteams');
    echo "</label>";
    Html::textarea([
        'name' => 'comment',
        'enable_fileupload' => false,
        'cols' => 20,
        'rows' => 2,
        'value'=> $policieForm_item->fields['comment'],
        'placeholder' => 'Commentaires'
    ]);
    echo "</div>";

    echo "<div style='width: 100%; align-items: center; justify-content: center; display: flex'>";
    echo "<input type='submit' style='width: fit-content' class='submit' name='update' value='" . __("Mettre à jour", 'dlteams') . "' />";
    echo "</div>";
    Html::closeForm();
//$storageperiod_item->

    echo "</div>";
}


if(isset($_POST["action"]) && $_POST["action"] == "edit_policieform_item"){

    $item_str = $_POST["itemtype"];
    $item = new $item_str();
    $item->getFromDB($_POST["items_id"]);
//    $iterator = PluginDlteamsRecord_Element::getPolicyFormRequest($item);
//    $used = [];
//
//    foreach ($iterator as $data) {
////        $items_list[$data['linkid']] = $data;
//        $used[$data['id']] = $data['id'];
//    }


    $pi = new PluginDlteamsPolicieForm_Item();
    $pi->getFromDB($linkid);

    echo "<form name='ticketitem_form$rand' id='ticketitem_form$rand' method='post'
            action='" . Toolbox::getItemTypeFormURL(PluginDlteamsPolicieForm_Item::class) . "'>";
    echo "<input type='hidden' name='linkid' value='" . $linkid . "' />";
    echo "<input type='hidden' name='itemtype' value='" . $_POST["itemtype"] . "' />";
    echo "<input type='hidden' name='items_id' value='" . $_POST["items_id"] . "' />";
    echo "<div style='display: flex; flex-direction: column; gap: 1rem;'>";
    echo "<div style='display: flex; flex-direction: column; gap: 0.5rem;'>";
    echo "<label>";
    echo __("Obligatoire");
    echo "</label>";

//    var_dump($pi->fields);
//    die();

    global $CFG_GLPI;
    $ri = new PluginDlteamsRecord_Item();
    $ri->getFromDBByCrit([
        "itemtype"  => PluginDlteamsPolicieForm::class,
        "items_id"  => $pi->fields["policieforms_id"],
        "records_id" => $pi->fields["items_id"],
        "comment"   => addslashes($pi->fields["comment"]),
    ]);
    Dropdown::showYesNo("mandatory", $ri->fields["mandatory"]);

    echo "</div>";


    echo "<div style='display: flex; flex-direction: column; gap: 0.5rem;'>";
    echo "<label>";
    echo __("Commentaires", 'dlteams');
    echo "</label>";
    Html::textarea(['name' => 'comment',
        'value' => $pi->fields["comment"],
        'class' => 'storage_comment1',
        'cols' => 60,
        'rows' => 3,
        'enable_richtext' => false]);
    echo "</div>";

    echo "<div style='width: 100%; align-items: center; justify-content: center; display: flex'>";
    echo "<input type='submit' style='width: fit-content' class='submit' name='update' value='" . __("Mettre à jour", 'dlteams') . "' />";
    echo "</div>";
    Html::closeForm();
//$storageperiod_item->

    echo "</div>";
}

if(isset($_POST["action"]) && $_POST["action"] == "edit_record_acteurs"){

    echo "<form name='ticketitem_form$rand' id='ticketitem_form$rand' method='post'
            action='" . Toolbox::getItemTypeFormURL(PluginDlteamsActeur_Item::class) . "'>";
    echo "<input type='hidden' name='linkid' value='" . $linkid . "' />";
    $record_item = new PluginDlteamsRecord_Item();
    $record_item->getFromDB($linkid);
    $record = new PluginDlteamsRecord();
    $record->getFromDB($record_item->fields["records_id"]);


    echo "<div style='display: flex; flex-direction: column; gap: 0.5rem;'>";
    echo "<label>";
    echo __("Rôle", 'dlteams');
    echo "</label>";
    echo "<textarea  maxlength=600 rows='3' name='comment' placeholder='Commentaire'>". $record_item->fields["comment"] ."</textarea>";
    echo "</div>";


    echo "<div style='width: 100%; align-items: center; justify-content: center; display: flex; margin-top: 1rem'>";
    echo "<input type='submit' style='width: fit-content' class='submit' name='update_edit_record_acteur' value='" . __("Mettre à jour", 'dlteams') . "' />";
    echo "</div>";
//    echo "</div>";

    Html::closeForm();



    echo "</div>";
}


if(isset($_POST["action"]) && $_POST["action"] == "edit_appliance_acteurs"){

    echo "<form name='ticketitem_form$rand' id='ticketitem_form$rand' method='post'
            action='" . Toolbox::getItemTypeFormURL(PluginDlteamsAppliance_Actor::class) . "'>";
    echo "<input type='hidden' name='linkid' value='" . $linkid . "' />";
    $appliance_item = new Appliance_Item();
    $appliance_item->getFromDB($linkid);
    $appliance = new Appliance();
    $appliance->getFromDB($appliance_item->fields["appliances_id"]);


    echo "<div style='display: flex; flex-direction: column; gap: 0.5rem;'>";
    echo "<label>";
    echo __("Rôle", 'dlteams');
    echo "</label>";
    echo "<textarea  maxlength=600 rows='3' name='comment' placeholder='Commentaire'>". $appliance_item->fields["comment"] ."</textarea>";
    echo "</div>";


    echo "<div style='width: 100%; align-items: center; justify-content: center; display: flex; margin-top: 1rem'>";
    echo "<input type='submit' style='width: fit-content' class='submit' name='update_edit_appliance_acteur' value='" . __("Mettre à jour", 'dlteams') . "' />";
    echo "</div>";
//    echo "</div>";

    Html::closeForm();



    echo "</div>";
}


if(isset($_POST["action"]) && $_POST["action"] == "edit_record_right"){
//    var_dump("zzz");
//    die();
    echo "<form name='ticketitem_form$rand' id='ticketitem_form$rand' method='post'
            action='" . Toolbox::getItemTypeFormURL(PluginDlteamsRightMeasure_Item::class) . "'>";
    echo "<input type='hidden' name='linkid' value='" . $linkid . "' />";
    $rm_item = new PluginDlteamsRightMeasure_Item();
    $rm_item->getFromDB($linkid);



    echo "<div style='display: flex; flex-direction: column; gap: 0.5rem;'>";
    echo "<label>";
    echo __("Comment");
    echo "</label>";

    Html::textarea(['name' => 'comment',
        'enable_fileupload' => false,
//        'editor_id' => 'rr_id',
        'enable_richtext' => true,
        'value' => $rm_item->fields["comment"],

    ]);
//    echo "<textarea  maxlength=600 rows='3' name='comment' placeholder='Commentaire'>". $record_item->fields["comment"] ."</textarea>";
    echo "</div>";


    echo "<div style='width: 100%; align-items: center; justify-content: center; display: flex; margin-top: 1rem'>";
    echo "<input type='submit' style='width: fit-content' class='submit' name='update_edit_record_right' value='" . __("Mettre à jour", 'dlteams') . "' />";
    echo "</div>";
//    echo "</div>";

    Html::closeForm();
//$storageperiod_item->



    echo "</div>";
}