<?php

/**
 * ---------------------------------------------------------------------
 *
 * GLPI – Gestionnaire Libre de Parc Informatique
 *
 * signup.php – API AJAX pour création de compte et gestion des entités
 *
 * @since     0.85
 * @copyright 2015-2025 Teclib’ and contributors.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 * ---------------------------------------------------------------------
 */
const GLPI_USE_CSRF_CHECK = 0;
$SECURITY_STRATEGY = 'no_check';
include("../../../inc/includes.php");
//session_start();
use Glpi\Application\View\TemplateRenderer;
use Glpi\Toolbox\Sanitizer;

/** @var array   $CFG_GLPI */
/** @var \DBmysql $DB      */
global $CFG_GLPI, $DB;

// ---------------------------------------------------------------------
// Lecture de l’action envoyée en POST
// ---------------------------------------------------------------------
$action = isset($_POST['action']) ? Sanitizer::sanitize($_POST['action']) : '';
header('Content-Type: application/json; charset=utf-8');
//var_dump($action);
//die();
switch ($action) {

    // -------------------------------------------------------------
    // 1) Vérifier si l’e-mail existe dans DLTeams (table glpi_useremails)
    //    Retour JSON : success = true si l’utilisateur existe, sinon false + message
    // -------------------------------------------------------------
    case 'checkEmail':
        $emailRaw = trim($_POST['email'] ?? '');
        $email    = strtolower($emailRaw);

        if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
            echo json_encode([
                'success' => false,
                'message' => "Format d’adresse e-mail invalide."
            ]);
            break;
        }

        // Requête pour vérifier l’existence dans glpi_useremails
        $emailEscaped = $DB->escape($email);
        $result       = $DB->request([
            'SELECT' => ['users_id'],
            'FROM'   => 'glpi_useremails',
            'WHERE'  => ['email' => $emailEscaped],
            'LIMIT'  => 1
        ]);

        $userId = 0;
        foreach ($result as $row) {
            $userId = (int)$row['users_id'];
            break;
        }

//        if ($userId <= 0) {
//            echo json_encode([
//                'success' => true,
//                'message' => "Ce compte n'existe pas dans DLTeams."
//            ]);
//            break;
//        }
//        else{
        if ($userId > 0){
            echo json_encode([
                'success' => false,
                'message' => "Il semble que vous ayez déjà un compte. Veuillez vous <a href='#'>connecter</a> ou faire <a href='#'>mot de passe oublié</a> si vous ne vous rappelez plus du mot de passe"
            ]);
            return;
        }
//        }

        // Stocker l’ID utilisateur et l’e-mail en session
        $_SESSION['signup_user_id'] = $userId;
        $_SESSION['signup_email']   = $email;

        // Générer un code de confirmation à 6 chiffres
        $code                         = rand(100000, 999999);
        $_SESSION['signup_code']      = (string)$code;
        $_SESSION['signup_code_time'] = time();

        // Préparer le contenu HTML pour le mail
        $contentHtml = "Bonjour,<br/><br/>"
            . "Votre code de confirmation est : <strong>{$code}</strong><br/><br/>"
            . "Ce code expire dans 10 minutes.<br/><br/>"
            . "Cordialement,<br/>L’équipe DLTeams";

        $notificationData = [
            'subject'      => "Code de confirmation DLTeams",
            'content_html' => html_entity_decode($contentHtml),
            'to'           => $email,
            'toname'       => $email,
        ];

        $mail = new PluginDlteamsNotificationMail();
        if (!$mail->sendNotification($notificationData)) {
            echo json_encode([
                'success' => false,
                'message' => "Impossible d'envoyer l’e-mail de confirmation."
            ]);
            break;
        }

        echo json_encode([
            'success' => true,
            'message' => "Code de confirmation envoyé."
        ]);
        break;

    // -------------------------------------------------------------
    // 2) Vérifier le code de confirmation (stocké en session)
    //    Retour JSON : success = true si le code correspond, sinon false + message
    // -------------------------------------------------------------
    case 'verifyCode':
        $inputCode  = trim($_POST['code'] ?? '');
        $storedCode = $_SESSION['signup_code']      ?? '';
        $sentTime   = $_SESSION['signup_code_time'] ?? 0;

        if (empty($storedCode) || empty($inputCode)) {
            echo json_encode([
                'success' => false,
                'message' => "Aucun code de confirmation trouvé. Veuillez recommencer."
            ]);
            break;
        }

        // Vérifier l’expiration : 10 minutes = 600 secondes
        if ((time() - $sentTime) > 600) {
            unset($_SESSION['signup_code'], $_SESSION['signup_code_time']);
            echo json_encode([
                'success' => false,
                'message' => "Le code de confirmation a expiré. Merci de recommencer."
            ]);
            break;
        }

        if ($inputCode !== $storedCode) {
            echo json_encode([
                'success' => false,
                'message' => "Le code de confirmation est incorrect."
            ]);
            break;
        }

        // Code validé : on supprime de la session
        unset($_SESSION['signup_code'], $_SESSION['signup_code_time']);

        echo json_encode([
            'success' => true,
            'message' => "Code validé."
        ]);
        break;

    // -------------------------------------------------------------
    // 3) Enregistrer/lier l’identité de l’utilisateur
    //    Retour JSON : success = true + on stocke l’ID utilisateur en session pour la suite
    // -------------------------------------------------------------
    case 'submitIdentity':

        $firstname = trim($_POST['firstname'] ?? '');
        $lastname  = trim($_POST['lastname']  ?? '');
        $phone     = trim($_POST['phone']     ?? '');
        $role      = trim($_POST['role']      ?? '');
        $email     = $_SESSION['signup_email']   ?? trim($_POST['role']      ?? '');
        $userId    = (int)($_SESSION['signup_user_id'] ?? 0);

        // Vérifications basiques
        if (empty($email) || empty($firstname) || empty($lastname) || empty($role)) {
            echo json_encode([
                'success' => false,
                'message' => "Les champs Prénom, Nom et Rôle sont obligatoires."
            ]);
            break;
        }

//        var_dump($userId);
//        die();

//        if ($userId > 0) {
//            // --- Utilisateur existant : mise à jour des champs ---
//            $user = new User();
//            if (!$user->getFromDB($userId)) {
//                echo json_encode([
//                    'success' => false,
//                    'message' => "Utilisateur introuvable."
//                ]);
//                break;
//            }
//            $user->fields['realname'] = $firstname;
//            $user->fields['name']     = $lastname;
//            $user->fields['phone']    = $phone;
//            $user->update([
//                'input' => [
//                    'realname' => $firstname,
//                    'name'     => $lastname,
//                    'phone'    => $phone
//                ]
//            ]);
//        }
//        else {
            // --- Nouvel utilisateur : création dans glpi_users puis glpi_useremails ---
//            $user         = new User();

        $_SESSION['signup_user_name'] = $email;
        $_SESSION['signup_user_firstname'] = $firstname;
        $_SESSION['signup_user_realname'] = $lastname;
        $_SESSION['signup_user_phone'] = $phone;
//            $newUserId = $user->add([
////                'input' => [
//                'name'         => $lastname,
//                'realname'     => $firstname,
//                'phone'        => $phone,
//            ]);


//            if (!$newUserId) {
//                echo json_encode([
//                    'success' => false,
//                    'message' => "Erreur lors de la création du compte utilisateur."
//                ]);
//                break;
//            }
//            $userId = $newUserId;

            // Ajouter l’e-mail dans glpi_useremails
//            $DB->insert(
//                'glpi_useremails',
//                [
//                    'users_id' => $userId,
//                    'email'    => $email,
//                    'is_default'  => 1,
////                    'input'    => date('Y-m-d H:i:s')
//                ]
//            );


//        }

        // Stocker l’ID utilisateur et le rôle en session
        $_SESSION['signup_user_id'] = $userId;
        $_SESSION['signup_role']    = $role;

        echo json_encode([
            'success' => true,
            'message' => "Identité enregistrée."
        ]);
        break;

    // -------------------------------------------------------------
    // 4.a) Rejoindre une entité (Entity)
    // -------------------------------------------------------------
    case 'joinTeam':
        $userId     = (int)($_SESSION['signup_user_id'] ?? 0);
//        var_dump($userId);
//        die();
        $entityName = trim($_POST['team_name'] ?? '');
        $adminEmail = strtolower(trim($_POST['admin_email'] ?? ''));

        if ($userId <= 0) {
            echo json_encode([
                'success' => false,
                'message' => "Utilisateur introuvable. Veuillez recommencer."
            ]);
            break;
        }
        if (empty($entityName) || empty($adminEmail) || !filter_var($adminEmail, FILTER_VALIDATE_EMAIL)) {
            echo json_encode([
                'success' => false,
                'message' => "Le nom de l’entité et l’e-mail de l’administrateur sont obligatoires."
            ]);
            break;
        }

        // Vérifier que l’entité existe (glpi_entities)
        $entity = new Entity();
        $query = [
            "FROM" => Entity::getTable(),
            "WHERE" => [
                "name" => $entityName
            ]
        ];
        $result_entity = iterator_to_array($DB->request($query));
        if(count($result_entity)>0){
            $exists = true;
            $entityId = $result_entity[0]["id"];
        }

        $exists = false;

        $DB->insert(
            'glpi_entities_users',
            [
                'entities_id'  => $entityId,
                'users_id'     => $userId,
                'is_recursive' => 0
            ]
        );

        $user = new User();
        $user->update([
            "entities_id" => $entityId,
            "id" => $userId
        ]);

        // Envoi d’un e-mail à l’administrateur de l’entité via PluginDlteamsNotificationMail
        $contentHtml = "Bonjour,<br/><br/>"
            . "L’utilisateur (ID : {$userId}) souhaite rejoindre l’entité “{$entityName}”.<br/>"
            . "Adresse e-mail du demandeur : " . ($_SESSION['signup_email'] ?? '') . "<br/><br/>"
            . "Veuillez prendre les mesures nécessaires.<br/><br/>"
            . "Cordialement,<br/>L’équipe DLTeams";

        $notificationData = [
            'subject'      => "Nouvelle demande pour rejoindre l’entité “{$entityName}”",
            'content_html' => html_entity_decode($contentHtml),
            'to'           => $adminEmail,
            'toname'       => $adminEmail,
        ];

        $mail = new PluginDlteamsNotificationMail();
        // On ignore le retour, la création est déjà effectuée
        $mail->sendNotification($notificationData);

        echo json_encode([
            'success' => true,
            'message' => "Votre demande a été envoyée à l’administrateur de l’entité."
        ]);
        break;

    // -------------------------------------------------------------
    // 4.b) Créer une entité (Entity)
    // -------------------------------------------------------------
    case 'createTeam':
        $userId     = (int)($_SESSION['signup_user_id'] ?? 0);
        $entityName = trim($_POST['team_name'] ?? '');

//        if ($userId <= 0) {
//            echo json_encode([
//                'success' => false,
//                'message' => "Utilisateur introuvable. Veuillez recommencer."
//            ]);
//            break;
//        }
        if (empty($entityName)) {
            echo json_encode([
                'success' => false,
                'message' => "Le nom de l’entité est obligatoire."
            ]);
            break;
        }

        // Vérifier qu’aucune entité ne porte déjà ce nom

        $entity = new Entity();
        $query = [
            "FROM" => Entity::getTable(),
            "WHERE" => [
                "name" => $entityName
            ]
        ];
        $result_entity = iterator_to_array($DB->request($query));


        if (count($result_entity)>0) {
            echo json_encode([
                'success' => false,
                'message' => "Une entité porte déjà ce nom."
            ]);
            break;
        }


//        var_dump($entityName);
//        die();
        // Création de l’entité (parent = racine, entities_id = 0)

        $_POST["add"] = "";

        $oldProfile = $_SESSION['glpiactiveprofile'] ?? null;

        if (!isset($_SESSION['glpiactiveprofile']) || !is_array($_SESSION['glpiactiveprofile'])) {
            $_SESSION['glpiactiveprofile'] = [];
        }
        $_SESSION['glpiactiveprofile']['entity'] = (
            intval($_SESSION['glpiactiveprofile']['entity'] ?? 0)
            | UPDATE
        );

        $result = Session::haveRight('entity', UPDATE);

        $dropdown = new Entity();
        $newEntityId = $dropdown->add([
            "name" => $_POST["team_name"],
            "entities_id" => 0
        ]);


//        creation du user
        $user = new User();
        $users_id = $user->add([
            "entities_id" => $newEntityId,
            "name" => $_SESSION['signup_email'],
            "firstname" => $_SESSION['signup_user_firstname'],
            "realname" => $_SESSION['signup_user_realname'],
            "phone" => $_SESSION['signup_user_phone'],
            "password" => Auth::getPasswordHash("11111111"),
            "password_last_update" => $_SESSION['glpi_currenttime']
        ]);
        $user_email = new UserEmail();
        $user_email->add([
            "email" => $_SESSION['signup_email'],
            "users_id" => $users_id,
            "is_default" => 1
        ]);
        $user_profile = new Profile_User();
        $user_profile->add([
            "users_id" => $users_id,
            "profiles_id" => 4,
            "entities_id" => $newEntityId
        ]);

        if (!$newEntityId) {
            echo json_encode([
                'success' => false,
                'message' => "Impossible de créer l’entité pour le moment."
            ]);
            break;
        }

        
        // Ajouter automatiquement le créateur comme membre de l’entité
        echo json_encode([
            'success' => true,
            'message' => "Entité “{$entityName}” créée avec succès. Veuillez vous connecter <a href=''>ici</a>"
        ]);
        break;

    // -------------------------------------------------------------
    // Action non reconnue
    // -------------------------------------------------------------
    default:
        echo json_encode([
            'success' => false,
            'message' => "Action inconnue ou non spécifiée."
        ]);
        break;
}
