<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallows others than DLPlace developers to distribute, sell,
 or add additional requirements without the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 -------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
 -------------------------------------------------------------------------
*/

include('../../../inc/includes.php');

// En-tête du plugin
Html::header(__('Assets'), $_SERVER['PHP_SELF'], 'assets', 'menu');

// Entité active pour le compteur
$activeEntity = Session::getActiveEntity();

?>

    <style>
        /* Grid menu styling */
        .dlteams-menu .menu-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
            gap: 1.5rem;
            justify-items: center;
            padding: 2rem 0;
        }

        .dlteams-menu .menu-item {
            background: #fff;
            border-radius: 0.5rem;
            padding: 1rem;
            width: 100%;
            max-width: 140px;
            text-align: center;
            transition: transform 0.2s ease, box-shadow 0.2s ease;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05);
            position: relative;
        }

        .dlteams-menu .menu-item:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.1);
        }

        .dlteams-menu .menu-item i {
            color: #2f3f64;
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }

        .dlteams-menu .menu-item span {
            display: block;
            margin-top: 0.25rem;
            font-weight: 500;
            color: #333;
        }

        .dlteams-menu .menu-item .counter {
            display: block;
            margin-top: 0.5rem;
            font-size: 0.9rem;
            color: #6c757d;
        }
    </style>

    <div class="container dlteams-menu">
        <div class="menu-grid">
            <?php
            // Définition des classes d'éléments de menu
            $items = [
                // Types GLPI pour le menu Informatique
                'Computer',         // Ordinateurs
                'Monitor',          // Moniteurs
                'Line',             // Lignes (ligne téléphonique)
                'SoftwareLicense',          // Licences
                'Certificate',      // Certificats
                'DataCenter',       // Data centers
                'Domain',           // Domaines
                'Cluster',          // Clusters
                'Software',         // Logiciels
                'NetworkEquipment', // Matériels réseau
                'Peripheral',       // Périphériques
                'Printer',          // Imprimantes
                'Cartridge',        // Cartouches
                Consumable::class,       // Consommables
                'Phone',            // Téléphones
                'Rack',             // Baies
                'Enclosure',          // Châssis
                'Pdu',              // PDU
                'PassiveDCEquipment', // Équipements passifs
                'Unmanaged',   // Unmanaged assets
                'Cable',            // Câbles
                'PluginDlteamsNetworkPort',      // Ports réseau
//                'AllAssets',           // Global
//                'Dashboard'         // Tableau de bord
            ];

            foreach ($items as $className) {
                $url = $className::getSearchURL();
                $icon = $className::getIcon();
                $label = $className::getTypeName();
                $table = $className::getTable();
                // GLPI fonction native pour compter les éléments par entité
                switch ($className) {
                    case Consumable::class:
                        $count = countElementsInTable($table, ["entities_id" => $activeEntity]);
                        break;
                    default:
                        $count = countElementsInTableForEntity($table, $activeEntity);
                        break;

                }

                echo '<a href="' . $url . '" class="menu-item text-decoration-none">';
                echo '  <i class="' . $icon . '"></i>';
                echo '  <span>' . $label . '</span>';
                echo '  <span class="counter">' . $count . '</span>';
                echo '</a>';
            }
            ?>
        </div>
    </div>

<?php
// Pied de page du plugin
Html::footer();
