<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include("../../../inc/includes.php");


if (!isset($_GET['id'])) {
    $_GET['id'] = "";
}

$task = new PluginDlteamsTicketTask();


if (isset($_POST['add'])) {

    $task->check(-1, CREATE, $_POST);
    $tickettask = new TicketTask();
    if(isset($_POST["task_review"])){
        $_POST["task_review"] == "on"?$_POST["task_review"] = true:$_POST["task_review"] = false;
    }
//    $tickettask->getFromDB($_POST["tickettasks_id"]);
    $data = $_POST;
//    $data["tasktemplates_id"] = $tickettask->fields["tasktemplates_id"];
    $id = $task->add($data);
    handleGroupPlanning($data);

    if(isset($_POST["_projects_id"])){
        $tickettask_item = new PluginDlteamsTicketTask_Item();
        $r1 = $tickettask_item->add([
            "tickettasks_id" => $id,
            "itemtype" => Project::class,
            "items_id" => $_POST["_projects_id"]
        ]);

        $projecttem = new Item_Project();
        $r2 = $projecttem->add([
            "projects_id" => $_POST["_projects_id"],
            "itemtype" => PluginDlteamsTicketTask::class,
            "items_id" => $id
        ]);
    }
    Html::redirect($task->getFormURLWithID($id));

}
else if (isset($_POST['update'])) {

    if(isset($_POST["task_review"])){
        $_POST["task_review"] == "on"?$_POST["task_review"] = true:$_POST["task_review"] = false;
    }
    else
        $_POST["task_review"] = false;
    $task = new TicketTask();
    $task->check($_POST['id'], UPDATE);
    $task->getFromDB($_POST["id"]);
    if(!$task->fields["begin"] && isset($_POST["plan"]["begin"]) && isset($_POST["groups_id_tech"])){
        $temp = $_POST;
        unset($temp["id"]);
        handleGroupPlanning($temp);
    }
    $id = $task->update([...$_POST]);


    $tickettask_validation = new PluginDlteamsTicketTask_Validation();
    global $DB;

    $crit = [
        "users_id" => Session::getLoginUserID(),
        "tickettasks_id" => $_POST["id"],
        "entities_id" => Session::getActiveEntity(),
    ];


    Html::back();

}
if(isset($_POST["task_review"])){
//        send vaidation mail

    $tickettask_validation = new PluginDlteamsTicketTask_Validation();
    $result = $DB->insert($tickettask_validation->getTable(),
        [
            "users_id" => Session::getLoginUserID(),
            "tickettasks_id" => $_POST["id"],
            "status" => CommonITILValidation::WAITING,
            "submission_date" => $_SESSION['glpi_currenttime'],
//              "date_mod" => $_SESSION['glpi_currenttime'],
            "entities_id" => Session::getActiveEntity(),
            "users_id_validate" => 0
        ]);

    if($result)
        Session::addMessageAfterRedirect("Une demande de contrôle a bien été créée");
    else{
        Session::addMessageAfterRedirect("Une erreur s'est produite lors de la demande du contrôle", 0, ERROR);
    }

    Html::back();
}
//elseif(isset($_POST["task_review"]) && $tickettask_validation->getFromDBByCrit($crit) && !$_POST["task_review"]){
//    $result = $tickettask_validation->deleteByCriteria($crit);
//
//    if($result)
//        Session::addMessageAfterRedirect("La demande de contrôle a bien été retirée");
//    else{
//        Session::addMessageAfterRedirect("Une erreur s'est produite lors du retrait du contrôle", 0, ERROR);
//    }
//}
else if (isset($_POST['delete'])) {

    $task = new TicketTask();
    $task->check($_POST['id'], DELETE);
    $task->delete($_POST);
    $task->redirectToList();

}
else if (isset($_POST['purge'])) {

    $task = new PluginDlteamsTicketTask();
//    $task->check($_POST['id'], PURGE);

    $task->delete(["id" => $_POST['id']]);

    if ($task->deleteByCriteria([
        "tickettasks_id" => $_POST['id']
    ])) {
        Session::addMessageAfterRedirect("Toutes les planifications associés ont été supprimés");
    }

    $task->redirectToList();

}
else if (isset($_POST["add_planification"])) {
    $tickettask = new TicketTask();

    $tickettask->getFromDB($_POST["tickettasks_id"]);


    $id = $tickettask->add([
        ...$_POST,
        "content" => sprintf("Suite de la tâche %s", $_POST["tickettasks_id"]),
    ]);
    Session::addMessageAfterRedirect("Planification ajoutée avec succès");
    Html::back();
}
else if (isset($_POST["unplan"])) {
    $task = new TicketTask();
    $task->getFromDB($_POST["linkid"]);
//    $task->check($_POST["id"], UPDATE);
    $task->unplan();

    $DB->delete($task->getTable(), [
        "tickettasks_id" => $_POST["linkid"]
    ]);

    $fk = getForeignKeyFieldForItemType(TicketTask::class);
    \Glpi\Event::log(
        $task->getField($fk),
        strtolower(TicketTask::class),
        4,
        "tracking",
        //TRANS: %s is the user login
        sprintf(__('%s unplans a task'), $_SESSION["glpiname"])
    );
    Session::addMessageAfterRedirect("Tâche dé-planifié avec succès");
    Html::back();
}
else if (isset($_POST["add_periodic_tasks"])) {

    global $DB;
$DB->beginTransaction();

    try {
        // Valider les données POST
        validatePostData();

        // Récupération des tâches et préparation des données de base
        $tickettaskparent = new TicketTask();
        $tickettaskparent->getFromDB($_POST["tickettasks_id"]);

        $reccurenttask = new PluginDlteamsReccurent_Task();
        $dateDebut = new DateTime($_POST["begin_date"]);
        $dateFin = !empty($_POST["end_date"]) ? new DateTime($_POST["end_date"]) : null;
        $monthDay = !empty($_POST["month_day"]) ? $_POST["month_day"] : $dateDebut->format('d');

        $rt_data = [
            "actiontime"       => $_POST["estimate_duration"],
            "users_id"         => Session::getLoginUserID(),
            "entities_id"      => Session::getActiveEntity(),
            "periodicity"      => $_POST["periodicity"],
            "day_of_week_json" => isset($_POST['weekday']) ? json_encode($_POST['weekday']) : null,
            "day_of_month_json" => isset($_POST["month_day"]) ? json_encode([$monthDay]) : null,
            "begin_date"       => $_POST["begin_date"],
            "occurence_nbr"    => $_POST["occurrences"] ?? null,
            "tickettasks_id"   => $_POST["tickettasks_id"]
        ];

        // Ajouter la tâche récurrente
        $rtid = $reccurenttask->add($rt_data);
        if (!$rtid) {
            throw new Exception("Une erreur s'est produite lors de la création de la tâche récurrente.");
        }

        // Gestion des différents types de périodicité
        $reccurent_end = null;
        switch ($_POST["periodicity"]) {
            case "daily":
                $reccurent_end = handlePeriodicity(
                    $tickettaskparent, $_POST["estimate_duration"], $rtid,
                    $dateDebut, $dateFin ? $dateFin->modify("+1 day") : null,
                    $_POST["occurrences"] ?? null, '+1 day'
                );
                break;

            case "weekly":
                if (!isset($_POST['weekday']) || !is_array($_POST['weekday'])) {
                    throw new Exception("Veuillez sélectionner au moins un jour de la semaine pour une périodicité hebdomadaire.");
                }
                $selectedDays = $_POST['weekday'];
                if (isset($_POST["periodicity_range_end"]) && $_POST["periodicity_range_end"] == "end_on_date" && $dateFin) {
                    $reccurent_end = handleWeeklyPeriodicity($tickettaskparent, $_POST["estimate_duration"], $rtid, $dateDebut, $dateFin, $selectedDays);
                } else {
                    $reccurent_end = handlePeriodicity($tickettaskparent, $_POST["estimate_duration"], $rtid, $dateDebut, null, $_POST["occurrences"], '+1 week');
                }
                break;

            case "monthly":
                if (!isset($_POST["month_day"])) {
                    throw new Exception("Veuillez spécifier un jour du mois pour la périodicité mensuelle.");
                }
                $reccurent_end = handleMonthlyPeriodicity($tickettaskparent, $_POST["estimate_duration"], $rtid, $dateDebut, $dateFin, $_POST["occurrences"], $_POST["month_day"]);
                break;

            default:
                throw new Exception("Périodicité non supportée.");
        }

        // Mise à jour de la tâche récurrente avec la date de fin
        if ($reccurent_end) {
            $reccurenttask->update(["id" => $rtid, "end_date" => $reccurent_end]);
        }

        $DB->commit();
        Session::addMessageAfterRedirect("Les tâches périodiques ont été ajoutées avec succès");
        Html::back();

    } catch (Exception $e) {
        $DB->rollback();
        Session::addMessageAfterRedirect($e->getMessage(), 0, ERROR);
        Html::back();
    }

}
else if(isset($_POST["update_planification"])){
    $tickettask = new TicketTask();

    $data = $_POST;
    unset($data["content"]);
    unset($data["tickettasks_id"]);
    $id = $tickettask->update([
        ...$data,
        "id" => $_POST["linkid"],
    ]);
    Session::addMessageAfterRedirect("Opération éffectuée avec succès");
    Html::back();
}
else {
    $task->checkGlobal(READ);

//    if (Session::getCurrentInterface() == 'central') {
    Html::header(PluginDlteamsTicketTask::getTypeName(2), '', "helpdesk", "plugindlteamstickettask");

//    } else {
//        Html::helpHeader(PluginDlteamsTicketTask::getTypeName(0));
//    }

    $task->display(['id' => $_GET['id'], ...$_GET]);

    if (Session::getCurrentInterface() == 'central') {
        Html::footer();
    } else {
        Html::helpFooter();
    }

}


// Fonction générique pour ajouter une tâche
function addTask($tickettaskparent, $currentDate, $estimate_duration, $rtid) {
    $tickettask = new TicketTask();
    $tickettask->getFromDB($_POST["tickettasks_id"]);
    $data = $tickettask->fields;

    unset($data["id"], $data["uuid"], $data["date_creation"], $data["date_mod"]);

    if($data["begin"]){
        $data["begin"] = $currentDate->format("Y-m-d H:i:s");
    }
    if($data["actiontime"] && !$estimate_duration){
        $data["actiontime"] = $data["estimate_duration"];
    }
    $array = array_merge($data, [
        "date" => $currentDate->format("Y-m-d H:i:s"),
        "estimate_duration" => $estimate_duration,
        "reccurent_tasks_id" => $rtid
    ]);

    $tickettask->add($array);
}

// Fonction pour gérer la périodicité mensuelle
function handleMonthlyPeriodicity($tickettaskparent, $estimate_duration, $rtid, $dateDebut, $dateFin = null, $occurences = null, $monthDay) {
    $currentDate = clone $dateDebut;
    $counter = 0;

    while (($dateFin && $currentDate <= $dateFin) || ($occurences && $counter < $occurences)) {
        $currentDate->setDate($currentDate->format('Y'), $currentDate->format('m'), $monthDay);
        addTask($tickettaskparent, $currentDate, $estimate_duration, $rtid);
        $currentDate->modify('+1 month');
        $counter++;
    }

    return $currentDate->format('Y-m-d');
}

// Fonction pour gérer la périodicité hebdomadaire
function handleWeeklyPeriodicity($tickettaskparent, $estimate_duration, $rtid, $dateDebut, $dateFin, $selectedDays) {
    $nextDateToStart = clone $dateDebut;
//    $nextday = $selectedDays[0];
//    $firstDateOfAll = clone $nextDateToStart;

    foreach ($selectedDays as $nextday){

        $nextDateToStart->modify("next $nextday");
        while ($nextDateToStart <= $dateFin) {
            if (in_array(strtolower($nextDateToStart->format('l')), $selectedDays)) {
                addTask($tickettaskparent, $nextDateToStart, $estimate_duration, $rtid);
            }
            $nextDateToStart->modify('+1 week');
        }

        $nextDateToStart = clone $dateDebut;
    }



    return $nextDateToStart->format('Y-m-d');
}

// Fonction pour gérer la périodicité générale (journalière, hebdomadaire, etc.)
function handlePeriodicity($tickettaskparent, $estimate_duration, $rtid, $dateDebut, $dateFin = null, $occurences = null, $modifyInterval) {
    $currentDate = clone $dateDebut;
    $counter = 0;

    while (($dateFin && $currentDate <= $dateFin) || ($occurences && $counter < $occurences)) {
        addTask($tickettaskparent, $currentDate, $estimate_duration, $rtid);
        $currentDate->modify($modifyInterval);
        $counter++;
        if ($dateFin && $currentDate->format('Y-m-d') > $dateFin->format('Y-m-d')) {
            break;
        }
    }

    return $currentDate->format('Y-m-d');
}

// Fonction de validation des entrées POST
function validatePostData() {
    if (empty($_POST["estimate_duration"])) {
        throw new Exception("Veuillez choisir une durée.");
    }

    if (empty($_POST["begin_date"])) {
        throw new Exception("Veuillez préciser la date de début.");
    }

    if (!isset($_POST["periodicity_range_end"])) {
        throw new Exception("Veuillez spécifier une date de fin ou un nombre d'occurrences.");
    }

    if ($_POST["periodicity"] == "weekly" && empty($_POST['weekday'])) {
        throw new Exception("Veuillez sélectionner au moins un jour de la semaine pour la périodicité hebdomadaire.");
    }

    if ($_POST["periodicity"] == "monthly" && empty($_POST["month_day"])) {
        throw new Exception("Veuillez spécifier un jour du mois pour la périodicité mensuelle.");
    }
}

function handleGroupPlanning($data){
    if(isset($data["plan"]["begin"]) && isset($data["groups_id_tech"])){
        $users = Group_User::getGroupUsers($data["groups_id_tech"]);
        $tickettask = new TicketTask();

        $content = sprintf("Planification du groupe %s", Group::getFriendlyNameById($data["groups_id_tech"]));




        foreach ($users as $user){
            $tickettask->add([
                ...$data,
                "content" => $content,
                "users_id" => $user["id"]
            ]);
        }
    }
}