<?php

/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2024 Teclib' and contributors.
 * @copyright 2003-2014 by the INDEPNET Development Team.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */

include_once('../../../inc/includes.php');

$validation = new PluginDlteamsTicketTask_Validation();

use Glpi\Event;

// autoload include in objecttask.form (ticketvalidation, changevalidation,...)
if (!defined('GLPI_ROOT')) {
    die("Sorry. You can't access this file directly");
}

Session::checkLoginUser();

if (!($validation instanceof CommonITILValidation)) {
    Html::displayErrorAndDie('');
}
if (!$validation->canView()) {
    Html::displayRightError();
}
/*highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//die();
$itemtype = $validation->getItilObjectItemType();
$fk       = getForeignKeyFieldForItemType($itemtype);
/*highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//die();
if (isset($_POST["add"])) {
//    $validation->check(-1, CREATE, $_POST);
    if (
        isset($_POST['users_id_validate'])
        && (count($_POST['users_id_validate']) > 0)
    ) {
        $users = $_POST['users_id_validate'];
        foreach ($users as $user) {
            $_POST['users_id_validate'] = $user;
            global $DB;
            $keys = ['tickettasks_id', 'users_id_validate', 'comment_submission'];

            $data = [];
            $data["users_id"] = Session::getLoginUserID();
            $data["entities_id"] = Session::getActiveEntity();
            $data["submission_date"] = date('Y-m-d H:i:s');

            foreach ($keys as $key) {
                if (isset($_POST[$key])) {
                    $data[$key] = $_POST[$key];
                } else {
                    $data[$key] = null; // ou une valeur par défaut si la clé n'est pas présente dans $_POST
                }
            }

            highlight_string("<?php\n\$data =\n" . var_export($data, true) . ";\n?>");
            $result = $DB->insert($validation->getTable(),$data);
//            var_dump($DB->error());
//            die();
            Session::addMessageAfterRedirect("Demande de validation envoyée avec succès");
            Event::log(
                $validation->getField($fk),
                strtolower($itemtype),
                4,
                "tracking",
                //TRANS: %s is the user login
                sprintf(__('%s adds an approval'), $_SESSION["glpiname"])
            );
        }
    }
    Html::back();
} else if (isset($_POST["update"])) {
    $validation->check($_POST['id'], UPDATE);
    $validation->update($_POST);
    Event::log(
        $validation->getField($fk),
        strtolower($itemtype),
        4,
        "tracking",
        //TRANS: %s is the user login
        sprintf(__('%s updates an approval'), $_SESSION["glpiname"])
    );
    Html::back();
}
else if (isset($_POST["purge"])) {
    $validation->check($_POST['id'], PURGE);
    $validation->delete($_POST, 1);

    Event::log(
        $validation->getField($fk),
        strtolower($itemtype),
        4,
        "tracking",
        //TRANS: %s is the user login
        sprintf(__('%s purges an approval'), $_SESSION["glpiname"])
    );
    Html::back();
} else if (isset($_POST['approval_action'])) {
    if ($_POST['users_id_validate'] == Session::getLoginUserID()) {
        $validation->update($_POST + [
                'status' => ($_POST['approval_action'] === 'approve') ? CommonITILValidation::ACCEPTED : CommonITILValidation::REFUSED
            ]);

        $approvedtext = ($_POST['approval_action'] === 'approve') ? "approuvé":"rejeté";
        $user = new User();
        $user->getFromDB(Session::getLoginUserID());
        $controller = $user->fields["firstname"]." ".$user->fields["realname"];
        $date = Html::convDateTime($_SESSION["glpi_currenttime"], null, false);
        $text_to_add = "<br/> <b>Tâche $approvedtext par $controller le $date</b>";

        $validation = new PluginDlteamsTicketTask_Validation();
        $validation->getFromDB($_POST["id"]);
        $tickettask = new TicketTask();
        if($tickettask->getFromDB($validation->fields["tickettasks_id"])){
//        have parent
            if($tickettask->fields["tickettasks_id"]){
                $tickettask = new TicketTask();
                $tickettask->getFromDB($tickettask->fields["tickettasks_id"]);
            }

            $tickettask->update([
                "content" => $tickettask->fields["content"].$text_to_add,
                "id" => $tickettask->fields["id"]
            ]);
        }
        Html::back();
    }
}
Html::displayErrorAndDie('Lost');

