<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */


function plugin_dlteams_install()
{

    global $DB, $new_install;
    include_once(Plugin::getPhpDir("dlteams") . "/inc/profile.class.php");
// nouvelle installation ou mise à jour ?
    if (!$DB->TableExists("glpi_plugin_dlteams_records")) {
        $new_install = true; // no table so first install
        Session::addMessageAfterRedirect("Nouvelle installation effectuée");
    } else {
        $new_install = false;
        Session::addMessageAfterRedirect("Mise à jour du Plug'in effectuée");
    }


//    include_once(Plugin::getPhpDir("dlteams") . "/install/install.php");
//  création et mises à jour des tables
    error_reporting(E_ALL & ~E_WARNING);
    mysqli_report(MYSQLI_REPORT_OFF);

    $DB->runFile(plugin_dlteams_root . "/install/sql/update-1.0.sql");
    $DB->runFile(plugin_dlteams_root . "/install/sql/update-1.1.sql");
    $DB->runFile(plugin_dlteams_root . "/install/sql/update-1.2.sql");
    require_once(plugin_dlteams_root . "/install/sql/update-24.php");
    require_once(plugin_dlteams_root . "/install/sql/update-25.php");
	require_once(plugin_dlteams_root . "/install/sql/update-26.php");
    // $install = new PluginDlteamsInstall();
    // $install->install();

//    PluginDlteamsProfile::initProfile();
//    PluginDlteamsProfile::createFirstAccess($_SESSION['glpiactiveprofile']['id']);
//    Plugin::registerClass('CronTask', ['PluginDlteamsUpdateStats']);


    /*var_dump("zzz");
    die();*/
    return true;
}


/**
 * Hook pour personnaliser l'affichage des éléments de recherche
 *
 * @param string $type Type d'élément
 * @param int $ID ID de l'option de recherche
 * @param array $data Données de la ligne
 * @param string $num Nom de la colonne
 *
 * @return string Attributs HTML à ajouter
 */
function plugin_dlteams_displayConfigItem($type, $ID, $data, $num)
{
//    if ($type == 'PluginDlteamsRecord') {
//        $record_id = $data['raw']['id'] ?? 0;
//
//        $completenumber = trim((string)($data['raw']['ITEM_PluginDlteamsRecord_1'] ?? ''));
//
//        if ($completenumber !== '') {
//            $parts = explode('.', $completenumber);
//            $decimal = $parts[1] ?? '';
//
//            // Vérifier si la partie décimale est vide, "0" ou "00"
//            if ($decimal === '0' || $decimal === '00') {
//
//                return 'style="background-color: #d4edda !important; background: #d4edda !important;"';
//            }
//        }
//    }

    return '';
}

function plugin_dlteams_uninstall()
{
    global $DB;
    $DB->query('SET foreign_key_checks = 0');
    if (plugin_dlteams_root == "/var/www/dlteams_app/marketplace/dlteams" or plugin_dlteams_root == "/var/www/dev_dlteams_app/marketplace/dlteams" or plugin_dlteams_root == "/var/www/free_dlteams_app/marketplace/dlteams") {
        $mandatory_sites = 1;
    } else {
        $mandatory_sites = 0;
    }

//    disable dlteams fork
    $directory = GLPI_ROOT . "/marketplace/dlteams/install/fork/" . GLPI_VERSION . "/origin_glpi";
    $rii = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($directory));
    $files = array();
    foreach ($rii as $file) {
        if ($file->isDir()) {
            continue;
        }
        $files[] = $file->getPathname();
    }
    foreach ($files as $path) {
        copy($path, GLPI_ROOT . str_replace($directory, "", $path));
    }
//    disable dlteams whitelabel
    $directory = GLPI_ROOT . "/marketplace/dlteams/install/whitelabel/" . GLPI_VERSION . "/origin_glpi";
    $rii = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($directory));
    $files = array();
    foreach ($rii as $file) {
        if ($file->isDir()) {
            continue;
        }
        $files[] = $file->getPathname();
    }
    foreach ($files as $path) {
        copy($path, GLPI_ROOT . str_replace($directory, "", $path));
    }

    // deleting rgpd-model entitie + all dlteams database tables
    $requete = "SHOW TABLES LIKE 'glpi_plugin_dlteams_records'";
    $resultat = $DB->query($requete);
    if ($mandatory_sites == 0 && $resultat->num_rows > 0) {
        $DB->runFile(plugin_dlteams_root . "/install/sql/delete-modelrgpd.sql"); //delete model-rgpd + profile + user
        //$DB->runFile(plugin_dlteams_root . "/install/sql/delete-datas.sql"); //delete all dlteams database + delete displaypreference records + profilerights records
        drop_tables();
        rollback_columns();
    }
    /* $options_tooltip['link_class'] = 'btn btn-outline-secondary';
    Html::showToolTip("Effacer toutes les données du plug'in ?", $options_tooltip);
    // Session::addMessageAfterRedirect("Effacer toutes les données du plug'in ?");
    // echo '<a href="#" onclick="confirmDelete()">Supprimer</a>';
    // var_dump ("effacement");
    function confirmDelete() {
        $confirmation = confirm("Effacer toutes les données du plug'in ?");
        if ($mandatory_sites == 0 && $confirmation) {
            $DB->runFile(plugin_dlteams_root . "/install/sql/delete-modelrgpd.sql"); //delete model-rgpd + profile + user
            //$DB->runFile(plugin_dlteams_root . "/install/sql/delete-datas.sql"); //delete all dlteams database + delete displaypreference records + profilerights records
            drop_tables();
        } else {
            alert("Suppression annulée.");
        }
    }*/
    return true;
}

function plugin_dlteams_getDropdown()
{
    // Tableau de base des éléments avec leur type et nom
    $dropdownItems = [

        PluginDlteamsActivityCategory::class => PluginDlteamsActivityCategory::getTypeName(2), // Catégories de traitement
        PluginDlteamsAuditCategory::class => PluginDlteamsAuditCategory::getTypeName(2), // Catégories d'audit
        PluginDlteamsPolicieFormCategory::class => PluginDlteamsPolicieFormCategory::getTypeName(2), // Catégories de jeux de données
        PluginDlteamsCatalogClassification::class => PluginDlteamsCatalogClassification::getTypeName(2), // Classification de l'information
        PluginDlteamsDataCarrierCategory::class => PluginDlteamsDataCarrierCategory::getTypeName(2), // Catégories de base de données
        PluginDlteamsDataCarrierHosting::class => PluginDlteamsDataCarrierHosting::getTypeName(2), // Type d'hébergement
        PluginDlteamsDataCarrierType::class => PluginDlteamsDataCarrierType::getTypeName(2), // Type de base données
        PluginDlteamsDataCarrierManagement::class => PluginDlteamsDataCarrierManagement::getTypeName(2), // Type de gestion
        PluginDlteamsDataCategory::class => PluginDlteamsDataCategory::getTypeName(2), // Catégorie de données
        PluginDlteamsImpact::class => PluginDlteamsImpact::getTypeName(2), // Type d'impact
        PluginDlteamsKeyType::class => PluginDlteamsKeyType::getTypeName(2), // Type de clés
        PluginDlteamsLegalBasisType::class => PluginDlteamsLegalBasisType::getTypeName(2), // Type de bases légales
        PluginDlteamsMeansOfAcce::class => PluginDlteamsMeansOfAcce::getTypeName(2), // Moyens d'accès (aux données/catalogues)
        PluginDlteamsMediaSupport::class => PluginDlteamsMediaSupport::getTypeName(2), // Support, médias de collecte
        PluginDlteamsProtectiveCategory::class => PluginDlteamsProtectiveCategory::getTypeName(2), // Catégories des mesures de protection
        PluginDlteamsRightMeasureCategory::class => PluginDlteamsRightMeasureCategory::getTypeName(2), // Catégories de mesure
        PluginDlteamsProcessedDataCategory::class => PluginDlteamsProcessedDataCategory::getTypeName(2), // Catégories de mesure
        PluginDlteamsProtectiveType::class => PluginDlteamsProtectiveType::getTypeName(2), // Types de mesures de protection
        PluginDlteamsSendingReason::class => PluginDlteamsSendingReason::getTypeName(2), // Motifs d'envoi d'informations
        PluginDlteamsServerType::class => PluginDlteamsServerType::getTypeName(2), //
        PluginDlteamsSIIntegration::class => PluginDlteamsSIIntegration::getTypeName(2), // Intégration dans le système d'information
        PluginDlteamsStorageType::class => PluginDlteamsStorageType::getTypeName(2), // Type de stockage
        PluginDlteamsStorageUnitType::class => PluginDlteamsStorageUnitType::getTypeName(2), // Catégories d'audit
        PluginDlteamsStorageEndAction::class => PluginDlteamsStorageEndAction::getTypeName(2), // Action en fin de stockage
        PluginDlteamsTransmissionmethod::class => PluginDlteamsTransmissionmethod::getTypeName(2), // Méthode de transmission
        PluginDlteamsUserProfile::class => PluginDlteamsUserProfile::getTypeName(2), // Rôle et droits pour les utilisateurs
        PluginDlteamsVehicleType::class => PluginDlteamsVehicleType::getTypeName(2), // Catégories de véhicule
        PluginDlteamsRgpdAdequacy::class => PluginDlteamsRgpdAdequacy::getTypeName(2), // RGPD Adequacy
    ];

    // Filtrer les éléments en fonction des droits
    $filteredDropdown = [];
    foreach ($dropdownItems as $class => $typeName) {
        if (Session::haveRight($class::$rightname, READ)) {
            $filteredDropdown[$class] = $typeName;
        }
    }

    return $filteredDropdown;
}

function plugin_dlteams_getAddSearchOptions($itemtype)
{
    $options = [];
    if ($itemtype == 'Entity') {
        $options = PluginDlteamsControllerInfo::getSearchOptionsControllerInfo();
    }
    return $options;
}


function plugin_dlteams_addWhere($link, $nott, $type, $ID, $val)
{
//    $backtrace = debug_backtrace();

    // Afficher l'appel précédent
//    if (isset($backtrace[1])) {
//        $caller = $backtrace[1];
//        echo "La fonction a été appelée depuis le fichier " . $caller['file'] . " à la ligne " . $caller['line'] . " dans la fonction " . $caller['function'] . "()\n";
//    } else {
//        echo "La fonction a été appelée directement.\n";
//    }
//
//    die();
    $searchopt = &Search::getOptions($type);
    $table = $searchopt[$ID]["table"];
    $field = $searchopt[$ID]["field"];

    $SEARCH = Search::makeTextSearch($val, $nott);

    switch ($table . "." . $field) {
        case "glpi_plugin_resources_managers.name":
        case "glpi_plugin_resources_recipients_leaving.name":
        case "glpi_plugin_resources_recipients.name":
        case "glpi_plugin_resources_salemanagers.name":
            $ADD = " OR `" . $table . "`.`firstname` LIKE '%" . $val . "%' OR `" . $table . "`.`realname` LIKE '%" . $val . "%' ";
            if ($nott && $val != "NULL") {
                $ADD = " OR `$table`.`$field` IS NULL";
            }
            return $link . " (`$table`.`$field` $SEARCH " . $ADD . " ) ";

            break;
    }
    return "";
}

function plugin_dlteams_addSelect(...$args)
{
    switch ($args[0]) {
        case "PluginDlteamsStep":
            break;
    }
}

function plugin_dlteams_getDatabaseRelations()
{
    $plugin = new Plugin();
    if ($plugin->isActivated('dlteams')) {
        return [
            'glpi_entities' => [
                'glpi_plugin_dlteams_accountkeys' => 'entities_id',
                'glpi_plugin_dlteams_records' => 'entities_id',
                'glpi_plugin_dlteams_controllerinfos' => 'entities_id',
                'glpi_plugin_dlteams_impacts' => 'entities_id',
                'glpi_plugin_dlteams_storageendactions' => 'entities_id',
                'glpi_plugin_dlteams_sendingreasons' => 'entities_id',
                'glpi_plugin_dlteams_datacarriercategories' => 'entities_id',
                'glpi_plugin_dlteams_auditcategories' => 'entities_id',
                'glpi_plugin_dlteams_activitycategories' => 'entities_id',
                'glpi_plugin_dlteams_protectivecategories' => 'entities_id',
                'glpi_plugin_dlteams_datacarriertypes' => 'entities_id',
                'glpi_plugin_dlteams_datacarrierhostings' => 'entities_id',
                'glpi_plugin_dlteams_datacarriermanagements' => 'entities_id',
                'glpi_plugin_dlteams_catalogclassifications' => 'entities_id',
                'glpi_plugin_dlteams_legalbasis' => 'entities_id',
                'glpi_plugin_dlteams_legalbasistypes' => 'entities_id',
                'glpi_plugin_dlteams_physicalstorages' => 'entities_id',
                'glpi_plugin_dlteams_personaldatacategories' => 'entities_id',
                'glpi_plugin_dlteams_steps' => 'entities_id',
                'glpi_plugin_dlteams_securitymeasures' => 'entities_id',
                'glpi_plugin_dlteams_keytypes' => 'entities_id',
                'glpi_plugin_dlteams_protectivetypes' => 'entities_id',
                'glpi_plugin_dlteams_userprofiles' => 'entities_id',
                'glpi_plugin_dlteams_vehicles' => 'entities_id',
            ],
            'glpi_users' =>
                ['glpi_plugin_dlteams_controllerinfos' => ['users_id_representative', 'users_id_dpo',],
                    // 'glpi_plugin_dlteams_configs' => ['users_id_creator', 'users_id_lastupdater',],
                    'glpi_plugin_dlteams_activitycategories' => ['users_id_creator', 'users_id_lastupdater',],
                    'glpi_plugin_dlteams_impacts' => ['users_id_creator', 'users_id_lastupdater',],
                    'glpi_plugin_dlteams_storageendactions' => ['users_id_creator', 'users_id_lastupdater',],
                    'glpi_plugin_dlteams_sendingreasons' => ['users_id_creator', 'users_id_lastupdater',],
                    'glpi_plugin_dlteams_datacarriercategories' => ['users_id_creator', 'users_id_lastupdater',],
                    'glpi_plugin_dlteams_auditcategories' => ['users_id_creator', 'users_id_lastupdater',],
                    'glpi_plugin_dlteams_legalbasis' => ['users_id_creator', 'users_id_lastupdater',],
                    'glpi_plugin_dlteams_personaldatacategories' => ['users_id_creator', 'users_id_lastupdater',],
                    'glpi_plugin_dlteams_steps' => ['users_id_creator', 'users_id_lastupdater',],
                    'glpi_plugin_dlteams_records' => ['users_id_creator', 'users_id_lastupdater', 'users_id_owner',],
                    'glpi_plugin_dlteams_securitymeasures' => ['users_id_creator', 'users_id_lastupdater',],
                    'glpi_plugin_dlteams_vehicles' => ['users_id_creator', 'users_id_lastupdater',],
                ],

            //'glpi_plugin_dlteams_storageendactions' => ['glpi_plugin_dlteams_records_actionfinperiodes' => 'plugin_dlteams_storageendactions_id',],
            //'glpi_plugin_dlteams_activitycategories' => ['glpi_plugin_dlteams_activitycategories' => 'glpi_plugin_dlteams_activitycategories',],
            //'glpi_plugin_dlteams_legalbasistypes' => ['glpi_plugin_dlteams_records_legalbasistypes' => 'plugin_dlteams_legalbasistypes_id',],
            //'glpi_plugin_dlteams_impactorganisms' => ['glpi_plugin_dlteams_records_impactorganisms' => 'plugin_dlteams_impactorganisms_id',],
            //'glpi_plugin_dlteams_legalbasisacts' => ['glpi_plugin_dlteams_records_legalbasis' => 'plugin_dlteams_legalbasisacts_id', 'glpi_plugin_dlteams_records_retentions' => 'plugin_dlteams_legalbasisacts_id',],
            // 'glpi_plugin_dlteams_personaldatacategories' => ['glpi_plugin_dlteams_records_personalanddatacategories' => 'plugin_dlteams_personaldatacategories_id',],
            //'glpi_plugin_dlteams_securitymeasures' => ['glpi_plugin_dlteams_records_securitymeasures' => 'plugin_dlteams_securitymeasures_id',],
            //'glpi_softwares' => ['glpi_plugin_dlteams_records_softwares' => 'softwares_id',],
        ];
    }
    return [];
}

function plugin_dlteams_postinit()
{
    global $PLUGIN_HOOKS;
    $PLUGIN_HOOKS['item_purge']['accounts']['KnowbaseItem_Item'] = ['ManualLink', 'cleanForItem'];
    $PLUGIN_HOOKS['item_purge']['accounts']['KnowbaseItem_Item'] = array('PluginAccountsAccount_Item', 'cleanForItem');
    CommonGLPI::registerStandardTab('KnowbaseItem_Item', 'PluginAccountsAccount_Item');
}


function plugin_dlteams_MassiveActions($itemtype)
{
    switch ($itemtype) {
//		 case Document_Item::class:
//		 return ['PluginDlteamsRecord' . MassiveAction::CLASS_ACTION_SEPARATOR . 'deleteRelation' => __('Supprimer la relation test', 'dlteams'),];
        case PluginDlteamsAccountKey::class:
            return ['PluginDlteamsAccountKey' . MassiveAction::CLASS_ACTION_SEPARATOR . 'copyTo' => "<i class='fa-fw far fa-copy" . "'></i>" . __('Copy To', 'dlteams'),];
        case PluginDlteamsRecord::class:
            return ['PluginDlteamsRecord' . MassiveAction::CLASS_ACTION_SEPARATOR . 'copyTo' => "<i class='fa-fw far fa-copy" . "'></i>" . __('Copy To', 'dlteams'),];
        case PluginDlteamsDataCatalog::class:
            return [
                'PluginDlteamsDataCatalog' . MassiveAction::CLASS_ACTION_SEPARATOR . 'copyTo' => "<i class='fa-fw far fa-copy" . "'></i>" . __('Copy To', 'dlteams'),
                'PluginDlteamsDataCatalog' . MassiveAction::CLASS_ACTION_SEPARATOR . 'add_child_catalogs' => __('Ajouter des sous catalogues', 'dlteams'),
            ];
        case PluginDlteamsRiskAssessment::class:
            return ['PluginDlteamsRiskAssessment' . MassiveAction::CLASS_ACTION_SEPARATOR . 'copyTo' => "<i class='fa-fw far fa-copy" . "'></i>" . __('Copy To', 'dlteams'),];
        case PluginDlteamsConcernedPerson::class:
            return ['PluginDlteamsConcernedPerson' . MassiveAction::CLASS_ACTION_SEPARATOR . 'copyTo' => "<i class='fa-fw far fa-copy" . "'></i>" . __('Copy To', 'dlteams'),];
        case PluginDlteamsProcessedData::class:
            return ['PluginDlteamsProcessedData' . MassiveAction::CLASS_ACTION_SEPARATOR . 'copyTo' => "<i class='fa-fw far fa-copy" . "'></i>" . __('Copy To', 'dlteams'),];
        case PluginDlteamsLegalbasi::class:
            return ['PluginDlteamsLegalbasi' . MassiveAction::CLASS_ACTION_SEPARATOR . 'copyTo' => "<i class='fa-fw far fa-copy" . "'></i>" . __('Copy To', 'dlteams'),];
        case PluginDlteamsStoragePeriod::class:
            return ['PluginDlteamsStoragePeriod' . MassiveAction::CLASS_ACTION_SEPARATOR . 'copyTo' => "<i class='fa-fw far fa-copy" . "'></i>" . __('Copy To', 'dlteams'),];
        case PluginDlteamsThirdPartyCategory::class:
            return ['PluginDlteamsThirdPartyCategory' . MassiveAction::CLASS_ACTION_SEPARATOR . 'copyTo' => "<i class='fa-fw far fa-copy" . "'></i>" . __('Copy To', 'dlteams'),];
        case PluginDlteamsPolicieForm::class:
            return ['PluginDlteamsPolicieForm' . MassiveAction::CLASS_ACTION_SEPARATOR . 'copyTo' => "<i class='fa-fw far fa-copy" . "'></i>" . __('Copy To', 'dlteams'),];
        case PluginDlteamsAudit::class:
            return ['PluginDlteamsAudit' . MassiveAction::CLASS_ACTION_SEPARATOR . 'copyTo' => "<i class='fa-fw far fa-copy" . "'></i>" . __('Copy To', 'dlteams'),];
        case PluginDlteamsProtectiveMeasure::class:
            return ['PluginDlteamsProtectiveMeasure' . MassiveAction::CLASS_ACTION_SEPARATOR . 'copyTo' => "<i class='fa-fw far fa-copy" . "'></i>" . __('Copy To', 'dlteams'),];
        case Project::class:
            return ['PluginDlteamsProject_Ma' . MassiveAction::CLASS_ACTION_SEPARATOR . 'copyTo' => "<i class='fa-fw far fa-copy" . "'></i>" . __('Copy To', 'dlteams'),];
        case PluginDlteamsProcedure::class:
            return ['PluginDlteamsProcedure' . MassiveAction::CLASS_ACTION_SEPARATOR . 'copyTo' => "<i class='fa-fw far fa-copy" . "'></i>" . __('Copy To', 'dlteams'),];
        case PluginDlteamsTrainingCertification::class:
            return ['PluginDlteamsTrainingCertification' . MassiveAction::CLASS_ACTION_SEPARATOR . 'copyTo' => "<i class='fa-fw far fa-copy" . "'></i>" . __('Copy To', 'dlteams'),];
        case PluginDlteamsTrainingSession::class:
            return ['PluginDlteamsTrainingSession' . MassiveAction::CLASS_ACTION_SEPARATOR . 'copyTo' => "<i class='fa-fw far fa-copy" . "'></i>" . __('Copy To', 'dlteams'),];
        case PluginDlteamsDeliverable::class:
            return ['PluginDlteamsDeliverable' . MassiveAction::CLASS_ACTION_SEPARATOR . 'copyTo' => "<i class='fa-fw far fa-copy" . "'></i>" . __('Copy To', 'dlteams'),];
        case Appliance::class:
            return [PluginDlteamsMassiveAction::class . MassiveAction::CLASS_ACTION_SEPARATOR . 'copyTo' => "<i class='fa-fw far fa-copy" . "'></i>" . __('Copy To', 'dlteams'),];
        case PluginDlteamsRightMeasure::class:
            return ['PluginDlteamsRightMeasure' . MassiveAction::CLASS_ACTION_SEPARATOR . 'copyTo' => "<i class='fa-fw far fa-copy" . "'></i>" . __('Copy To', 'dlteams'),];
        case PluginDlteamsDataCarrierType::class:
            return ['PluginDlteamsDataCarrierType' . MassiveAction::CLASS_ACTION_SEPARATOR . 'copyTo' => "<i class='fa-fw far fa-copy" . "'></i>" . __('Copy To', 'dlteams'),];
        case Document::class:
            return [Document::class . MassiveAction::CLASS_ACTION_SEPARATOR . 'copyTo' => "<i class='fa-fw far fa-copy" . "'></i>" . __('Copy To', 'dlteams'),];
        case User::class:
            $action = [];
            $prefix = PluginDlteamsAccountKey_Item::class . MassiveAction::CLASS_ACTION_SEPARATOR;
            $action[$prefix . "assign_key_to_user"] = __('Assigner une clé à cet utilisateur', 'dlteams');


            $prefix = PluginDlteamsRecord_Item::class . MassiveAction::CLASS_ACTION_SEPARATOR;
            $action[$prefix . "assign_as_record_acteur"] = __('Assigner comme acteur d\'un traitement', 'dlteams');

            $prefix = PluginDlteamsUser_Item::class . MassiveAction::CLASS_ACTION_SEPARATOR;
            $action[$prefix . "assign_computer_to_user"] = __('Assigner un ordinateur', 'dlteams');

            $prefix = PluginDlteamsAccountKey_Item::class . MassiveAction::CLASS_ACTION_SEPARATOR;
            $action[$prefix . "create_account_and_assign_to_user"] = __('Créer des comptes et les attribuer', 'dlteams');

            return $action;


        case Group::class:
            $action = [];

            $prefix = PluginDlteamsAccountKey_Item::class . MassiveAction::CLASS_ACTION_SEPARATOR;
            $action[$prefix . "create_account_and_assign_to_group"] = __('Attribuer un compte à ce groupe', 'dlteams');

            $prefix = PluginDlteamsAccountKey_Item::class . MassiveAction::CLASS_ACTION_SEPARATOR;
            $action[$prefix . "create_account_and_assign_to_each_user_of_group"] = __(' Créer des comptes pour chaque utilisateur et les attribuer', 'dlteams');

            return $action;
        case Computer::class:
            $action = [];

            $prefix = PluginDlteamsProtectiveMeasure::class . MassiveAction::CLASS_ACTION_SEPARATOR;
            $action[$prefix . "add_protectivemeasure_to_computer"] = __('Ajouter une mesure de protection', 'dlteams');

            return $action;
        case SupplierType::class:
            return ['PluginDlteamsMassiveAction' . MassiveAction::CLASS_ACTION_SEPARATOR . 'copyTo' => "<i class='fa-fw far fa-copy" . "'></i>" . __('Copy To', 'dlteams'),];
            break;
    }
}

////// SPECIFIC MODIF MASSIVE FUNCTIONS ///////

function dlteams_additem_called(CommonDBTM $item)
{
    // On supplier creation : set it automaticaly to active
    if ($item::getType() === Supplier::getType()) {
        $item->fields['is_active'] = 1;
        $item->updateInDB(['is_active']);
        Session::addMessageAfterRedirect("Supplier auto set to active", true);
    }
}

// ajouter la même fonction pour rendre à oui l'ouverture d'une nouvelle fenetre dans item_link

function dlteams_display_login()
{
    global $CFG_GLPI;
    global $GLPI_MARKETPLACE_DIR;
//    echo "
//    <div style='display: flex; flex-direction: column; gap: 0.5rem; width: 100%'>
//
//    <div id='g_id_onload'
//     data-client_id='935144528784-dtqamo20q8g52tevp8jh3nmj0e1bak92.apps.googleusercontent.com'
//     data-context='signin'
//     data-ux_mode='popup'
//     data-callback='handleCredentialResponse'>
//</div>
//<div class='g_id_signin'
//     data-type='standard'
//     data-shape='rectangular'
//     data-theme='outline'
//     data-text='signin_with'
//     data-size='large'>
//</div>
//
//                      <div class='g-signin2' data-onsuccess='onSignIn'></div>
//
//                      <button class='btn btn-sso btn-sso-microsoft d-flex align-items-center'>
//                        <i class='bi bi-microsoft''></i>
//                        Se connecter avec Microsoft
//                      </button>
//            </div>;";

    echo "
   <style>
      #logo_login img {
         display: none;
      }
      #logo_login {
          background-image: url('" . $GLPI_MARKETPLACE_DIR . "/dlteams/images/banner.png');
          background-repeat: no-repeat;
          background-size: contain;
          width: 100%;
          height: 0;
          padding-top: 25%;
          padding-bottom: 0;
          margin: 0;
      }
      #text-login {
         display: none;
      }
      #firstboxlogin {
          background: #4F4E4E !important;
      }
      input.submit {
         background-color: #50E3C2 !important;
         border: #90F3E2 !important;
         color: #FFF !important;
      }
      #footer-login, a.copyright {
          color: #50E3C2 !important;
      }

      #footer-login:before {
          font-weight: bold;
          content: 'DL Place - ';
      }
      
      
      .btn-sso-google {
    background-color: #ffffff;
      color: #757575;
      border: 1px solid #ddd;
    }
    .btn-sso-google:hover {
    background-color: #f7f7f7;
      color: #000;
    }

    /* Style personnalisé pour le bouton Microsoft */
    .btn-sso-microsoft {
    background-color: #f3f2f1;
      color: #333333;
      border: 1px solid #c8c6c4;
    }
    .btn-sso-microsoft:hover {
    background-color: #e1dfdd;
      color: #000000;
    }

    /* Alignement des icônes et texte dans les boutons */
    .btn-sso i {
    margin-right: 8px;
    }

    /* Taille des icônes */
    .btn-sso i {
    font-size: 1.2rem;
    }
   </style>";

    echo "<script>
// Change FAQ link on login page
//let faq_link = document.querySelectorAll('#box-faq > a')[0];
//faq_link.href = 'faq';

// SEO : add canonical link tag
//let link = !!document.querySelector(\"link[rel='canonical']\") ? document.querySelector(\"link[rel='canonical']\") : document.createElement('link');
//link.setAttribute('rel', 'canonical');
//link.setAttribute('href', location.protocol + '//' + location.host + '/');
//document.head.appendChild(link);

const googleClientId = '935144528784-dtqamo20q8g52tevp8jh3nmj0e1bak92.apps.googleusercontent.com';

// Rechercher la balise <meta> existante
let metaTag = document.querySelector('meta[name=\'google-signin-client_id\']');

if (!metaTag) {
  // Si la balise n'existe pas, la créer
  metaTag = document.createElement('meta');
  metaTag.setAttribute('name', 'google-signin-client_id');
  document.head.appendChild(metaTag);
}

// Définir dynamiquement l'attribut 'content'
metaTag.setAttribute('content', googleClientId);

function handleCredentialResponse(response) {
  const id_token = response.credential;
  console.log(response);
  console.log(id_token);

  }
  
  
</script>";

    echo '<script src="https://apis.google.com/js/platform.js" async defer></script>';

    // Used to change title and favicon
    $path = $CFG_GLPI['root_doc'] . "/marketplace/dlteams";
    echo "<script src='$path/js/plugin.js'></script>";
}

// permet de redimenssioner les champs de saisie HTML moins haut que 5 lignes quand on utilise la fonction Html::textarea([
//function plugin_dlteams_displayFooter() {
//   echo <<<HTML
//<script>
//   tinymce.on('AddEditor', function(e) {
//      if (e.editor.id === 'right_information') {
//         e.editor.on('init', function () {
//            this.theme.resizeTo(null, 150); // définit la hauteur
//         });
//      }
//   });
//</script>
//HTML;
//}

/* Change the GLPI menu to modify "GRC" tab / @param $menu array / @return mixed */
function plugin_dlteams_redefine_menus(array $menu)
{
    global $PLUGIN_HOOKS;
    global $PLUGIN_HOOKS;
    // Si le menu est vide, on retourne directement
    if (empty($menu)) {
        return $menu;
    }

    /*
     * SECTION 1 : Ajout des menus spécifiques du plug-in s'ils ne sont pas déjà définis
     */
    if (!array_key_exists('dlteams', $menu)) {
        // --- Menu Actifs
        $assets = [
            'default' => PluginDlteamsPhysicalStorage::getSearchURL(),
            'icon' => "fa-sharp fa-solid fa-th",
            'title' => 'Patrimoine',
            'content' => [
                'plugindlteamsphysicalstorage' => PluginDlteamsPhysicalStorage::getMenuContent(),
                'plugindlteamsvehicle' => PluginDlteamsVehicle::getMenuContent(),
            ],
        ];

        $backtrace = debug_backtrace();

        // Récupère la ligne à laquelle cette fonction a été appelée
        $callerLine = $backtrace[0]['line'];
        $callerFile = $backtrace[0]['file'];

        // --- Menu Gouvernance Risques Conformités
        $dlteams = [
            'default' => '/marketplace/dlteams/front/rgpd.php',
            'icon' => "fa-sharp fa-solid fa-circle-check",
            'title' => 'GRC',
            'content' => [
                'riskassessment' => PluginDlteamsRiskAssessment::getMenuContent(),
                'protectivemeasure' => PluginDlteamsProtectiveMeasure::getMenuContent(),
                'impactanalysis' => PluginDlteamsImpactAnalysis::getMenuContent(),
                // PluginDlteamsProtectiveMeasure::class,
                'plugindlteamsmenu' => PluginDlteamsMenu::getMenuContent(),
                'plugindlteamsiso27001' => PluginDlteamsIso27001::getMenuContent(),
                'governance' => PluginDlteamsIso26000::getMenuContent(),
            ],
        ];

        // --- Menu Registre RGPD
        $registres = [
            'default' => '/marketplace/dlteams/front/rgpddashboard.php',
            'icon' => "fa-sharp fa-solid fa-cogs",
            //'icon'    => "fas fa-shield",
            'title' => 'Registre RGPD',
            'content' => [],
        ];
        $itemtypes_registre = [
            PluginDlteamsRecord::$menukey => PluginDlteamsRecord::class,
            PluginDlteamsConcernedPerson::$menukey => PluginDlteamsConcernedPerson::class,
            PluginDlteamsProcessedData::$menukey => PluginDlteamsProcessedData::class,
			PluginDlteamsPolicieForm::$menukey => PluginDlteamsPolicieForm::class,
            PluginDlteamsLegalbasi::$menukey => PluginDlteamsLegalbasi::class,
            PluginDlteamsStoragePeriod::$menukey => PluginDlteamsStoragePeriod::class,
            PluginDlteamsThirdPartyCategory::$menukey => PluginDlteamsThirdPartyCategory::class,
            PluginDlteamsRightMeasure::$menukey => PluginDlteamsRightMeasure::class,
        ];
        foreach ($itemtypes_registre as $menukey => $class) {
            if (Session::haveRight($class::$rightname, READ)) {
                $registres['content'][$menukey] = $class::getMenuContent();
            }
        }

        // --- Menu Données et accès
        $dataaccess = [
            'default' => '/marketplace/dlteams/front/dataaccessmenu.php',
            'icon' => "fa-sharp fa-solid fa-database",
            'title' => 'Données et accès',
            'content' => [],
        ];
        $classes = [
            PluginDlteamsPolicieForm::class,
            PluginDlteamsDataCatalog::class,
            Database::class,
            Appliance::class,
            PluginDlteamsAccountKey::class,
            PluginDlteamsAccessOpening::class,
//            PluginDlteamsDataCarrierType::class,
        ];

        $itemtypes_dataaccess = [];

        foreach ($classes as $class) {
            if (property_exists($class, 'menukey') && isset($class::$menukey)) {
                $itemtypes_dataaccess[$class::$menukey] = $class;
            }
        }

        foreach ($itemtypes_dataaccess as $menukey => $class) {
            if (property_exists($class, 'rightname') && Session::haveRight($class::$rightname, READ)) {
                $dataaccess['content'][$menukey] = $class::getMenuContent();
            }
        }


        // Droits pour insertion
        $can_read_dashboard = Session::haveRight('dashboard', READ);
        $can_read_datagovernance = !empty($registres['content']);
        $can_read_dataaccess = !empty($dataaccess['content']);

        // Insertion des menus selon les droits
        if ($can_read_dashboard) {
            array_splice_assoc($menu, 1, 0, ['actifs' => $assets]);
            array_splice_assoc($menu, 2, 0, ['dlteams' => $dlteams]);
        }
        if ($can_read_datagovernance) {
            array_splice_assoc($menu, 2, 0, ['datagovernance' => $registres]);
        }
        if ($can_read_dataaccess) {
            array_splice_assoc($menu, 2, 0, ['dataaccess' => $dataaccess]);
        }
    }

    /*
     * SECTION 2 : Mise à jour de l'icône du menu "assets"
     */
    if (isset($menu['assets'])) {
        $menu['assets']['icon'] = 'fa fa-desktop';
    }

    /*
     * SECTION 2 : Réorganisation du menu "management" et "tools"
     */
    if (isset($menu['management']) && is_array($menu['management']['content'])) {
        // Transfert de sous-menus de "management" vers "assets"
        if (isset($menu['assets']['content']) && is_array($menu['assets']['content'])) {
            $transferts = [
                'line' => 2,
                'certificate' => 3,
                'datacenter' => 4,
                'cluster' => 5,
                'domain' => 5,
            ];
            foreach ($transferts as $key => $position) {
                if (isset($menu['management']['content'][$key])) {
                    $tmp = $menu['management']['content'][$key];
                    unset($menu['management']['content'][$key]);
                    array_splice_assoc($menu['assets']['content'], $position, 0, [$key => $tmp]);
                }
            }
        }

        // Ajout d'éléments spécifiques dans "management"
        array_splice_assoc($menu['management']['content'], 0, 0, ['document' => Document::getMenuContent()]);
        array_splice_assoc($menu['management']['content'], 1, 0, ['deliverable' => PluginDlteamsDeliverable::getMenuContent()]);
        array_splice_assoc($menu['management']['content'], 2, 0, ['notepad' => Notepad::getMenuContent()]);
        array_splice_assoc($menu['management']['content'], 3, 0, ['contract' => Contract::getMenuContent()]);
        array_splice_assoc($menu['management']['content'], 4, 0, ['budget' => Budget::getMenuContent()]);

        // Injections dans "helpdesk"
        array_splice_assoc($menu['helpdesk']['content'], 1, 0, ['plugindlteamstickettask' => PluginDlteamsTicketTask::getMenuContent()]);
        array_splice_assoc($menu['helpdesk']['content'], 12, 0, ['project' => Project::getMenuContent()]);
        array_splice_assoc($menu['helpdesk']['content'], 13, 0, ['reservationitem' => ReservationItem::getMenuContent()]);

        $plugin = new Plugin();
        if ($plugin->isActivated('formcreator')) {
            array_splice_assoc($menu['helpdesk']['content'], 14, 0, ['formcreatoranswer' => PluginFormcreatorFormAnswer::getMenuContent()]);
            if (Session::haveRight('entity', UPDATE)) {
                $PLUGIN_HOOKS['menu_toadd']['formcreator']['management'] = PluginFormcreatorForm::class;
                unset($PLUGIN_HOOKS['menu_toadd']['formcreator']['admin']);
                array_splice_assoc($menu['management']['content'], 3, 0, ['form' => PluginFormcreatorForm::getMenuContent()]);
            }
//            if (isset(Location::$menukey)) {
//                array_splice_assoc($menu['management']['content'], 4, 0, [Location::$menukey => Location::getMenuContent()]);
//            }
        }

        if ($plugin->isActivated('archimap') && Session::haveRight('plugin_archimap', READ)) {
            unset($PLUGIN_HOOKS['menu_toadd']['archimap']['graph']);
        }

        // Transfert d'éléments depuis "tools" vers "management"
        if (isset($menu['tools']['content']) && is_array($menu['tools']['content'])) {
            $outils = ['knowbaseitem', 'reminder', 'rssfeed'];
            foreach ($outils as $key) {
                if (isset($menu['tools']['content'][$key])) {
                    $tmp = $menu['tools']['content'][$key];
                    unset($menu['tools']['content'][$key]);
                    $position = match ($key) {
                        'knowbaseitem' => 5,
                        'reminder' => 6,
                        'rssfeed' => 7,
                        default => 0,
                    };
                    array_splice_assoc($menu['management']['content'], $position, 0, [$key => $tmp]);
                }
            }
        }

        if ($plugin->isActivated('archimap') && Session::haveRight('plugin_archimap', READ)) {
            array_splice_assoc($menu['management']['content'], 3, 0, ['pluginarchimapmenu' => PluginArchimapGraph::getMenuContent()]);
        }

        // Transfert du sous-menu "softwarelicense"
        if (isset($menu['management']['content']['softwarelicense']) && isset($menu['assets']['content'])) {
            $tmp = $menu['management']['content']['softwarelicense'];
            unset($menu['management']['content']['softwarelicense']);
            array_splice_assoc($menu['assets']['content'], 3, 0, ['informatiquesoftwarelicense' => $tmp]);
        }

        // Suppression de la clé "reservationitem" dans "tools"
        if (isset($menu['tools']['content']['reservationitem'])) {
            unset($menu['tools']['content']['reservationitem']);
        }
    }

    /*
     * SECTION 3 : Ajout du menu "personnes & organisations"
     */
    $personnesorganisme = [
        'default' => '/marketplace/dlteams/front/personnes.php',
        'icon' => "fa-sharp fa-solid fa-users",
        'title' => _n("People & organization", "People & organizations", 2, "dlteams"),
        'content' => [],
    ];
    $itemtypes_personnesorganisme = [
        PluginDlteamsPersonnesMenu::$menukey ?? null => PluginDlteamsPersonnesMenu::class,
        Supplier::$menukey ?? null => Supplier::class,
        Contact::$menukey ?? null => Contact::class,
        User::$menukey ?? null => User::class,
        Group::$menukey ?? null => Group::class,
        Entity::$menukey ?? null => Entity::class,
		Location::$menukey ?? null => Location::class,
    ];
    $itemtypes_personnesorganisme = array_filter($itemtypes_personnesorganisme, fn($key) => $key !== null, ARRAY_FILTER_USE_KEY);

    // Suppression d'éléments déplacés
    if (isset($menu['management']['content']) && is_array($menu['management']['content'])) {
        unset(
            $menu['management']['content']['supplier'],
            $menu['management']['content']['contact'],
            $menu['management']['content']['database'],
            $menu['management']['content']['appliance']
        );
    }
    if (isset($menu['admin']['content']) && is_array($menu['admin']['content'])) {
        unset(
            $menu['admin']['content']['user'],
            $menu['admin']['content']['group'],
            $menu['admin']['content']['entity'],
        );
    }
    if (isset($menu['tools']['content']) && is_array($menu['tools']['content'])) {
        unset($menu['tools']['content']['project']);
    }

    // Ajout conditionnel selon les droits
    foreach ($itemtypes_personnesorganisme as $menukey => $class) {
        if (Session::haveRight($class::$rightname, READ)) {
            $personnesorganisme['content'][$menukey] = $class::getMenuContent();
        }
    }
    if (!empty($personnesorganisme['content'])) {
        array_splice_assoc($menu, 1, 0, ['personnesorganisme' => $personnesorganisme]);
    }

    // Mise à jour du default de helpdesk
    $menu['helpdesk']['default'] = '/front/dashboard_helpdesk.php';

    /*
     * SECTION 4 : Réordonnancement final des clés du menu
     */
    $desiredOrder = [
        'personnesorganisme',
        'actifs',
        'assets',
        'dataaccess',
        'helpdesk',
        'management',
        'dlteams',
        'datagovernance',
        'tools',
        'admin',
        'config',
    ];
    $allKeys = array_keys($menu);
    $extraKeys = array_diff($allKeys, $desiredOrder);
    $newMenu = [];

    foreach ($desiredOrder as $key) {
        if (isset($menu[$key])) {
            $newMenu[$key] = $menu[$key];
        }
        if ($key == "assets")
            $newMenu[$key]["default"] = "/marketplace/dlteams/front/assetsmenu.php";
        if ($key == "helpdesk")
            $newMenu[$key]["default"] = "/marketplace/dlteams/front/helpdeskmenu.php";
        if ($key == "management")
            $newMenu[$key]["default"] = "/marketplace/dlteams/front/managementmenu.php";


    }
    foreach ($extraKeys as $key) {
        $newMenu[$key] = $menu[$key];
    }

    return $newMenu;
}


/**
 * Hook pour filtrer les utilisateurs sur dlteams.app
 */
//function plugin_dlteams_filter_users($itemtype, $options) {
//    var_dump("zzz");
//    die();
//    if ($itemtype === 'User' && isset($_SERVER['HTTP_HOST']) && $_SERVER['HTTP_HOST'] === 'dlteams.app') {
//        // Ajouter une condition pour exclure les utilisateurs 2 et 4367
//        if (!isset($options['WHERE'])) {
//            $options['WHERE'] = [];
//        }
//
//        $options['WHERE'][] = [
//            'NOT' => [
//                'glpi_users.id' => [2, 4367]
//            ]
//        ];
//    }
//
//    return $options;
//}


/**
 * Insère un tableau associatif dans un autre tableau à une position donnée tout en préservant les clés.
 *
 * @param array $array Le tableau original
 * @param int $position La position d'insertion
 * @param int $length Le nombre d'éléments à remplacer (souvent 0 pour une insertion)
 * @param array $insert Le tableau associatif à insérer
 * @return array Le tableau modifié
 */

function array_splice_assoc(array &$array, int $position, int $length, array $insert): array
{
    $array_before = array_slice($array, 0, $position, true);
    $array_after = array_slice($array, $position + $length, null, true);
    $array = $array_before + $insert + $array_after;
    return $array;
}

function plugin_dlteams_pre_item_form($params)
{

    if (!$params["item"])
        return;
    if ($params["item"]->getType() == Entity::class && Session::getActiveTab(Entity::class) == "Entity$2") {

        echo "<tr><th colspan='4'>" . __('Lieux') . "</th></tr>";

        echo "<tr class='tab_bg_1'>";
        echo "<td>Choisir un lieu</td>";
        echo "<td style='display: flex'>";
        // Affichage de la dropdown des locations (vérifiez que le name est bien 'locations_id')
        Location::dropdown([
            'entity' => $_SESSION['glpiactive_entity'],
            'width' => '250px'
        ]);

        // Bouton pour déclencher la récupération des informations
        echo "&nbsp;<button id='defaultAddressButton' style='width: fit-content;' class='btn btn-primary btn-secondary'>" .
            _x('button', 'Adresse par défaut') . "</button>";
        echo "</td>";
        echo "<td align='left'></td>";
        echo "<td></td>";
        echo "</tr>";

        global $CFG_GLPI;

        $ajax_url = $CFG_GLPI["root_doc"] . "/marketplace/dlteams/ajax/locationinfo.php";

        // Injection du script jQuery
        echo "<script>
        $(document).ready(function(){
            // Désactivation initiale des champs
            $('input[name=\"postcode\"]').prop('readonly', true);
            $('textarea[name=\"address\"]').prop('readonly', true);
            $('input[name=\"town\"]').prop('readonly', true);
            $('input[name=\"state\"]').prop('readonly', true);
            $('input[name=\"country\"]').prop('readonly', true);
            $('input[name=\"longitude\"]').prop('readonly', true);
            $('input[name=\"latitude\"]').prop('readonly', true);
            $('input[name=\"altitude\"]').prop('readonly', true);

            // Clic sur le bouton 'Adresse par défaut'
            $('#defaultAddressButton').on('click', function(e){
                e.preventDefault(); // Empêche le comportement par défaut du bouton

                var locationId = $('select[name=\"locations_id\"]').val();
                if(locationId !== ''){
                    // Requête AJAX pour récupérer les informations de la location sélectionnée
                    $.ajax({
                        url: '$ajax_url',
                        method: 'GET',
                        data: { id: locationId },
                        dataType: 'json',
                        success: function(response) {
                            // Remplissage des champs désactivés avec les données reçues
                            $('input[name=\"postcode\"]').val(response.postcode);
                            $('textarea[name=\"address\"]').val(response.address);
                            $('input[name=\"town\"]').val(response.town);
                            $('input[name=\"state\"]').val(response.state);
                            $('input[name=\"country\"]').val(response.country);
                            $('input[name=\"longitude\"]').val(response.longitude);
                            $('input[name=\"latitude\"]').val(response.latitude);
                            $('input[name=\"altitude\"]').val(response.altitude);
                        },
                        error: function(xhr, status, error) {
                            console.error('Erreur lors de la récupération des informations : ' + error);
                        }
                    });
                }
            });
            // Avant la soumission du formulaire, supprimer l'attribut 'name' du champ locations_id
            $('form').on('submit', function(){
                $('select[name=\"locations_id\"]').removeAttr('name');
            });
            
        });
        </script>";
    }

}

// Handle update item hook - @param CommonDBTM $item Item instance - @return void
function dlteams_purge_called(CommonDBTM $item)
{
    switch ($item::getType()) {
        case Link::getType():
            PluginDlteamsDeliverable_Item::deleteItemAfterLinkDeletion($item);
            break;
    }
}

function drop_tables()
{
    global $DB;
    $objects = [
        'accountkeys', 'accountkeys_items', 'activitycategories', 'activitycategories_items', 'allitems', 'auditcategories', 'auditcategories_items', 'audits', 'audits_items', 'catalogclassifications', 'concernedpersons', 'concernedpersons_items', 'configs', 'conservationcategory', 'consent', 'contacts_items', 'controllerinfos', 'databasehostings', 'databasemanagements', 'datacarriercategories', 'datacarrierhostings', 'datacarriermanagements', 'datacarriertypes', 'datacarriertypes_items', 'datacatalogs', 'datacatalogs_items', 'datacategories', 'datacenters_items', 'deliverables', 'deliverables_contents', 'deliverables_items', 'dlteams_deliverables_sections', 'deliverables_variables', 'deliverables_variables_items', 'documents_items', 'groups_items', 'impacts', 'impactorganisms', 'keytypes', 'legalbasis', 'legalbasistypes', 'legalbasis_items', 'links_items', 'meansofacces', 'meansofacces_items', 'mediasupports', 'networkequipments_items', 'pdus_items', 'peripherals_items', 'phones_items', 'physicalstorages', 'physicalstorages_items', 'policieforms', 'policieforms_items', 'processeddatas', 'processeddatas_items', 'processes', 'processes_items', 'protectivecategories', 'protectivemeasures', 'protectivemeasures_items', 'protectivetypes', 'records', 'records_actionfinperiodes', 'records_contracts', 'records_items', 'records_legalbasis', 'records_legalbasisacts', 'records_personalanddatacategories', 'records_retentions', 'records_securitymeasures', 'records_softwares', 'records_consent', 'records_externals', 'storages', 'records_storages', 'records_impacts', 'records_elements', 'records_basedonnees', 'records_impactorganisms', 'rightmeasurecategories', 'rightmeasures', 'rightmeasures_items', 'riskassessments', 'riskassessments_items', 'sendingreasons', 'servertypes', 'storageendactions', 'storageperiods', 'storageperiods_items', 'storagetypes', 'thirdpartycategories', 'thirdpartycategories_items', 'trainingcategories', 'trainingcertifications', 'trainings', 'userprofiles', 'users_items', 'printers_items', 'procedures', 'procedures_contents', 'procedures_items', 'procedures_sections', 'procedures_variables', 'procedures_variables_items', 'racks_items', 'siintegrations', 'trainingsessions', 'trainingsessions_items', 'transmissionmethods', 'steps_items', 'storageunittypes', 'vehicles', 'vehicletypes',
    ];
    foreach ($objects as $object) {
        $table = "glpi_plugin_dlteams_" . $object;
        $query = "DROP TABLE IF EXISTS " . $table . " ";
        $DB->queryOrDie($query, $DB->error());
    }

}


function rollback_columns()
{
    global $DB;
    $objects = [
        'glpi_knowbaseitems' => ['entities_id', 'is_recursive']
    ];

    // Pour chaque table et ses colonnes à supprimer
    foreach ($objects as $tableName => $columns) {
        $table = "" . $tableName;
        foreach ($columns as $column) {
            $query = "ALTER TABLE " . $table . " DROP COLUMN " . $column;
            $DB->queryOrDie($query, $DB->error());
        }
    }
}

function plugin_dlteams_copyFiles($source_directory, $target_prefix = GLPI_ROOT)
{
    $rii = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($source_directory));
    $files = [];

    foreach ($rii as $file) {
        if ($file->isDir()) {
            continue;
        }
        $files[] = $file->getPathname();
    }

    foreach ($files as $path) {
        $target_path = $target_prefix . str_replace($source_directory, "", $path);
        if (!copy($path, $target_path)) {
            Session::addMessageAfterRedirect("Error copying file: " . $path, 0, ERROR);
        }
    }
}

function plugin_dlteams_resetCache()
{
    $config = new Config();
    $config->checkGlobal(UPDATE);
    $cache_manager = new \Glpi\Cache\CacheManager();
    if ($cache_manager->getTranslationsCacheInstance()->clear()) {
        Session::addMessageAfterRedirect(__('Translation cache reset successful'));
    }
}

function plugin_dlteams_deactivate()
{

    $types = PluginDlteamsItemType::getTypes();


    foreach ($types as $type) {
        if (str_contains(strtolower($type), "dlteams")) {
            $item_class = $type . "_Item";
            $origin_table = $type::getTable();
            if (class_exists($item_class)) {
                $item_table = $item_class::getTable();
                $where_condition = [
                    $origin_table . ".id IS NULL"
                ];

                $join_condition = [
                    "LEFT JOIN" => [
                        $origin_table => [
                            'ON' => [
                                $origin_table => "id",
                                $item_table => strtolower(str_replace("PluginDlteams", "", $type::getType())) . "s_id",
                            ]
                        ],
                    ],

                ];

                global $DB;
                // supprimer tous les elements trouvés
                $DB->delete($item_table, $where_condition, $join_condition);

//          Rechercher dans la table item, en faisant une left jointure avec la table mere where tablemere.id is null
//                $query = [
//                    "FROM" => $item_table,
//                    "LEFT JOIN" => [
//                        $origin_table => [
//                            'ON' => [
//                                $origin_table => "id",
//                                $item_table => strtolower(str_replace("PluginDlteams", "", $item_table::getType())) . "s_id",
//                            ]
//                        ],
//                    ],
//                    "WHERE" => $where_condition
//                ];

            }
        }
    }
    PluginDlteamsConfig::plugin_deactivate();
}


function plugin_dlteams_activate()
{
    /*var_dump("zzz");
    die();*/
    PluginDlteamsConfig::plugin_activate();
}


