<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */


use GlpiPlugin\dlteams\Exception\ImportFailureException;

class PluginDlteamsAppliance_Policieform extends CommonDBTM
{
//    static public $itemtype_2 = 'PluginDlteamsAcces_Storage';
    static public $itemtype_1;
    public static $items_id_1;

//    public function __construct()
//    {
//        static::$itemtype_1 = str_replace("_Item", "", __CLASS__); // $itemtype_1 ---> PluginDlteamsDataCatalog
//        static::$items_id_1 = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", __CLASS__))) . "s_id";
//        parent::__construct();
//        parent::forceTable(PluginDlteamsStoragePeriod_Item::getTable());
//    }

    static function canCreate()
    {
        return true;
    }

    static function canView()
    {
        return true;
    }

    static function canUpdate()
    {
        return true;
    }

    static function canDelete()
    {
        return true;
    }

    static function canPurge()
    {
        return true;
    }

    function canCreateItem()
    {
        return true;
    }

    function canViewItem()
    {
        return true;
    }

    function canUpdateItem()
    {
        return true;
    }

    function canDeleteItem()
    {
        return true;
    }

    function canPurgeItem()
    {
        return true;
    }

//    static function getTypeName($nb = 0)
//    {
//        return __("Data catalog", 'dlteams');
//    }

    static function getTypeNameForClass($nb = 0)
    {
        return __("Jeux de données effectifs", 'dlteams');
    }

    // affichage de l'onglet et de son nom
    public function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {
        switch ($item->getType()) {
            case Appliance::class:
                $ong = [];
                if (!$withtemplate) {
                    if (Session::haveRight($item::$rightname, READ)) {
                        // tab name Traitements
                        $ong[] = static::createTabEntry(__("Jeux de données effectifs", 'dlteams'), count(static::getAppliancePolicieformEffectifRequest($item)));
                    }
                }

                return $ong;
                break;
        }

        return '';
    }

    // comptage du nombre de liaison entre les 2 objets dans la table de l'objet courant
    static function countForItem(CommonDBTM $item)
    {
        $dbu = new DbUtils();
        return $dbu->countElementsInTable(static::getTable(), ['items_id' => $item->getID(), 'itemtype' => $item->getType()]);
    }


    public static function getItemsRequest(CommonDBTM $object_item)
    {
        global $DB;
        $link_table = str_replace("_Item", "", __CLASS__);
        $temp = new $link_table();

        $items = $DB->request([
            'FROM' => self::getTable(),
            'SELECT' => [
                self::getTable() . '.id',
                self::getTable() . '.id as linkid',
                self::getTable() . '.comment',
                self::getTable() . '.itemtype as itemtype',
                self::getTable() . '.items_id as items_id',
            ],
            'WHERE' => [
                static::getTable() . '.' . static::$items_id_1 => $object_item->fields['id']
            ],
            'LEFT JOIN' => [
                $temp->getTable() => [
                    'FKEY' => [
                        static::getTable() => static::$items_id_1,
                        $temp->getTable() => 'id'
                    ]
                ]
            ],
//            'ORDER' => self::getTable() . '.id DESC',
            'ORDER' => [$temp->getTable() . '.name ASC', self::getTable() . '.itemtype ASC'],
        ]);

        return iterator_to_array($items);
    }


    public function defineTabs($options = [])
    {
        $ong = [];
        $this->addDefaultFormTab($ong);
        $this->addImpactTab($ong, $options);
        return $ong;
    }

    public static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {
        switch ($item->getType()) {
//            si onglet objet datacatalog, on affiche tous les utilisateurs et groupes et contacts et suppliers qui on acces a ce catalogue
            case Appliance::class:

                    self::showPolicieformEffectifs($item);
//                end Traitements
                break;
        }
    }

    /**
     * Show items links to a document
     *
     * @param $doc Document object
     *
     * @return void
     **@since 0.84
     *
     */
    public static function showUtilisateursEffectifs(PluginDlteamsDataCatalog $object_item)
    {

        global $DB;
        $instID = $object_item->fields['id'];
        if (!$object_item->can($instID, READ)) {
            return false;
        }
        $canedit = $object_item->can($instID, UPDATE);

        $types_iterator = [];
        $types = PluginDlteamsItemType::getTypes();
//        Enlève le choix de L'objet LegalBasi dans la dropdown qui affiche la liste des objets
        $key = array_search("PluginDlteamsDataCatalog", $types);
        unset($types[$key]);
        $rand = mt_rand();

        $items = self::getUtilisateursEffectifRequest($object_item);
        if (!count($items)) {
            echo "<table class='tab_cadre_fixe'><tr><th>" . __('No item found') . "</th></tr>";
            echo "</table>";
        } else {
            echo "<table class='tab_cadre_fixehov'>";
            $header = "<tr>";
//            if ($canedit) {
//                $header .= "<th width='10'>";
//                $header .= Html::getCheckAllAsCheckbox('mass' . __CLASS__ . $rand);
//                $header .= "</th>";
//            }
            $header .= "<th>" . __("Element") . "</th>";
            $header .= "<th>" . __("Objet") . "</th>";
            $header .= "<th>" . __("Comment") . "</th>";
            $header .= "</tr>";
            echo $header;

            foreach ($items as $row) {
                $item = new $row['itemtype'](); //plante si itemtype is null
                $item->getFromDB($row['items_id']);
                $name = "<a target='_blank' href=\"" . $item::getFormURLWithID($item->getField('id')) . "\">" . $item->getField('name') . "</a>";
                echo "<tr lass='tab_bg_1'>";
//                if ($canedit) {
//                    echo "<td>";
//                    Html::showMassiveActionCheckBox(__CLASS__, $row["id"]);
//                    echo "</td>";
//                }
                echo "<td>" . $name . "</td>";
                echo "<td>" . $row["itemtype"]::getTypeName() . "</td>";
                echo "<td>" . $row['comment'] . "</td>";
                echo "</tr>";
            }
            echo $header;
            echo "</table>";

        }
    }


    /**
     * Show items links to a document
     *
     * @param $doc Document object
     *
     * @return void
     **@since 0.84
     *
     */
    public static function showPolicieformEffectifs(Appliance $object_item)
    {
        global $DB;
        $instID = $object_item->fields['id'];
        if (!$object_item->can($instID, READ)) {
            return false;
        }

        echo "<table class='tab_cadre_fixe'>";

        echo "<tr class='tab_bg_2'><th colspan='3'>" . _("Jeux de données contenus dans les catalogues") .
            "</th>";
        echo "</tr>";
        echo "</table>";

        $items = self::getAppliancePolicieformEffectifRequest($object_item);
        if (!count($items)) {
            echo "<table class='tab_cadre_fixe'><tr><th>" . __('No item found') . "</th></tr>";
            echo "</table>";
        } else {

            echo "<table class='tab_cadre_fixehov'>";
            $header = "<tr>";

            $header .= "<th>" . __(PluginDlteamsPolicieForm::getTypeName(2)) . "</th>";
            $header .= "<th style='width: 15%'>" . "Contenu" . "</th>";
            $header .= "<th>" . __("Comment") . "</th>";
            $header.="<th>"."Traitements"."</th>";
            $header .= "</tr>";
            echo $header;

            foreach ($items as $row) {
                $item = new $row['itemtype'](); //plante si itemtype is null
                $item->getFromDB($row['items_id']);
                $catalog_name = "<a target='_blank' href=\"" . $item::getFormURLWithID($item->getField('id')) . "\">" . $item->getField('name') . "</a>";

                $pf = new PluginDlteamsPolicieForm(); //plante si itemtype is null
                $pf->getFromDB($row['policieforms_id']);
                $name = "<a target='_blank' href=\"" . $pf::getFormURLWithID($pf->getField('id')) . "\">" . $pf->getField('name')." ( ".$catalog_name." ) " . "</a>";

                echo "<tr lass='tab_bg_1'>";
//                if ($canedit) {
//                    echo "<td>";
//                    Html::showMassiveActionCheckBox(__CLASS__, $row["id"]);
//                    echo "</td>";
//                }
                echo "<td>" . $name . "</td>";
                echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                echo ">" . $row["content"] . "</td>";
                echo "<td>" . $row['comment'] . "</td>";

                echo "<td class='left relations_list" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                echo ">";

                $policieform_id = $row["policieforms_id"];
                $datacatalogs_id = $row["items_id"];
//                $policieform = new PluginDlteamsPolicieForm();
//                $policieform->getFromDB($policieform_id);


                $users_data = PluginDlteamsRecord_Item::getRequest($pf);
                echo "<ul>";
                foreach ($users_data as $li_row) {
                    echo "<li>";
                    $linkid = $li_row["linkid"];
                    echo $li_row["name"] . "&nbsp; <i class='fa fa-close delete-record-pf' data-linkid='$linkid' style='color: red; cursor: pointer'></i>";
                    echo "</li>";
                }
                echo "</ul>";

                echo "<span class='pointer add_record' data-policieform-id='$policieform_id' data-datacatalog-id='$datacatalogs_id'>
                    <i class='fa fa-plus' title='" . __('Attribuer un traitement') . "'></i>
                    <span class='sr-only'>" . __('Attribuer un traitement à ce jeu de données') . "</span>
                 </span>";
                echo "</td>";
                echo "</tr>";
            }
//            echo $header;
            echo "</table>";

        }

        echo "
            <script>
                $('.add_record').click(function () {
             glpi_ajax_dialog({
                dialogclass: 'modal-md',
                bs_focus: false,
                params: {
                  policieforms_id: $(this).attr('data-policieform-id'),
                  datacatalogs_id: $(this).attr('data-datacatalog-id')
                },
                url: '/marketplace/dlteams/ajax/policiform_record.php',
                title: i18n.textdomain('dlteams').__('Action', 'dlteams'),
                close: function () {

                },
                fail: function () {
                    displayAjaxMessageAfterRedirect();
                }
                
             });
        });
                
                
                
                 $('.delete-record-pf').click(function(e) {
          e.preventDefault();
           $.ajax({
                        url: '/marketplace/dlteams/ajax/policiform_record.php',
                        type: 'POST',
                        data: {
                            delete: true,
                            linkid: $(this).attr('data-linkid'),
                        },
                        success: function (data) {
                            location.reload();
                        },
                        
            });
        });
                </script>
            ";
    }

    public static function showAccessibleCataloguesItems(CommonDBTM $object_item)
    {

        global $DB;
        $instID = $object_item->fields['id'];
        if (!$object_item->can($instID, READ)) {
            return false;
        }
        $canedit = $object_item->can($instID, UPDATE);

        $types_iterator = [];
        $types = PluginDlteamsItemType::getTypes();
//        Enlève le choix de L'objet LegalBasi dans la dropdown qui affiche la liste des objets
        $key = array_search("PluginDlteamsDataCatalog", $types);
        unset($types[$key]);
        $rand = mt_rand();
        $items = self::getCataloguesAccessibleRequest($object_item);
        if (!count($items)) {
            echo "<table class='tab_cadre_fixe'><tr><th>" . __('No item found') . "</th></tr>";
            echo "</table>";
        } else {

            echo "<table class='tab_cadre_fixehov'>";
            $header = "<tr>";
//            if ($canedit) {
//                $header .= "<th width='10'>";
//                $header .= Html::getCheckAllAsCheckbox('mass' . __CLASS__ . $rand);
//                $header .= "</th>";
//            }
            $header .= "<th>" . __("Catalogue") . "</th>";
//            $header .= "<th>" . __("Objet") . "</th>";
            $header .= "<th>" . __("Comment") . "</th>";
            $header .= "</tr>";
            echo $header;

            foreach ($items as $row) {
                /*                highlight_string("<?php\n\$data =\n" . var_export($row, true) . ";\n?>");*/
//                die();
                $item = new PluginDlteamsDataCatalog(); //plante si itemtype is null
                $item->getFromDB($row['datacatalogs_id']);
                $name = "<a target='_blank' href=\"" . $item::getFormURLWithID($item->fields['id']) . "\">" . $item->fields['name'] . "</a>";
                echo "<tr lass='tab_bg_1'>";
//                if ($canedit) {
//                    echo "<td>";
//                    Html::showMassiveActionCheckBox(__CLASS__, $row["id"]);
//                    echo "</td>";
//                }
                echo "<td>" . $name . "</td>";
//                echo "<td>" . PluginDlteamsDataCatalog::getTypeName() . "</td>";
                echo "<td>" . $row['comment'] . "</td>";
                echo "</tr>";
            }
            echo $header;
            echo "</table>";

        }
    }

    public function post_purgeItem()
    {
        global $DB;
//        purge relations
        $relation_item_str = $this->fields["itemtype"] . "_Item";
        if (!class_exists($relation_item_str))
            $relation_item_str = "PluginDlteams" . $relation_item_str;
        $relation_item = new $relation_item_str();

        $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype"]))) . "s_id";

        $criteria = [
            "itemtype" => static::$itemtype_2,
            "items_id" => $this->fields[static::$items_id_1],
            $relation_column_id => $this->fields["items_id"],
            "comment" => $this->fields["comment"]
        ];


        $DB->delete($relation_item->getTable(), $criteria);

//        $relation_item->deleteByCriteria($criteria);
    }

    public function post_updateItem($history = 1)
    {
        $relation_item_str = $this->fields["itemtype"] . "_Item";
        if (!class_exists($relation_item_str))
            $relation_item_str = "PluginDlteams" . $relation_item_str;
        $relation_item = new $relation_item_str();
        $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype"]))) . "s_id";

        $criteria = [
            "itemtype" => static::$itemtype_2,
            "items_id" => $this->fields[static::$items_id_1],
            $relation_column_id => $this->fields["items_id"],
            "comment" => $this->oldvalues["comment"]
        ];


        $relation_item->deleteByCriteria($criteria);
        $relation_item->add([
            ...$criteria,
            "comment" => $this->fields["comment"]
        ]);
    }

    function rawSearchOptions()
    {
        $tab[] = [
            'id' => '44',
            'table' => static::getTable(),
            'field' => 'comment',
            'datatype' => 'text',
            'name' => __("Commentaire"),
            'forcegroupby' => true,
            'massiveaction' => true,
        ];

        return $tab;
    }

    public function getForbiddenStandardMassiveAction()
    {
        $forbidden = parent::getForbiddenStandardMassiveAction();
        $forbidden[] = 'clone';
        $forbidden[] = 'MassiveAction:add_transfer_list';
        $forbidden[] = 'MassiveAction:amend_comment';
        return $forbidden;
    }

    public static function getUtilisateursEffectifRequest(CommonDBTM $item)
    {
        global $DB;        //var_dump ($table_name, $columnid_name);
        $table_item_name = getTableForItemType(static::$itemtype_2 . "_Item");

        $query = [
            'SELECT' => [
                $table_item_name . '.id AS linkid',
                $table_item_name . '.itemtype AS itemtype',
                $table_item_name . '.items_id AS items_id',
                $table_item_name . '.*',
            ],
            'FROM' => $table_item_name,
            'WHERE' => [
                $table_item_name . '.itemtype' => ['LIKE', PluginDlteamsAccountKey::class],
                $table_item_name . '.' . 'datacatalogs_id' => $item->fields['id'],
            ],
        ];

        if ($DB->fieldExists($table_item_name, 'comment')) {
            $query['SELECT'][] = $table_item_name . '.comment AS comment';
        }


        $iterator = $DB->request($query);
        $temp = [];

        foreach ($iterator as $id => $data) {

            if ($data["itemtype"]) {
                $item_object = null;
                $item_str = $data["itemtype"];
                $item_object = new $item_str();
                $item_object->getFromDB($data["items_id"]);


                if (isset($item_object->fields["entities_id"])) {
                    array_push($temp, $data);
                }

            }

        }

        $users = [];
//      get users that have acces to this catalog through account or keys
        foreach ($temp as $datacatalog_item) {

            $request2 = [
                'SELECT' => [
                    PluginDlteamsAccountKey_Item::getTable() . ".id as linkid",
                    PluginDlteamsAccountKey_Item::getTable() . ".*",
                ],
                'FROM' => PluginDlteamsAccountKey_Item::getTable(),
                'OR' => [
                    [
                        'itemtype' => User::class,
                        'accountkeys_id' => $datacatalog_item["items_id"]
                    ],
                    [
                        'itemtype' => Group::class,
                        'accountkeys_id' => $datacatalog_item["items_id"]
                    ],
                    [
                        'itemtype' => Supplier::class,
                        'accountkeys_id' => $datacatalog_item["items_id"]
                    ],
                    [
                        'itemtype' => Contact::class,
                        'accountkeys_id' => $datacatalog_item["items_id"]
                    ],
                ],
            ];


            $iterator = $DB->request($request2);
            $temp = [];

            foreach ($iterator as $id => $data) {

                if ($data["itemtype"]) {
                    array_push($users, $data);
                }

            }
        }

        return $users;
    }


    public static function getAppliancePolicieformEffectifRequest(CommonDBTM $item)
    {
        global $DB;        //var_dump ($table_name, $columnid_name);
        $table_item_name = getTableForItemType(PluginDlteamsDataCatalog::class . "_Item");

        $query = [
            'SELECT' => [
                $table_item_name . '.id AS linkid',
                $table_item_name . '.itemtype AS itemtype',
                $table_item_name . '.items_id AS items_id',
                $table_item_name . '.*',
            ],
            'FROM' => $table_item_name,
            'WHERE' => [
                $table_item_name . '.itemtype' => ['LIKE', PluginDlteamsAppliance::class],
                $table_item_name . '.' . 'items_id' => $item->fields['id'],
            ],
        ];

//        if ($DB->fieldExists($table_item_name, 'comment')) {
//            $query['SELECT'][] = $table_item_name . '.comment AS comment';
//        }


        $iterator = $DB->request($query);
        $temp = [];

        foreach ($iterator as $id => $data) {

            if ($data["itemtype"]) {
                $item_object = null;
                $item_str = $data["itemtype"];
                $item_object = new $item_str();
                $item_object->getFromDB($data["items_id"]);


                if (isset($item_object->fields["entities_id"])) {
                    array_push($temp, $data);
                }

            }

        }

        $policieforms = [];
//      get policieforms that have acces to this appliance through datacatalog
        foreach ($temp as $datacatalog) {

            $request2 = [
                'SELECT' => [
                    PluginDlteamsPolicieForm_Item::getTable() . ".id as linkid",
                    PluginDlteamsPolicieForm_Item::getTable() . ".*",
                    PluginDlteamsPolicieForm::getTable() . ".content as content",
                ],
                'FROM' => PluginDlteamsPolicieForm_Item::getTable(),
                'JOIN' => [
                    PluginDlteamsPolicieForm::getTable() => [
                        'ON' => [
                            PluginDlteamsPolicieForm_Item::getTable() => "policieforms_id",
                            PluginDlteamsPolicieForm::getTable() => 'id'
                        ]
                    ]
                ],
                'WHERE' => [
                    'itemtype' => PluginDlteamsDataCatalog::class,
                    'items_id' => $datacatalog["datacatalogs_id"]
                ],
            ];


            $iterator = $DB->request($request2);
            $temp = [];

            foreach ($iterator as $id => $data) {

                if ($data["itemtype"]) {
                    array_push($policieforms, $data);
                }

            }
        }

        return $policieforms;
    }


    public static function getCataloguesAccessibleRequest(CommonDBTM $item)
    {
        global $DB;        //var_dump ($table_name, $columnid_name);


        $accountkeys = [];
//      get users that have acces to this catalog through account or keys

        $request2 = [
            'SELECT' => [
                PluginDlteamsAccountKey_Item::getTable() . ".id as linkid",
                PluginDlteamsAccountKey_Item::getTable() . ".*",
            ],
            'FROM' => PluginDlteamsAccountKey_Item::getTable(),
            'WHERE' => [
                'itemtype' => $item->getType(),
                'items_id' => $item->fields["id"]
            ]
        ];


        $iterator = $DB->request($request2);

        foreach ($iterator as $id => $data) {

            if ($data["itemtype"]) {
                array_push($accountkeys, $data);
            }

        }


        $temp = [];
        foreach ($accountkeys as $accountkey_item) {
            $query = [
                'SELECT' => [
                    PluginDlteamsDataCatalog_Item::getTable() . '.id AS linkid',
                    PluginDlteamsDataCatalog_Item::getTable() . '.itemtype AS itemtype',
                    PluginDlteamsDataCatalog_Item::getTable() . '.items_id AS items_id',
                    PluginDlteamsDataCatalog_Item::getTable() . '.*',
                ],
                'FROM' => PluginDlteamsDataCatalog_Item::getTable(),
                'WHERE' => [
                    PluginDlteamsDataCatalog_Item::getTable() . '.itemtype' => ['LIKE', PluginDlteamsAccountKey::class],
                    PluginDlteamsDataCatalog_Item::getTable() . '.' . 'items_id' => $accountkey_item["accountkeys_id"],
                ],
            ];

            if ($DB->fieldExists(PluginDlteamsDataCatalog_Item::getTable(), 'comment')) {
                $query['SELECT'][] = PluginDlteamsDataCatalog_Item::getTable() . '.comment AS comment';
            }


            $iterator = $DB->request($query);

            foreach ($iterator as $id => $data) {

                if ($data["itemtype"]) {
                    array_push($temp, $data);

                }

            }
        }

        return $temp;
    }
}
