<?php

/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2023 Teclib' and contributors.
 * @copyright 2003-2014 by the INDEPNET Development Team.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */

use Glpi\Application\View\TemplateRenderer;
use Glpi\Event;
use Glpi\Plugin\Hooks;
use Glpi\System\Requirement\PhpSupportedVersion;
use Glpi\System\Requirement\SafeDocumentRoot;
use Glpi\System\Requirement\SessionsSecurityConfiguration;

/**
 * Central class
 **/
class PluginDlteamsCentral extends CommonDBTM
{

    /**
     * Return the localized name of the current Type
     * Should be overloaded in each new class
     *
     * @return string
     **/
    static function getTypeName($nb = 0) {

        return _n('Dlteams', 'Dlteams', $nb, 'resources');
    }

    /**
     * @param \CommonGLPI $item
     * @param int         $withtemplate
     *
     * @return array|string
     */
    function getTabNameForItem(CommonGLPI $item, $withtemplate = 0) {

         if ($item->getType() == 'Central') {
             $ong = [];
             $ong[] = PluginDlteamsCentral::getTypeName(2);

             $isDpo = $_SESSION['glpiactiveprofile']["name"] == "DPO";
             $isRSSI = $_SESSION['glpiactiveprofile']["name"] == "RSSI";

             if($isDpo)
                $ong[] = "DPO";

             if($isRSSI)
                $ong[] = "RSSI";
            return $ong;
        }
        return '';
    }

    /**
     * @param \CommonGLPI $item
     * @param int         $tabnum
     * @param int         $withtemplate
     *
     * @return bool
     */
    static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0) {


        $isDpo = $_SESSION['glpiactiveprofile']["name"] == "DPO";
        $isRSSI = $_SESSION['glpiactiveprofile']["name"] == "RSSI";

        if($isDpo)
            $ong[] = "DPO";

        if($isRSSI)
            $ong[] = "RSSI";
        $self = new self();
       if ($item->getType() == 'Central') {
           if($tabnum == 0)
                $self->showCentral(Session::getLoginUserID());
           if($tabnum == 1 && $isDpo)
               $self->showCentralForDPO(Session::getLoginUserID());
           if($tabnum == 2 && $isRSSI)
               $self->showCentralFORRSSI(Session::getLoginUserID());

        }
        return true;
    }


    public static function canView()
    {
        return true;
    }

    /**
     * @param $who
     */
    function showCentral($who) {
        global $DB, $CFG_GLPI;
        
        if (!$this->canView()) {
            return;
        }



        $who = Session::getLoginUserID();
/*        highlight_string("<?php\n\$data =\n" . var_export($_SESSION['glpiactiveprofile'], true) . ";\n?>");*/
//        die();

        
        // === WIDGETS GLPI STANDARD ===
        $lists = [];
        
        // Messages (ITILFollowup)
        if (Session::haveRight('followup', READ)) {
            $lists[] = [
                'itemtype' => PluginDlteamsMessage::class,
                'status' => 'process'
            ];
        }

        // Actualités
        if (Session::haveRight('reminder_public', READ)) {
            $lists[] = [
                'itemtype' => Reminder::class,
                'status' => 'process'
            ];
        }
        
        // Tâches (TicketTask)
        if (Session::haveRight('ticket', READ)) {
            $lists[] = [
                'itemtype' => TicketTask::class,
                'status' => 'todo'
            ];
        }


        if (Session::haveRight('ticket', READ)) {
            $lists[] = [
                'itemtype' => PluginDlteamsTicketTask::class,
                'status' => 'process'
            ];
        }

        
        // Événements
        if (Session::haveRight('ticket', READ)) {
            $lists[] = [
                'itemtype' => Ticket::class,
                'status' => 'process'
            ];
        }
        
        // Documents
        if (Session::haveRight('document', READ)) {
            $lists[] = [
                'itemtype' => Document::class,
                'status' => 'process'
            ];
        }
        
        // Contrats
        if (Session::haveRight('contract', READ)) {
            $lists[] = [
                'itemtype' => Contract::class,
                'status' => 'process'
            ];
        }
        
        // Notes
        if (Session::haveRight('notepad', READ)) {
            $lists[] = [
                'itemtype' => Notepad::class,
                'status' => 'process'
            ];
        }
        
        // Base de connaissance
        if (Session::haveRight('knowbase', READ)) {
            $lists[] = [
                'itemtype' => KnowbaseItem::class,
                'status' => 'process'
            ];
        }

        // Réponses aux formulaires
//        if (class_exists('PluginFormcreatorFormAnswer') && Session::haveRight('plugin_formcreator', READ)) {
            $lists[] = [
                'itemtype' => 'PluginFormcreatorFormAnswer',
                'status' => 'process'
            ];
//        }

        
        $twig_params = [
            'cards' => []
        ];
        
        foreach ($lists as $list) {
            $card_params = [
                'start' => 0,
                'status' => $list['status'],
                'showgrouptickets' => 'false'
            ];
            $idor = Session::getNewIDORToken($list['itemtype'], $card_params);
            $twig_params['cards'][] = [
                'itemtype' => $list['itemtype'],
                'widget' => 'central_list',
                'params' => $card_params + [
                    '_idor_token' => $idor
                ]
            ];
        }
        
        // Planning
        $card_params = [
            'who' => $who
        ];
        $idor = Session::getNewIDORToken(Planning::class, $card_params);
        $twig_params['cards'][] = [
            'itemtype' => Planning::class,
            'widget' => 'central_list',
            'params' => $card_params + [
                '_idor_token' => $idor
            ]
        ];
        
        // Actualités et rappels personnels
        $idor = Session::getNewIDORToken(Reminder::class);
        $twig_params['cards'][] = [
            'itemtype' => Reminder::class,
            'widget' => 'central_list',
            'params' => [
                '_idor_token' => $idor
            ]
        ];
        
        // Actualités et rappels publics
        if (Session::haveRight("reminder_public", READ)) {
            $idor = Session::getNewIDORToken(Reminder::class, [
                'personal' => 'false'
            ]);
            $twig_params['cards'][] = [
                'itemtype' => Reminder::class,
                'widget' => 'central_list',
                'params' => [
                    'personal' => 'false',
                    '_idor_token' => $idor
                ]
            ];
        }
        
        TemplateRenderer::getInstance()->display('central/widget_tab.html.twig', $twig_params);
    }


    function showCentralFORRSSI($who) {
        global $DB, $CFG_GLPI;

        if (!$this->canView()) {
            return;
        }



        $who = Session::getLoginUserID();

        // === WIDGETS GLPI STANDARD ===
        $lists = [];

        // Jeux de données
        if (Session::haveRight('plugin_dlteams_policieform', READ)) {
            $lists[] = [
                'itemtype' => 'PluginDlteamsPolicieForm',
                'status' => 'process'
            ];
        }

        // Catalogues
        if (Session::haveRight('plugin_dlteams_datacatalog', READ)) {
            $lists[] = [
                'itemtype' => 'PluginDlteamsDataCatalog',
                'status' => 'process'
            ];
        }

        // Applicatifs
        if (Session::haveRight('plugin_dlteams_appliance', READ)) {
            $lists[] = [
                'itemtype' => 'PluginDlteamsAppliance',
                'status' => 'process'
            ];
        }

        // Comptes et clés
        if (Session::haveRight('plugin_dlteams_accountkey', READ)) {
            $lists[] = [
                'itemtype' => 'PluginDlteamsAccountKey',
                'status' => 'process'
            ];
        }

        // Accès physiques
        if (Session::haveRight('plugin_dlteams_accessopening', READ)) {
            $lists[] = [
                'itemtype' => PluginDlteamsAccessOpening::class,
                'status' => 'process'
            ];
        }

        // Mesures de protection
        if (Session::haveRight('plugin_dlteams_protectivemeasure', READ)) {
            $lists[] = [
                'itemtype' => PluginDlteamsProtectiveMeasure::class,
                'status' => 'process'
            ];
        }

        // Risques
        if (Session::haveRight('plugin_dlteams_riskassessment', READ)) {
            $lists[] = [
                'itemtype' => PluginDlteamsRiskAssessment::class,
                'status' => 'process'
            ];
        }

        $twig_params = [
            'cards' => []
        ];

        foreach ($lists as $list) {
            $card_params = [
                'start' => 0,
                'status' => $list['status'],
                'showgrouptickets' => 'false'
            ];
            $idor = Session::getNewIDORToken($list['itemtype'], $card_params);
            $twig_params['cards'][] = [
                'itemtype' => $list['itemtype'],
                'widget' => 'central_list',
                'params' => $card_params + [
                    '_idor_token' => $idor
                ]
            ];
        }

        // Planning
        $card_params = [
            'who' => $who
        ];
        $idor = Session::getNewIDORToken(Planning::class, $card_params);
        $twig_params['cards'][] = [
            'itemtype' => Planning::class,
            'widget' => 'central_list',
            'params' => $card_params + [
                '_idor_token' => $idor
            ]
        ];

        // Actualités et rappels personnels
        $idor = Session::getNewIDORToken(Reminder::class);
        $twig_params['cards'][] = [
            'itemtype' => Reminder::class,
            'widget' => 'central_list',
            'params' => [
                '_idor_token' => $idor
            ]
        ];

        // Actualités et rappels publics
        if (Session::haveRight("reminder_public", READ)) {
            $idor = Session::getNewIDORToken(Reminder::class, [
                'personal' => 'false'
            ]);
            $twig_params['cards'][] = [
                'itemtype' => Reminder::class,
                'widget' => 'central_list',
                'params' => [
                    'personal' => 'false',
                    '_idor_token' => $idor
                ]
            ];
        }

        TemplateRenderer::getInstance()->display('central/widget_tab.html.twig', $twig_params);
    }


    function showCentralForDPO($who) {
        global $DB, $CFG_GLPI;

        if (!$this->canView()) {
            return;
        }



        $who = Session::getLoginUserID();
/*        highlight_string("<?php\n\$data =\n" . var_export($_SESSION['glpiactiveprofile'], true) . ";\n?>");*/
//        die();

        $isDpo = $_SESSION['glpiactiveprofile']["name"] == "DPO";
        $isRSSI = $_SESSION['glpiactiveprofile']["name"] == "RSSI";


        // === WIDGETS GLPI STANDARD ===
        $lists = [];


        // Traitements
        if (Session::haveRight('plugin_dlteams_record', READ)) {
            $lists[] = [
                'itemtype' => 'PluginDlteamsRecord',
                'status' => 'process'
            ];
        }

        // Personnes concernées
        if (Session::haveRight('plugin_dlteams_concernedperson', READ)) {
            $lists[] = [
                'itemtype' => 'PluginDlteamsConcernedPerson',
                'status' => 'process'
            ];
        }

        // Données traitées
        if (Session::haveRight('plugin_dlteams_processeddata', READ)) {
            $lists[] = [
                'itemtype' => 'PluginDlteamsProcessedData',
                'status' => 'process'
            ];
        }

        // Bases légales
        if (Session::haveRight('plugin_dlteams_legalbasi', READ)) {
            $lists[] = [
                'itemtype' => 'PluginDlteamsLegalbasi',
                'status' => 'process'
            ];
        }

        // Durées de conservation
        if (Session::haveRight('plugin_dlteams_storageperiod', READ)) {
            $lists[] = [
                'itemtype' => 'PluginDlteamsStoragePeriod',
                'status' => 'process'
            ];
        }

        // Catégorie tiers
        if (Session::haveRight('plugin_dlteams_thirdpartycategory', READ)) {
            $lists[] = [
                'itemtype' => PluginDlteamsThirdPartyCategory::class,
                'status' => 'process'
            ];
        }

        // Jeux de données
        if (Session::haveRight('plugin_dlteams_policieform', READ)) {
            $lists[] = [
                'itemtype' => 'PluginDlteamsPolicieForm',
                'status' => 'process'
            ];
        }

//        // Catalogues
//        if (Session::haveRight('plugin_dlteams_datacatalog', READ)) {
//            $lists[] = [
//                'itemtype' => 'PluginDlteamsDataCatalog',
//                'status' => 'process'
//            ];
//        }
//
//        // Applicatifs
//        if (Session::haveRight('plugin_dlteams_appliance', READ)) {
//            $lists[] = [
//                'itemtype' => 'PluginDlteamsAppliance',
//                'status' => 'process'
//            ];
//        }
//
//        // Comptes et clés
//        if (Session::haveRight('plugin_dlteams_accountkey', READ)) {
//            $lists[] = [
//                'itemtype' => 'PluginDlteamsAccountKey',
//                'status' => 'process'
//            ];
//        }
//
//        // Accès physiques
//        if (Session::haveRight('plugin_dlteams_accessopening', READ)) {
//            $lists[] = [
//                'itemtype' => PluginDlteamsAccessOpening::class,
//                'status' => 'process'
//            ];
//        }
//
//        // Mesures de protection
//        if (Session::haveRight('plugin_dlteams_protectivemeasure', READ)) {
//            $lists[] = [
//                'itemtype' => PluginDlteamsProtectiveMeasure::class,
//                'status' => 'process'
//            ];
//        }
//
//        // Risques
//        if (Session::haveRight('plugin_dlteams_riskassessment', READ)) {
//            $lists[] = [
//                'itemtype' => PluginDlteamsRiskAssessment::class,
//                'status' => 'process'
//            ];
//        }

        $twig_params = [
            'cards' => []
        ];

        foreach ($lists as $list) {
            $card_params = [
                'start' => 0,
                'status' => $list['status'],
                'showgrouptickets' => 'false'
            ];
            $idor = Session::getNewIDORToken($list['itemtype'], $card_params);
            $twig_params['cards'][] = [
                'itemtype' => $list['itemtype'],
                'widget' => 'central_list',
                'params' => $card_params + [
                    '_idor_token' => $idor
                ]
            ];
        }

        // Planning
        $card_params = [
            'who' => $who
        ];
        $idor = Session::getNewIDORToken(Planning::class, $card_params);
        $twig_params['cards'][] = [
            'itemtype' => Planning::class,
            'widget' => 'central_list',
            'params' => $card_params + [
                '_idor_token' => $idor
            ]
        ];

        // Actualités et rappels personnels
        $idor = Session::getNewIDORToken(Reminder::class);
        $twig_params['cards'][] = [
            'itemtype' => Reminder::class,
            'widget' => 'central_list',
            'params' => [
                '_idor_token' => $idor
            ]
        ];

        // Actualités et rappels publics
        if (Session::haveRight("reminder_public", READ)) {
            $idor = Session::getNewIDORToken(Reminder::class, [
                'personal' => 'false'
            ]);
            $twig_params['cards'][] = [
                'itemtype' => Reminder::class,
                'widget' => 'central_list',
                'params' => [
                    'personal' => 'false',
                    '_idor_token' => $idor
                ]
            ];
        }

        TemplateRenderer::getInstance()->display('central/widget_tab.html.twig', $twig_params);
    }

}