<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */


use GlpiPlugin\dlteams\Exception\ImportFailureException;

class PluginDlteamsDocumentRGPD extends CommonDBTM
{

    public function __construct()
    {
        parent::__construct();
        self::forceTable(Document::getTable());
    }

    use PluginDlteamsExportable;

    static $rightname = 'plugin_dlteams_documentrgpd';
    public $dohistory = true;
    protected $usenotepad = true;

    static function getTypeName($nb = 0)
    {
        return __("Document", 'dlteams');
    }

    static function canCreate() {return true;}
    static function canView() {return true;}
    static function canUpdate() {return true;}
    static function canDelete() {return true;}
    static function canPurge() {return true;}
    function canCreateItem() {return true;}
    function canViewItem() {return true;}
    function canUpdateItem() {return true;}
    function canDeleteItem() {return true;}
    function canPurgeItem() {return true;}



    public static function getTable($classname = null)
    {
        return Document::getTable(); // TODO: Change the autogenerated stub
    }

    public static function getDefaultSearchRequest()
    {
        $search = [
            'criteria' => [
                0 => [
                    'field' => 7,
                    'searchtype' => 'contains',
                    'value' => 'RGPD'
                ],
            ],
            'sort' => 20,
            'order' => 'ASC'
        ];

        if (Session::haveRight(self::$rightname, Ticket::READALL)) {
            $search['criteria'][0]['value'] = 'notold';
        }
        return $search;
    }

    public function rawSearchOptions()
    {
        $document = new Document();
        return $document->rawSearchOptions(); // TODO: Change the autogenerated stub
    }
}
