<?php

use Glpi\RichText\UserMention;

/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2023 Teclib' and contributors.
 * @copyright 2003-2014 by the INDEPNET Development Team.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */

/// Class KnowbaseItem_Comment
/// since version 9.2
class PluginDlteamsLinkfile extends CommonDBTM
{
    public static $rightname = 'plugin_dlteams_linkfile';
    public $dohistory = true;


    public static function getIcon()
    {
        return 'fas fa-comments';
    }

    public static function getMenuContent()
    {
        return parent::getMenuContent(); // TODO: Change the autogenerated stub
    }


    public function canAddItem($type)
    {
        return parent::canAddItem($type); // TODO: Change the autogenerated stub
    }

    public function canCreateItem()
    {
        return parent::canCreateItem(); // TODO: Change the autogenerated stub
    }

    public function canUpdateItem()
    {
        return parent::canUpdateItem(); // TODO: Change the autogenerated stub
    }

    public function canDeleteItem()
    {
        return parent::canDeleteItem(); // TODO: Change the autogenerated stub
    }

    public function canPurgeItem()
    {
        return true;
    }

    public function canViewItem()
    {
        return true;
    }

    public static function canCreate()
    {
        return true;
    }

    public static function canView()
    {
        return true;
    }

    public static function canUpdate()
    {
        return true;
    }

    public static function canDelete()
    {
        return true;
    }

    public static function canPurge()
    {
        return true;
    }

//    protected static $notable = true;


//    public function __construct()
//    {
//        parent::forceTable("glpi_plugin_dlteams_messages");
//    }

    public static function getTypeName($nb = 0)
    {
        return _n('Fichiers', 'Fichiers', $nb);
    }

//    public static function getTable($classname = null)
//    {
//        return "glpi_plugin_dlteams_messages";
//    }


    public function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {
        switch ($item->getType()) {
            default:
                $nb = 0;
                if ($_SESSION['glpishow_count_on_tabs']) {


                }
                return [
                    0 => self::createTabEntry(self::getTypeName(), $nb)
                ];
                break;
        }
    }

    public static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {
        switch ($item->getType()) {
            default:
                self::showFiles($item);
                break;
        }
    }

    public static function showFiles(CommonDBTM $item) {
        $url = $item->fields["link"];
        $canedit = true; // Définir la permission d'édition ici
        $identifier = null;

        if (!preg_match('/\/pub\/([a-f0-9]{32})/i', $url, $matches)) {
            return;
        }
        $identifier = $matches[1];

        $directory_path = GLPI_ROOT . '/pub/' . $identifier;
        $files_list = [];
        if (is_dir($directory_path)) {
            $files_list = array_diff(scandir($directory_path), ['.', '..']);
        }

        echo "<div class='spaced file-manager' data-identifier='$identifier'>";
        echo "<table class='tab_cadre_fixehov'>";

        $header_end = "<th>" . __("Fichier") . "</th>";
        $header_end .= "<th>" . __("Type", 'dlteams') . "</th>";
        if ($canedit) {
            $header_end .= "<th>" . __("Actions") . "</th>";
        }
        echo "<tr>$header_end</tr>";

        if (empty($files_list)) {
            $colspan = $canedit ? 3 : 2;
            echo "<tr><td colspan='$colspan'>" . __("Aucun fichier dans ce dossier.") . "</td></tr>";
        }

        foreach ($files_list as $filename) {
            echo "<tr class='tab_bg_1'>";

            // Utiliser Config::get('url_base') est plus robuste que $_SERVER
            $base_url  = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
            $file_url = $base_url . '/pub/' . $identifier . '/' . $filename;
            $file_link = "<a target='_blank' rel='noopener noreferrer' href='" . $file_url . "'><span class='filename-text'>" . $filename . "</span></a>";
            $file_extension = pathinfo($filename, PATHINFO_EXTENSION);

            echo "<td class='left'>$file_link</td>";
            echo "<td class='left' width='30%'>" . strtoupper($file_extension) . "</td>";

            if ($canedit) {
                echo "<td class='center' width='80px'>
                    <i class='fas fa-pencil-alt rename-file' title=\"" . __('Rename') . "\" style='cursor:pointer; margin:0 5px;'
                       data-filename=\"" . $filename . "\"></i>
                    <i class='fas fa-trash-alt delete-file' title=\"" . __('Delete') . "\" style='cursor:pointer; margin:0 5px;'
                       data-filename=\"" . $filename . "\"></i>
                  </td>";
            }
            echo "</tr>";
        }

        echo "</table></div>";
        self::injectFileActionJs();
    }

    public static function injectFileActionJs() {
        global $CFG_GLPI;
        $ajax_url = $CFG_GLPI["root_doc"].'/marketplace/dlteams/ajax/linkfile_actions.php'; // Adaptez ce chemin si nécessaire

        echo "<script type='text/javascript'>
    $(function() {
        $(document).on('click', '.delete-file', function() {
            let icon = $(this);
            let filename = icon.data('filename');
            let identifier = $('.file-manager').data('identifier');

            if (confirm('" . __('Voulez-vous vraiment supprimer ce fichier ?') . "\\n' + filename)) {
                $.post('$ajax_url', { action: 'delete', identifier: identifier, filename: filename }, function(response) {
                    if (response.success) {
                        icon.closest('tr').fadeOut(400, function() { $(this).remove(); });
                    } else {
                        alert('Erreur: ' + response.message);
                    }
                }, 'json').fail(function() { alert('" . __('Erreur de communication avec le serveur.') . "'); });
            }
        });

        $(document).on('click', '.rename-file', function() {
            let icon = $(this);
            let td = icon.closest('tr').find('td:first');
            let span = td.find('.filename-text');
            let current_filename = icon.data('filename');
            let input_html = `<div class='rename-form'><input type='text' class='rename-input' value='` + current_filename + `' style='width: 80%;' />
                              <i class='fas fa-check-circle save-rename' style='cursor:pointer; color:green; margin-left:5px;'></i>
                              <i class='fas fa-times-circle cancel-rename' style='cursor:pointer; color:red; margin-left:5px;'></i></div>`;
            span.parent('a').hide();
            icon.closest('td').hide();
            td.append(input_html);
        });

        $(document).on('click', '.cancel-rename', function() {
            let td = $(this).closest('td');
            td.find('.rename-form').remove();
            td.find('a').show();
            td.closest('tr').find('td.center').show();
        });

        $(document).on('click', '.save-rename', function() {
            let icon = $(this);
            let td = icon.closest('td');
            let identifier = $('.file-manager').data('identifier');
            let old_filename = td.closest('tr').find('.rename-file').data('filename');
            let new_filename = td.find('.rename-input').val();

            $.post('$ajax_url', { action: 'rename', identifier: identifier, old_filename: old_filename, new_filename: new_filename }, function(response) {
                if (response.success) {
                    td.find('a').show().find('.filename-text').text(new_filename);
                    td.closest('tr').find('.rename-file, .delete-file').data('filename', new_filename);
                    td.find('.rename-form').remove();
                    td.closest('tr').find('td.center').show();
                } else {
                    alert('Erreur: ' + response.message);
                }
            }, 'json').fail(function() { alert('" . __('Erreur de communication avec le serveur.') . "'); });
        });
    });
    </script>";
    }


}