<?php

/**
 * ---------------------------------------------------------------------
 *
 * DLTeams plugin for GLPI
 *
 * @package   dlteams
 * @author    DLPlace developers
 * @copyright Copyright (c) 2022 DLPlace
 * @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
 * @link      https://github.com/dlplace/dlteams
 * @since     2021
 * ---------------------------------------------------------------------
 */

include("../../../inc/includes.php");
header("Content-Type: text/html; charset=UTF-8");
Html::header_nocache();

// Classe temporaire pour TreeBrowse
class PluginDlteamsMessageTreeBrowse extends CommonDBTM
{
    public static function getTable($classname = null) {
        return 'glpi_itilfollowups';
    }

    public static function getTypeName($nb = 0) {
        return _n('Message', 'Messages', $nb);
    }

    public function rawSearchOptions() {
        $tab = [];

        $tab[] = [
            'id' => '1',
            'table' => 'glpi_itilfollowups',
            'field' => 'id',
            'name' => __('ID'),
            'datatype' => 'number',
            'massiveaction' => false
        ];

        $tab[] = [
            'id' => '2',
            'table' => 'glpi_itilfollowups',
            'field' => 'content',
            'name' => __('Content'),
            'datatype' => 'text',
            'massiveaction' => false
        ];

        $tab[] = [
            'id' => '3',
            'table' => 'glpi_itilfollowups',
            'field' => 'date_creation',
            'name' => __('Creation date'),
            'datatype' => 'datetime',
            'massiveaction' => false
        ];

        $tab[] = [
            'id' => '4',
            'table' => 'glpi_users',
            'field' => 'name',
            'linkfield' => 'users_id',
            'name' => __('Posté par'),
            'datatype' => 'text',
            'massiveaction' => false
        ];

        $tab[] = [
            'id' => '5',
            'table' => 'glpi_itilfollowups',
            'field' => 'conversation',
            'name' => __('Conversation ID'),
            'datatype' => 'number',
            'massiveaction' => false,
            'searchtype' => 'equals'
        ];

        return $tab;
    }
}

switch ($_REQUEST['action']) {
    case "getItemslist":
        $params = [
            'start' => $_REQUEST['start'],
            'is_deleted' => $_REQUEST['is_deleted'],
            'browse' => 1,
            'as_map' => 0,
            'showmassiveactions' => true,
            'criteria' => $_REQUEST['criteria'],
            'sort' => $_REQUEST['sort'] ?? [],
            'order' => $_REQUEST['order'] ?? [],
        ];

        $itemtype = $_REQUEST['itemtype'];

        // Vérifier que c'est bien PluginDlteamsMessage
        if ($itemtype !== 'PluginDlteamsMessage') {
            http_response_code(400);
            return;
        }

        $cat_id = $_REQUEST['cat_id'] ?? '';

        // Construire le critère de filtrage par conversation
        if ($cat_id !== '' && $cat_id !== '-1') {
            $params['criteria'][] = [
                'link' => "AND",
                'field' => '5', // ID du champ conversation
                'searchtype' => "equals",
                'value' => $cat_id
            ];
        } elseif ($cat_id === '-1') {
            // Messages sans conversation
            $params['criteria'][] = [
                'link' => "AND",
                'field' => '5', // ID du champ conversation
                'searchtype' => "equals",
                'value' => '0'
            ];
        }

        // Utiliser la classe nommée
        Search::showList('PluginDlteamsMessageTreeBrowse', $params);
        return;
}
http_response_code(400);
return;