<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */


class PluginDlteamsPolicieForm_Section extends CommonDBTM
{

    public static function getDeliverableContents($sections_id){
        global $DB;
        return $DB->request([
            "FROM" => PluginDlteamsDeliverable_Content::getTable(),
            'ORDER' => 'timeline_position ASC',
            "deliverable_sections_id" => $sections_id
        ]);

    }

    public static function showAllDeliverableParagraph($sections_id)
    {
        $deliverable_contents = static::getDeliverableContents($sections_id);

        $ct = 0;
        foreach ($deliverable_contents as $index => $dc) {

            $isFirst = ($ct === 0);
            $isLast = ($ct === count($deliverable_contents) - 1);

            echo "<span id='bloc_{$dc['id']}' style='background-color: #dbdbdb; border-color: #87aa8a;' class='mt-2 timeline-content left card paragraph-bloc'>
                <div class='card-body'>
                    <div style='display: flex; justify-content: end; gap: 9px; align-items: center'>";


            if ($isFirst) {
                echo "<i class='fa fa-caret-down btn-moveparagraphdown'></i>";
            }

            if (!$isFirst) {
                echo "<i class='fa fa-caret-up btn-moveparagraphup'></i>";
            }

            if (!$isLast && !$isFirst) {
                echo "<i class='fa fa-caret-down btn-moveparagraphdown'></i>";
            }

            echo "<i class='fa fa-trash btn-remove-paragraph' id='remove_paragraph{$dc['id']}'></i>
              <i class='fa fa-arrows btn-moveparagraph' data-paragraph-id='{$dc['id']}'></i>
              </div>
              <div class='row flex-column bloc_content'>
                  <input type='hidden' name='id_field[]' value='{$dc['id']}'>
                  <h3><a href='#' id='title_{$dc['id']}' style='color: royalblue; text-decoration: underline;' class='paragraph-title'>{$dc['name']}</a></h3>
                  <p style='margin-bottom: 0px; display: flex; gap: 5px; align-items: center;' class='text-sm'>
                      <i class='fa fa-commenting'></i>
                      " . htmlspecialchars(substr($dc['comment'], 0, 20)) . "...
                  </p>
              </div>
          </div>
      </span>";
            $ct++;
        }
    }


    public function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {
        $nbdoc = $nbitem = 0;
        switch ($item->getType()) {
            case 'PluginDlteamsPolicieForm':
            case Document::class:
                global $DB;
                $allchapter = $DB->request(
                    [
                        'FROM' => PluginDlteamsDeliverable_Section::getTable(),
                        'WHERE'  => [
                            'items_id' => $item->fields["id"],
                            'itemtype' => $item->getType()
                        ],
                        'ORDER' => ['timeline_position DESC'],
                    ]);


                $ong = [];
                if ($allchapter) {
                    foreach ($allchapter as $index => $chapter) {

                        $ong[$index] = self::createTabEntry(_n(
                            $chapter['tab_name'],
                            $chapter['tab_name'], // TODO: replace with plural name
                            Session::getPluralNumber()
                        ), $nbdoc);
                    }
                }

                return $ong;
        }
    }

    private static function isFirstTab($tabnum, CommonGLPI $item)
    {
        global $DB;
        $allchapter = $DB->request(
            [
                'FROM' => PluginDlteamsDeliverable_Section::getTable(),
                'WHERE'  => [
                    'items_id' => $item->fields["id"],
                    'itemtype' => $item->getType()
                ],
                'ORDER' => ['timeline_position DESC'],
            ]);

        $position = 0;
        foreach ($allchapter as $chapter) {
            if ($chapter["id"] == $tabnum && $position === 0)
                return true;

            $position++;
        }

        return false;
    }


    private static function isLastTab($tabnum, CommonGLPI $item)
    {
        global $DB;
        $allchapter = $DB->request(PluginDlteamsDeliverable_Section::getTable(), ['ORDER' => ['timeline_position DESC'], 'deliverables_id' => $item->fields["id"]]);

        $position = 0;
        foreach ($allchapter as $chapter) {
            if ($chapter["id"] == $tabnum && $position === 0)
                return true;

            $position++;
        }

        return false;
    }

    public static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {

        global $DB;
        $sections_id = $tabnum;

        $instID = $item->fields['id'];
        $itemtype = $item->getType();
        if (!$item->can($instID, READ)) {
            return false;
        }
        $canedit = $item->can($instID, UPDATE);
        $tab = new PluginDlteamsDeliverable_Section();
        $tab->getFromDB($tabnum);

        if ($canedit) {
            echo "<form method='post' id='form_bloc' action='" . Toolbox::getItemTypeFormURL(__CLASS__) . "'4>";
            echo "<input type='hidden' name='tabnum' value='" . $tabnum . "' />";
            echo "<input type='hidden' name='items_id' value='" . $instID . "' />";
            echo "<input type='hidden' name='itemtype' value='" . $itemtype . "' />";
            echo "<input type='hidden' name='deliverables_sections_id' value='" . $tabnum . "' />";
            echo "<div style='display: flex; gap: 5px; align-items: center'>";
            if (!static::isFirstTab($tabnum, $item)) {
                echo "<input type='submit' class='submit' name='moveup_tab' value='" . __("Monter", 'dlteams') . "' />";
            }
            if (!static::isLastTab($tabnum, $item)) {
                echo "<input type='submit' class='submit' name='movedown_tab' value='" . __("Descendre", 'dlteams') . "' />";
            }
//            echo "<input type='submit' class='submit' name='delete_tab' value='" . __("Supprimer", 'dlteams') . "' />";


            echo "<div style='padding: 4px; background-color: #cbcbcb; border-radius: 5px; display: flex; gap: 4px;'>";
            echo "<input type='text' placeholder='Nom de l\'onglet' class='formcontrol' name='tabname' value='" . $tab->fields["tab_name"] . "' />";
            echo "<input type='submit' class='submit' name='rename_tab' value='" . __("Renommer", 'dlteams') . "' />";
            echo "</div>";

            echo "<button type='submit' style='background-color: transparent; border: none' name='delete_tab'><i style='color: red' class='fa fa-trash'></i></button>";

            echo "<input type='button' class='submit addparagraphe_btn' name='addparagraphe_btn_$sections_id'  value='" . __("Ajouter paragraphe", 'dlteams') . "' />";
//            if ($item->fields["links_id"]) {
//            $link = new Link();
//
//            $link->getFromDB($item->fields["links_id"]);
////                $folder_link = $link->fields["link"];
//            $url = Toolbox::getItemTypeFormURL("PluginDlteamsDeliverable")
//                ."?deliverable_id=".$item->fields["id"]."&report_type="
//                .PluginDlteamsPublish::REPORT_SINGLE_RECORD
//                ."&print_comments=true"
//                ."&prevent_contextmenu=true"
//                ."&print_first_page=true"
//                ."&edit_pdf=true";
//            echo "<div> <a class='btn btn-outline-secondary' style='display: block' target='_blank' href='" . $url . "' id='btn_publication_folder'><i class='fa fa-eye'></i></a> </div>";
//            }
            echo "</div>";


            echo "<div class='col-12 col-sm content-block' style='margin-bottom: 125px;'>
            
            <span style='background-color: #f2f0e2; border-color: #aa9d87;' class='mt-2 timeline-content left card'>
               <div class='card-body'>
                    <input type='hidden' name='id_field[]' value=''>
                    <div class='row flex-column'>
                        <div class='form-field col-12  mb-2'>
                           <label class='col-form-label ' for='name_567414212'>
                              Titre
                           </label>
                           <div class='field-container'>
                               <input type='text' class='form-control ' name='name[]' value='" . htmlspecialchars($tab->fields["name"]??"") . "' maxlength='255'>
                           </div>
                       </div>
                       
                       <div class='form-field col-12 col-12 itil-textarea-content mb-2'>
                           <label class='col-form-label'>
                              Commentaire
                           </label>
                    
                          <div class='field-container'>
                               <textarea class='form-control' name='comment[]' rows='3' style='width: 100%;' aria-hidden='true'>" . $tab->fields["comment"] . "</textarea>
                          </div>         
                       </div>

                       <div class='form-field col-12 col-12 itil-textarea-content mb-2'>
                           <label class='col-form-label'>
                              Introduction
                           </label>
                    
                          <div class='field-container'>";
            Html::textarea(['name' => 'content[]',
                'value' => $tab->fields["content"], //\Glpi\RichText\RichText::getSafeHtml($this->fields['content'], true),
                'enable_fileupload' => false,
                'enable_richtext' => true,
                'cols' => 100,
                'rows' => 100
            ]);
//                               <textarea class='form-control' name='content[]' rows='3' style='width: 100%;' aria-hidden='true'>" . $tab->fields["content"] . "</textarea>
            echo "</div>         
                       </div>
                       
                       
                       <div style='display: flex; justify-content: end'>
                        <button style='background-color: transparent; border: none' type='submit'  name='save_section'><i class='fa fa-save fa-2x'></i></button>
                       </div>
                       
                    </div>
               </div>
            </span>
            
            <div style='display: flex; flex-direction: column; gap: 7px;' class='sortable' id='document_bloc'>";


            static::showAllDeliverableParagraph($sections_id);

            echo "</div>    
           <div style='background-color: white; box-shadow: #0a0a0a; padding: 20px; position: fixed; bottom: 0; width: 100%; display: flex; gap: 10px;'> 
            
           
            <input type='button' class='submit addparagraphe_btn' name='addparagraphe_btn_$sections_id' value='" . __("Ajouter un paragraphe", 'dlteams') . "' />
           </div>

         </div>
        ";

            Html::closeForm();


            echo '
<style>
    .highlight {
        border: 1px solid red;
        font-weight: bold;
        font-size: 45px;
        background-color: #333333;
    }
    .btn-remove-paragraph,
    .btn-moveparagraph,
    .btn-moveparagraphdown,
    .btn-moveparagraphup {
        cursor: pointer;
    }
</style>

<script type="text/javascript">

$(document).ready(function () {
    const observer = new MutationObserver((mutations) => {

            function bindEvents() {
            $(".btn-moveparagraphup").off("click").on("click", function () {
                var parentElement = $(this).closest(".paragraph-bloc");
                var previousElement = parentElement.prev(".paragraph-bloc");

                if (previousElement.length > 0) {
                    let formArray = $("#form_bloc").serializeArray();
                    const idx = formArray.filter(x => x.name === "id_field[]" && x.value).map(x => x.value);
                    const parentId = parentElement.attr("id").replace("bloc_", "");
                    const data = {
                        idx,
                        tomove_id: parentId,
                        direction: "up",
                    };

                    $.ajax({
                        url: "/marketplace/dlteams/ajax/move_deliverable_paragraph.php",
                        type: "POST",
                        data,
                        success: function () {
                            parentElement.animate({ top: -previousElement.outerHeight() }, 300);
                            previousElement.animate({ top: parentElement.outerHeight() }, 300, function () {
                                parentElement.insertBefore(previousElement);
                                parentElement.css("top", "");
                                previousElement.css("top", "");
                            });
                        },
                        error: function () {
                            alert("Une erreur est survenue lors du déplacement. Veuillez réessayer.");
                        }
                    });
                }
            });

            $(".btn-moveparagraphdown").off("click").on("click", function () {
                var parentElement = $(this).closest(".paragraph-bloc");
                var nextElement = parentElement.next(".paragraph-bloc");

                if (nextElement.length > 0) {
                    let formArray = $("#form_bloc").serializeArray();
                    const idx = formArray.filter(x => x.name === "id_field[]" && x.value).map(x => x.value);
                    const parentId = parentElement.attr("id").replace("bloc_", "");
                    const data = {
                        idx,
                        tomove_id: parentId,
                        direction: "down",
                    };

                    $.ajax({
                        url: "/marketplace/dlteams/ajax/move_deliverable_paragraph.php",
                        type: "POST",
                        data,
                        success: function () {
                            parentElement.animate({ top: nextElement.outerHeight() }, 300);
                            nextElement.animate({ top: -parentElement.outerHeight() }, 300, function () {
                                parentElement.insertAfter(nextElement);
                                parentElement.css("top", "");
                                nextElement.css("top", "");
                            });
                        },
                        error: function () {
                            alert("Une erreur est survenue lors du déplacement. Veuillez réessayer.");
                        }
                    });
                }
            });

            $(".btn-remove-paragraph").off("click").click(function () {
                var selector_remove_paragraph = $(this).attr("id");
                var id = selector_remove_paragraph.replace("remove_paragraph", "");
                var bloc_selector = "#bloc_" + id;

                if (window.confirm("Êtes-vous sûr de retirer ce paragraphe ?")) {
                    $.ajax({
                        url: "/marketplace/dlteams/ajax/remove_deliverable_paragraph.php?content_id=" + id,
                        type: "GET",
                        success: function (html) {
                            $("#document_bloc").html(html);
                        }
                    });
                }
            });

            $(".addparagraphe_btn").off("click").on("click", function (event) {
                event.preventDefault();
                const section_id = $(this).attr("name").replace("addparagraphe_btn_", "");
                $.ajax({
                    url: "/marketplace/dlteams/ajax/add_deliverable_paragraph.php?section_id=" + section_id,
                    type: "GET",
                    success: function (html) {
                        $("#document_bloc").html(html);
                        $("html, body").animate({ scrollTop: $(document).height() }, 1000);
                    }
                });
            });
            
            $(".btn-moveparagraph").off("click").on("click", function () {
                const paragraphId = $(this).data("paragraph-id");
                const data = {
                    paragraphId,
                    direction: "to_chapter"
                };

                // Requête AJAX pour valider le déplacement côté serveur
                glpi_ajax_dialog({
                    dialogclass: "modal-xl",
                    bs_focus: false,
                    url: "/marketplace/dlteams/ajax/move_deliverable_paragraph.php",
                    params: {
                        ...data,
                    },
                    title: i18n.textdomain("dlteams").__("Déplacement du paragraphe", "dlteams"),
                    close: function () {

                    },
                    fail: function () {
                        displayAjaxMessageAfterRedirect();
                    }
                });

               
            });


            $(".paragraph-title").off("click").click(function (event) {
                event.preventDefault();
                var content_id = $(this).attr("id").replace("title_", "");
                glpi_ajax_dialog({
                    dialogclass: "modal-xl",
                    bs_focus: false,
                    url: "/marketplace/dlteams/ajax/get_deliverable_paragraph_content.php",
                    params: {
                        content_id,
                    },
                    title: i18n.textdomain("dlteams").__("Edit paragraph", "dlteams"),
                    close: function () {},
                    fail: function () {
                        displayAjaxMessageAfterRedirect();
                    }
                });
            });
        }

        bindEvents();

    });

    const config = {
            childList: true,
            attributes: true,
            subtree: true // Observer les mutations sur des descendants également
        };


        observer.observe(document.body, config);
    
});

</script>


';

        }

        return parent::displayTabContentForItem($item, $tabnum, $withtemplate); // TODO: Change the autogenerated stub
    }

    public static function showMassiveActionsSubForm(MassiveAction $ma)
    {
        return parent::showMassiveActionsSubForm($ma); // TODO: Change the autogenerated stub
    }

    public static function processMassiveActionsForOneItemtype(MassiveAction $ma, CommonDBTM $item, array $ids)
    {
        parent::processMassiveActionsForOneItemtype($ma, $item, $ids); // TODO: Change the autogenerated stub
    }

    public function prepareTabContentForm()
    {

    }
}


