<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

class PluginDlteamsPolicieForm_TransmissionMethods extends CommonDBTM
{

    static public $itemtype_1 = 'PluginDlteamsPolicieForm';
    static public $items_id_1 = 'policieforms_id';
//    static public $itemtype_2 = 'PluginDlteamsConcernedPerson';
//    static public $items_id_2 = 'plugin_dlteams_concernedpersons_id';
    static public $column1_id = '49'; // for dlteams massiveupdate purpose
    static public $column2_id = '42'; // for dlteams massiveupdate purpose
    static public $column3_id = '39'; // for dlteams massiveupdate purpose

    static function canCreate()
    {
        return true;
    }

    static function canView()
    {
        return true;
    }

    static function canUpdate()
    {
        return true;
    }

    static function canDelete()
    {
        return true;
    }

    static function canPurge()
    {
        return true;
    }

    public static function showForPolicieForm(CommonGLPI $item, mixed $withtemplate) {
        $rand = mt_rand();

        // Styles globaux
        echo "<style>
        .form-element {
            display: flex;
            flex-direction: column;
            gap: 1em;
        }
        .input-field select {
            width: 100%;
        }
        @media (max-width: 768px) {
            .form-element {
                font-size: 16px;
            }
            .input-field select {
                height: 40px;
            }
        }
    </style>";

        echo "<div class='firstbloc'>";
        echo "<form name='ticketitem_form{$rand}' id='ticketitem_form{$rand}' method='post' action='"
            . Toolbox::getItemTypeFormURL(__CLASS__) . "'>";

        // Champ caché ID
        echo Html::hidden('id', ['value' => $item->fields['id']]);

        //
        // 1) Méthode de transmission
        //
        echo "<table class='tab_cadre_fixe'>";
        echo "  <tr>";
        echo "    <th colspan='3'>" . __('Méthode de transmission', 'dlteams') . "</th>";
        echo "  </tr>";
        echo "  <tr>";
        echo "    <td class='form-element'>";
        echo        __('Quel canal ou méthode de collecte ?', 'dlteams');
        echo "      <div class='input-field'>";
        global $DB;
        $iterator = $DB->request([
            "FROM"   => PluginDlteamsTransmissionMethod::getTable(),
            "SELECT" => ["name", "id"]
        ]);
        $list = [];
        foreach ($iterator as $data) {
            $list[$data['id']] = $data['name'];
        }
        Dropdown::showFromArray(
            "transmission_methods",
            $list,
            [
                'values'   => json_decode($item->fields["transmissionmethod"] ?? '[]', true),
                'multiple' => true,
                'rand'     => $rand,
                'width'    => '100%',
            ]
        );
        echo "      </div>";
        echo "      <div class='input-field'>";
        echo "        <label for='transmission_comment'>" . __('Commentaire', 'dlteams') . "</label>";
        echo "        <input type='text' name='transmission_comment' id='transmission_comment'"
            . " value='" . Html::cleanInputText($item->fields['transmission_comment'] ?? '') . "'"
            . " style='width:100%' />";
        echo "      </div>";
        echo "    </td>";
        echo "  </tr>";
        echo "  <tr>";
        echo "    <td colspan='3'>";
        echo "      <input type='submit' name='update_transmission'"
            . " value=\"" . _sx('button', 'Save') . "\" class='submit' style='margin-top:5px;' />";
        echo "    </td>";
        echo "  </tr>";
        echo "</table>";

        //
        // 2) Supports, médias de collecte
        //
        echo "<table class='tab_cadre_fixe' style='margin-top:20px;'>";
        echo "  <tr>";
        echo "    <th colspan='3'>" . __("Supports, médias de collecte", 'dlteams') . "</th>";
        echo "  </tr>";
        echo "  <tr>";
        echo "    <td class='form-element'>";
        echo        __('Y a-t-il un média ou support transmis ?', 'dlteams');
        echo "      <div class='input-field'>";
        $iterator = $DB->request([
            "FROM"   => PluginDlteamsMediaSupport::getTable(),
            "SELECT" => ["name", "id"]
        ]);
        $list = [];
        foreach ($iterator as $data) {
            $list[$data['id']] = $data['name'];
        }
        Dropdown::showFromArray(
            "support_methods",
            $list,
            [
                'values'   => json_decode($item->fields["mediasupport"] ?? '[]', true),
                'multiple' => true,
                'rand'     => $rand,
                'width'    => '100%',
            ]
        );
        echo "      </div>";
        echo "      <div class='input-field'>";
        echo "        <label for='support_comment'>" . __('Commentaire', 'dlteams') . "</label>";
        echo "        <input type='text' name='support_comment' id='support_comment'"
            . " value='" . Html::cleanInputText($item->fields['support_comment'] ?? '') . "'"
            . " style='width:100%' />";
        echo "      </div>";
        echo "    </td>";
        echo "  </tr>";
        echo "  <tr>";
        echo "    <td colspan='3'>";
        echo "      <input type='submit' name='update_support'"
            . " value=\"" . _sx('button', 'Save') . "\" class='submit' style='margin-top:5px;' />";
        echo "    </td>";
        echo "  </tr>";
        echo "</table>";

        //
        // 3) Intégration au SI
        //
        echo "<table class='tab_cadre_fixe' style='margin-top:20px;'>";
        echo "  <tr>";
        echo "    <th colspan='3'>" . __("Intégration au SI", 'dlteams') . "</th>";
        echo "  </tr>";
        echo "  <tr>";
        echo "    <td class='form-element'>";
        echo        __('Mode d\'enregistrement des données collectées', 'dlteams');
        echo "      <div class='input-field'>";
        $iterator = $DB->request([
            "FROM"   => PluginDlteamsSIIntegration::getTable(),
            "SELECT" => ["name", "id"]
        ]);
        $list = [];
        foreach ($iterator as $data) {
            $list[$data['id']] = $data['name'];
        }
        Dropdown::showFromArray(
            "si_integration",
            $list,
            [
                'values'   => json_decode($item->fields["siintegration"] ?? '[]', true),
                'multiple' => true,
                'rand'     => $rand,
                'width'    => '100%',
            ]
        );
        echo "      </div>";
        echo "      <div class='input-field'>";
        echo "        <label for='integration_comment'>" . __('Commentaire', 'dlteams') . "</label>";
        echo "        <input type='text' name='integration_comment' id='integration_comment'"
            . " value='" . Html::cleanInputText($item->fields['integration_comment'] ?? '') . "'"
            . " style='width:100%' />";
        echo "      </div>";
        echo "    </td>";
        echo "  </tr>";
        echo "  <tr>";
        echo "    <td colspan='3'>";
        echo "      <input type='submit' name='update_integration'"
            . " value=\"" . _sx('button', 'Save') . "\" class='submit' style='margin-top:5px;' />";
        echo "    </td>";
        echo "  </tr>";
        echo "</table>";

        // Fermeture du formulaire
        Html::closeForm();
        echo "</div>";  // .firstbloc
    }



    public function canEdit($ID)
    {
        return true;
    }

    function canCreateItem()
    {
        return true;
    }

    function canViewItem()
    {
        return true;
    }

    function canUpdateItem()
    {
        return true;
    }

    function canDeleteItem()
    {
        return true;
    }

    function canPurgeItem()
    {
        return true;
    }


    static function getTypeName($nb = 0)
    {
        return __("Methodes de transmission", 'dlteams');
    }


    function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {
        if (!$item->canView()) {
            return false;
        }

        switch ($item->getType()) {
            case PluginDlteamsPolicieForm::class :

                $nb = 0;

                if ($_SESSION['glpishow_count_on_tabs']) {
                    $nb = 0;
                }
                return self::createTabEntry(static::getTypeName($nb), "$nb");
        }

        return '';
    }

    static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {

        switch ($item->getType()) {
            case PluginDlteamsPolicieForm::class :
                self::showForPolicieForm($item, $withtemplate);
//                $item->ShowDatacarrierType($item->fields["id"]);
                break;
        }

        return true;
    }


}