<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

use GlpiPlugin\dlteams\Exception\ImportFailureException;

class PluginDlteamsProcessedData extends CommonDropdown implements PluginDlteamsExportableInterface{
    use PluginDlteamsExportable;
    static $rightname = 'plugin_dlteams_processeddata';
    public static $menukey = "datagovernancedcp";
    public $dohistory = true;
    protected $usenotepad = true;
    const SEEALL = -1;

    use Glpi\Features\TreeBrowse;


    static function getTypeName($nb = 0)
    {
        return _n('Processed data', 'Processed datas', $nb, 'dlteams');
    }

    
    function showForm($id, $options = [])
    {
        global $CFG_GLPI;
        $this->initForm($id, $options);
        $this->showFormHeader($options);

        echo "<style>";
        echo "
            .form-table-text {
                text-align: right;
                width: 25%;
            }
            
            
            @media (max-width: 800px) {
                .form-table-text {
                    text-align: left;
                    width: 100%;
                }
            }
        ";

        echo "</style>";


        echo "<table, th, td width='100%'>";


//       echo "<tr>";
//        echo "<td class='form-table-text'>". __("Number (order)", 'dlteams') . "</td>";
//        echo "<td colspan='1'>";
//        $number = Html::cleanInputText($this->fields['number']);
//        echo "<input type='number' min='1' max='9999' name='number' size='8' value='" . $number . "'>";
//        echo "</td>";
//        echo "<td width='30%' style='text-align:right'>". " " . "</td>";
//        echo "</tr>" ;


        echo "<tr>";
//		echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "<td class='form-table-text' >" . __("Name", 'dlteams') . "</td>";
        echo "<td>";
        $name = Html::cleanInputText($this->fields['name']);
        echo "<input type='text' style='width:98%' name='name' required value='" . $name . "'>" . "</td>";
        echo "<td width='15%' style='text-align:right'>" . " " . "</td>";
        echo "</tr>";


        echo "<tr class='tab_bg_1'>";
        echo "<td class='form-table-text'>" . PluginDlteamsProcessedDataCategory::getTypeName(Session::getPluralNumber()) . "</td>";
        echo "<td>";
        echo Html::input("__categories_defined", ["type" => "hidden", "value" => 1]);
        $rand = mt_rand();
        echo "<div style='display: flex; flex-direction: row; gap: 0px'>";
        PluginDlteamsProcessedDataCategory::dropdown([
            'name' => "_categories[]",
            'value' => $this->fields['_categories'] ?? [],
            'multiple' => true,
            'width' => "100%",
        ]);
        $comment_icon = "";
        $comment_id = Html::cleanId("comment_" . "_categories[]" . $rand);
        $link_id = Html::cleanId("comment_link_" . "_categories[]" . $rand);

        $comment_icon .= Html::showToolTip("Montrer " . PluginDlteamsProcessedDataCategory::getTypeName(), [
            "link_class" => 'btn btn-outline-secondary',
            'contentid' => $comment_id,
            'linkid' => $link_id,
            'addicon' => false,
            'display' => false,
            'link' => PluginDlteamsProcessedDataCategory::getSearchURL()
        ]);

        echo $comment_icon;
        echo "</div>";

        echo "</td>";
        echo "</tr>\n";


        echo "<tr>";
//	  echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "<td class='form-table-text'>" . __("GDPR Sensitive", 'dlteams') . "</td>";
        echo "<td>";
        Dropdown::showYesNo("rgpd_sensitive_data", $this->fields['rgpd_sensitive_data']);
        echo "</td></tr>";

        echo "<tr>";
//	  echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "<td class='form-table-text'>" . __("Seen sensitive data", 'dlteams') . "</td>";
        echo "<td>";
        Dropdown::showYesNo("seen_sensitive_data", $this->fields['seen_sensitive_data']);
        echo "</td></tr>";

        echo "<tr>";
//      echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "<td class='form-table-text'>" . __("Content", 'dlteams') . "</td>";
        echo "<td>";
        $content = Html::cleanInputText($this->fields['content']);
        echo "<textarea style='width: 98%;' name='content' rows='3'>" . $content . "</textarea>";
        echo "</td></tr>";


        echo "<tr>";
//      echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "<td class='form-table-text'>" . __("Comments") . "</td>";
        echo "<td>";
        $comment = Html::cleanInputText($this->fields['comment']);
        echo "<textarea style='width: 98%;' name='comment' rows='3'>" . $comment . "</textarea>";
        echo "</td></tr>";
        echo "</table>";

        $options["withtemplate"] = "";
        $this->showFormButtons($options);


        echo "<script>
            document.querySelector('button[name=purge]').removeAttribute('onclick');

            $(document).off('click').on('click', 'button[name=purge]', function (e) {
                console.log($('input[name=id]').val());
                e.preventDefault();
//                
                glpi_ajax_dialog({
                dialogclass: 'modal-lg',
                bs_focus: false,
                url: '/marketplace/dlteams/ajax/confirm_purge_relations.php',
                params: { itemtype: 'PluginDlteamsProcessedData', items_id: $('input[name=id]').val() },
                title: i18n.textdomain('dlteams').__('Confirmation', 'dlteams'),
                close: function () {},
                fail: function () {
                    displayAjaxMessageAfterRedirect();
                }
            });
            });

        </script>";
        return true;
    }

    /**
     * Sauvegarde les catégories dans les tables _Item
     */
    public function saveCategoriesToItemTables($categories = [])
    {
        global $DB;

        if (empty($categories)) {
            $categories = $_POST['_categories'] ?? [];
        }

        // 1. Supprimer les anciennes relations
        $this->deleteCategoriesFromItemTables();

        if (empty($categories)) {
            return;
        }

        //2 +  3. Insérer dans PluginDlteamsProcessedData_Item puis PluginDlteamsProcessedDataCategory_Item pour chaque catégorie
        foreach ($categories as $category_id) {

            $processeddata_item = new PluginDlteamsProcessedData_Item();
            $processeddata_item->add([
                'processeddatas_id' => $this->getID(),
                'itemtype' => PluginDlteamsProcessedDataCategory::class,
                'items_id' => $category_id,
            ]);


            $category_item = new PluginDlteamsProcessedDataCategory_Item();
            $category_item->add([
                'processeddatacategories_id' => $category_id,
                'itemtype' => PluginDlteamsProcessedData::class,
                'items_id' => $this->getID()
            ]);
        }
    }

    /**
     * Supprime les catégories des tables _Item
     */
    public function deleteCategoriesFromItemTables()
    {
        global $DB;

        // 1. Supprimer les relations dans ProcessedDataCategory_Item
            $DB->delete(PluginDlteamsProcessedDataCategory_Item::getTable(), [
                'itemtype' => PluginDlteamsProcessedData::class,
                'items_id' => $this->getID()
            ]);

        // 2. Supprimer les ProcessedData_Item
        $DB->delete(PluginDlteamsProcessedData_Item::getTable(), [
            'processeddatas_id' => $this->getID(),
            'itemtype' => PluginDlteamsProcessedDataCategory::class
        ]);
    }

    /**
     * Charge les catégories depuis les tables _Item
     */
    public function loadCategoriesFromItemTables()
    {
        global $DB;

        // 1. Récupérer les ProcessedData_Item liés
        $processeddata_items = $DB->request([
            'SELECT' => ['items_id'],
            'FROM' => PluginDlteamsProcessedData_Item::getTable(),
            'WHERE' => [
                'processeddatas_id' => $this->getID(),
                'itemtype' => PluginDlteamsProcessedDataCategory::class
            ]
        ]);

        $processeddata_categories_ids = [];
        foreach ($processeddata_items as $item) {
            $processeddata_categories_ids[] = $item['items_id'];
        }

        if (empty($processeddata_categories_ids)) {
            $this->fields['_categories'] = [];
            return;
        }

        $category_ids = [];
        foreach ($processeddata_categories_ids as $category_id) {
            $category_ids[] = $category_id;
        }

        $this->fields['_categories'] = $category_ids;
    }

    /**
     * Remplace post_addItem()
     */
    public function post_addItem()
    {
        $this->saveCategoriesToItemTables();
        parent::post_addItem();
    }

    /**
     * Remplace post_updateItem()
     */
    public function post_updateItem($history = true)
    {
        $this->saveCategoriesToItemTables();
        parent::post_updateItem($history);
    }

    /**
     * Remplace post_getFromDB()
     */
    public function post_getFromDB()
    {
        $this->loadCategoriesFromItemTables();
        parent::post_getFromDB();
    }




    /**
     * Show the knowbase browse view
     **/
    public static function showBrowseView(string $itemtype, array $params, $update = false)
    {
        /** @var array $CFG_GLPI */
        global $CFG_GLPI;

        $rand = mt_rand();
        $ajax_url = $CFG_GLPI["root_doc"] . "/marketplace/dlteams/ajax/processeddata.php";
        $loading_txt = __s('Loading...');
        $start = (int)($_REQUEST['start'] ?? 0);
        $cat_id = (int)($_GET["processeddatacategories_id"] ?? $_SESSION['processeddata_cat_id'] ?? 0);

//        $ajax_url    = $CFG_GLPI["root_doc"] . "/ajax/treebrowse.php";
        $loading_txt = __s('Loading...');
        $start = (int)($_REQUEST['start'] ?? 0);
        $browse = (int)($_REQUEST['browse'] ?? 0);
        $is_deleted = (int)($_REQUEST['is_deleted'] ?? 0);
        $criteria = json_encode($params['criteria']);
        $sort = json_encode($_REQUEST['sort'] ?? []);
        $order = json_encode($_REQUEST['order'] ?? []);

        $category_list = json_encode(self::getTreeCategoryList());
//        var_dump(count($category_list));
        /*        highlight_string("<?php\n\$data =\n" . var_export($category_list, true) . ";\n?>");*/
//        die();
        $no_cat_found = __s("No category found");

        $JS = <<<JAVASCRIPT
         $(function() {
            var loadingindicator  = $("<div class='loadingindicator'>$loading_txt</div>");
            $('#items_list$rand').html(loadingindicator); // loadingindicator on doc ready
            var loadNode = function(cat_id) {
               $('#items_list$rand').html(loadingindicator);
               $('#items_list$rand').load('$ajax_url', {
                'action': 'getItemslist',
                'cat_id': cat_id,
                'itemtype': '$itemtype',
                'start': $start,
                'browse': $browse,
                'is_deleted': $is_deleted,
                'criteria': $criteria,
                'sort': $sort,
                'order': $order,
               });
            };

            $('#tree_category$rand').fancytree({
               // load plugins
               extensions: ['filter', 'glyph', 'persist'],

               persist: {
                  cookiePrefix: 'fancytree-kb-',
                  expandLazy: true,
                  overrideSource: true,
                  store: "auto"
               },

               // Scroll node into visible area, when focused by keyboard
               autoScroll: true,

               // enable font-awesome icons
               glyph: {
                  preset: "awesome5",
                  map: {}
               },

               // load json data
               source: {$category_list},

               // filter plugin options
               filter: {
                  mode: "hide", // remove unmatched nodes
                  autoExpand: true, // if results found in children, auto-expand parent
                  nodata: '{$no_cat_found}', // message when no data found
               },

               // events
               activate: function(event, data) {
                  var node = data.node;
                  var key  = node.key;

                  loadNode(key);
               },

            });

            loadNode($cat_id);
            $.ui.fancytree.getTree("#tree_category$rand").activateKey($cat_id);

            $(document).on('keyup', '#browser_tree_search$rand', function() {
               var search_text = $(this).val();
               $.ui.fancytree.getTree("#tree_category$rand").filterNodes(search_text);
            });
         });
JAVASCRIPT;
        echo Html::scriptBlock($JS);
        echo "<div id='tree_browse'>
         <div class='browser_tree'>
            <input type='text' class='browser_tree_search' id='browser_tree_search$rand'>
            <div id='tree_category$rand'></div>
         </div>
         <div id='items_list$rand' class='browser_items'></div>
      </div>";
    }


//    public static function showBrowseView(string $itemtype, array $params, $update = false)
//    {
//        /** @var array $CFG_GLPI */
//        global $CFG_GLPI;
//
//        $ajax_url    = $CFG_GLPI["root_doc"] . "/ajax/treebrowse.php";
//        $loading_txt = __s('Loading...');
//        $start       = (int)($_REQUEST['start'] ?? 0);
//        $browse      = (int)($_REQUEST['browse'] ?? 0);
//        $is_deleted  = (int)($_REQUEST['is_deleted'] ?? 0);
//        $criteria    = json_encode($params['criteria']);
//        $sort        = json_encode($_REQUEST['sort'] ?? []);
//        $order       = json_encode($_REQUEST['order'] ?? []);
//
//        $category_list = json_encode(self::getTreeCategoryList());
//        $no_cat_found  = __s("No category found");
//
//        $JS = <<<JAVASCRIPT
//        var loadingindicator  = $("<div class='loadingindicator'>$loading_txt</div>");
//        $('#items_list').html(loadingindicator);
//        window.loadNode = function(cat_id) {
//            $('#items_list').html(loadingindicator);
//            $('#items_list').load('$ajax_url', {
//                'action': 'getItemslist',
//                'cat_id': cat_id,
//                'itemtype': '$itemtype',
//                'start': $start,
//                'browse': $browse,
//                'is_deleted': $is_deleted,
//                'criteria': $criteria,
//                'sort': $sort,
//                'order': $order,
//            });
//        };
//JAVASCRIPT;
//
//        if ($update) {
//            $JS .= <<<JAVASCRIPT
//            $('#tree_category').fancytree('option', 'source', {$category_list});
//JAVASCRIPT;
//
//            $params['criteria'][] = $_SESSION['treebrowse'][$itemtype];
//            $results = Search::getDatas($itemtype, $params);
//            $results['searchform_id'] = $params['searchform_id'] ?? null;
//            Search::displayData($results);
//        } else {
//            $JS .= <<<JAVASCRIPT
//            $(function() {
//                $('#tree_category').fancytree({
//                    // load plugins
//                    extensions: ['filter', 'glyph', 'persist'],
//
//                    // Scroll node into visible area, when focused by keyboard
//                    autoScroll: true,
//
//                    // enable font-awesome icons
//                    glyph: {
//                        preset: "awesome5",
//                        map: {}
//                    },
//
//                    persist: {
//                        cookiePrefix: '$itemtype',
//                        expandLazy: true,
//                        overrideSource: true,
//                        store: "auto"
//                    },
//
//                    // load json data
//                    source: {$category_list},
//
//                    // filter plugin options
//                    filter: {
//                        mode: "hide", // remove unmatched nodes
//                        autoExpand: true, // if results found in children, auto-expand parent
//                        nodata: '{$no_cat_found}', // message when no data found
//                    },
//
//                    // events
//                    activate: function(event, data) {
//                        var node = data.node;
//                        var key  = node.key;
//
//                        window.loadNode(key);
//                    },
//
//                });
//
//                var tree = $.ui.fancytree.getTree("#tree_category")
//                if (tree.activeNode === null) {
//                    tree.activateKey(-1);
//                }
//                $(document).on('keyup', '#browser_tree_search', function() {
//                    var search_text = $(this).val();
//                    $.ui.fancytree.getTree("#tree_category").filterNodes(search_text);
//                });
//            });
//
//JAVASCRIPT;
//            echo "<div id='tree_browse'>
//            <div class='browser_tree d-flex flex-column'>
//                <input type='text' class='browser_tree_search' placeholder='" . __s("Search…") . "' id='browser_tree_search'>
//                <div id='tree_category' class='browser-tree-container'></div>
//            </div>
//            <div id='items_list' class='browser_items'></div>
//            </div>";
//        }
//        echo Html::scriptBlock($JS);
//    }

    /**
     * Get list of knowbase categories in fancytree format.
     *
     * @return array
     * @since 9.4
     *
     */
    public static function getTreeCategoryList()
    {

        /** @var \DBmysql $DB */
        global $DB;

        $cat_table = PluginDlteamsProcessedDataCategory::getTable();
        $cat_fk = PluginDlteamsProcessedDataCategory::getForeignKeyField();

//        $kbitem_visibility_crit = KnowbaseItem::getVisibilityCriteria(true);

        $items_subquery = new QuerySubQuery(
            array_merge_recursive(
                [
                    'SELECT' => ['COUNT DISTINCT' => PluginDlteamsProcessedData::getTableField('id') . ' as cpt'],
                    'FROM' => PluginDlteamsProcessedData::getTable(),
                    'INNER JOIN' => [
                        PluginDlteamsProcesseddata_ProcesseddataCategory::getTable() => [
                            'ON' => [
                                PluginDlteamsProcesseddata_ProcesseddataCategory::getTable() => PluginDlteamsProcessedData::getForeignKeyField(),
                                PluginDlteamsProcessedData::getTable() => 'id'
                            ]
                        ]
                    ],
                    'WHERE' => [
                        PluginDlteamsProcesseddata_ProcesseddataCategory::getTableField($cat_fk) => new QueryExpression(
                            $DB->quoteName(PluginDlteamsProcessedDataCategory::getTableField('id'))
                        ),
                    ]
                ], []
//                $kbitem_visibility_crit
            ),
            'items_count'
        );

        $cat_iterator = $DB->request([
            'SELECT' => [
                PluginDlteamsProcessedDataCategory::getTableField('id'),
                PluginDlteamsProcessedDataCategory::getTableField('name'),
                PluginDlteamsProcessedDataCategory::getTableField($cat_fk),
                $items_subquery,
            ],
            'FROM' => $cat_table,
            'ORDER' => [
//                PluginDlteamsProcessedDataCategory::getTableField('level') . ' DESC',
                PluginDlteamsProcessedDataCategory::getTableField('name'),
            ]
        ]);

        $inst = new PluginDlteamsProcessedDataCategory();
        $categories = [];
        foreach ($cat_iterator as $category) {
            if (DropdownTranslation::canBeTranslated($inst)) {
                $tname = DropdownTranslation::getTranslatedValue(
                    $category['id'],
                    $inst->getType()
                );
                if (!empty($tname)) {
                    $category['name'] = $tname;
                }
            }
            $categories[] = $category;
        }
        // Remove categories that have no items and no children
        // Requires category list to be sorted by level DESC
        foreach ($categories as $index => $category) {
            $children = array_filter(
                $categories,
                function ($element) use ($category, $cat_fk) {
                    return $category['id'] == $element[$cat_fk];
                }
            );

            if (empty($children) && 0 == $category['items_count']) {
                unset($categories[$index]);
            }
        }

        // Add root category (which is not a real category)
        $root_items_count = $DB->request(
            array_merge_recursive(
                [
                    'SELECT' => ['COUNT DISTINCT' => PluginDlteamsProcessedData::getTableField('id') . ' as cpt'],
                    'FROM' => PluginDlteamsProcessedData::getTable(),
                    'LEFT JOIN' => [
                        PluginDlteamsProcesseddata_ProcesseddataCategory::getTable() => [
                            'ON' => [
                                PluginDlteamsProcesseddata_ProcesseddataCategory::getTable() => PluginDlteamsProcessedData::getForeignKeyField(),
                                PluginDlteamsProcessedData::getTable() => 'id'
                            ]
                        ],
                        PluginDlteamsProcessedDataCategory::getTable() => [
                            'ON' => [
                                PluginDlteamsProcesseddata_ProcesseddataCategory::getTable() => PluginDlteamsProcessedDataCategory::getForeignKeyField(),
                                PluginDlteamsProcessedDataCategory::getTable() => 'id'
                            ]
                        ]
                    ],
                    'WHERE' => [
                        PluginDlteamsProcessedDataCategory::getTableField('id') => null,
                        PluginDlteamsProcessedData::getTableField('entities_id') => Session::getActiveEntity(),
                    ]
                ], []
//                $kbitem_visibility_crit
            )
        )->current();
        $categories[] = [
            'id' => 0,
            'name' => __s('Root category'),
            'items_count' => $root_items_count['cpt'],
        ];

        // construct flat data
        $nodes = [];
        foreach ($categories as $category) {
            $cat_id = intval($category['id']);
            $node = [
                'key' => $cat_id,
                'title' => $category['name'],
                'parent' => null,
                'a_attr' => [
                    'data-id' => $cat_id
                ],
            ];

            if ($category['items_count'] > 0) {
                $node['title'] .= ' <span class="badge bg-azure-lt" title="' . __s('This category contains processed datas') . '">'
                    . $category['items_count']
                    . '</span>';
            }

            $nodes[] = $node;
        }

        // recursive construct tree data
        $buildtree = function (array &$elements, $parent = null) use (&$buildtree) {
            $branch = [];

            foreach ($elements as $index => $element) {
                if ($element['parent'] === $parent) {
                    $children = $buildtree($elements, $element['key']);
                    if (count($children) > 0) {
                        $element['children'] = $children;
                    }
                    $branch[] = $element;
                    unset($elements[$index]);
                }
            }
            return $branch;
        };

        $newtree = $buildtree($nodes);

        return $newtree;
    }


    /**
     * Print out list kb item
     *
     * @param $options $_GET
     * @param $type      string   search type : browse / search (default search)
     **/
    public static function showList($options, $type = 'search')
    {
        /** @var array $CFG_GLPI */
        global $CFG_GLPI;

        Search::showList(PluginDlteamsProcessedData::class, []);

//        $DBread = DBConnection::getReadConnection();
//
//        // Default values of parameters
//        $params['faq'] = !Session::haveRight(self::$rightname, READ);
//        $params["start"] = "0";
//        $params["processeddatacategories_id"] = null;
//        $params["contains"] = "";
//        $params["target"] = $_SERVER['PHP_SELF'];
//
//        if (is_array($options) && count($options)) {
//            foreach ($options as $key => $val) {
//                $params[$key] = $val;
//            }
//        }
//        $ki = new self();
//        switch ($type) {
//            case 'myunpublished':
//                if (!Session::haveRightsOr(self::$rightname, [UPDATE, self::PUBLISHFAQ])) {
//                    return false;
//                }
//                break;
//
//            case 'allunpublished':
//                if (!Session::haveRight(self::$rightname, self::KNOWBASEADMIN)) {
//                    return false;
//                }
//                break;
//
//            default:
//                break;
//        }

//        if (!$params["start"]) {
//            $params["start"] = 0;
//        }
//
//        $criteria = self::getListRequest($params, $type);
//
//        $main_iterator = $DBread->request($criteria);
//        $rows = count($main_iterator);
//        $numrows = $rows;
//
//        // Get it from database
//        $KbCategory = new KnowbaseItemCategory();
//        $title = "";
//        if ($KbCategory->getFromDB($params["knowbaseitemcategories_id"])) {
//            $title = (empty($KbCategory->fields['name']) ? "(" . $params['knowbaseitemcategories_id'] . ")"
//                : $KbCategory->fields['name']);
//            $title = sprintf(__('%1$s: %2$s'), _n('Category', 'Categories', 1), $title);
//        }
//
//        Session::initNavigateListItems('KnowbaseItem', $title);
//        // force using getSearchUrl on list icon (when viewing a single article)
//        $_SESSION['glpilisturl']['KnowbaseItem'] = '';
//
//        $list_limit = $_SESSION['glpilist_limit'];

//        $showwriter = in_array($type, ['myunpublished', 'allunpublished', 'allmy']);
//
//        // Limit the result, if no limit applies, use prior result
//        if (
//            ($rows > $list_limit)
//            && !isset($_GET['export_all'])
//        ) {
//            $criteria['START'] = (int)$params['start'];
//            $criteria['LIMIT'] = (int)$list_limit;
//            $main_iterator = $DBread->request($criteria);
//            $numrows = count($main_iterator);
//        }

//        if ($numrows > 0) {
//            // Set display type for export if define
//            $output_type = Search::HTML_OUTPUT;
//
//            if (isset($_GET["display_type"])) {
//                $output_type = $_GET["display_type"];
//            }
//
//            // Pager
//            $parameters = "start=" . $params["start"] . "&amp;knowbaseitemcategories_id=" .
//                $params['knowbaseitemcategories_id'] . "&amp;contains=" .
//                $params["contains"] . "&amp;is_faq=" . $params['faq'];
//
//            if (
//                isset($options['item_itemtype'])
//                && isset($options['item_items_id'])
//            ) {
//                $parameters .= "&amp;item_items_id=" . $options['item_items_id'] . "&amp;item_itemtype=" .
//                    $options['item_itemtype'];
//            }
//
//            $pager_url = "";
//            if ($output_type == Search::HTML_OUTPUT) {
//                $pager_url = Toolbox::getItemTypeSearchURL('KnowbaseItem');
//                if (!Session::getLoginUserID()) {
//                    $pager_url = $CFG_GLPI['root_doc'] . "/front/helpdesk.faq.php";
//                }
//                Html::printPager($params['start'], $rows, $pager_url, $parameters, 'KnowbaseItem');
//            }
//
//            $nbcols = 1;
//            // Display List Header
//            echo Search::showHeader($output_type, $numrows + 1, $nbcols);
//
//            echo Search::showNewLine($output_type);
//            $header_num = 1;
//            echo Search::showHeaderItem($output_type, __('Subject'), $header_num);
//
//            if ($output_type != Search::HTML_OUTPUT) {
//                echo Search::showHeaderItem($output_type, __('Content'), $header_num);
//            }
//
//            if ($showwriter) {
//                echo Search::showHeaderItem($output_type, __('Writer'), $header_num);
//            }
//            echo Search::showHeaderItem($output_type, _n('Category', 'Categories', 1), $header_num);
//
//            if ($output_type == Search::HTML_OUTPUT) {
//                echo Search::showHeaderItem($output_type, _n('Associated element', 'Associated elements', Session::getPluralNumber()), $header_num);
//            }
//
//            if (
//                isset($options['item_itemtype'])
//                && isset($options['item_items_id'])
//                && ($output_type == Search::HTML_OUTPUT)
//            ) {
//                echo Search::showHeaderItem($output_type, '&nbsp;', $header_num);
//            }
//
//
//
//            // Num of the row (1=header_line)
//            $row_num = 1;
////            foreach ($main_iterator as $data) {
////                Session::addToNavigateListItems('KnowbaseItem', $data["id"]);
////                // Column num
////                $item_num = 1;
////                echo Search::showNewLine($output_type, ($row_num - 1) % 2);
////                $row_num++;
////
////                $item = new self();
////                $item->getFromDB($data["id"]);
////                $name = $data["name"];
////                $answer = $data["answer"];
////                // Manage translations
////                if (isset($data['transname']) && !empty($data['transname'])) {
////                    $name = $data["transname"];
////                }
////                if (isset($data['transanswer']) && !empty($data['transanswer'])) {
////                    $answer = $data["transanswer"];
////                }
////
////                if ($output_type == Search::HTML_OUTPUT) {
////                    $toadd = '';
////                    if (
////                        isset($options['item_itemtype'])
////                        && isset($options['item_items_id'])
////                    ) {
////                        $href = " href='#' data-bs-toggle='modal' data-bs-target='#kbshow{$data["id"]}'";
////                        $toadd = Ajax::createIframeModalWindow(
////                            'kbshow' . $data["id"],
////                            KnowbaseItem::getFormURLWithID($data["id"]),
////                            ['display' => false]
////                        );
////                    } else {
////                        $href = " href=\"" . KnowbaseItem::getFormURLWithID($data["id"]) . "\" ";
////                    }
////
////                    $fa_class = "";
////                    $fa_title = "";
////                    if (
////                        $data['is_faq']
////                        && (!Session::isMultiEntitiesMode()
////                            || isset($data['visibility_count'])
////                            && $data['visibility_count'] > 0)
////                    ) {
////                        $fa_class = "fa-question-circle faq";
////                        $fa_title = __s("This item is part of the FAQ");
////                    } else if (
////                        isset($data['visibility_count'])
////                        && $data['visibility_count'] <= 0
////                    ) {
////                        $fa_class = "fa-eye-slash not-published";
////                        $fa_title = __s("This item is not published yet");
////                    }
////                    echo Search::showItem(
////                        $output_type,
////                        "<div class='kb'>$toadd <i class='fa fa-fw $fa_class' title='$fa_title'></i> <a $href>" . Html::resume_text($name, 80) . "</a></div>
////                                       <div class='kb_resume'>" . Html::resume_text(RichText::getTextFromHtml($answer, false, false, true), 600) . "</div>",
////                        $item_num,
////                        $row_num
////                    );
////                } else {
////                    echo Search::showItem($output_type, $name, $item_num, $row_num);
////                    echo Search::showItem($output_type, RichText::getTextFromHtml($answer, true, false, true), $item_num, $row_num);
////                }
////
////                $showuserlink = 0;
////                if (Session::haveRight('user', READ)) {
////                    $showuserlink = 1;
////                }
////                if ($showwriter) {
////                    echo Search::showItem(
////                        $output_type,
////                        getUserName($data["users_id"], $showuserlink),
////                        $item_num,
////                        $row_num
////                    );
////                }
////
////                $categories_names = [];
////                $ki->getFromDB($data["id"]);
////                $categories = KnowbaseItem_KnowbaseItemCategory::getItems($ki);
////                foreach ($categories as $category) {
////                    $knowbaseitemcategories_id = $category['knowbaseitemcategories_id'];
////                    $fullcategoryname = getTreeValueCompleteName(
////                        "glpi_knowbaseitemcategories",
////                        $knowbaseitemcategories_id
////                    );
////                    if ($output_type == Search::HTML_OUTPUT) {
////                        $cathref = $ki->getSearchURL() . "?knowbaseitemcategories_id=" .
////                            $knowbaseitemcategories_id . '&amp;forcetab=Knowbase$2';
////                        $categories_names[] = "<a class='kb-category'"
////                            . " href='$cathref'"
////                            . " data-category-id='" . $knowbaseitemcategories_id . "'"
////                            . ">" . $fullcategoryname . '</a>';
////                    } else {
////                        $categories_names[] = $fullcategoryname;
////                    }
////                }
////                echo Search::showItem($output_type, implode(', ', $categories_names), $item_num, $row_num);
////
////                if ($output_type == Search::HTML_OUTPUT) {
////                    echo "<td class='center'>";
////                    $j = 0;
////                    $iterator = $DBread->request([
////                        'FIELDS' => 'documents_id',
////                        'FROM' => 'glpi_documents_items',
////                        'WHERE' => [
////                                'items_id' => $data["id"],
////                                'itemtype' => 'KnowbaseItem'
////                            ] + getEntitiesRestrictCriteria('', '', '', true)
////                    ]);
////                    foreach ($iterator as $docs) {
////                        $doc = new Document();
////                        $doc->getFromDB($docs["documents_id"]);
////                        echo $doc->getDownloadLink();
////                        $j++;
////                        if ($j > 1) {
////                            echo "<br>";
////                        }
////                    }
////                    echo "</td>";
////                }
////
////                if (
////                    isset($options['item_itemtype'])
////                    && isset($options['item_items_id'])
////                    && ($output_type == Search::HTML_OUTPUT)
////                ) {
////                    $forcetab = $options['item_itemtype'] . '$main';
////                    $item_itemtype = $options['item_itemtype'];
////                    $content = "<a href='" . $item_itemtype::getFormURLWithID($options['item_items_id']) .
////                        "&amp;load_kb_sol=" . $data['id'] .
////                        "&amp;forcetab=" . $forcetab . "'>" .
////                        __('Use as a solution') . "</a>";
////                    echo Search::showItem($output_type, $content, $item_num, $row_num);
////                }
////
////                // End Line
////                echo Search::showEndLine($output_type);
////            }
//
//            // Display footer
//            if (
//                ($output_type == Search::PDF_OUTPUT_LANDSCAPE)
//                || ($output_type == Search::PDF_OUTPUT_PORTRAIT)
//            ) {
//                echo Search::showFooter(
//                    $output_type,
//                    Dropdown::getDropdownName(
//                        "glpi_knowbaseitemcategories",
//                        $params['knowbaseitemcategories_id']
//                    ),
//                    $numrows
//                );
//            } else {
//                echo Search::showFooter($output_type, '', $numrows);
//            }
//            echo "<br>";
//            if ($output_type == Search::HTML_OUTPUT) {
//                Html::printPager($params['start'], $rows, $pager_url, $parameters, 'KnowbaseItem');
//            }
//        } else {
//            echo "<div class='center b'>" . __('No item found') . "</div>";
//        }
    }


    /**
     * Display datas extracted from DB
     *
     * @param array $data Array of search datas prepared to get datas
     *
     * @return void
     **/
    public static function displayData(array $data)
    {
        /** @var array $CFG_GLPI */
        global $CFG_GLPI;

        if (!isset($data['data']) || !isset($data['data']['totalcount'])) {
            return false;
        }

        $search     = $data['search'];
        $itemtype   = $data['itemtype'];
        $item       = $data['item'];
        $is_deleted = $search['is_deleted'];

        foreach ($search['criteria'] as $key => $criteria) {
            if (isset($criteria['virtual']) && $criteria['virtual']) {
                unset($search['criteria'][$key]);
            }
        }

        // Contruct parameters
        $globallinkto  = Toolbox::append_params([
            'criteria'     => \Glpi\Toolbox\Sanitizer::unsanitize($search['criteria']),
            'metacriteria' => \Glpi\Toolbox\Sanitizer::unsanitize($search['metacriteria'])
        ], '&');

        $parameters = http_build_query([
            'sort'   => $search['sort'],
            'order'  => $search['order']
        ]);

        $parameters .= "&{$globallinkto}";

        if (isset($_GET['_in_modal'])) {
            $parameters .= "&_in_modal=1";
        }

        // For plugin add new parameter if available
        if ($plug = isPluginItemType($data['itemtype'])) {
            $out = Plugin::doOneHook($plug['plugin'], 'addParamFordynamicReport', $data['itemtype']);
            if (is_array($out) && count($out)) {
                $parameters .= Toolbox::append_params($out, '&');
            }
        }

        $search['target'] = \Glpi\Toolbox\URL::sanitizeURL($search['target']);
        $prehref = $search['target'] . (strpos($search['target'], "?") !== false ? "&" : "?");
        $href    = $prehref . $parameters;

        Session::initNavigateListItems($data['itemtype'], '', $href);

        $count = $data['data']['totalcount'] ?? 0;

        \Glpi\Application\View\TemplateRenderer::getInstance()->display('components/search/display_data.html.twig', [
            'data'                => $data,
            'union_search_type'   => $CFG_GLPI["union_search_type"],
            'rand'                => mt_rand(),
            'no_sort'             => $search['no_sort'] ?? false,
            'order'               => $search['order'] ?? [],
            'sort'                => $search['sort'] ?? [],
            'start'               => $search['start'] ?? 0,
            'limit'               => $_SESSION['glpilist_limit'],
            'count'               => $count,
            'item'                => $item,
            'itemtype'            => $itemtype,
            'href'                => $href,
            'prehref'             => $prehref,
            'posthref'            => $globallinkto,
            'showmassiveactions'  => ($search['showmassiveactions'] ?? true)
                && $data['display_type'] != Search::GLOBAL_SEARCH
                && ($itemtype == AllAssets::getType()
                    || count(MassiveAction::getAllMassiveActions($item, $is_deleted))
                ),
            'massiveactionparams' => $data['search']['massiveactionparams'] + [
                    'num_displayed' => min($_SESSION['glpilist_limit'], $count),
                    'is_deleted'    => $is_deleted,
                    'container'     => "massform$itemtype",
                ],
            'can_config'          => Session::haveRightsOr('search_config', [
                DisplayPreference::PERSONAL,
                DisplayPreference::GENERAL
            ]),
            'may_be_deleted'      => $item instanceof CommonDBTM && $item->maybeDeleted() && !$item->useDeletedToLockIfDynamic(),
            'may_be_located'      => $item instanceof CommonDBTM && $item->maybeLocated(),
            'may_be_browsed'      => $item !== null && Toolbox::hasTrait($item, \Glpi\Features\TreeBrowse::class),
        ]);

        // Add items in item list
        foreach ($data['data']['rows'] as $row) {
            if ($itemtype !== AllAssets::class) {
                Session::addToNavigateListItems($itemtype, $row["id"]);
            } else {
                // In case of a global search, reset and empty navigation list to ensure navigation in
                // item header context is not shown. Indeed, this list does not support navigation through
                // multiple itemtypes, so it should not be displayed in global search context.
                Session::initNavigateListItems($row['TYPE'] ?? $data['itemtype']);
            }
        }

        // Clean previous selection
        $_SESSION['glpimassiveactionselected'] = [];
    }

    /**
     * Output data (for export in CSV, PDF, ...).
     *
     * @param array $data Array of search datas prepared to get datas
     *
     * @return void
     **/
    public static function outputData(array $data)
    {
        /** @var array $CFG_GLPI */
        global $CFG_GLPI;

        if (
            !isset($data['data'])
            || !isset($data['data']['totalcount'])
            || $data['data']['count'] <= 0
            || $data['search']['as_map'] != 0
        ) {
            return false;
        }

        // Define begin and end var for loop
        // Search case
        $begin_display = $data['data']['begin'];
        $end_display   = $data['data']['end'];

        // Compute number of columns to display
        // Add toview elements
        $nbcols          = count($data['data']['cols']);

        // Display List Header
        echo self::showHeader($data['display_type'], $end_display - $begin_display + 1, $nbcols);

        // New Line for Header Items Line
        $headers_line        = '';
        $headers_line_top    = '';

        $headers_line_top .= self::showBeginHeader($data['display_type']);
        $headers_line_top .= self::showNewLine($data['display_type']);

        $header_num = 1;

        // Display column Headers for toview items
        $metanames = [];
        foreach ($data['data']['cols'] as $val) {
            $name = $val["name"];

            // prefix by group name (corresponding to optgroup in dropdown) if exists
            if (isset($val['groupname'])) {
                $groupname = $val['groupname'];
                if (is_array($groupname)) {
                    //since 9.2, getSearchOptions has been changed
                    $groupname = $groupname['name'];
                }
                $name  = "$groupname - $name";
            }

            // Not main itemtype add itemtype to display
            if ($data['itemtype'] != $val['itemtype']) {
                if (!isset($metanames[$val['itemtype']])) {
                    if ($metaitem = getItemForItemtype($val['itemtype'])) {
                        $metanames[$val['itemtype']] = $metaitem->getTypeName();
                    }
                }
                $name = sprintf(
                    __('%1$s - %2$s'),
                    $metanames[$val['itemtype']],
                    $val["name"]
                );
            }

            $headers_line .= self::showHeaderItem(
                $data['display_type'],
                $name,
                $header_num,
                '',
                (!$val['meta']
                    && ($data['search']['sort'] == $val['id'])),
                $data['search']['order']
            );
        }

        // Add specific column Header
        if (isset($CFG_GLPI["union_search_type"][$data['itemtype']])) {
            $headers_line .= self::showHeaderItem(
                $data['display_type'],
                __('Item type'),
                $header_num
            );
        }
        // End Line for column headers
        $headers_line .= self::showEndLine($data['display_type'], true);

        $headers_line_top    .= $headers_line;
        $headers_line_top    .= self::showEndHeader($data['display_type']);

        echo $headers_line_top;

        // Num of the row (1=header_line)
        $row_num = 1;

        $typenames = [];
        // Display Loop
        foreach ($data['data']['rows'] as $row) {
            // Column num
            $item_num = 1;
            $row_num++;
            // New line
            echo self::showNewLine(
                $data['display_type'],
                ($row_num % 2),
                $data['search']['is_deleted']
            );

            // Print other toview items
            foreach ($data['data']['cols'] as $col) {
                $colkey = "{$col['itemtype']}_{$col['id']}";
                if (!$col['meta']) {
                    echo self::showItem(
                        $data['display_type'],
                        $row[$colkey]['displayname'],
                        $item_num,
                        $row_num,
                        self::displayConfigItem(
                            $data['itemtype'],
                            $col['id'],
                            $row
                        )
                    );
                } else { // META case
                    echo self::showItem(
                        $data['display_type'],
                        $row[$colkey]['displayname'],
                        $item_num,
                        $row_num
                    );
                }
            }

            if (isset($CFG_GLPI["union_search_type"][$data['itemtype']])) {
                if (!isset($typenames[$row["TYPE"]])) {
                    if ($itemtmp = getItemForItemtype($row["TYPE"])) {
                        $typenames[$row["TYPE"]] = $itemtmp->getTypeName();
                    }
                }
                echo self::showItem(
                    $data['display_type'],
                    $typenames[$row["TYPE"]],
                    $item_num,
                    $row_num
                );
            }
            // End Line
            echo self::showEndLine($data['display_type']);
        }

        // Create title
        $title = '';
        if (
            ($data['display_type'] == self::PDF_OUTPUT_LANDSCAPE)
            || ($data['display_type'] == self::PDF_OUTPUT_PORTRAIT)
        ) {
            $title = self::computeTitle($data);
        }

        // Display footer (close table)
        echo self::showFooter($data['display_type'], $title, $data['data']['count']);
    }


    /**
     * Build request for showList
     *
     * @param $params array  (contains, knowbaseitemcategories_id, faq)
     * @param $type   string search type : browse / search (default search)
     *
     * @return array : SQL request
     **@since 0.83
     *
     */
    public static function getListRequest(array $params, $type = 'search')
    {
        /** @var \DBmysql $DB */
        global $DB;

        $criteria = [
            'SELECT' => [
                PluginDlteamsProcessedData::getTable() . '.*'
            ],
            'FROM' => PluginDlteamsProcessedData::getTable(),
            'WHERE' => [], //to be filled
            'LEFT JOIN' => [], //to be filled
            'GROUPBY' => [PluginDlteamsProcessedData::getTable() . '.id']
        ];

        // Lists kb Items
//        $restrict = self::getVisibilityCriteria(true);
//        $restrict_where = $restrict['WHERE'];
//        unset($restrict['WHERE']);
//        unset($restrict['SELECT']);
//        $criteria = array_merge_recursive($criteria, $restrict);

//        switch ($type) {
//            case 'myunpublished':
//            case 'allmy':
//            case 'allunpublished':
//                break;
//
//            default:
//                // Build query
////                if (Session::getLoginUserID()) {
////                    $criteria['WHERE'] = array_merge(
////                        $criteria['WHERE'],
////                        $restrict_where
////                    );
////                } else {
////                    // Anonymous access
////                    if (Session::isMultiEntitiesMode()) {
////                        $criteria['WHERE']['glpi_entities_knowbaseitems.entities_id'] = 0;
////                        $criteria['WHERE']['glpi_entities_knowbaseitems.is_recursive'] = 1;
////                    }
////                }
//                break;
//        }

//        if ($params['faq']) { // helpdesk
//            $criteria['WHERE'][] = [
//                'OR' => [
//                    'glpi_knowbaseitems.is_faq' => 1,
//                    'glpi_knowbaseitems_users.users_id' => Session::getLoginUserID(),
//                ]
//            ];
//        }


        if ($params['processeddatacategories_id'] !== PluginDlteamsProcessedData::SEEALL) {
            $criteria['LEFT JOIN'][PluginDlteamsProcesseddata_ProcesseddataCategory::getTable()] = [
                'FKEY' => [
                    PluginDlteamsProcesseddata_ProcesseddataCategory::getTable() => PluginDlteamsProcessedData::getForeignKeyField(),
                    PluginDlteamsProcessedData::getTable() => 'id',
                ],
            ];
            if ($params['processeddatacategories_id'] > 0) {
                $criteria['WHERE'][PluginDlteamsProcesseddata_ProcesseddataCategory::getTableField('processeddatacategories_id')] = $params['processeddatacategories_id'];
            } elseif ($params['knowbaseitemcategories_id'] === 0) {
                $criteria['WHERE'][PluginDlteamsProcesseddata_ProcesseddataCategory::getTableField('processeddatacategories_id')] = null;
            }
        }

//        if (
//            KnowbaseItemTranslation::isKbTranslationActive()
//            && (countElementsInTable('glpi_knowbaseitemtranslations') > 0)
//        ) {
//            $criteria['LEFT JOIN']['glpi_knowbaseitemtranslations'] = [
//                'ON' => [
//                    'glpi_knowbaseitems' => 'id',
//                    'glpi_knowbaseitemtranslations' => 'knowbaseitems_id', [
//                        'AND' => [
//                            'glpi_knowbaseitemtranslations.language' => $_SESSION['glpilanguage']
//                        ]
//                    ]
//                ]
//            ];
//            $criteria['SELECT'][] = 'glpi_knowbaseitemtranslations.name AS transname';
//            $criteria['SELECT'][] = 'glpi_knowbaseitemtranslations.answer AS transanswer';
//        }

        // a search with $contains
//        switch ($type) {
//            case 'allmy':
//                $criteria['WHERE']['glpi_knowbaseitems.users_id'] = Session::getLoginUserID();
//                break;
//
//            case 'myunpublished':
//                $criteria['WHERE']['glpi_knowbaseitems.users_id'] = Session::getLoginUserID();
//                $criteria['WHERE']['glpi_entities_knowbaseitems.entities_id'] = null;
//                $criteria['WHERE']['glpi_knowbaseitems_profiles.profiles_id'] = null;
//                $criteria['WHERE']['glpi_groups_knowbaseitems.groups_id'] = null;
//                $criteria['WHERE']['glpi_knowbaseitems_users.users_id'] = null;
//                break;
//
//            case 'allunpublished':
//                // Only published
//                $criteria['WHERE']['glpi_entities_knowbaseitems.entities_id'] = null;
//                $criteria['WHERE']['glpi_knowbaseitems_profiles.profiles_id'] = null;
//                $criteria['WHERE']['glpi_groups_knowbaseitems.groups_id'] = null;
//                $criteria['WHERE']['glpi_knowbaseitems_users.users_id'] = null;
//                break;
//
//            case 'allpublished':
//                $criteria['HAVING']['visibility_count'] = ['>', 0];
//                break;
//
//            case 'search':
//                if (strlen($params["contains"]) > 0) {
//                    $search = Sanitizer::unsanitize($params["contains"]);
//                    $search_wilcard = self::computeBooleanFullTextSearch($search);
//
//                    $addscore = [];
//                    if (
//                        KnowbaseItemTranslation::isKbTranslationActive()
//                        && (countElementsInTable('glpi_knowbaseitemtranslations') > 0)
//                    ) {
//                        $addscore = [
//                            'glpi_knowbaseitemtranslations.name',
//                            'glpi_knowbaseitemtranslations.answer'
//                        ];
//                    }
//
//                    $expr = "(MATCH(" . $DB->quoteName('glpi_knowbaseitems.name') . ", " . $DB->quoteName('glpi_knowbaseitems.answer') . ")
//                           AGAINST(" . $DB->quote($search_wilcard) . " IN BOOLEAN MODE)";
//
//                    if (!empty($addscore)) {
//                        foreach ($addscore as $addscore_field) {
//                            $expr .= " + MATCH(" . $DB->quoteName($addscore_field) . ")
//                                        AGAINST(" . $DB->quote($search_wilcard) . " IN BOOLEAN MODE)";
//                        }
//                    }
//                    $expr .= " ) AS SCORE ";
//                    $criteria['SELECT'][] = new QueryExpression($expr);
//
//                    $ors = [
//                        new QueryExpression(
//                            "MATCH(" . $DB->quoteName('glpi_knowbaseitems.name') . ",
//                        " . $DB->quoteName('glpi_knowbaseitems.answer') . ")
//                        AGAINST(" . $DB->quote($search_wilcard) . " IN BOOLEAN MODE)"
//                        )
//                    ];
//
//                    if (!empty($addscore)) {
//                        foreach ($addscore as $addscore_field) {
//                            $ors[] = [
//                                'NOT' => [$addscore_field => null],
//                                new QueryExpression(
//                                    "MATCH(" . $DB->quoteName($addscore_field) . ")
//                              AGAINST(" . $DB->quote($search_wilcard) . " IN BOOLEAN MODE)"
//                                )
//                            ];
//                        }
//                    }
//
//                    $search_where = $criteria['WHERE']; // Visibility restrict criteria
//
//                    $search_where[] = ['OR' => $ors];
//
//                    // Add visibility date
//                    $visibility_crit = [
//                        [
//                            'OR' => [
//                                ['glpi_knowbaseitems.begin_date' => null],
//                                ['glpi_knowbaseitems.begin_date' => ['<', new QueryExpression('NOW()')]]
//                            ]
//                        ], [
//                            'OR' => [
//                                ['glpi_knowbaseitems.end_date' => null],
//                                ['glpi_knowbaseitems.end_date' => ['>', new QueryExpression('NOW()')]]
//                            ]
//                        ]
//                    ];
//                    $search_where[] = $visibility_crit;
//
//                    $criteria['ORDERBY'] = ['SCORE DESC'];
//
//                    // preliminar query to allow alternate search if no result with fulltext
//                    $search_criteria = [
//                        'COUNT' => 'cpt',
//                        'LEFT JOIN' => $criteria['LEFT JOIN'],
//                        'FROM' => 'glpi_knowbaseitems',
//                        'WHERE' => $search_where
//                    ];
//                    $search_iterator = $DB->request($search_criteria);
//                    $numrows_search = $search_iterator->current()['cpt'];
//
//                    if ($numrows_search <= 0) {// not result this fulltext try with alternate search
//                        $search1 = [/* 1 */
//                            '/\\\"/',
//                            /* 2 */
//                            "/\+/",
//                            /* 3 */
//                            "/\*/",
//                            /* 4 */
//                            "/~/",
//                            /* 5 */
//                            "/</",
//                            /* 6 */
//                            "/>/",
//                            /* 7 */
//                            "/\(/",
//                            /* 8 */
//                            "/\)/",
//                            /* 9 */
//                            "/\-/"
//                        ];
//                        $contains = preg_replace($search1, "", $params["contains"]);
//                        $ors = [
//                            ["glpi_knowbaseitems.name" => ['LIKE', Search::makeTextSearchValue($contains)]],
//                            ["glpi_knowbaseitems.answer" => ['LIKE', Search::makeTextSearchValue($contains)]]
//                        ];
//                        if (
//                            KnowbaseItemTranslation::isKbTranslationActive()
//                            && (countElementsInTable('glpi_knowbaseitemtranslations') > 0)
//                        ) {
//                            $ors[] = ["glpi_knowbaseitemtranslations.name" => ['LIKE', Search::makeTextSearchValue($contains)]];
//                            $ors[] = ["glpi_knowbaseitemtranslations.answer" => ['LIKE', Search::makeTextSearchValue($contains)]];
//                        }
//                        $criteria['WHERE'][] = ['OR' => $ors];
//                        // Add visibility date
//                        $criteria['WHERE'][] = $visibility_crit;
//                    } else {
//                        $criteria['WHERE'] = $search_where;
//                    }
//                }
//                break;
//
//            case 'browse':
//                if (!Session::haveRight(self::$rightname, self::KNOWBASEADMIN)) {
//                    // Add visibility date
//                    $criteria['WHERE'][] = [
//                        'OR' => [
//                            ['glpi_knowbaseitems.begin_date' => null],
//                            ['glpi_knowbaseitems.begin_date' => ['<', new QueryExpression('NOW()')]]
//                        ]
//                    ];
//                    $criteria['WHERE'][] = [
//                        'OR' => [
//                            ['glpi_knowbaseitems.end_date' => null],
//                            ['glpi_knowbaseitems.end_date' => ['>', new QueryExpression('NOW()')]]
//                        ]
//                    ];
//                }
//
//                $criteria['ORDERBY'] = ['glpi_knowbaseitems.name ASC'];
//                break;
//        }

        return $criteria;
    }

    public static function getForeignKeyField()
    {
        return "processeddatas_id";
    }

    public static function getMenuContent()
    {

        $menu = [];
        $menu['title'] = static::getTypeName(Session::getPluralNumber());
        $menu['shortcut'] = 'n';
        $menu['page'] = static::getSearchURL();
        $menu['icon'] = self::getIcon();
        $menu['config']['default'] = '/front/dropdown.php';


        $menu['options'] = [];
//        Bouton add
        if (static::canCreate()) {
            $menu['options']["processeddata"]['links']['add'] = static::getFormURL(false);
        }

//        bouton rechercher
        $menu['options']["processeddata"]['links']['search'] = static::getSearchURL(false);


//        bouton help
        $image = "<i class='fas fa-question' title='" . 'Aide' . "'></i>";
        $menu['options']["processeddata"]['links'][$image] = KnowbaseItem::getSearchURL(false) . '?contains="données à caractère personnel"';

        echo "<script>
                        \$(document).ready(function () {
                            // Attendre que la page soit complètement chargée
                            \$('a[href^=\"/front/knowbaseitem.php?contains=\"]').attr('target', '_blank');
                           
                        });
                    </script>";


        if (count($_SESSION['glpiprofiles']) > 1) {
            $profile = new Profile();
            $name = 'Vue-Modele';
            $options = [
                'SELECT' => [
                    'id'
                ],
                'WHERE' => [
                    'name' => $name,
                ]
            ];

            global $DB;
            $req = $DB->request($profile->getTable(), $options);
            foreach ($req as $id => $row) {
                //if ($row = $req->next()) {
                $profile->getFromDB($row['id']);
                if (array_key_exists($profile->getID(), $_SESSION['glpiprofiles'])) {
                    $swap = $_SESSION['glpiactiveprofile']['id'] == $profile->getID();
                    $text = '<i class="fa fa-layer-group pointer" style="margin-right: 0.4em;"></i>' . __("Swap to model view", "dlteams");
                    $returnKey = array_key_first($_SESSION['glpiprofiles']) == $profile->getID() ? array_keys($_SESSION['glpiprofiles'])[1] : array_key_first($_SESSION['glpiprofiles']);
                    $prodif = $profile->getID();
                    $server_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
                    empty($swap) ? $text = "vue modèle" : $text = "vue modèle";
                    empty($swap) ? $val = $prodif : $val = $returnKey;
                    empty($swap) ? $checked = '' : $checked = 'checked';


                    $text_temp = "<div id='switchmodelcontainer' style='width:100%; display: flex;justify-content: center; margin-bottom: 1px; margin-right: 25px;'>
                                        <label class='form-check form-switch btn-xs  me-0 me-sm-1 px-1 py-1 mb-0 flex-column-reverse flex-sm-row'
                                            title='$text'>
                                         <input type='checkbox' class='form-check-input ms-0 me-1 mt-0' role='button'
                                                autocomplete='off'
                                                $checked
                                                onclick='window.location.href=`$server_url/front/central.php?newprofile=$val`'
                                                />
                                         <span class='form-check-label mb-1 mb-sm-0'>
                                            $text
                                         </span>
                                      </label></div>
                                      
                                      <script>
                                            var child = document.getElementById('switchmodelcontainer');
                                            var parent = child.parentNode;
                                            parent.style.border = 'none';
                                            parent.classList.remove('btn-outline-secondary');
                                        </script>
                            ";


                    $menu['options']["processeddata"]['links'][$text_temp] = "/front/central.php?newprofile=$val";
                    break;


                }
            }

        }

        return $menu;
    }

    public static function getCurrentId()
    {
        // Get the current URL
        $currentURL = $_SERVER['REQUEST_URI'];

        // Get the query string from the URL
        $queryString = parse_url($currentURL, PHP_URL_QUERY);

        // Initialize an empty array for query parameters
        $queryParams = [];

        // Parse the query string into an array of parameters if it exists
        if ($queryString) {
            parse_str($queryString, $queryParams);
        }

        // Get the value of the "id" parameter
        $id = isset($queryParams['id']) ? $queryParams['id'] : null;

        return $id;
    }


    function prepareInputForAdd($input)
    {

        $input['users_id_creator'] = Session::getLoginUserID();

        if (!$input['number'])
            $input['number'] = null;

        return parent::prepareInputForAdd($input);
    }

//    function prepareInputForUpdate($input)
//    {
//
//        $input['users_id_lastupdater'] = Session::getLoginUserID();
//        if (!$input['number'])
//            $input['number'] = null;
//
//        return parent::prepareInputForUpdate($input);
//    }

    function cleanDBonPurge()
    {
        /*$rel = new PluginDlteamsRecord_MotifEnvoi();
        $rel->deleteByCriteria(['plugin_dlteams_concernedpersons_id' => $this->fields['id']]);*/
    }

    function rawSearchOptions()
    {
        $tab = [];
        $tab[] = [
            'id' => 'common',
            'name' => __("Characteristics")
        ];

        $tab[] = [
            'id' => '1',
            'table' => $this->getTable(),
            'field' => 'name',
            'name' => __("Name"),
            'datatype' => 'itemlink',
            'massiveaction' => false,
            'autocomplete' => true,
        ];

        $tab[] = [
            'id' => '2',
            'table' => $this->getTable(),
            'field' => 'id',
            'name' => __("ID"),
            'massiveaction' => false,
            'datatype' => 'number',
        ];

        $tab[] = [
            'id' => '3',
            'table' => $this->getTable(),
            'field' => 'comment',
            'name' => __("Comments"),
            'datatype' => 'text',
            'toview' => true,
            'massiveaction' => true,
        ];

        $tab[] = [
            'id' => '4',
            'table' => 'glpi_entities',
            'field' => 'completename',
            'name' => __("Entity"),
            'datatype' => 'dropdown',
            'massiveaction' => true,
        ];

        $tab[] = [
            'id' => '5',
            'table' => $this->getTable(),
            'field' => 'is_recursive',
            'name' => __("Child entities"),
            'datatype' => 'bool',
            'massiveaction' => false,
        ];


        $tab[] = [
            'id' => '6',
            'table' => $this->getTable(),
            'field' => 'rgpd_sensitive_data',
            'name' => __("GDPR Sensitive", 'dlteams'),
            'datatype' => 'bool',
            'massiveaction' => true,
        ];

        $tab[] = [
            'id' => '7',
            'table' => $this->getTable(),
            'field' => 'seen_sensitive_data',
            'name' => __("Seen sensitive data", 'dlteams'),
            'datatype' => 'bool',
            'massiveaction' => true,
        ];

        $tab[] = [
            'id' => '8',
            'table' => $this->getTable(),
            'field' => 'content',
            'name' => __("Content"),
            'datatype' => 'text',
            'toview' => true,
            'massiveaction' => true,
        ];

        $tab[] = [
            'id' => '9',
            'table' => $this->getTable(),
            'field' => 'number',
            'name' => __("Num"),
            'datatype' => 'number',
            'min' => 1,
            'max' => 10000,
            'massiveaction' => true,
        ];

        $tab[] = [
            'id' => '10',
            'table' => $this->getTable(),
            'field' => 'date_creation',
            'name' => __("Creation date"),
            'massiveaction' => false,
            'datatype' => 'text',
        ];

        $tab[] = [
            'id' => '11',
            'table' => $this->getTable(),
            'field' => 'date_mod',
            'name' => __("Last update"),
            'massiveaction' => false,
            'datatype' => 'text',
        ];

        /*$tab[] = [
            'id' => '108',
            'table' => 'glpi_plugin_dlteams_records_items',
            'field' => 'records_id',
            'name' => _x('quantity', 'Traitements'),
            'forcegroupby' => true,
            'usehaving' => true,
            'datatype' => 'count',
            'massiveaction' => false,
            'joinparams' => [
                'jointype' => 'itemtype_item'
            ]
        ];*/


        /*$tab[] = [
            'id' => '13',
            'table' => PluginDlteamsProcessedDataCategory_Item::getTable(),
            'field' => 'id',
            'name' => PluginDlteamsProcessedDataCategory::getTypeName(),
            'forcegroupby' => true,
            'usehaving' => true,
            'datatype' => 'count',
            'massiveaction' => false,
            'joinparams' => [
                'jointype' => 'itemtype_item'
            ]
        ];*/

        /*$tab[] = [
            'id' => '13',
            'table' => PluginDlteamsProcessedDataCategory::getTable(),
            'field' => 'name',
            'name' => PluginDlteamsProcessedDataCategory::getTypeName(),
            'datatype' => 'dropdown',
            'joinparams' => [
                'beforejoin' => [
                    'table' => PluginDlteamsProcesseddata_ProcesseddataCategory::getTable(),
                    'joinparams' => [
                    'field'      => 'processeddatacategories_id',
                        'jointype' => 'child',
                    ]
                ]
            ],
            'massiveaction' => true,
        ];*/

        $tab[] = [
            'id'                 => '107',
            'table'              => PluginDlteamsProcessedData_Item::getTable(),
            'field'              => 'items_id',
            'name'               => _x('quantity','Catégories'),
            'datatype'           => 'specific', //'itemlink',
            'comments'           => true,
            'nosort'             => false,
            'additionalfields'   => ['itemtype'],
            'joinparams'         => [
            'linkfield' => 'processeddatas_id',
                'jointype'           => 'child',
                'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsProcessedDataCategory::class."'",
            ],
            'forcegroupby'       => true,
            'massiveaction'      => false,			
			'htmltext'           => true,
            'showprocesseddatacategory' => true,
        ];

       /*$tab[] = [
           'id'                 => '107',
           'table'              => PluginDlteamsProcessedData_Item::getTable(),
           'field'              => 'items_id', // 'items_id' ou 'id'
           'name'               => _x('quantity', 'Catégorie'),
           'datatype'           => 'specific', //'count' pour compteur ; 'specific' pour la liste
           'comments'           => true,
           'nosort'             => false,
           'nosearch'           => true,
           'additionalfields'   => ['itemtype'],
           'joinparams'         => [
               'linkfield' => 'processeddatas_id',
               'jointype'           => 'child',
               'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsProcessedDataCategory::class."' AND NEWTABLE.`items_id` <> 0 AND NEWTABLE.`items_id` IN (SELECT `id` FROM `glpi_plugin_dlteams_processeddatacategories`)",
           ],
           'forcegroupby'       => true,
           'massiveaction'      => false,
           'showrecords' => true
       ];*/

        $tab[] = [
            'id' => '108',
            'table' => PluginDlteamsProcessedData_Item::getTable(),
            'field' => 'items_id', 
            'name' => _x('quantity', 'Traitements'),
            'datatype' => 'count',
            'comments' => true,
            // 'nosort' => true,
            'nosearch' => true,
            'joinparams' => [
                'linkfield' => 'processeddatas_id',
                'jointype' => 'child',
                'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsRecord::class."' AND NEWTABLE.`items_id` <> 0 AND NEWTABLE.`items_id` IN (SELECT `id` FROM `glpi_plugin_dlteams_records`)",
            ],
            'forcegroupby' => true,
            'massiveaction' => false,
			// 'showrecords' => true
        ];

        $tab[] = [
            'id' => '111',
            'table' => PluginDlteamsProcessedData_Item::getTable(),
            'field' => 'id',
            'name' => _x('quantity', 'Jeux de données'),
            'datatype' => 'count',
            'comments' => true,
            // 'nosort' => true,
            // 'nosearch' => true,
            'joinparams' => [
                'linkfield' => 'processeddatas_id',
                'jointype' => 'child', // TODO: revoir le pb d'entité
                'condition' => "AND NEWTABLE.`itemtype` = '" . PluginDlteamsPolicieForm::class . "' 
                                AND NEWTABLE.`items_id` <> 0 
                                AND NEWTABLE.`items_id` IN (SELECT `id` FROM `" . PluginDlteamsPolicieForm::getTable() . "` 
                                WHERE `entities_id` IN (" . implode(',', array_map('intval', $_SESSION["glpiactiveentities"])) . "))",
            ],
            // 'forcegroupby' => true,
            // 'massiveaction' => false,
        ];

        $tab[] = [
            'id' => '112',
            'table' => PluginDlteamsProcessedData_Item::getTable(),
            'field' => 'id',
            'name' => _x('quantity', 'Personnes concernées'),
            'datatype' => 'count',
            'comments' => true,
            //'nosort' => true,
            'nosearch' => true,
            'joinparams' => [
                'linkfield' => 'processeddatas_id',
                'jointype' => 'child', // TODO: revoir le pb d'entité
                'condition' => "AND NEWTABLE.`itemtype1` = '" . PluginDlteamsConcernedPerson::class . "' 
                                AND NEWTABLE.`items_id1` <> 0 
                                AND NEWTABLE.`items_id1` IN (SELECT `id` FROM `" . PluginDlteamsConcernedPerson::getTable() . "` 
                                
                                WHERE `entities_id` IN (" . implode(',', array_map('intval', $_SESSION["glpiactiveentities"])) . "))",
            ],
            'forcegroupby' => true,
            'massiveaction' => false,
        ];

        return $tab;
    }

    public function showTabsContent($options = [])
    {
        parent::showTabsContent($options); // TODO: Change the autogenerated stub
    }

    public function defineTabs($options = [])
    {

        $ong = [];


        $ong = array();
        //add main tab for current object
        $this->addDefaultFormTab($ong)
//	         ->addStandardTab(PluginDlteamsProcessedDataCategory_Item::class, $ong, $options)
            ->addStandardTab(PluginDlteamsPolicieForm_Item::class, $ong, $options)
			->addStandardTab('PluginDlteamsRecord_Item', $ong, $options)
            ->addStandardTab(PluginDlteamsConcernedPerson_Item::class, $ong, $options)
            ->addStandardTab('ManualLink', $ong, $options)
            ->addStandardTab(PluginDlteamsTicket_Item::class, $ong, $options)
            ->addStandardTab('KnowbaseItem_Item', $ong, $options)
            ->addImpactTab($ong, $options)
            ->addStandardTab('Notepad', $ong, $options)
            ->addStandardTab('PluginDlteamsProcessedData_Item', $ong, $options)
            ->addStandardTab('Log', $ong, $options);

        return $ong;
    }

    function exportToDB($subItems = [])
    {
        if ($this->isNewItem()) {
            return false;
        }

        $export = $this->fields;
        return $export;
    }

    public static function importToDB(PluginDlteamsLinker $linker, $input = [], $containerId = 0, $subItems = [])
    {
        $item = new self();
        $originalId = $input['id'];
        unset($input['id']);
        $input['entities_id'] = $_POST['entities_id'];;
        $input['comment'] = str_replace(['\'', '"'], "", $input['comment']);
        $input['name'] = str_replace(['\'', '"'], "", $input['name']);
        $input['content'] = str_replace(['\'', '"'], "", $input['content']);
        $itemId = $item->add($input);
        if ($itemId === false) {
            $typeName = strtolower(self::getTypeName());
            throw new ImportFailureException(sprintf(__('failed to copy the %1$s record', 'dlteams'), $input['name']));
        }
        return $itemId;
    }

    public function deleteObsoleteItems(CommonDBTM $container, array $exclude)
    {
    }

//    public function post_addItem()
//    {
//        $this->update1NTableData(PluginDlteamsProcesseddata_ProcesseddataCategory::class, "_categories");
//        parent::post_addItem(); // TODO: Change the autogenerated stub
//    }
//
//    public function post_updateItem($history = true)
//    {
//        // Update categories
//        $this->update1NTableData(PluginDlteamsProcesseddata_ProcesseddataCategory::class, '_categories');
//        parent::post_updateItem();
//    }
//
//    public function post_getFromDB()
//    {
//        // Load categories
//        $this->load1NTableData(PluginDlteamsProcesseddata_ProcesseddataCategory::class, '_categories');
//        parent::post_getFromDB();
//    }

    public static function showMassiveActionsSubForm(MassiveAction $ma)
    {
        switch ($ma->getAction()) {
            case 'copyTo':
                Entity::dropdown([
                    'name' => 'entities_id',
                ]);
                echo '<br /><br />' . Html::submit(_x('button', 'Post'), ['name' => 'massiveaction']);
                return true;

            case 'manage_categories':
                // Étape 1 : Sélection de l'action (Ajouter/Supprimer)
                if (!isset($ma->POST['action_type'])) {
                    echo "<table width='100%'>";
                    echo "<tr><td colspan='2'><strong>" . __("Sélectionner l'action à effectuer", 'dlteams') . "</strong></td></tr>";
                    echo "<tr><td>";
                    echo "<input type='radio' name='action_type' value='add' id='action_add' checked>";
                    echo "<label for='action_add'>" . __("Ajouter une catégorie", 'dlteams') . "</label>";
                    echo "</td></tr>";
                    echo "<tr><td>";
                    echo "<input type='radio' name='action_type' value='remove' id='action_remove'>";
                    echo "<label for='action_remove'>" . __("Supprimer une catégorie", 'dlteams') . "</label>";
                    echo "</td></tr>";
                    echo "</table>";
                    echo "<br>";
                    echo Html::submit("<i class='fas fa-arrow-right'></i><span>" . __("Suivant", 'dlteams') . "</span>", [
                        'name'  => 'massiveaction',
                        'class' => 'btn btn-sm btn-primary',
                    ]);
                    return true;
                }

                // Étape 2 : Sélection de la catégorie
                if (!isset($ma->POST['category_id'])) {
                    $action_type = $ma->POST['action_type'];
                    $action_label = ($action_type == 'add') ? __("Ajouter", 'dlteams') : __("Supprimer", 'dlteams');

                    echo "<table width='100%'>";
                    echo "<tr><td colspan='2'><strong>" . sprintf(__("%s une catégorie aux données sélectionnées", 'dlteams'), $action_label) . "</strong></td></tr>";
                    echo "<tr><td>" . PluginDlteamsProcessedDataCategory::getTypeName(1) . ":</td>";
                    echo "<td>";

                    if ($action_type == 'remove') {
                        // Pour la suppression, on ne montre que les catégories déjà associées
                        $existing_categories = [];
                        foreach ($ma->items as $itemtype => $ids) {
                            foreach ($ids as $id) {
                                $item = new PluginDlteamsProcessedData();
                                if ($item->getFromDB($id)) {
                                    $item->loadCategoriesFromItemTables();
                                    if (!empty($item->fields['_categories'])) {
                                        $existing_categories = array_merge($existing_categories, $item->fields['_categories']);
                                    }
                                }
                            }
                        }
                        $existing_categories = array_unique($existing_categories);

                        if (empty($existing_categories)) {
                            echo "<div class='alert alert-warning'>";
                            echo "<i class='fas fa-exclamation-triangle'></i> ";
                            echo __("Aucune catégorie n'est associée aux données sélectionnées.", 'dlteams');
                            echo "</div>";
                            echo "<br>";
                            echo Html::submit("<i class='fas fa-times'></i><span>" . __("Annuler", 'dlteams') . "</span>", [
                                'name'  => 'massiveaction_cancel',
                                'class' => 'btn btn-sm btn-secondary',
                            ]);
                            return true;
                        }

                        PluginDlteamsProcessedDataCategory::dropdown([
                            'name' => 'category_id',
                            'condition' => ['id' => $existing_categories],
                            'display_emptychoice' => true,
                            'emptylabel' => __("Sélectionner une catégorie...", 'dlteams'),
                        ]);
                    } else {
                        // Pour l'ajout, on montre toutes les catégories disponibles
                        PluginDlteamsProcessedDataCategory::dropdown([
                            'name' => 'category_id',
                            'display_emptychoice' => true,
                            'emptylabel' => __("Sélectionner une catégorie...", 'dlteams'),
                        ]);
                    }

                    echo "</td></tr>";
                    echo "</table>";
                    echo "<br>";
                    echo Html::submit("<i class='fas fa-check'></i><span>" . __("Confirmer", 'dlteams') . "</span>", [
                        'name'  => 'massiveaction',
                        'class' => 'btn btn-sm btn-primary',
                    ]);
                    return true;
                }

                // Étape 3 : Confirmation finale
                $action_type = $ma->POST['action_type'];
                $category_id = $ma->POST['category_id'];
                $category = new PluginDlteamsProcessedDataCategory();
                $category->getFromDB($category_id);
                $category_name = $category->fields['name'] ?? "ID: $category_id";

                $action_label = ($action_type == 'add') ? __("Ajouter", 'dlteams') : __("Supprimer", 'dlteams');
                $count_items = count($ma->items, COUNT_RECURSIVE) - count($ma->items);

                echo "<div class='alert alert-info'>";
                echo "<i class='fas fa-info-circle'></i> ";
                echo sprintf(__("Vous êtes sur le point de %s la catégorie \"%s\" à %d donnée(s) traitée(s).", 'dlteams'),
                    strtolower($action_label), $category_name, $count_items);
                echo "</div>";

                echo "<table width='100%'>";
                echo "<tr><td><strong>" . __("Action:", 'dlteams') . "</strong></td>";
                echo "<td>" . $action_label . "</td></tr>";
                echo "<tr><td><strong>" . __("Catégorie:", 'dlteams') . "</strong></td>";
                echo "<td>" . $category_name . "</td></tr>";
                echo "<tr><td><strong>" . __("Nombre d'éléments:", 'dlteams') . "</strong></td>";
                echo "<td>" . $count_items . "</td></tr>";
                echo "</table>";

                echo "<br>";
                echo Html::submit("<i class='fas fa-check'></i><span>" . __("Exécuter", 'dlteams') . "</span>", [
                    'name'  => 'massiveaction',
                    'class' => 'btn btn-sm btn-success',
                ]);
                echo " ";
                echo Html::submit("<i class='fas fa-times'></i><span>" . __("Annuler", 'dlteams') . "</span>", [
                    'name'  => 'massiveaction_cancel',
                    'class' => 'btn btn-sm btn-secondary',
                ]);
                return true;
        }
        return parent::showMassiveActionsSubForm($ma);
    }

    static function processMassiveActionsForOneItemtype(MassiveAction $ma, CommonDBTM $item, array $ids)
    {
        switch ($ma->getAction()) {
            case 'copyTo':
                if ($item->getType() == 'PluginDlteamsProcessedData') {
                    foreach ($ids as $id) {
                        if ($item->getFromDB($id)) {
                            if ($item->copy1($ma->POST['entities_id'], $id, $item)) {

                                Session::addMessageAfterRedirect(sprintf(__('Record copied: %s', 'dlteams'), $item->getName()));
                                $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_OK);
                            }
                        } else {
                            // Example of ko count
                            $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_KO);
                        }
                    }
                }
                return;

            case 'manage_categories':
                if ($item->getType() == 'PluginDlteamsProcessedData') {
                    $action_type = $ma->POST['action_type'] ?? '';
                    $category_id = $ma->POST['category_id'] ?? 0;

                    if (empty($action_type) || empty($category_id)) {
                        foreach ($ids as $id) {
                            $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_KO);
                        }
                        return;
                    }

                    $category = new PluginDlteamsProcessedDataCategory();
                    if (!$category->getFromDB($category_id)) {
                        foreach ($ids as $id) {
                            $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_KO);
                        }
                        return;
                    }

                    $category_name = $category->fields['name'];
                    $success_count = 0;
                    $error_count = 0;

                    foreach ($ids as $id) {
                        if ($item->getFromDB($id)) {
                            try {
                                // Charger les catégories actuelles
                                $item->loadCategoriesFromItemTables();
                                $current_categories = $item->fields['_categories'] ?? [];

                                if ($action_type == 'add') {
                                    // Ajouter la catégorie si elle n'est pas déjà présente
                                    if (!in_array($category_id, $current_categories)) {
                                        $current_categories[] = $category_id;
                                        $item->fields['_categories'] = $current_categories;
                                        $item->saveCategoriesToItemTables();
                                        $success_count++;
                                    } else {
                                        // Catégorie déjà présente
                                        $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_OK);
                                        continue;
                                    }
                                } else if ($action_type == 'remove') {
                                    // Supprimer la catégorie si elle est présente
                                    if (in_array($category_id, $current_categories)) {
                                        $current_categories = array_diff($current_categories, [$category_id]);
                                        $item->fields['_categories'] = array_values($current_categories);
                                        $item->saveCategoriesToItemTables();
                                        $success_count++;
                                    } else {
                                        // Catégorie non présente
                                        $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_OK);
                                        continue;
                                    }
                                }

                                $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_OK);

                            } catch (Exception $e) {
                                $error_count++;
                                $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_KO);
                            }
                        } else {
                            $error_count++;
                            $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_KO);
                        }
                    }

                    // Message de résultat
                    $action_label = ($action_type == 'add') ? __("Ajoutée", 'dlteams') : __("Supprimée", 'dlteams');
                    if ($success_count > 0) {
                        Session::addMessageAfterRedirect(
                            sprintf(__("Catégorie \"%s\" %s avec succès à %d donnée(s) traitée(s).", 'dlteams'),
                                $category_name, strtolower($action_label), $success_count),
                            true, INFO
                        );
                    }
                    if ($error_count > 0) {
                        Session::addMessageAfterRedirect(
                            sprintf(__("Erreur lors du traitement de %d donnée(s) traitée(s).", 'dlteams'), $error_count),
                            true, ERROR
                        );
                    }
                }
                return;
        }
        parent::processMassiveActionsForOneItemtype($ma, $item, $ids);
    }

    public static function getMassiveActionsForItemtype(array &$actions, $itemtype, $is_deleted = false, ?CommonDBTM $checkitem = null)
    {
        if ($itemtype == 'PluginDlteamsProcessedData') {
            $action_prefix = __CLASS__ . MassiveAction::CLASS_ACTION_SEPARATOR;

            $actions[$action_prefix . 'manage_categories'] =
                "<i class='ma-icon fas fa-tags'></i>" .
                __("Ajouter/Supprimer une catégorie de données", 'dlteams');
        }

        parent::getMassiveActionsForItemtype($actions, $itemtype, $is_deleted, $checkitem);
    }


    public function copy1($entity, $id, $item)
    {
        global $DB;
        $dbu = new DbUtils();
        $name = $item->fields['name'];

        $nb = $dbu->countElementsInTable(static::getTable(), ['name' => addslashes($name), 'entities_id' => $entity]);

        if ($nb <= 0) {
            $DB->request("
                        INSERT INTO " . static::getTable() . " (
                            entities_id, 
                            is_recursive, 
                            is_deleted, 
                            is_template, 
                            template_name, 
                            name, 
                            number,
                            content, 
                            comment, 
                            rgpd_sensitive_data, 
                            seen_sensitive_data, 
                            date_mod, date_creation) 
                        SELECT '$entity', 
                                is_recursive, 
                                is_deleted, 
                                is_template, 
                                template_name, 
                                name, 
                                number,
                                content, 
                                comment, 
                                rgpd_sensitive_data, 
                                seen_sensitive_data, 
                                date_mod, 
                                date_creation 
                        FROM " . static::getTable() . " 
                        WHERE id='$id'"
            );
            return true;
        } else {
            return false;
        }
    }

    /**
     * Display processed data in central view
     *
     * @param integer $start
     * @param string  $status
     * @param boolean $showgrouptickets
     *
     * @return void
     */
    public static function showCentralList($start = 0, $status = 'process', $showgrouptickets = true)
    {
        global $DB;

        if (!Session::haveRight('plugin_dlteams_processeddata', READ)) {
            return false;
        }

        $iterator = $DB->request([
            'FROM' => self::getTable(),
            'WHERE' => [
                'entities_id' => Session::getActiveEntity()
            ],
            'ORDER' => ['date_mod DESC'],
            'LIMIT' => $_SESSION['glpidisplay_count_on_home'] ?? 10
        ]);

        $total_row_count = count($iterator);
        $displayed_row_count = min((int)$_SESSION['glpidisplay_count_on_home'], $total_row_count);

        if ($total_row_count > 0) {
            // Titre principal avec lien
            $main_header = "<a href=\"" . self::getSearchURL() . "\">" .
                Html::makeTitle(__('Recent Processed Data', 'dlteams'), $displayed_row_count, $total_row_count) . "</a>";
            
            echo "<div class='table-responsive'>";
            echo "<table class='table table-borderless table-striped table-hover card-table'>";
            echo "<thead>";
            echo "<tr>";
            echo "<th colspan='3'>" . $main_header . "</th>";
            echo "</tr>";
            echo "<tr>";
            echo "<th>" . __('ID') . "</th>";
            echo "<th>" . __('Name') . "</th>";
            echo "<th>" . __('Date modification') . "</th>";
            echo "</tr>";
            echo "</thead>";
            echo "<tbody>";

            foreach ($iterator as $data) {
                $url = self::getFormURLWithID($data['id']);
                echo "<tr>";
                echo "<td><a href='" . $url . "' class='btn btn-sm btn-outline-primary'>" . $data['id'] . "</a></td>";
                echo "<td>" . htmlspecialchars($data['name']) . "</td>";
                echo "<td class='text-muted'>" . Html::convDateTime($data['date_mod']) . "</td>";
                echo "</tr>";
            }

            echo "</tbody>";
            echo "</table>";
            echo "</div>";

            if ($total_row_count > $displayed_row_count) {
                echo "<div class='text-center mt-2'>";
                echo "<a href='" . self::getSearchURL() . "' class='btn btn-sm btn-outline-secondary'>";
                echo sprintf(__('Show all %d items'), $total_row_count);
                echo "</a>";
                echo "</div>";
            }
        } else {
            echo "<div class='text-center text-muted p-4'>";
            echo "<i class='fas fa-inbox fa-2x mb-2'></i><br>";
            echo __('No item found');
            echo "</div>";
        }
    }

}
