<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

class PluginDlteamsProfile extends Profile
{
    static $rightname = "profile";

    function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {
        if ($item->getType() == Profile::class) {
            /** @var Profile $item */
            if ($item->getField('id')
                && ($item->getField('interface') != 'helpdesk')) {
                return [
                    "Traitements",
                    "Données et accès",
                    "GRC",
                    PluginDlteamsMenu::getTypeName(2),
                ];

            }
        }
        return '';
    }

    static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {
        if ($item->getType() == Profile::class) {
            /** @var Profile $item */

            $ID = $item->getID();
            $prof = new self();
            switch ($tabnum) {
                case 0:
                    $prof->showFormRegistreTraitements($ID);
                    break;
                case 1:
                    $prof->showFormDataaccess($ID);
                    break;
                case 2:
                    $prof->showFormGRC($ID);
                    break;
                case 3:
                    $prof->showForm($ID);
                    break;

            }

        }
        return true;
    }

    public function showFormRegistreTraitements($ID, $options = [])
    {
        $profile = new Profile();
        if (($can_update = Session::haveRightsOr(self::$rightname, [CREATE, UPDATE, PURGE]))) {
            echo "<form method='post' action='" . $profile->getFormURL() . "'>";
        }

        $profile->getFromDB($ID);
        if ($profile->getField('interface') == 'central') {

            $rights = $this->getRegistreTraitementsRights();
            $profile->displayRightsChoiceMatrix($rights, [
                'canedit' => $can_update,
                'default_class' => 'tab_bg_2',
                'title' => __("General")
            ]);
        }

        if ($can_update) {
            echo "<div class='center'>";
            echo Html::hidden('id', ['value' => $ID]);
            echo Html::submit(_sx('button', 'Save'), ['name' => 'update']);
            echo "</div>\n";
            Html::closeForm();
        }
    }


    public function showFormDataaccess($ID, $options = [])
    {
        $profile = new Profile();
        if (($can_update = Session::haveRightsOr(self::$rightname, [CREATE, UPDATE, PURGE]))) {
            echo "<form method='post' action='" . $profile->getFormURL() . "'>";
        }

        $profile->getFromDB($ID);
        if ($profile->getField('interface') == 'central') {

            $rights = $this->getDataaccessRights();
            $profile->displayRightsChoiceMatrix($rights, [
                'canedit' => $can_update,
                'default_class' => 'tab_bg_2',
                'title' => __("General")
            ]);
        }

        if ($can_update) {
            echo "<div class='center'>";
            echo Html::hidden('id', ['value' => $ID]);
            echo Html::submit(_sx('button', 'Save'), ['name' => 'update']);
            echo "</div>\n";
            Html::closeForm();
        }
    }


    public function showFormGRC($ID, $options = [])
    {
        $profile = new Profile();
        if (($can_update = Session::haveRightsOr(self::$rightname, [CREATE, UPDATE, PURGE]))) {
            echo "<form method='post' action='" . $profile->getFormURL() . "'>";
        }

        $profile->getFromDB($ID);
        if ($profile->getField('interface') == 'central') {

            $rights = $this->getGRCRights();
            $profile->displayRightsChoiceMatrix($rights, [
                'canedit' => $can_update,
                'default_class' => 'tab_bg_2',
                'title' => __("General")
            ]);
        }

        if ($can_update) {
            echo "<div class='center'>";
            echo Html::hidden('id', ['value' => $ID]);
            echo Html::submit(_sx('button', 'Save'), ['name' => 'update']);
            echo "</div>\n";
            Html::closeForm();
        }
    }

    public function showForm($ID, $options = [])
    {
        $profile = new Profile();
        if (($can_update = Session::haveRightsOr(self::$rightname, [CREATE, UPDATE, PURGE]))) {
            echo "<form method='post' action='" . $profile->getFormURL() . "'>";
        }

        $profile->getFromDB($ID);
        if ($profile->getField('interface') == 'central') {

            $rights = $this->getAllRights();
            $profile->displayRightsChoiceMatrix($rights, [
                'canedit' => $can_update,
                'default_class' => 'tab_bg_2',
                'title' => __("General")
            ]);
        }

        if ($can_update) {
            echo "<div class='center'>";
            echo Html::hidden('id', ['value' => $ID]);
            echo Html::submit(_sx('button', 'Save'), ['name' => 'update']);
            echo "</div>\n";
            Html::closeForm();
        }
    }

    static function addDefaultProfileInfos($profiles_id, $rights, $drop_existing = false)
    {
        $profileRight = new ProfileRight();
        $dbu = new DbUtils();
        foreach ($rights as $right => $value) {
            if ($dbu->countElementsInTable('glpi_profilerights', [
                    'profiles_id' => $profiles_id,
                    'name' => $right
                ])
                && $drop_existing) {

                $profileRight->deleteByCriteria([
                    'profiles_id' => $profiles_id,
                    'name' => $right]);
            }

            if (!$dbu->countElementsInTable('glpi_profilerights', [
                'profiles_id' => $profiles_id,
                'name' => $right])) {
                $myright['profiles_id'] = $profiles_id;
                $myright['name'] = $right;
                $myright['rights'] = $value;
                $profileRight->add($myright);

                $_SESSION['glpiactiveprofile'][$right] = $value;
            }
        }
    }

    static function createFirstAccess($ID)
    {
        self::addDefaultProfileInfos($ID, [
            'plugin_dlteams_controllerinfo' => CREATE | READ | UPDATE,
            'plugin_dlteams_createpdf' => CREATE,
            /* les objets*/
            'plugin_dlteams_accountkey' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_record' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_concernedperson' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_processeddata' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_legalbasi' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_storageperiod' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_thirdpartycategory' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_rightmeasure' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_policieform' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_datacarrier' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_datacatalog' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_appliance' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_account' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_networkport' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_riskassessment' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_audit' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_protectivemeasure' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_trainingcertification' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_trainingsession' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_deliverable' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_fichierhtml' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_knowbaseitem' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_step' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_procedure' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_physicalstorage' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_vehicle' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'knowbase' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            /* les intitulés*/
            'plugin_dlteams_activitycategory' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_policieformcategrory' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_auditcategory' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_catalogclassification' => CREATE | READ | UPDATE | DELETE | PURGE,
            'plugin_dlteams_datacarriercategory' => CREATE | READ | UPDATE | DELETE | PURGE,
            'plugin_dlteams_datacarrierhosting' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_datacarriermanagement' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_datacarriertype' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_deliverablevariable' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_procedurevariable' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_datacategory' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_impact' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_keytype' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_legalbasistype' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_meansofacce' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_mediasupport' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_protectivecategory' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_protectivetype' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_rightmeasurecategory' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_sendingreason' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_servertype' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_siintegration' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_storageendaction' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_storagetype' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_transmissionmethod' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_userprofile' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_process' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_storageunittype' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_tickettask' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_vehicletype' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_menu' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_iso27001menu' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_accessopening' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_itilfollowup' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_rgpdadequacy' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_documentrgpd' => CREATE | READ | UPDATE | DELETE | PURGE | READNOTE | UPDATENOTE,
            'plugin_dlteams_form' => READ,
            'plugin_dlteams_message' => READ | DELETE | PURGE | READNOTE | UPDATENOTE,

//          autres
            'plugin_reports_dlteams_record' => READ,
            'plugin_reports_dlteams_datacatalog' => READ,
            'plugin_reports_dlteams_asset' => READ,
        ], true);
    }

    static function getAllRights($all = false)
    {
        // Définir les ensembles de droits courants
        $commonRights = [
            CREATE => __("Create"),
            READ => __("Read"),
            UPDATE => __("Update"),
            DELETE => __("Delete"),
            PURGE => __("Delete permanently"),
            READNOTE => __("Read notes"),
            UPDATENOTE => __("Update notes"),
        ];

        $basicRights = [
            CREATE => __("Create"),
            READ => __("Read"),
            UPDATE => __("Update"),
        ];

        // Liste des droits
        $items = [
            PluginDlteamsControllerInfo::class => [
                'rights' => $basicRights
            ],
            PluginDlteamsPublish::class => [
                'rights' => [CREATE => __("Create")]
            ],
            PluginDlteamsAccountKey::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsRecord::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsConcernedPerson::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsProcessedData::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsLegalbasi::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsStoragePeriod::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsThirdPartyCategory::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsRightMeasure::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsPolicieForm::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsDataCarrier::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsDataCatalog::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsTicketTask::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsAppliance::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsAccount::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsNetworkPort::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsRiskAssessment::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsAudit::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsPhysicalStorage::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsProtectiveMeasure::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsTrainingCertification::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsTrainingSession::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsDeliverable::class => [
                'rights' => $commonRights
            ],
//            PluginDlteamsFichierHTML::class => [
//                'rights' => $commonRights
//            ],
            PluginDlteamsKnowbaseItem::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsProcedure::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsITILFollowup::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsStep::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsVehicle::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsAuditCategory::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsCatalogClassification::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsDataCarrierCategory::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsDataCarrierHosting::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsDataCarrierManagement::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsDataCarrierType::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsDeliverable_Variable::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsProcedure_Variable::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsDataCategory::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsImpact::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsKeytype::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsLegalBasisType::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsMeansOfAcce::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsAccessOpening::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsMediaSupport::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsProtectiveCategory::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsProtectiveType::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsActivityCategory::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsRightMeasureCategory::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsProcessedDataCategory::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsConcernedPersonCategory::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsPolicieFormCategory::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsSendingReason::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsServerType::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsSIIntegration::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsStorageEndAction::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsStoragetype::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsTransmissionMethod::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsUserprofile::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsProcess::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsVehicleType::class => [
                'rights' => $commonRights
            ],

            PluginDlteamsRgpdAdequacy::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsForm::class => [
                'rights' => [READ => __("Read")]
            ],
            PluginDlteamsDocumentRGPD::class => [
                'rights' => $commonRights
            ],
            PluginDlteamsTicketTask_Validation::class => [
                'rights' => $commonRights
            ],

            PluginDlteamsMessage::class => [
                'rights' => [
                    READ => __("Read"),
                    DELETE => __("Delete"),
                    PURGE => __("Delete permanently"),
                    READNOTE => __("Read notes"),
                    UPDATENOTE => __("Update notes"),
                ]
            ],
            KnowbaseItem::class => [
                'rights' => $commonRights
            ],
        ];

        // Construction dynamique des droits
        $rights = [];
        foreach ($items as $class => $data) {
            if (class_exists($class))
                $rights[] = [
                    'itemtype' => $class,
                    'label' => $class::getTypeName(2),
                    'field' => $class::$rightname,
                    'rights' => $data['rights'],
                ];
        }

        // Ajouter des cas spécifiques si nécessaire
        $rights[] = [
            'field' => 'plugin_reports_dlteams_record',
            'rights' => $basicRights
        ];

        $rights[] = [
            'field' => 'plugin_reports_dlteams_datacatalog',
            'rights' => $basicRights
        ];

        $rights[] = [
            'field' => 'plugin_reports_dlteams_asset',
            'rights' => $basicRights
        ];

        return $rights;
    }


    static function getRegistreTraitementsRights($all = false)
    {
        // Définir les ensembles de droits courants
        $commonRights = [
            CREATE => __("Create"),
            READ => __("Read"),
            UPDATE => __("Update"),
            DELETE => __("Delete"),
            PURGE => __("Delete permanently"),
            READNOTE => __("Read notes"),
            UPDATENOTE => __("Update notes"),
        ];

        $basicRights = [
            CREATE => __("Create"),
            READ => __("Read"),
            UPDATE => __("Update"),
        ];

        // Liste des droits
        $items = [
            PluginDlteamsRecord::class => [
                'rights' => $basicRights
            ],
            PluginDlteamsConcernedPerson::class => [
                'rights' => $basicRights
            ],
            PluginDlteamsProcessedData::class => [
                'rights' => $basicRights
            ],
            PluginDlteamsLegalbasi::class => [
                'rights' => $basicRights
            ],
            PluginDlteamsStoragePeriod::class => [
                'rights' => $basicRights
            ],
            PluginDlteamsThirdPartyCategory::class => [
                'rights' => $basicRights
            ],
            PluginDlteamsRightMeasure::class => [
                'rights' => $basicRights
            ],
            PluginDlteamsPolicieForm::class => [
                'rights' => $basicRights
            ],


        ];

        // Construction dynamique des droits
        $rights = [];
        foreach ($items as $class => $data) {
            $rights[] = [
                'itemtype' => $class,
                'label' => $class::getTypeName(2),
                'field' => $class::$rightname,
                'rights' => $data['rights'],
            ];
        }

        // Ajouter des cas spécifiques si nécessaire
//        $rights[] = [
//            'field' => 'plugin_reports_dlteams_record',
//            'rights' => $basicRights
//        ];
//        $rights[] = [
//            'field' => 'plugin_reports_dlteams_asset',
//            'rights' => $basicRights
//        ];

        return $rights;
    }

    static function getDataaccessRights($all = false)
    {
        // Définir les ensembles de droits courants
        $commonRights = [
            CREATE => __("Create"),
            READ => __("Read"),
            UPDATE => __("Update"),
            DELETE => __("Delete"),
            PURGE => __("Delete permanently"),
            READNOTE => __("Read notes"),
            UPDATENOTE => __("Update notes"),
        ];

        $basicRights = [
            CREATE => __("Create"),
            READ => __("Read"),
            UPDATE => __("Update"),
        ];

        // Liste des droits
        $items = [
            PluginDlteamsDataCatalog::class => [
                'rights' => $basicRights
            ],
            PluginDlteamsPolicieForm::class => [
                'rights' => $basicRights
            ],
            Database::class => [
                'rights' => $basicRights
            ],
            Appliance::class => [
                'rights' => $basicRights
            ],
            PluginDlteamsAccountKey::class => [
                'rights' => $basicRights
            ],
            PluginDlteamsMeansOfAcce::class => [
                'rights' => $basicRights
            ],
            Location::class => [
                'rights' => $basicRights
            ],
        ];

        // Construction dynamique des droits
        $rights = [];
        foreach ($items as $class => $data) {
            $rights[] = [
                'itemtype' => $class,
                'label' => $class::getTypeName(2),
                'field' => $class::$rightname,
                'rights' => $data['rights'],
            ];
        }

        // Ajouter des cas spécifiques si nécessaire
//        $rights[] = [
//            'field' => 'plugin_reports_dlteams_record',
//            'rights' => $basicRights
//        ];
//        $rights[] = [
//            'field' => 'plugin_reports_dlteams_asset',
//            'rights' => $basicRights
//        ];

        return $rights;
    }


    static function getGRCRights($all = false)
    {
        // Définir les ensembles de droits courants
        $commonRights = [
            CREATE => __("Create"),
            READ => __("Read"),
            UPDATE => __("Update"),
            DELETE => __("Delete"),
            PURGE => __("Delete permanently"),
            READNOTE => __("Read notes"),
            UPDATENOTE => __("Update notes"),
        ];

        $basicRights = [
            CREATE => __("Create"),
            READ => __("Read"),
            UPDATE => __("Update"),
        ];

        // Liste des droits
        $items = [
            PluginDlteamsRiskAssessment::class => [
                'rights' => $basicRights
            ],
            PluginDlteamsProtectiveMeasure::class => [
                'rights' => $basicRights
            ],
        ];

        // Construction dynamique des droits
        $rights = [];
        foreach ($items as $class => $data) {
            $rights[] = [
                'itemtype' => $class,
                'label' => $class::getTypeName(2),
                'field' => $class::$rightname,
                'rights' => $data['rights'],
            ];
        }

        return $rights;
    }

    static function removeRightsFromSession()
    {
        foreach (self::getAllRights(true) as $right) {
            if (isset($_SESSION['glpiactiveprofile'][$right['field']])) {
                unset($_SESSION['glpiactiveprofile'][$right['field']]);
            }
        }
    }

    static function initProfile()
    {
        global $DB;
        $profile = new self();
        foreach ($profile->getAllRights() as $data) {

            if (countElementsInTable('glpi_profilerights', ['name' => $data['field']]) == 0) {
                ProfileRight::addProfileRights([$data['field']]);
            }
        }

        $profiles = $DB->request(
            "SELECT *
          FROM `glpi_profilerights`
          WHERE `profiles_id`='" . $_SESSION['glpiactiveprofile']['id'] . "'
            AND `name` LIKE 'plugin_dlteams_%' OR `name` LIKE 'plugin_reports_dlteams_%'"
        );

        foreach ($profiles as $prof) {
            $_SESSION['glpiactiveprofile'][$prof['name']] = $prof['rights'];
        }


    }

}
