<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */


use GlpiPlugin\dlteams\Exception\ImportFailureException;

class PluginDlteamsRecord_Item extends PluginDlteamsObjectCollection
{
    static public $itemtype_2 = 'PluginDlteamsRecord';
    static public $itemtype_1;
    public static $items_id_1;
    public static $title;
    public static $sub_title;
    public static $table_match_str = [];

    protected $orderColumn = "timeline_position";

    public function __construct()
    {

        static::$itemtype_1 = str_replace("_Item", "", __CLASS__); // $itemtype_1 ---> PluginDlteamsRecord
        static::$items_id_1 = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", __CLASS__))) . "s_id";
		static::$title = __("Traitements en relation avec cet objet", 'dlteams');        
        if (Group::class) {static::$title = "Traitements en relation avec ce groupe";}
		static::$sub_title = __("Choisir un nouveau traitement à lier", 'dlteams');
        static::$table_match_str = [
            [
                'head_text' => __("Name"),
                'column_name' => 'name',
                'show_as_link' => true
            ],
            [
                'head_text' => __("Content"),
                'column_name' => 'content',
            ],
            [
                'head_text' => __("Comment"),
                'column_name' => 'comment',
            ]
        ];
        parent::__construct();
    }

    static function canCreate()
    {
        return true;
    }

    static function canView()
    {
        return true;
    }

    static function canUpdate()
    {
        return true;
    }

    static function canDelete()
    {
        return true;
    }

    static function canPurge()
    {
        return true;
    }

    function canCreateItem()
    {
        return true;
    }

    function canViewItem()
    {
        return true;
    }

    function canUpdateItem()
    {
        return true;
    }

    function canDeleteItem()
    {
        return true;
    }

    function canPurgeItem()
    {
        return true;
    }

    static function getTypeName($nb = 0)
    {
        return _n("Processing Activity", "Processing Activities", $nb, 'dlteams');
    }


    /**
     * Réordonne ce record_item selon les index front (0-based).
     *
     * @param int $oldIndex0 Ancien index envoyé par le front (0-based)
     * @param int $newIndex0 Nouvel index envoyé par le front (0-based)
     * @param string $direction MOVE_BEFORE ou MOVE_AFTER
     * @return bool
     */
    public function reorder(int $oldIndex0, int $newIndex0, string $direction): bool
    {
        // on charge l'objet parent nécessaire à getRequest()
        $parent = new PluginDlteamsRecord();
        $parent->getFromDB((int)$this->fields['records_id']);

        // on délègue au générique
        return $this->reorderByIndex(
            $oldIndex0,
            $newIndex0,
            $direction,
            PluginDlteamsRecord_PersonalAndDataCategory::class,
            'getRequest',
            [$parent],
            true
        );
    }

    static function getTypeNameForClass($nb = 0)
    {
        return __("Associated items", 'dlteams');
    }

    public static function getFormURLWithID($id = 0, $full = true)
    {
        $itemtype = PluginDlteamsRecord::class;
        $itemtype_item = new PluginDlteamsRecord_Item();
        $itemtype_item->getFromDB($id);
        $link = $itemtype::getFormURL($full);
        $link .= (strpos($link, '?') ? '&' : '?') . 'id=' . $itemtype_item->fields["records_id"];
        return $link;
    }

    // affichage de l'onglet et de son nom
    public function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {
        switch ($item->getType()) {
            case 'PluginDlteamsRecord':
                if (!$withtemplate) {
                    if (Session::haveRight($item::$rightname, READ)) {
                        if ($_SESSION['glpishow_count_on_tabs']) {
                            return static::createTabEntry(static::getTypeNameForClass(), static::countForItem($item));
                        }
                        return static::getTypeNameForClass();
                    }
                }
                break;
            case PluginDlteamsProcessedData::class:
                if (!$withtemplate) {
                    if (Session::haveRight($item::$rightname, READ)) {
                        if ($_SESSION['glpishow_count_on_tabs']) {
                            $iterator = static::getProcesseddataRequest($item);
                            $count = 0;
                            $previousrecords_id = 0;
                            foreach ($iterator as $data) {

                                if ($previousrecords_id != $data["records_id"])
                                    $count++;

                                $previousrecords_id = $data["records_id"];
                            }
                            return static::createTabEntry(static::getTypeName(2), $count);
                        }
                        return static::getTypeName(2);
                    }
                }
                break;
            case PluginDlteamsConcernedPerson::class:
                $ong = [];
                if (!$withtemplate) {
                    if (Session::haveRight($item::$rightname, READ)) {
                        if ($_SESSION['glpishow_count_on_tabs']) {
                            $ong[] = static::createTabEntry(PluginDlteamsProcessedData::getTypeName(2), count(static::getRequest($item)));
                            $ong[] = static::createTabEntry(PluginDlteamsRecord::getTypeName(2), count(static::getRecordsRequest($item)));
                        }
                    }

                }

                return $ong;
                break;
            default:
                if (!$withtemplate) {
                    if (Session::haveRight($item::$rightname, READ)) {
                        if ($_SESSION['glpishow_count_on_tabs']) {
                            return static::createTabEntry(static::getTypeName(2), count(static::getRequest($item)));
                        }
                        return static::getTypeName(2);
                    }
                }
                break;
        }

        return '';
    }

    // comptage du nombre de liaison entre les 2 objets dans la table de l'objet courant
    static function countForItem(CommonDBTM $item)
    {
        $dbu = new DbUtils();
        return $dbu->countElementsInTable(static::getTable(), ['items_id' => $item->getID(), 'itemtype' => $item->getType()]);
    }


    public static function getItemsRequest(CommonDBTM $object_item)
    {
        global $DB;
        $link_table = str_replace("_Item", "", __CLASS__);
        $temp = new $link_table();
        //var_dump ($link_table, static::getTable(), $temp->getTable());
        $items = $DB->request([
            'FROM' => self::getTable(),
            'SELECT' => [
                self::getTable() . '.id',
                self::getTable() . '.id as linkid',
                self::getTable() . '.comment',
                self::getTable() . '.itemtype as itemtype',
                self::getTable() . '.items_id as items_id',
            ],
            'WHERE' => [
                static::getTable() . '.' . static::$items_id_1 => $object_item->fields['id']
            ],
            'LEFT JOIN' => [
                $temp->getTable() => [
                    'FKEY' => [
                        static::getTable() => static::$items_id_1,
                        $temp->getTable() => 'id'
                    ]
                ]
            ],
//            'ORDER' => self::getTable() . '.id DESC',
            'ORDER' => [$temp->getTable() . '.name ASC', self::getTable() . '.itemtype ASC'],
        ]);

        return iterator_to_array($items);
    }


    public function defineTabs($options = [])
    {
        $ong = [];
        $this->addDefaultFormTab($ong);
        $this->addImpactTab($ong, $options);
        return $ong;
    }

    public static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {
        switch ($item->getType()) {
            case static::$itemtype_2:
                self::showItems($item);
                self::showRelatedPolicieformDatacarrierItem($item);
                break;
            case PluginDlteamsProcessedData::class:
                self::showRecordProcessedData($item);
                break;
            case PluginDlteamsConcernedPerson::class:
                if ($tabnum == 0)
                    self::showForItem($item);
                if ($tabnum == 1)
                    self::showRecodsForItem($item);
                break;
            default:
                self::showForItem($item);
                break;
        }
    }

    public static function getSpecificValueToDisplay($field, $values, array $options = [])
    {
        if (!is_array($values)) {
            $values = [$field => $values];
        }

        if (isset($options["searchopt"]["showpolicies"])) {
            $record = new PluginDlteamsPolicieForm();
            if ($record->getFromDB($values["items_id"])) {
                $url = PluginDlteamsRecord::getFormURLWithID($values["items_id"]);
                return "<a href='$url' target='_blank'>" . $record->fields["name"] . ";</a>";
            }
            return;
        }

        if (isset($options["searchopt"]["showconcernedPerson"])) {
            $concernedPerson = new PluginDlteamsConcernedPerson();
//            die();
            if ($concernedPerson->getFromDB($values["items_id"])) {
                $url = PluginDlteamsConcernedPerson::getFormURLWithID($values["items_id"]);
                return "<a href='$url' target='_blank'>" . $concernedPerson->fields["name"] . ";</a>";
            }
            return;
        }

        if (isset($options["searchopt"]["showprocessedData"])) {
            $processedData = new PluginDlteamsProcessedData();
            if ($processedData->getFromDB($values["items_id1"])) {
                $url = PluginDlteamsProcessedData::getFormURLWithID($values["items_id1"]);
                return "<a href='$url' target='_blank'>" . $processedData->fields["name"] . ";</a>";
            }
            return;
        }

        if (isset($options["searchopt"]["showstoragePeriod"])) {
            $storagePeriod = new PluginDlteamsStoragePeriod();
            if ($storagePeriod->getFromDB($values["items_id"])) {
                $url = PluginDlteamsStoragePeriod::getFormURLWithID($values["items_id"]);
                return "<a href='$url' target='_blank'>" . $storagePeriod->fields["name"] . ";</a>";
            }
            return;
        }

        if (isset($options["searchopt"]["showLegaBasi"])) {
            $legalBasi = new PluginDlteamsLegalbasi();
            if ($legalBasi->getFromDB($values["items_id"])) {
                $url = PluginDlteamsLegalbasi::getFormURLWithID($values["items_id"]);
                return "<a href='$url' target='_blank'>" . $legalBasi->fields["name"] . ";</a>";
            }
            return;
        }

        return parent::getSpecificValueToDisplay($field, $values, $options);
    }

    public static function showRecordProcessedData(PluginDlteamsProcessedData $processedData)
    {

        $id = $processedData->fields['id'];
        $canedit = $processedData->can($id, UPDATE); // canedit booleen = true
        $rand = mt_rand(1, mt_getrandmax());

        $iterator = static::getProcesseddataRequest($processedData);
        $items_list = [];
        $used = [];

        //while ($data = $iterator->next()) {
        foreach ($iterator as $id => $data) {
            $items_list[$data['linkid']] = $data;
            $used[$data['id']] = $data['id'];
        }

        $canedit = false;

        echo "<table class='tab_cadre_fixehov'>
            <tr>
                " . ($canedit ? "<th width='10'>" . Html::getCheckAllAsCheckbox('mass' . __class__ . $rand) . "</th>" : "") . "
                <th>" . _n("Traitement", "Traitements", 0, 'dlteams') . "</th>
                <th>" . _n("Concerned person", "Concerned persons", 0, 'dlteams') . "</th>";
        echo "<th>" . __("Mandatory", 'dlteams') . "</th>";
//                echo "<th>" . __("GDPR Sensitive", 'dlteams') . "</th>";
        echo "</tr>";
        $previousrecords_id = 0;
        foreach ($items_list as $data) {

            if ($previousrecords_id == $data["records_id"])
                $recordtext = "----";
            else
                $recordtext = PluginDlteamsRecord_PersonalAndDataCategory::getItemLinkWithNumber($data, PluginDlteamsRecord::class, 'records_id', "", true);
            echo "<tr>
                " . ($canedit ? "<td>" . Html::getMassiveActionCheckBox(__class__, $data['linkid']) . "</td>" : "") . "
                <td>" . $recordtext . "</td>
                <td>" . PluginDlteamsRecord_PersonalAndDataCategory::getItemLinkWithNumber($data, 'itemtype', 'items_id', "") . "</td>";
            echo "<td>" . ($data['mandatory'] ? __('Yes') : __('No')) . "</td>";
//                echo "<td>" . ($data['rgpd_sensitive_data'] ? __('Yes') : __('No')) . "</td>";
            echo "</tr>";
            $previousrecords_id = $data["records_id"];
        }
        echo "</table>";

    }

    public static function showRelatedPolicieformDatacarrierItem(PluginDlteamsRecord $record)
    {

        $policieforms_iterator = PluginDlteamsRecord_Element::getPolicyFormRequest($record);


        echo "<table style='margin-top: 1.5rem' class='tab_cadre_fixe'>";
        echo "<tr class='tab_bg_2'><th style='text-align:left!important'>" . __("Autres types de données (comptables, commerciales, ...) des jeux de données", 'dlteams') . "</th></tr>";
        echo "</table>";


        foreach ($policieforms_iterator as $policieform_item) {
            $pf = new PluginDlteamsPolicieForm();
            $pf->getFromDB($policieform_item["policieforms_id"]);


            echo "<table style='margin-top: 0.2rem; margin-bottom: 0.2rem' class='tab_cadre_fixe'>";
            echo "<tr class='tab_bg_2'><th style='text-align:left!important'>" . $pf->fields["name"] . "</th></tr>";
            echo "</table>";
            $pf->ShowDatacarrierType($policieform_item["policieforms_id"], true);
        }
    }

    /**
     * Show items links to a document
     *
     * @param $doc Document object
     *
     * @return void
     **@since 0.84
     *
     */
    public static function showItems(PluginDlteamsRecord $object_item)
    {
        global $DB;

        $instID = $object_item->fields['id'];
        if (!$object_item->can($instID, READ)) {
            return false;
        }
        $canedit = $object_item->can($instID, UPDATE);
        $types_iterator = [];
        $number = count($types_iterator);

        $rand = mt_rand();
        if ($canedit) {
            echo "<form name='recorditem_form$rand' id='recorditem_form$rand' method='post'
            action='" . Toolbox::getItemTypeFormURL(__CLASS__) . "'>";
            echo "<input type='hidden' name='" . static::$items_id_1 . "' value='$instID'>";
            echo "<input type='hidden' name='itemtype1' value='" . str_replace("_Item", "", __CLASS__) . "'>";
            echo "<input type='hidden' name='items_id1' value='" . $instID . "'>";

            echo "<table class='tab_cadre_fixe'>";
            $title = "Elément copié depuis un modèle";
//                $entitled = "Associated items";
            echo "<tr class='tab_bg_2'><th colspan='3'>" . __($title, 'dlteams') .
                "</th>";
            echo "</tr>";

//                echo "<tr class='tab_bg_1'><td class='right' style='text-wrap: nowrap;' width='40%'>" . __($entitled, 'dlteams');
//                echo "</td><td width='40%' class='left'>";
//                $types = PluginDlteamsItemType::getTypes();
//                $key = array_search("PluginDlteamsLegalBasi", $types);
//                unset($types[$key]);
//                echo "<div style='display: flex; gap: 4px;'>";
//                Dropdown::showSelectItemFromItemtypes(['itemtypes' => $types,
//                    'entity_restrict' => ($object_item->fields['is_recursive'] ? getSonsOf('glpi_entities', $object_item->fields['entities_id'])
//                        : $object_item->fields['entities_id']),
//                    'checkright' => true,
//                    'used' => $used,
//                    'ajax_page' => "/marketplace/dlteams/ajax/dlteamsDropdownAllItem.php"
//                ]);
//                echo "</div>";
//                unset($types);
//                echo "</td><td width='20%' class='left'>";
//                echo "</td></tr>";

            echo "<tr class='tab_bg_1'>";
            echo "<td>" . __("Entité");
            echo "</td>";
            echo "<td class='left comment-td'>";
            echo __("Id");
            echo "</td>";
            echo "<td class='left'>";
            echo __("Date");
            echo "</td>";
            echo "<td class='left'>";
            echo "</td>";
            echo "</tr>";
            echo "<style>
                .comment-td {width: 40%;}
                @media (max-width: 767px) {.comment-td {width: 100%;}}
              </style>";

            echo "<tr class='tab_bg_1' id='field_submit'><td>";
            if (isset($item->fields["entity_model"]) && $item->fields["entity_model"]) {
                $entity = new Entity();
                $entity->getFromDB($item->fields["entity_model"]);
                echo $entity->fields["name"];
            } else
                echo "---";
            echo "</td>";
            echo "<td class='left'>";

            if (isset($item->fields["date_majmodel"]) && $item->fields["date_majmodel"]) {
                Html::convDate($item->fields["date_majmodel"]);
            } else
                echo "---";

            echo "</td>";
            echo "<td  class='left'>";
            if (isset($item->fields["id_model"]) && $item->fields["id_model"]) {
                $itemtype_str = $item::getType();

                $itemtype = new $itemtype_str();
                $itemtype->getFromDB($item->fields["id_model"]);
                echo $itemtype->fields["name"];
            } else
                echo "---";
            echo "</td>";
            echo "<td class='left'>";

            echo "<div style='display: flex; gap: 4px;'>";
            echo "<input for='recorditem_form$rand' type='submit' name='add' value=\"" . _sx('button', 'Add') . "\" class='submit'>";
            echo "</div>";
            echo "</td>";
            echo "</tr>";

            echo "</table>";
            Html::closeForm();
        }


//


        $used = [];
        $types = PluginDlteamsItemType::getTypes();
//        Enlève le choix de L'objet LegalBasi dans la dropdown qui affiche la liste des objets
        $key = array_search("PluginDlteamsRecord", $types);

//
        unset($types[$key]);
        $rand = mt_rand();

        if ($canedit) {
            echo "<form name='recorditem_form$rand' id='recorditem_form$rand' method='post'
            action='" . Toolbox::getItemTypeFormURL(__CLASS__) . "'>";
            echo "<input type='hidden' name='" . static::$items_id_1 . "' value='$instID'>";
            echo "<input type='hidden' name='itemtype1' value='" . str_replace("_Item", "", __CLASS__) . "'>";
            echo "<input type='hidden' name='items_id1' value='" . $instID . "'>";

            echo "<table class='tab_cadre_fixe'>";
            $title = "Ajouter une relation / Créer un élément et le relier";
            $entitled = "Associated items";
            echo "<tr class='tab_bg_2'><th colspan='3'>" . __($title, 'dlteams') .
                "</th>";
            echo "</tr>";

            echo "<tr class='tab_bg_1'><td class='right' style='text-wrap: nowrap;' width='40%'>" . __($entitled, 'dlteams');
            echo "</td><td width='40%' class='left'>";
            $types = PluginDlteamsItemType::getTypes();
            $key = array_search("PluginDlteamsLegalBasi", $types);
            unset($types[$key]);
            echo "<div style='display: flex; gap: 4px;'>";
            Dropdown::showSelectItemFromItemtypes(['itemtypes' => $types,
                'entity_restrict' => ($object_item->fields['is_recursive'] ? getSonsOf('glpi_entities', $object_item->fields['entities_id'])
                    : $object_item->fields['entities_id']),
                'checkright' => true,
                'used' => $used,
                'ajax_page' => "/marketplace/dlteams/ajax/dlteamsDropdownAllItem.php"
            ]);
            echo "</div>";
            unset($types);
            echo "</td><td width='20%' class='left'>";
            echo "</td></tr>";

            echo "<tr class='tab_bg_1' style='display: none' id='field_comment'><td class='right' width='40%'>" . __("Comment");
            echo "</td><td width='40%' class='left comment-td'>";
            echo "<div style='display: flex; gap: 4px;'>";
            echo "<textarea type='text' style='width:100%' maxlength=1000 rows='3' name='comment' class='comment'></textarea>";
            echo "</div>";
            echo "</td><td width='20%' class='left'>";
            echo "</td></tr>";
            echo "<style>
                    .comment-td {width: 40%;}
                    @media (max-width: 767px) {.comment-td {width: 100%;}}
                  </style>";

            echo "<tr class='tab_bg_1' style='display: none' id='field_submit'><td class='right' width='40%'>";
            echo "</td><td width='40%' class='left'>";

            echo "<div style='display: flex; gap: 4px;'>";
            echo "<input for='recorditem_form$rand' type='submit' name='add' value=\"" . _sx('button', 'Add') . "\" class='submit'>";
            echo "</div>";
            echo "</td><td width='20%' class='left'>";
            echo "</td></tr>";

            echo "</table>";
            Html::closeForm();
        }

        echo "<script>
                $(document).ready(function(e){
                    $(document).on('change', 'select[name=items_id]', function () {
                        if($(this).val() != '0'){
                            $('#field_submit').css('display', 'revert');
                            $('#field_comment').css('display', 'revert');
                            
                            $.ajax({
                                url: '/marketplace/dlteams/ajax/get_object_specific_field.php',
                                type: 'POST',
                                data: {
                                    id: $(this).val(),
                                    object: $('select[name=itemtype]').val(),
                                    field: 'content'
                                },
                                success: function (data) {
                                    // Handle the returned data here
                                    let comm_field = $('textarea[name=comment]');
                                    comm_field.val(data);
                                    comm_field.val(comm_field.val().replace(/^\s+/, ''));
                                }
                            });  
                        } else {
                            $('textarea[name=comment]').val('');
                            $('#field_submit').css('display', 'none');
                            $('#field_comment').css('display', 'none');   
                        }
                    });
                });
        </script>";

//        var_dump(self::getTable());
        $items = self::getItemsRequest($object_item);

        if (!count($items)) {
            echo "<table class='tab_cadre_fixe'><tr><th>" . __('No item found') . "</th></tr>";
            echo "</table>";
        } else {
            if ($canedit) {
                Html::openMassiveActionsForm('mass' . __CLASS__ . $rand);
                $massiveactionparams = [
                    'num_displayed' => min($_SESSION['glpilist_limit'], count($items)),
                    'container' => 'mass' . __CLASS__ . $rand
                ];
                Html::showMassiveActions($massiveactionparams);
            }

            echo "<table class='tab_cadre_fixehov'>";
            $header = "<tr>";
            if ($canedit) {
                $header .= "<th width='10'>";
                $header .= Html::getCheckAllAsCheckbox('mass' . __CLASS__ . $rand);
                $header .= "</th>";
            }
            $header .= "<th>" . __("Element") . "</th>";
            $header .= "<th>" . __("Objet") . "</th>";
            $header .= "<th>" . __("Comment") . "</th>";
            $header .= "</tr>";
            echo $header;

            foreach ($items as $row) {
                $item = new $row['itemtype'](); //plante si itemtype is null
                $item->getFromDB($row['items_id']);
                $name = "<a target='_blank' href=\"" . $item::getFormURLWithID($item->getField('id')) . "\">" . $item->getField('name') . "</a>";
                echo "<tr lass='tab_bg_1'>";
                if ($canedit) {
                    echo "<td>";
                    Html::showMassiveActionCheckBox(__CLASS__, $row["id"]);
                    echo "</td>";
                }
                echo "<td>" . $name . "</td>";
                echo "<td>" . $row["itemtype"]::getTypeName() . "</td>";
                echo "<td>" . htmlspecialchars_decode($row['comment'] ?? "") . "</td>";
                echo "</tr>";
            }
            echo $header;
            echo "</table>";

            if ($canedit && count($items)) {
                $massiveactionparams['ontop'] = false;
                Html::showMassiveActions($massiveactionparams);
            }
            if ($canedit) {
                Html::closeForm();
            }

        }
    }

    public static function showMassiveActionsSubForm(MassiveAction $ma)
    {

        switch ($ma->getAction()) {
            case 'assign_as_record_acteur':
                echo "<tr class='tab_bg_1'><td width='24%' style='display: flex; align-items: center; gap: 5px'>";
                PluginDlteamsRecord::dropdown([
                    "name" => "records_id",
                    "addicon" => PluginDlteamsRecord::canCreate(),
                    "width" => "150px",
                    "used" => [],
                ]);

                echo "</td>";

                echo '<br /><br />' . Html::submit(_x('button', 'Post'), ['name' => 'massiveaction']);
                return true;
                break;
        }
        return parent::showMassiveActionsSubForm($ma); // TODO: Change the autogenerated stub
    }

    public static function processMassiveActionsForOneItemtype(MassiveAction $ma, CommonDBTM $item, array $ids)
    {
        global $DB;
        $DB->beginTransaction();
        switch ($ma->getAction()) {
            case 'assign_as_record_acteur':
                foreach ($ids as $id) {
                    $user_item = new PluginDlteamsUser_Item();
                    $array1 = [
                        "users_id" => $id,
                        "itemtype" => PluginDlteamsRecord::class,
                        "items_id" => $ma->POST["records_id"],
                    ];
                    $user_item->add($array1);

                    $record_item = new PluginDlteamsRecord_Item();
                    $array_2 = [
                        "records_id" => $ma->POST["records_id"],
                        "itemtype" => User::class,
                        "items_id" => $id,
                        "users_id_actor" => $id
                    ];
                    if (!$record_item->getFromDBByCrit($array_2)) {

                        $record_item->add($array_2);
                        Session::addMessageAfterRedirect("Opération éffectué avec succès");
                        $DB->commit();
                    } else {
                        Session::addMessageAfterRedirect("Cet utilisateur est déjà acteur de ce traitement", true, ERROR);
                        $DB->rollback();
                    }
                }
                break;
        }
        parent::processMassiveActionsForOneItemtype($ma, $item, $ids); // TODO: Change the autogenerated stub
    }

    static function showForItem(CommonDBTM $item, $withtemplate = 0)
    {
        $itemtype1_list_in_records = [
            PluginDlteamsProcessedData::class,
        ];

        $exceptions_itemtype_in_records = [
            PluginDlteamsConcernedPerson::class
        ];

        $id = $item->fields['id'];
        $canedit = $item->can($id, UPDATE); // canedit booleen = true
        $rand = mt_rand(1, mt_getrandmax());
        global $DB;

        $iterator = static::getRequest($item);
        $number = count($iterator);
        $items_list = [];
        $used = [];

        //while ($data = $iterator->next()) {
        foreach ($iterator as $id => $data) {
            $items_list[$data['linkid']] = $data;
            $used[$data['id']] = $data['id'];
        }

        $excluded = [PluginDlteamsConcernedPerson::class];

        if ($canedit && !in_array($item->getType(), $excluded)) {
            echo "<form name='recorditem_form$rand' id='recorditem_form$rand' method='post'
             action='" . Toolbox::getItemTypeFormURL(PluginDlteamsElementsRGPD::class) . "'>";
            echo "<input type='hidden' name='itemtype1' value='" . $item->getType() . "' />";
            echo "<input type='hidden' name='itemtype' value='" . static::$itemtype_2 . "' />";
            echo "<input type='hidden' name='items_id1' value='" . $item->getID() . "' />";
            echo "<input type='hidden' name='entities_id' value='" . $item->fields['entities_id'] . "' />";
//
            echo "<table class='tab_cadre_fixe'>";

            echo "<tr class='tab_bg_2'><th colspan='3'>" . static::$title .
                "</th>";
            echo "</tr>";

            echo "<tr class='tab_bg_1'>";
            echo "<td class='right' style='text-wrap: nowrap;' width='20%'>";
            echo static::$sub_title;
            echo "</td>";
            echo "<td style='display: flex;' class='left'>";

//            Dropdown::showFromArray('test', [
//                ['name' => 'element1'],
//                ['name' => 'element2'],
//            ], ['width'   => '30%',
//                'rand'    => $rand,
//                'display' => false]);
            global $CFG_GLPI;
            PluginDlteamsRecord::dropdown([
                'addicon' => true,
                'name' => 'items_id',
                'used' => $used,
                'value' => "", //$responsible,
                'right' => 'all',
                'width' => "250px",
                'rand' => $rand,
                'url' => $CFG_GLPI['root_doc'] . "/marketplace/dlteams/ajax/getDropdownValue.php"
            ]);


            echo "</td>";
            echo "<td class='left'>";
            echo "</td>";
            echo "</tr>";


//
//
            echo "<tr class='tab_bg_1' style='display: none;' id='field-createlink$rand'>";
            echo "<td class='right' width='20%'>";
            echo __("Comment");
            echo "</td>";
            echo "<td style='display: flex;' class='left'>";
            echo "<div>";
            echo "<textarea type='text' style='width:100%;' maxlength=1000 rows='2' name='comment' class='comment'></textarea>";
            if ($item::getType() == PluginDlteamsDataCatalog::class) {
                echo "<div style='display: flex; align-items: center; gap: 3px;'>";
                Html::showCheckbox([
                    'name' => 'apply_on_childs',
                    'checked' => true
                ]);

                echo "<label>les catalogues enfants héritent automatiquement</label>";
                echo "</div>";
            }

            echo "</div>";
            echo "</td>";
            echo "<td class='left'>";
            echo "</td>";
            echo "</tr>";

            echo "<tr>";
            echo "<td>";
            echo "</td>";
            echo "<td colspan='2' class='left'>";
            echo "<button name='link_element' style='display: none;' id='btn-createlink$rand' class='btn btn-primary'>Relier cet élément</button>";
            echo "</td>";
            echo "</tr>";


            echo "</table>";
            Html::closeForm();
        }

        echo "<script>
                $(document).ready(function(e){

                  
                $(document).on('change', '#dropdown_items_id$rand', function () {
                    if($(this).val() != '0'){
                        document.getElementById('btn-createlink$rand').style.display = 'block';
                        document.getElementById('field-createlink$rand').style.display = 'table-row';
                        
                        $.ajax({
                                url: '/marketplace/dlteams/ajax/get_object_specific_field.php',
                                type: 'POST',
                                data: {
                                    id: $(this).val(),
                                    object: '" . static::$itemtype_2 . "',
                                    field: 'content'
                                },
                                success: function (data) {
                                    // Handle the returned data here
//                                    let comm_field = $('textarea[name=comment]');
//                                    comm_field.val(data);
//                                    comm_field.val(comm_field.val().replace(/^\s+/, ''));
                                }
                            });                      
                        
                        
                    }
                    else{
                       // document.getElementById('btn-createlink').style.display = 'none';
                        //document.getElementById('field-createlink$rand').style.display = 'none';
                    }
                       
                    });
                });
        </script>";

        $massiveaction_processor = __CLASS__;

        if (in_array($item::getType(), $itemtype1_list_in_records) || in_array($item::getType(), $exceptions_itemtype_in_records)) {
            $massiveaction_processor = $item::getType() . "_Item";
            static::$items_id_1 = strtolower(str_replace("PluginDlteams", "", $item::getType())) . "s_id";
        }


        echo "<div class='spaced'>";
        if ($canedit && $number && !in_array($item->getType(), $excluded)) {
            Html::openMassiveActionsForm('mass' . $massiveaction_processor . $rand);
            $massive_action_params = [
                'container' => 'mass' . $massiveaction_processor . $rand,
                'num_displayed' => min($_SESSION['glpilist_limit'], $number)
            ];
            Html::showMassiveActions($massive_action_params);
        }
        echo "<table class='tab_cadre_fixehov'>";

        $header_begin  = "<tr>";
        $header_top    = '';
        $header_bottom = '';
        $header_end    = '';

        if ($canedit && $number && !in_array($item->getType(), $excluded)) {
            $header_begin .= "<th width='10'>";
            $header_top   .= Html::getCheckAllAsCheckbox('mass' . $massiveaction_processor . $rand);
            $header_end   .= "</th>";
        }

        if ($item->getType() == PluginDlteamsConcernedPerson::class) {
            $header_end .= "<th>" . __("Catégorie de données") . "</th>";
        }
        $header_end .= "<th>" . __("Name") . "</th>";

        if ($item->getType() != PluginDlteamsConcernedPerson::class) {
            $header_end .= "<th style='width: 40%'>" . __("Content") . "</th>";
            $header_end .= "<th style='width: 30%'>" . __("Comment") . "</th>";
        }

        if ($item->getType() == PluginDlteamsConcernedPerson::class) {
            $header_end .= "<th>" . __("Sensible") . "</th>";
            $header_end .= "<th>" . __("Vu comme sensible") . "</th>";
        }

        $header_end .= "</tr>";

        echo $header_begin . $header_top . $header_end;

// --- Options locales ---
        $CONTENT_LIMIT = 220; // nb de caractères avant “Voir plus”
        $js_injected   = false; // pour n'injecter le JS qu'une seule fois

        foreach ($items_list as $data) {
            echo "<tr class='tab_bg_1'>";

            if ($canedit && $number && !in_array($item->getType(), $excluded)) {
                echo "<td width='10'>";
                Html::showMassiveActionCheckBox($massiveaction_processor, $data['linkid']);
                echo "</td>";

                $id = $data['linkid'];
            }

            // --- Colonne "Catégorie de données" si ConcernedPerson ---
            if ($item->getType() == PluginDlteamsConcernedPerson::class) {
                $itemtype1 = $data["itemtype1"];

                if (isset($data["itemtype1"])) {
                    $object_name = new $itemtype1();
                    $object_name->getFromDB($data["items_id1"]);
                    $name_cat = $object_name->fields["name"];

                    $url2 = $itemtype1::getFormURLWithID($data["items_id1"]);
                    $name_cat = sprintf("<a target='_blank' href='%s'>%s</a>", $url2, Html::entities_deep($name_cat));
                } else {
                    $name_cat = "Pas de catégorie de données";
                }

                echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                echo ">" . $name_cat . "</td>";
            }

            // --- Colonne "Name" (avec tooltip membres si Group::class) ---
            if ((in_array($item::getType(), $itemtype1_list_in_records) || in_array($item::getType(), $exceptions_itemtype_in_records))) {
                $object_name = new static::$itemtype_1();
                $object_name->getFromDB($data["items_id"]);
                $display_name = $object_name->fields["name"];
            } else {
                $display_name = $data["name"];
            }

            $item_id_key = (in_array($item::getType(), $itemtype1_list_in_records) || in_array($item::getType(), $exceptions_itemtype_in_records))
                ? "items_id" : static::$items_id_1;

            $url_item  = static::$itemtype_2::getFormURLWithID($data[$item_id_key]);

            // ancre avec id unique pour y attacher le tooltip
            $anchor_id = 'name_' . $data[$item_id_key] . '_' . mt_rand();
            $name_html = sprintf(
                "<a id='%s' target='_blank' href='%s'>%s - %s</a>",
                $anchor_id,
                $url_item,
                Html::entities_deep($data["completenumber"]),
                Html::entities_deep($display_name)
            );

            echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
            echo ">" . $name_html;

            // Tooltip membres du groupe si c'est un groupe
            if (isset($data["itemtype"]) && $data["itemtype"] === Group::class) {
                // Récupérer les membres
                $groupmembers = Group_User::getGroupUsers($data['items_id']) ?? [];

                // Construire la liste cliquable : on affiche le "name" (ou realname/firstname si besoin)
                $links = [];
                foreach ($groupmembers as $u) {
                    if (empty($u['id'])) continue;

                    // n’afficher que le "name" (si tu préfères realname/firstname, remplace la ligne suivante)
                    $label = Html::entities_deep($u['name'] ?? '');
                    if ($label === '') {
                        // fallback minimal si le champ 'name' est vide
                        $tmp = trim(($u['realname'] ?? '') . ' ' . ($u['firstname'] ?? ''));
                        $label = Html::entities_deep($tmp);
                        if ($label === '') continue;
                    }
                    $uurl = User::getFormURLWithID((int)$u['id']);
                    $links[] = '<a target="_blank" href="'.$uurl.'">'.$label.'</a>';
                }

                if ($links) {
                    $tooltip_html = implode('<br>', $links);
                    echo Html::showToolTip($tooltip_html, [
                        'applyto' => $anchor_id,
                        'title'   => __('Membres du groupe'),
                        'display' => false
                    ]);
                }
            }

            echo "</td>";

            // --- Colonnes "Content" et "Comment" ---
            if ($item->getType() != PluginDlteamsConcernedPerson::class) {
                // Content avec Voir plus / Voir moins
                $raw_content = (string)($data["content"] ?? '');
                // on encode pour éviter l'injection dans le tableau
                $safe_content = Html::entities_deep($raw_content);

                // longueur sur la version sans tags (au cas où) — ici déjà encodé, donc c'est du texte pur
                $len = mb_strlen($safe_content);
                $content_uid = 'ct_' . ($data['linkid'] ?? $data[$item_id_key] ?? mt_rand()) . '_' . mt_rand();

                echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");

                echo ">";

                if ($len > $CONTENT_LIMIT) {
                    $trunc = mb_substr($safe_content, 0, $CONTENT_LIMIT);
                    // blocs show/hide
                    echo "<span id='{$content_uid}_short'>{$trunc}… ";
                    echo "<a href='#' class='dl-see-more' data-target='{$content_uid}'>" . __('Voir plus') . "</a></span>";
                    echo "<span id='{$content_uid}_full' style='display:none'>{$safe_content} ";
                    echo "<a href='#' class='dl-see-less' data-target='{$content_uid}'>" . __('Voir moins') . "</a></span>";
                } else {
                    echo $safe_content;
                }

                echo "</td>";

                // Comment (on évite htmlspecialchars_decode : on affiche proprement du texte)
                $comment = Html::entities_deep((string)($data["comment"] ?? ""));
                echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                echo ">" . $comment . "</td>";
            }

            // --- Colonnes sensibles si ConcernedPerson ---
            if ($item->getType() == PluginDlteamsConcernedPerson::class) {
                $record = new PluginDlteamsRecord();
                $record->getFromDB($data["items_id"]);

                echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                echo ">";
                echo PluginDlteamsRecord::isSensitive($record) ? "Oui" : "Non";
                echo "</td>";

                echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                echo ">";
                echo !empty($data["sensitive"]) ? "Oui" : "Non";
                echo "</td>";
            }

            echo "</tr>";

            // Injecter le JS une seule fois pour Voir plus / Voir moins
            if (!$js_injected) {
                $js_injected = true;
                echo "<script>
document.addEventListener('click', function(e) {
    // Voir plus
    if (e.target && e.target.classList.contains('dl-see-more')) {
        e.preventDefault();
        var uid = e.target.getAttribute('data-target');
        var s = document.getElementById(uid + '_short');
        var f = document.getElementById(uid + '_full');
        if (s && f) { s.style.display = 'none'; f.style.display = ''; }
    }
    // Voir moins
    if (e.target && e.target.classList.contains('dl-see-less')) {
        e.preventDefault();
        var uid = e.target.getAttribute('data-target');
        var s = document.getElementById(uid + '_short');
        var f = document.getElementById(uid + '_full');
        if (s && f) { f.style.display = 'none'; s.style.display = ''; }
    }
});
</script>";
            }
        }

        echo "</table>";

        Html::closeForm();

        echo "
                <script>
                    $(document).ready(function(e) {
                        window.eventBinded = false;
                
                        $(document).on('change', 'select[name=id_field]', function () {
                            
                            
                            if (!alertShown) {
                                $.ajax({
                                        url: '/marketplace/dlteams/ajax/get_object_specific_field.php',
                                        type: 'POST',
                                        data: {
                                            id: " . $id . ",
                                            object: '" . static::$itemtype_2 . "_Item" . "',
                                            field: 'comment'
                                        },
                                        success: function (data) {
                                            // Handle the returned data here
                                            console.log(data);
                                            $('textarea[name=comment]').val(data);
                                        }
                            });
                                eventBinded = true;
                            }
                        });
                    });
                </script>
                ";

        echo "</div>";
//        }

    }


    static function showRecodsForItem(CommonDBTM $item, $withtemplate = 0)
    {
        $id = $item->fields['id'];
        $canedit = false; // canedit booleen = true
        $rand = mt_rand(1, mt_getrandmax());
        global $DB;

        $iterator = static::getRecordsRequest($item);
        $number = count($iterator);
        $items_list = [];
        $used = [];

        //while ($data = $iterator->next()) {
        foreach ($iterator as $id => $data) {
            $items_list[$data['linkid']] = $data;
            $used[$data['id']] = $data['id'];
        }

        if ($canedit) {
            echo "<form name='datacarrieritem_form$rand' id='datacarrieritem_form$rand' method='post'
             action='" . Toolbox::getItemTypeFormURL(PluginDlteamsElementsRGPD::class) . "'>";
            echo "<input type='hidden' name='itemtype1' value='" . $item->getType() . "' />";
            echo "<input type='hidden' name='itemtype' value='" . static::$itemtype_2 . "' />";
            echo "<input type='hidden' name='items_id1' value='" . $item->getID() . "' />";
            echo "<input type='hidden' name='entities_id' value='" . $item->fields['entities_id'] . "' />";
//
            echo "<table class='tab_cadre_fixe'>";

            echo "<tr class='tab_bg_2'><th colspan='3'>" . static::$title .
                "</th>";
            echo "</tr>";

            echo "<tr class='tab_bg_1'>";
            echo "<td class='right' style='text-wrap: nowrap;' width='20%'>";
            echo static::$sub_title;
            echo "</td>";
            echo "<td style='display: flex;' class='left'>";


            static::$itemtype_2::dropdown([
                'addicon' => true,
                'name' => 'items_id',
                'value' => "", //$responsible,
                // 'entity' => $this->fields["entities_id"],
                'right' => 'all',
                'width' => "250px",
            ]);

            $field_id = Html::cleanId("dropdown_" . 'items_' . mt_rand());
            $item_link = getItemForItemtype(static::$itemtype_2);

            echo '<div class="btn btn-outline-secondary"
                           title="' . __s('Add') . '" data-bs-toggle="modal" data-bs-target="#add_' . $field_id . '">'
                . Ajax::createIframeModalWindow('add_' . $field_id, $item_link->getFormURL(), ['display' => false])
                . "<span data-bs-toggle='tooltip'>
              <i class='fa-fw ti ti-plus'></i>
              <span class='sr-only'>" . __s('Add') . "</span>
                </span>"
                . '</div>';


            echo "</td>";
            echo "<td class='left'>";
            echo "</td>";
            echo "</tr>";


//
//
            echo "<tr class='tab_bg_1' style='display: none;' id='field-createlink'>";
            echo "<td class='right' width='20%'>";
            echo __("Comment");
            echo "</td>";
            echo "<td style='display: flex;' class='left'>";
            echo "<textarea type='text' style='width:100%;' maxlength=1000 rows='2' name='comment' class='comment'></textarea>";
            echo "</td>";
            echo "<td class='left'>";
            echo "</td>";
            echo "</tr>";

            echo "<tr>";
            echo "<td>";
            echo "</td>";
            echo "<td colspan='2' class='left'>";
            echo "<button name='link_element' style='display: none;' id='btn-createlink' class='btn btn-primary'>Relier cet élément</button>";
            echo "</td>";
            echo "</tr>";


            echo "</table>";
            Html::closeForm();
        }

        echo "<script>
                $(document).ready(function(e){

                $('select[name=items_id]').on('change', function () {
                    if($(this).val() != '0'){
                        document.getElementById('btn-createlink').style.display = 'block';
                        document.getElementById('field-createlink').style.display = 'table-row';
                        
                        $.ajax({
                                url: '/marketplace/dlteams/ajax/get_object_specific_field.php',
                                type: 'POST',
                                data: {
                                    id: $(this).val(),
                                    object: '" . static::$itemtype_2 . "',
                                    field: 'content'
                                },
                                success: function (data) {
                                    // Handle the returned data here
                                    let comm_field = $('textarea[name=comment]');
                                    comm_field.val(data);
                                    comm_field.val(comm_field.val().replace(/^\s+/, ''));
                                }
                            });                      
                        
                        
                    }
                    else{
                        document.getElementById('btn-createlink').style.display = 'none';
                        document.getElementById('field-createlink').style.display = 'none';
                    }
                       
                    });
                });
        </script>";


        if ($iterator) {

            echo "<div class='spaced'>";
            if ($canedit && $number) {
                Html::openMassiveActionsForm('mass' . __CLASS__ . $rand);
                $massive_action_params = [
                    'container' => 'mass' . __CLASS__ . $rand,
                    'num_displayed' => min($_SESSION['glpilist_limit'], $number)
                ];
                Html::showMassiveActions($massive_action_params);
            }
            echo "<table class='tab_cadre_fixehov'>";

            $header_begin = "<tr>";
            $header_top = '';
            $header_bottom = '';
            $header_end = '';


            if ($canedit && $number) {

                $header_begin .= "<th width='10'>";
                $header_top .= Html::getCheckAllAsCheckbox('mass' . __CLASS__ . $rand);
//                $header_bottom .= Html::getCheckAllAsCheckbox('mass' . __CLASS__ . $rand);
                $header_end .= "</th>";
            }


//            foreach (static::$table_match_str as $column) {
            $header_end .= "<th>" . __("Name") . "</th>";
            $header_end .= "<th>" . __("Comment") . "</th>";
//            }
            $header_end .= "</tr>";

            echo $header_begin . $header_top . $header_end;
            //var_dump($items_list);
            foreach ($items_list as $data) {
                echo "<tr class='tab_bg_1'>";

                if ($canedit && $number) {
                    echo "<td width='10'>";

                    $item_str = $item::class . "_Item";
//                        Computer_Item::class;
                    Html::showMassiveActionCheckBox(__CLASS__, $data['linkid']);
                    echo "</td>";

                    $id = $data['linkid'];
                }


//                foreach (static::$table_match_str as $key => $column) {

//                    if (isset($data[$column["column_name"]]))
                $name = $data["name"];
//                    if (!isset($data[$column["column_name"]]))
//                        $name = "--";

//                    if ($key === 0)
                $name = "<a target='_blank' href=\"" . static::$itemtype_2::getFormURLWithID($data[static::$items_id_1]) . "\">" . $name . "</a>";

                echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                echo ">" . $name . "</td>";

                echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                echo ">" . $data["comment"] . "</td>";
//                }

                echo "</tr>";
            }

            echo "</table>";

            Html::closeForm();

            echo "
                <script>
                    $(document).ready(function(e) {
                      //  var window.eventBinded = false;
                
                        $(document).on('change', 'select[name=id_field]', function () {
                            console.log('shhhh');
                            
                            if (!alertShown) {
                                $.ajax({
                                        url: '/marketplace/dlteams/ajax/get_object_specific_field.php',
                                        type: 'POST',
                                        data: {
                                            id: " . $id . ",
                                            object: '" . static::$itemtype_2 . "_Item" . "',
                                            field: 'comment'
                                        },
                                        success: function (data) {
                                            // Handle the returned data here
                                            console.log(data);
                                            $('textarea[name=comment]').val(data);
                                        }
                            });
                              //  eventBinded = true;
                            }
                        });
                    });
                </script>
                ";

            echo "</div>";
        }

    }

    public function post_purgeItem()
    {
        $exception_list = PluginDlteamsUtils::itemtypeExceptionList();
        if (in_array($this->fields["itemtype"], $exception_list)) {
            $relation_item_str = "Item_" . $this->fields["itemtype"];
        } else
            $relation_item_str = $this->fields["itemtype"] . "_Item";

//        purge relations
        if (!class_exists($relation_item_str))
            $relation_item_str = "PluginDlteams" . $relation_item_str;

        if ($relation_item_str == Document_Item::class)
            $relation_item_str = PluginDlteamsDocument_Item::class;


        $relation_item = new $relation_item_str();

        $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype"]))) . "s_id";
        if ($this->fields["itemtype"] == PluginDlteamsThirdPartyCategory::class)
            $relation_column_id = "thirdpartycategories_id";

        $criteria = [
            "itemtype" => static::$itemtype_2,
            "items_id" => $this->fields[static::$items_id_1],
            $relation_column_id => $this->fields["items_id"],
//            "comment" => $this->fields["comment"]
        ];
        global $DB;
        if ($DB->fieldExists($relation_item->getTable(), 'itemtype1') && $this->fields["itemtype1"]) {
            $criteria["itemtype1"] = $this->fields["itemtype1"];
            $criteria["items_id1"] = $this->fields["items_id1"];
        }


        if ($DB->fieldExists($relation_item->getTable(), 'itemtype1')) {
            $criteria["comment"] = $this->fields["comment"];
        }

        $relation_item->deleteByCriteria($criteria);


        //        purge relation 2
        if ($this->fields["itemtype1"] && $this->fields["items_id1"]) {

            $relation_item_str = $this->fields["itemtype1"] . "_Item";
            if (!class_exists($relation_item_str))
                $relation_item_str = "PluginDlteams" . $relation_item_str;
            $relation_item = new $relation_item_str();

            $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype1"]))) . "s_id";
            if ($this->fields["itemtype1"] == PluginDlteamsRgpdAdequacy::class)
                $relation_column_id = "rgpdadequacies_id";

            $criteria = [
                "itemtype" => "PluginDlteamsRecord",
                "items_id" => $this->fields["records_id"],
                $relation_column_id => $this->fields["items_id1"],
                "itemtype1" => $this->fields["itemtype"],
                "items_id1" => $this->fields["items_id"],
                "comment" => $this->fields["comment"]
            ];

            if ($relation_item->deleteByCriteria($criteria))
                Session::addMessageAfterRedirect("Relation " . $relation_item::getTypeName() . " supprimé avec succès");

        }
    }


    public function post_updateItem($history = 1)
    {
        $exception_list = PluginDlteamsUtils::itemtypeExceptionList();
        if (in_array($this->fields["itemtype"], $exception_list)) {
            $relation_item_str = "Item_" . $this->fields["itemtype"];
        } else
            $relation_item_str = $this->fields["itemtype"] . "_Item";

        if (!class_exists($relation_item_str))
            $relation_item_str = "PluginDlteams" . $relation_item_str;

        if ($relation_item_str == Document_Item::class)
            $relation_item_str = PluginDlteamsDocument_Item::class;

        $relation_item = new $relation_item_str();

        if ($this->fields["itemtype"] == PluginDlteamsThirdPartyCategory::class) {
            $relation_column_id = "thirdpartycategories_id";
        } else
            $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype"]))) . "s_id";

        $criteria = [
            "itemtype" => static::$itemtype_2,
            "items_id" => $this->fields[static::$items_id_1],
            $relation_column_id => $this->fields["items_id"],
//            "comment" => $this->oldvalues["comment"]
        ];


        $r = $relation_item->deleteByCriteria($criteria);

        global $DB;
        if ($DB->fieldExists($relation_item->getTable(), 'comment')) {
            $criteria["comment"] = addslashes($this->fields["comment"]);
        }

        global $DB;
        if (isset($this->fields["plugin_dlteams_storagetypes_id"]) && $DB->fieldExists($relation_item->getTable(), 'plugin_dlteams_storagetypes_id'))
            $criteria["plugin_dlteams_storageendactions_id"] = $this->fields["plugin_dlteams_storageendactions_id"];

        if (isset($this->fields["plugin_dlteams_storagetypes_id"]) && $DB->fieldExists($relation_item->getTable(), 'plugin_dlteams_storagetypes_id'))
            $criteria["plugin_dlteams_storagetypes_id"] = $this->fields["plugin_dlteams_storagetypes_id"];

        $criteria2 = [
            ...$criteria,
//            "comment" => $this->fields["comment"]
        ];

        if ($DB->fieldExists($relation_item->getTable(), 'comment')) {
            $criteria2["comment"] = addslashes($this->fields["comment"]);
        }
        $relation_item->add($criteria2);


        Session::addMessageAfterRedirect("Relation mis a jour avec succès");
    }

    function rawSearchOptions()
    {
        $tab[] = [
            'id' => '44',
            'table' => static::getTable(),
            'field' => 'comment',
            'datatype' => 'text',
            'name' => __("Commentaire"),
            'forcegroupby' => true,
            'massiveaction' => true,
        ];

        return $tab;
    }

    public function getForbiddenStandardMassiveAction()
    {
        $forbidden = parent::getForbiddenStandardMassiveAction();
        $forbidden[] = 'clone';
        $forbidden[] = 'MassiveAction:add_transfer_list';
        $forbidden[] = 'MassiveAction:amend_comment';
        $forbidden[] = 'Document_Item:remove';
        $forbidden[] = 'Document_Item:add';
        return $forbidden;
    }

    public static function getRequest(CommonDBTM $item)
    {
        $itemtype1_list_in_records = [
            PluginDlteamsProcessedData::class,
        ];

        $exceptions_itemtype_in_records = [
            PluginDlteamsConcernedPerson::class
        ];

        global $DB;
        if (in_array($item::getType(), $itemtype1_list_in_records) || in_array($item::getType(), $exceptions_itemtype_in_records)) {
            $table_item_name = getTableForItemType($item::getType() . "_Item");
            $table_name = $item::getTable(); // si $item = DataCatalog, $table_name contiendra data_catalogs
            $columnid_name = strtolower(str_replace("PluginDlteams", "", $item::getType())) . "s_id"; // $columnid_name contiendra users_id si $item = User
        } else {
            $table_item_name = getTableForItemType(static::$itemtype_2 . "_Item");
            $table_name = static::$itemtype_2::getTable(); // si $item = DataCatalog, $table_name contiendra data_catalogs
            $columnid_name = strtolower(str_replace("PluginDlteams", "", static::$itemtype_2::getType())) . "s_id"; // $columnid_name contiendra users_id si $item = User
        }

//        var_dump($columnid_name);
//        die();

        $query = [
            'SELECT' => [
                $table_item_name . '.id AS linkid',
                $table_item_name . '.itemtype AS itemtype',
                $table_item_name . '.items_id AS items_id',
                $table_item_name . '.' . $columnid_name . ' AS columnid_name',
                $table_item_name . '.*',
                $table_name . '.id AS id',
                $table_name . '.name AS name',
                $table_name . '.content AS content',
            ],
            'FROM' => $table_item_name,
            'LEFT JOIN' => [
                $table_name => [
                    'ON' => [
                        $table_item_name => $columnid_name,
                        $table_name => 'id'
                    ]
                ]
            ],
        ];

        if ($DB->FieldExists($table_item_name, 'itemtype1')) {
            $query["SELECT"][] = $table_item_name . '.itemtype1 as itemtype1';
            $query["SELECT"][] = $table_item_name . '.items_id1 as items_id1';
        }

        if ($DB->FieldExists($table_item_name, 'mandatory')) {
            $query["SELECT"][] = $table_item_name . '.mandatory as mandatory';
        }


        if ($table_name == PluginDlteamsRecord::getTable()) {
            $query["SELECT"][] = $table_name . '.number AS number';
            $query["SELECT"][] = $table_name . '.completenumber AS completenumber';
            $query["ORDERBY"][] = $table_name . '.number ASC';
        }


//        if ($item::getType() == PluginDlteamsRecord::class){
//            var_dump("zzz");
//            die();
        if ($table_item_name == PluginDlteamsRecord_Item::getTable())
            $joincolumn_id = "records_id";
        else
            $joincolumn_id = "items_id";

        $query["SELECT"][] = PluginDlteamsRecord::getTable() . '.number AS number';
        $query["SELECT"][] = PluginDlteamsRecord::getTable() . '.parentnumber AS parentnumber';
        $query["SELECT"][] = PluginDlteamsRecord::getTable() . '.completenumber AS completenumber';
        $query["SELECT"][] = PluginDlteamsRecord::getTable() . '.sensitive AS sensitive';
        $query["SELECT"][] = PluginDlteamsRecord::getTable() . '.id AS id';
//        $query["ORDERBY"][] = PluginDlteamsRecord::getTable() . '.completenumber ASC';
        if($table_name == PluginDlteamsConcernedPerson::getTable()){
            $query["ORDERBY"][] = PluginDlteamsConcernedPerson::getTable() . '.name ASC';
//            $query["ORDERBY"][] = PluginDlteamsRecord::getTable() . '.completenumber ASC';
        }
        else
            $query["ORDERBY"][] = PluginDlteamsRecord::getTable() . '.completenumber ASC';
        $query["LEFT JOIN"][PluginDlteamsRecord::getTable()] = [
            'ON' => [
                $table_item_name => $joincolumn_id,
                PluginDlteamsRecord::getTable() => 'id'
            ]
        ];
//        }


        if (in_array($item::getType(), $itemtype1_list_in_records) || in_array($item::getType(), $exceptions_itemtype_in_records)) {
            $query["WHERE"] = [
                $table_item_name . '.itemtype' => ['LIKE', static::$itemtype_1],
                $table_item_name . '.' . $columnid_name => $item->fields['id'],
            ];
        } else {
            $query["WHERE"] = [
                $table_item_name . '.itemtype' => ['LIKE', $item::getType()],
                $table_item_name . '.' . 'items_id' => $item->fields['id'],
            ];
        }

        if ($DB->fieldExists($table_item_name, 'comment')) {
            $query['SELECT'][] = $table_item_name . '.comment AS comment';
        }

        if ($DB->fieldExists($table_name, 'content')) {
            $query['SELECT'][] = $table_name . '.content AS content';
        }


        $iterator = $DB->request($query);
        $temp = [];

        foreach ($iterator as $id => $data) {
            if ($data["itemtype"]) {
                $item_object = null;
                $item_str = $data["itemtype"];
                $item_object = new $item_str();
                $item_object->getFromDB($data["items_id"]);
                if (isset($item_object->fields["entities_id"])) {
                    array_push($temp, $data);
                }
            }
        }
        return $temp;
    }


    public static function getRecordsRequest(CommonDBTM $item)
    {
        $table_name = static::$itemtype_2::getTable(); // si $item = DataCatalog, $table_name contiendra data_carriers
        $columnid_name = strtolower(str_replace("PluginDlteams", "", static::$itemtype_2::getType())) . "s_id"; // $columnid_name contiendra users_id si $item = User
        global $DB;        //var_dump ($table_name, $columnid_name);
        $table_item_name = getTableForItemType(static::$itemtype_2 . "_Item");

        $query = [
            'SELECT' => [
                $table_item_name . '.id AS linkid',
                $table_item_name . '.itemtype AS itemtype',
                $table_item_name . '.items_id AS items_id',
                $table_item_name . '.*',
                $table_name . '.id AS id',
                $table_name . '.name AS name',
                $table_name . '.content AS content',
            ],
            'DISTINCT' => true,
            'FROM' => $table_item_name,
            'LEFT JOIN' => [
                $table_name => [
                    'ON' => [
                        $table_item_name => $columnid_name,
                        $table_name => 'id'
                    ]
                ]
            ],
            'WHERE' => [
                $table_item_name . '.itemtype' => ['LIKE', $item::getType()],
                $table_item_name . '.' . 'items_id' => $item->fields['id'],
            ],
            'ORDERBY' => ["$table_name.name ASC"]
        ];


        /*        highlight_string("<?php\n\$data =\n" . var_export($query, true) . ";\n?>");*/
//        die();
        if ($DB->fieldExists($table_item_name, 'comment')) {
            $query['SELECT'][] = $table_item_name . '.comment AS comment';
        }

        if ($DB->fieldExists($table_name, 'content')) {
            $query['SELECT'][] = $table_name . '.content AS content';
        }


        $iterator = $DB->request($query);
        $temp = [];

        $records_idx = [];
        foreach ($iterator as $id => $data) {

            if (!in_array($data["id"], $records_idx)) {
                $records_idx[] = $data["id"];
            } else
                continue;
            if ($data["itemtype"]) {
                $item_object = null;
                $item_str = $data["itemtype"];
                $item_object = new $item_str();
                $item_object->getFromDB($data["items_id"]);


                if (isset($item_object->fields["entities_id"])) {
                    array_push($temp, $data);
                }

            }

        }
        return $temp;
    }


    public static function getProcesseddataRequest(PluginDlteamsProcessedData $processedData)
    {
        $query = [
            'SELECT' => [
                PluginDlteamsRecord_Item::getTable() . '.id AS linkid',
                PluginDlteamsRecord_Item::getTable() . '.itemtype AS itemtype',
                PluginDlteamsRecord_Item::getTable() . '.items_id AS items_id',
                PluginDlteamsRecord_Item::getTable() . '.*',
                PluginDlteamsRecord::getTable() . '.id AS id',
                PluginDlteamsRecord::getTable() . '.name AS name',
                PluginDlteamsRecord::getTable() . '.content AS content',
            ],
            'FROM' => PluginDlteamsRecord_Item::getTable(),
            'LEFT JOIN' => [
                PluginDlteamsRecord::getTable() => [
                    'ON' => [
                        PluginDlteamsRecord_Item::getTable() => "records_id",
                        PluginDlteamsRecord::getTable() => 'id'
                    ]
                ]
            ],
            'WHERE' => [
                "itemtype1" => PluginDlteamsProcessedData::class,
                "items_id1" => $processedData->fields["id"],
                "records_id" => ["<>", 0],
                PluginDlteamsRecord::getTable().".entities_id" => Session::getActiveEntity()
            ],
            "ORDERBY" => ['records_id']
        ];


        global $DB;
        return $DB->request($query);
    }

    static function showConsent1(PluginDlteamsRecord $record, $data = [])
    {
        if ($data['consent_type1'] == 0) {
        } else if ($data['consent_type1'] == 1) {
            //echo __("Groupe <i class='fas fa-dolly'></i>&nbsp;", 'dlteams');
            global $CFG_GLPI;
            Group::dropdown([
                'addicon' => Group::canCreate(),
                'name' => "groups_id",
                'display_emptychoice' => false,
                'url' => $CFG_GLPI['root_doc'] . "/marketplace/dlteams/ajax/getDropdownValue.php",
                'width' => "200px"
            ]);
            echo "<textarea type='text' rows='1' name='comment' placeholder='Commentaire'  style='margin-bottom:-15px;margin-left:190px;width:45%'></textarea>";
            echo "<input type='submit' name='add1' value=\"" . _sx('button', 'Add') . "\" class='submit' style='float:right;margin-right:7.5%'>";

        } else if ($data['consent_type1'] == 2) {
            //echo __("Utilisateur <i class='fas fa-dolly'></i>&nbsp;", 'dlteams');

            /*User::dropdown([
            'addicon'  => User::canCreate(),
            'name' => "users_id",
            'display_emptychoice' => false,
            'width' => "200px"

         ]); */
            $randDropdown = mt_rand();
            User::dropdown(['value' => $record->fields["users_id"],
                'entity' => $record->fields["entities_id"],
                'right' => 'all',
                'width' => '200px',
                'rand' => $randDropdown]);
            echo "<textarea type='text' maxlength=600 rows='1' name='comment' placeholder='Commentaire' style='margin-bottom:-15px;margin-left:140px;width:45%'></textarea>";
            echo "<input type='submit' name='add1' value=\"" . _sx('button', 'Add') . "\" class='submit' style='float:right;margin-right:7.5%'>";


        } else if ($data['consent_type1'] == 3) {
            // Display explicit consentecho "<td><br>" . "</td><td>";

            //echo __("Tiers Categories <i class='fas fa-dolly'></i>&nbsp;", 'dlteams');

//            echo "<span style='margin-right:10px;'>";
//            //echo __("Tiers ", 'dlteams');
//            //echo "<br/><br/>";
//
//            PluginDlteamsRgpdAdequacy::dropdown([
//                'addicon' => PluginDlteamsRgpdAdequacy::canCreate(),
//                'name' => "rgpdadequacies_id",
//                'display_emptychoice' => false,
//                'width' => '150px'
//            ]);
//            echo "</span>";


            PluginDlteamsThirdPartyCategory::dropdown([
                'addicon' => PluginDlteamsThirdPartyCategory::canCreate(),
                'name' => "plugin_dlteams_thirdpartycategories_id1",
                'width' => "200px"
            ]);
            echo "<textarea type='text' maxlength=600 rows='1' name='comment' placeholder='Commentaire' style='margin-bottom:-15px;margin-left:110px;width:35%'></textarea>";
            echo "<input type='submit' name='add1' value=\"" . _sx('button', 'Add') . "\" class='submit' style='float:right;margin-right:7.5%'>";

        } else if ($data['consent_type1'] == 4) {
            // Display explicit consentecho "<td><br>" . "</td><td>";

            //echo __("Tiers <i class='fas fa-dolly'></i>&nbsp;", 'dlteams');
//            echo "<span style='margin-right:10px;'>";
//            //echo __("Tiers ", 'dlteams');
//            //echo "<br/><br/>";
//
//            PluginDlteamsRgpdAdequacy::dropdown([
//                'addicon' => PluginDlteamsRgpdAdequacy::canCreate(),
//                'name' => "rgpdadequacies_id",
//                'display_emptychoice' => false,
//                'width' => '150px'
//            ]);
//            echo "</span>";

            Supplier::dropdown([
                'addicon' => Supplier::canCreate(),
                'name' => "suppliers_id1",
                'display_emptychoice' => false,
                'width' => "200px"
            ]);
            echo "<textarea type='text' maxlength=600 rows='1' name='comment' placeholder='Commentaire' style='margin-bottom:-15px;margin-left:110px;width:35%'></textarea>";

            echo "<input type='submit' name='add1' value=\"" . _sx('button', 'Add') . "\" class='submit' style='float:right;margin-right:7.5%'>";
        }

    }


}
