<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

class PluginDlteamsRecord_Rights extends CommonDBTM {
   static public $itemtype_2 = PluginDlteamsRightMeasure::class;
   static function getTypeName($nb = 0) {
      return __("Rights exercice", 'dlteams');
   }

   function getTabNameForItem(CommonGLPI $item, $withtemplate = 0) {
      if (!$item->canView()) {
         return false;
      }

      switch ($item->getType()) {
         case PluginDlteamsRecord::class :
             $nb = count(static::getRequest($item));

             if($item->fields['consent_type'])
                 $nb++;
             else{
                 $value = $item->fields['consent_json'] ?? '[]';

// Si c’est une string, on décode, sinon on garde tel quel
                 if (is_string($value)) {
                     $decoded = json_decode($value, true) ?? [];
                 } elseif (is_array($value)) {
                     $decoded = $value;
                 } else {
                     $decoded = [];
                 }

                 $nb += count($decoded);
             }

            return self::createTabEntry(PluginDlteamsRecord_Rights::getTypeName(1), $nb);
      }

      return '';
   }

   static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0) {
      switch ($item->getType()) {
         case PluginDlteamsRecord::class :

            $rights = new self();
            $rights->showForRecord($item, $withtemplate = 0);
            break;
      }
      return true;
   }

   static function showForRecord(PluginDlteamsRecord $record, $withtemplate = 0) {
      global $CFG_GLPI;
      $id = $record->fields['id'];
      if (!$record->can($id, READ)) {
         return false;
      }

      $canedit = PluginDlteamsRecord::canUpdate();
      $rand = mt_rand(1, mt_getrandmax());

      $options['canedit'] = $canedit;
      $options['formtitle'] = __("Right exercice", 'dlteams');

       echo "<style>";
       echo "
            .form-table-text {
                text-align: right;
                width: 40%;
            }
            @media (max-width: 800px) {
                .form-table-text {
                    text-align: left;
                    width: 100%;
                }
            }
        ";

       echo "</style>";


       echo "<div class='firstbloc'>";
       echo "<form name='ticketitem_form$rand' id='ticketitem_form$rand' method='post'
         action='" . Toolbox::getItemTypeFormURL(__class__) . "'>";
       echo "<input type='hidden' name='plugin_dlteams_records_id' value='$id' />";

       echo "<table class='tab_cadre_fixe'>";
       echo "<tr class='tab_bg_2%'><th colspan='2'>";
       echo __("Consentement", 'dlteams') . "</th></tr>";

       echo "<tr><td  class='form-table-text'>" . __("Is the consent implicit or explicit?", 'dlteams') ;
	   Html::showToolTip(__("Article 9.2.a du RGPD<br>Le consentement est explicite lorsque la personne effectue un acte clair, formel et volontaire pour exprimer son accord au traitement 
	   (obligatoire lors de toute collecte de donnée sensible)<br>Exemples : <br>Je consens expressément à ce que mes données de santé soient utilisées dans le cadre de mon suivi médical<br>
	   En cochant cette case, j’autorise l’organisme à traiter mes données biométriques à des fins d’authentification<br>Je signe ce formulaire pour autoriser l’enregistrement et la transmission de mes informations médicales à l’hôpital", 'dlteams'));
	   echo "</td><td>";
       $rand = Dropdown::showFromArray("consent_type", [
           __("Implicit", 'dlteams'),
           __("Explicit", 'dlteams')
       ], [
           'value' => $record->fields['consent_type'] ?? 0,
       ]);
       $params = [
           'consent_type' => '__VALUE__',
           'plugin_dlteams_records_id' => $id
       ];
       Ajax::updateItemOnSelectEvent(
           "dropdown_consent_type$rand",
           'consent_row',
           $CFG_GLPI['root_doc'] . '/marketplace/dlteams/ajax/record_right_consent_dropdown.php',
           $params
       );


       echo "<tr id='consent_row'>";
       self::showConsent($record, $record->fields);
       echo "</tr>";

//       echo "<tr><td class='form-table-text'>" . __("Commentaires ou autres mesures", 'dlteams');
//       Html::showToolTip(__("mentions, document remis, lien internet, affiche, …", 'dlteams'));
//       echo "</td><td class='left'>";
//
//       $cols = 100;
//       $rows = 60;
//       Html::textarea(['name' => 'right_information',
//           'value' => $record->fields['right_information'],
//           'enable_fileupload' => false,
//           'enable_richtext' => true,
//           'cols' => $cols,
//           'rows' => $rows
//       ]);
//       echo "</td></tr>";

       if ($canedit) {
           echo "<tr><td class='center' colspan='2'><input type='submit' name='update'  class='submit' value=" . __('Save') . ">";
           echo "</td></tr>";
       }
       echo "</table>";
       Html::closeForm();
       echo "</div>";





      //if ($canedit) {
       echo "<div class='firstbloc'>";
//       echo "<form name='ticketitem_form$rand' id='ticketitem_form$rand' method='post'
//         action='" . Toolbox::getItemTypeFormURL(__class__) . "'>";
//       echo "<input type='hidden' name='plugin_dlteams_records_id' value='$id' />";

       echo "<table class='tab_cadre_fixe'>";
       echo "<tr class='tab_bg_2%'><th colspan='2'>";
       echo __("Droits des personnes", 'dlteams') . "</th></tr>";
	   // echo "<td class='left'>";
	   // echo __("Mesures spécifiques prises à l'occasion de ce traitement", 'dlteams');
	   // echo "</td>";
	   // echo __("En plus des mesures génériques comme les mentions légales du site internet, quelles mesures spécifiques sont prises à l'occasion de ce traitement concernant : ", 'dlteams') . "<br>";
	   // echo __("- la délivrance d'informations particulières (mentions, document remis, lien internet, affiche ...)", 'dlteams') . "<br>";
	   // echo __("- l'exercice des droits (accès, rectification, oubli, opposition)", 'dlteams') . "<br>";
	   // echo __("- la portabilité ou la subrogation", 'dlteams') . "</td>";
	   echo "<td class='left' width='30%'>";
	   echo __("Mesures issues des jeux de données", 'dlteams');
	   echo "</td>";

	   $pfx = PluginDlteamsRecord_Element::getPolicyFormRequest($record);
	   echo "<td>";
	   foreach ($pfx as $pf){
           $policieform = new PluginDlteamsPolicieForm();
           $policieform->getFromDB($pf["policieforms_id"]);
	       $mesure_iterator = PluginDlteamsRightMeasure_Item::getItemRequest($policieform);
	       foreach ($mesure_iterator as $measure){
               echo sprintf("%s; &nbsp;", $measure["name"]);
           }
       }
	   echo "</td>";

	   echo "</table>";

       $id = $record->fields['id'];
       $canedit = $record->can($id, UPDATE); // canedit booleen = true
       $rand = mt_rand(1, mt_getrandmax());
       global $DB;

       $iterator = static::getRequest($record);
       $number = count($iterator);
       $items_list = [];
       $used = [];

       //while ($data = $iterator->next()) {
       foreach ($iterator as $id => $data) {
           $items_list[$data['linkid']] = $data;
           $used[$data['id']] = $data['id'];
       }

       if ($canedit) {
           echo "<form name='ticketitem_form$rand' id='ticketitem_form$rand' method='post'
             action='" . Toolbox::getItemTypeFormURL(PluginDlteamsElementsRGPD::class) . "'>";
           echo "<input type='hidden' name='itemtype1' value='" . $record->getType() . "' />";
           echo "<input type='hidden' name='itemtype' value='" . static::$itemtype_2 . "' />";
           echo "<input type='hidden' name='items_id1' value='" . $record->getID() . "' />";
           echo "<input type='hidden' name='entities_id' value='" . $record->fields['entities_id'] . "' />";
           echo "<table class='tab_cadre_fixe'>";

           echo "<tr class='tab_bg_1'>";
           echo "<td class='left' width='20%'>";
		   // echo __("Indiquez une mesure pour les droits", 'dlteams');
		   echo __("Ajouter d'autres mesures", 'dlteams');
		   Html::showToolTip(__("- informations des personnes : mentions, articles, lien internet, affiche, ...<br>- si consentement : méthode, formulaire, stockage
		   <br>- droits des personnes : accès, rectification, opposition<br>- mesures de portabilité<br>- directives anticipées<br> ...", 'dlteams'));
           echo "</td>";
           echo "<td style='display: flex;' class='left'>";

           global $DB;
           global $CFG_GLPI;
           $params = [
               'addicon' => true,
               'name' => 'items_id',
               'value' => "", //$responsible,
               //'entity' => $this->fields["entities_id"],
               'right' => 'all',
               'width' => "300px",
               'url' => $CFG_GLPI['root_doc'] . "/marketplace/dlteams/ajax/getDropdownValue.php",
               'used' => $used,
           ];
           static::$itemtype_2::dropdown($params);

           echo "</td>";
           echo "<td class='left'>";
           echo "</td>";
           echo "</tr>";

           echo "<tr class='tab_bg_1' style='display: none;' id='field-createlink'>";
           echo "<td class='right' width='20%'>";
           echo __("Comment");
           echo "</td>";
           echo "<td class='left'>";

           Html::textarea(['name' => 'comment',
               'enable_fileupload' => false,
               'editor_id' => 'rr_id',
               'enable_richtext' => true,
               'cols' => 100,
               'rows' => 100
           ]);
//           echo "<textarea type='text' style='width:100%;' maxlength=1000 rows='2' name='comment' class='comment'></textarea>";
           echo "</td>";
           echo "<td class='left'>";
           echo "</td>";
           echo "</tr>";

           echo "<tr>";
           echo "<td>";
           echo "</td>";
           echo "<td colspan='2' class='left'>";
           echo "<button name='link_element' style='display: none;' id='btn-createlink' class='btn btn-primary'>Ajouter</button>";
           echo "</td>";
           echo "</tr>";


           echo "</table>";
           Html::closeForm();
       }

       echo "<script>
                $(document).ready(function(e){

                $('select[name=items_id]').on('change', function () {
                    if($(this).val() != '0'){
                        document.getElementById('btn-createlink').style.display = 'block';
                        document.getElementById('field-createlink').style.display = 'table-row';
                        
                        $.ajax({
                                url: '/marketplace/dlteams/ajax/get_object_specific_field.php',
                                type: 'POST',
                                data: {
                                    id: $(this).val(),
                                    object: '" . static::$itemtype_2 . "',
                                    field: 'content'
                                },
                                success: function (data) {
                                    // Handle the returned data here
                                    // let comm_field = $('textarea[name=comment]');
                                    //comm_field.val(data);
                                    tinymce.get('rr_id').setContent(data);
                                    //comm_field.val(comm_field.val().replace(/^\s+/, ''));
                                }
                            });                      
                        
                        
                    }
                    else{
                        document.getElementById('btn-createlink').style.display = 'none';
                        document.getElementById('field-createlink').style.display = 'none';
                    }
                       
                    });
                });
        </script>";

       echo "<script>
            $('.editma$rand').off('click').click(function(e) {
                
               glpi_ajax_dialog({
                dialogclass: 'modal-xs',
                bs_focus: false,
                url: '/marketplace/dlteams/ajax/edit_items.php',
                params: {
                    action: 'edit_record_right',
                    linkid: $(this).data('id')
                },
                title: i18n.textdomain('dlteams').__('Action', 'dlteams'),
                close: function () {

                },
                fail: function () {
                    displayAjaxMessageAfterRedirect();
                }
            });
            });
            
            </script>";

       echo "<div class='spaced'>";
       if ($canedit && $number) {
           Html::openMassiveActionsForm('mass' . PluginDlteamsRightMeasure_Item::class . $rand);
           $massive_action_params = [
               'container' => 'mass' . PluginDlteamsRightMeasure_Item::class . $rand,
               'num_displayed' => min($_SESSION['glpilist_limit'], $number)
           ];
           Html::showMassiveActions($massive_action_params);
       }
       echo "<table class='tab_cadre_fixehov'>";

       $header_begin = "<tr>";
       $header_top = '';
       $header_bottom = '';
       $header_end = '';


       if ($canedit && $number) {

           $header_begin .= "<th width='10'>";
           $header_top .= Html::getCheckAllAsCheckbox('mass' . PluginDlteamsRightMeasure_Item::class . $rand);
//                $header_bottom .= Html::getCheckAllAsCheckbox('mass' . __CLASS__ . $rand);
           $header_end .= "</th>";

           $header_end .= "<th></th>";
       }


           $header_end .= "<th>" . PluginDlteamsRightMeasure::getTypeName() . "</th>";
           $header_end .= "<th>" . "Type de mesure" . "</th>";
           $header_end .= "<th>" . __("Content") . "</th>";

       if ($canedit) {
           $header_end .= "<th width='4%' class='left'></th>";
       }
       $header_end .= "</tr>";

       echo $header_begin . $header_top . $header_end;
       echo "<tbody class='sortable-rules'>";
       foreach ($items_list as $data) {

           echo "<tr data-rightmeasureitems_id='" . $data['linkid'] . "' class='tab_bg_1'>";

           if ($canedit && $number) {
               echo "<td width='10'>";

               $item_str = $record::class . "_Item";
               Html::showMassiveActionCheckBox(PluginDlteamsRightMeasure_Item::class, $data['linkid']);
               echo "</td>";

//               $id = $data['linkid'];


               echo "<td width='15' >";
               $linkid = $data['linkid'];
               echo "<i class='fa fa-edit editma$rand' style='cursor:pointer;' data-id='$linkid'></i>";
               echo "</td>";
           }


           $rightmeasures_id = $data["rightmeasures_id"];
           $rm = new PluginDlteamsRightMeasure();
           $rm->getFromDB($rightmeasures_id);



                   $name = $data["name"];

                   $name = "<a target='_blank' href=\"" . static::$itemtype_2::getFormURLWithID($data["rightmeasures_id"]) . "\">" . $name . "</a>";
//
               echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
               echo ">" . $name . "</td>";



           $categories = PluginDlteamsRightMeasureCategory_Item::getRequest($rm);

           $categories_name = "";
           foreach ($categories as $category){
               $categories_name.= "<span>" . $category["name"] . "</span><br>";
           }
           echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
           echo ">" . $categories_name . "</td>";



           echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
           echo ">" . \Glpi\RichText\RichText::getEnhancedHtml(htmlspecialchars_decode($data["comment"]), ['text_maxsize' => 50]) . "</td>";

           if ($canedit) {
               echo "<td colspan='2'><i class='fas fa-grip-horizontal grip-rule'></i></td>";
           }

           echo "</tr>";
       }
       echo "</tbody>";
       echo "</table>";

       Html::closeForm();

       $id = $record->fields["id"];
       echo "
                <script>
                    $(document).ready(function(e) {
                        //var window.eventBinded = false;
                
                        $(document).on('change', 'select[name=id_field]', function () {
                            console.log('shhhh');
                            
                            if (!alertShown) {
                                $.ajax({
                                        url: '/marketplace/dlteams/ajax/get_object_specific_field.php',
                                        type: 'POST',
                                        data: {
                                            id: " . $id . ",
                                            object: '" . static::$itemtype_2 . "_Item" . "',
                                            field: 'comment'
                                        },
                                        success: function (data) {
                                            // Handle the returned data here
                                            console.log(data);
                                            $('textarea[name=comment]').val(data);
                                        }
                            });
                                eventBinded = true;
                            }
                        });
                    });
                </script>
                ";

       echo "</div>";

       if($canedit){
           $collection_classname = static::getType();
           $js = <<<JAVASCRIPT
         $(function() {
            sortable('.sortable-rules', {
               handle: '.grip-rule',
               placeholder: '<tr><td colspan="7" class="sortable-placeholder">&nbsp;</td></tr>'
            })[0].addEventListener('sortupdate', function(e) {
               var sort_detail          = e.detail;
               console.log('alll');
               console.log(sort_detail);
               var rightmeasureitems_id              = sort_detail.item.dataset.rightmeasureitems_id;
               var collection_classname = "{$collection_classname}";
               var new_index            = sort_detail.destination.index;
               var old_index            = sort_detail.origin.index;
               var ref_id               = sort_detail.destination.itemsBeforeUpdate[new_index].dataset.rightmeasureitems_id;
               var sort_action          = 'after';

               if (old_index > new_index) {
                  sort_action = 'before';
               }

               try{
                $.post(CFG_GLPI['root_doc']+'/marketplace/dlteams/ajax/record_right_timeline.php', {
                  'action': 'move_rule',
                  'new_index': new_index,
                  'old_index': old_index,
                  'rightmeasureitems_id': rightmeasureitems_id,
                  'collection_classname': collection_classname,
                  'sort_action': sort_action,
                  'ref_id': ref_id,
               });
               }
               catch(e){
               
               }

               displayAjaxMessageAfterRedirect();
            });
         });
JAVASCRIPT;
           echo Html::scriptBlock($js);
       }

       Html::closeForm();
       echo "</div>";


      echo "<div class='firstbloc'>";
      echo "<form name='ticketitem_form$rand' id='ticketitem_form$rand' method='post'
         action='" . Toolbox::getItemTypeFormURL(__class__) . "'>";
      echo "<input type='hidden' name='plugin_dlteams_records_id' value='$id' />";

echo "<table class='tab_cadre_fixe'>";
echo "<tr class='tab_bg_2'>";
echo "<td class='left' style='vertical-align: top; width: 200px;'>" . __("Commentaires", 'dlteams') . "</td>";
echo "<td class='left'>";

Html::textarea([
    'name'               => 'right_information',
    'value'              => $record->fields['right_information'],
    'enable_fileupload'  => false,
    'enable_richtext'    => true,
]);
//          echo "<textarea type='text' style='width:98%' maxlength=1000 rows='3' name='consent_explicit' required>" .
echo "</td>";
echo "</tr>";
echo "</table>";

      if ($canedit) {
         echo "<tr><td class='center' colspan='2'><input type='submit' name='update'  class='submit' value=" . __('Save') . ">";
         echo "</td></tr>";
      }
      // echo "</table>";
      Html::closeForm();
      echo "</div>";
   }

    public static function getRequest(CommonDBTM $item, $flat = false)
    {
        global $DB;
        $query = static::getQueryStr($item);
        $iterator = $DB->request($query);
        $temp = [];

        foreach ($iterator as $id => $data) {
            if ($data["itemtype"]) {


                $rightmeasures_id = $data["rightmeasures_id"];
                $rm = new PluginDlteamsRightMeasure();
                $rm->getFromDB($rightmeasures_id);
                $categories = PluginDlteamsRightMeasureCategory_Item::getRequest($rm);

                $categories_name = "";
                foreach ($categories as $category){
                    if($flat)
                        $categories_name.= $category["name"]."; ";
                    else
                        $categories_name.= "<a target='_blank' href=\"" . PluginDlteamsRightMeasureCategory::getFormURLWithID($category["rightmeasurecategories_id"]) . "\">" . $category["name"] . "</a><br>";
                }

                $item_object = null;
                $item_str = $data["itemtype"];
                $item_object = new $item_str();
                $item_object->getFromDB($data["items_id"]);
                if (isset($item_object->fields["entities_id"])) {
                    array_push($temp, [...$data, "categories" => $categories_name]);
                }
            }
        }
        return $temp;
    }

    public static function  getQueryStr(CommonDBTM $item){
        $table_name = PluginDlteamsRightMeasure::getTable(); // si $item = DataCatalog, $table_name contiendra data_catalogs
        $columnid_name = strtolower(str_replace("PluginDlteams", "", PluginDlteamsRightMeasure::getType())) . "s_id"; // $columnid_name contiendra users_id si $item = User

//
        global $DB;
        $table_item_name = getTableForItemType(PluginDlteamsRightMeasure::class . "_Item");

        $query = [
            'SELECT' => [
                $table_item_name . '.id AS linkid',
                $table_item_name . '.itemtype AS itemtype',
                $table_item_name . '.items_id AS items_id',
                $table_item_name . '.*',
                $table_name . '.id AS id',
                $table_name . '.name AS name',
                $table_name . '.content AS content',
//                'glpi_plugin_dlteams_protectivetypes.name AS typename',
//                'glpi_plugin_dlteams_protectivecategories.name as namecat',
            ],
            'FROM' => $table_item_name,
            'LEFT JOIN' => [
                $table_name => [
                    'ON' => [
                        $table_item_name => $columnid_name,
                        $table_name => 'id'
                    ]
                ]
            ],
            'WHERE' => [
                $table_item_name . '.itemtype' => ['LIKE', $item::getType()],
                $table_item_name . '.' . 'items_id' => $item->fields['id'],
            ],
            'ORDERBY' => ['timeline_position ASC']
        ];

        /*        highlight_string("<?php\n\$data =\n" . var_export($query, true) . ";\n?>");*/
//        die();
        if ($DB->fieldExists($table_item_name, 'comment')) {
            $query['SELECT'][] = $table_item_name . '.comment AS comment';
        }

        if ($DB->fieldExists($table_name, 'content')) {
            $query['SELECT'][] = $table_name . '.content AS content';
        }

        return $query;
    }

   static function showConsent(PluginDlteamsRecord $record, $data = []) {
      if ($data['consent_type'] == 0) {
         // Display implicit consent

         echo "<td class='form-table-text'>" . __("Reasons why consent is not required", 'dlteams') . "</td><td>";
         // Obtain array from json stored in the record DB table, if it doesn't exists, empty json string
         $consent = json_decode($record->fields['consent_json'] ?? "{}", true);
         $choices = [
            __("Punctual or contractual engagement", 'dlteams'),
            __("Prior consent to a third-party", 'dlteams'),
            __("Legitimate ou pre-contractual process", 'dlteams'),
            __("Legal obligation", 'dlteams'),
            __("Public interest mission or safeguard of vital interests", 'dlteams'),
            "<input type='text' disabled=false placeholder='" . __("Other") .
            "' name='consent_other' id='consent_other' value='" . ($consent['other'] ?? '') . "'>",
         ];
         echo PluginDlteamsUtils::displayCheckboxes($consent, $choices, 'consent', 'checkbox') . "</td>";

      } elseif ($data['consent_type'] == 1) {
         // Display explicit consent
         echo "<td class='form-table-text'>" . __("Procédure de consentement", 'dlteams') . "<br><i>" .
            __("Detail consent collect process", 'dlteams') . "</i></td><td>";


         //echo "<textarea type='text' style='width:98%' maxlength=1000 rows='3' name='consent_explicit' required>" .
            //($data['consent_explicit'] ?? "") . "</textarea>";

          $rand = Dropdown::showFromArray("consent_explicit", [
              __("------", 'dlteams'),
              __("Conforme", 'dlteams'),
              __("En cours", 'dlteams'),
              __("Non conforme", 'dlteams')
          ], [
              'value' => $data['consent_explicit'],
              'width' => 'auto'
          ]);
      }
   }
}