<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */


use GlpiPlugin\dlteams\Exception\ImportFailureException;

class PluginDlteamsTicketTask_Item extends CommonDBTM
{
    static public $itemtype_2 = TicketTask::class;
    static public $itemtype_1;
    public static $items_id_1;
    public static $title;
    public static $sub_title;
    public static $table_match_str = [];

    public function __construct()
    {
        static::$itemtype_1 = str_replace("_Item", "", __CLASS__); // $itemtype_1 ---> PluginDlteamsProtectiveMeasure
        static::$items_id_1 = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", __CLASS__))) . "s_id";
        static::$title = __("Mesures de protection en relation avec cet élément", 'dlteams');
        static::$sub_title = __("Choisir une nouvelle mesure de protection", 'dlteams');
        static::$table_match_str = [
            [
                'head_text' => __("Name"),
                'column_name' => 'name',
                'show_as_link' => true
            ],
            [
                'head_text' => __("Type"),
                'column_name' => 'typename',
            ],
            [
                'head_text' => __("Categorie"),
                'column_name' => 'namecat',
            ],
            [
                'head_text' => __("Comment"),
                'column_name' => 'comment',
            ]
        ];
        parent::__construct();
    }

    static function canCreate()
    {
        return true;
    }

    static function canView()
    {
        return true;
    }

    static function canUpdate()
    {
        return true;
    }

    static function canDelete()
    {
        return true;
    }

    static function canPurge()
    {
        return true;
    }

    function canCreateItem()
    {
        return true;
    }

    function canViewItem()
    {
        return true;
    }

    function canUpdateItem()
    {
        return true;
    }

    function canDeleteItem()
    {
        return true;
    }

    function canPurgeItem()
    {
        return true;
    }

    static function getTypeName($nb = 0)
    {
        return __("Tâches", 'dlteams');
    }

    static function getTypeNameForClass($nb = 0)
    {
        return __("Eléments rattachés", 'dlteams');
    }

    static function getSpecificValueToDisplay($field, $values, array $options=array()) {

        highlight_string("<?php\n\$data =\n" . var_export($field, true) . ";\n?>");
        highlight_string("<?php\n\$data =\n" . var_export($values, true) . ";\n?>");
        if (!is_array($values)) {
            $values = array($field => $values);
        }

        switch ($field) {
            case 'tickettasks_id':
                $ticket = new Ticket();

                highlight_string("<?php\n\$data =\n" . var_export($values, true) . ";\n?>");
                die();

                if($ticket->getFromDB($values["tickets_id"])){
                    global $DB;
                    $tickettask_query = [
                        "FROM" => TicketTask::getTable(),
                        "WHERE" => [
                            "tickets_id" => $ticket->fields["id"]
                        ]
                    ];
                    $tickettask_iterator = $DB->request($tickettask_query);


                    $suit = "
                        <div style='display: flex; justify-content: end'><div style='display: flex; flex-direction: column; width: 75%; background-color: #f3f3f3; padding: 2px'>";
                    foreach ($tickettask_iterator as $tickettask) {

                        $label = htmlspecialchars(Planning::getState($tickettask["state"]), ENT_QUOTES);
                        $class = Planning::getStatusClass($tickettask["state"]);
                        $color = Planning::getStatusColor($tickettask["state"]);
                        $icon = "<i class='itilstatus $class $color me-1' title='$label' data-bs-toggle='tooltip'></i><span></span>";

                        $suit.=sprintf("<hr style='margin: 2px;'/>
                    <div><a href='%s' id='steptickettask_%s'> %s</a> %s</div>",
                            TicketTask::getFormURLWithID($tickettask["id"]),
//                            $tickettask["id"],
                            $tickettask["id"],
                            html_entity_decode($tickettask["content"]),
                            $icon
                        );

                        echo "
                        <script>
                            $(document).ready(function () {
                                $('#steptickettask_".$tickettask["id"]."').qtip({
                                    position: { viewport: $(window) },
                                    content: {
                                        text: '".addslashes(html_entity_decode($tickettask["content"]))."',
                                        title: '".addslashes(Planning::getStatusIcon($tickettask["state"]))."',
                                    },
                                    style: {classes: 'qtip-shadow qtip-bootstrap'},
                                    hide: {
                                      fixed: true,
                                      delay: 200,
                                      leave: false,
                                      when: { event: 'unfocus' }
                                    }
                                });
                            });
                        </script>
                        ";
                    }
                    $suit.="</div></div>";

                    $criteria    = [
                        'tickets_id' => $ticket->fields['id'],
                        'state'     => [Planning::TODO, Planning::DONE],
                        'tickettasks_id' => NULL
                    ];
                    $total_tasks = countElementsInTable(TicketTask::getTable(), $criteria);
                    $criteria    = [
                        'tickets_id' => $ticket->fields['id'],
                        'state'      => Planning::DONE,
                        'tickettasks_id' => NULL
                    ];
                    $done_tasks = countElementsInTable(TicketTask::getTable(), $criteria);
                    $percentdone = 0;
                    if($total_tasks>0){
                        $percentdone = floor(100 * $done_tasks / $total_tasks);
                    }

                    echo "
                        <script>
                            $(document).ready(function () {
                                $('#stepticket_".$ticket->fields["id"]."').qtip({
                                    position: { viewport: $(window) },
                                    content: {
                                        title: '".addslashes(html_entity_decode($ticket->fields["name"]))."',
                                        text: '".addslashes(html_entity_decode($ticket->fields["content"]))."',
                                    },
                                    style: {classes: 'qtip-shadow qtip-bootstrap'},
                                    hide: {
                                      fixed: true,
                                      delay: 200,
                                      leave: false,
                                      when: { event: 'unfocus' }
                                    }
                                });
                            });
                        </script>
                        ";

                    return sprintf("<a href='%s' id='stepticket_".$ticket->fields["id"]."' target='_blank'>#%s</a> %s (%s)",
                            Ticket::getFormURLWithID($ticket->fields["id"]),
                            $ticket->fields["id"],
                            $ticket->fields["name"],
                            $percentdone." %"
                        ).$suit;
                }
                return "";
                break;
        }
        return "";
//        return parent::getSpecificValueToDisplay($field, $values, $options);
    }


    // affichage de l'onglet et de son nom
    public function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {
        switch ($item->getType()) {

            default:
                if (!$withtemplate) {
                    if ($_SESSION['glpishow_count_on_tabs']) {
                        return static::createTabEntry(static::getTypeName(2), count(static::getRequest($item)));
                    }
                    return static::getTypeName(2);
                }
                break;
        }

        return '';
    }

    // comptage du nombre de liaison entre les 2 objets dans la table de l'objet courant
    static function countForItem(CommonDBTM $item)
    {
        $dbu = new DbUtils();
        return $dbu->countElementsInTable(static::getTable(), ['items_id' => $item->getID(), 'itemtype' => $item->getType()]);
    }


    public static function getItemsRequest(CommonDBTM $object_item)
    {
        global $DB;
        $link_table = str_replace("_Item", "", __CLASS__);
        $temp = new $link_table();

        $items = $DB->request([
            'FROM' => self::getTable(),
            'SELECT' => [
                self::getTable() . '.id',
                self::getTable() . '.*',
                self::getTable() . '.id as linkid',
                self::getTable() . '.comment',
                self::getTable() . '.itemtype as itemtype',
                self::getTable() . '.items_id as items_id',
            ],
            'WHERE' => [
                static::getTable() . '.' . static::$items_id_1 => $object_item->fields['id']
            ],
            'LEFT JOIN' => [
                $temp->getTable() => [
                    'FKEY' => [
                        static::getTable() => static::$items_id_1,
                        $temp->getTable() => 'id'
                    ]
                ]
            ],
            'ORDER' => self::getTable() . '.id DESC'
        ]);

        return iterator_to_array($items);
    }


    public function defineTabs($options = [])
    {

        $ong = [];
        $this->addDefaultFormTab($ong);
        $this->addImpactTab($ong, $options);

        return $ong;
    }

    public static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {
        switch ($item->getType()) {
//            case static::$itemtype_2:
//                self::showItems($item);
//                break;
            default:
                self::showForItem($item);
                break;
        }
    }

    /**
     * Show items links to a document
     *
     * @param $doc Document object
     *
     * @return void
     **@since 0.84
     *
     */
    public static function showItems(PluginDlteamsProtectiveMeasure $object_item)
    {
        global $DB;
        $instID = $object_item->fields['id'];
        if (!$object_item->can($instID, READ)) {
            return false;
        }
        $canedit = $object_item->can($instID, UPDATE);
        // for a measure,
        // don't show here others protective measures associated to this one,
        // it's done for both directions in self::showAssociated
        $types_iterator = [];
        $number = count($types_iterator);

        $used = [];
        $types = PluginDlteamsItemType::getTypes();
//        Enlève le choix de L'objet LegalBasi dans la dropdown qui affiche la liste des objets
        $key = array_search(static::$itemtype_2, $types);
        unset($types[$key]);
        $rand = mt_rand();


        if ($canedit) {
            echo "<form name='ticketitem_form$rand' id='ticketitem_form$rand' method='post'
            action='" . Toolbox::getItemTypeFormURL(__CLASS__) . "'>";
            echo "<input type='hidden' name='" . static::$items_id_1 . "' value='$instID'>";
            echo "<input type='hidden' name='itemtype1' value='" . str_replace("_Item", "", __CLASS__) . "'>";
            echo "<input type='hidden' name='items_id1' value='" . $instID . "'>";

            echo "<table class='tab_cadre_fixe'>";
            $title = "Related objects";
            $entitled = "Indicate the objects related to this element";
            echo "<tr class='tab_bg_2'><th colspan='2'>" . __($title, 'dlteams') .
                "<br><i style='font-weight: normal'>" .
                "</i></th>";
            echo "</tr>";

            echo "<tr class='tab_bg_1'><td class='left' width='40%'>" . __($entitled, 'dlteams');
            echo "</td><td width='40%' class='left'>";
            $types = PluginDlteamsItemType::getTypes();
            $key = array_search("PluginDlteamsLegalBasi", $types);
            unset($types[$key]);
            Dropdown::showSelectItemFromItemtypes(['itemtypes' => $types,
                'entity_restrict' => ($object_item->fields['is_recursive'] ? getSonsOf('glpi_entities', $object_item->fields['entities_id'])
                    : $object_item->fields['entities_id']),
                'checkright' => true,
                'used' => $used
            ]);
            unset($types);
            echo "</td><td width='20%' class='left'><input for='ticketitem_form$rand' type='submit' name='add' value=\"" . _sx('button', 'Add') . "\" class='submit'>";
            echo "</td></tr>";
            echo "<tr class='tab_bg_1'><td width='35%' class=''>";
            echo __("Comment");
            echo "<br/><br/>";
            echo "<textarea type='text' style='width:100%' maxlength=1000 rows='3' name='comment' class='comment_legalbasi_item'></textarea>";
            echo "</td>";
            echo "</table>";
            Html::closeForm();
        }

//        var_dump(self::getTable());
        $items = self::getItemsRequest($object_item);

        if (!count($items)) {
            echo "<table class='tab_cadre_fixe'><tr><th>" . __('No item found') . "</th></tr>";
            echo "</table>";
        } else {
            if ($canedit) {
                Html::openMassiveActionsForm('mass' . __CLASS__ . $rand);
                $massiveactionparams = [
                    'num_displayed' => min($_SESSION['glpilist_limit'], count($items)),
                    'container' => 'mass' . __CLASS__ . $rand
                ];
                Html::showMassiveActions($massiveactionparams);
            }

            echo "<table class='tab_cadre_fixehov'>";
            $header = "<tr>";
            if ($canedit) {
                $header .= "<th width='10'>";
                $header .= Html::getCheckAllAsCheckbox('mass' . __CLASS__ . $rand);
                $header .= "</th>";
            }
            $header .= "<th>" . __("Nom") . "</th>";
            $header .= "<th>" . __("Type") . "</th>";

            // colonne non generique
            $header .= "<th>" . __("Categorie") . "</th>";
            $header .= "<th>" . __("Comment") . "</th>";
            $header .= "</tr>";
            echo $header;


            foreach ($items as $row) {
                $item = new $row['itemtype']();
                $item->getFromDB($row['items_id']);
                $name = "<a target='_blank' href=\"" . $item::getFormURLWithID($item->getField('id')) . "\">" . $item->getField('name') . "</a>";
                echo "<tr lass='tab_bg_1'>";
                if ($canedit) {
                    echo "<td>";
                    Html::showMassiveActionCheckBox(__CLASS__, $row["id"]);
                    echo "</td>";
                }
                echo "<td>" . $name . "</td>";
                echo "<td>" . $row["itemtype"]::getTypeName() . "</td>";

                // colonne non generique
                $item = new PluginDlteamsProtectiveCategory();
                $item->getFromDB($row['protectivemeasures_id']);
                $name = "<a target='_blank' href=\"" . $item::getFormURLWithID($row['protectivemeasures_id']) . "\">" . $item->getField('name') . "</a>";

                echo "<td>" . $name . "</td>";
                echo "<td>" . $row['comment'] . "</td>";
                echo "</tr>";

            }
            echo $header;
            echo "</table>";

            if ($canedit && count($items)) {
                $massiveactionparams['ontop'] = false;
                Html::showMassiveActions($massiveactionparams);
            }
            if ($canedit) {
                Html::closeForm();
            }

        }
    }

    static function showForItem(CommonDBTM $item, $withtemplate = 0)
    {
        if ($item->getType() == Project::class) {
            $timeline_stats = $item->getTimelineStats();


            $total_duration = $timeline_stats['total_duration'] ?? 0;
            $total_estimate_duration = $timeline_stats['total_estimateduration'] ?? 0;
            $todo_percent = $timeline_stats['percent_done'] ?? 0;
            $nb_taches = $timeline_stats['nb_taches'] ?? 0;
            $done_tasks = $timeline_stats['done_tasks'] ?? 0;
            $nb_planifications_done = $timeline_stats['nb_planifications_done'] ?? 0;
            $nb_planifications = $timeline_stats['nb_planifications'] ?? 0;

            if (!function_exists('format_duration')) {
                function format_duration(int $seconds): string
                {
                    $seconds = max(0, $seconds);
                    $h = intdiv($seconds, 3600);
                    $m = intdiv($seconds % 3600, 60);
                    $s = $seconds % 60;

                    if ($h > 0 && $m > 0) return sprintf('%dh %dm', $h, $m);
                    if ($h > 0) return sprintf('%dh', $h);
                    if ($m > 0) return sprintf('%dm', $m);
                    return sprintf('%ds', $s);
                }
            }

            $todo_percent = (int)$todo_percent;
            $reste_a_faire = max(0, (int)$nb_taches - (int)$done_tasks);

            echo '<div style="display: block" class="timeline-item timeline_stats pb-3">';

            echo '<div class="mb-2 ms-1 text-muted">';
            echo sprintf(__('%s tâches et %s planifications'), (int)$nb_taches, (int)$nb_planifications);
            echo '</div>';

            echo '<div class="mb-2 ms-1 text-muted">';
            echo sprintf(__('Durée totale prévue: %s'), format_duration((int)$total_estimate_duration));
            echo '</div>';

            echo '<div class="mb-2 ms-1 text-muted">';
            echo sprintf(__('Durée totale effective: %s'), format_duration((int)$total_duration));
            echo '</div>';

            echo '<div class="mb-2 ms-1 text-muted" id="count_todo">';
            echo __('Reste à faire: ');
            echo '<b>' . sprintf(__('%s'), $reste_a_faire) . '</b>';
            echo '</div>';

            echo '<div class="d-flex">';
            echo '<span class="task-progress-label mx-2">' . $todo_percent . '%</span>';
            echo '<div class="progress mt-1" style="max-width: 260px">';
            echo '<div class="progress-bar progress-bar-striped timeline-progress" role="progressbar" '
                . 'style="width: ' . $todo_percent . '%;" '
                . 'aria-valuenow="' . $todo_percent . '" aria-valuemin="0" aria-valuemax="100"></div>';
            echo '</div>';
            echo '</div>';

            echo '</div>';
        }


        if (empty($GLOBALS['__dlteams_clamp_assets_loaded'])) {
            $GLOBALS['__dlteams_clamp_assets_loaded'] = true;

            echo '<style>
   /* Clamp sur 3 lignes pour les cellules de contenu */
   .dl-clamp{
      display:-webkit-box;
      -webkit-box-orient:vertical;
      -webkit-line-clamp:3;
      overflow:hidden;
      max-height:calc(1.4em * 3);
      line-height:1.4em;
      word-break:break-word;
      white-space:pre-wrap; /* conserve les retours à la ligne sans exploser la largeur */
   }
   .dl-clamp.expanded{
      -webkit-line-clamp:unset;
      max-height:none;
   }
   .dl-clamp-toggle{
      cursor:pointer;
      font-size:12px;
      margin-left:6px;
      white-space:nowrap;
   }
   </style>';

            echo '<script>
   (function(){
     document.addEventListener("click", function(e){
       var t = e.target;
       if (!t.classList.contains("dl-clamp-toggle")) return;
       var id = t.getAttribute("data-target");
       var el = document.getElementById(id);
       if(!el) return;

       var expanded = el.classList.toggle("expanded");
       // si pas de HTML riche, basculer texte complet depuis data-full
       if (expanded && el.dataset.full && !el.dataset.rich){
         el.textContent = el.dataset.full;
       } else if (!expanded && el.dataset.preview && !el.dataset.rich){
         el.textContent = el.dataset.preview;
       }
       t.textContent = expanded ? "Voir moins" : "Voir plus";
     }, true);
   })();
   </script>';
        }


        global $DB;

        $id = $item->fields['id'];
        $canedit = $item->can($id, UPDATE);
        $rand = mt_rand(1, mt_getrandmax());

        $iterator = static::getRequest($item);
        $number = count($iterator);
        $items_list = [];
        $used = [];

        // Préparer les données à afficher
        foreach ($iterator as $id => $data) {
            $items_list[$data['linkid']] = $data;
            $used[$data['id']] = $data['id'];
        }



        $massiveaction_processor = PluginDlteamsTicketTask_Plannification::class;
        echo "<div class='spaced'>";

        // Affichage du formulaire d'actions massives
        if ($canedit && $number) {
            Html::openMassiveActionsForm('mass' . $massiveaction_processor . $rand);
            Html::showMassiveActions([
                'container' => 'mass' . $massiveaction_processor . $rand,
                'num_displayed' => min($_SESSION['glpilist_limit'], $number)
            ]);

            echo "<a href='/marketplace/dlteams/front/tickettask.form.php?_projects_id=" . $item->fields["id"] . "' target='_blank' 
                  class='btn btn-primary btn-sm' 
                  style='width: fit-content;' 
                  title='Créer une nouvelle tâche liée à cet élément'>
                  <i class='fas fa-plus'></i> " . _x('button', 'Ajouter ') . "</a>";
        }

        echo "<table class='tab_cadre_fixehov'>";

        // Génération de l'en-tête du tableau
        echo "<tr>";
        if ($canedit && $number) {
            echo "<th width='10'>" . Html::getCheckAllAsCheckbox('mass' . $massiveaction_processor . $rand) . "</th>";
        }
        echo "<th>" . __("Id") . "</th>";
        echo "<th>" . __("Content") . "</th>";
        echo "<th>" . __("Gabarit") . "</th>";
        echo "<th>" . __("Statut") . "</th>";
        echo "<th>" . __("Date planning") . "</th>";
        echo "<th>" . __("Durée réelle") . "</th>";
        echo "<th>" . __("Acteur") . "</th>";
        echo "<th>" . __("Groupe") . "</th>";
        echo "<th>" . __("Echéance") . "</th>";
        echo "</tr>";

        // Remplissage du tableau avec les données
        foreach ($items_list as $data) {
            $styles = isset($data["tickettasks_id"]) ? "style=\"background-color: beige;\"" : "";
            echo "<tr $styles class='tab_bg_1'>";

            if ($canedit && $number) {
                echo "<td width='10'>";
                Html::showMassiveActionCheckBox($massiveaction_processor, $data['linkid']);
                echo "</td>";
            }

            $linkid = (int)$data["linkid"];
            $name = "<a href='" . PluginDlteamsTicketTask::getFormURLWithID($linkid) . "' target='_blank'><i class='editma' data-id='$linkid' class='fa fa-edit' style='cursor:pointer;'></i>&nbsp;" . $linkid . "</a>";
            echo "<td class='left'>" . $name . "</td>";

            // === Cellule "content" avec clamp + toggle ===
            // 1) version "preview" texte (fallback server-side) : on nettoie & tronque pour éviter les lignes immenses
            $raw_content = (string)($data["content"] ?? "");
            $plain_for_preview = trim(preg_replace('/\s+/u', ' ', strip_tags(html_entity_decode($raw_content, ENT_QUOTES | ENT_HTML5, 'UTF-8'))));
            $preview_len = 220; // ajuste la longueur pour la preview fallback
            $preview_text = mb_strimwidth($plain_for_preview, 0, $preview_len, "…", 'UTF-8');

            // 2) Choix d’affichage : si tu veux garder le HTML riche, passe par innerHTML et ne mets pas data-full texte
            //    Ici, on garde HTML tel quel dans la vue "clampée", et on marque data-rich="1"
            $content_id = "dlc_" . $linkid;
            $has_long = (mb_strlen($plain_for_preview, 'UTF-8') > $preview_len || substr_count($raw_content, "\n") >= 3);

            echo "<td class='left'>";

            // Bloc clampé : HTML riche autorisé (si ton contenu est déjà filtré côté GLPI)
            // Si tu préfères éviter tout HTML pour la liste: remplace par nl2br(htmlspecialchars($preview_text, ...)) et data-rich=0
            echo "<div id='" . $content_id . "' class='dl-clamp' data-rich='1' " .
                "data-preview=\"" . htmlspecialchars($preview_text, ENT_QUOTES | ENT_HTML5, 'UTF-8') . "\" " .
                "data-full=\"\">"; // on n injecte pas la version full texte si on garde le HTML
            // Affichage initial (clamp CSS fera le job). On décode si tu stockes encodé.
            echo htmlspecialchars_decode($raw_content, ENT_QUOTES);
            echo "</div>";

            if ($has_long) {
                echo "<a class='dl-clamp-toggle' data-target='" . $content_id . "'>Voir plus</a>";
            }

            echo "</td>";

            // Gabarit
            echo "<td class='left'>" . ($data["templatename"] ?? "--") . "</td>";

            // Statut
            echo "<td class='left'>" . Planning::getStatusIcon($data['state']) . "</td>";

            // Date de planification
            $begin_ts = !empty($data["begin"]) ? strtotime($data["begin"]) : null;
            echo "<td class='left'>" . ($begin_ts ? date('d-m-Y H:i', $begin_ts) : "--") . "</td>";

            // Échéance
            echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'>" : "'>") . PluginDlteamsToolbox::timestampToString($data["actiontime"], false, false) . "</td>";

            // Acteur
            echo "<td class='left'>" . sprintf("%s %s", ($data["user_firstname"] ?? ""), ($data["user_realaname"] ?? "")) . "</td>";

            // Groupe
            echo "<td class='left'>" . ($data["group_completename"] ?? "--") . "</td>";

            // Date (format FR long via IntlDateFormatter) – correction: $row -> $data
            $date_val = $data["date"] ?? ($row->fields["date"] ?? null); // si tu as encore $row dans ton scope
            if (!empty($date_val)) {
                try {
                    $formatter = new IntlDateFormatter('fr_FR', IntlDateFormatter::FULL, IntlDateFormatter::NONE);
                    $date = $formatter->format(new DateTime($date_val));
                } catch (\Throwable $e) {
                    $date = "--";
                }
            } else {
                $date = "--";
            }
            echo "<td class='left'>" . $date . "</td>";

            echo "</tr>";
        }

        echo "</table>";
        Html::closeForm();

        // Script JS pour l'édition
        echo "<script>
        $(document).ready(function () {
            $('.btn-updatetask').on('click', function () {
                var link_id = $(this).attr('data-row-id');
                glpi_ajax_dialog({
                    dialogclass: 'modal-xl',
                    bs_focus: false,
                    url: '/marketplace/dlteams/ajax/tickettask_plannif.php?itemtype=TicketTask&items_id=' + link_id + '&edittickettask=true',
                    params: { linkid: link_id },
                    title: i18n.textdomain('dlteams').__('Action', 'dlteams'),
                    close: function () {},
                    fail: function () { displayAjaxMessageAfterRedirect(); }
                });
            });
            
            
            $('.editma').off('click').click(function(e) {
                    glpi_ajax_dialog({
                        dialogclass: 'modal-lg',
                        bs_focus: false,
                        url: '/marketplace/dlteams/ajax/tickettask_plannif.php',
                        params: {
                            action: 'edit_tickettask_planif',
                            linkid: $(this).data('id'),
                            action: 'update',
                        },
                        title: i18n.textdomain('dlteams').__('Modifier une planification', 'dlteams'),
                        close: function () {},
                        fail: function () {
                            displayAjaxMessageAfterRedirect();
                        }
                    });
                });
        });
    </script>";


        echo "</div>";
    }


    public function post_purgeItem()
    {
//        purge relations
        $relation_item_str = $this->fields["itemtype"] . "_Item";
        $relation_item = new $relation_item_str();
        $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype"]))) . "s_id";

        $criteria = [
            "itemtype" => static::$itemtype_2,
            "items_id" => $this->fields[static::$items_id_1],
            $relation_column_id => $this->fields["items_id"],
            "comment" => $this->fields["comment"]
        ];

        $relation_item->deleteByCriteria($criteria);
    }

    public function post_updateItem($history = 1)
    {
        $relation_item_str = $this->fields["itemtype"] . "_Item";
        $relation_item = new $relation_item_str();
        $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype"]))) . "s_id";

        $criteria = [
            "itemtype" => static::$itemtype_2,
            "items_id" => $this->fields[static::$items_id_1],
            $relation_column_id => $this->fields["items_id"],
            "comment" => $this->oldvalues["comment"]
        ];

        $relation_item->deleteByCriteria($criteria);
        $relation_item->add([
            ...$criteria,
            "comment" => $this->fields["comment"]
        ]);
    }

    function rawSearchOptions()
    {
        $tab[] = [
            'id' => '44',
            'table' => static::getTable(),
            'field' => 'comment',
            'datatype' => 'text',
            'name' => __("Commentaire"),
            'forcegroupby' => true,
            'massiveaction' => true,
        ];

        return $tab;
    }

    public function getForbiddenStandardMassiveAction()
    {
        $forbidden = parent::getForbiddenStandardMassiveAction();
        $forbidden[] = 'clone';
        $forbidden[] = 'MassiveAction:add_transfer_list';
        $forbidden[] = 'MassiveAction:amend_comment';
        return $forbidden;
    }

    public static function getRequest(CommonDBTM $item, $todo = false)
    {
        global $DB;

        if ($item::getType() !== Project::class) {
            return [];
        }

        // Aliases de tables
        $tti = PluginDlteamsTicketTask_Item::getTable();  // pivot
        $tt  = TicketTask::getTable();                    // glpi_tickettasks
        $t   = Ticket::getTable();
        $tpl = TaskTemplate::getTable();
        $u   = User::getTable();
        $g   = Group::getTable();

        $item_id = (int)$item->fields['id'];

        // -------- Requête 1 : liaisons directes (tti.tickettasks_id = tt.id)
        $query1 = [
            'SELECT' => [
                "$tt.id AS linkid",
                "$t.id AS id",
                "$tt.content AS content",
                "$tt.*",
                "$t.name AS name",
                "$tpl.name AS templatename",
                "$u.firstname as user_firstname",
                "$u.realname  as user_realaname",
                "$g.completename as group_completename",
            ],
            'FROM' => $tti,
            'LEFT JOIN' => [
                $tt => [
                    'ON' => [ $tti => 'tickettasks_id', $tt => 'id' ]
                ],
                $t => [
                    'ON' => [ $tt => 'tickets_id', $t => 'id' ]
                ],
                $tpl => [
                    'ON' => [ $tt => 'tasktemplates_id', $tpl => 'id' ]
                ],
                $u => [
                    'ON' => [ $tt => 'users_id_tech', $u => 'id' ]
                ],
                $g => [
                    'ON' => [ $tt => 'groups_id_tech', $g => 'id' ]
                ],
            ],
            // OR à la racine, exactement comme dans ton code initial
            'OR' => [[
                "$tti.items_id" => $item_id,
                "$tti.itemtype" => $item::getType(),
            ]],
            'ORDER' => [ "$tt.id ASC" ],
        ];

        $it1 = $DB->request($query1);

        $rows   = [];
        $linkId = [];

        foreach ($it1 as $row) {
            $rows[] = $row;
            if (!empty($row['linkid'])) {
                $linkId[] = (int)$row['linkid'];
            }
        }

        // -------- Requête 2 : tâches dont tt.tickettasks_id = linkid (IN (...))
        if (!empty($linkId)) {
            $linkId = array_values(array_unique($linkId));

            $query2 = [
                'SELECT' => [
                    "tt.id AS linkid",
                    "t.id AS id",
                    "tt.content AS content",
                    "tt.*",
                    "t.name AS name",
                    "tpl.name AS templatename",
                    "u.firstname as user_firstname",
                    "u.realname  as user_realaname",
                    "g.completename as group_completename",
                ],
                'FROM' => "$tt AS tt",
                'LEFT JOIN' => [
                    "$t AS t" => [
                        'ON' => [ 'tt' => 'tickets_id', 't' => 'id' ]
                    ],
                    "$tpl AS tpl" => [
                        'ON' => [ 'tt' => 'tasktemplates_id', 'tpl' => 'id' ]
                    ],
                    "$u AS u" => [
                        'ON' => [ 'tt' => 'users_id_tech', 'u' => 'id' ]
                    ],
                    "$g AS g" => [
                        'ON' => [ 'tt' => 'groups_id_tech', 'g' => 'id' ]
                    ],
                ],
                'WHERE' => [
                    'tt.tickettasks_id' => $linkId, // IN (...)
                ],
                'ORDER' => [ 'tt.id ASC' ],
            ];

            $it2 = $DB->request($query2);
            foreach ($it2 as $row2) {
                $rows[] = $row2;
            }
        }

        return $rows;
    }


}