<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software. 
 It disallow others people than DLPlace developers to distribute, sell, 
 or add additional requirements to this software. 
 Though, a limited set of safe added requirements can be allowed, but 
 for private or internal usage only ;  without even the implied warranty 
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

$querys = [
    "ALTER TABLE glpi_plugin_dlteams_riskassessments ADD COLUMN IF NOT EXISTS entity_model int unsigned DEFAULT NULL AFTER date_mod;",
    "ALTER TABLE glpi_plugin_dlteams_riskassessments ADD COLUMN IF NOT EXISTS id_model int unsigned DEFAULT NULL AFTER entity_model;",
    "ALTER TABLE glpi_plugin_dlteams_riskassessments ADD COLUMN IF NOT EXISTS date_majmodel timestamp NULL DEFAULT NULL AFTER id_model;",
    "ALTER TABLE glpi_plugin_dlteams_riskassessments ADD COLUMN IF NOT EXISTS type_majmodel tinyint(1) unsigned DEFAULT NULL AFTER date_majmodel;",

    "ALTER TABLE glpi_plugin_dlteams_audits DROP COLUMN IF EXISTS copy_id;",
    "ALTER TABLE glpi_plugin_dlteams_audits DROP COLUMN IF EXISTS copy_entityid;",
    "ALTER TABLE glpi_plugin_dlteams_audits DROP COLUMN IF EXISTS copy_date;",
    "ALTER TABLE glpi_plugin_dlteams_audits DROP COLUMN IF EXISTS copy_update;",

    "ALTER TABLE glpi_plugin_dlteams_audits ADD COLUMN IF NOT EXISTS entity_model int unsigned DEFAULT NULL AFTER date_mod;",
    "ALTER TABLE glpi_plugin_dlteams_audits ADD COLUMN IF NOT EXISTS id_model int unsigned DEFAULT NULL AFTER entity_model;",
    "ALTER TABLE glpi_plugin_dlteams_audits ADD COLUMN IF NOT EXISTS date_majmodel timestamp NULL DEFAULT NULL AFTER id_model;",
    "ALTER TABLE glpi_plugin_dlteams_audits ADD COLUMN IF NOT EXISTS type_majmodel tinyint(1) unsigned DEFAULT NULL AFTER date_majmodel;",

    "ALTER TABLE glpi_plugin_dlteams_protectivemeasures DROP COLUMN IF EXISTS copy_id;",
    "ALTER TABLE glpi_plugin_dlteams_protectivemeasures DROP COLUMN IF EXISTS copy_entityid;",
    "ALTER TABLE glpi_plugin_dlteams_protectivemeasures DROP COLUMN IF EXISTS copy_date;",
    "ALTER TABLE glpi_plugin_dlteams_protectivemeasures DROP COLUMN IF EXISTS copy_update;",

    "ALTER TABLE glpi_plugin_dlteams_protectivemeasures ADD COLUMN IF NOT EXISTS entity_model int unsigned DEFAULT NULL AFTER date_mod;",
    "ALTER TABLE glpi_plugin_dlteams_protectivemeasures ADD COLUMN IF NOT EXISTS id_model int unsigned DEFAULT NULL AFTER entity_model;",
    "ALTER TABLE glpi_plugin_dlteams_protectivemeasures ADD COLUMN IF NOT EXISTS date_majmodel timestamp NULL DEFAULT NULL AFTER id_model;",
    "ALTER TABLE glpi_plugin_dlteams_protectivemeasures ADD COLUMN IF NOT EXISTS type_majmodel tinyint(1) unsigned DEFAULT NULL AFTER date_majmodel;",

    "ALTER TABLE glpi_plugin_dlteams_datacarriertypes ADD COLUMN IF NOT EXISTS entity_model int unsigned DEFAULT NULL AFTER date_mod;",
    "ALTER TABLE glpi_plugin_dlteams_datacarriertypes ADD COLUMN IF NOT EXISTS id_model int unsigned DEFAULT NULL AFTER entity_model;",
    "ALTER TABLE glpi_plugin_dlteams_datacarriertypes ADD COLUMN IF NOT EXISTS date_majmodel timestamp NULL DEFAULT NULL AFTER id_model;",
    "ALTER TABLE glpi_plugin_dlteams_datacarriertypes ADD COLUMN IF NOT EXISTS type_majmodel tinyint(1) unsigned DEFAULT NULL AFTER date_majmodel;",

    "ALTER TABLE glpi_appliances DROP COLUMN IF EXISTS copy_id;",
    "ALTER TABLE glpi_appliances DROP COLUMN IF EXISTS copy_entityid;",
    "ALTER TABLE glpi_appliances DROP COLUMN IF EXISTS copy_date;",
    "ALTER TABLE glpi_appliances DROP COLUMN IF EXISTS copy_update;",

    "ALTER TABLE glpi_appliances ADD COLUMN IF NOT EXISTS entity_model int unsigned DEFAULT NULL AFTER date_mod;",
    "ALTER TABLE glpi_appliances ADD COLUMN IF NOT EXISTS id_model int unsigned DEFAULT NULL AFTER entity_model;",
    "ALTER TABLE glpi_appliances ADD COLUMN IF NOT EXISTS date_majmodel timestamp NULL DEFAULT NULL AFTER id_model;",
    "ALTER TABLE glpi_appliances ADD COLUMN IF NOT EXISTS type_majmodel tinyint(1) unsigned DEFAULT NULL AFTER date_majmodel;",

    "ALTER TABLE glpi_plugin_dlteams_policieforms DROP INDEX IF EXISTS name_entities;",
    "ALTER TABLE glpi_plugin_dlteams_policieforms ADD UNIQUE INDEX IF NOT EXISTS name_entities_is_deleted (entities_id, name, is_deleted) USING BTREE;",

    "ALTER TABLE glpi_projecttasks ADD COLUMN IF NOT EXISTS timeline_position tinyint(1) NOT NULL DEFAULT 0 AFTER date_mod;",

    "ALTER TABLE glpi_tickets ADD COLUMN IF NOT EXISTS timeline_position tinyint(1) NOT NULL DEFAULT 0 AFTER date_mod;",

    "ALTER TABLE glpi_plugin_dlteams_datacatalogs MODIFY COLUMN visible_datas text DEFAULT NULL;",
    "ALTER TABLE glpi_plugin_dlteams_datacatalogs MODIFY COLUMN profile_rights text DEFAULT NULL;",
    "ALTER TABLE glpi_plugin_dlteams_datacatalogs MODIFY COLUMN access_means text DEFAULT NULL;",

    "ALTER TABLE glpi_plugin_dlteams_datacarriertypes_items MODIFY COLUMN datacarriertypes_id int unsigned DEFAULT NULL;",
    "ALTER TABLE glpi_plugin_dlteams_datacarriertypes_items MODIFY COLUMN items_id int unsigned DEFAULT NULL;",

    "DROP TABLE IF EXISTS glpi_plugin_dlteams_deliverablevariables;",

    "ALTER TABLE glpi_plugin_dlteams_accountkeys_items ADD COLUMN IF NOT EXISTS groups_id INT UNSIGNED NULL AFTER users_id_tech;",
    "ALTER TABLE glpi_plugin_dlteams_accountkeys_items ADD COLUMN IF NOT EXISTS groups_id_tech INT UNSIGNED NULL AFTER groups_id;",

    "DROP TABLE IF EXISTS glpi_plugin_dlteams_records_externals;",
    "DROP TABLE IF EXISTS glpi_plugin_dlteams_records_legalbasis;",
    "DROP TABLE IF EXISTS glpi_plugin_dlteams_records_personalanddatacategories;",
    "DROP TABLE IF EXISTS glpi_plugin_dlteams_records_storages;",

    "ALTER TABLE glpi_plugin_dlteams_records DROP COLUMN IF EXISTS plugin_dlteams_activitycategories_id;",
    "ALTER TABLE glpi_plugin_dlteams_records DROP COLUMN IF EXISTS zzz_violation_impact;",
    "ALTER TABLE glpi_plugin_dlteams_records DROP COLUMN IF EXISTS zzz_violation_impact_level;",
    "ALTER TABLE glpi_plugin_dlteams_records DROP COLUMN IF EXISTS storage_medium;",
    "ALTER TABLE glpi_plugin_dlteams_records DROP COLUMN IF EXISTS pia_required;",
    "ALTER TABLE glpi_plugin_dlteams_records DROP COLUMN IF EXISTS pia_status;",
    "ALTER TABLE glpi_plugin_dlteams_records DROP COLUMN IF EXISTS conservation_time;",
    "ALTER TABLE glpi_plugin_dlteams_records DROP COLUMN IF EXISTS archive_time;",
    "ALTER TABLE glpi_plugin_dlteams_records DROP COLUMN IF EXISTS archive_required;",

    "ALTER TABLE glpi_projecttasks ADD COLUMN IF NOT EXISTS completename MEDIUMTEXT DEFAULT NULL AFTER comment;",

    "UPDATE glpi_projecttasks SET completename = name WHERE completename IS NULL;",

    "ALTER TABLE glpi_tickettasks ADD COLUMN IF NOT EXISTS tickettasks_id INT UNSIGNED NULL AFTER sourceof_items_id;",
    "ALTER TABLE glpi_tickettasks ADD COLUMN IF NOT EXISTS estimate_duration int unsigned NOT NULL DEFAULT 0 AFTER tickettasks_id;",

    "ALTER TABLE glpi_users ADD COLUMN IF NOT EXISTS microsoft_guid VARCHAR(30) NULL DEFAULT NULL AFTER timeline_date_format;",

    "ALTER TABLE glpi_plugin_dlteams_accountkeys_items ADD COLUMN IF NOT EXISTS is_directory tinyint(1) NOT NULL DEFAULT 0 AFTER comment;",

    "ALTER TABLE glpi_plugin_dlteams_activitycategories ADD COLUMN IF NOT EXISTS number INT UNSIGNED NULL AFTER comment;",
    "ALTER TABLE glpi_plugin_dlteams_activitycategories ADD COLUMN IF NOT EXISTS plugin_dlteams_activitycategories_id INT UNSIGNED NULL AFTER comment;",
    "ALTER TABLE glpi_plugin_dlteams_activitycategories ADD COLUMN IF NOT EXISTS completename MEDIUMTEXT DEFAULT NULL AFTER plugin_dlteams_activitycategories_id;",
    "ALTER TABLE glpi_plugin_dlteams_activitycategories DROP COLUMN IF EXISTS activitycategories_id;",

    "ALTER TABLE glpi_plugin_dlteams_records ADD COLUMN IF NOT EXISTS plugin_dlteams_activitycategories_id INT UNSIGNED NULL AFTER links_id;",
    "ALTER TABLE glpi_plugin_dlteams_records ADD COLUMN IF NOT EXISTS forms_id INT UNSIGNED NULL AFTER plugin_dlteams_activitycategories_id;",
    "ALTER TABLE glpi_plugin_dlteams_records ADD COLUMN IF NOT EXISTS parentnumber INT UNSIGNED DEFAULT 1 AFTER number;",
    "ALTER TABLE glpi_plugin_dlteams_records ADD COLUMN IF NOT EXISTS completenumber DECIMAL (10,2) AFTER parentnumber;",

    "UPDATE glpi_plugin_dlteams_records SET parentnumber = 1 WHERE parentnumber IS NULL;",

    "UPDATE glpi_plugin_dlteams_records SET completenumber = number + parentnumber/100 WHERE completenumber IS NULL;",

    "CREATE TABLE IF NOT EXISTS glpi_plugin_dlteams_vehicles ( id int unsigned NOT NULL AUTO_INCREMENT, is_deleted tinyint(1) NOT NULL DEFAULT 0, entities_id INT unsigned NOT NULL DEFAULT 0, is_recursive tinyint(1) NOT NULL DEFAULT 0, name varchar(255) NOT NULL DEFAULT '', comment mediumtext DEFAULT NULL, manufacturers_id INT UNSIGNED NULL, peripheralmodels_id INT UNSIGNED NULL, motor_type varchar(255) NOT NULL DEFAULT '', doublekey TINYINT(1) NOT NULL DEFAULT 0, plugin_dlteams_vehicletypes_id int unsigned NULL, users_id INT unsigned NOT NULL DEFAULT 0, groups_id INT unsigned NOT NULL DEFAULT 0, taxbenefit decimal (5,2) DEFAULT NULL, otherbenefit decimal (5,2) DEFAULT NULL, nb TINYINT(1) NOT NULL DEFAULT 1, buyingdate timestamp NULL DEFAULT NULL, guarantee INT unsigned NULL, rentalamount decimal (5,2) DEFAULT NULL, firstrental decimal (5,2) DEFAULT NULL, lastrental decimal (5,2) DEFAULT NULL, soldprice decimal (5,2) DEFAULT NULL, typeofpurchase varchar(255) NOT NULL DEFAULT '', rentalperiod varchar(255) NOT NULL DEFAULT '', maintenance decimal (5,2) DEFAULT NULL, withtax TINYINT(1) DEFAULT NULL, suppliers_id INT unsigned DEFAULT NULL, locations_id int unsigned DEFAULT NULL, date_mod timestamp NULL DEFAULT NULL, date_creation timestamp NULL DEFAULT NULL, is_helpdesk_visible TINYINT(1) NOT NULL DEFAULT 0, PRIMARY KEY (id) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='PluginDlteamsVehicle';",
    "ALTER TABLE glpi_plugin_dlteams_riskassessments ADD COLUMN IF NOT EXISTS entity_model int unsigned DEFAULT NULL AFTER date_mod;",
    "ALTER TABLE glpi_plugin_dlteams_riskassessments ADD COLUMN IF NOT EXISTS id_model int unsigned DEFAULT NULL AFTER entity_model;",
    "ALTER TABLE glpi_plugin_dlteams_riskassessments ADD COLUMN IF NOT EXISTS date_majmodel timestamp NULL DEFAULT NULL AFTER id_model;",
    "ALTER TABLE glpi_plugin_dlteams_riskassessments ADD COLUMN IF NOT EXISTS type_majmodel tinyint(1) unsigned DEFAULT NULL AFTER date_majmodel;",

    "ALTER TABLE glpi_plugin_dlteams_audits DROP COLUMN IF EXISTS copy_id;",
    "ALTER TABLE glpi_plugin_dlteams_audits DROP COLUMN IF EXISTS copy_entityid;",
    "ALTER TABLE glpi_plugin_dlteams_audits DROP COLUMN IF EXISTS copy_date;",
    "ALTER TABLE glpi_plugin_dlteams_audits DROP COLUMN IF EXISTS copy_update;",

    "ALTER TABLE glpi_plugin_dlteams_audits ADD COLUMN IF NOT EXISTS entity_model int unsigned DEFAULT NULL AFTER date_mod;",
    "ALTER TABLE glpi_plugin_dlteams_audits ADD COLUMN IF NOT EXISTS id_model int unsigned DEFAULT NULL AFTER entity_model;",
    "ALTER TABLE glpi_plugin_dlteams_audits ADD COLUMN IF NOT EXISTS date_majmodel timestamp NULL DEFAULT NULL AFTER id_model;",
    "ALTER TABLE glpi_plugin_dlteams_audits ADD COLUMN IF NOT EXISTS type_majmodel tinyint(1) unsigned DEFAULT NULL AFTER date_majmodel;",

    "ALTER TABLE glpi_plugin_dlteams_protectivemeasures DROP COLUMN IF EXISTS copy_id;",
    "ALTER TABLE glpi_plugin_dlteams_protectivemeasures DROP COLUMN IF EXISTS copy_entityid;",
    "ALTER TABLE glpi_plugin_dlteams_protectivemeasures DROP COLUMN IF EXISTS copy_date;",
    "ALTER TABLE glpi_plugin_dlteams_protectivemeasures DROP COLUMN IF EXISTS copy_update;",

    "ALTER TABLE glpi_plugin_dlteams_protectivemeasures ADD COLUMN IF NOT EXISTS entity_model int unsigned DEFAULT NULL AFTER date_mod;",
    "ALTER TABLE glpi_plugin_dlteams_protectivemeasures ADD COLUMN IF NOT EXISTS id_model int unsigned DEFAULT NULL AFTER entity_model;",
    "ALTER TABLE glpi_plugin_dlteams_protectivemeasures ADD COLUMN IF NOT EXISTS date_majmodel timestamp NULL DEFAULT NULL AFTER id_model;",
    "ALTER TABLE glpi_plugin_dlteams_protectivemeasures ADD COLUMN IF NOT EXISTS type_majmodel tinyint(1) unsigned DEFAULT NULL AFTER date_majmodel;",

    "ALTER TABLE glpi_plugin_dlteams_datacarriertypes ADD COLUMN IF NOT EXISTS entity_model int unsigned DEFAULT NULL AFTER date_mod;",
    "ALTER TABLE glpi_plugin_dlteams_datacarriertypes ADD COLUMN IF NOT EXISTS id_model int unsigned DEFAULT NULL AFTER entity_model;",
    "ALTER TABLE glpi_plugin_dlteams_datacarriertypes ADD COLUMN IF NOT EXISTS date_majmodel timestamp NULL DEFAULT NULL AFTER id_model;",
    "ALTER TABLE glpi_plugin_dlteams_datacarriertypes ADD COLUMN IF NOT EXISTS type_majmodel tinyint(1) unsigned DEFAULT NULL AFTER date_majmodel;",

    "ALTER TABLE glpi_appliances DROP COLUMN IF EXISTS copy_id;",
    "ALTER TABLE glpi_appliances DROP COLUMN IF EXISTS copy_entityid;",
    "ALTER TABLE glpi_appliances DROP COLUMN IF EXISTS copy_date;",
    "ALTER TABLE glpi_appliances DROP COLUMN IF EXISTS copy_update;",

    "ALTER TABLE glpi_appliances ADD COLUMN IF NOT EXISTS entity_model int unsigned DEFAULT NULL AFTER date_mod;",
    "ALTER TABLE glpi_appliances ADD COLUMN IF NOT EXISTS id_model int unsigned DEFAULT NULL AFTER entity_model;",
    "ALTER TABLE glpi_appliances ADD COLUMN IF NOT EXISTS date_majmodel timestamp NULL DEFAULT NULL AFTER id_model;",
    "ALTER TABLE glpi_appliances ADD COLUMN IF NOT EXISTS type_majmodel tinyint(1) unsigned DEFAULT NULL AFTER date_majmodel;",

    "ALTER TABLE glpi_plugin_dlteams_policieforms DROP INDEX IF EXISTS name_entities;",
    "ALTER TABLE glpi_plugin_dlteams_policieforms ADD UNIQUE INDEX IF NOT EXISTS name_entities_is_deleted (entities_id, name, is_deleted) USING BTREE;",

    "ALTER TABLE glpi_projecttasks ADD COLUMN IF NOT EXISTS timeline_position tinyint(1) NOT NULL DEFAULT 0 AFTER date_mod;",
    "ALTER TABLE glpi_tickets ADD COLUMN IF NOT EXISTS timeline_position tinyint(1) NOT NULL DEFAULT 0 AFTER date_mod;",

    "ALTER TABLE glpi_plugin_dlteams_datacatalogs MODIFY COLUMN visible_datas text DEFAULT NULL;",
    "ALTER TABLE glpi_plugin_dlteams_datacatalogs MODIFY COLUMN profile_rights text DEFAULT NULL;",
    "ALTER TABLE glpi_plugin_dlteams_datacatalogs MODIFY COLUMN access_means text DEFAULT NULL;",

    "ALTER TABLE glpi_plugin_dlteams_datacarriertypes_items MODIFY COLUMN datacarriertypes_id int unsigned DEFAULT NULL;",
    "ALTER TABLE glpi_plugin_dlteams_datacarriertypes_items MODIFY COLUMN items_id int unsigned DEFAULT NULL;",

    "DROP TABLE IF EXISTS glpi_plugin_dlteams_deliverablevariables;",

    "ALTER TABLE glpi_plugin_dlteams_accountkeys_items ADD COLUMN IF NOT EXISTS groups_id INT UNSIGNED NULL AFTER users_id_tech;",
    "ALTER TABLE glpi_plugin_dlteams_accountkeys_items ADD COLUMN IF NOT EXISTS groups_id_tech INT UNSIGNED NULL AFTER groups_id;",

    "DROP TABLE IF EXISTS glpi_plugin_dlteams_records_externals;",
    "DROP TABLE IF EXISTS glpi_plugin_dlteams_records_legalbasis;",
    "DROP TABLE IF EXISTS glpi_plugin_dlteams_records_personalanddatacategories;",
    "DROP TABLE IF EXISTS glpi_plugin_dlteams_records_storages;",

    "ALTER TABLE glpi_plugin_dlteams_records DROP COLUMN IF EXISTS plugin_dlteams_activitycategories_id;",
    "ALTER TABLE glpi_plugin_dlteams_records DROP COLUMN IF EXISTS zzz_violation_impact;",
    "ALTER TABLE glpi_plugin_dlteams_records DROP COLUMN IF EXISTS zzz_violation_impact_level;",
    "ALTER TABLE glpi_plugin_dlteams_records DROP COLUMN IF EXISTS storage_medium;",
    "ALTER TABLE glpi_plugin_dlteams_records DROP COLUMN IF EXISTS pia_required;",
    "ALTER TABLE glpi_plugin_dlteams_records DROP COLUMN IF EXISTS pia_status;",
    "ALTER TABLE glpi_plugin_dlteams_records DROP COLUMN IF EXISTS conservation_time;",
    "ALTER TABLE glpi_plugin_dlteams_records DROP COLUMN IF EXISTS archive_time;",
    "ALTER TABLE glpi_plugin_dlteams_records DROP COLUMN IF EXISTS archive_required;",

    "ALTER TABLE glpi_projecttasks ADD COLUMN IF NOT EXISTS completename MEDIUMTEXT DEFAULT NULL AFTER comment;",
    "UPDATE glpi_projecttasks SET completename = name WHERE completename IS NULL;",

    "ALTER TABLE glpi_tickettasks ADD COLUMN IF NOT EXISTS tickettasks_id INT UNSIGNED NULL AFTER sourceof_items_id;",
    "ALTER TABLE glpi_tickettasks ADD COLUMN IF NOT EXISTS estimate_duration int unsigned NOT NULL DEFAULT 0 AFTER tickettasks_id;",

    "ALTER TABLE glpi_users ADD COLUMN IF NOT EXISTS microsoft_guid VARCHAR(30) NULL DEFAULT NULL AFTER timeline_date_format;",
    "ALTER TABLE glpi_plugin_dlteams_accountkeys_items ADD COLUMN IF NOT EXISTS is_directory tinyint(1) NOT NULL DEFAULT 0 AFTER comment;",

    "ALTER TABLE glpi_plugin_dlteams_activitycategories ADD COLUMN IF NOT EXISTS number INT UNSIGNED NULL AFTER comment;",
    "ALTER TABLE glpi_plugin_dlteams_activitycategories ADD COLUMN IF NOT EXISTS plugin_dlteams_activitycategories_id INT UNSIGNED NULL AFTER comment;",
    "ALTER TABLE glpi_plugin_dlteams_activitycategories ADD COLUMN IF NOT EXISTS completename MEDIUMTEXT DEFAULT NULL AFTER plugin_dlteams_activitycategories_id;",
    "ALTER TABLE glpi_plugin_dlteams_activitycategories DROP COLUMN IF EXISTS activitycategories_id;",

    "ALTER TABLE glpi_plugin_dlteams_records ADD COLUMN IF NOT EXISTS plugin_dlteams_activitycategories_id INT UNSIGNED NULL AFTER links_id;",
    "ALTER TABLE glpi_plugin_dlteams_records ADD COLUMN IF NOT EXISTS forms_id INT UNSIGNED NULL AFTER plugin_dlteams_activitycategories_id;",
    "ALTER TABLE glpi_plugin_dlteams_records ADD COLUMN IF NOT EXISTS parentnumber INT UNSIGNED DEFAULT 1 AFTER number;",
    "ALTER TABLE glpi_plugin_dlteams_records ADD COLUMN IF NOT EXISTS completenumber DECIMAL (10,2) AFTER parentnumber;",

    "UPDATE glpi_plugin_dlteams_records SET parentnumber = 1 WHERE parentnumber IS NULL;",
    "UPDATE glpi_plugin_dlteams_records SET completenumber = number + parentnumber/100 WHERE completenumber IS NULL;",

    "CREATE TABLE IF NOT EXISTS glpi_plugin_dlteams_vehicles ( id int unsigned NOT NULL AUTO_INCREMENT, is_deleted tinyint(1) NOT NULL DEFAULT 0, entities_id INT unsigned NOT NULL DEFAULT 0, is_recursive tinyint(1) NOT NULL DEFAULT 0, name varchar(255) NOT NULL DEFAULT '', comment mediumtext DEFAULT NULL, manufacturers_id INT UNSIGNED NULL, peripheralmodels_id INT UNSIGNED NULL, motor_type varchar(255) NOT NULL DEFAULT '', doublekey TINYINT(1) NOT NULL DEFAULT 0, plugin_dlteams_vehicletypes_id int unsigned NULL, users_id INT unsigned NOT NULL DEFAULT 0, groups_id INT unsigned NOT NULL DEFAULT 0, taxbenefit decimal (5,2) DEFAULT NULL, otherbenefit decimal (5,2) DEFAULT NULL, nb TINYINT(1) NOT NULL DEFAULT 1, buyingdate timestamp NULL DEFAULT NULL, guarantee INT unsigned NULL, rentalamount decimal (5,2) DEFAULT NULL, firstrental decimal (5,2) DEFAULT NULL, lastrental decimal (5,2) DEFAULT NULL, soldprice decimal (5,2) DEFAULT NULL, typeofpurchase varchar(255) NOT NULL DEFAULT '', rentalperiod varchar(255) NOT NULL DEFAULT '', maintenance decimal (5,2) DEFAULT NULL, withtax TINYINT(1) DEFAULT NULL, suppliers_id INT unsigned DEFAULT NULL, locations_id int unsigned DEFAULT NULL, date_mod timestamp NULL DEFAULT NULL, date_creation timestamp NULL DEFAULT NULL, is_helpdesk_visible TINYINT(1) NOT NULL DEFAULT 0, PRIMARY KEY (id) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='PluginDlteamsVehicle';",

    "CREATE TABLE IF NOT EXISTS glpi_plugin_dlteams_vehicletypes ( id int unsigned NOT NULL AUTO_INCREMENT, name varchar(255) DEFAULT NULL, comment mediumtext DEFAULT NULL, entities_id int unsigned NOT NULL DEFAULT 0, is_recursive tinyint(1) NOT NULL DEFAULT 0, date_mod timestamp NULL DEFAULT NULL, date_creation timestamp NULL DEFAULT NULL, PRIMARY KEY (id) ) ENGINE = InnoDB;",

    "ALTER TABLE glpi_plugin_dlteams_policieforms_items ADD COLUMN IF NOT EXISTS items_id1 int unsigned DEFAULT NULL AFTER itemtype;",
    "ALTER TABLE glpi_plugin_dlteams_policieforms_items ADD COLUMN IF NOT EXISTS itemtype1 varchar(255) DEFAULT NULL AFTER items_id1;",

    "CREATE TABLE IF NOT EXISTS glpi_plugin_dlteams_suppliers_items ( id int UNSIGNED NOT NULL AUTO_INCREMENT, suppliers_id int UNSIGNED NOT NULL DEFAULT 0, itemtype varchar(255) NOT NULL, items_id int UNSIGNED NOT NULL DEFAULT 0, itemtype1 varchar(255) DEFAULT NULL, items_id1 int unsigned NOT NULL DEFAULT 0, comment varchar(255) DEFAULT NULL, foreign_id int UNSIGNED NOT NULL DEFAULT 0, date_creation timestamp NULL, date_mod timestamp NULL, PRIMARY KEY (id) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",

    "CREATE TABLE IF NOT EXISTS glpi_plugin_dlteams_sendingreasons_items ( id int UNSIGNED NOT NULL AUTO_INCREMENT, sendingreasons_id int UNSIGNED NOT NULL, itemtype varchar(255) NOT NULL, items_id int UNSIGNED NOT NULL DEFAULT 0, itemtype1 varchar(255) NOT NULL, items_id1 int unsigned NOT NULL DEFAULT 0, comment varchar(255) NOT NULL, foreign_id int UNSIGNED NOT NULL DEFAULT 0, date_creation timestamp NULL DEFAULT NULL, date_mod timestamp NULL DEFAULT NULL, PRIMARY KEY (id) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",

    "CREATE TABLE IF NOT EXISTS glpi_plugin_dlteams_accessopenings ( id int unsigned NOT NULL AUTO_INCREMENT, is_deleted tinyint(1) NOT NULL DEFAULT 0, entities_id INT unsigned NOT NULL DEFAULT 0, is_recursive tinyint(1) NOT NULL DEFAULT 0, name varchar(255) NOT NULL DEFAULT '', comment mediumtext DEFAULT NULL, locations_id int unsigned DEFAULT NULL, date_mod timestamp NULL DEFAULT NULL, date_creation timestamp NULL DEFAULT NULL, is_helpdesk_visible TINYINT(1) NOT NULL DEFAULT 0, PRIMARY KEY (id) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='PluginDlteamsAccessOpening';",

    "ALTER TABLE glpi_plugin_dlteams_audits CHANGE COLUMN IF EXISTS plugin_dlregister_auditcategories_id plugin_dlteams_auditcategories_id int unsigned DEFAULT NULL;",

    "CREATE TABLE IF NOT EXISTS glpi_plugin_dlteams_accessopenings_items ( id int UNSIGNED NOT NULL AUTO_INCREMENT, accessopenings_id int UNSIGNED NOT NULL DEFAULT 0, itemtype varchar(255) NOT NULL, items_id int UNSIGNED NOT NULL DEFAULT 0, itemtype1 varchar(255) DEFAULT NULL, items_id1 int unsigned NOT NULL DEFAULT 0, comment varchar(255) DEFAULT NULL, foreign_id int UNSIGNED NOT NULL DEFAULT 0, date_creation timestamp NULL, date_mod timestamp NULL, PRIMARY KEY (id) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",

    "CREATE TABLE IF NOT EXISTS glpi_plugin_dlteams_locations_items ( id int UNSIGNED NOT NULL AUTO_INCREMENT, locations_id int UNSIGNED NOT NULL DEFAULT 0, itemtype varchar(255) NOT NULL, items_id int UNSIGNED NOT NULL DEFAULT 0, comment varchar(255) DEFAULT NULL, date_creation timestamp NULL, date_mod timestamp NULL, PRIMARY KEY (id) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",

    "ALTER TABLE glpi_itilfollowups ADD COLUMN IF NOT EXISTS parent_comment_id INT UNSIGNED NULL AFTER content;",

    "ALTER TABLE glpi_plugin_dlteams_records ADD COLUMN IF NOT EXISTS is_grouping TINYINT NOT NULL DEFAULT '0' AFTER content;",

    "ALTER TABLE glpi_itilfollowups ADD COLUMN IF NOT EXISTS date_creation TIMESTAMP NULL AFTER content;",
    "ALTER TABLE glpi_itilfollowups ADD COLUMN IF NOT EXISTS date_mod TIMESTAMP NULL AFTER date_creation;",
    "ALTER TABLE glpi_itilfollowups ADD COLUMN IF NOT EXISTS entities_id INT UNSIGNED NOT NULL DEFAULT 0;",

    "ALTER TABLE glpi_plugin_dlteams_rightmeasures ADD COLUMN IF NOT EXISTS rightmeasurecategories LONGTEXT NULL AFTER comment;",

    "ALTER TABLE glpi_plugin_dlteams_records ADD COLUMN IF NOT EXISTS users_id_auditor INT UNSIGNED DEFAULT NULL AFTER comment;",
    "ALTER TABLE glpi_plugin_dlteams_records ADD COLUMN IF NOT EXISTS targettickets_id INT UNSIGNED DEFAULT 0 AFTER users_id_auditor;",
    "ALTER TABLE glpi_plugin_dlteams_records ADD COLUMN IF NOT EXISTS deliverables_id INT UNSIGNED DEFAULT 0 AFTER targettickets_id;",

    "ALTER TABLE glpi_plugin_dlteams_policieforms_items DROP INDEX IF EXISTS unicity;",
    "ALTER TABLE glpi_plugin_dlteams_policieforms_items ADD UNIQUE INDEX unicity (policieforms_id, itemtype, items_id, itemtype1, items_id1);",

    "CREATE TABLE IF NOT EXISTS glpi_plugin_dlteams_projecttasks_items ( id int UNSIGNED NOT NULL AUTO_INCREMENT, projecttasks_id int UNSIGNED NOT NULL DEFAULT 0, itemtype varchar(255) NOT NULL, items_id int UNSIGNED NOT NULL DEFAULT 0, comment varchar(255) DEFAULT NULL, date_creation timestamp NULL, date_mod timestamp NULL, PRIMARY KEY (id) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",

    "CREATE TABLE IF NOT EXISTS glpi_plugin_dlteams_rgpdadequacies ( id int unsigned NOT NULL AUTO_INCREMENT, is_deleted tinyint(1) NOT NULL DEFAULT 0, entities_id INT unsigned NOT NULL DEFAULT 0, is_recursive tinyint(1) NOT NULL DEFAULT 0, name varchar(255) NOT NULL DEFAULT '', comment mediumtext DEFAULT NULL, date_mod timestamp NULL DEFAULT NULL, date_creation timestamp NULL DEFAULT NULL, is_helpdesk_visible TINYINT(1) NOT NULL DEFAULT 0, PRIMARY KEY (id) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='PluginDlteamsRgpdAdequacy';",

    "CREATE TABLE IF NOT EXISTS glpi_plugin_dlteams_rgpdadequacies_items ( id int unsigned NOT NULL AUTO_INCREMENT, rgpdadequacies_id int unsigned NOT NULL DEFAULT 0, items_id int unsigned NOT NULL DEFAULT 0, itemtype varchar(100) DEFAULT NULL, items_id1 int unsigned NOT NULL DEFAULT 0, itemtype1 varchar(100) DEFAULT NULL, comment mediumtext DEFAULT NULL, timeline_position tinyint(1) NOT NULL DEFAULT 0, date_creation timestamp NULL DEFAULT NULL, date timestamp NULL DEFAULT NULL, date_mod timestamp NULL DEFAULT NULL, PRIMARY KEY (id), KEY date_mod (date_mod), KEY date_creation (date_creation) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",

    "ALTER TABLE glpi_documents ADD COLUMN IF NOT EXISTS policieforms_id INT UNSIGNED DEFAULT NULL AFTER comment;",
    "ALTER TABLE glpi_documents ADD COLUMN IF NOT EXISTS deliverables_id INT UNSIGNED DEFAULT NULL AFTER comment;",

    "UPDATE glpi_configs SET value = '255' WHERE name = 'url_maxlength';",

    "ALTER TABLE glpi_plugin_dlteams_datacatalogs ADD COLUMN IF NOT EXISTS default_format mediumtext DEFAULT NULL AFTER directory_name;",

    "ALTER TABLE glpi_plugin_dlteams_deliverables ADD COLUMN IF NOT EXISTS documents_id INT UNSIGNED DEFAULT 0 AFTER comment;",

    "ALTER TABLE glpi_plugin_dlteams_activitycategories ADD COLUMN IF NOT EXISTS completename MEDIUMTEXT DEFAULT NULL AFTER comment;",
    "ALTER TABLE glpi_plugin_dlteams_activitycategories ADD COLUMN IF NOT EXISTS level INT(11) NOT NULL DEFAULT '0';",
    "ALTER TABLE glpi_plugin_dlteams_activitycategories ADD COLUMN IF NOT EXISTS ancestors_cache LONGTEXT NULL;",
    "ALTER TABLE glpi_plugin_dlteams_activitycategories ADD COLUMN IF NOT EXISTS sons_cache LONGTEXT NULL;",

    "ALTER TABLE glpi_plugin_dlteams_policieforms ADD COLUMN IF NOT EXISTS activitycategories_idx LONGTEXT NULL AFTER comment;",

    "ALTER TABLE glpi_groups ADD COLUMN IF NOT EXISTS locations_id INT UNSIGNED DEFAULT 1 AFTER comment;",
    "ALTER TABLE glpi_groups ADD COLUMN IF NOT EXISTS email VARCHAR(255) NULL AFTER comment;",
    "ALTER TABLE glpi_groups ADD COLUMN IF NOT EXISTS phonenumber VARCHAR(255) NULL AFTER comment;",
    "ALTER TABLE glpi_groups ADD COLUMN IF NOT EXISTS acronym VARCHAR(255) NULL AFTER comment;",
    "ALTER TABLE glpi_groups ADD COLUMN IF NOT EXISTS number INT UNSIGNED DEFAULT 1 AFTER comment;",
    "ALTER TABLE glpi_groups ADD COLUMN IF NOT EXISTS parentnumber INT UNSIGNED DEFAULT 1 AFTER number;",
    "ALTER TABLE glpi_groups ADD COLUMN IF NOT EXISTS completenumber DECIMAL (10,2) AFTER parentnumber;",

    "ALTER TABLE glpi_plugin_dlteams_records ADD COLUMN IF NOT EXISTS entity_model int unsigned DEFAULT NULL AFTER date_mod;",
    "ALTER TABLE glpi_plugin_dlteams_records ADD COLUMN IF NOT EXISTS id_model int unsigned DEFAULT NULL AFTER entity_model;",
    "ALTER TABLE glpi_plugin_dlteams_records ADD COLUMN IF NOT EXISTS date_majmodel timestamp NULL DEFAULT NULL AFTER id_model;",
    "ALTER TABLE glpi_plugin_dlteams_records ADD COLUMN IF NOT EXISTS type_majmodel tinyint(1) unsigned DEFAULT NULL AFTER date_majmodel;",

    "ALTER TABLE glpi_plugin_dlteams_records MODIFY COLUMN collect_comment TEXT;",

    "ALTER TABLE glpi_groups ADD COLUMN IF NOT EXISTS type VARCHAR(255) NULL AFTER comment;",

    "ALTER TABLE glpi_documentcategories ADD COLUMN IF NOT EXISTS entities_id INT UNSIGNED NOT NULL DEFAULT 0;",

    "ALTER TABLE glpi_documentcategories DROP INDEX IF EXISTS unicity;",
    "ALTER TABLE glpi_documentcategories ADD UNIQUE INDEX IF NOT EXISTS unicity (entities_id, name, documentcategories_id) USING BTREE;",

    "ALTER TABLE glpi_plugin_dlteams_rightmeasures DROP COLUMN IF EXISTS plugin_dlteams_rightmeasurecategories_id;",

    "ALTER TABLE glpi_plugin_dlteams_legalbasis ADD COLUMN IF NOT EXISTS activitycategories_idx LONGTEXT NULL AFTER comment;",

    "ALTER TABLE glpi_plugin_dlteams_deliverables ADD COLUMN IF NOT EXISTS is_internaldocument TINYINT NOT NULL DEFAULT '0' AFTER content;",

    "ALTER TABLE glpi_plugin_dlteams_records ADD COLUMN IF NOT EXISTS is_internaldocument TINYINT NOT NULL DEFAULT '0' AFTER content;",

    "ALTER TABLE glpi_suppliertypes ADD COLUMN IF NOT EXISTS entity_model int unsigned DEFAULT NULL AFTER date_mod;",
    "ALTER TABLE glpi_suppliertypes ADD COLUMN IF NOT EXISTS id_model int unsigned DEFAULT NULL AFTER entity_model;",
    "ALTER TABLE glpi_suppliertypes ADD COLUMN IF NOT EXISTS date_majmodel timestamp NULL DEFAULT NULL AFTER id_model;",
    "ALTER TABLE glpi_suppliertypes ADD COLUMN IF NOT EXISTS type_majmodel tinyint(1) unsigned DEFAULT NULL AFTER date_majmodel;",

    "ALTER TABLE glpi_tickettasks ADD COLUMN IF NOT EXISTS canbevalidated tinyint(1) unsigned DEFAULT '0' AFTER date_creation;",

    "ALTER TABLE glpi_itilfollowups ADD COLUMN IF NOT EXISTS tag VARCHAR(255) NULL AFTER content;",

    "CREATE TABLE IF NOT EXISTS glpi_plugin_dlteams_tickettasks_validations ( id int unsigned NOT NULL AUTO_INCREMENT, entities_id int unsigned NOT NULL DEFAULT 0, users_id int unsigned NOT NULL DEFAULT 0, tickettasks_id int unsigned NOT NULL DEFAULT 0, users_id_validate int unsigned NOT NULL DEFAULT 0, comment_submission text COLLATE utf8mb4_unicode_ci, comment_validation text COLLATE utf8mb4_unicode_ci, status int unsigned NOT NULL DEFAULT 2, submission_date TIMESTAMP DEFAULT NULL, validation_date TIMESTAMP DEFAULT NULL, timeline_position tinyint(1) NOT NULL DEFAULT 0, PRIMARY KEY (id), KEY entities_id (entities_id), KEY users_id (users_id), KEY users_id_validate (users_id_validate), KEY tickettasks_id (tickettasks_id), KEY submission_date (submission_date), KEY validation_date (validation_date), KEY status (status) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",

    "ALTER TABLE glpi_tickettasks ADD COLUMN IF NOT EXISTS global_validation int unsigned NOT NULL DEFAULT 1;",
    "ALTER TABLE glpi_tickettasks ADD COLUMN IF NOT EXISTS validation_percent int unsigned NOT NULL DEFAULT 0;",

    "ALTER TABLE glpi_tickettasks ADD COLUMN IF NOT EXISTS status int unsigned NOT NULL DEFAULT 1;",

    "ALTER TABLE glpi_plugin_dlteams_datacatalogs ADD COLUMN IF NOT EXISTS manage_accountkey tinyint(1) NOT NULL DEFAULT 0;",

    "ALTER TABLE glpi_plugin_dlteams_datacatalogs ADD COLUMN IF NOT EXISTS keyrequired tinyint(1) NOT NULL DEFAULT 0;",

    "CREATE TABLE IF NOT EXISTS glpi_plugin_dlteams_reccurents_tasks ( id int unsigned NOT NULL AUTO_INCREMENT, entities_id int unsigned NOT NULL DEFAULT 0, users_id int unsigned NOT NULL DEFAULT 0, actiontime int unsigned NOT NULL DEFAULT 0, periodicity ENUM('daily', 'weekly', 'monthly', 'yearly'), day_of_week_json mediumtext DEFAULT NULL, day_of_month_json mediumtext DEFAULT NULL, day_of_year_json mediumtext DEFAULT NULL, begin_date TIMESTAMP DEFAULT NULL, end_date TIMESTAMP DEFAULT NULL, occurence_nbr int unsigned NOT NULL DEFAULT 0, PRIMARY KEY (id), KEY entities_id (entities_id), KEY users_id (users_id) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",

    "ALTER TABLE glpi_tickettasks ADD COLUMN IF NOT EXISTS reccurent_tasks_id int unsigned DEFAULT NULL AFTER content;",

    "ALTER TABLE glpi_plugin_dlteams_reccurents_tasks ADD COLUMN IF NOT EXISTS tickettasks_id int unsigned DEFAULT NULL AFTER entities_id;",

    "ALTER TABLE glpi_projects ADD COLUMN IF NOT EXISTS order_type VARCHAR(255) NULL AFTER comment;",

    "ALTER TABLE glpi_projects ADD COLUMN IF NOT EXISTS completename text COLLATE utf8mb4_unicode_ci AFTER comment;",

    "ALTER TABLE glpi_projects ADD COLUMN IF NOT EXISTS number int unsigned NOT NULL DEFAULT 0 AFTER comment;",

    "ALTER TABLE glpi_projects ADD COLUMN IF NOT EXISTS level INT unsigned NOT NULL DEFAULT 0;",
    "ALTER TABLE glpi_projects ADD COLUMN IF NOT EXISTS ancestors_cache LONGTEXT NULL;",
    "ALTER TABLE glpi_projects ADD COLUMN IF NOT EXISTS sons_cache LONGTEXT NULL;",

    "ALTER TABLE glpi_notepads ADD COLUMN IF NOT EXISTS entities_id int unsigned NOT NULL DEFAULT 0;",

    "ALTER TABLE glpi_tickettasks ADD COLUMN IF NOT EXISTS task_review tinyint(1) unsigned DEFAULT 0 AFTER date_creation;",

    "ALTER TABLE glpi_authldaps ADD COLUMN IF NOT EXISTS entities_id int unsigned NOT NULL DEFAULT 0 AFTER id;",
    "ALTER TABLE glpi_authldaps ADD COLUMN IF NOT EXISTS is_recursive tinyint(1) NOT NULL DEFAULT 0 AFTER entities_id;",

    "ALTER TABLE glpi_authmails ADD COLUMN IF NOT EXISTS entities_id int unsigned NOT NULL DEFAULT 0 AFTER id;",
    "ALTER TABLE glpi_authmails ADD COLUMN IF NOT EXISTS is_recursive tinyint(1) NOT NULL DEFAULT 0 AFTER entities_id;",

    "CREATE TABLE IF NOT EXISTS glpi_plugin_dlteams_displayviews ( id int unsigned NOT NULL AUTO_INCREMENT, entities_id int unsigned NOT NULL DEFAULT 0, name varchar(255) NOT NULL DEFAULT '', date_creation timestamp NULL DEFAULT NULL, date_mod timestamp NULL DEFAULT NULL, PRIMARY KEY (id), KEY entities_id (entities_id) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",

    "DROP TABLE IF EXISTS glpi_plugin_dlteams_views;",

    "CREATE TABLE IF NOT EXISTS glpi_plugin_dlteams_displaypreferences ( id int unsigned NOT NULL AUTO_INCREMENT, itemtype varchar(100) NOT NULL, num int unsigned NOT NULL DEFAULT 0, rank int unsigned NOT NULL DEFAULT 0, users_id int unsigned NOT NULL DEFAULT 0, views_id int unsigned NOT NULL DEFAULT 0, PRIMARY KEY (id) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",

    "ALTER TABLE glpi_plugin_formcreator_forms ADD COLUMN IF NOT EXISTS plugin_formcreator_forms_id int unsigned NOT NULL DEFAULT 0 AFTER id;",

    "ALTER TABLE glpi_plugin_formcreator_forms ADD COLUMN IF NOT EXISTS completename MEDIUMTEXT;",

    "ALTER TABLE glpi_plugin_formcreator_forms ADD COLUMN IF NOT EXISTS level int unsigned NOT NULL DEFAULT 0;",
    "ALTER TABLE glpi_plugin_formcreator_forms ADD COLUMN IF NOT EXISTS sons_cache longtext COLLATE utf8mb4_unicode_ci;",
    "ALTER TABLE glpi_plugin_formcreator_forms ADD COLUMN IF NOT EXISTS ancestors_cache longtext COLLATE utf8mb4_unicode_ci;",

    "ALTER TABLE glpi_plugin_dlteams_records ADD COLUMN IF NOT EXISTS report_type tinyint(1) DEFAULT 0;",

    "ALTER TABLE glpi_plugin_dlteams_displayviews ADD COLUMN IF NOT EXISTS itemtype varchar(100) DEFAULT NULL AFTER name;",

    "ALTER TABLE glpi_plugin_dlteams_displayviews ADD COLUMN IF NOT EXISTS users_id INT unsigned NOT NULL DEFAULT 0 AFTER name;",

    "ALTER TABLE glpi_plugin_dlteams_displayviews ADD COLUMN IF NOT EXISTS is_recursive tinyint(1) NOT NULL DEFAULT 1;",

    "ALTER TABLE glpi_plugin_dlteams_displayviews DROP COLUMN IF EXISTS users_id;",

    "ALTER TABLE glpi_itilfollowups ADD COLUMN IF NOT EXISTS solved_state int unsigned NOT NULL DEFAULT 0;",

    "ALTER TABLE glpi_itilfollowups ADD COLUMN IF NOT EXISTS conversation int unsigned DEFAULT NULL;",

    "UPDATE glpi_itilfollowups JOIN glpi_tickets ON glpi_itilfollowups.items_id = glpi_tickets.id SET glpi_itilfollowups.entities_id = glpi_tickets.entities_id WHERE glpi_itilfollowups.itemtype = 'Ticket' AND glpi_itilfollowups.entities_id = 0;",

    "UPDATE glpi_itilfollowups JOIN glpi_tickettasks ON glpi_itilfollowups.items_id = glpi_tickettasks.id JOIN glpi_tickets ON glpi_tickettasks.tickets_id = glpi_tickets.id SET glpi_itilfollowups.entities_id = glpi_tickets.entities_id WHERE glpi_itilfollowups.itemtype = 'PluginDlteamsTicketTask' AND glpi_itilfollowups.entities_id = 0;",

    "ALTER TABLE glpi_plugin_dlteams_concernedpersons ADD COLUMN IF NOT EXISTS number int unsigned NULL DEFAULT NULL AFTER type_majmodel;",

    "UPDATE glpi_plugin_dlteams_concernedpersons SET number = CAST(SUBSTRING_INDEX(name, ' ', 1) AS UNSIGNED) WHERE name REGEXP '^[0-9]+ ' AND number IS NULL;",

    "UPDATE glpi_plugin_dlteams_concernedpersons SET name = REGEXP_REPLACE(name, '^[0-9]+ ?', '') WHERE name REGEXP '^[0-9]+ ';",

    "ALTER TABLE glpi_plugin_formcreator_forms ADD COLUMN IF NOT EXISTS date_mod timestamp NULL DEFAULT NULL;",
    "ALTER TABLE glpi_plugin_formcreator_forms ADD COLUMN IF NOT EXISTS date_creation timestamp NULL DEFAULT NULL;",

    "ALTER TABLE glpi_plugin_dlteams_records CHANGE content content VARCHAR(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL;",

    "ALTER TABLE glpi_plugin_dlteams_processeddatas ADD COLUMN IF NOT EXISTS number int unsigned NULL DEFAULT NULL AFTER type_majmodel;",

    "UPDATE glpi_plugin_dlteams_processeddatas SET number = CAST(SUBSTRING_INDEX(name, ' ', 1) AS UNSIGNED) WHERE name REGEXP '^[0-9]+ ' AND number IS NULL;",

    "UPDATE glpi_plugin_dlteams_processeddatas SET name = REGEXP_REPLACE(name, '^[0-9]+ ?', '') WHERE name REGEXP '^[0-9]+ ';",
    ];

$i = 1;
global $DB;
foreach ($querys as $query) {
		// echo $query . "<br>";
		$result = $DB->query($query) or die("Erreur". $DB->error());
		if ($DB->error) {
			try {    
				throw new Exception("MySQL error $DB->error <br> Query:<br> $query", $msqli->errno);    
			} catch(Exception $e ) {
			echo "Error No: ".$e->getCode(). " - ". $e->getMessage() . "<br >";
			echo nl2br($e->getTraceAsString());
			}
		}
		$i++;
}

// version Alexis octobre 2025 
/*
$i = 1;
global $DB;
foreach ($querys as $query) {
		// echo $query . "<br>";

//    var_dump("zz$i");
    try {
		$result = $DB->request($query);

    }
    catch (Exception $e){
        var_dump($e->getMessage());
    }
	$i++;
}
*/

//    var_dump($DB->error());
//		if ($DB->error) {
//			try {
//				throw new Exception("MySQL error $DB->error <br> Query:<br> $query", $msqli->errno);
//			} catch(Exception $e ) {
//			echo "Error No: ".$e->getCode(). " - ". $e->getMessage() . "<br >";
//			echo nl2br($e->getTraceAsString());
//			}
//		}

