<?php
/**
-------------------------------------------------------------------------
LICENSE

This file is part of Reports plugin for GLPI.

Reports is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Reports is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with Reports. If not, see <http://www.gnu.org/licenses/>.

@package   reports
@authors    Nelly Mahu-Lasson, Remi Collet
@copyright Copyright (c) 2009-2022 Reports plugin team
@license   AGPL License 3.0 or (at your option) any later version
http://www.gnu.org/licenses/agpl-3.0-standalone.html
@link      https://forge.glpi-project.org/projects/reports
@link      http://www.glpi-project.org/
@since     2009
--------------------------------------------------------------------------
 */

$USEDBREPLICATE        = 1;
$DBCONNECTION_REQUIRED = 0; // not really a big SQL request

include ("../../../../inc/includes.php");

$dbu = new DbUtils();

//if(isset($_POST["publish_dlteams"])){
//
//}
/*highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//die();
//TRANS: The name of the report = Location tree
$report = new PluginReportsAutoReport(__('Données traitées par catégories de personnes et par traitement', 'dlteams'));


//Report's search criterias
$date = new PluginReportsDropdownCriteria($report, 'mandatory');
//Display criterias form is needed
$report->displayCriteriasForm();

$report->setColumns([
    new PluginReportsColumn('traitement', __('Traitement'), ['sorton' => 'traitement']),
    new PluginReportsColumn('concernedperson', PluginDlteamsConcernedPerson::getTypeName(), ['sorton' => 'concernedperson']),
    new PluginReportsColumn('processeddata', PluginDlteamsProcessedData::getTypeName(), ['sorton' => 'processeddata']),
    new PluginReportsColumn('mandatory', __('Obligatoire'), ['sorton' => 'mandatory']),
//    new PluginReportsColumn('record_name', __('Traitement'), ['sorton' => 'record_name']),
//    new PluginReportsColumn('entity', __('Entité'), ['sorton' => 'entity']),
]);


// SQL statement
$query = "SELECT UNIQUE 
    t2.`name` AS `traitement`, 
    t3.`name` AS `concernedperson`, 
    t4.`name` AS `processeddata`, 
    CASE 
        WHEN t1.`mandatory` = 1 THEN 'Oui'
        ELSE 'non'
    END AS `mandatory`
FROM `glpi_plugin_dlteams_records_items` AS t1 
INNER JOIN `glpi_plugin_dlteams_records` AS t2
    ON t1.`records_id` = t2.`id`
INNER JOIN `glpi_plugin_dlteams_concernedpersons` AS t3
    ON t1.`items_id` = t3.`id`
INNER JOIN `glpi_plugin_dlteams_processeddatas` AS t4
    ON t1.`items_id1` = t4.`id`
WHERE t1.`itemtype` = 'PluginDlteamsConcernedPerson' 
  AND t1.`itemtype1` = 'PluginDlteamsProcessedData'" .
    $dbu->getEntitiesRestrictRequest(" AND ", "t2") .
    $report->getOrderBy(' t2.`name`, t3.`name`, t1.`items_id`, t1.`items_id1');

//$report->setGroupByAuto('traitement');
$report->setGroupBy(['traitement']);
//$report->
//$report->setGroupBy('registration_number');
//$report->setGroupBy('completenumber');
$report->setSqlRequest($query);
$report->execute();