﻿<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include_once("../../../inc/includes.php");

Session::checkLoginUser();

// Traitement de la soumission du formulaire
if (isset($_POST["select_category"])) {
    $category_id = $_POST["itilcategories_id"] ?? 0;
    
    if ($category_id > 0) {
        // Sauvegarder la catégorie sélectionnée dans la session
        $_SESSION["saveInput"]["Ticket"]["itilcategories_id"] = $category_id;
        
        // Fermer le modal et rediriger
        echo "<script type=\"text/javascript\">";
        echo "parent.$(\".modal\").modal(\"hide\");";
        echo "parent.location.href = \"" . Ticket::getFormURL() . "?itilcategories_id=" . $category_id . "\";";
        echo "</script>";
        exit;
    } else {
        echo "<div class=\"alert alert-danger\">";
        echo "<i class=\"fas fa-exclamation-triangle me-2\"></i>";
        echo __("Veuillez sélectionner une catégorie");
        echo "</div>";
    }
}

// Afficher le formulaire de sélection
echo "<div style=\"padding: 20px;\" class=\"container-fluid\">";
echo "<form method=\"post\" action=\"" . Ticket::getFormURL() . "\">";

echo "<h4 class=\"mb-3\">";
echo "<i class=\"fas fa-tags me-2\"></i>";
echo __("Sélectionner une catégorie pour votre ticket");
echo "</h4>";

echo "<div class=\"alert alert-info mb-3\">";
echo "<i class=\"fas fa-info-circle me-2\"></i>";
echo __("Choisissez une catégorie pour commencer la création de votre ticket. Cette étape vous permettra d'accéder aux champs spécifiques à cette catégorie.");
echo "</div>";

echo "<div class=\"mb-3\">";
echo "<label for=\"itilcategories_id\" class=\"form-label\">";
echo "<strong>" . _n("Category", "Categories", 1) . " *</strong>";
echo "</label>";

$rand = mt_rand();
// Dropdown des catégories ITIL
ITILCategory::dropdown([
    "name" => "itilcategories_id",
    "value" => 0,
    "rand" => $rand,
    "display_emptychoice" => true,
    "emptylabel" => __("Sélectionner une catégorie..."),
    "entity" => $_SESSION["glpiactive_entity"],
    "condition" => [
        "is_helpdeskvisible" => 1
    ],
    "width" => "100%",
    "required" => true
]);
echo "</div>";

echo "<div class=\"alert alert-warning mb-3\">";
echo "<i class=\"fas fa-exclamation-triangle me-2\"></i>";
echo __("<strong>Note :</strong> Vous pourrez modifier cette catégorie plus tard si nécessaire.");
echo "</div>";

echo "<div class=\"d-flex justify-content-between\">";
echo "<button type=\"button\" class=\"btn btn-secondary\" onclick=\"parent.$('.modal').modal('hide');\">";
echo "<i class=\"fas fa-times me-2\"></i>";
echo __("Annuler");
echo "</button>";

echo "<button type=\"submit\" name=\"select_category\" class=\"btn btn-primary\">";
echo "<i class=\"fas fa-check me-2\"></i>";
echo __("Continuer avec cette catégorie");
echo "</button>";
echo "</div>";

Html::closeForm();
echo "</div>";


echo "
<script type=\"text/javascript\">
$(function() {
    // Focus sur le dropdown
    setTimeout(function() {
        $(\"#dropdown_itilcategories_id".$rand."\").focus();
    }, 100);

    // Validation du formulaire
    $(\"form\").on(\"submit\", function(e) {
        var categoryId = $(\"#dropdown_itilcategories_id".$rand."\").val();
        if (!categoryId || categoryId == \"0\") {
            e.preventDefault();
            alert(\"" . __("Veuillez sélectionner une catégorie") . "\");
            return false;
        }
        
        // Afficher un indicateur de chargement
        $(\"button[type=submit]\").prop(\"disabled\", true).html(\"<i class=\\\"fas fa-spinner fa-spin me-2\\\"></i>\" + \"" . __("Traitement...") . "\");
    });
});
</script>";
?>
