<?php

/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2023 Teclib' and contributors.
 * @copyright 2003-2014 by the INDEPNET Development Team.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */

include_once('../../../inc/includes.php');

// Vérification de la présence de l'ID dans les paramètres GET
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Aucun identifiant fourni']);
    exit;
}

$locationId = intval($_GET['id']);

// Création d'une instance de Location et récupération des données
$location = new Location();
if (!$location->getFromDB($locationId)) {
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Location non trouvée']);
    exit;
}

// Constitution du tableau de résultat avec les champs souhaités
$result = [
    'postcode'  => isset($location->fields['postcode']) ? $location->fields['postcode'] : '',
    'address'   => isset($location->fields['address']) ? $location->fields['address'] : '',
    'town'      => isset($location->fields['town']) ? $location->fields['town'] : '',
    'state'     => isset($location->fields['state']) ? $location->fields['state'] : '',
    'country'   => isset($location->fields['country']) ? $location->fields['country'] : '',
    'longitude' => isset($location->fields['longitude']) ? $location->fields['longitude'] : '',
    'latitude'  => isset($location->fields['latitude']) ? $location->fields['latitude'] : '',
    'altitude'  => isset($location->fields['altitude']) ? $location->fields['altitude'] : '',
];

// Définition du header pour le JSON et renvoi de la réponse
header('Content-Type: application/json');
echo json_encode($result);
exit;