<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software. 
 It disallow others people than DLPlace developers to distribute, sell, 
 or add additional requirements to this software. 
 Though, a limited set of safe added requirements can be allowed, but 
 for private or internal usage only ;  without even the implied warranty 
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include_once('../../../inc/includes.php');

// Check authentication
Session::checkLoginUser();


// Set content type to JSON
header('Content-Type: application/json');

try {
    // Validate required parameters
    if (!isset($_POST['itemtype'])) {
        throw new Exception('Missing itemtype parameter');
    }

    $itemtype = $_POST['itemtype'];
    
    // Validate itemtype exists and user has rights
    if (!($item = getItemForItemtype($itemtype))) {
        throw new Exception('Invalid itemtype');
    }

    // Check if user can read this itemtype
    if (!$item->canView()) {
        throw new Exception('Access denied');
    }

    // Prepare parameters for getItems
    $params = [
        'return_columns' => isset($_POST['return_columns']) ? json_decode($_POST['return_columns'], true) : ['id', 'name'],
        'entity'         => isset($_POST['entity']) ? (int)$_POST['entity'] : -1,
        'entity_sons'    => isset($_POST['entity_sons']) ? (bool)$_POST['entity_sons'] : false,
        'condition'      => isset($_POST['condition']) ? json_decode($_POST['condition'], true) : [],
        'used'           => isset($_POST['used']) ? (array)$_POST['used'] : [],
        'searchText'     => isset($_POST['searchText']) ? trim($_POST['searchText']) : ''
    ];

    // Validate return_columns
    if (!is_array($params['return_columns']) || empty($params['return_columns'])) {
        $params['return_columns'] = ['id', 'name'];
    }

    // Validate condition
    if (!is_array($params['condition'])) {
        $params['condition'] = [];
    }

    // Get items using the MultiSelector class
    $items = PluginDlteamsMultiSelector::getItems($itemtype, $params);

    // Format response
    $response = [
        'success' => true,
        'items'   => $items,
        'count'   => count($items)
    ];

    echo json_encode($response);

} catch (Exception $e) {
    // Error response
    $response = [
        'success' => false,
        'error'   => $e->getMessage(),
        'items'   => [],
        'count'   => 0
    ];

    http_response_code(400);
    echo json_encode($response);
}

