<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include("../../../inc/includes.php");

// Vérifier que l'utilisateur est connecté
Session::checkLoginUser();

if (isset($_POST['type'])) {
    $type = $_POST['type'];


    switch ($type) {
        case 'User':

            User::dropdown([
                'name' => 'responsible_id',
                'entity' => -1,
                'right' => 'all',
                'display' => true,
                'width' => '250px',
                'emptylabel' => __('Choisir un utilisateur', 'dlteams')
            ]);
            break;
            
        case 'Group':

            Group::dropdown([
                'name' => 'responsible_id',
                'entity' => -1,
                'display' => true,
                'width' => '250px',
                'emptylabel' => __('Choisir un groupe', 'dlteams')
            ]);
            break;
            
        default:
            echo "<div style='padding: 8px; background-color: #f8f9fa; border: 1px solid #dee2e6; border-radius: 4px; color: #6c757d;'>";
            echo "<i class='fas fa-info-circle'></i> " . __('Sélectionner d\'abord un type de responsable', 'dlteams');
            echo "</div>";
            break;
    }
} else {
    // Si aucun type n'est fourni, afficher un message informatif
    echo "<div style='padding: 8px; background-color: #f8f9fa; border: 1px solid #dee2e6; border-radius: 4px; color: #6c757d;'>";
    echo "<i class='fas fa-info-circle'></i> " . __('Sélectionner d\'abord un type de responsable', 'dlteams');
    echo "</div>";
}
?>
