<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include("../../../inc/includes.php");

Session::checkLoginUser();


if (isset($_POST['consent_type']) && $_POST['consent_type'] && $_POST['plugin_dlteams_records_id'] && $_POST['add1']) {
    $record_item = new PluginDlteamsRecord_Item();

    $record = new PluginDlteamsRecord();
    $record->getFromDB($_POST['plugin_dlteams_records_id']);

    switch ($_POST["consent_type"]) {
        case 1:
            if ($_POST['groups_id']) {

                $r_id = $record_item->add([
                    'records_id' => $_POST['plugin_dlteams_records_id'],
                    'itemtype' => 'Group',
                    'items_id' => $_POST['groups_id'],
                    'comment' => addslashes($_POST['comment']),
                    'name' => addslashes($record->fields['name']),
                    'groups_id' => $_POST['groups_id'],
                ]);

                $group_item = new PluginDlteamsGroup_Item();

//                $group = new Group();
//                $group->getFromDB($_POST['groups_id']);

                $group_item->add([
                    'groups_id' => $_POST['groups_id'],
                    'itemtype' => 'PluginDlteamsRecord',
                    'items_id' => $_POST['plugin_dlteams_records_id'],
                    'comment' => addslashes($_POST['comment']),
//                    'name' => $group->fields['name']
                ]);

                Session::addMessageAfterRedirect("Groupe responsable ajouté avec succès");
            }
            break;
        case 2:
            if ($_POST['users_id']) {
                $r_id = $record_item->add([
                    'records_id' => $_POST['plugin_dlteams_records_id'],
                    'itemtype' => 'User',
                    'items_id' => $_POST['users_id'],
                    'comment' => addslashes($_POST['comment']),
                    'name' => addslashes($record->fields['name']),
                    'users_id' => $_POST['users_id'],
                ]);


                $user = new User();
                $user->getFromDB($_POST['users_id']);
                $group_item = new PluginDlteamsUser_Item();
                $u = $group_item->add([
                    'users_id' => $_POST['users_id'],
                    'itemtype' => 'PluginDlteamsRecord',
                    'items_id' => $_POST['plugin_dlteams_records_id'],
                    'comment' => addslashes($_POST['comment']),
//                    'name' => $user->fields["name"]
                ]);

                Session::addMessageAfterRedirect("Utilisateur responsable ajouté avec succès");
            }
            break;
        case 3:
            if ($_POST['plugin_dlteams_thirdpartycategories_id1']) {
                $thpc_item = new PluginDlteamsThirdPartyCategory_Item();
                $rgpdadequacy_item = new PluginDlteamsRgpdAdequacy_Item();
                if($r_id = $record_item->add([
                    'records_id' => $_POST['plugin_dlteams_records_id'],
                    'itemtype' => 'PluginDlteamsThirdPartyCategory',
                    'items_id' => $_POST['plugin_dlteams_thirdpartycategories_id1'],
                    'itemtype1' => PluginDlteamsRgpdAdequacy::class,
                    'items_id1' => $_POST["rgpdadequacies_id"]??0,
                    'comment' => addslashes($_POST['comment']),
                    'name' => addslashes($record->fields['name'])
                ])
                    &&
                $g_id = $thpc_item->add([
                    'thirdpartycategories_id' => $_POST['plugin_dlteams_thirdpartycategories_id1'],
                    'itemtype' => 'PluginDlteamsRecord',
                    'items_id' => $_POST['plugin_dlteams_records_id'],
                    'itemtype1' => PluginDlteamsRgpdAdequacy::class,
                    'items_id1' => $_POST["rgpdadequacies_id"]??0,
                    'comment' => addslashes($_POST['comment']),
//                    'foreign_id' => $r_id
                ])
                &&
                    $ra_id = $rgpdadequacy_item->add([
                        "rgpdadequacies_id" =>  $_POST["rgpdadequacies_id"]??0,
                        'itemtype' => 'PluginDlteamsRecord',
                        'items_id' => $_POST['plugin_dlteams_records_id'],
                        'itemtype1' => 'PluginDlteamsThirdPartyCategory',
                        'items_id1' => $_POST['plugin_dlteams_thirdpartycategories_id1'],
                        'comment' => addslashes($_POST['comment']),
                    ])
                )
                Session::addMessageAfterRedirect("Tier catégorie responsable ajouté avec succès");
                else{
                    global $DB;
                    Session::addMessageAfterRedirect("Une erreur s'est produite", 0, ERROR);
                }
            }
            break;
        case 4:
            if ($_POST['suppliers_id1']) {
                $r_id = $record_item->add([
                    'records_id' => $_POST['plugin_dlteams_records_id'],
                    'itemtype' => 'Supplier',
                    'items_id' => $_POST['suppliers_id1'],
                    'comment' => addslashes($_POST['comment']),
                    'name' => addslashes($record->fields['name'])
                ]);

                $group_item = new PluginDlteamsSupplier_Item();
                $group_item->add([
                    'suppliers_id' => $_POST['suppliers_id1'],
                    'itemtype' => 'PluginDlteamsRecord',
                    'items_id' => $_POST['plugin_dlteams_records_id'],
                    'comment' => addslashes($_POST['comment']),
//                    'foreign_id' => $r_id
                ]);

                Session::addMessageAfterRedirect("Fournisseur responsable ajouté avec succès");
            }
            break;
    }

}
elseif(isset($_POST['add'])) {

        $itemtype = $_POST['itemtype']; // ex: PluginDlteamsProtectiveMeasure
        $itemtype1 = $_POST['itemtype1']; // ex: PluginDlteamsRecord
        $itemtype_item = $itemtype . '_Item'; // ex: PluginDlteamsProtectiveMeasure_Item
        $itemtype1_item = $itemtype1 . '_Item'; // ex: PluginDlteamsRecord_Item
        $baseItem = new $itemtype();
//    $baseItem->check($_POST[$itemtype::getForeignKeyField()], UPDATE);

        global $DB;

        if (isset($_POST['items_id'])) {
            //add baseItem side
            $baseItem_items = new $itemtype_item();

            $i1_itemsid_column = strtolower(str_replace("PluginDlteams", "", $itemtype)) . "s_id";
            $i1 = [
                $i1_itemsid_column => $_POST["items_id"],
                "items_id" => $_POST["items_id1"],
                "itemtype" => $_POST["itemtype1"],
                "comment" => $_POST["comment"],
            ];
            $test = $baseItem_items->add($i1);

            if ($itemtype1 == "PluginDlteamsThirdPartyCategory")
                $i2_itemsid_column = "thirdpartycategories_id";
            else
                $i2_itemsid_column = strtolower(str_replace("PluginDlteams", "", $itemtype1)) . "s_id";
            $i2 = [
                $i2_itemsid_column => $_POST["items_id1"],
                "items_id" => $_POST["items_id"],
                "itemtype" => $_POST["itemtype"],
                "comment" => $_POST["comment"],
            ];
            $second_items = new $itemtype1_item();
            $test1 = $DB->insert($second_items->getTable(), $i2);

            Session::addMessageAfterRedirect("Ajouté avec succès");
        }


    Html::back();
}
elseif (isset($_POST["update_edit_record_acteur"])){
//    if(!$_POST["items_id1"]){
//        Session::addMessageAfterRedirect("Veuillez sélectionner un motif", 0, ERROR);
//        Html::back();
//    }
    $record_item = new PluginDlteamsRecord_Item();
    if($record_item->getFromDB($_POST["linkid"])){

        $record_item_oldfields = $record_item->fields;

        $record_item->update([
//            "items_id1" => $_POST["items_id1"],
            "comment" => $_POST["comment"],
            "id" => $_POST["linkid"]
        ]);

//        $criteria_sr = [
//            "sendingreasons_id" => $record_item_oldfields["items_id1"],
//            "itemtype" => PluginDlteamsRecord::class,
//            "items_id" => $record_item_oldfields["records_id"],
//            "itemtype1" => $record_item_oldfields["itemtype"],
//            "items_id1" => $record_item_oldfields["items_id"],
//            "comment" => $record_item_oldfields["comment"]
//        ];

//        $sendingreasn_item = new PluginDlteamsSendingReason_Item();
//        if($sendingreasn_item->deleteByCriteria($criteria_sr)){
//            $sendingreasn_item->add([
//                ...$criteria_sr,
//                "sendingreasons_id" => $_POST["items_id1"],
//                "comment" => $_POST["comment"]
//            ]);
//        }


//        $itemtype_item_str = $record_item_oldfields["itemtype"]."_Item"; // ConcernedPerson, ThirdPartyCategory, Supplier
//        $itemtype_item = new $itemtype_item_str();
//        $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $record_item_oldfields["itemtype"]))) . "s_id";
//
//        $criteria_itemtype = [
//            $relation_column_id => $record_item_oldfields["records_id"],
//            "itemtype" => PluginDlteamsRecord::class,
//            "items_id" => $record_item_oldfields["records_id"],
//            "itemtype1" => $record_item_oldfields["itemtype1"],
//            "items_id1" => $record_item_oldfields["items_id1"],
//            "comment" => $record_item_oldfields["comment"]
//        ];
//        if($itemtype_item->getFromDBByCrit($criteria_itemtype)){
//            $itemtype_item->update([
//                ...$criteria_itemtype,
//                "items_id1" => $_POST["items_id1"],
//                "comment" => $_POST["comment"]
//            ]);
//        }

        Session::addMessageAfterRedirect("Opération éffectuée avec succès");
        Html::back();
    }

}

if($_POST["plugin_dlteams_records_id"]){

    $r = new PluginDlteamsRecord();
    $r->getFromDB($_POST["plugin_dlteams_records_id"]);
    $nb = count($DB->request(PluginDlteamsActeur_Item::getRequest($r)));
    $DB->update(PluginDlteamsRecord::getTable(),[
        "r_actors" => $nb
    ],
        ["id" => $_POST["plugin_dlteams_records_id"]]);
}


Html::back();
