<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include("../../../inc/includes.php");

if (!isset($_GET['id'])) {
    $_GET['id'] = "";
}
$deliverable = new PluginDlteamsDeliverable();
/*highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//die();

if (isset($_GET["items_id"]))
    $data = $_GET;
else
    $data = $_POST;
/*highlight_string("<?php\n\$data =\n" . var_export($data, true) . ";\n?>");*/
//die();
if (isset($_POST["edit_html"])) {

    $pdfoutput = new PluginDlteamsPublish();
    $print_options = PluginDlteamsPublish::preparePrintOptionsFromForm($_GET);

    updateEditDeliverableSettings();

    $deliverable = new PluginDlteamsDeliverable();
    $deliverable->getFromDB($_POST['deliverable_id']);
//    $print_options['print_first_page'] = $_POST['print_first_page'];
    $print_options["ispdf"] = false;
    $print_options["prevent_contextmenu"] = isset($_POST["prevent_contextmenu"]) ? $_POST["prevent_contextmenu"] : false;
    $print_options["print_first_page"] = isset($_POST["print_first_page"]) ? $_POST["print_first_page"] : false;
    $print_options["print_comments"] = isset($_POST["print_comments"]) ? $_POST["print_comments"] : false;
    $pdfoutput->deliverableGenerateHtml($print_options, $deliverable);
}
elseif (isset($_POST["publish_dlteams"])) {

    $print_options["ispdf"] = false;
    $print_options["prevent_contextmenu"] = isset($_POST["prevent_contextmenu"]) ? $_POST["prevent_contextmenu"] : false;
    if (!isset($_POST["choosen_publication_folder"]) || !$_POST["choosen_publication_folder"] || $_POST["choosen_publication_folder"] == "0") {
        Session::addMessageAfterRedirect("Veuillez choisir un dossier de publication", false, ERROR);
        Html::back();
    }

    updateEditDeliverableSettings();

    $itemtype_str = $_REQUEST["itemtype"];
    $itemtype = new $itemtype_str();

//    $deliverable = new PluginDlteamsDeliverable();
    $itemtype->getFromDB($_POST['items_id']);
    $print_options['print_first_page'] = isset($_POST['print_first_page']) ? $_POST['print_first_page'] : false;
    $print_options["prevent_contextmenu"] = isset($_POST["prevent_contextmenu"]) ? $_POST["prevent_contextmenu"] : false;
    $print_options['print_comments'] = isset($_POST['print_comments']) ? $_POST['print_comments'] : false;
    $pdfoutput = new PluginDlteamsPublish();
    $print_options = PluginDlteamsPublish::preparePrintOptionsFromForm($_GET);
    $glpiRoot = str_replace('\\', '/', GLPI_ROOT);
//    $valeurp= $pdfoutput->getGuidValue($_GET, $print_options);

    if ($_SESSION['glpiactive_entity'] == 0) {
        Session::addMessageAfterRedirect("Cette opération ne peut pas être réalisée en entité root", 0, WARNING);
        Html::back();
    }
    $link_folder = new Link();
    $link_folder->getFromDB($_POST['choosen_publication_folder']);
    $str_link = $link_folder->fields['link'];

    $server_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";

    $str_link = str_replace($server_url . "/" . "pub" . "/", "", $str_link);
    $str_guid = str_replace("/", "", $str_link);

    if (isset($str_guid) && $str_guid != 0 && $str_guid != NULL) {
        if (!file_exists($glpiRoot . "/" . "pub" . "/" . $str_guid . "/")) {
            $parent_directory = $glpiRoot . "/pub";
            if (!is_dir($parent_directory)) {
                $cre = mkdir($parent_directory, 0755, true);
            }
            $new_directory = $parent_directory . "/" . $str_guid;
            if (!is_dir($new_directory)) {
                $cre = mkdir($new_directory, 0755, true);
            }

        }
        $print_options['guid_value'] = $str_guid;

        $deliverable_items = new PluginDlteamsDeliverable_Item();

        $exist = $deliverable_items->find([
            "itemtype" => "Link",
            "items_id" => $_POST["choosen_publication_folder"],
            "deliverables_id" => $_POST["deliverable_id"]
        ]);

        if (count($exist) > 0) {
            $id = 0;
            foreach ($exist as $di) {
                $id = $di["id"];
            }

            $linkitem_id = 0;

            $link_item_exist = new PluginDlteamsLink_Item();
            $link_item_exist->deleteByCriteria([
                "links_id" => $_POST["choosen_publication_folder"],
                "itemtype" => "PluginDlteamsDeliverable",
                "items_id" => $_POST["deliverable_id"]
            ]);


            $link_item_exist->add([
                "links_id" => $_POST["choosen_publication_folder"],
                "itemtype" => "PluginDlteamsDeliverable",
                "items_id" => $_POST["deliverable_id"]
            ]);

            $deliverable_items->deleteByCriteria([
                "itemtype" => "Link",
                "items_id" => $_POST["choosen_publication_folder"],
                "deliverables_id" => $_POST["deliverable_id"],
            ]);

            $deliverable_items->add([
                "itemtype" => "Link",
                "items_id" => $_POST["choosen_publication_folder"],
                "deliverables_id" => $_POST["deliverable_id"]
            ]);

        } else {

            $deliverable_items->add([
                "itemtype" => "Link",
                "items_id" => $_POST["choosen_publication_folder"],
                "deliverables_id" => $_POST["deliverable_id"]
            ]);

            $link_item = new PluginDlteamsLink_Item();
            $link_item->add([
                "links_id" => $_POST["choosen_publication_folder"],
                "itemtype" => "PluginDlteamsDeliverable",
                "items_id" => $_POST["deliverable_id"]
            ]);
        }


        $print_options["print_first_page"] = isset($_POST["print_first_page"]) ? $_POST["print_first_page"] : false;

        $print_options["print_comments"] = isset($_POST["print_comments"]) ? $_POST["print_comments"] : false;
        $print_options["prevent_contextmenu"] = isset($_POST["prevent_contextmenu"]) ? $_POST["prevent_contextmenu"] : false;

        $pdfoutput->deliverablePublishDlteams($print_options, $itemtype);
//        Session::addMessageAfterRedirect(sprintf(__('Fichier crée avec Succès')));
        Html::back();
    } else {
        Session::addMessageAfterRedirect("Veuillez choisir un autre dossier et rééssayer", 0, WARNING);
        Html::back();
        $pdfoutput->generateGuid($_GET, $print_options);
        $pdfoutput->deliverablePublishDlteams($print_options, $_GET);
//        Session::addMessageAfterRedirect(sprintf(__('Fichier crée avec Succès')));
        Html::back();
    }
}
elseif (isset($data["edit_pdf"]) || (isset($data["action"]) && $data["action"] == "print")) {
    $pdfoutput = new PluginDlteamsPublish();
    $print_options = PluginDlteamsPublish::preparePrintOptionsFromForm($data);

    if (!isset($_GET["items_id"]))
        updateEditDeliverableSettings();

    $itemtype_str = $_REQUEST["itemtype"];
    $itemtype = new $itemtype_str();
    $items_id = $data['items_id'] ?? $data['deliverable_id'];
    $itemtype->getFromDB($items_id);

    if ($itemtype) {
        $print_options["ispdf"] = true;
        $print_options["prevent_contextmenu"] = $data["prevent_contextmenu"] ?? false;
        $print_options["print_first_page"] = $itemtype->fields["is_firstpage"] ?? $data["print_first_page"] ?? false;
        $print_options["print_comments"] = $data["print_comments"] ?? false;

        $pdfoutput->deliverableGenerateReport($print_options, $itemtype);
//        $_GET["report_type"] = 7;
//        $pdfoutput->showPDF($_GET);
    }

}
elseif (isset($_POST['add'])) {

    $data = $_POST;
    $deliverable->check(-1, CREATE, $data);
    handleActionDocument($data);

    if (!$data["documents_id"]) {

        $document = new Document();
        $documents_id = $document->add([
            "name" => $data["name"],
            "entities_id" => Session::getActiveEntity()
        ]);
//        Session::addMessageAfterRedirect("Document ");
    } else {
        $documents_id = $data["documents_id"];
    }

    $id = $deliverable->add([...$data, "documents_id" => $documents_id, "users" => Session::getLoginUserID()]);

    $document->update([
        "deliverables_id" => $id,
        "id" => $documents_id
    ]);


    global $DB;
    $position = 0;
    $chapter = new PluginDlteamsDeliverable_Section();
    $condition = [
        'FROM' => 'glpi_plugin_dlteams_deliverables_sections',
        'ORDER' => 'id DESC',
        'LIMIT' => 1,
        'deliverables_id' => $id
    ];

    $chapters = $DB->request($condition);

    foreach ($chapters as $key => $c) {
        $lastRecord = $c["timeline_position"];

        $position = $lastRecord + 1;
    }
    if ($position == 0)
        $position++;

    $result = $chapter->add([
        "tab_name" => "Contenu",
        "timeline_position" => $position,
        "deliverables_id" => $id
    ]);
    Html::redirect($deliverable->getFormURLWithID($id));

}
else if (isset($_POST['update'])) {
    handleUpdateDeliverable();
    Html::back();
}
else if (isset($_POST['delete'])) {

    $deliverable->check($_POST['id'], DELETE);
    $deliverable->delete($_POST);
    $deliverable->redirectToList();
}
else if (isset($_POST['save'])) {

//    if(!isset($_POST["choosen_publication_folder"]) || !$_POST["choosen_publication_folder"] || $_POST["choosen_publication_folder"] == '0' ){
//        Session::addMessageAfterRedirect("Veuillez choisir un dossier de publication", false, ERROR);
//        Html::back();
//    }

    if (updateEditDeliverableSettings())
        Session::addMessageAfterRedirect("Mise à jour avec succès");
    else
        Session::addMessageAfterRedirect("Une erreur s'est produite", false, ERROR);
    Html::back();
}
else if (isset($_POST["approvedeliverable"])) {

    $receiver_mail = $_POST["email"];

    if (!NotificationMailing::isUserAddressValid($receiver_mail)) {
        Session::addMessageAfterRedirect("Le destinataire ne possede pas d'adresse email valide ($receiver_mail)", false, WARNING);
        Html::back();
    }


// Génération du token d'approbation
    $approbation_token = sha1(Toolbox::getRandomString(30));

// Définition de l'URL du serveur
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? 'https' : 'http';
    $server_url = $protocol . '://' . $_SERVER['HTTP_HOST'];

// Construction du lien et du texte d'approbation
    $approbation_link = "{$server_url}/marketplace/dlteams/front/approve.form.php?token={$approbation_token}";
    $approbation_text = "<br/><br/>Si vous n'arrivez pas à valider en cliquant sur le bouton, veuillez copier le lien ci-dessous et le coller dans votre navigateur: {$approbation_link}";
    $approbation_button = "<br/><center><a style='padding: 5px; background-color: #0a6aa1; color: white; border-radius: 3px;' href='{$approbation_link}'>cliquer pour approuver</a></center>";

// Récupération du livrable et du document associé
    $deliverable = new PluginDlteamsDeliverable();
    $deliverable->getFromDB($_POST["deliverable_id"]);

    $document = new Document();
    $document->getFromDB($deliverable->fields["documents_id"]);
    $document_name = $document->fields["name"];
// Échappement du nom du document pour éviter les conflits SQL
    $document_name_escaped = addslashes($document_name);

// Construction de l'URL du document et du texte d'approbation
    $document_url = "{$server_url}/front/document.send.php?docid={$deliverable->fields["documents_id"]}";
    $text_approval = "Merci de confirmer la lecture du document intitulé \"{$document_name_escaped}\", lu ce jour sur le <a href=\"{$document_url}\">lien</a>";

// Envoi de la notification si le livrable existe
    $saveitem = false;
    if ($deliverable) {
        $approbation_content_html = html_entity_decode($text_approval) . "<br/>" . $approbation_button . $approbation_text;
        $notificationData = [
            "subject" => "Approbation de document",
            "content_html" => $approbation_content_html,
            "to" => $receiver_mail, // adresse email du destinataire
            "toname" => $receiver_mail,
        ];

        $mail = new PluginDlteamsNotificationMail();
        if ($mail->sendNotification($notificationData)) {
            $saveitem = true;
            Session::addMessageAfterRedirect("Notification envoyé");
        } else {
            Session::addMessageAfterRedirect("Notification non envoyé", false, ERROR);
        }
    } else {
        Session::addMessageAfterRedirect("Une erreur s'est produite", false, ERROR);
    }

// Enregistrement de l'item de livrable si la notification a été envoyée
    if ($saveitem) {
        $baseData = [
            "deliverables_id" => $_POST["deliverable_id"],
            "itemtype" => Document::class,
            "items_id" => $deliverable->fields["documents_id"],
        ];

        $itemData = [
            "comment" => addslashes($approbation_content_html),
            "approval_token" => $approbation_token,
            "email" => $receiver_mail,
            "object_notification" => "Approbation de document",
            "object_approval" => "Approbation de document",
            "text_approval" => $text_approval,
        ];

        // Fusion des tableaux avec l'opérateur spread pour conserver la logique initiale
        $deliverable_item = new PluginDlteamsDeliverable_Item();
        $deliverable_item->add([...$baseData, ...$itemData]);


//    var_dump($test);
//    die();

//    if ($deliverable_item->getFromDBByCrit($data)) {
//        $deliverable_item->update([
//            ...$data,
//            "comment" => $_POST["notification_text"],
//            "approval_token" => $approbation_token,
//            "email" => $receiver_mail,
//            "object_notification" => $_POST["object"],
//            "object_approval" => $_POST["object_approbation"],
//            "id" => $deliverable->fields["id"]
//        ]);
//    } else {
//
//        $deliverable_item->add([
//            ...$data,
//            "comment" => $_POST["notification_text"],
//            "approval_token" => $approbation_token,
//            "email" => $receiver_mail,
//            "object_notification" => $_POST["object"],
//            "object_approval" => $_POST["object_approbation"]
//        ]);
//    }

//        $itemtype_item_str = "PluginDlteams" . $itemtype . "_Item";
//        $itemtype_item = new $itemtype_item_str();
//        if ($itemtype == Contact::class)
//            $id_column_name = "contacts_id";
//        else
//            $id_column_name = "users_id";
//
//        $data2 = [
//            $id_column_name => $items_id,
//            "itemtype" => PluginDlteamsDeliverable::class,
//            "items_id" => $_POST["items_id"],
//        ];
//
//        $itemtype_item->add([
//            ...$data2,
//            "comment" => $_POST["notification_text"],
//        ]);


//    if ($itemtype_item->getFromDBByCrit($data2)) {
//        $itemtype_item->update([
//            ...$data2,
//            "comment" => $_POST["notification_text"],
//            "id" => $itemtype_item->fields["id"]
//        ]);
//    } else {
//        $itemtype_item->add([
//            ...$data2,
//            "comment" => $_POST["notification_text"],
//        ]);
//
//    }
    }

    Html::redirect($deliverable->getFormURLWithID($_POST["deliverable_id"]));
}
else if (isset($_POST["approve_document"])) {


    handleUpdateDeliverable();
//    die();
    global $CFG_GLPI;
    Html::redirect($CFG_GLPI["root_doc"] . "/marketplace/dlteams/front/deliverable.action.php?id=" . $_POST["id"] . "&action=approve_document");
}
else if (isset($_POST["purge"])) {
    $deliverable->check($_POST['id'], PURGE);
    $deliverable->delete($_POST, 1);
    global $DB;

    $DB->update(Document::getTable(),
        [
            "deliverables_id" => null
        ],
        [
            "deliverables_id" => $_POST['id']
        ]
    );

//    \Glpi\Event::log(
//        $deliverable->getField($fk),
//        strtolower($itemtype),
//        4,
//        "tracking",
//        //TRANS: %s is the user login
//        sprintf(__('%s purges an approval'), $_SESSION["glpiname"])
//    );
    Html::back();
}
elseif (isset($_POST["add_tab"])) {

/*    highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//    die();
    $position = 0;
    $chapter = new PluginDlteamsDeliverable_Section();
    $condition = [
        'FROM' => 'glpi_plugin_dlteams_deliverables_sections',
        'ORDER' => 'id DESC',
        'LIMIT' => 1,
        'WHERE' => [
            'items_id' => $_POST["deliverable_id"],
            "itemtype" => PluginDlteamsDeliverable::class,
        ]
    ];

    global $DB;
    $chapters = $DB->request($condition);

    foreach ($chapters as $key => $c) {
        $lastRecord = $c["timeline_position"];

        $position = $lastRecord + 1;
    }
    if ($position == 0)
        $position++;

    $result = $chapter->add([
        "tab_name" => "section $position",
        "timeline_position" => $position,
//        "deliverables_id" => $_GET["deliverables_id"],
        "itemtype" => PluginDlteamsDeliverable::class,
        "items_id" => $_REQUEST["deliverable_id"]
    ]);


//    var_dump($result);
//    die();
    Html::back();
    Session::addMessageAfterRedirect("Onglet ajouté avec succès");
}
elseif(isset($_POST["add_document_from_deliverable"])){
    $document = new Document();
    $docid    = $document->add([
        "name"        => $_POST["name"],
        "entities_id" => Session::getActiveEntity(),
        "documentscategories_id" => $_POST["documentscategories_id"]
    ]);

    if ($docid) {
        $deliverable = new PluginDlteamsDeliverable();
        $deliverables_id = $deliverable->add([
            "name"         => $_POST["name"],
            "entities_id"  => Session::getActiveEntity(),
            "documents_id" => $docid
        ]);

        if ($deliverables_id) {
            $document->update([
                "id"              => $docid,
                "deliverables_id" => $deliverables_id
            ]);
        }
        Session::addMessageAfterRedirect("Opération éffectuée avec succès");
        Html::redirect(PluginDlteamsDeliverable::getFormURLWithID($deliverables_id));
    } else {
        Session::addMessageAfterRedirect("Une erreur s'est produite", 0, ERROR);
        Html::back();
    }
}
else {

    $deliverable->checkGlobal(READ);

    if (Session::getCurrentInterface() == 'central') {
//        Html::header(PluginDlteamsDeliverable::getTypeName(2), '', 'management', 'deliverable', 'deliverable');

        $menus = ["management", "deliverable", "deliverable"];
        PluginDlteamsDeliverable::displayFullPageForItem($_GET['id'], $menus, [
            'formoptions' => "data-track-changes=true",
        ]);


//        Html::header(PluginDlteamsDeliverable::getTypeName(2), '', "management", "dlteams", "deliverable");
    } else {
        Html::helpHeader(PluginDlteamsDeliverable::getTypeName(0));
    }

//    $deliverable->display(['id' => $_GET['id']]);

    if (Session::getCurrentInterface() == 'central') {
        Html::footer();
    } else {
        Html::helpFooter();
    }
}

function updateEditDeliverableSettings()
{
    $itemtype_str = $_POST["itemtype"];
    $itemtype = new $itemtype_str();
//    $itemtype = new PluginDlteamsDeliverable();

    /*    highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//    die();

    return $itemtype->update([
        "is_firstpage" => isset($_POST["print_first_page"]) && $_POST["print_first_page"] === "on" ? true : false,
        "is_comment" => isset($_POST["print_comments"]) && $_POST["print_comments"] === "on" ? true : false,
        "print_logo" => isset($_POST["print_logo"]) && $_POST["print_logo"] === "on" ? true : false,
        "document_name" => $_POST["document_url"],
        "document_title" => $_POST["document_title"],
//        "document_content" => $_POST["document_content"],
//        "document_comment" => $_POST["document_comment"],
        "links_id" => isset($_POST["choosen_publication_folder"]) ? $_POST["choosen_publication_folder"] : null,
        "id" => $_POST['deliverable_id']
    ]);

}


function handleActionDocument(&$data)
{
    if (isset($data["rename_choice"]) && $data["rename_choice"] == "rename_document") {
        $deliverable = new PluginDlteamsDeliverable();
        $deliverable->getFromDB($data["deliverable_id"]);
        $data["name"] = $deliverable->fields["name"];
    }

    if (isset($data["rename_choice"]) && $data["rename_choice"] == "rename_html") {
        global $DB;
        $DB->update(
            PluginDlteamsDeliverable::getTable(),
            [
                "name" => $data["name"]
            ],
            [
                "id" => $data["deliverable_id"]
            ]
        );
    }
}


function handleUpdateDeliverable()
{
    $data = $_POST;
    handleActionDocument($data);

    $deliverable = new PluginDlteamsDeliverable();
    $deliverable->check($data['id'], UPDATE);

//    if (!isset($data["documents_id"]) || !$data["documents_id"]) {
//
//        $document = new Document();
//        $documents_id = $document->add([
//            "name" => $data["name"],
//            "entities_id" => Session::getActiveEntity()
//        ]);
////        Session::addMessageAfterRedirect("Document ");
//    } else {
//        $documents_id = $data["documents_id"];
//    }

    $deliverable->update([...$data]);

//    if (isset($document))
//        $document->update([
//            "deliverables_id" => $data["id"],
//            "id" => $documents_id
//        ]);

}