<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software. 
 It disallow others people than DLPlace developers to distribute, sell, 
 or add additional requirements to this software. 
 Though, a limited set of safe added requirements can be allowed, but 
 for private or internal usage only ;  without even the implied warranty 
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */
 
include("../../../inc/includes.php");

Session::checkLoginUser();

if(isset($_POST['update'], $_POST['plugin_dlteams_records_id'])) {
   $record = new PluginDlteamsRecord();
   $record->check($_POST['plugin_dlteams_records_id'], UPDATE);

   // Transform $_POST['consent_*'] into array then into json to put it in DB
   // (dirty but avoid adding another table & relations)
   foreach ($_POST as $key => $value) {
      if (preg_match('/consent_(\d+|other)/',$key)) {
         $consent_array [preg_replace('/consent_/', '',$key)] = $value;
      }
   }
   $consent_json = json_encode($consent_array, JSON_UNESCAPED_UNICODE);

   global $DB;
// Liste des champs que l’on souhaite potentiellement mettre à jour
    $fields = [
        'consent_json',       // valeur calculée
        'consent_type',
        'consent_explicit',
        'right_information',
//        'right_opposition',   // attention à l’orthographe
//        'right_portability',  // attention à l’orthographe
    ];

// On commence par injecter les valeurs calculées hors POST
    $data = [];
    if (isset($consent_json)) {
        $data['consent_json'] = $consent_json;
    }

// Pour chacun des autres champs, on vérifie qu’il existe bien dans $_POST
    foreach ($fields as $field) {
        // on saute consent_json qui est déjà traité
        if ($field === 'consent_json') {
            continue;
        }
        if (array_key_exists($field, $_POST)) {
            $data[$field] = $_POST[$field];
        }
    }

// Si au moins un champ est présent, on lance la mise à jour
    if (!empty($data)) {
        $DB->updateOrDie(
            'glpi_plugin_dlteams_records',
            $data,
            ['id' => $_POST['plugin_dlteams_records_id']]
        );
    }
}

//highlight_string(var_export($_POST, true));
//die();
if($_POST["plugin_dlteams_records_id"]){

    $r = new PluginDlteamsRecord();
    $r->getFromDB($_POST["plugin_dlteams_records_id"]);
    $nb = count(PluginDlteamsRecord_External::getListForItem($r));


    if($_POST["consent_type"] == 0){
        $DB->update(PluginDlteamsRecord::getTable(),[
            "r_consentexplicit" => "n/a"
        ],
            ["id" => $_POST["plugin_dlteams_records_id"]]);

        $DB->update(PluginDlteamsRecord::getTable(),[
            "r_consentjustif" => "n/a"
        ],
            ["id" => $_POST["plugin_dlteams_records_id"]]);
    }

    if($_POST["consent_type"] == 1){
        $DB->update(PluginDlteamsRecord::getTable(),[
            "r_consentexplicit" => $r->fields["consent_explicit"]
        ],
            ["id" => $_POST["plugin_dlteams_records_id"]]);

        $DB->update(PluginDlteamsRecord::getTable(),[
            "r_consentjustif" => "n/a"
        ],
            ["id" => $_POST["plugin_dlteams_records_id"]]);
    }




    $DB->update(PluginDlteamsRecord::getTable(),[
        "r_consentjustif" => $_POST["consent_type"]==1 && $_POST["consent_explicit"]?"oui":"n/a"
    ],
        ["id" => $_POST["plugin_dlteams_records_id"]]);


}


Html::back();
