<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include('../inc/includes.php');
use GuzzleHttp\Client as Guzzle_Client;
use GuzzleHttp\Psr7\Message;
use GuzzleHttp\Psr7\Response;
use GuzzleHttp\Psr7\Request;
use wapmorgan\UnifiedArchive\Formats;
use wapmorgan\UnifiedArchive\UnifiedArchive;
use Glpi\Marketplace\Controller as MarketplaceController;

$httpClient = new Guzzle_Client();
$request = new Request('GET', 'https://update.dlteams.app/plugin/versions');
$res = $httpClient->sendAsync($request, [])->wait();

$remote_versions = json_decode($res->getBody()->getContents(), true);
$remote_versions = $remote_versions["versions"];
if (is_array($remote_versions)) {

    $higher_version = null;

    foreach ($remote_versions as $release) {
        // Si $maxItem n'est pas encore défini, ou si la version courante est supérieure
        if ($higher_version === null
            || version_compare($release['version'], $higher_version['version'], '>')) {
            $higher_version = $release;
        }
    }


    $plugin_inst = new Plugin();
    $exists = $plugin_inst->getFromDBbyDir("dlteams");
    $currentversion = $plugin_inst->fields["version"];

    if ($currentversion != $higher_version["version"]) {
        $url      = $higher_version["download_url"];
        $filename = basename(parse_url($url, PHP_URL_PATH));
        $dest     = GLPI_TMP_DIR . '/' . $filename;

        $options = [
            'headers'  => [
                'Accept' => '*/*',
            ],
            'sink'     => $dest,
        ];


//        $client = new Guzzle_Client();
//        $response = $client->request('GET', 'https://dlteams.free.beeceptor.com/plugin/versions');





        try {
            $response = $httpClient->request('GET', $url, $options); // ok fichier téléchargé
//            decompresser l'archive vers un nom de version
            // extract the archive
            if (!UnifiedArchive::canOpen($dest)) {
                $type = Formats::detectArchiveFormat($dest);
                Session::addMessageAfterRedirect(
                    sprintf(__('Plugin archive format is not supported by your system : %s.'), $type),
                    false,
                    ERROR
                );
                return false;
            }

            // Some plugins archives may be huge, as they may embed some binaries.
            // Upgrade memory limit to 512M, which should be enough.
            $memory_limit = (int)Toolbox::getMemoryLimit();
            if ($memory_limit > 0 && $memory_limit < (512 * 1024 * 1024)) {
                ini_set('memory_limit', '512M');
            }

            $archive = UnifiedArchive::open($dest);
            $error = $archive === null;
            if (!$error) {
                // clean dir in case of update
                Toolbox::deleteDir(GLPI_MARKETPLACE_DIR . "/dlteams1");
                mkdir(GLPI_MARKETPLACE_DIR . "/dlteams1");
                chmod(GLPI_MARKETPLACE_DIR . "/dlteams1", 0777);

                try {
                    // copy files
                    $dlteams_dir = GLPI_MARKETPLACE_DIR . "/dlteams1";
                    mkdir(GLPI_MARKETPLACE_DIR . "/dlteams1", 0777, true);
                    $archive->extract(GLPI_MARKETPLACE_DIR. "/dlteams1") !== false;
                    chmod(GLPI_MARKETPLACE_DIR . "/dlteams1", 0777);
                    unlink($dest);
                    Session::addMessageAfterRedirect("Succès");

                } catch (\wapmorgan\UnifiedArchive\Exceptions\ArchiveExtractionException $e) {

                    $error = true;
                }
            }

            Toolbox::deleteDir(GLPI_MARKETPLACE_DIR . "/dlteams");
            $renameresult = rename(GLPI_MARKETPLACE_DIR . "/dlteams1", GLPI_MARKETPLACE_DIR . "/dlteams");

            ob_start();
//            $plugin_inst->update([
//                'id'    => $plugin_inst->fields['id'],
//                'state' => Plugin::ACTIVATED,
//                'version' => $higher_version["version"]
//            ]);
            if ($plugin_inst->getFromDBbyDir("dlteams")) {
                $marketplace_ctrl = new MarketplaceController("dlteams");
                $marketplace_ctrl->installPlugin();
                $marketplace_ctrl->enablePlugin();
            }


            ob_end_clean();

            if ($error) {
                Session::addMessageAfterRedirect(
                    __('Unable to extract plugin archive.'),
                    false,
                    ERROR
                );
                Session::addMessageAfterRedirect("Vous pouvez télécharger manuellement depuis <a href='$url'>$url</a> et extraire vers $dlteams_dir");
                return false;
            }


            global $CFG_GLPI;
            Html::redirect($CFG_GLPI["root_doc"] . "/front/central.php");

        }
        catch (HttpRequestException $e) {

            Toolbox::logDebug( [
                'title'     => "Plugins API error",
                'exception' => $e->getMessage(),
//                'request'   => HttpMessage::toString($e->getRequest()),
            ]);

            Html::back();

        }
    }
}
Html::back();
