<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

use GlpiPlugin\dlteams\Exception\ImportFailureException;

class PluginDlteamsDatacatalog_Childs_Massiveactions extends CommonDBTM
{
    static function canCreate() { return true;}
    static function canView() { return true;}
    static function canUpdate() { return true;}
    static function canDelete() { return true;}
    static function canPurge() { return true;}
    function canCreateItem() { return true;}
    function canViewItem() { return true;}
    function canUpdateItem() { return true;}
    function canDeleteItem() { return true;}
    function canPurgeItem() { return true;}

    public function __construct()
    {
        self::forceTable(PluginDlteamsDataCatalog::getTable());
        parent::__construct();
    }

    public static function processMassiveActionsForOneItemtype(MassiveAction $ma, CommonDBTM $item, array $ids)
    {
/*        highlight_string("<?php\n\$data =\n" . var_export($ma->getAction(), true) . ";\n?>");*/
/*        highlight_string("<?php\n\$data =\n" . var_export($item->fields, true) . ";\n?>");*/
/*        highlight_string("<?php\n\$data =\n" . var_export($ids, true) . ";\n?>");*/
        die();

        switch ($ma->getAction()){
            case 'update_child_storage':
                $data_ = [
//                    "datacatalogs_id" =>
                ];
                break;
            case 'update_child_appliances':
                break;
            case 'update_child_locations':
                break;
            case 'update_child_records':
                break;
        }

        parent::processMassiveActionsForOneItemtype($ma, $item, $ids); // TODO: Change the autogenerated stub
    }

    function getSpecificMassiveActions($checkitem = NULL)
    {
        $actions = parent::getSpecificMassiveActions($checkitem);

        // add a single massive action
        $class = __CLASS__;

        $action_key = "update_child_storage";
        $action_label = __("Mettre à jour les sous-catalogues avec les Stockages", "dlteams");
        $actions[$class . MassiveAction::CLASS_ACTION_SEPARATOR . $action_key] = $action_label;

        $action_key = "update_child_appliances";
        $action_label = __("Mettre à jour les sous-catalogues avec les Applicatifs ", "dlteams");
        $actions[$class . MassiveAction::CLASS_ACTION_SEPARATOR . $action_key] = $action_label;

        $action_key = "update_child_locations";
        $action_label = __("Mettre à jour les sous-catalogues avec les Lieux", "dlteams");
        $actions[$class . MassiveAction::CLASS_ACTION_SEPARATOR . $action_key] = $action_label;

        $action_key = "update_child_records";
        $action_label = __("Mettre à jour les sous-catalogues avec les Traitements", "dlteams");
        $actions[$class . MassiveAction::CLASS_ACTION_SEPARATOR . $action_key] = $action_label;

        return $actions;
    }

    function getForbiddenStandardMassiveAction()
    {
        $forbidden = parent::getForbiddenStandardMassiveAction();

        $forbidden[] = 'delete';
        $forbidden[] = 'purge';
        $forbidden[] = 'restore';

        $forbidden[] = 'update';
        $forbidden[] = 'clone';
        $forbidden[] = 'add_transfer_list';
        $forbidden[] = 'MassiveAction:amend_comment';
        return $forbidden;
    }
}
