<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

//require_once('record_item.class.php');
//require_once('record_juridique.class.php');

class PluginDlteamsDatacatalog_External extends CommonDBTM
{

//    static public $itemtype_1 = 'PluginDlteamsRecord';
//    static public $items_id_1 = 'plugin_dlteams_records_id';
//    static public $itemtype_2 = PluginDlteamsConcernedPerson::class;
//    static public $items_id_2 = 'plugin_dlteams_concernedpersons_id';

    static public $column1_id = '50';
    static public $column2_id = '51';

    static function canCreate() {return true;}
    static function canView() {return true;}
    static function canUpdate() {return true;}
    static function canDelete() {return true;}
    static function canPurge() {return true;}
    function canCreateItem() {return true;}
    function canViewItem() {return true;}
    function canUpdateItem() {return true;}
    function canDeleteItem() {return true;}
    function canPurgeItem() {return true;}
    function canEdit($id) {return true;}

    public function __construct()
    {
        self::forceTable("glpi_items_tickets");
    }

    static function getTypeName($nb = 0)
    {
        return _n("Intervenants", "Intervenant", $nb, 'dlteams');
    }

//    static function countForItem(CommonDBTM $item)
//    {
//        $dbu = new DbUtils();
//        return $dbu->countElementsInTable('glpi_plugin_dlteams_records_externals', ['plugin_dlteams_records_id' => $item->getID()]);
//    }


    function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {
        if (!$item->canView()) {
            return false;
        }

        global $DB;
        switch ($item->getType()) {
            case PluginDlteamsDataCatalog::class :
//                var_dump(count(PluginDlteamsRecord_External::getListForItem($item)));
//                die();
                $nb = count(PluginDlteamsDatacatalog_External::getListForItem($item)) + count($DB->request(PluginDlteamsDatacatalogActeur_Item::getRequest($item)));

                $query = PluginDlteamsDatacatalogActeur_Item::getRequest($item, true);
                if(!empty($query))
                    $nb+= count($DB->request($query));
                return self::createTabEntry(PluginDlteamsDatacatalog_External::getTypeName($nb), $nb);
        }

        return '';
    }

    static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {

        switch ($item->getType()) {
            case PluginDlteamsDataCatalog::class :
                PluginDlteamsDatacatalogActeur_Item::showItemsForItemTypeActeur($item, $withtemplate);

                echo "<br/>";
                PluginDlteamsDatacatalogActeur_Item::showItemsForItemTypeActeur($item, $withtemplate, true);

//                self::showForRecord($item, $withtemplate);
                break;
        }

        return true;
    }

    static function getListForItem(CommonDBTM $item)
    {

        global $DB;
//      $params = static::getListForItemParams($item, true);
//      $params['SELECT'][] = "glpi_plugin_dlteams_records_externals.recipient_reason AS recipient_reason";
//      $params['SELECT'][] = "glpi_plugin_dlteams_records_externals.recipient_comment AS recipient_comment";

        $request = [
            'SELECT' => [
                'glpi_plugin_dlteams_datacatalogs_items.id AS linkid',
                'glpi_plugin_dlteams_datacatalogs_items.id AS id',
                'glpi_plugin_dlteams_datacatalogs_items.itemtype AS itemtype',
                'glpi_plugin_dlteams_datacatalogs_items.items_id AS items_id',
                'glpi_plugin_dlteams_datacatalogs_items.itemtype1 AS itemtype1',
                'glpi_plugin_dlteams_datacatalogs_items.items_id1 AS items_id1',
                'glpi_plugin_dlteams_datacatalogs_items.comment AS comment',
            ],
            'FROM' => 'glpi_plugin_dlteams_datacatalogs_items',
            'ORDER' => ['glpi_plugin_dlteams_datacatalogs_items.id ASC'],
            'OR' => [
                [
                    'glpi_plugin_dlteams_datacatalogs_items.datacatalogs_id' => $item->fields['id'],
                    'glpi_plugin_dlteams_datacatalogs_items.itemtype' => 'PluginDlteamsConcernedPerson',
                    'glpi_plugin_dlteams_datacatalogs_items.itemtype1' => 'PluginDlteamsSendingReason',
                ],
                [
                    'glpi_plugin_dlteams_datacatalogs_items.datacatalogs_id' => $item->fields['id'],
                    'glpi_plugin_dlteams_datacatalogs_items.itemtype' => 'PluginDlteamsThirdPartyCategory',
                    'glpi_plugin_dlteams_datacatalogs_items.itemtype1' => 'PluginDlteamsSendingReason',
                ],
                [
                    'glpi_plugin_dlteams_datacatalogs_items.datacatalogs_id' => $item->fields['id'],
                    'glpi_plugin_dlteams_datacatalogs_items.itemtype' => 'Supplier',
                    'glpi_plugin_dlteams_datacatalogs_items.itemtype1' => 'PluginDlteamsSendingReason',
                ],
            ]
        ];

        //print_r($params);die;
        $iterator = $DB->request($request);
        return $iterator;
        //$iterator = $DB->request($params);
    }


    /**add by me**/
    function rawSearchOptions()
    {

        $tab = [];
//        $tab[] = [
//            'id' => "17",
//            'table' => PluginDlteamsConcernedPerson::getTable(),
//            'field' => 'name',
//            'name' => __("Personnes concernées"),
//            'forcegroupby' => true,
//            'massiveaction' => true,
//            'datatype' => 'dropdown',
//            'searchtype' => ['equals', 'notequals'],
//        ];
//
//        $tab[] = [
//            'id' => "18",
//            'table' => PluginDlteamsThirdPartyCategory::getTable(),
//            'field' => 'name',
//            'name' => __("Tiers Categories"),
//            'forcegroupby' => true,
//            'massiveaction' => true,
//            'datatype' => 'dropdown',
//            'searchtype' => ['equals', 'notequals'],
//        ];
//
//        $tab[] = [
//            'id' => "19",
//            'table' => Supplier::getTable(),
//            'field' => 'name',
//            'name' => __("tiers"),
//            'forcegroupby' => true,
//            'massiveaction' => true,
//            'datatype' => 'dropdown',
//            'searchtype' => ['equals', 'notequals'],
//        ];
//
//        $tab[] = [
//            'id' => "23",
//            'table' => PluginDlteamsSendingReason::getTable(),
//            'field' => 'name',
//            'name' => __("Motif Envoi"),
//            'forcegroupby' => true,
//            'massiveaction' => true,
//            'datatype' => 'dropdown',
//            'searchtype' => ['equals', 'notequals'],
//        ];

        $tab[] = [
            'id' => "24",
            'table' => PluginDlteamsRecord_External::getTable(),
            'field' => 'recipient_comment',
            'name' => __("Données"),
            'massiveaction' => true,
            'datatype' => 'text'
        ];

        return $tab;
    }


    public function getForbiddenStandardMassiveAction()
    {
        $forbidden = parent::getForbiddenStandardMassiveAction();
        $forbidden[] = 'clone';
//        $forbidden[] = 'MassiveAction:purge';
//        $forbidden[] = 'MassiveAction:update';
        $forbidden[] = 'MassiveAction:add_transfer_list';
        $forbidden[] = 'MassiveAction:amend_comment';
        return $forbidden;
    }

    static function showConsent(PluginDlteamsDataCatalog $datacatalog, $data = [])
    {
        if ($data['consent_type'] == 0) {
        } else if ($data['consent_type'] == 3) {
            echo "<span style='margin-left:10px;margin-top:20px;width:170px'>";
            //echo __("Tiers ", 'dlteams');
            //echo "<br/><br/>";

            Supplier::dropdown([
                'addicon' => Supplier::canCreate(),
                'name' => "suppliers_id",
                'display_emptychoice' => false,
                'width' => '150px'
            ]);
            echo "</span>";

//
            echo "<span style='margin-left:90px;margin-top:20px;width:280px'>";
            echo __("Motif d'envoi ", 'dlteams');
            //echo "<br/><br/>";
            PluginDlteamsSendingReason::dropdown([
                'addicon' => PluginDlteamsSendingReason::canCreate(),
                'name' => 'plugin_dlteams_sendingreasons_id',
                'width' => '250px'
            ]);
            //echo "<br/><br/>";
            echo "</span>";
            echo "<span style='margin-left:100px;margin-top:20px;width:30%'>";
            // echo __("Commentaire ");
            //echo "<br/><br/>";
            echo "<textarea type='text' maxlength=600 rows='1' name='recipient_comment' style='width:30%;margin-bottom:-13px;margin-top:20px' placeholder='Rôle'></textarea>";
            echo "</span>";

//echo "<br/><br/>";
            echo "<input type='submit' name='add' value=\"" . _sx('button', 'Add') . "\" class='submit' style='margin-top:18px;float:right;margin-right:7%'>";
//

        } else if ($data['consent_type'] == 1) {
            echo "<span style='margin-left:10px;margin-top:20px;width:170px'>";
            // echo __("Personnes Concernees ", 'dlteams');
            //echo "<br/><br/>";
            PluginDlteamsConcernedPerson::dropdown([
                'addicon' => PluginDlteamsConcernedPerson::canCreate(),
                'name' => "plugin_dlteams_concernedpersons_id",
                'width' => '150px'
            ]);
            echo "</span>";
            //
            echo "<span style='margin-left:90px;margin-top:20px;width:280px'>";
            echo __("Motif d'envoi ", 'dlteams');
            //echo "<br/><br/>";
            PluginDlteamsSendingReason::dropdown([
                'addicon' => PluginDlteamsSendingReason::canCreate(),
                'name' => 'plugin_dlteams_sendingreasons_id',
                'width' => '250px'
            ]);
            //echo "<br/><br/>";
            echo "</span>";
            echo "<span style='margin-left:100px;margin-top:20px;width:30%'>";
            // echo __("Commentaire ");
            //echo "<br/><br/>";
            echo "<textarea type='text' maxlength=600 rows='1' name='recipient_comment' style='width:30%;margin-bottom:-13px;margin-top:20px' placeholder='Rôle'></textarea>";
            echo "</span>";

//echo "<br/><br/>";
            echo "<input type='submit' name='add' value=\"" . _sx('button', 'Add') . "\" class='submit' style='margin-top:18px;float:right;margin-right:7%'>";
//

        } else if ($data['consent_type'] == 2) {
            // Display explicit consentecho "<td><br>" . "</td><td>";
            echo "<span style='margin-left:10px;margin-top:20px;width:170px'>";
            //echo __("Tiers Categories ", 'dlteams');
            //echo "<br/><br/>";
            PluginDlteamsThirdPartyCategory::dropdown([
                'addicon' => PluginDlteamsThirdPartyCategory::canCreate(),
                'name' => "plugin_dlteams_thirdpartycategories_id",
                'width' => '150px',
            ]);
            echo "</span>";
            //
            echo "<span style='margin-left:90px;margin-top:20px;width:280px'>";
            echo __("Motif d'envoi ", 'dlteams');
            //echo "<br/><br/>";
            PluginDlteamsSendingReason::dropdown([
                'addicon' => PluginDlteamsSendingReason::canCreate(),
                'name' => 'plugin_dlteams_sendingreasons_id',
                'width' => '250px',
            ]);
            //echo "<br/><br/>";
            echo "</span>";
            echo "<span style='margin-left:100px;margin-top:20px;width:30%'>";
            // echo __("Commentaire ");
            //echo "<br/><br/>";
            echo "<textarea type='text' maxlength=600 rows='1' name='recipient_comment' style='width:30%;margin-bottom:-13px;margin-top:20px' placeholder='Rôle'></textarea>";
            echo "</span>";

//echo "<br/><br/>";
            echo "<input type='submit' name='add' value=\"" . _sx('button', 'Add') . "\" class='submit' style='margin-top:18px;float:right;margin-right:7%'>";
//
        }
    }

    static function showConsent1(PluginDlteamsDataCatalog $datacatalog, $data = [])
    {
        if ($data['consent_type1'] == 0) {
        } else if ($data['consent_type1'] == 1) {
            //echo __("Groupe <i class='fas fa-dolly'></i>&nbsp;", 'dlteams');
            Group::dropdown([
                'addicon' => Group::canCreate(),
                'name' => "groups_id",
                'display_emptychoice' => false,
                'width' => "200px"
            ]);
            echo "<textarea type='text' rows='1' name='comment' placeholder='Rôle'  style='margin-bottom:-15px;margin-left:190px;width:45%'></textarea>";
            echo "<input type='submit' name='add1' value=\"" . _sx('button', 'Add') . "\" class='submit' style='float:right;margin-right:7.5%'>";

        } else if ($data['consent_type1'] == 2) {
            //echo __("Utilisateur <i class='fas fa-dolly'></i>&nbsp;", 'dlteams');

            /*User::dropdown([
            'addicon'  => User::canCreate(),
            'name' => "users_id",
            'display_emptychoice' => false,
            'width' => "200px"

         ]); */
            $randDropdown = mt_rand();
            User::dropdown([
//                'value' => $datacatalog->fields["users_id"],
                'entity' => $datacatalog->fields["entities_id"],
                'right' => 'all',
                'width' => '200px',
                'rand' => $randDropdown]);
            echo "<textarea type='text' maxlength=600 rows='1' name='comment' placeholder='Rôle' style='margin-bottom:-15px;margin-left:140px;width:45%'></textarea>";
            echo "<input type='submit' name='add1' value=\"" . _sx('button', 'Add') . "\" class='submit' style='float:right;margin-right:7.5%'>";


        } else if ($data['consent_type1'] == 3) {
            // Display explicit consentecho "<td><br>" . "</td><td>";

            //echo __("Tiers Categories <i class='fas fa-dolly'></i>&nbsp;", 'dlteams');

//            echo "<span style='margin-right:10px;'>";
//            //echo __("Tiers ", 'dlteams');
//            //echo "<br/><br/>";
//
//            PluginDlteamsRgpdAdequacy::dropdown([
//                'addicon' => PluginDlteamsRgpdAdequacy::canCreate(),
//                'name' => "rgpdadequacies_id",
//                'display_emptychoice' => false,
//                'width' => '150px'
//            ]);
//            echo "</span>";


            PluginDlteamsThirdPartyCategory::dropdown([
                'addicon' => PluginDlteamsThirdPartyCategory::canCreate(),
                'name' => "plugin_dlteams_thirdpartycategories_id1",
                'width' => "200px"
            ]);
            echo "<textarea type='text' maxlength=600 rows='1' name='comment' placeholder='Rôle' style='margin-bottom:-15px;margin-left:110px;width:35%'></textarea>";
            echo "<input type='submit' name='add1' value=\"" . _sx('button', 'Add') . "\" class='submit' style='float:right;margin-right:7.5%'>";

        } else if ($data['consent_type1'] == 4) {
            // Display explicit consentecho "<td><br>" . "</td><td>";

            //echo __("Tiers <i class='fas fa-dolly'></i>&nbsp;", 'dlteams');
//            echo "<span style='margin-right:10px;'>";
//            //echo __("Tiers ", 'dlteams');
//            //echo "<br/><br/>";
//
//            PluginDlteamsRgpdAdequacy::dropdown([
//                'addicon' => PluginDlteamsRgpdAdequacy::canCreate(),
//                'name' => "rgpdadequacies_id",
//                'display_emptychoice' => false,
//                'width' => '150px'
//            ]);
//            echo "</span>";

            Supplier::dropdown([
                'addicon' => Supplier::canCreate(),
                'name' => "suppliers_id1",
                'display_emptychoice' => false,
                'width' => "200px"
            ]);
            echo "<textarea type='text' maxlength=600 rows='1' name='comment' placeholder='Rôle' style='margin-bottom:-15px;margin-left:110px;width:35%'></textarea>";

            echo "<input type='submit' name='add1' value=\"" . _sx('button', 'Add') . "\" class='submit' style='float:right;margin-right:7.5%'>";
        }

    }


}
