<?php

/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

use Glpi\Application\View\TemplateRenderer;
use Glpi\RichText\RichText;

class PluginDlteamsDeliverable extends CommonDropdown implements PluginDlteamsExportableInterface{
    static $rightname = 'plugin_dlteams_deliverable';
    public $dohistory = true;
    protected $usenotepad = true;

    public function __construct()
    {
        if (isset($_GET['forcetab'])) {
            Session::setActiveTab(__CLASS__, $_GET['forcetab']);
            unset($_GET['forcetab']);
        }
        parent::__construct();
    }

    static function getTypeName($nb = 0)
    {
        return _n("HTML file", "HTML files", $nb, 'dlteams');
    }

    public function showTabsContent($options = [])
    {
        parent::showTabsContent($options); // TODO: Change the autogenerated stub
    }

    public function showApprovalForm(){
        echo '<div class="container mt-5">';
        echo '  <div class="row justify-content-center">';
        echo '    <div class="col-md-8 col-lg-6">';
        echo '      <div class="card shadow-sm">';
        echo '        <div class="card-header text-center">';
        echo '          <h4>' . __("Veuillez saisir votre adresse email", "dlteams") . '</h4>';
        echo '        </div>';
        echo '        <div class="card-body">';
        echo '          <p class="mb-2">' . __("Vous recevrez un courriel vous permettant d'approuver ce document", "dlteams") . '</p>';
//        echo '          <p>' . __("Souhaitez-vous :", "dlteams") . '</p>';
        echo '          <form method="post" action="'.Toolbox::getItemTypeFormURL(__CLASS__).'" >';

        echo "<input type='hidden' name='deliverable_id' value='" . $this->fields["id"] . "'>";

        echo '            <div class="form-check mb-3">';
        echo '              <input class="form-control" type="text" placeholder="Adresse mail" name="email">';
//        echo '              <label class="form-check-label" for="choice1">' . __("Renommer le document avec le nom du fichier html", "dlteams") . '</label>';
        echo '            </div>';

        echo '            <button type="submit" name="approvedeliverable" class="btn btn-primary w-100">' . __("Valider", "dlteams") . '</button>';
        Html::closeForm();
        echo '        </div>';
        echo '      </div>';
        echo '    </div>';
        echo '  </div>';
        echo '</div>';
    }

    public function showDocumentActions() {
        echo '<div class="container mt-5">';
        echo '  <div class="row justify-content-center">';
        echo '    <div class="col-md-8 col-lg-6">';
        echo '      <div class="card shadow-sm">';
        echo '        <div class="card-header text-center">';
        echo '          <h4>' . __("Action sur le document", "dlteams") . '</h4>';
        echo '        </div>';
        echo '        <div class="card-body">';
        echo '          <p>' . __("Le nom de votre fichier HTML diffère du nom du document.", "dlteams") . '</p>';
        echo '          <p>' . __("Souhaitez-vous :", "dlteams") . '</p>';
        echo '          <form method="post" action="'.Toolbox::getItemTypeFormURL(__CLASS__).'" >';


        // Ajout des champs cachés pour retransmettre les données du POST précédent (sauf _glpi_csrf_token)
        foreach ($_POST as $key => $value) {
            if ($key !== '_glpi_csrf_token') {
                echo '<input type="hidden" name="' . htmlspecialchars($key, ENT_QUOTES, 'UTF-8') . '" value="' . htmlspecialchars($value, ENT_QUOTES, 'UTF-8') . '">';
            }
        }

        echo '            <div class="form-check mb-3">';
        echo '              <input class="form-check-input" type="radio" name="rename_choice" id="choice1" value="rename_document">';
        echo '              <label class="form-check-label" for="choice1">' . __("Renommer le document avec le nom du fichier html", "dlteams") . '</label>';
        echo '            </div>';
        echo '            <div class="form-check mb-3">';
        echo '              <input class="form-check-input" type="radio" name="rename_choice" id="choice2" value="rename_html">';
        echo '              <label class="form-check-label" for="choice2">' . __("Renommer le fichier html avec le nom du document", "dlteams") . '</label>';
        echo '            </div>';
        echo '            <div class="form-check mb-3">';
        echo '              <input class="form-check-input" type="radio" name="rename_choice" id="choice3" value="keep_different" checked>';
        echo '              <label class="form-check-label" for="choice3">' . __("Laisser les deux noms différents", "dlteams") . '</label>';
        echo '            </div>';
        echo '            <button type="submit" class="btn btn-primary w-100">' . __("Valider", "dlteams") . '</button>';
        Html::closeForm();
        echo '        </div>';
        echo '      </div>';
        echo '    </div>';
        echo '  </div>';
        echo '</div>';
    }

    static function getSpecificValueToSelect($field, $name = '', $values = '', array $options = [])
    {
        if (!is_array($values)) {
            $values = [$field => $values];
        }

        $options['display'] = false;
        switch ($field) {
            case 'items_id':
                if (isset($values['itemtype']) && !empty($values['itemtype'])) {
                    $options['name'] = $name;
                    $options['value'] = $values[$field];
                    return Dropdown::show($values['itemtype'], $options);
                }
                break;
        }
        return parent::getSpecificValueToSelect($field, $name, $values, $options);
    }

    public static function getSpecificValueToDisplay($field, $values, array $options = [])
    {

        if (isset($options["searchopt"]["editbutton"]) && $options["searchopt"]["editbutton"]) {
            $id = $options["raw_data"]["raw"]["id"];

            $output = "";

            $url = Toolbox::getItemTypeFormURL("PluginDlteamsDeliverable")
                . "?items_id=" . $id . "&report_type="
                . PluginDlteamsPublish::REPORT_SINGLE_RECORD
                . "&print_comments=true"
                . "&prevent_contextmenu=true"
                . "&print_first_page=true"
                . "&edit_pdf=true&itemtype=PluginDlteamsDeliverable";

            $output .= "<a href='$url' target='_blank'>" . __("Edit / Print PDF", 'dlteams') . "</a>";

            $output .= Html::closeForm(false);
            return $output;
        }
        parent::getSpecificValueToDisplay($field, $values, $options);
    }

//    public static function getAdditionalMenuLinks()
//    {
//        $image = "<i class='fas fa-question' title='" . 'Aide' . "'></i>";
//        $links[$image] = KnowbaseItem::getSearchURL(false) . '?contains="base de connaissances"';
//        return $links;
//    }

    public static function getCurrentId()
    {
        // Get the current URL
        $currentURL = $_SERVER['REQUEST_URI'];

        // Get the query string from the URL
        $queryString = parse_url($currentURL, PHP_URL_QUERY);

        // Initialize an empty array for query parameters
        $queryParams = [];

        // Parse the query string into an array of parameters if it exists
        if ($queryString) {
            parse_str($queryString, $queryParams);
        }

        // Get the value of the "id" parameter
        $id = isset($queryParams['id']) ? $queryParams['id'] : null;

        return $id;
    }


//    public static function getAdditionalMenuLinks()
//    {
//        $plus = "<i class='fas fa-add' onclick='' title='" . __("add tab", 'dlteams') . "'></i> <span style='margin-left: 4px;'>ajouter chapitre</span>";
//
//        $temp_url = "/marketplace/dlteams/front/deliverable_section.form.php" . "?deliverables_id=" . static::getCurrentId() . "&add_tab=" . true;
//        $links[$plus] = $temp_url;
//        return $links; // TODO: Change the autogenerated stub
//    }

    function showForm($id, $options = [])
    {
        global $CFG_GLPI;

        $this->initForm($id, $options);
        $this->showFormHeader($options);

        echo "<table, th, td width='60%'>";
        echo "<tr>";
        echo "<input type='hidden' name='deliverable_id' value='" . $id . "'>";
		
//        echo "<td width='15%' style='text-align:right'>" . " " . "</td>";
        echo "<td width='15%' style='text-align:right' >" . __("Document", 'dlteams') . "</td>";
        echo "<td>";
        // $name = Html::cleanInputText($this->fields['name']);
		$documents_id = Html::cleanInputText($this->fields['documents_id']);

		$document = new Document();
		// 2. Récupérer les données du document en utilisant l'ID
		if ($document->getFromDB($documents_id)) { // Le document a été trouvé
			$document_name = $document->fields['name'];
			$name = Html::cleanInputText($document_name) . " ({$documents_id})";
			$this->fields['name'] = $document_name;
			$this->update($this->fields);
		} else {
			$name = "Document introuvable (ID: {$document_id})";
		}
        
		if(!$this->fields["documents_id"]) 
            echo "<input type='text' style='width:98%' name='name' required value='" . $name . "'>" . "</td>";
		    //$document_url = Document::getFormURLWithID($this->fields["documents_id"])."&forcetab=Document";
			// echo "<a href='$document_url'>$name</a>";}
        else{
            $document_url = Document::getFormURLWithID($this->fields["documents_id"])."&forcetab=Document";
            echo "<a href='$document_url'>$name</a>";
        }
        echo "<td width='15%' style='text-align:right'>" . " " . "</td>";
        echo "</tr>";

//        echo "<tr>";
//        echo "<td width='15%' div style='text-align:right'>" . __("Document", 'dlteams') . "</div></td>";
//        echo "<td>";
//        Dropdown::show(Document::class, [
//            'addicon' => Document::canCreate(),
//            'name' => 'documents_id',
//            'value' => $this->fields['documents_id'],
//        ]);
//        echo "</td>";
//        echo "</tr>";


        echo "<tr>.";
//        echo "<td width='15%' style='text-align:right'>" . " " . "</td>";
        echo "<td width='15%' style='text-align:right'>" . __("Préambule", 'dlteams') . "</td>";
        echo "<td>";
        $cols = 100;
        $rows = 60;
        $content = Html::cleanInputText($this->fields["document_content"]);
//        echo "<textarea style='width: 98%;' name='content' rows='4'>" . $content . "</textarea>";
        Html::textarea([
            "name" => "document_content",
            "cols" => 100,
            "rows" => 5,
            "value" => $content,
            "enable_richtext" => true
        ]);
        echo "</td></tr>";

        echo "<tr>";
//        echo "<td width='15%' style='text-align:right'>" . " " . "</td>";
        echo "<td width='15%' style='text-align:right'>" . __("Comments") . "</td>";
        echo "<td>";
        $comment = Html::cleanInputText($this->fields["document_comment"]);
//        echo "<textarea style='width: 98%;' name='document_comment' rows='4'>" . $comment . "</textarea>";
        Html::textarea(['name' => 'document_comment',
            'value' => $comment,
            'enable_fileupload' => false,
            'enable_richtext' => true,
            'cols' => $cols,
            'rows' => $rows
        ]);
        echo "</td></tr>";
        echo "</table>";

        // Ajout du bandeau "créé par" et "modifié par"
        echo "<div>";
        echo "<span style='margin-top: 10px; text-align: start '>";
        $user = new User();
        $user->getFromDB($this->fields["users_id"]);
        if (isset($user->fields["firstname"]) && $user->fields["realname"])
            echo sprintf("Créé le %s par %s %s | ", date('d-m-Y H:i', strtotime($this->fields["date_creation"])), $user->fields["firstname"], $user->fields["realname"]);

        if (isset($this->fields["users_id_editor"])) {
            $user->getFromDB($this->fields["users_id_editor"]);
            if (isset($user->fields["firstname"]) && $user->fields["realname"])
                echo sprintf("Mis à jour le %s par %s %s", date('d-m-Y H:i', strtotime($this->fields["date_mod"])), $user->fields["firstname"], $user->fields["realname"]);
            echo "</span>";
        }
        echo "</div>";

        if($this->fields["id"]){
            $options["addbuttons"] = [
                'add_tab' => 'Ajouter chapitre'
            ];
        }

//        $options = [
//
//        ]
        $this->showFormButtons($options);
        Html::requireJs('tinymce');


        echo '<script>
        $(document).ready(function(e){
            $("form").submit(function(){
                var nameVal = $("input[name=\'name\']").val();
                var selectText = $("select[name=\'documents_id\'] option:selected").text();
                console.log(selectText);
                e.preventDefault();
                if(selectText!="" && nameVal !== selectText){
                    // Modification de l\'action pour rediriger vers deliverable.action.php
                    $(this).attr("action", "deliverable.action.php");
                   
                }
                // Sinon, le formulaire se soumet normalement avec son action par défaut.
            });
        });
        </script>';
        //$options['colspan'] = 2;
        //$this->showDates($options);





//        if($this->fields["id"]){
//            echo "<br/>";
//            echo "<br/>";
//
//            echo "<table class='tab_cadre_fixe'>";
//            echo "<tr class='tab_bg_2'><th colspan='4'>" . __("Journal des envois et approbations", 'dlteams') .
//                "</th>";
//            echo "</tr>";
//            echo "<th colspan='2'></th></tr>";
//            echo "</table>";
//
//
//            $canedit = $this->can($id, UPDATE); // canedit booleen = true
//            $iterator = static::getDocumentsNotificationsRequest($this);
//
//            $number = count($iterator);
//            $item_list = [];
//            foreach ($iterator as $data) {
//                array_push($item_list, $data);
//            }
//            $rand = mt_rand();
//
//            $ma_processor = PluginDlteamsDeliverable_Item::class;
//            echo "<div class='spaced' > ";
//            if ($canedit && count($iterator) > 0) {
//                Html::openMassiveActionsForm('mass' . $ma_processor . $rand);
//    //                Html::openMassiveActionsForm();
//                $massive_action_params = [
//                    'container' => 'mass' . $ma_processor . $rand,
//                    'num_displayed' => min($_SESSION['glpilist_limit'], $number)];
//                Html::showMassiveActions($massive_action_params);
//            }
//            echo "<br />";
//
//            echo "<table class='tab_cadre_fixehov' > ";
//
//            $header_begin = "<tr > ";
//            $header_top = '';
//            $header_bottom = '';
//            $header_end = '';
//
//            if ($canedit && $number) {
//                $header_begin .= "<th width = '10' > ";
//                $header_top .= Html::getCheckAllAsCheckbox('mass' . $ma_processor . $rand);
//                $header_bottom .= Html::getCheckAllAsCheckbox('mass' . $ma_processor . $rand);
//                $header_end .= "</th > ";
//            }
//
//
//    //        $header_end .= "<th> " . __("Name") . " </th > ";
//    //        $header_end .= "<th> " . __("Type") . " </th > ";
//            $header_end .= "<th> " . __("Date envoi") . " </th > ";
//    //        $header_end .= "<th> " . __("Demande d'approbation") . " </th > ";
//            $header_end .= "<th> " . __("Heure d'approbation") . " </th > ";
//            $header_end .= "<th> " . "" . " </th > ";
//            $header_end .= "</tr > ";
//
//    //        die();
//
//            echo $header_begin . $header_top . $header_end;
//            foreach ($item_list as $data) {
//                echo "<tr class='tab_bg_1' > ";
//
//                if ($canedit && $number) {
//                    echo "<td width = '10' > ";
//                    Html::showMassiveActionCheckBox($ma_processor, $data['linkid']);
//                    echo "</td > ";
//                }
//
//
//                $itemtype = $data["itemtype"];
//                $oi = new $itemtype();
//                $oi->getFromDB($data['items_id']);
//                $name = "<a target = '_blank' href = \"" . $itemtype::getFormURLWithID($data['items_id']) . "\">" . $oi->fields["name"] . "</a>";
//
//    //            echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
//    //            echo ">" . $name . "</td>";
//
//
//    //            echo "<td class='left'>" . $data['itemtype']::getTypeName() . " </td>";
//
//                echo "<td class='left'>" . date('d/m/Y H:i:s', strtotime($data["date_creation"])) . "</td>";
//    //            echo "<td class='left'>";
//    //            echo $data["approval_request"] ? "Oui" : "Non";
//    //            echo "</td>";
//
//                if ($data["date_approval"])
//                    echo "<td class='left'>" . date('d/m/Y H:i:s', strtotime($data["date_approval"])) . "</td>";
//                else
//                    echo "<td class='left'>--</td>";
//
//
//                echo "<td class='left'>";
//                $id = $data["id"];
//                echo "<a style='border: solid 1px; border-radius: 2px; padding: 2px; border-color: #6d9dc8; color: #6d9dc8; cursor: pointer;' class='btn-showcomment' data-comment-id='$id'><i class='fas fa-eye' title='" . __("show comment", 'dlteams') . "'></i></a>";
//                echo "</td>";
//
//
//                echo "</tr>";
//            }
//            echo "</table>";
//
//            echo "
//            <script>
//        $(document).ready(function () {
//            $('.btn-showcomment').on('click', function () {
//                var comment_id = $(this).attr('data-comment-id');
//
//
//                glpi_ajax_dialog({
//                    dialogclass: 'modal-xl',
//                    bs_focus: false,
//                    url: '/marketplace/dlteams/ajax/get_deliverable_notification_data.php',
//                    params: {
//                        comment_id,
//                    },
//                    title: i18n.textdomain('dlteams').__('Commentaires', 'dlteams'),
//                    close: function () {
//
//                    },
//                    fail: function () {
//                        displayAjaxMessageAfterRedirect();
//                    }
//                });
//            });
//        });
//
//    </script>
//            ";
//
//            if ($canedit && $number > 10) {
//                $massive_action_params['ontop'] = false;
//                Html::showMassiveActions($massive_action_params);
//                Html::closeForm();
//            }
//            if ($canedit) {
//                Html::closeForm();
//            }
//
//            echo "</div>";
//        }
    }

    public static function  getDocumentsNotificationsRequest(PluginDlteamsDeliverable $deliverable){
            $request = [
                "SELECT" => [
                    PluginDlteamsDeliverable_Item::getTable() . ".*",
                    PluginDlteamsDeliverable_Item::getTable() . ".id as linkid",
                ],
                "FROM" => PluginDlteamsDeliverable_Item::getTable(),
                "OR" => [
                    [
                        "itemtype" => "Document",
                        "deliverables_id" => $deliverable->fields["id"]
                    ],
//                    [
//                        "itemtype" => "User",
//                        "deliverables_id" => $item->fields["id"]
//                    ]
                ],
            ];
            global $DB;
            return $DB->request($request);

    }

    public static function showForProjectTask(ProjectTask $projecttask)
    {
        $ID = $projecttask->getField('id');
        if (!$projecttask->can($ID, READ)) {
            return false;
        }

        $canedit = $projecttask->canEdit($ID);
        $rand = mt_rand();

        $iterator = self::getListForItem($projecttask);
        $numrows = count($iterator);

        $tickets = [];
        $used = [];
        foreach ($iterator as $data) {
            $tickets[$data['id']] = $data;
            $used[$data['id']] = $data['id'];
        }

        if ($canedit) {
            $condition = [
                'NOT' => [
                    'glpi_tickets.status' => array_merge(
                        Ticket::getSolvedStatusArray(),
                        Ticket::getClosedStatusArray()
                    )
                ]
            ];
            echo TemplateRenderer::getInstance()->render('components/form/link_existing_or_new.html.twig', [
                'rand' => $rand,
                'link_itemtype' => __CLASS__,
                'source_itemtype' => ProjectTask::class,
                'source_items_id' => $ID,
                'target_itemtype' => Ticket::class,
                'dropdown_options' => [
                    'entity' => $projecttask->getEntityID(),
                    'entity_sons' => $projecttask->isRecursive(),
                    'used' => $used,
                    'displaywith' => ['id'],
                    'condition' => $condition
                ],
                'create_link' => Session::haveRight(Ticket::$rightname, CREATE)
            ]);
        }

        echo "<div class='spaced'>";
        if ($canedit && $numrows) {
            Html::openMassiveActionsForm('mass' . __CLASS__ . $rand);
            $massiveactionparams = ['num_displayed' => min($_SESSION['glpilist_limit'], $numrows),
                'container' => 'mass' . __CLASS__ . $rand
            ];
            Html::showMassiveActions($massiveactionparams);
        }

        echo "<table class='tab_cadre_fixehov'>";
        echo "<tr><th colspan='12'>" . Ticket::getTypeName($numrows) . "</th>";
        echo "</tr>";
        if ($numrows) {
            Ticket::commonListHeader(Search::HTML_OUTPUT, 'mass' . __CLASS__ . $rand);
            Session::initNavigateListItems(
                'Ticket',
                //TRANS : %1$s is the itemtype name,
                //        %2$s is the name of the item (used for headings of a list)
                sprintf(
                    __('%1$s = %2$s'),
                    ProjectTask::getTypeName(1),
                    $projecttask->fields["name"]
                )
            );

            $i = 0;
            foreach ($tickets as $data) {
                Session::addToNavigateListItems('Ticket', $data["id"]);
                Ticket::showShort(
                    $data['id'],
                    [
                        'row_num' => $i,
                        'type_for_massiveaction' => __CLASS__,
                        'id_for_massiveaction' => $data['linkid']
                    ]
                );
                $i++;
            }
        }
        echo "</table>";
        if ($canedit && $numrows) {
            $massiveactionparams['ontop'] = false;
            Html::showMassiveActions($massiveactionparams);
            Html::closeForm();
        }
        echo "</div>";
    }

    function showFormqqq($id, $options = [])
    {

        global $CFG_GLPI;

        $this->initForm($id, $options);
        $this->showFormHeader($options);


        echo "<tr class='tab_bg_1'>";
        echo "<td>" . __('Name') . "</td>";
        echo "</tr><td>";

        echo "<tr>";
        echo "<td>";

        echo "</td>";
        echo "</tr>";

        echo "<td rowspan='1'>" . __('Comments') . "</td>";
        $cols = 100;
        $rows = 60;
        echo "<td rowspan='1'>
               <textarea cols='45' rows='2' name='comment' id='field_name' >" . $this->fields["comment"];
        echo "</textarea></td>";


        echo "</tr>\n";
        echo "<tr>";
        echo "<td colspan='2'>";
        echo __('Content');
        echo "<br/>";
        echo "<br/>";
        Html::textarea(['name' => 'content',
            'value' => "", //\Glpi\RichText\RichText::getSafeHtml($this->fields['content'], true),
            'enable_fileupload' => false,
            'enable_richtext' => true,
            'cols' => $cols,
            'rows' => $rows
        ]);
        echo "</td>";
        echo "</tr>";

        return true;
    }

    function showDates($options = [])
    {

        $isNewID = ((isset($options['withtemplate']) && ($options['withtemplate'] == 2))
            || $this->isNewID($this->getID()));

        if ($isNewID) {
            return true;
        }

        $date_creation_exists = ($this->getField('date_creation') != NOT_AVAILABLE);
        $date_mod_exists = ($this->getField('date_mod') != NOT_AVAILABLE);

        $colspan = $options['colspan'];
        if ((!isset($options['withtemplate']) || ($options['withtemplate'] == 0))
            && !empty($this->fields['template_name'])) {
            $colspan = 1;
        }

        echo "<tr class='tab_bg_1 footerRow'>";
        //Display when it's not a new asset being created
        if ($date_creation_exists
            && $this->getID() > 0
            && (!isset($options['withtemplate']) || $options['withtemplate'] == 0 || $options['withtemplate'] == NULL)) {
            echo "<th colspan='$colspan'>";
            printf(__('Created on %s'), Html::convDateTime($this->fields["date_creation"]), " ;");
            echo "</th>";
        } else if (!isset($options['withtemplate']) || $options['withtemplate'] == 0 || !$date_creation_exists) {
            echo "<th colspan='$colspan'>";
            echo "</th>";
        }

        if (isset($options['withtemplate']) && $options['withtemplate']) {
            echo "<th colspan='$colspan'>";
            //TRANS: %s is the datetime of insertion
            printf(__('Created on %s'), Html::convDateTime($_SESSION["glpi_currenttime"]));
            echo "</th>";
        }
        echo "  -  ";
        if ($date_mod_exists) {
            echo "<th colspan='$colspan'>";
            //TRANS: %s is the datetime of update
            printf(__('Last update on %s'), Html::convDateTime($this->fields["date_mod"]));
            echo "</th>";
        } else {
            echo "<th colspan='$colspan'>";
            echo "</th>";
        }

        if ((!isset($options['withtemplate']) || ($options['withtemplate'] == 0))
            && !empty($this->fields['template_name'])) {
            echo "<th colspan='" . ($colspan * 2) . "'>";
            printf(__('Created from the template %s'), $this->fields['template_name']);
            echo "</th>";
        }

        echo "</tr>";
    }

    public static function getDefaultSearchRequest()
    {
        $search = [
            'criteria' => [
                0 => [
                    'field' => 0,
                    'searchtype' => 'contains',
                    'value' => ''
                ],
            ],
            'sort' => 9,
            'order' => 'DESC'
        ];
        return $search;
    }

    function rawSearchOptions()
    {

        $tab = [];

        $tab[] = [
            'id' => 'common',
            'name' => __("Characteristics")
        ];

        $tab[] = [
            'id' => '1',
            'table' => $this->getTable(),
            'field' => 'name',
            'name' => __("Name"),
            'datatype' => 'itemlink',
            'massiveaction' => false,
            'autocomplete' => true,
        ];

        $tab[] = [
            'id' => '2',
            'table' => $this->getTable(),
            'field' => 'id',
            'name' => __("ID"),
            'massiveaction' => false,
            'datatype' => 'number',
        ];

        $tab[] = [
            'id' => '3',
            //'table' => 'glpi_documentcategories',
            'table' => 'glpi_projecttasks',
            'field' => 'name',
            'name' => __("Rubrique"),
            'datatype' => 'dropdown',
            'toview' => true,
            'massiveaction' => true,
        ];

        $tab[] = [
            'id' => '4',
            'table' => $this->getTable(),
            'field' => 'document_content',
            'name' => __("Content"),
            'datatype' => 'text',
            'htmltext' => true,
            'toview' => true,
            'massiveaction' => true,
        ];

        $tab[] = [
            'id' => '5',
            'table' => $this->getTable(),
            'field' => 'comment',
            'name' => __("Comments"),
            'datatype' => 'text',
            'toview' => true,
            'massiveaction' => true,
        ];

        $tab[] = [
            'id' => '6',
            'table' => 'glpi_entities',
            'field' => 'completename',
            'name' => __("Entity"),
            'massiveaction' => true,
            'datatype' => 'dropdown',
        ];

        $tab[] = [
            'id' => '7',
            'table' => $this->getTable(),
            'field' => 'is_recursive',
            'name' => __("Child entities"),
            'massiveaction' => false,
            'datatype' => 'bool',
        ];

        $tab[] = [
            'id' => '8',
            'table' => $this->getTable(),
            'field' => 'date_creation',
            'name' => __("Creation date"),
            'massiveaction' => false,
            'datatype' => 'text',
        ];

        $tab[] = [
            'id' => '9',
            'table' => $this->getTable(),
            'field' => 'date_mod',
            'name' => __("Last update"),
            'massiveaction' => false,
            'datatype' => 'text',
        ];

        $tab[] = [
            'id' => '10',
            'table' => $this->getTable(),
            'field' => 'id',
            'name' => __("Editer"),
            'massiveaction' => false,
            'datatype' => 'specific',
            'editbutton' => true
        ];

//        $tab[] = [
//            'id' => '10',
//            'table' => Deliverable_Item::getTable(),
//            'field' => 'date_mod',
//            'name' => __("Last update"),
//            'massiveaction' => false,
//            'datatype' => 'text',
//        ];

        return $tab;
    }

    public function defineTabs($options = [])
    {
        $ong = [];
        $ong = array();


        $this->addDefaultFormTab($ong)
            ->addStandardTab(PluginDlteamsDeliverable_Section::class, $ong, $options)
//            ->addStandardTab('PluginDlteamsProjectTask_Deliverable', $ong, $options)
            ->addStandardTab('PluginDlteamsPublish', $ong, $options)
            ->addStandardTab(PluginDlteamsDeliverableNotification::class, $ong, $options)
            ->addStandardTab(PluginDlteamsMessage::class, $ong, $options)
//            ->addStandardTab('PluginDlteamsObject_document', $ong, $options)
            ->addStandardTab('Notepad', $ong, $options)
			->addStandardTab('KnowbaseItem_Item', $ong, $options)
            ->addStandardTab('Ticket', $ong, $options)
            ->addImpactTab($ong, $options)
            ->addStandardTab('PluginDlteamsObject_allitem', $ong, $options)
            ->addStandardTab('Log', $ong, $options);
        return $ong;
    }


//    public function getForbiddenStandardMassiveAction()
//    {
//        $forbidden = parent::getForbiddenStandardMassiveAction();
//        $forbidden[] = 'Infocom:activate';
//        $forbidden[] = 'MassiveAction:add_transfer_list';
//        $forbidden[] = 'Document_Item:add';
//        $forbidden[] = 'Contract_Item:add';
//        $forbidden[] = 'MassiveAction:amend_comment';
//        $forbidden[] = 'MassiveAction:add_note';
//        $forbidden[] = 'PluginDlteamsDeliverable:copyTo';
//        return $forbidden;
//    }

    function exportToDB($subItems = [])
    {
        if ($this->isNewItem()) {
            return false;
        }

        $export = $this->fields;
        return $export;
    }

    public static function importToDB(PluginDlteamsLinker $linker, $input = [], $containerId = 0, $subItems = [])
    {
        $item = new self();
        $originalId = $input['id'];
        unset($input['id']);
        $input['entities_id'] = $_POST['entities_id'];;
        $input['comment'] = str_replace(['\'', '"'], "", $input['comment']);
        $input['name'] = str_replace(['\'', '"'], "", $input['name']);
        $input['content'] = str_replace(['\'', '"'], "", $input['content']);
        $itemId = $item->add($input);
        if ($itemId === false) {
            $typeName = strtolower(self::getTypeName());
            throw new ImportFailureException(sprintf(__('failed to copy the %1$s record', 'dlteams'), $input['name']));
        }
        return $itemId;
    }

    public function deleteObsoleteItems(CommonDBTM $container, array $exclude)
    {
    }

    public function post_purgeItem()
    {
        $dsection_query = [
            "FROM" => PluginDlteamsDeliverable_Section::getTable(),
            "WHERE" => [
                "deliverables_id" => $this->fields["id"]
            ]
        ];
        global $DB;
        $dsection_query_iterator = $DB->request($dsection_query);
        foreach ($dsection_query_iterator as $dsection) {
            $deliverable_content = new PluginDlteamsDeliverable_Content();
            $deliverable_content->deleteByCriteria([
                "deliverable_sections_id" => $dsection["id"]
            ]);
        }

        $deliverablesection = new PluginDlteamsDeliverable_Section();
        $deliverablesection->deleteByCriteria([
            "deliverables_id" => $this->fields["id"]
        ]);


        Session::addMessageAfterRedirect("Les sections et leurs contenus ont été supprimés avec succès");
        parent::post_purgeItem(); // TODO: Change the autogenerated stub
    }

    public static function showMassiveActionsSubForm(MassiveAction $ma)
    {
//        var_dump("jjsl");
//        die();
        switch ($ma->getAction()) {
            case 'copyTo':
               //                $values = [];
//                foreach ($_SESSION["glpiactiveentities"] ?? [] as $key => $entities_id) {
//                    $entity = new Entity();
//                    $entity->getFromDB($entities_id);
//                    $values[$key] = $entity->fields["completename"];
//                }
                Entity::dropdown(['name' => 'entities_id']);
                echo '<br /><br />' . Html::submit(_x('button', 'Post'), ['name' => 'massiveaction']);
                return true;
        }
        return parent::showMassiveActionsSubForm($ma);
    }

    static function processMassiveActionsForOneItemtype(MassiveAction $ma, CommonDBTM $item, array $ids)
    {
        switch ($ma->getAction()) {
            case 'copyTo':
                if ($item->getType() == 'PluginDlteamsDeliverable') {
                    foreach ($ids as $id) {
                        if ($item->getFromDB($id)) {
                            if ($item->copy1($ma->POST['entities_id'], $id, $item)) {
                                Session::addMessageAfterRedirect(sprintf(__('Deliverable copied: %s', 'dlteams'), $item->getName()));
                                $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_OK);
                            }
                        } else {
                            // Example of ko count
                            $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_KO);
                        }
                    }
                }
                return;
        }
        parent::processMassiveActionsForOneItemtype($ma, $item, $ids);
    }


    /**
     * @param $entity entité de destination vers laquelle sera éffectué la copie
     * @param $id id à copier
     * @param $item item à copier
     * @return bool
     */
    public function copy1($entity, $id, $item)
    {
        global $DB;
        $DB->beginTransaction();
        $dbu = new DbUtils();
        $name = addslashes($item->fields['name']);
        $entities_ori = $item->fields['entities_id'];
        $id_ori = $item->fields['id'];
        $nb = $dbu->countElementsInTable(static::getTable(), ['name' => $name, 'entities_id' => $entity, 'is_deleted' => 0]);

// code original
        try {
            if ($nb <= 0) {
                $deliverable_origin = new PluginDlteamsDeliverable();
                $new_deliverable = new PluginDlteamsDeliverable();
                $deliverable_origin->getFromDB($id_ori);


                // STEP 1 : on enleve les champs a ne pas copier
                unset($deliverable_origin->fields["date_creation"]);
                unset($deliverable_origin->fields["date_mod"]);
                unset($deliverable_origin->fields["links_id"]);
                unset($deliverable_origin->fields["users_id"]);
                unset($deliverable_origin->fields["id"]);// STEP 2 : creation des new deliverable

                /*                highlight_string("<?php\n\$data =\n" . var_export(addslashes($deliverable_origin->fields["document_content"]??""), true) . ";\n?>");*/
//                die();
                $newid = $new_deliverable->add([
                    ...$deliverable_origin->fields,
                    "name" => addslashes($deliverable_origin->fields["name"] ?? ""),
                    "content" => addslashes($deliverable_origin->fields["content"] ?? ""),
                    "comment" => addslashes($deliverable_origin->fields["comment"] ?? ""),
                    "object_approval" => addslashes($deliverable_origin->fields["object_approval"] ?? ""),
                    "object_notification" => addslashes($deliverable_origin->fields["object_notification"] ?? ""),
                    "document_content" => addslashes($deliverable_origin->fields["document_content"] ?? ""),
                    "document_title" => addslashes($deliverable_origin->fields["document_title"] ?? ""),
                    "document_comment" => addslashes($deliverable_origin->fields["document_comment"] ?? ""),
                    "text_approval" => addslashes($deliverable_origin->fields["text_approval"] ?? ""),
                    "text_notification" => addslashes($deliverable_origin->fields["text_notification"] ?? ""),
                    "entities_id" => $entity
                ]);

                // creation new sections avec deliverable_id
                $query = [
                    "FROM" => PluginDlteamsDeliverable_Section::getTable(),
                    "WHERE" => [
                        "deliverables_id" => $id_ori
                    ]
                ];

                $desction_iterator = $DB->request($query);
                foreach ($desction_iterator as $dsection_ori) {
                    $dsection = new PluginDlteamsDeliverable_Section();

                    $section_ori_id = $dsection_ori["id"];
                    unset($dsection_ori["date_creation"]);
                    unset($dsection_ori["date_mod"]);
                    unset($dsection_ori["id"]);
                    $newdsection_id = $dsection->add([
                        ...$dsection_ori,
                        "name" => addslashes($dsection_ori["name"] ?? ""),
                        "comment" => addslashes($dsection_ori["comment"] ?? ""),
                        "content" => addslashes($dsection_ori["content"] ?? ""),
                        "deliverables_id" => $newid
                    ]);

                    $query = [
                        "FROM" => PluginDlteamsDeliverable_Content::getTable(),
                        "WHERE" => [
                            "deliverable_sections_id" => $section_ori_id
                        ]
                    ];
                    $desction_content_iterator = $DB->request($query);
//                creation des content
                    if (count($desction_content_iterator) > 0) {

                        foreach ($desction_content_iterator as $decontent_ori) {
                            $decontent = new PluginDlteamsDeliverable_Content();

                            unset($decontent_ori["date_creation"]);
                            unset($decontent_ori["date_mod"]);
                            unset($decontent_ori["id"]);
                            $decontent->add([
                                ...$decontent_ori,
                                "name" => addslashes($decontent_ori["name"] ?? ""),
                                "comment" => addslashes($decontent_ori["comment"] ?? ""),
                                "content" => addslashes($decontent_ori["content"] ?? ""),
                                "deliverable_sections_id" => $newdsection_id
                            ]);
                        }
                    }

                }

                /**copy the document**/
                $document_query = [
                    "FROM" => Document_Item::getTable(),
                    "WHERE" => [
                        "items_id" => $id_ori,
                        "itemtype" => PluginDlteamsDeliverable::class,
                        "entities_id" => $entities_ori
                    ]
                ];
                $documentitem_iterator = $DB->request($document_query);
                foreach ($documentitem_iterator as $id => $documentitem_ori) {

//                        copy the origin document
                    $document = new Document();
                    $document_ori = new Document();
                    $document_ori->getFromDB($documentitem_ori['documents_id']);
                    unset($document_ori->fields["date_creation"]);
                    unset($document_ori->fields["id"]);
//                        add document if not exist
                    $crit_doc = [
//                        ...$document_ori->fields,
                        "name" => addslashes($document_ori->fields["name"] ?? ""),
                        "content" => addslashes($document_ori->fields["content"] ?? ""),
                        "comment" => addslashes($document_ori->fields["comment"] ?? ""),
                        "object_approval" => addslashes($document_ori->fields["object_approval"] ?? ""),
                        "object_notification" => addslashes($document_ori->fields["object_notification"] ?? ""),
                        "document_content" => addslashes($document_ori->fields["document_content"] ?? ""),
                        "document_comment" => addslashes($document_ori->fields["document_comment"] ?? ""),
                        "text_approval" => addslashes($document_ori->fields["text_approval"] ?? ""),
                        "text_notification" => addslashes($document_ori->fields["text_notification"] ?? ""),
                        "entities_id" => $entity
                    ];

                    if (!$document->getFromDBByCrit($crit_doc)) {
                        $newiddoc = $document->add($crit_doc);
                    } else {
                        $document->getFromDBByCrit($crit_doc);
                        $newiddoc = $document->fields["id"];
                    }

                    $document = new PluginDlteamsDeliverable();
                    $documentdeli_ori = new PluginDlteamsDeliverable();
                    $documentdeli_ori->getFromDB($documentitem_ori['items_id']);
                    unset($documentdeli_ori->fields["date_creation"]);
                    unset($documentdeli_ori->fields["id"]);
                    $crit_doc_deliverable = [
//                        ...$document_ori->fields,
                        "name" => addslashes($documentdeli_ori->fields["name"]),
                        "is_deleted" => 0,
                        "entities_id" => $entity
                    ];

                    $doc_deliverable = new PluginDlteamsDeliverable();
                    if (!$doc_deliverable->getFromDBByCrit($crit_doc_deliverable)) {
                        $newiddeliverable_doc = $doc_deliverable->add($crit_doc_deliverable);
                    } else {
                        $doc_deliverable->getFromDBByCrit($crit_doc_deliverable);
                        $newiddeliverable_doc = $doc_deliverable->fields["id"];
                    }

//                        then add the document item
                    $documentitem = new Document_Item();
                    unset($documentitem_ori["documents_id"]);
                    $documentitem->add([
                        ...$documentitem_ori,
                        "documents_id" => $newiddoc,
                        "items_id" => $newiddeliverable_doc,
                        "entities_id" => $entity
                    ]);


                }


                /**copy the document**/

//            copie des variables et des notifications
                $variable_notification_query = [
                    "FROM" => PluginDlteamsDeliverable_Item::getTable(),
                    "WHERE" => [
                        "deliverables_id" => $id_ori,
                        "entities_id" => $entities_ori
                    ]

                ];
                $variable_notification_iterator = $DB->request($variable_notification_query);
                foreach ($variable_notification_iterator as $id => $variable_notification_ori) {
//                    $val0 = $row['deliverables_id']; //get documents_id

                    $deliverable_ori = new PluginDlteamsDeliverable();
                    $deliverable_temp = new PluginDlteamsDeliverable();
                    $deliverable_ori->getFromDB($variable_notification_ori["deliverables_id"]);

                    unset($deliverable_ori->fields["date_creation"]);
                    unset($deliverable_ori->fields["date_mod"]);
                    unset($deliverable_ori->fields["links_id"]);
                    unset($deliverable_ori->fields["users_id"]);
                    unset($deliverable_ori->fields["id"]);
                    $exist_criteria = [
                        ...$deliverable_ori->fields,
                        "name" => addslashes($deliverable_ori->fields["name"]),
                        "content" => addslashes($deliverable_ori->fields["content"]),
                        "document_content" => addslashes($deliverable_ori->fields["document_content"] ?? ""),
                        "document_title" => addslashes($deliverable_ori->fields["document_title"] ?? ""),
                        "document_comment" => addslashes($deliverable_ori->fields["document_comment"] ?? ""),
                        "object_notification" => addslashes($deliverable_ori->fields["object_notification"] ?? ""),
                        "object_approval" => addslashes($deliverable_ori->fields["object_approval"] ?? ""),
                        "text_notification" => addslashes($deliverable_ori->fields["text_notification"] ?? ""),
                        "text_approval" => addslashes($deliverable_ori->fields["text_approval"] ?? ""),
                        "entities_id" => $entity
                    ];

                    if (!$deliverable_temp->getFromDBByCrit($exist_criteria)) {
                        $dtemp_id = $deliverable_temp->add([
                            ...$deliverable_ori->fields,
                            "name" => addslashes($deliverable_ori->fields["name"] ?? ""),
                            "content" => addslashes($deliverable_ori->fields["content"] ?? ""),
                            "document_content" => addslashes($deliverable_ori->fields["document_content"] ?? ""),
                            "document_title" => addslashes($deliverable_ori->fields["document_title"] ?? ""),
                            "document_comment" => addslashes($deliverable_ori->fields["document_comment"] ?? ""),
                            "object_notification" => addslashes($deliverable_ori->fields["object_notification"] ?? ""),
                            "object_approval" => addslashes($deliverable_ori->fields["object_approval"] ?? ""),
                            "text_notification" => addslashes($deliverable_ori->fields["text_notification"] ?? ""),
                            "text_approval" => addslashes($deliverable_ori->fields["text_approval"] ?? ""),
                            "entities_id" => $entity,
                        ]);
                        if (!$dtemp_id) {
                            $DB->rollback();
                            Session::addMessageAfterRedirect("Une erreur s'est produite", 0, ERROR);
//                            die();
                            return false;
                        }
                    } else {
                        $deliverable_temp->getFromDBByCrit($exist_criteria);
                        $dtemp_id = $deliverable_temp->fields["id"];
                    }

                    $deliverable_item = new PluginDlteamsDeliverable_Item();
                    unset($variable_notification_ori["date_creation"]);
                    unset($variable_notification_ori["date_mod"]);
                    unset($variable_notification_ori["id"]);
                    $deliverable_item->add([
                        ...$variable_notification_ori,
                        "deliverables_id" => $dtemp_id,
                        "entities_id" => $entity,
                        "comment" => addslashes($variable_notification_ori["comment"] ?? ""),
                        "text_notification" => addslashes($variable_notification_ori["text_notification"] ?? ""),
                        "text_approval" => addslashes($variable_notification_ori["text_approval"] ?? ""),
                        "object_notification" => addslashes($variable_notification_ori["object_notification"] ?? ""),
                        "object_approval" => addslashes($variable_notification_ori["object_approval"] ?? ""),
                    ]);

                    /**get ID of record copied***/
//                    $reqF = $DB->request("SELECT * FROM glpi_plugin_dlteams_deliverables_items WHERE name='$val1' and entities_id='$entity'");
                }

                $DB->commit();
                return true;

            } else {
                Session::addMessageAfterRedirect("Un élément existe déja avec le même nom", 0, WARNING);
                $DB->rollback();
                return false;
            }
        } catch (Exception $e) {
            $DB->rollback();
            throw new Exception($e->getMessage());
        }

        return true;
    }

    public static function getMenuContent()
    {
        echo <<<HTML
<script type="text/javascript">
\$(function() {
  // Délégation pour attraper tous les liens "Ajouter"
  \$(document).on('click', 'a.btn-secondary[href*="deliverable.form.php"]', function(e) {
    e.preventDefault();
    var url = "/marketplace/dlteams/ajax/add_document_from_deliverable.php";

    glpi_ajax_dialog({
      dialogclass: 'modal-lg',
      bs_focus:     false,
      url:          url,
      params:       {},  // pas de params spécifiques pour l'ajout
      title:        i18n.textdomain('dlteams').__('Ajouter', 'dlteams'),
      close: function() {
        // callback après fermeture (optionnel)
      },
      fail: function() {
        displayAjaxMessageAfterRedirect();
      }
    });
  });
});
</script>
HTML;
        return parent::getMenuContent(); // TODO: Change the autogenerated stub
    }
}

