<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

// require_once ('record_basedonnee.class.php');
use GlpiPlugin\dlteams\Exception\ImportFailureException;

class PluginDlteamsObject_document extends CommonDBRelation
{
//   static public $itemtype_1 = 'PluginDlteamsRecord';
//   static public $items_id_1 = 'plugin_dlteams_records_id';
    static public $itemtype_2 = 'Document';

//   static public $items_id_2 = 'items_id';

    static function canCreate()
    {
        return true;
    }

    static function canView()
    {
        return true;
    }

    static function canUpdate()
    {
        return true;
    }

    static function canDelete()
    {
        return true;
    }

    static function canPurge()
    {
        return true;
    }

    function canCreateItem()
    {
        return true;
    }

    function canViewItem()
    {
        return true;
    }

    function canUpdateItem()
    {
        return true;
    }

    function canDeleteItem()
    {
        return true;
    }

    function canPurgeItem()
    {
        return true;
    }

//    public static function getTable($classname = null)
//    {
//        return PluginDlteamsDocument_Item::getTable(); // TODO: Change the autogenerated stub
//    }
//
    public function __construct()
    {
        self::forceTable(PluginDlteamsDocument_Item::getTable());
    }

//   static function getTypeName($nb = 0) {
//      return __("Contracts, DB", 'dlteams');
//   }
    /**
     * Export in an array all the data of the current instanciated PluginDlteamsRecord_LegalBasisAct
     * @param boolean $remove_uuid remove the uuid key
     *
     * @return array the array with all data (with sub tables)
     */

    // fonction d'apparition et de comptage de l'onglet Documents
    function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {
        if (!$item->canView()) {
            return false;
        }
        switch ($item->getType()) {
            //case PluginDlteamsRecord::class :
            //   $nbitem = PluginDlteamsAllItem::countSpecificItems($item, [Document::getType(), /*PluginDlteamsDatabase::getType()*/ PluginDatabasesDatabase::getType()]);
            //   return self::createTabEntry(PluginDlteamsRecord_Element::getTypeName($nbitem), $nbitem);
            case PluginDlteamsConcernedPerson::class :
                $nbitem = countElementsInTable('glpi_documents_items', ['itemtype' => 'PluginDlteamsConcernedPerson', 'items_id' => $item->fields['id']]);
                return self::createTabEntry(Document::getTypeName(Session::getPluralNumber()), $nbitem);
            case PluginDlteamsPolicieForm::class :
                $nbitem = countElementsInTable('glpi_documents_items', ['itemtype' => 'PluginDlteamsPolicieForm', 'items_id' => $item->fields['id']]);
                return self::createTabEntry(Document::getTypeName(Session::getPluralNumber()), $nbitem);
            case PluginDlteamsStorageperiod::class :
                $nbitem = countElementsInTable('glpi_documents_items', ['itemtype' => 'PluginDlteamsStorageperiod', 'items_id' => $item->fields['id']]);
                return self::createTabEntry(Document::getTypeName(Session::getPluralNumber()), $nbitem);
            case PluginDlteamsDatabase::class :
                $nbitem = countElementsInTable('glpi_documents_items', ['itemtype' => 'PluginDlteamsDatabase', 'items_id' => $item->fields['id']]);
                return self::createTabEntry(Document::getTypeName(Session::getPluralNumber()), $nbitem);
            case PluginDlteamsDataCatalog::class :
                $nbitem = countElementsInTable('glpi_documents_items', ['itemtype' => 'PluginDlteamsDataCatalog', 'items_id' => $item->fields['id']]);
                return self::createTabEntry(Document::getTypeName(Session::getPluralNumber()), $nbitem);
            case PluginDlteamsAccountKey::class :
                $nbitem = countElementsInTable('glpi_documents_items', ['itemtype' => 'PluginDlteamsAccountKey', 'items_id' => $item->fields['id']]);
                return self::createTabEntry(Document::getTypeName(Session::getPluralNumber()), $nbitem);
            case Ticket::class :
                $nbitem = countElementsInTable('glpi_documents_items', ['itemtype' => 'Ticket', 'items_id' => $item->fields['id']]);
                return self::createTabEntry(Document::getTypeName(Session::getPluralNumber()), $nbitem);
            case DocumentCategory::class :
                $nbitem = countElementsInTable('glpi_documents', ['documentcategories_id' => $item->fields['id']]);
                return self::createTabEntry(Document::getTypeName(Session::getPluralNumber()), $nbitem);
            default:
                $nbitem = countElementsInTable('glpi_documents_items', ['itemtype' => $item->getType(), 'items_id' => $item->fields['id']]);
                return self::createTabEntry(Document::getTypeName(Session::getPluralNumber()), $nbitem);
        }
        return '';
    }


    public static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {

        switch ($item->gettype()) {
            case DocumentCategory::class:
                self::showForDocumentCategory($item, $withtemplate);
                break;
            default:
                self::showForitem($item, $withtemplate);
                break;
        }

    }

    public static function getMassiveActionsForItemtype(
        array &$actions,
        $itemtype,
        $is_deleted = 0,
        ?CommonDBTM $checkitem = null
    )
    {
        global $CFG_GLPI;


        $action_prefix = 'Contract_Item' . MassiveAction::CLASS_ACTION_SEPARATOR;
        $actions[$action_prefix . 'add'] = "<i class='fa-fw " . self::getIcon() . "'></i>" .
            _x('button', 'Add a contract');
        $actions[$action_prefix . 'remove'] = _x('button', 'Remove a contract');

    }


    static function showForItem(CommonDBTM $item, $withtemplate = 0, $canadd = true)
    {
        $id = $item->fields['id'];
        $canedit = $item->can($id, UPDATE); // canedit booleen = true
        $rand = mt_rand(1, mt_getrandmax());
        global $DB;

        $iterator = $DB->request(self::getRequest($item));
        $number = count($iterator); // $number est le nombre de ligne à afficher (=nombre de documents reliés)
        $used = [];


        foreach ($iterator as $data) {
            $used[$data["id"]] = $data["id"];
        }
//        form
        // echo "<div style='width: 100%; display: flex; justify-content: center; padding: 1rem;'><button data-itemtype='" . $item->getType() . "' data-id='" . $id . "' class='btn btn-primary btn-sm adddoc-btn'>Ajouter un document</button></div>";
        echo "<script>
            $('.adddoc-btn').off('click').click(function(e) {
       
               glpi_ajax_dialog({
                dialogclass: 'modal-lg',
                bs_focus: false,
                url: '/marketplace/dlteams/ajax/object_document_form.php',
                params: {
                    id: $(this).data('id'),
                    itemtype: $(this).data('itemtype'),
                },
                title: i18n.textdomain('dlteams').__('Lier un document', 'dlteams'),
                close: function () {

                },
                fail: function () {
                    displayAjaxMessageAfterRedirect();
                }
            });
            });
            
            </script>";

        echo "<table class='tab_cadre_fixe'>";
        echo "<tr class='tab_bg_1'><th>" . __('Documents liés') ;
        //echo "<div style='width: 100%; display: flex; justify-content: center; padding: 1rem;'><button data-itemtype='" . $item->getType() . "' data-id='" . $id . "' class='btn btn-primary btn-sm adddoc-btn'>Ajouter un document</button></div>";		
		echo " - "."<button data-itemtype='" . $item->getType() . "' data-id='" . $id . "' class='btn btn-primary btn-sm adddoc-btn'>Ajouter un document</button></div>";				
		echo "</th></tr>";
        echo "</table>";
        if ($iterator) {
            echo "<div class='spaced'>";
            if ($canedit && $number && $canadd) {
                Html::openMassiveActionsForm('mass' . Document_Item::class . $rand);
                $massive_action_params = ['container' => 'mass' . Document_Item::class . $rand,
                    'num_displayed' => min($_SESSION['glpilist_limit'], $number)];

                Html::showMassiveActions($massive_action_params);
            }
            echo "<div class='glpi-responsive-table'>";
            echo "<table class='tab_cadre_fixehov'>";

            $header_begin = "<tr>";
            $header_top = '';
            $header_bottom = '';
            $header_end = '';

            if ($canedit && $number && $canadd) {
                $header_begin .= "<th width='10'>";
                $header_top .= Html::getCheckAllAsCheckbox('mass' . Document_Item::class . $rand);
                $header_bottom .= Html::getCheckAllAsCheckbox('mass' . Document_Item::class . $rand);
                $header_end .= "</th>";
            }

            $header_end .= "<th>" . __("Name") . "</th>";
            $header_end .= "<th>" . __("Dossier") . "</th>";
            $header_end .= "<th style='white-space: nowrap; width: 12%'>" . __("Fichier courant") . "</th>";
            $header_end .= "<th style='width: 10%'>" . __("URL") . "</th>";

            $header_end .= "<th>" . __("Fichier HTML") . "</th>";
            $header_end .= "<th>" . __("Comment") . "</th>";
            $header_end .= "</tr>";

            echo $header_begin . $header_top . $header_end;

            //foreach ($items_list as $data) {
            // var_dump ($iterator);

            if (count($iterator) == 0) {
                echo "<tr class='tab_bg_1'>";
                echo "<td colspan='100' align='center'>";
                PluginDlteamsUtils::displayEmptyBox();
                echo "</td>";
                echo "</tr>";
            }
            foreach ($iterator as $data) {
                if ($data['name'] || $data['link']) {

                    echo "<tr class='tab_bg_1'>";

                    if ($canedit && $number && $canadd) {
                        echo "<td width='10'>";
                        Html::showMassiveActionCheckBox(Document_Item::class, $data['linkid']);
                        echo "</td>";
                    }
                    $link = $data['name'];
                    if ($_SESSION['glpiis_ids_visible'] || empty($data['name'])) {
                        $link = sprintf(__("%1\$s (%2\$s)"), $link, $data['id']);
                    }

                    $name = "<a target='_blank' href=\"" . static::$itemtype_2::getFormURLWithID($data['id']) . "\">" . $link . "</a>";
                    echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                    echo ">" . $name . "</td>";

                    echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'") . ">";
                    if ($data['folder']) {
                        echo $data['folder'];
                    } else {
                        echo "---";
                    }
                    echo "</td>";

                    echo "<td width='18%' class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                    echo ">";
                    if ($data['filename']) {
//                        echo "<a href='../../../front/document.send.php?docid=" . $data['id'] . "' target='_blank'>" . "voir" . "</a>";
                        $document = new Document();
                        $document->getFromDB($data["id"]);
                        echo $document->getDownloadLink(null, 25);
                    } else {
                        echo "---";
                    }
                    echo "</td>";

                    echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'") . ">";
                    if ($data['link']) {
                        echo "<a href='" . $data['link'] . "' target='_blank'>" . "voir" . "</a>";
                    } else {
                        echo "---";
                    }
                    echo "</td>";


                    echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'") . ">";
                    if ($data['htmlfile']) {
                        $deliverable = new PluginDlteamsDeliverable();
                        $deliverable->getFromDB($data["deliverables_id"]);

                        $url = Toolbox::getItemTypeFormURL("PluginDlteamsDeliverable")
                            . "?deliverable_id=" . $data["deliverables_id"] . "&report_type="
                            . PluginDlteamsPublish::REPORT_SINGLE_RECORD
                            . "&print_comments=" . $deliverable->fields["is_comment"]
                            . "&prevent_contextmenu=true"
                            . "&print_first_page=" . $deliverable->fields["is_firstpage"]
                            . "&edit_pdf=true";
                        echo "<div> <a target='_blank' href='" . $url . "' id='btn_publication_folder'>" . $data['htmlfile'] . "</a> </div>";
//                        echo $data['htmlfile'];
                    } else {
                        echo "---";
                    }
                    echo "</td>";


                    echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                    echo " width='20%'>";
                    if ($data['comment']) {
                        echo $data['comment'];
                    } else {
                        echo "---";
                    }
                    echo "</td>";

                    echo "</tr>";
                }
            }


            if ($iterator->count() > 10) {
                echo $header_begin . $header_bottom . $header_end;
            }
            echo "</table>";
            echo "</div>";

            if ($canedit && $number > 10 && $canadd) {
                $massive_action_params['ontop'] = false;
                Html::showMassiveActions($massive_action_params);
                Html::closeForm();
            }

            echo "</div>";
        }

//        responsive
        echo "<style>
            .glpi-responsive-table {
                  width: 100%;
                  overflow-x: auto;
                }
                
                .glpi-responsive-table table {
                  width: 100%;
                  border-collapse: collapse;
                  min-width: 600px; /* empêche la casse sur les petits écrans */
                }
                
                @media screen and (max-width: 768px) {
                  .tab_cadre_fixe th,
                  .tab_cadre_fixe td,
                  .tab_cadre_fixehov th,
                  .tab_cadre_fixehov td {
                    font-size: 14px;
                    padding: 8px;
                  }
                
                  .btn,
                  input[type='submit'] {
                    width: 100%;
                    margin-top: 8px;
                  }
                }
                
                .td-fixed-small {
                  width: 2%;
                }
                
                @media screen and (max-width: 768px) {
                  .td-fixed-small {
                    width: fit-content !important;
                    white-space: nowrap;
                  }
                }
        </style>";

    }

    static function showForDocumentCategory(CommonDBTM $item, $withtemplate = 0, $canadd = true)
    {
        $id = $item->fields['id'];
        $canedit = $item->can($id, UPDATE); // canedit booleen = true
        $rand = mt_rand(1, mt_getrandmax());
        global $DB;

        $iterator = $DB->request(self::getRequestDocumentCategory($item));
//        var_dump($iterator->getSql());
//        die();

        $number = count($iterator); // $number est le nombre de ligne à afficher (=nombre de documents reliés)
        $used = [];
        $maprocessor = __CLASS__;


        foreach ($iterator as $data) {
            $used[$data["id"]] = $data["id"];
        }


//        form

        echo "<div style='width: 100%; display: flex; justify-content: center; padding: 1rem;'><button data-itemtype='" . $item->getType() . "' data-id='" . $id . "' class='btn btn-primary btn-sm adddoc-btn'>Ajouter un document</button></div>";

        echo "<script>
            $('.adddoc-btn').off('click').click(function(e) {
                
               glpi_ajax_dialog({
                dialogclass: 'modal-lg',
                bs_focus: false,
                url: '/marketplace/dlteams/ajax/object_document_form.php',
                params: {
                    id: $(this).data('id'),
                    itemtype: $(this).data('itemtype'),
                },
                title: i18n.textdomain('dlteams').__('Lier un document', 'dlteams'),
                close: function () {

                },
                fail: function () {
                    displayAjaxMessageAfterRedirect();
                }
            });
            });
            
            </script>";


        echo "<table class='tab_cadre_fixe'>";
        echo "<tr class='tab_bg_1'><th>" . __('Documents liés') . "</th></tr>";
        echo "</table>";
        if ($iterator) {
            echo "<div class='spaced'>";
            if ($canedit && $number && $canadd) {
                Html::openMassiveActionsForm('mass' . $maprocessor . $rand);
                $massive_action_params = ['container' => 'mass' . $maprocessor . $rand,
                    'num_displayed' => min($_SESSION['glpilist_limit'], $number)];

                Html::showMassiveActions($massive_action_params);
            }
            echo "<div class='glpi-responsive-table'>";
            echo "<table class='tab_cadre_fixehov'>";

            $header_begin = "<tr>";
            $header_top = '';
            $header_bottom = '';
            $header_end = '';

            if ($canedit && $number && $canadd) {
                $header_begin .= "<th width='10'>";
                $header_top .= Html::getCheckAllAsCheckbox('mass' . $maprocessor . $rand);
                $header_bottom .= Html::getCheckAllAsCheckbox('mass' . $maprocessor . $rand);
                $header_end .= "</th>";
            }

            $header_end .= "<th>" . __("Name") . "</th>";
            $header_end .= "<th>" . __("Dossier") . "</th>";
            $header_end .= "<th style='white-space: nowrap; width: 12%'>" . __("Fichier courant") . "</th>";
            $header_end .= "<th style='width: 10%'>" . __("URL") . "</th>";

            $header_end .= "<th>" . __("Fichier HTML") . "</th>";
            $header_end .= "<th>" . __("Comment") . "</th>";
            $header_end .= "</tr>";

            echo $header_begin . $header_top . $header_end;

            //foreach ($items_list as $data) {
            // var_dump ($iterator);

            if (count($iterator) == 0) {
                echo "<tr class='tab_bg_1'>";
                echo "<td colspan='100' align='center'>";
                PluginDlteamsUtils::displayEmptyBox();
                echo "</td>";
                echo "</tr>";
            }
            foreach ($iterator as $data) {
                if ($data['name'] || $data['link']) {

                    echo "<tr class='tab_bg_1'>";

                    if ($canedit && $number && $canadd) {
                        echo "<td width='10'>";
                        Html::showMassiveActionCheckBox($maprocessor, $data['linkid']);
                        echo "</td>";
                    }
                    $link = $data['name'];
                    if ($_SESSION['glpiis_ids_visible'] || empty($data['name'])) {
                        $link = sprintf(__("%1\$s (%2\$s)"), $link, $data['id']);
                    }

                    $name = "<a target='_blank' href=\"" . static::$itemtype_2::getFormURLWithID($data['id']) . "\">" . $link . "</a>";
                    echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                    echo ">" . $name . "</td>";

                    echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'") . ">";
                    if ($data['folder']) {
                        echo $data['folder'];
                    } else {
                        echo "---";
                    }
                    echo "</td>";

                    echo "<td width='18%' class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                    echo ">";
                    if ($data['filename']) {
//                        echo "<a href='../../../front/document.send.php?docid=" . $data['id'] . "' target='_blank'>" . "voir" . "</a>";
                        $document = new Document();
                        $document->getFromDB($data["id"]);
                        echo $document->getDownloadLink(null, 25);
                    } else {
                        echo "---";
                    }
                    echo "</td>";

                    echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'") . ">";
                    if ($data['link']) {
                        echo "<a href='" . $data['link'] . "' target='_blank'>" . "voir" . "</a>";
                    } else {
                        echo "---";
                    }
                    echo "</td>";


                    echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'") . ">";
                    if ($data['htmlfile']) {
                        $deliverable = new PluginDlteamsDeliverable();
                        $deliverable->getFromDB($data["deliverables_id"]);

                        $url = Toolbox::getItemTypeFormURL("PluginDlteamsDeliverable")
                            . "?deliverable_id=" . $data["deliverables_id"] . "&report_type="
                            . PluginDlteamsPublish::REPORT_SINGLE_RECORD
                            . "&print_comments=" . $deliverable->fields["is_comment"]
                            . "&prevent_contextmenu=true"
                            . "&print_first_page=" . $deliverable->fields["is_firstpage"]
                            . "&edit_pdf=true";
                        echo "<div> <a target='_blank' href='" . $url . "' id='btn_publication_folder'>" . $data['htmlfile'] . "</a> </div>";
//                        echo $data['htmlfile'];
                    } else {
                        echo "---";
                    }
                    echo "</td>";


                    echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                    echo " width='20%'>";
                    if ($data['comment']) {
                        echo $data['comment'];
                    } else {
                        echo "---";
                    }
                    echo "</td>";

                    echo "</tr>";
                }
            }


            if ($iterator->count() > 10) {
                echo $header_begin . $header_bottom . $header_end;
            }
            echo "</table>";
            echo "</div>";

            if ($canedit && $number > 10 && $canadd) {
                $massive_action_params['ontop'] = false;
                Html::showMassiveActions($massive_action_params);
                Html::closeForm();
            }

            echo "</div>";
        }

//        responsive
        echo "<style>
            .glpi-responsive-table {
                  width: 100%;
                  overflow-x: auto;
                }
                
                .glpi-responsive-table table {
                  width: 100%;
                  border-collapse: collapse;
                  min-width: 600px; /* empêche la casse sur les petits écrans */
                }
                
                @media screen and (max-width: 768px) {
                  .tab_cadre_fixe th,
                  .tab_cadre_fixe td,
                  .tab_cadre_fixehov th,
                  .tab_cadre_fixehov td {
                    font-size: 14px;
                    padding: 8px;
                  }
                
                  .btn,
                  input[type='submit'] {
                    width: 100%;
                    margin-top: 8px;
                  }
                }
                
                .td-fixed-small {
                  width: 2%;
                }
                
                @media screen and (max-width: 768px) {
                  .td-fixed-small {
                    width: fit-content !important;
                    white-space: nowrap;
                  }
                }
        </style>";

    }

    /* Execute massive action for dlteams Plugin
     * @see CommonDBTM::processMassiveActionsForOneItemtype()
     */
    static function processMassiveActionsForOneItemtype(MassiveAction $ma, CommonDBTM $item, array $ids)
    {

//        var_dump($ma->getAction());
//        die();
        switch ($ma->getAction()) {
            case 'copyTo':
                if ($item->getType() == 'PluginDlteamsRecord') {
                    /** @var PluginDlteamsRecord $item */
                    foreach ($ids as $id) {
                        if ($item->getFromDB($id)) {
                            if ($item->copy($ma->POST['entities_id'], $id, $item)) {
                                Session::addMessageAfterRedirect(sprintf(__('Record copied: %s', 'dlteams'), $item->getName()));
                                $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_OK);
                            }
                        } else {
                            // Example of ko count
                            $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_KO);
                        }
                    }
                }
                return;
            case 'delete_dlteams_action':
                foreach ($ids as $id) {
                    $document = new Document();
                    if($document->getFromDB($id)){
                        $document->update([
                           "documentcategories_id" => 0,
                           "id" => $id
                        ]);
                    }
                }
                $ma->itemDone(__CLASS__, $id, MassiveAction::ACTION_OK);
                break;
        }
        parent::processMassiveActionsForOneItemtype($ma, $item, $ids);
    }

    function getSpecificMassiveActions($checkitem = NULL)
    {
        $actions = parent::getSpecificMassiveActions($checkitem);

        // add a single massive action
        $class = __CLASS__;

//        $action_key = "update_dlteams_action";
//        $action_label = __("Update dlteams relations", "dlteams");
//        $actions[$class . MassiveAction::CLASS_ACTION_SEPARATOR . $action_key] = $action_label;

        $action_key = "delete_dlteams_action";
        $action_label = _n("Delete dlteams relation", "Delete dlteams relations", 0, "dlteams");
        $actions[$class . MassiveAction::CLASS_ACTION_SEPARATOR . $action_key] = $action_label;

        return $actions;
    }


    function rawSearchOptions()
    {

        $tab = [];

        $tab[] = [
            'id' => '31',
            'table' => Document::getTable(),
            'field' => 'name',
            'name' => __("Nom du document"),
            'forcegroupby' => true,
            'massiveaction' => false,
            'datatype' => 'dropdown',
            'searchtype' => ['equals', 'notequals'],
            'joinparams' => [
                'beforejoin' => [
                    'table' => self::getTable(),
                    'joinparams' => [
                        'jointype' => 'child'
                    ]
                ]
            ]
        ];

        $tab[] = [
            'id' => '32',
            'table' => Document::getTable(),
            'field' => 'comment',
            'name' => __("Commentaire"),
            'forcegroupby' => true,
            'massiveaction' => true,
            'datatype' => 'text',
            'searchtype' => ['equals', 'notequals'],
            'joinparams' => [
                'beforejoin' => [
                    'table' => self::getTable(),
                    'joinparams' => [
                        'jointype' => 'child'
                    ]
                ]
            ]
        ];

        return $tab;
    }

    public function cleanDBonPurge()
    {
        $this->deleteChildrenAndRelationsFromDb(
            [
                Appliance_Item_Relation::class,
            ]
        );
    }


    static function getRequest($record)
    {
        return [
            'SELECT' => [
                'glpi_documents_items.id AS linkid',
                'glpi_documents.id AS id',
                'glpi_documents.name AS name',
                'glpi_documents.deliverables_id AS deliverables_id',
                DocumentCategory::getTable() . '.name AS folder',
                PluginDlteamsDeliverable::getTable() . '.name AS htmlfile',
                'glpi_documents.filename AS filename',
                'glpi_documents.link AS link',
                'glpi_documents_items.comment AS comment',

            ],
            'FROM' => 'glpi_documents_items',
            'LEFT JOIN' => [
                'glpi_documents' => [
                    'FKEY' => [
                        'glpi_documents_items' => "documents_id",
                        'glpi_documents' => "id",
                    ]
                ],
                DocumentCategory::getTable() => [
                    'FKEY' => [
                        DocumentCategory::getTable() => "id",
                        'glpi_documents' => "documentcategories_id",
                    ]
                ],
                PluginDlteamsDeliverable::getTable() => [
                    'FKEY' => [
                        PluginDlteamsDeliverable::getTable() => "id",
                        'glpi_documents' => "deliverables_id",
                    ]
                ],

            ],

            'ORDER' => [
                'name ASC'
                //'contenu ASC'
            ],
            'WHERE' => [
                'glpi_documents_items.items_id' => $record->fields['id'],
                'glpi_documents_items.itemtype' => $record->getType()
            ]
        ];
    }

    static function getRequestDocumentCategory($record)
    {
        return [
            'SELECT' => [
                'glpi_documents.id AS id',
                'glpi_documents.id AS linkid',
                'glpi_documents.name AS name',
                'glpi_documents.deliverables_id AS deliverables_id',
                DocumentCategory::getTable() . '.name AS folder',
                PluginDlteamsDeliverable::getTable() . '.name AS htmlfile',
                'glpi_documents.filename AS filename',
                'glpi_documents.link AS link',
                'glpi_documents.comment AS comment',

            ],
            'FROM' => 'glpi_documents',
            'LEFT JOIN' => [
                DocumentCategory::getTable() => [
                    'FKEY' => [
                        DocumentCategory::getTable() => "id",
                        'glpi_documents' => "documentcategories_id",
                    ]
                ],
                PluginDlteamsDeliverable::getTable() => [
                    'FKEY' => [
                        PluginDlteamsDeliverable::getTable() => "id",
                        'glpi_documents' => "deliverables_id",
                    ]
                ],

            ],
            'ORDER' => [
                'name ASC'
                //'contenu ASC'
            ],
            'WHERE' => [
                'glpi_documents.documentcategories_id' => $record->fields['id'],
//                'glpi_documents_items.itemtype' => $record->getType()
            ]
        ];
    }


    public function getForbiddenStandardMassiveAction()
    {
        $forbidden = parent::getForbiddenStandardMassiveAction();
        $forbidden[] = 'clone';
        $forbidden[] = 'MassiveAction:update';
        $forbidden[] = 'MassiveAction:purge';
        $forbidden[] = 'MassiveAction:add_transfer_list';
        $forbidden[] = 'MassiveAction:amend_comment';
        return $forbidden;
    }
}
