<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

class PluginDlteamsPolicieFormCategory extends CommonDropdown {
    static $rightname = 'plugin_dlteams_policieformcategrory';
    public $dohistory = true;
    protected $usenotepad = true;


    static function getTypeName($nb = 0) {
        return _n("Catégorie de jeux de données", "Catégories de jeux de données", $nb, 'dlteams');
    }

    public static function getFieldLabel()
    {
        return _n('Type', 'Types', 1);
    }

    function prepareInputForAdd($input) {
        $input['users_id_creator'] = Session::getLoginUserID();

        if (array_key_exists('decimalnumber', $input) && array_key_exists('number', $input)) {
            $input["completenumber"] = $input["number"] + $input["decimalnumber"] / 100;
        }
        return parent::prepareInputForAdd($input);
    }

    function prepareInputForUpdate($input) {
        $input['users_id_lastupdater'] = Session::getLoginUserID();

        if (array_key_exists('decimalnumber', $input) && array_key_exists('number', $input)) {
            $input["completenumber"] = $input["number"] + $input["decimalnumber"] / 100;
        }

        return parent::prepareInputForUpdate($input);
    }

//    function cleanDBonPurge() {
//        $rel = new PluginDlteamsRecord_StorageEndAction();
//        $rel->deleteByCriteria(['plugin_dlteams_rightmeasurecategories_id' => $this->fields['id']]);
//    }

    function rawSearchOptions() {

        $tab = [];

        $tab[] = [
            'id'                 => 'common',
            'name'               => __("Characteristics")
        ];

        $tab[] = [
            'id'                 => '1',
            'table'              => $this->getTable(),
            'field'              => 'name',
            'name'               => __("Name"),
            'datatype'           => 'itemlink',
            'massiveaction'      => false,
            'autocomplete'       => true,
        ];

        $tab[] = [
            'id'                 => '2',
            'table'              => $this->getTable(),
            'field'              => 'id',
            'name'               => __("ID"),
            'massiveaction'      => false,
            'datatype'           => 'number',
        ];

        $tab[] = [
            'id'                 => '3',
            'table'              => $this->getTable(),
            'field'              => 'comment',
            'name'               => __("Comments"),
            'datatype'           => 'text',
            'toview'             => true,
            'massiveaction'      => true,
        ];

        $tab[] = [
            'id'                 => '4',
            'table'              => 'glpi_entities',
            'field'              => 'completename',
            'name'               => __("Entity"),
            'datatype'           => 'dropdown',
            'massiveaction'      => true,
        ];

        $tab[] = [
            'id'                 => '5',
            'table'              => $this->getTable(),
            'field'              => 'is_recursive',
            'name'               => __("Child entities"),
            'datatype'           => 'bool',
            'massiveaction'      => false,
        ];

        return $tab;
    }


    function showForm($id, $options = [])
    {

//        \Glpi\Application\View\TemplateRenderer::getInstance()->display('@dlteams/components/form/recordform.html.twig', [
//            ]
//        );

        global $CFG_GLPI;
        $this->initForm($id, $options);
        $this->showFormHeader($options);


        echo "<style>";
        echo "
            .form-table-text {
                text-align: right;
                width: 40%;
            }
            @media (max-width: 800px) {
                .form-table-text {
                    text-align: left;
                    width: 100%;
                }
            }
        ";


        echo "</style>";
        echo "<tr class='tab_bg_1'>";
        echo "<td class='form-table-text'>" . __("Number (order)", 'dlteams') . "</td>";
        echo "<td colspan='1'>";
        $number = Html::cleanInputText($this->fields['number']);
        echo "<input type='number' min='1' max='9999' name='number' size='8' required value='" . $number . "'>";
        $number = Html::cleanInputText($this->fields['decimalnumber']);
        if ($id == 0) $number = 1;
        echo "<input type='number' min='0' max='9999' id='decimalnumber' name='decimalnumber' size='8' required value='" . $number . "'>";
        echo "</td></tr>";

        echo "<tr class='tab_bg_1'>";
        echo "<td class='form-table-text'>" . __("Name") .
            "</td>";
        echo "<td colspan='2'>";
        $name = Html::cleanInputText($this->fields['name']);

        // on affiche un warning (texte en rouge) en dessous de designation du traitement "En publication, seule la désignation sera affichée"
        echo "<input type='text' style='width:98%' maxlength=250 name='name' required value='" . $name . "'>";

        echo "</td></tr>";
//
        echo "<tr class='tab_bg_1'>";
        echo "<td class='form-table-text'>" . __("Content") .
            "</td>";

        echo "<td colspan='2' >";
        $content = Html::cleanInputText($this->fields['content']);
        echo "<textarea style='width:98%' name='content' maxlength='2000' rows='7'>" . $content . "</textarea>";
        echo "</td></tr>";



        echo "<tr class='tab_bg_1'>";
        echo "<td class='form-table-text'>" . __("Comment") .
            "</td>";

        echo "<td colspan='2' >";
        $comment = Html::cleanInputText($this->fields['comment']);
        echo "<textarea style='width:98%' name='comment' maxlength='2000' rows='7'>" . $comment . "</textarea>";
        echo "</td></tr>";


        $this->showFormButtons($options);


        return true;
    }




    public function defineTabs($options = [])
    {
        $ong = [];
        $ong = array();
        $this->addDefaultFormTab($ong)
            ->addStandardTab(PluginDlteamsPolicieForm_Item::class, $ong, $options)
            ->addStandardTab('Notepad', $ong, $options)
            ->addStandardTab('Log', $ong, $options);
        return $ong;
    }


}
