<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */


use GlpiPlugin\dlteams\Exception\ImportFailureException;

class PluginDlteamsProject_Ma extends CommonDBTM {

    static public $itemtype_2 = 'PluginDlteamsDataCatalog';

    static function canCreate()
    {
        return true;
    }

    static function canView()
    {
        return true;
    }
//
    static function canUpdate()
    {
        return true;
    }

    static function canDelete()
    {
        return true;
    }

    static function canPurge()
    {
        return true;
    }

    function canCreateItem()
    {
        return true;
    }

    function canViewItem()
    {
        return true;
    }

    function canUpdateItem()
    {
        return true;
    }

    function canDeleteItem()
    {
        return true;
    }

    function canPurgeItem()
    {
        return true;
    }


    public static function getTable($classname = null)
    {
        return PluginDlteamsDataCatalog::getTable(); // TODO: Change the autogenerated stub
    }

    public function rawSearchOptions()
    {
        return parent::rawSearchOptions(); // TODO: Change the autogenerated stub
    }


    public function getForbiddenStandardMassiveAction()
    {
        $forbidden = parent::getForbiddenStandardMassiveAction();
        $forbidden[] = 'clone';
        $forbidden[] = 'MassiveAction:add_transfer_list';
        $forbidden[] = 'MassiveAction:amend_comment';
        $forbidden[] = 'MassiveAction:update';
        return $forbidden;
    }

    public function getSpecificMassiveActions($checkitem = NULL)
    {
        $actions = parent::getSpecificMassiveActions($checkitem);
        // add a single massive action
        $class = __CLASS__;
        $action_key = "delete_dlteams_action";
        $action_label = _n("Supprimer", "Supprimer", 0, "dlteams");

        $actions[$class . MassiveAction::CLASS_ACTION_SEPARATOR . $action_key] = $action_label;

        return $actions;
    }

    public static function showMassiveActionsSubForm(MassiveAction $ma)
    {
        switch ($ma->getAction()) {
            case 'copyTo':
               //                $values = [];
//                foreach ($_SESSION["glpiactiveentities"] ?? [] as $key => $entities_id) {
//                    $entity = new Entity();
//                    $entity->getFromDB($entities_id);
//                    $values[$key] = $entity->fields["completename"];
//                }
                Entity::dropdown(['name' => 'entities_id']);
                echo '<br /><br />' . Html::submit(_x('button', 'Post'), ['name' => 'massiveaction']);
                return true;
        }
        return parent::showMassiveActionsSubForm($ma);
    }



    public static function processMassiveActionsForOneItemtype(MassiveAction $ma, CommonDBTM $item, array $ids)
    {

        switch ($ma->getAction()){
            case 'copyTo':
/*                highlight_string("<?php\n\$data =\n" . var_export($ma->POST, true) . ";\n?>");*/
//                die();
                foreach ($ids as $id){
                    if ($item->getFromDB($id)) {
                        if (static::copy1($ma->POST['entities_id'], $id, $item)) {

                            Session::addMessageAfterRedirect(sprintf(__('%s copied: %s', 'dlteams'), $item->getTypeName(), $item->getName()));
                            $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_OK);
                        }
                    } else {
                        // Example of ko count
                        $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_KO);
                    }
                }
                $ma->itemDone(__CLASS__, $id, MassiveAction::ACTION_OK);
                return true;
                break;
        }
        parent::processMassiveActionsForOneItemtype($ma, $item, $ids); // TODO: Change the autogenerated stub
    }

    public static function copy1($entity, $id, $item)
    {
        global $DB;

        try {
            $DB->beginTransaction();

            $dbu = new DbUtils();
            $name = $item->fields['name'];

            $nb = $dbu->countElementsInTable($item->getTable(), [
                'name'        => addslashes($name),
                'entities_id' => $entity
            ]);

            $pj = new Project();
            $pj->getFromDB($id);

            if ($nb <= 0) {
                // Copier le projet
                $project = new Project();
                $project->add([
                    "name"        => addslashes($pj->fields["name"]),
                    "content"     => addslashes($pj->fields["content"]),
                    "comment"     => addslashes($pj->fields["comment"]),
                    "entities_id" => $entity,
                ]);

                $newid = $project->fields["id"];

                // Copier les tâches du projet
                $projectTask = new ProjectTask();
                $tasks = $projectTask->find(['projects_id' => $id, 'entities_id' => $pj->fields["entities_id"]]);

                // Tableau pour mapper les anciens et nouveaux IDs des tâches
                $taskIdMapping = [];


                foreach ($tasks as $taskData) {
                    $oldTaskId = $taskData['id'];

                    // Préparer les données pour la nouvelle tâche
                    $taskData['projects_id'] = $newid; // Associer la tâche au nouveau projet
                    unset($taskData['id']); // Supprimer l'ID pour permettre l'insertion
                    $taskData["uuid"] = plugin_dlteams_getUuid();

                    // Créer la nouvelle tâche
                    $newTask = new ProjectTask();
                    $r = $newTask->add($taskData);


                    // Stocker le mapping des IDs
                    $taskIdMapping[$oldTaskId] = $newTask->fields['id'];
                }

                // Copier les tickets liés aux tâches
                $projectTaskTicket = new ProjectTask_Ticket();

                foreach ($taskIdMapping as $oldTaskId => $newTaskId) {
                    // Récupérer les tickets liés à l'ancienne tâche
                    $tickets = $projectTaskTicket->find(['projecttasks_id' => $oldTaskId]);

                    foreach ($tickets as $ticketData) {
                        // Préparer les données pour la nouvelle liaison
                        $ticketData['projecttasks_id'] = $newTaskId; // Associer au nouveau projecttask
                        unset($ticketData['id']); // Supprimer l'ID pour permettre l'insertion

                        // Créer la nouvelle liaison
                        $newTicketLink = new ProjectTask_Ticket();
                        $newTicketLink->add($ticketData);
                    }
                }
            }

            $DB->commit();
        } catch (Exception $e) {
            $DB->rollBack();
            // Gérer l'erreur (par exemple, journalisation)
            $message = "Erreur : " . $e->getMessage();
            Session::addMessageAfterRedirect("Une erreur s'est produite");
            return false;
        }
    }



}
