<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */


use GlpiPlugin\dlteams\Exception\ImportFailureException;

class PluginDlteamsProtectiveMeasure_Stats extends CommonDBTM
{

    static public $itemtype_2 = PluginDlteamsProtectiveMeasure::class;
    static public $itemtype_1;
    public static $items_id_1;
    public static $title;
    public static $sub_title;
    public static $table_match_str = [];

    static function canCreate()
    {
        return true;
    }

    static function canView()
    {
        return true;
    }

    static function canUpdate()
    {
        return true;
    }

    static function canDelete()
    {
        return true;
    }

    static function canPurge()
    {
        return true;
    }

    function canCreateItem()
    {
        return true;
    }

    function canViewItem()
    {
        return true;
    }

    function canUpdateItem()
    {
        return true;
    }

    function canDeleteItem()
    {
        return true;
    }

    function canPurgeItem()
    {
        return true;
    }


    static function getTypeNameForClass($nb = 0)
    {
        return __("Statistiques", 'dlteams');
    }

    // affichage de l'onglet et de son nom
    public function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {

        switch ($item->getType()) {
            case static::$itemtype_2:
                $ong = [];
                if (!$withtemplate) {
                    if (Session::haveRight($item::$rightname, READ)) {
                        // tab name utilisateurs effectifs
                        if ($_SESSION['glpishow_count_on_tabs']) {
                            $ong[] = static::createTabEntry(static::getTypeNameForClass(), 0);
                        } else {
                            $ong[] = static::getTypeNameForClass();
                        }
                    }
                }

                return $ong;
                break;
            default:
                return [];
        }

        return '';
    }


    public static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {
        switch ($item->getType()) {
            case static::$itemtype_2:
                self::showStatsForProtectiveMeasure($item);

                break;
        }
    }

    public static function showStatsForProtectiveMeasure(CommonDBTM $item)
    {
        // === 1. RÉCUPÉRATION DES DONNÉES ===
        $completenumber = $item->fields["completenumber"];
        $parties = explode('.', $completenumber);
        $parentnumber = $parties[0];

        $query = [
            "FROM"    => PluginDlteamsRecord::getTable(),
            "WHERE"   => [
                "entities_id"    => Session::getActiveEntity(),
                "completenumber" => ["LIKE", "$parentnumber.%"],
                "id"             => ["!=", $item->fields["id"]]
            ],
            "ORDERBY" => ["parentnumber"]
        ];

        global $DB;
        $iterator = $DB->request($query);
        $records = iterator_to_array($iterator);

        // === 2. AFFICHAGE HTML ET CSS ===
        echo '<style>
        .conformity-table { border-collapse: collapse; width: 100%; font-family: Arial, sans-serif; border: 2px solid #00b050; }
        .conformity-table th, .conformity-table td { border: 1px solid #c0c0c0; padding: 8px; text-align: left; }
        .conformity-table thead th { background-color: #e2efda; text-align: center; font-weight: bold; }
        .conformity-table .main-header { background-color: #00b050; color: white; font-size: 1.2em; }
        .conformity-table .row-header { font-weight: bold; background-color: #f2f2f2; }
        /* ... autres styles ... */
    </style>';

        echo '<table class="conformity-table">';
        echo '<thead>';
        echo '    <tr><th class="main-header" colspan="' . (count($records) + 1) . '">' . Html::entities_deep($item->fields["name"]) . '</th></tr>';
        echo '    <tr><th>Éléments descriptif / Traitements</th>';
        foreach ($records as $record) {
            echo '<th>';
            $text = (string)($record['completenumber'] . ' - ' . $record['name']);
            $limit = 15;
            $full  = Html::entities_deep($text);
            $short = Html::entities_deep(mb_substr($text, 0, $limit, 'UTF-8'));
            $url = PluginDlteamsRecord::getFormURLWithID($record["id"]);
            if (mb_strlen($text, 'UTF-8') > $limit) {

                echo '<span><a href="'.$url.'">' . $short . '&hellip;</a></span> ';
                Html::showToolTip($full);
            } else {
                echo '<span> <a href="'.$url.'">' . $full . '</a></span>';
            }
            echo '</th>';
        }
        echo '</tr></thead>';
        echo '<tbody>';

        // === 3. LIGNES DU TABLEAU (STRUCTURE ORIGINALE) ===

        echo '<tr><td class="row-header">Finalités indiquées</td>';
        foreach ($records as &$record) {
            if (empty($record["r_purposes"])) self::updateRecordStats($record, 'purposes');
            echo '<td>' . (empty($record["r_purposes"]) ? "Non" : "Oui") . '</td>';
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Responsable de traitement, auditeur</td>';
        foreach ($records as &$record) {
            if (empty($record['r_nbrcontroller'])) self::updateRecordStats($record, 'nbrcontroller');
            echo "<td>{$record['r_nbrcontroller']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Base légales</td>';
        foreach ($records as &$record) {
            if (empty($record['r_legalbasis'])) self::updateRecordStats($record, 'legalbasis');
            echo "<td>{$record['r_legalbasis']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Catégories de personnes concernées</td>';
        foreach ($records as &$record) {
            if (empty($record["r_concernedpersons"])) self::updateRecordStats($record, 'concernedpersons');
            echo "<td>{$record['r_concernedpersons']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Données traitées</td>';
        foreach ($records as &$record) {
            if (empty($record["r_processeddatas"])) self::updateRecordStats($record, 'processeddatas');
            echo "<td>{$record['r_processeddatas']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Durées légales de conservation / Indication des pro</td>';
        foreach ($records as &$record) {
            if (empty($record["r_storageperiod"])) self::updateRecordStats($record, 'storageperiod');
            echo "<td>{$record['r_storageperiod']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Acteurs et sous-traitants</td>';
        foreach ($records as &$record) {
            if (empty($record['r_actors'])) self::updateRecordStats($record, 'actors');
            echo "<td>{$record['r_actors']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Destinataires</td>';
        foreach ($records as &$record) {
            if (empty($record["r_recipients"])) self::updateRecordStats($record, 'recipients');
            echo "<td>{$record['r_recipients']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Mesures pour les droits</td>';
        foreach ($records as &$record) {
            if (empty($record["r_rightmeasures"])) self::updateRecordStats($record, 'rightmeasures');
            echo "<td>{$record['r_rightmeasures']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">SI consentement, méthode + lieu de stockage</td>';
        foreach ($records as &$record) {
            if (empty($record["r_consentexplicit"])) self::updateRecordStats($record, 'consentexplicit');
            echo "<td>{$record['r_consentexplicit']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">SI pas de consentement, justification</td>';
        foreach ($records as &$record) {
            if (empty($record["r_consentjustif"])) self::updateRecordStats($record, 'consentjustif');
            echo "<td>{$record['r_consentjustif']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Nombre de personnes concernées</td>';
        foreach ($records as &$record) {
            if (empty($record['r_nbr_concernedpersons'])) self::updateRecordStats($record, 'nbr_concernedpersons');
            echo "<td>{$record['r_nbr_concernedpersons']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Plus grande vulnérabilité des personnes concernées</td>';
        foreach ($records as &$record) {
            if (empty($record["r_maxvulnerability"])) self::updateRecordStats($record, 'maxvulnerability');
            echo "<td>{$record['r_maxvulnerability']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Nombre de données sensibles / vues comme sensible</td>';
        foreach ($records as $record) { // Pas de '&' car pas de modification
            echo "<td>{$record['r_nbr_sensitivedatas']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Traitement permettant un profilage</td>';
        foreach ($records as &$record) {
            if (empty($record["r_profiling"])) self::updateRecordStats($record, 'profiling');
            echo "<td>{$record['r_profiling']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Localisation acteurs sous-traitants hors UE</td>';
        foreach ($records as &$record) {
            if (empty($record['r_subcontractoroutue'])) self::updateRecordStats($record, 'subcontractoroutue');
            echo "<td>{$record['r_subcontractoroutue']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Transfert de données hors UE / info & consentement</td>';
        foreach ($records as $record) {
            echo "<td>{$record['r_storageoutue']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Impacts (pour les personnes / l\'organisme)</td>';
        foreach ($records as &$record) {
            if (empty($record['r_averageimpacts'])) self::updateRecordStats($record, 'averageimpacts');
            echo "<td>{$record['r_averageimpacts']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Sensibilité du traitement</td>';
        foreach ($records as $record) {
            echo "<td>{$record['r_treatmentsensitivity']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">PIA nécessaire / effectué</td>';
        foreach ($records as $record) {
            echo "<td>{$record['r_pianeedanddone']}</td>";
        }
        echo '</tr>';

        // Séparateur
        echo '<tr><td class="row-header" style="border-bottom: 2px solid #00b050;">&nbsp;</td>';
        foreach ($records as $record) {
            echo '<td style="border-bottom: 2px solid #00b050;"></td>';
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Jeux de données</td>';
        foreach ($records as &$record) {
            if (empty($record["r_nbrpolicieform"])) self::updateRecordStats($record, 'nbrpolicieform');
            echo "<td>{$record['r_nbrpolicieform']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Mesures de protection (jeux de données)</td>';
        foreach ($records as &$record) {
            if (empty($record["r_pmpolicieform"])) self::updateRecordStats($record, 'pmpolicieform');
            echo "<td>{$record['r_pmpolicieform']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Catalogues</td>';
        foreach ($records as &$record) {
            if (empty($record["r_nbrdatacatalog"])) self::updateRecordStats($record, 'nbrdatacatalog');
            echo "<td>{$record['r_nbrdatacatalog']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Mesures de protection (catalogues)</td>';
        foreach ($records as &$record) {
            if (empty($record["r_pmdatacatalog"])) self::updateRecordStats($record, 'pmdatacatalog');
            echo "<td>{$record['r_pmdatacatalog']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Stockage des données renseigné</td>';
        foreach ($records as &$record) {
            if (empty($record["r_nbrstorage"])) self::updateRecordStats($record, 'nbrstorage');
            echo "<td>{$record['r_nbrstorage']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Localisation des stockages</td>';
        foreach ($records as $record) {
            echo "<td>{$record['r_nbrestorageloc']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Mesures de protection (matériels)</td>';
        foreach ($records as $record) {
            echo "<td>{$record['r_pmmateriel']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Mesures de protection (locaux)</td>';
        foreach ($records as $record) {
            echo "<td>{$record['r_pmlocation']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Catalogues annuaire</td>';
        foreach ($records as &$record) {
            if (empty($record["r_addatacatalog"])) self::updateRecordStats($record, 'addatacatalog');
            echo "<td>{$record['r_addatacatalog']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Comptes ayant accès</td>';
        foreach ($records as &$record) {
            if (empty($record["r_nbraccountandkey"])) self::updateRecordStats($record, 'nbraccountandkey');
            echo "<td>{$record['r_nbraccountandkey']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Utilisateurs ayant accès</td>';
        foreach ($records as &$record) {
            if (empty($record["r_nbrusers"])) self::updateRecordStats($record, 'nbrusers');
            echo "<td>{$record['r_nbrusers']}</td>";
        }
        echo '</tr>';

        echo '<tr><td class="row-header">Non-conformités relevées / résolues</td>';
        foreach ($records as $record) {
            echo "<td>{$record['r_noncompliance']}</td>";
        }
        echo '</tr>';

        echo '<tr style="border-bottom: 2px solid #00b050;"><td class="row-header">Note de conformité (1 à 4)</td>';
        foreach ($records as $record) {
            // La logique pour déterminer la classe CSS (couleur) irait ici
            echo '<td class="status-light-green">à améliorer</td>';
        }
        echo '</tr>';

        echo '</tbody></table>';

        // Supprimer la référence après la dernière boucle pour éviter les effets de bord
        unset($record);
    }




    /**
     * Calcule et met à jour les champs statistiques pour un enregistrement donné.
     *
     * @param array    &$record    L'enregistrement à mettre à jour (passé par référence).
     * @param string|null $operation  Le nom de l'opération de mise à jour à effectuer.
     * Si null, toutes les opérations sont effectuées.
     */
    public static function updateStats(array &$protectivemeasure, ?string $operation = null)
    {
        global $DB;
        $runAll = ($operation === null);

        switch ($operation) {

            case 'r_nbrpolicieform':
                if (empty($protectivemeasure['r_nbrpolicieform'])) {
                    $p = new PluginDlteamsProtectiveMeasure();
                    $p->getFromDB($protectivemeasure['id']);
                    $nb = PluginDlteamsPolicieForm_Item::countForItem($p);
                    $DB->update(PluginDlteamsProtectiveMeasure::getTable(), ["r_nbrpolicieform" => $nb], ["id" => $protectivemeasure['id']]);
                    $protectivemeasure['r_nbrpolicieform'] = $nb;
                }
                if (!$runAll) break;
                if (empty($protectivemeasure['r_nbrdatacatalog'])) {
                    $p = new PluginDlteamsProtectiveMeasure();
                    $p->getFromDB($protectivemeasure['id']);
                    $nb = PluginDlteamsDataCatalog_Item::countForItem($p);
                    $DB->update(PluginDlteamsProtectiveMeasure::getTable(), ["r_nbrdatacatalog" => $nb], ["id" => $protectivemeasure['id']]);
                    $protectivemeasure['r_nbrdatacatalog'] = $nb;
                }
                if (!$runAll) break;
                if (empty($protectivemeasure['r_nbrstorage'])) {
                    $p = new PluginDlteamsProtectiveMeasure();
                    $p->getFromDB($protectivemeasure['id']);
                    $nb = count(PluginDlteamsProtectiveMeasureStorage_Item::getItemsRequest($p));
                    $DB->update(PluginDlteamsProtectiveMeasure::getTable(), ["r_nbrstorage" => $nb], ["id" => $protectivemeasure['id']]);
                    $protectivemeasure['r_nbrstorage'] = $nb;
                }
                if (!$runAll) break;


        }
    }

}