<?php

class PluginDlteamsToolbox
{
    /**
     * Return a list of GLPI itemtypes.
     * These itemtypes will be available to attach fields containers on them,
     * and will be usable in dropdown / glpi_item fields.
     *
     * @return array
     */
    public static function getGlpiItemtypes(): array
    {
        global $CFG_GLPI, $PLUGIN_HOOKS;

        $assets_itemtypes = [
            Computer::class,
            Monitor::class,
            Software::class,
            NetworkEquipment::class,
            Peripheral::class,
            Printer::class,
            CartridgeItem::class,
            ConsumableItem::class,
            Phone::class,
            Rack::class,
            Enclosure::class,
            PDU::class,
            PassiveDCEquipment::class,
            Cable::class,
            Glpi\Socket::class,
        ];

        $actifs_itemtypes = [
            PluginDlteamsPhysicalStorage::class,
            PluginDlteamsAccessOpening::class,
        ];

        $rgpd_itemtypes = [
            PluginDlteamsRecord::class,
            PluginDlteamsPolicieForm::class,
            PluginDlteamsDataCatalog::class,
            PluginDlteamsAccountKey::class
        ];


        $management_itemtypes = [
            Datacenter::class,
            Appliance::class,
            Database::class,
            DatabaseInstance::class,
        ];


        $all_itemtypes = [
                _n('Asset', 'Assets', Session::getPluralNumber())         => $assets_itemtypes,
                __('Actifs')                                              => $actifs_itemtypes,
                __('Management')                                          => $management_itemtypes,
                __('RGPD')                                                => $rgpd_itemtypes,
            ];

        $plugin = new Plugin();
        if ($plugin->isActivated('genericobject') && method_exists('PluginGenericobjectType', 'getTypes')) {
            $go_itemtypes = [];
            foreach (array_keys(PluginGenericobjectType::getTypes()) as $go_itemtype) {
                if (!class_exists($go_itemtype)) {
                    continue;
                }
                $go_itemtypes[] = $go_itemtype;
            }
            if (count($go_itemtypes) > 0) {
                $all_itemtypes[$plugin->getInfo('genericobject', 'name')] = $go_itemtypes;
            }
        }

        $plugins_names = [];
        foreach ($all_itemtypes as $section => $itemtypes) {
            $named_itemtypes = [];
            foreach ($itemtypes as $itemtype) {
                $prefix = '';
                if ($itemtype_specs = isPluginItemType($itemtype)) {
                    $plugin_key = $itemtype_specs['plugin'];
                    if (!array_key_exists($plugin_key, $plugins_names)) {
                        $plugins_names[$plugin_key] = Plugin::getInfo($plugin_key, 'name');
                    }
                    $prefix = $plugins_names[$plugin_key] . ' - ';
                }

                $named_itemtypes[$itemtype] = $prefix . $itemtype::getTypeName(Session::getPluralNumber());
            }
            $all_itemtypes[$section] = $named_itemtypes;
        }

        // Remove empty lists (e.g. Plugin list).
        $all_itemtypes = array_filter($all_itemtypes);

        return $all_itemtypes;
    }



    /**
     * Make a good string from the unix timestamp $sec
     *
     * @param int|float  $time         timestamp
     * @param boolean    $display_sec  display seconds ?
     * @param boolean    $use_days     use days for display ?
     *
     * @return string
     **/
    public static function timestampToString($time, $display_sec = true, $use_days = true)
    {

        $time = (float)$time;

        $sign = '';
        if ($time < 0) {
            $sign = '- ';
            $time = abs($time);
        }
        $time = floor($time);

        // Force display seconds if time is null
        if ($time < MINUTE_TIMESTAMP) {
            $display_sec = true;
        }

        $units = Toolbox::getTimestampTimeUnits($time);
        if ($use_days) {
            if ($units['day'] > 0) {
                if ($display_sec) {
                    //TRANS: %1$s is the sign (-or empty), %2$d number of days, %3$d number of hours,
                    //       %4$d number of minutes, %5$d number of seconds
                    return sprintf(
                        __('%1$s%2$d j %3$d h %4$d min %5$d seconds'),
                        $sign,
                        $units['day'],
                        $units['hour'],
                        $units['minute'],
                        $units['second']
                    );
                }
                //TRANS:  %1$s is the sign (-or empty), %2$d number of days, %3$d number of hours,
                //        %4$d number of minutes
                return sprintf(
                    __('%1$s%2$d days %3$d h %4$d min'),
                    $sign,
                    $units['day'],
                    $units['hour'],
                    $units['minute']
                );
            }
        } else {
            if ($units['day'] > 0) {
                $units['hour'] += 24 * $units['day'];
            }
        }

        if ($units['hour'] > 0) {
            if ($display_sec) {
                //TRANS:  %1$s is the sign (-or empty), %2$d number of hours, %3$d number of minutes,
                //        %4$d number of seconds
                return sprintf(
                    __('%1$s%2$d h %3$d min %4$d s'),
                    $sign,
                    $units['hour'],
                    $units['minute'],
                    $units['second']
                );
            }
            //TRANS: %1$s is the sign (-or empty), %2$d number of hours, %3$d number of minutes
            return sprintf(__('%1$s%2$d h %3$d min'), $sign, $units['hour'], $units['minute']);
        }

        if ($units['minute'] > 0) {
            if ($display_sec) {
                //TRANS:  %1$s is the sign (-or empty), %2$d number of minutes,  %3$d number of seconds
                return sprintf(
                    __('%1$s%2$d h %3$d min'),
                    $sign,
                    $units['minute'],
                    $units['second']
                );
            }
            //TRANS: %1$s is the sign (-or empty), %2$d number of minutes
            return sprintf(
                _n('%1$s%2$d min', '%1$s%2$d min', $units['minute']),
                $sign,
                $units['minute']
            );
        }

        if ($display_sec) {
            //TRANS:  %1$s is the sign (-or empty), %2$d number of seconds
            return sprintf(
                _n('%1$s%2$s sec', '%1$s%2$s sec', $units['second']),
                $sign,
                $units['second']
            );
        }
        return '';
    }
}