<?php

/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

//use Glpi\Application\View\TemplateRenderer;
class PluginDlteamsTrainingCertification extends CommonDropdown
    implements PluginDlteamsExportableInterface
{
    static $rightname = 'plugin_dlteams_trainingcertification';
    public $dohistory = true;
    protected $usenotepad = true;

    static function getTypeName($nb = 0) {
        return _n("Training Certification", "Training Certifications", $nb, 'dlteams');
    }

    public function showTabsContent($options = [])
    {
        parent::showTabsContent($options); // TODO: Change the autogenerated stub
    }

    function showForm($id, $options = [])
    {
        global $CFG_GLPI;

        $this->initForm($id, $options);
        $this->showFormHeader($options);

        echo "<table, th, td width='60%'>";
        echo "<tr>";
        echo "<input type='hidden' name='deliverable_id' value='".$id."'>";
        echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "<td width='15%' style='text-align:right' >". __("Nom", 'dlteams') . "</td>";
        echo "<td>";

        $name = Html::cleanInputText($this->fields['name']);
        echo "<input type='text' style='width:98%' name='name' required value='" . $name. "'>" . "</td>";
        echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "</tr>";

        /*		switch ($id->getType()) {
                    case 'ProjectTask':
                        self::showForProjectTask($id);
                        break;

                    case 'Ticket':
                        self::showForTicket($id);
                        break;
                }
                return true;
        */
        //$ID = $projecttask->getField('id');
        //if (!$projecttask->can($ID, READ)) {
        //    return false;
        //}
        /*        $rand    = mt_rand();
                $entities_id = 30 ;
                    echo TemplateRenderer::getInstance()->render('components/form/link_existing_or_new.html.twig', [
                        'rand' => $rand,
                        'link_itemtype' => __CLASS__,
                        'source_itemtype' => ProjectTask::class,
                        'source_items_id' => $id,
                        'target_itemtype' => PluginDlteamsDeliverable::class,
                        'dropdown_options' => [
                            'entity'      => $entities_id->getEntityID(),
                            'entity_sons' => $entities_id->isRecursive(),
                            'used'        => $used,
                            'displaywith' => ['id'],
                            'condition'   => $condition
                        ],
                        'create_link' => Session::haveRight(PluginDlteamsDeliverable::$rightname, CREATE)
                    ]);
        */
        $entities_id = 30 ;
//        echo "<tr>";
//        echo "<td width='15%' style='text-align:right'>". " " . "</td>";
//        echo "<td width='15%' div style='text-align:right'>". __("Rubrique projet", 'dlteams') . "</div></td>";
//        echo "<td>";
//        ProjectTask::dropdown([
//            'name' 		=> 'projecttasks_id',
//            //'entity' 	=> $entities_id->getEntityID(),
//            //'entity_sons' => $entities_id->isRecursive(),
//            'value' 	=> $this->fields['projecttasks_id']
//        ]);
//        echo "</td></tr>";

        echo "<tr>";
        echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "<td width='15%' style='text-align:right'>" . __("Content", 'dlteams') . "</td>";
        echo "<td>";
        $content = Html::cleanInputText($this->fields['content']);
        echo "<textarea style='width: 98%;' name='content' rows='4'>" . $content . "</textarea>";
        echo "</td></tr>";

        echo "<tr>";
        echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "<td width='15%' style='text-align:right'>" . __("Comments") . "</td>";
        echo "<td>";
        $comment = Html::cleanInputText($this->fields['comment']);
        echo "<textarea style='width: 98%;' name='comment' rows='4'>" . $comment . "</textarea>";
        echo "</td></tr>";
        echo "</table>";

        $this->showFormButtons($options);
        Html::requireJs('tinymce');

        //$options['colspan'] = 2;
        //$this->showDates($options);
    }

    function showFormqqq($id, $options = [])
    {

        global $CFG_GLPI;

        $this->initForm($id, $options);
        $this->showFormHeader($options);


        echo "<tr class='tab_bg_1'>";
        echo "<td>" . __('Name') . "</td>";
        echo "</tr><td>";

        echo "<tr>";
        echo "<td>";

        echo "</td>";
        echo "</tr>";

        echo "<td rowspan='1'>" . __('Comments') . "</td>";
        $cols = 100;
        $rows = 60;
        echo "<td rowspan='1'>
               <textarea cols='45' rows='2' name='comment' id='field_name' >" . $this->fields["comment"];
        echo "</textarea></td>";


        echo "</tr>\n";
        echo "<tr>";
        echo "<td colspan='2'>";
        echo __('Content');
        echo "<br/>";
        echo "<br/>";
        Html::textarea(['name' => 'content',
            'value' => "", //\Glpi\RichText\RichText::getSafeHtml($this->fields['content'], true),
            'enable_fileupload' => false,
            'enable_richtext' => true,
            'cols' => $cols,
            'rows' => $rows
        ]);
        echo "</td>";
        echo "</tr>";

        return true;
    }

    function showDates($options = []) {

        $isNewID = ((isset($options['withtemplate']) && ($options['withtemplate'] == 2))
            || $this->isNewID($this->getID()));

        if ($isNewID) {
            return true;
        }

        $date_creation_exists = ($this->getField('date_creation') != NOT_AVAILABLE);
        $date_mod_exists      = ($this->getField('date_mod') != NOT_AVAILABLE);

        $colspan = $options['colspan'];
        if ((!isset($options['withtemplate']) || ($options['withtemplate'] == 0))
            && !empty($this->fields['template_name'])) {
            $colspan = 1;
        }

        echo "<tr class='tab_bg_1 footerRow'>";
        //Display when it's not a new asset being created
        if ($date_creation_exists
            && $this->getID() > 0
            && (!isset($options['withtemplate']) || $options['withtemplate'] == 0 || $options['withtemplate'] == NULL)) {
            echo "<th colspan='$colspan'>";
            printf(__('Created on %s'), Html::convDateTime($this->fields["date_creation"]), " ;");
            echo "</th>";
        } else if (!isset($options['withtemplate']) || $options['withtemplate'] == 0 || !$date_creation_exists) {
            echo "<th colspan='$colspan'>";
            echo "</th>";
        }

        if (isset($options['withtemplate']) && $options['withtemplate']) {
            echo "<th colspan='$colspan'>";
            //TRANS: %s is the datetime of insertion
            printf(__('Created on %s'), Html::convDateTime($_SESSION["glpi_currenttime"]));
            echo "</th>";
        }
        echo "  -  ";
        if ($date_mod_exists) {
            echo "<th colspan='$colspan'>";
            //TRANS: %s is the datetime of update
            printf(__('Last update on %s'), Html::convDateTime($this->fields["date_mod"]));
            echo "</th>";
        } else {
            echo "<th colspan='$colspan'>";
            echo "</th>";
        }

        if ((!isset($options['withtemplate']) || ($options['withtemplate'] == 0))
            && !empty($this->fields['template_name'])) {
            echo "<th colspan='" . ($colspan * 2) . "'>";
            printf(__('Created from the template %s'), $this->fields['template_name']);
            echo "</th>";
        }

        echo "</tr>";
    }

    function rawSearchOptions()
    {

        $tab = [];

        $tab[] = [
            'id' => 'common',
            'name' => __("Characteristics")
        ];

        $tab[] = [
            'id' => '1',
            'table' => $this->getTable(),
            'field' => 'name',
            'name' => __("Name"),
            'datatype' => 'itemlink',
            'massiveaction' => false,
            'autocomplete' => true,
        ];

        $tab[] = [
            'id' => '2',
            'table' => $this->getTable(),
            'field' => 'id',
            'name' => __("ID"),
            'massiveaction' => false,
            'datatype' => 'number',
        ];

//        $tab[] = [
//            'id' => '3',
//            'table' => 'glpi_projecttasks',
//            'field' => 'name',
//            'name' => __("Rubrique Projet"),
//            'datatype' => 'dropdown',
//            'toview' => true,
//            'massiveaction' => true,
//        ];

        $tab[] = [
            'id' => '4',
            'table' => $this->getTable(),
            'field' => 'content',
            'name' => __("Content"),
            'datatype' => 'text',
            'toview' => true,
            'massiveaction' => true,
        ];

        $tab[] = [
            'id' => '5',
            'table' => $this->getTable(),
            'field' => 'comment',
            'name' => __("Comments"),
            'datatype' => 'text',
            'toview' => true,
            'massiveaction' => true,
        ];

        if ($this->isEntityAssign()) {
            $tab[] = [
                'id' => '6',
                'table' => 'glpi_entities',
                'field' => 'completename',
                'name' => __("Entity"),
                'massiveaction' => true,
                'datatype' => 'dropdown',
            ];
        }

        $tab[] = [
            'id' => '7',
            'table' => $this->getTable(),
            'field' => 'is_recursive',
            'name' => __("Child entities"),
            'massiveaction' => false,
            'datatype' => 'bool',
        ];

        $tab[] = [
            'id' => '8',
            'table' => $this->getTable(),
            'field' => 'date_creation',
            'name' => __("Creation date"),
            'massiveaction' => false,
            'datatype' => 'text',
        ];

        $tab[] = [
            'id' => '9',
            'table' => $this->getTable(),
            'field' => 'date_mod',
            'name' => __("Last update"),
            'massiveaction' => false,
            'datatype' => 'text',
        ];

        return $tab;
    }

    public function defineTabs($options = [])
    {
        $ong = [];
        $ong = array();


        $this->addDefaultFormTab($ong)
//            ->addStandardTab(PluginDlteamsDeliverable_Section::class, $ong, $options)
            ->addStandardTab('PluginDlteamsPublish', $ong, $options)
//            ->addStandardTab(PluginDlteamsDeliverableNotification::class, $ong, $options)
            ->addStandardTab('PluginDlteamsObject_document', $ong, $options)
            ->addStandardTab('ManualLink', $ong, $options)
//            ->addStandardTab('PluginDlteamsObject_allitem', $ong, $options)
            ->addStandardTab('Ticket', $ong, $options)
            ->addStandardTab('KnowbaseItem_Item', $ong, $options)
            ->addImpactTab($ong, $options)
            ->addStandardTab('Notepad', $ong, $options)
            ->addStandardTab('Log', $ong, $options);
        return $ong;
    }

//    public function getForbiddenStandardMassiveAction()
//    {
//        $forbidden = parent::getForbiddenStandardMassiveAction();
//        $forbidden[] = 'Infocom:activate';
//        $forbidden[] = 'MassiveAction:add_transfer_list';
//        $forbidden[] = 'Document_Item:add';
//        $forbidden[] = 'Contract_Item:add';
//        $forbidden[] = 'MassiveAction:amend_comment';
//        $forbidden[] = 'MassiveAction:add_note';
//        $forbidden[] = 'PluginDlteamsDeliverable:copyTo';
//        return $forbidden;
//    }

    function exportToDB($subItems = [])
    {
        if ($this->isNewItem()) {
            return false;
        }

        $export = $this->fields;
        return $export;
    }

    public static function importToDB(PluginDlteamsLinker $linker, $input = [], $containerId = 0, $subItems = [])
    {
        $item = new self();
        $originalId = $input['id'];
        unset($input['id']);
        $input['entities_id'] = $_POST['entities_id'];;
        $input['comment'] = str_replace(['\'', '"'], "", $input['comment']);
        $input['name'] = str_replace(['\'', '"'], "", $input['name']);
        $input['content'] = str_replace(['\'', '"'], "", $input['content']);
        $itemId = $item->add($input);
        if ($itemId === false) {
            $typeName = strtolower(self::getTypeName());
            throw new ImportFailureException(sprintf(__('failed to copy the %1$s record', 'dlteams'), $input['name']));
        }
        return $itemId;
    }

    public function deleteObsoleteItems(CommonDBTM $container, array $exclude)
    {
    }

    public static function showMassiveActionsSubForm(MassiveAction $ma)
    {
//        var_dump("jjsl");
//        die();
        switch ($ma->getAction()) {
            case 'copyTo':
               //                $values = [];
//                foreach ($_SESSION["glpiactiveentities"] ?? [] as $key => $entities_id) {
//                    $entity = new Entity();
//                    $entity->getFromDB($entities_id);
//                    $values[$key] = $entity->fields["completename"];
//                }
                Entity::dropdown(['name' => 'entities_id']);
                echo '<br /><br />' . Html::submit(_x('button', 'Post'), ['name' => 'massiveaction']);
                return true;
        }
        return parent::showMassiveActionsSubForm($ma);
    }

    static function processMassiveActionsForOneItemtype(MassiveAction $ma, CommonDBTM $item, array $ids)
    {
        switch ($ma->getAction()) {
            case 'copyTo':
                if ($item->getType() == 'PluginDlteamsDeliverable') {
                    foreach ($ids as $id) {
                        if ($item->getFromDB($id)) {
                            if ($item->copy1($ma->POST['entities_id'], $id, $item)) {
                                Session::addMessageAfterRedirect(sprintf(__('Record copied: %s', 'dlteams'), $item->getName()));
                                $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_OK);
                            }
                        } else {
                            // Example of ko count
                            $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_KO);
                        }
                    }
                }
                return;
        }
        parent::processMassiveActionsForOneItemtype($ma, $item, $ids);
    }

    public function copy1($entity, $id, $item)
    {
        global $DB;
        $dbu = new DbUtils();
        $name = addslashes(str_replace('"', '', $item->fields['name']));
        $entities_ori = $item->fields['entities_id'];
        $id_ori = $item->fields['id'];
        $nb = $dbu->countElementsInTable(static::getTable(), ['name' => $name, 'entities_id' => $entity]);
        //var_dump($name, $entities_ori, $id_ori, $entity, $nb); die ;
// code original
        if ($nb <= 0) {
            /*            // var_dump($id_ori);
                        $DB->request("INSERT INTO " . static::getTable() . " (is_deleted, entities_id, is_recursive, name, content, comment, date_mod, date_creation)
                            SELECT is_deleted, '$entity', is_recursive, '$name', content, comment, date_mod, date_creation FROM " . static::getTable() . "
                            WHERE id='$id_ori'");
                        //get Id of copy record
                        $reqC = $DB->request("SELECT id FROM glpi_plugin_dlteams_deliverables WHERE name = '$name' AND entities_id = '$entity'");
                        foreach ($reqC as $id => $row) {
                            $idRecord = $row['id']; //get id of copied record
                            //var_dump($idRecord);
                            echo "<br/>";
                        }
                        // var_dump($id_ori); //get Id of copy record
            */

            /* Nouveau code */
            // STEP 1 : on ajoute les oid
            $query = "ALTER TABLE `glpi_plugin_dlteams_deliverables` ADD IF NOT EXISTS `oid` INT UNSIGNED NOT NULL DEFAULT '0'";
            $DB->queryOrDie($query, $DB->error());
            $query = "ALTER TABLE `glpi_plugin_dlteams_deliverables_sections` ADD IF NOT EXISTS `oid` INT UNSIGNED NOT NULL DEFAULT '0', ADD IF NOT EXISTS `deliverables_oid` INT UNSIGNED NOT NULL DEFAULT '0'";
            $DB->queryOrDie($query, $DB->error());
            $query = "ALTER TABLE `glpi_plugin_dlteams_deliverables_contents` ADD IF NOT EXISTS `oid` INT UNSIGNED NOT NULL DEFAULT '0', ADD IF NOT EXISTS `deliverable_sections_oid` INT UNSIGNED NOT NULL DEFAULT '0'";
            $DB->queryOrDie($query, $DB->error());
            $reqC = $DB->request("SELECT id FROM glpi_plugin_dlteams_deliverables WHERE name = '$name' AND entities_id = '$entity'");
            //var_dump($name, $entities_ori, $id_ori, $entity, $nb); die ;
            // var_dump ($name, $entity); die;
            //foreach ($reqC as $id => $row) {
            //$idRecord = $row['id']; //get id of copied record

            // STEP 2 : creation des new deliverable
            $query = "INSERT INTO `glpi_plugin_dlteams_deliverables` (`oid`, `entities_id`, `name`, `content`, `comment`, `document_name`, `document_title`, `document_content`, `document_comment`, `date_creation`, `date_mod`)
				SELECT `id`, '$entity', `name`, `content`, `comment`, `document_name`, `document_title`, `document_content`, `document_comment`, `date_creation`, CURDATE()
				FROM `glpi_plugin_dlteams_deliverables`
				WHERE `id` = '$id_ori'";
            $DB->queryOrDie($query, $DB->error());
            // creation new sections avec deliverable_id vide
            $query = "INSERT INTO `glpi_plugin_dlteams_deliverables_sections` (`oid`, `deliverables_oid`, `name`, `tab_name`, `comment`, `content`, `timeline_position`, `date_creation`, `date_mod`)
			SELECT T2.`id`, T2.`deliverables_id`, T2.`name`, T2.`tab_name`, T2.`comment`, T2.`content`, T2.`timeline_position`, T2.`date_creation`, CURDATE()
			FROM `glpi_plugin_dlteams_deliverables_sections` AS T2
			WHERE T2.`deliverables_id` = '$id_ori'";
            $DB->queryOrDie($query, $DB->error());
            // creation new contents avec deliverable_sections_id vide
            $query = "INSERT INTO `glpi_plugin_dlteams_deliverables_contents` (`oid`, `deliverable_sections_oid`, `name`, `comment`, `content`, `timeline_position`, `date_creation`, `date_mod`)
				SELECT T3.`id`, T3.`deliverable_sections_id`, T3.`name`, T3.`comment`, T3.`content`, T3.`timeline_position`, T3.`date_creation`, CURDATE()
				FROM `glpi_plugin_dlteams_deliverables_contents` AS T3
				LEFT JOIN `glpi_plugin_dlteams_deliverables_sections` AS T2
				ON T3.`deliverable_sections_id` = T2.`id` 
				WHERE T2.`deliverables_id` = '$id_ori'";
            $DB->queryOrDie($query, $DB->error());
            // STEP 3 : MAJ des deliverables_id
            $query = "UPDATE `glpi_plugin_dlteams_deliverables_sections` AS T2
			LEFT JOIN `glpi_plugin_dlteams_deliverables` AS T1
			ON T2.`deliverables_oid` = T1.`oid`
				SET T2.`deliverables_id` = T1.`id`
				WHERE T2.`deliverables_oid` <> 0";
            $DB->queryOrDie($query, $DB->error());
            //STEP 3 : MAJ des deliverable_sections_id
            $query = "UPDATE `glpi_plugin_dlteams_deliverables_contents` AS T3
			LEFT JOIN `glpi_plugin_dlteams_deliverables_sections` AS T2 
			ON T3.`deliverable_sections_oid` = T2.`oid`
				SET T3.`deliverable_sections_id` = T2.`id`
				WHERE T3.`deliverable_sections_id` = 0";
            $DB->queryOrDie($query, $DB->error());
            //}
            // STEP 4 : effacement des oid
            $query = "ALTER TABLE `glpi_plugin_dlteams_deliverables` DROP IF EXISTS `oid`";
            $DB->queryOrDie($query, $DB->error());
            $query = "ALTER TABLE `glpi_plugin_dlteams_deliverables_sections` DROP IF EXISTS `oid`, DROP IF EXISTS `deliverables_oid`";
            $DB->queryOrDie($query, $DB->error());
            $query = "ALTER TABLE `glpi_plugin_dlteams_deliverables_contents` DROP IF EXISTS `oid`, DROP IF EXISTS `deliverable_sections_oid`";
            $DB->queryOrDie($query, $DB->error());


            /**copy the document**/
            $req = $DB->request("SELECT * FROM glpi_documents_items WHERE items_id='$id_ori' AND itemtype='PluginDlteamsDeliverable' and entities_id='$entities_ori'");
            //var_dump(count($req));
            if (count($req)) {
                foreach ($req as $id => $row) {
                    $val0 = $row['documents_id']; //get documents_id
                    //var_dump($val0);
                    echo "<br/>";
                    /**insert in document table***/
                    $DB->request("INSERT INTO glpi_documents (entities_id,is_recursive,name,filename,filepath,documentcategories_id,mime,date_mod,comment,is_deleted,link,users_id,tickets_id,sha1sum,is_blacklisted,tag,date_creation) SELECT '$entity',is_recursive,name,filename,filepath,documentcategories_id,mime,date_mod,comment,is_deleted,link,users_id,tickets_id,sha1sum,is_blacklisted,tag,date_creation FROM glpi_documents WHERE id='$val0' and entities_id='$entities_ori'");
                    /**get ID of record copied***/
                    $reqD = $DB->request("SELECT * FROM glpi_documents WHERE id='$val0'");
                    foreach ($reqD as $id => $row) {
                        $val1 = addslashes(str_replace('"', '', $row['name']));
                        //var_dump($val1);
                        echo "<br/>";
                    }
                    /**get ID of record copied***/
                    $reqF = $DB->request("SELECT * FROM glpi_documents WHERE name='$val1' and entities_id='$entity'");
                    foreach ($reqF as $id => $row) {
                        $val2 = $row['id'];
                        //var_dump($val2);
                        echo "<br/>";
                    }
                    /**insert in document_items table***/
                    $DB->request("INSERT INTO glpi_documents_items (documents_id,items_id,itemtype,entities_id) SELECT '$val2','$idRecord','PluginDlteamsDeliverable','$entity' FROM glpi_documents_items WHERE documents_id='$val0' AND items_id='$id_ori' and itemtype='PluginDlteamsDeliverable' and entities_id='$entities_ori'");
                    /**insert in document_items table***/
                }
            } else {
            }
            /**copy the document**/
            return true;
        } else {
            return false;
        }
    }
}

