<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */


$querys = [
    // Ajout du champ category pour les personnes concernées
    "ALTER TABLE `glpi_plugin_dlteams_concernedpersons`
        ADD IF NOT EXISTS `category` VARCHAR(50) DEFAULT 'physique' 
        AFTER `name`",
	/* erreur de table ca n'est pas protectivemeasures_items
    "ALTER TABLE `glpi_plugin_dlteams_protectivemeasures_items` ADD IF NOT EXISTS `r_nbrpolicieform` INT UNSIGNED DEFAULT NULL COMMENT 'nombre de jeux de données'",
    "ALTER TABLE `glpi_plugin_dlteams_protectivemeasures_items` ADD IF NOT EXISTS `r_nbrdatacatalog` INT UNSIGNED DEFAULT NULL COMMENT 'nombre de catalogues' AFTER `r_nbrpolicieform`",
    "ALTER TABLE `glpi_plugin_dlteams_protectivemeasures_items` ADD IF NOT EXISTS `r_nbrstorage` INT UNSIGNED DEFAULT NULL COMMENT 'nombre de stockage' AFTER `r_nbrdatacatalog`",
    "ALTER TABLE `glpi_plugin_dlteams_protectivemeasures_items` ADD IF NOT EXISTS `r_nbrrecord` INT UNSIGNED DEFAULT NULL COMMENT 'nombre de traitement' AFTER `r_nbrstorage`",*/

//    update de conversation selon les groupements deja effectués
    "UPDATE glpi_itilfollowups 
    SET conversation = id 
    WHERE parent_comment_id IS NULL;",

"UPDATE glpi_itilfollowups f1
SET conversation = f1.parent_comment_id
WHERE f1.parent_comment_id IS NOT NULL 
AND EXISTS (
    SELECT 1 FROM glpi_itilfollowups f2 
    WHERE f2.id = f1.parent_comment_id 
    AND f2.parent_comment_id IS NULL
);",

"UPDATE glpi_itilfollowups f1
SET conversation = (
    SELECT f2.conversation 
    FROM glpi_itilfollowups f2 
    WHERE f2.id = f1.parent_comment_id
)
WHERE f1.parent_comment_id IS NOT NULL 
AND f1.conversation IS NULL;",

"UPDATE glpi_itilfollowups f1
SET conversation = (
    SELECT f2.conversation 
    FROM glpi_itilfollowups f2 
    WHERE f2.id = f1.parent_comment_id
)
WHERE f1.parent_comment_id IS NOT NULL 
AND f1.conversation IS NULL;",

"UPDATE glpi_itilfollowups 
SET conversation = 0 
WHERE conversation IS NULL;",
    "ALTER TABLE `glpi_plugin_dlteams_policieforms`
        ADD IF NOT EXISTS `setofdocuments` tinyint NOT NULL DEFAULT '0' 
        AFTER `name`",
    "
    CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_concernedpersoncategories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `comment` mediumtext DEFAULT NULL,
  `entities_id` int unsigned NOT NULL DEFAULT 0,
  `is_recursive` tinyint(1) NOT NULL DEFAULT 1,
  `date_creation` timestamp NULL DEFAULT NULL,
  `users_id_creator` int unsigned DEFAULT NULL,
  `date_mod` timestamp NULL DEFAULT NULL,
  `users_id_lastupdater` int unsigned DEFAULT NULL,
   PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='PluginDlteamsConcernedPersonCategory';",
    "CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_concernedpersoncategories_items` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `concernedpersoncategories_id` int UNSIGNED NOT NULL DEFAULT 0,
  `itemtype` varchar(255) NOT NULL,
  `items_id` int UNSIGNED NOT NULL DEFAULT 0,
  `itemtype1` varchar(255) DEFAULT NULL,
  `items_id1` int unsigned NOT NULL DEFAULT 0,
  `comment` varchar(255) DEFAULT NULL,
  `date_creation` timestamp NULL,
  `date_mod` timestamp NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",
    "ALTER TABLE `glpi_plugin_dlteams_datacatalogs`
    DROP COLUMN IF EXISTS `is_directoryservice`;",
    "ALTER TABLE `glpi_plugin_dlteams_policieformcategories`
	ADD IF NOT EXISTS `number` INT UNSIGNED DEFAULT 1 AFTER `name`,
	ADD IF NOT EXISTS `decimalnumber` INT UNSIGNED DEFAULT 1 AFTER `number`,
	ADD IF NOT EXISTS `completenumber` DECIMAL (10,2) AFTER `decimalnumber`,
	ADD IF NOT EXISTS `content` TEXT NOT NULL AFTER `name`;",
    "CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_tickettasks_items` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `tickettasks_id` int UNSIGNED NOT NULL DEFAULT 0,
  `itemtype` varchar(255) NOT NULL,
  `items_id` int UNSIGNED NOT NULL DEFAULT 0,
  `itemtype1` varchar(255) DEFAULT NULL,
  `items_id1` int unsigned NOT NULL DEFAULT 0,
  `comment` varchar(255) DEFAULT NULL,
  `date_creation` timestamp NULL,
  `date_mod` timestamp NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",
//    "ALTER TABLE `glpi_plugin_dlteams_policieforms` ADD IF NOT EXISTS `p_nbrrecord` INT UNSIGNED DEFAULT NULL COMMENT 'nombre de jeux de données' AFTER `r_pianeedanddone`",


//A integrer a update-26.sql
    // fork dlteams: Ajout des colonnes pour les appliances
    "ALTER TABLE `glpi_appliances`
        ADD IF NOT EXISTS `saas_url` VARCHAR(255) DEFAULT NULL 
        COMMENT 'URL pour accès SaaS'",
    
    "ALTER TABLE `glpi_appliances`
        ADD IF NOT EXISTS `manuallinks_id` INT UNSIGNED DEFAULT NULL 
        COMMENT 'Lien vers ManualLink'",
];

$i = 1;
global $DB;
foreach ($querys as $query) {
    $result = $DB->query($query) or die("Erreur" . $DB->error());
    if ($DB->error) {
        try {
            // Log l'erreur mais continue
            error_log("Erreur SQL update-26.php: " . $DB->error . " - Query: " . $query);
        } catch (Exception $e) {
            echo "Error No: " . $e->getCode() . " - " . $e->getMessage() . "<br >";
            echo nl2br($e->getTraceAsString());
        }
    }
    $i++;
}

