-- Ajout du champ category pour les personnes concernées
ALTER TABLE `glpi_plugin_dlteams_concernedpersons`
    ADD IF NOT EXISTS `category` VARCHAR(50) DEFAULT 'physique' 
    AFTER `name`;

-- update de conversation selon les groupements deja effectués
UPDATE `glpi_itilfollowups` 
SET `conversation` = `id` 
WHERE `parent_comment_id` IS NULL;

UPDATE `glpi_itilfollowups` f1
SET `conversation` = f1.parent_comment_id
WHERE f1.parent_comment_id IS NOT NULL 
AND EXISTS (
    SELECT 1 FROM `glpi_itilfollowups` f2 
    WHERE f2.id = f1.parent_comment_id 
    AND f2.parent_comment_id IS NULL
);

UPDATE `glpi_itilfollowups` f1
SET `conversation` = (
    SELECT f2.conversation 
    FROM `glpi_itilfollowups` f2 
    WHERE f2.id = f1.parent_comment_id
)
WHERE f1.parent_comment_id IS NOT NULL 
AND f1.conversation IS NULL;

UPDATE `glpi_itilfollowups` f1
SET `conversation` = (
    SELECT f2.conversation 
    FROM `glpi_itilfollowups` f2 
    WHERE f2.id = f1.parent_comment_id
)
WHERE f1.parent_comment_id IS NOT NULL 
AND f1.conversation IS NULL;

UPDATE `glpi_itilfollowups` 
SET `conversation` = 0 
WHERE `conversation` IS NULL;

ALTER TABLE `glpi_plugin_dlteams_policieforms`
    ADD IF NOT EXISTS `setofdocuments` tinyint NULL DEFAULT NULL AFTER `name`;

CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_concernedpersoncategories` (
    `id` int unsigned NOT NULL AUTO_INCREMENT,
    `name` varchar(255) DEFAULT NULL,
    `comment` mediumtext DEFAULT NULL,
    `entities_id` int unsigned NOT NULL DEFAULT 0,
    `is_recursive` tinyint(1) NOT NULL DEFAULT 1,
    `date_creation` timestamp NULL DEFAULT NULL,
    `users_id_creator` int unsigned DEFAULT NULL,
    `date_mod` timestamp NULL DEFAULT NULL,
    `users_id_lastupdater` int unsigned DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='PluginDlteamsConcernedPersonCategory';

CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_concernedpersoncategories_items` (
    `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
    `concernedpersoncategories_id` int UNSIGNED NOT NULL DEFAULT 0,
    `itemtype` varchar(255) NOT NULL,
    `items_id` int UNSIGNED NOT NULL DEFAULT 0,
    `itemtype1` varchar(255) DEFAULT NULL,
    `items_id1` int unsigned NOT NULL DEFAULT 0,
    `comment` varchar(255) DEFAULT NULL,
    `date_creation` timestamp NULL,
    `date_mod` timestamp NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

ALTER TABLE `glpi_plugin_dlteams_datacatalogs`
    DROP COLUMN IF EXISTS `is_directoryservice`;

ALTER TABLE `glpi_plugin_dlteams_policieformcategories`
    ADD IF NOT EXISTS `number` INT UNSIGNED DEFAULT 1 AFTER `name`,
    ADD IF NOT EXISTS `decimalnumber` INT UNSIGNED DEFAULT 1 AFTER `number`,
    ADD IF NOT EXISTS `completenumber` DECIMAL (10,2) AFTER `decimalnumber`,
    ADD IF NOT EXISTS `content` TEXT NOT NULL AFTER `name`;

CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_tickettasks_items` (
    `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
    `tickettasks_id` int UNSIGNED NOT NULL DEFAULT 0,
    `itemtype` varchar(255) NOT NULL,
    `items_id` int UNSIGNED NOT NULL DEFAULT 0,
    `itemtype1` varchar(255) DEFAULT NULL,
    `items_id1` int unsigned NOT NULL DEFAULT 0,
    `comment` varchar(255) DEFAULT NULL,
    `date_creation` timestamp NULL,
    `date_mod` timestamp NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


