<?php

/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include("../../../inc/includes.php");

$rand = mt_rand();
$linkid = $_POST["linkid"];
global $CFG_GLPI;


echo "<form name='ticketitem_form$rand' id='ticketitem_form$rand' method='post'
            action='" . Toolbox::getItemTypeFormURL(PluginDlteamsPolicieForm::class) . "'>";
echo "<input type='hidden' name='linkid' value='" . $linkid . "' />";
$policieform_item = new PluginDlteamsPolicieForm_Item();
$policieform_item->getFromDB($linkid);

$policieform = new PluginDlteamsPolicieForm();
$policieform->getFromDB($policieform_item->fields["policieforms_id"]);
echo "<div style='display: flex; flex-direction: column; gap: 0.5rem;'>";
echo "<div style='display: flex; flex-direction: row; gap: 1rem;'>";
echo "<div style='display: flex; flex-direction: column; gap: 0.5rem;'>";
echo "<label>";
echo _n("People category", "People categories", 0, 'dlteams');
echo "</label>";
PluginDlteamsConcernedPerson::dropdown([
    //'addicon'  => PluginDlteamsConcernedPerson::canCreate(),
    'name' => "items_id",
    'rand' => $rand,
    'width' => '300px',
    'value' => $_SESSION["dlteams_pf_recent_concernedperson"]??$policieform_item->fields["items_id"]??"",
    'url'   => $CFG_GLPI['root_doc'] . "/marketplace/dlteams/ajax/getDropdownValue.php"
]);
echo "</div>";

//echo "<div style='display: flex; flex-direction: column; gap: 1rem;'>";
echo "<div style='display: flex; flex-direction: column; gap: 0.5rem;'>";
echo "<label>";
echo _n("People category", "People categories", 0, 'dlteams');
echo "</label>";

global $DB;
$iterator = $DB->request(PluginDlteamsPolicieForm_PersonalAndDataCategory::getRequest($policieform));
$number = count($iterator);

$items_list = [];
$used = [];
foreach ($iterator as $id => $data) {
    //while ($data = $iterator->next()) {
    $items_list[$data['linkid']] = $data;
    $used[$data['linkid']] = $data['linkid'];
}


$used = [];
if (!empty($_SESSION['dlteams_pf_recent_concernedperson'])) {
    $filtered = array_filter($items_list, function ($item) {
        return $item['items_id'] == $_SESSION['dlteams_pf_recent_concernedperson'];
    });
    $used = array_column($filtered, 'items_id1');
}

PluginDlteamsProcessedData::dropdown([
    'name' => 'items_id1',
    'used' => $used,
    'value' => $policieform_item->fields["items_id1"],
    'width' => '300px',
    'url'   => $CFG_GLPI['root_doc'] . "/marketplace/dlteams/ajax/getDropdownValue.php"
]);
echo "</div>";
echo "</div>";

echo "<div style='flex: 0.5; min-width: 150px; display: block'>";
echo "<label style='display: block; margin-bottom: 5px;'>" . __("Mandatory", 'dlteams') . "</label>";
Dropdown::showYesNo("mandatory", $policieform_item->fields["mandatory"]);
echo "</div>";


echo "<div style='display: flex; flex-direction: column; gap: 0.5rem;'>";
echo "<label>";
echo __("Commentaires", 'dlteams');
echo "</label>";
Html::textarea(['name'            => 'comment',
    'value'           => $policieform_item->fields["comment"],
    'class'           => 'storage_comment1',
    'cols'            => 60,
    'rows'            => 3,
    'enable_richtext' => false]);
echo "</div>";

echo "<div style='width: 100%; align-items: center; justify-content: center; display: flex'>";
echo "<input type='submit' style='width: fit-content' class='submit' name='update_policieforms_item_personal_and_datacategory' value='" . __("Mettre à jour", 'dlteams') . "' />";
echo "&nbsp;<input type='submit' style='width: fit-content' class='btn btn-ghost-danger' name='delete_policieforms_item_personal_and_datacategory' value='" . __("Delete permanently") . "' />";
echo "</div>";
Html::closeForm();
//$policieform_item->

echo "</div>";